/*
 * Decompiled with CFR 0.152.
 */
package com.isnetworks.ssh;

import com.isnetworks.ssh.FileBrowser;
import com.isnetworks.ssh.FileList;
import com.isnetworks.ssh.FileListItem;
import com.isnetworks.ssh.SSHException;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import mindbright.ssh.SSHMiscDialogs;
import mindbright.ssh.SSHSCPDialog;

public class FileDisplay
extends Panel {
    private FileBrowser mBrowser;
    private Button mChgDirButton;
    private Button mDeleteButton;
    private Panel mFileButtonsInnerPanel;
    private Panel mFileButtonsPanel;
    private Panel mFileHeaderPanel;
    private FileList mFileList;
    private Label mMachineDescriptionLabel;
    private Label mFileSystemLocationLabel;
    private Button mMkDirButton;
    private Button mRefreshButton;
    private Button mRenameButton;
    private Frame mOwnerFrame;
    private SSHSCPDialog mSCPDialog;

    public FileDisplay(Frame frame, String string, SSHSCPDialog sSHSCPDialog) {
        this.mOwnerFrame = frame;
        this.mSCPDialog = sSHSCPDialog;
        this.mMachineDescriptionLabel = new Label(string);
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.add("North", this.getFileHeaderPanel());
        this.add("Center", this.getFileList());
        this.add("South", this.getFileButtonsPanel());
    }

    private Panel getFileHeaderPanel() {
        if (this.mFileHeaderPanel == null) {
            this.mFileHeaderPanel = new Panel(new BorderLayout());
            this.mFileHeaderPanel.add("North", this.getMachineDescriptionLabel());
            this.mFileHeaderPanel.add("South", this.getFileSystemLocationLabel());
        }
        return this.mFileHeaderPanel;
    }

    private Label getMachineDescriptionLabel() {
        return this.mMachineDescriptionLabel;
    }

    private Label getFileSystemLocationLabel() {
        if (this.mFileSystemLocationLabel == null) {
            this.mFileSystemLocationLabel = new Label("");
        }
        return this.mFileSystemLocationLabel;
    }

    private Panel getFileButtonsPanel() {
        if (this.mFileButtonsPanel == null) {
            this.mFileButtonsPanel = new Panel(new BorderLayout());
            this.mFileButtonsPanel.add("North", this.getFileButtonsInnerPanel());
        }
        return this.mFileButtonsPanel;
    }

    private Panel getFileButtonsInnerPanel() {
        if (this.mFileButtonsInnerPanel == null) {
            this.mFileButtonsInnerPanel = new Panel(new GridLayout(1, 5));
            this.mFileButtonsInnerPanel.add(this.getChgDirButton());
            this.mFileButtonsInnerPanel.add(this.getMkDirButton());
            this.mFileButtonsInnerPanel.add(this.getRenameButton());
            this.mFileButtonsInnerPanel.add(this.getDeleteButton());
            this.mFileButtonsInnerPanel.add(this.getRefreshButton());
        }
        return this.mFileButtonsInnerPanel;
    }

    private Button getChgDirButton() {
        if (this.mChgDirButton == null) {
            this.mChgDirButton = new Button("ChgDir");
            this.mChgDirButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = SSHMiscDialogs.textfield("Change directory", "Directory", FileDisplay.this.mOwnerFrame, FileDisplay.this.getFileSystemLocationLabelText());
                    if (string != null) {
                        try {
                            FileDisplay.this.mBrowser.changeDirectory(string);
                        }
                        catch (SSHException sSHException) {
                            FileDisplay.this.mSCPDialog.logError(sSHException);
                        }
                    }
                }
            });
        }
        return this.mChgDirButton;
    }

    private Button getMkDirButton() {
        if (this.mMkDirButton == null) {
            this.mMkDirButton = new Button("MkDir");
            this.mMkDirButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = SSHMiscDialogs.textfield("Make directory relative to current path", "Directory name", FileDisplay.this.mOwnerFrame);
                    if (string != null) {
                        try {
                            FileDisplay.this.mBrowser.makeDirectory(string);
                        }
                        catch (SSHException sSHException) {
                            FileDisplay.this.mSCPDialog.logError(sSHException);
                        }
                    }
                }
            });
        }
        return this.mMkDirButton;
    }

    private Button getRenameButton() {
        if (this.mRenameButton == null) {
            this.mRenameButton = new Button("Rename");
            this.mRenameButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FileListItem fileListItem = FileDisplay.this.mFileList.getSelectedFileListItem();
                    String string = SSHMiscDialogs.textfield("Rename file", "New file name", FileDisplay.this.mOwnerFrame, fileListItem.getName());
                    if (string != null) {
                        try {
                            FileDisplay.this.mBrowser.rename(fileListItem, string);
                        }
                        catch (SSHException sSHException) {
                            FileDisplay.this.mSCPDialog.logError(sSHException);
                        }
                    }
                }
            });
        }
        return this.mRenameButton;
    }

    private Button getDeleteButton() {
        if (this.mDeleteButton == null) {
            this.mDeleteButton = new Button("Delete");
            this.mDeleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        FileDisplay.this.mBrowser.delete(FileDisplay.this.mFileList.getSelectedFileListItems());
                    }
                    catch (SSHException sSHException) {
                        FileDisplay.this.mSCPDialog.logError(sSHException);
                    }
                }
            });
        }
        return this.mDeleteButton;
    }

    private Button getRefreshButton() {
        if (this.mRefreshButton == null) {
            this.mRefreshButton = new Button("Refresh");
            this.mRefreshButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        FileDisplay.this.mBrowser.refresh();
                    }
                    catch (SSHException sSHException) {
                        FileDisplay.this.mSCPDialog.logError(sSHException);
                    }
                }
            });
        }
        return this.mRefreshButton;
    }

    private FileList getFileList() {
        if (this.mFileList == null) {
            this.mFileList = new FileList();
            this.mFileList.setFont(new Font("Monospaced", 0, 12));
            this.mFileList.setMultipleMode(true);
            this.mFileList.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        FileDisplay.this.mBrowser.fileDoubleClicked(FileDisplay.this.mFileList.getFileListItem(actionEvent.getActionCommand()));
                    }
                    catch (SSHException sSHException) {
                        FileDisplay.this.mSCPDialog.logError(sSHException);
                    }
                }
            });
            this.mFileList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    FileDisplay.this.enableButtons();
                }
            });
            this.mFileList.setBackground(Color.white);
        }
        return this.mFileList;
    }

    private void enableButtons() {
        this.mRenameButton.setEnabled(this.mFileList.getSelectionCount() == 1);
        this.mDeleteButton.setEnabled(this.mFileList.getSelectionCount() > 0);
    }

    public String getFileSystemLocationLabelText() {
        return this.getFileSystemLocationLabel().getText();
    }

    public void setFileSystemLocationLabelText(String string) {
        this.getFileSystemLocationLabel().setText(string);
    }

    public void setFileList(Vector vector, String string) {
        this.setFileSystemLocationLabelText(string);
        this.mFileList.setListItems(vector);
        this.enableButtons();
    }

    public void setFileBrowser(FileBrowser fileBrowser) {
        this.mBrowser = fileBrowser;
    }

    public FileListItem getSelectedFile() {
        return this.mFileList.getSelectedFileListItem();
    }

    public FileListItem[] getSelectedFiles() {
        return this.mFileList.getSelectedFileListItems();
    }
}

