/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mindbright.security.Cipher;
import mindbright.security.SecureRandom;
import mindbright.ssh.SSH;
import mindbright.ssh.SSHDataOutputStream;
import mindbright.ssh.SSHPdu;
import mindbright.util.CRC32;

public final class SSHPduOutputStream
extends SSHDataOutputStream
implements SSHPdu {
    public static final int SSH_DEFAULT_PKT_LEN = 8192;
    public static int mtu = 8192;
    byte[] readFromRawData;
    int readFromOff;
    int readFromSize;
    public int type;
    public Cipher cipher;

    public static synchronized void setMTU(int n) {
        mtu = n;
    }

    SSHPduOutputStream(Cipher cipher) {
        super(null);
        this.cipher = cipher;
    }

    SSHPduOutputStream(int n, Cipher cipher) throws IOException {
        super(new PduByteArrayOutputStream(mtu));
        this.type = n;
        this.cipher = cipher;
        if (cipher != null) {
            PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
            SecureRandom secureRandom = SSH.secureRandom();
            secureRandom.nextPadBytes(pduByteArrayOutputStream.getBuf(), 8);
            pduByteArrayOutputStream.setCount(8);
        } else {
            int n2 = 0;
            while (n2 < 8) {
                this.write(0);
                ++n2;
            }
        }
        this.write(n);
    }

    public SSHPdu createPdu() throws IOException {
        SSHPduOutputStream sSHPduOutputStream = new SSHPduOutputStream(this.type, this.cipher);
        return sSHPduOutputStream;
    }

    public void readFrom(InputStream inputStream) throws IOException {
        if (this.type != 23 && this.type != 16) {
            throw new IOException("Trying to read raw data into non-data PDU");
        }
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        this.readFromRawData = pduByteArrayOutputStream.getBuf();
        this.readFromOff = pduByteArrayOutputStream.size() + 4;
        this.readFromSize = inputStream.read(this.readFromRawData, this.readFromOff, mtu - this.readFromOff);
        if (this.readFromSize == -1) {
            throw new IOException("EOF");
        }
        this.writeInt(this.readFromSize);
        pduByteArrayOutputStream.setCount(this.readFromOff + this.readFromSize);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        boolean bl = false;
        int n = pduByteArrayOutputStream.size();
        int n2 = (n + 4) % 8;
        int n3 = (int)CRC32.getValue(pduByteArrayOutputStream.getBuf(), n2, n - n2);
        int n4 = n + 4 - n2;
        this.writeInt(n3);
        byte[] byArray = pduByteArrayOutputStream.getBuf();
        if (this.cipher != null) {
            this.cipher.encrypt(byArray, n2, byArray, n2, n4);
        }
        int n5 = n4 - (8 - n2);
        outputStream.write(n5 >>> 24 & 0xFF);
        outputStream.write(n5 >>> 16 & 0xFF);
        outputStream.write(n5 >>> 8 & 0xFF);
        outputStream.write(n5 >>> 0 & 0xFF);
        outputStream.write(byArray, n2, n4);
        outputStream.flush();
    }

    public byte[] rawData() {
        return this.readFromRawData;
    }

    public void rawSetData(byte[] byArray) {
    }

    public int rawOffset() {
        return this.readFromOff;
    }

    public int rawSize() {
        byte[] byArray = this.readFromRawData;
        int n = this.readFromOff - 4;
        int n2 = byArray[n++] + 256 & 0xFF;
        int n3 = byArray[n++] + 256 & 0xFF;
        int n4 = byArray[n++] + 256 & 0xFF;
        int n5 = byArray[n] + 256 & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    public void rawAdjustSize(int n) {
        PduByteArrayOutputStream pduByteArrayOutputStream = (PduByteArrayOutputStream)this.out;
        pduByteArrayOutputStream.setCount(n);
    }

    static final class PduByteArrayOutputStream
    extends ByteArrayOutputStream {
        PduByteArrayOutputStream() {
        }

        PduByteArrayOutputStream(int n) {
            super(n);
        }

        PduByteArrayOutputStream(byte[] byArray) {
            this.buf = byArray;
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }

        public void setBuf(byte[] byArray) {
            this.buf = byArray;
        }

        public void setCount(int n) {
            this.count = n;
        }
    }
}

