/*
 * Decompiled with CFR 0.152.
 */
package mindbright.ssh;

import com.isnetworks.ssh.AbstractFileBrowser;
import com.isnetworks.ssh.FileDisplay;
import com.isnetworks.ssh.FileListItem;
import com.isnetworks.ssh.SSHException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import mindbright.security.Cipher;
import mindbright.ssh.SSHChannelController;
import mindbright.ssh.SSHClient;
import mindbright.ssh.SSHClientUserAdaptor;
import mindbright.ssh.SSHConsole;
import mindbright.ssh.SSHPropertyHandler;
import mindbright.ssh.SSHSCPDialog;
import mindbright.terminal.Terminal;

public class SSHRemoteFileBrowsingConsole
extends AbstractFileBrowser
implements SSHConsole {
    private SSHClient mClient;
    private String mOutput = "";
    private String mCurrentDirectory;
    private SSHSCPDialog mErrorLog;

    public SSHRemoteFileBrowsingConsole(FileDisplay fileDisplay, SSHPropertyHandler sSHPropertyHandler, SSHSCPDialog sSHSCPDialog) {
        super(fileDisplay, sSHPropertyHandler);
        this.mErrorLog = sSHSCPDialog;
    }

    public void initialize() throws SSHException {
        try {
            this.disconnect();
            this.mClient = new SSHClient(this.mPropertyHandler, new SSHClientUserAdaptor(this.mPropertyHandler.getSrvHost(), this.mPropertyHandler.getSrvPort()));
            this.mClient.setConsole(this);
            this.mClient.activateTunnels = false;
            this.mClient.bootSSH(false);
            this.refresh();
        }
        catch (IOException iOException) {
            throw new SSHException("Error when connecting with remote machine");
        }
    }

    public void disconnect() {
        if (this.mClient != null && this.mClient.isConnected()) {
            this.mClient.forcedDisconnect();
        }
    }

    public void refresh() throws SSHException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("echo ****START PWD****\n");
            stringBuffer.append("pwd\n");
            stringBuffer.append("echo ****END PWD****\n");
            stringBuffer.append("ls -A -L -p -1\n");
            stringBuffer.append("echo ****END LS****\n");
            this.mClient.stdinWriteString(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new SSHException("Error sending command to remote machine");
        }
    }

    public void makeDirectory(String string) throws SSHException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("mkdir \"");
            stringBuffer.append(string);
            stringBuffer.append("\"\n");
            this.mClient.stdinWriteString(stringBuffer.toString());
            this.refresh();
        }
        catch (IOException iOException) {
            throw new SSHException("Error sending command to remote machine");
        }
    }

    public void rename(FileListItem fileListItem, String string) throws SSHException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("mv \"");
            stringBuffer.append(fileListItem.getAbsolutePath());
            stringBuffer.append("\" \"");
            stringBuffer.append(fileListItem.getParent());
            stringBuffer.append(string);
            stringBuffer.append("\"\n");
            this.mClient.stdinWriteString(stringBuffer.toString());
            this.refresh();
        }
        catch (IOException iOException) {
            throw new SSHException("Error sending command to remote machine");
        }
    }

    public void changeDirectory(String string) throws SSHException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("cd \"");
            stringBuffer.append(string);
            stringBuffer.append("\"\n");
            this.mClient.stdinWriteString(stringBuffer.toString());
            this.refresh();
        }
        catch (IOException iOException) {
            throw new SSHException("Error sending command to remote machine");
        }
    }

    public void delete(FileListItem[] fileListItemArray) throws SSHException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < fileListItemArray.length) {
                if (fileListItemArray[n].isDirectory()) {
                    stringBuffer.append("rmdir \"");
                } else {
                    stringBuffer.append("rm -f \"");
                }
                stringBuffer.append(fileListItemArray[n].getAbsolutePath());
                stringBuffer.append("\"\n");
                ++n;
            }
            this.mClient.stdinWriteString(stringBuffer.toString());
            this.refresh();
        }
        catch (IOException iOException) {
            throw new SSHException("Error sending command to remote machine");
        }
    }

    public Terminal getTerminal() {
        return null;
    }

    public void stdoutWriteString(byte[] byArray) {
        this.mOutput = this.mOutput + new String(byArray);
        while (this.mOutput.indexOf("****END LS****") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.mOutput, "\n");
            String string = stringTokenizer.nextToken();
            this.mCurrentDirectory = stringTokenizer.nextToken();
            if (!this.mCurrentDirectory.endsWith("/")) {
                this.mCurrentDirectory = this.mCurrentDirectory + "/";
            }
            string = stringTokenizer.nextToken();
            Vector<FileListItem> vector = new Vector<FileListItem>();
            if (!this.mCurrentDirectory.equals("/")) {
                vector.addElement(new FileListItem("..", this.mCurrentDirectory, true));
            }
            while (!(string = stringTokenizer.nextToken()).startsWith("****")) {
                boolean bl = string.endsWith("/");
                String string2 = string;
                if (bl) {
                    string2 = string.substring(0, string.length() - 1);
                }
                vector.addElement(new FileListItem(string2, this.mCurrentDirectory, bl));
            }
            FileListItem.sort(vector);
            this.mFileDisplay.setFileList(vector, this.mCurrentDirectory);
            this.mOutput = this.mOutput.substring(this.mOutput.indexOf("****END LS****") + "****END LS****".length());
        }
    }

    public void stderrWriteString(byte[] byArray) {
        String string = new String(byArray);
        this.mErrorLog.logError(new SSHException("Error: " + string.trim()));
    }

    public void print(String string) {
    }

    public void println(String string) {
    }

    public void serverConnect(SSHChannelController sSHChannelController, Cipher cipher) {
    }

    public void serverDisconnect(String string) {
    }

    public void fileDoubleClicked(FileListItem fileListItem) throws SSHException {
        if (fileListItem.isDirectory()) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("cd \"");
                stringBuffer.append(fileListItem.getAbsolutePath());
                stringBuffer.append("\"\n");
                this.mClient.stdinWriteString(stringBuffer.toString());
                this.refresh();
            }
            catch (IOException iOException) {
                throw new SSHException("Error sending command to remote machine");
            }
        }
    }
}

