/*
 * Decompiled with CFR 0.152.
 */
package mindbright.terminal;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import mindbright.terminal.TerminalDefProps;
import mindbright.terminal.TerminalMenuHandler;
import mindbright.terminal.TerminalMenuListener;
import mindbright.terminal.TerminalWin;
import mindbright.terminal.TerminalXTerm;
import mindbright.util.AWTConvenience;

public final class TerminalMenuHandlerFull
extends TerminalMenuHandler {
    TerminalWin term;
    Object[] optionsItems;
    Menu optionsMenu;
    TerminalMenuListener listener;
    static final String[] optionsMenuTxt = new String[]{"VT Options", "Reverse Video", "Auto Wraparound", "Reverse Wraparound", "Insert mode", "Auto Linefeed", "Scroll to Bottom On Key Press", "Scroll to Bottom On Tty Output", "Local Page-ctrl Keys", "Copy <CR><NL> Instead Of <CR>", "Visible Cursor", "Use ASCII For Line Draw", "Local Echo", "Scale Font On Resize", "Visual Bell", "Map <CTRL>+<SPC> To ^@ (<NUL>)", "Toggle 80/132 Columns", "Enable 80/132 Switching", "Copy On Select"};
    static final String[] settingsMenu = new String[]{"Terminal Settings", "Emulation", "Resize gravity", "Font", "Savelines", "Scrollbar", "Colors", "Backspace"};
    Dialog settingsDialog;
    Choice choiceTE;
    Choice choiceFN;
    Choice choiceFG;
    Choice choiceBG;
    Choice choiceCC;
    Checkbox cbInitPos;
    Checkbox cbUL;
    Checkbox cbUR;
    Checkbox cbLL;
    Checkbox cbLR;
    CheckboxGroup cbgInitPos;
    TextField textFS;
    TextField textFG;
    TextField textBG;
    TextField textCC;
    TextField textRows;
    TextField textCols;
    TextField textInitPos;
    Label lblAlert;
    static final String[] te = TerminalXTerm.getTerminalTypes();
    static final String[] fn = Toolkit.getDefaultToolkit().getFontList();
    Dialog settingsDialog2;
    Choice choiceSB;
    Choice choiceRG;
    Checkbox cbDEL;
    Checkbox cbBS;
    TextField textSL;
    TextField textSD;
    Label lblAlert2;
    static final String[] sb = new String[]{"left", "right", "none"};
    static final String[] rg = new String[]{"bottom", "top"};
    Dialog findDialog = null;
    TextField findText;
    Label label;
    Checkbox dirCheck;
    Checkbox caseCheck;
    Button findBut;
    Button cancBut;
    int curFindRow = 0;
    int curFindCol = 0;
    int findLen = 0;

    public void setTerminalWin(TerminalWin terminalWin) {
        this.term = terminalWin;
    }

    public void setTerminalMenuListener(TerminalMenuListener terminalMenuListener) {
        this.listener = terminalMenuListener;
    }

    public void update() {
        if (this.listener != null) {
            this.listener.update();
        }
    }

    public void setEnabledOpt(int n, boolean bl) {
        ((CheckboxMenuItem)this.optionsItems[n]).setEnabled(bl);
    }

    public void setStateOpt(int n, boolean bl) {
        ((CheckboxMenuItem)this.optionsItems[n]).setState(bl);
    }

    public Menu getOptionsMenu() {
        if (this.optionsMenu != null) {
            return this.optionsMenu;
        }
        this.optionsMenu = new Menu(optionsMenuTxt[0]);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = 0;
                while (n < TerminalMenuHandlerFull.this.optionsItems.length) {
                    if (TerminalMenuHandlerFull.this.optionsItems[n] == itemEvent.getItemSelectable()) break;
                    ++n;
                }
                if (n >= TerminalMenuHandlerFull.this.optionsItems.length) {
                    return;
                }
                TerminalMenuHandlerFull.this.term.setProperty(TerminalDefProps.defaultPropDesc[n][0], String.valueOf(!TerminalMenuHandlerFull.this.term.termOptions[n]));
            }
        };
        this.optionsItems = new Object[optionsMenuTxt.length - 1];
        int n = 1;
        while (n < optionsMenuTxt.length) {
            CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(optionsMenuTxt[n], this.term.termOptions[n - 1]);
            this.optionsItems[n - 1] = checkboxMenuItem;
            checkboxMenuItem.addItemListener(itemListener);
            this.optionsMenu.add(checkboxMenuItem);
            ++n;
        }
        ((CheckboxMenuItem)this.optionsItems[12]).setEnabled(false);
        return this.optionsMenu;
    }

    public final void termSettingsDialog() {
        Object object;
        if (this.settingsDialog == null) {
            this.settingsDialog = new Dialog(this.term.ownerFrame, settingsMenu[0], true);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.settingsDialog.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 6;
            Label label = new Label("Terminal type:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            this.choiceTE = new Choice();
            gridBagLayout.setConstraints(this.choiceTE, gridBagConstraints);
            this.settingsDialog.add(this.choiceTE);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 4;
            label = new Label("Columns:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            gridBagConstraints.gridwidth = 2;
            this.textCols = new TextField("", 3);
            gridBagLayout.setConstraints(this.textCols, gridBagConstraints);
            this.settingsDialog.add(this.textCols);
            label = new Label("Rows:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            this.textRows = new TextField("", 3);
            gridBagLayout.setConstraints(this.textRows, gridBagConstraints);
            this.settingsDialog.add(this.textRows);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            label = new Label("Font:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            gridBagConstraints.gridwidth = 6;
            this.choiceFN = new Choice();
            gridBagLayout.setConstraints(this.choiceFN, gridBagConstraints);
            this.settingsDialog.add(this.choiceFN);
            gridBagConstraints.gridwidth = 2;
            this.textFS = new TextField("", 3);
            gridBagLayout.setConstraints(this.textFS, gridBagConstraints);
            this.settingsDialog.add(this.textFS);
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 10;
            label = new Label("Foreground color:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 6;
            this.choiceFG = new Choice();
            gridBagLayout.setConstraints(this.choiceFG, gridBagConstraints);
            this.settingsDialog.add(this.choiceFG);
            object = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    TerminalMenuHandlerFull.this.updateColors();
                }
            };
            this.choiceFG.addItemListener((ItemListener)object);
            this.textFG = new TextField("", 10);
            gridBagLayout.setConstraints(this.textFG, gridBagConstraints);
            this.settingsDialog.add(this.textFG);
            gridBagConstraints.gridy = 5;
            label = new Label("Background color:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            gridBagConstraints.gridy = 6;
            this.choiceBG = new Choice();
            gridBagLayout.setConstraints(this.choiceBG, gridBagConstraints);
            this.settingsDialog.add(this.choiceBG);
            this.choiceBG.addItemListener((ItemListener)object);
            this.textBG = new TextField("", 10);
            gridBagLayout.setConstraints(this.textBG, gridBagConstraints);
            this.settingsDialog.add(this.textBG);
            gridBagConstraints.gridy = 7;
            label = new Label("Cursor color:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog.add(label);
            gridBagConstraints.gridy = 8;
            this.choiceCC = new Choice();
            gridBagLayout.setConstraints(this.choiceCC, gridBagConstraints);
            this.settingsDialog.add(this.choiceCC);
            this.choiceCC.addItemListener((ItemListener)object);
            this.textCC = new TextField("", 10);
            gridBagLayout.setConstraints(this.textCC, gridBagConstraints);
            this.settingsDialog.add(this.textCC);
            Panel panel = new Panel();
            GridBagLayout gridBagLayout2 = new GridBagLayout();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            panel.setLayout(gridBagLayout2);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.anchor = 17;
            this.cbInitPos = new Checkbox("Window position:");
            gridBagLayout2.setConstraints(this.cbInitPos, gridBagConstraints2);
            panel.add(this.cbInitPos);
            this.cbgInitPos = new CheckboxGroup();
            gridBagConstraints2.gridwidth = 1;
            this.cbUL = new Checkbox("", true, this.cbgInitPos);
            gridBagLayout2.setConstraints(this.cbUL, gridBagConstraints2);
            panel.add(this.cbUL);
            this.cbUR = new Checkbox("", false, this.cbgInitPos);
            gridBagLayout2.setConstraints(this.cbUR, gridBagConstraints2);
            panel.add(this.cbUR);
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.anchor = 10;
            this.textInitPos = new TextField("", 10);
            gridBagLayout2.setConstraints(this.textInitPos, gridBagConstraints2);
            panel.add(this.textInitPos);
            gridBagConstraints2.gridwidth = 1;
            gridBagConstraints2.anchor = 17;
            this.cbLL = new Checkbox("", false, this.cbgInitPos);
            gridBagLayout2.setConstraints(this.cbLL, gridBagConstraints2);
            panel.add(this.cbLL);
            this.cbLR = new Checkbox("", false, this.cbgInitPos);
            gridBagLayout2.setConstraints(this.cbLR, gridBagConstraints2);
            panel.add(this.cbLR);
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    TerminalMenuHandlerFull.this.updateInitPos();
                }
            };
            this.cbInitPos.addItemListener(itemListener);
            this.cbUL.addItemListener(itemListener);
            this.cbUR.addItemListener(itemListener);
            this.cbLL.addItemListener(itemListener);
            this.cbLR.addItemListener(itemListener);
            gridBagConstraints.gridy = 9;
            gridBagConstraints.insets = new Insets(8, 4, 0, 0);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.settingsDialog.add(panel);
            this.lblAlert = new Label("", 1);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.lblAlert, gridBagConstraints);
            this.settingsDialog.add(this.lblAlert);
            Panel panel2 = new Panel(new FlowLayout());
            Button button = new Button("OK");
            panel2.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        TerminalMenuHandlerFull.this.term.setProperty("te", te[TerminalMenuHandlerFull.this.choiceTE.getSelectedIndex()]);
                        TerminalMenuHandlerFull.this.term.setProperty("fn", fn[TerminalMenuHandlerFull.this.choiceFN.getSelectedIndex()]);
                        TerminalMenuHandlerFull.this.term.setProperty("fs", TerminalMenuHandlerFull.this.textFS.getText());
                        TerminalMenuHandlerFull.this.term.setProperty("fg", TerminalMenuHandlerFull.this.getSelectedColor(TerminalMenuHandlerFull.this.choiceFG, TerminalMenuHandlerFull.this.textFG));
                        TerminalMenuHandlerFull.this.term.setProperty("bg", TerminalMenuHandlerFull.this.getSelectedColor(TerminalMenuHandlerFull.this.choiceBG, TerminalMenuHandlerFull.this.textBG));
                        TerminalMenuHandlerFull.this.term.setProperty("cc", TerminalMenuHandlerFull.this.getSelectedColor(TerminalMenuHandlerFull.this.choiceCC, TerminalMenuHandlerFull.this.textCC));
                        String string = "";
                        if (TerminalMenuHandlerFull.this.cbInitPos.getState()) {
                            string = TerminalMenuHandlerFull.this.textInitPos.getText();
                        }
                        TerminalMenuHandlerFull.this.term.setProperty("gm", TerminalMenuHandlerFull.this.textCols.getText() + "x" + TerminalMenuHandlerFull.this.textRows.getText() + string);
                        ((Component)TerminalMenuHandlerFull.this.settingsDialog).setVisible(false);
                    }
                    catch (Exception exception) {
                        TerminalMenuHandlerFull.this.lblAlert.setText(exception.getMessage());
                    }
                }
            });
            button = new Button("Cancel");
            panel2.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.settingsDialog));
            gridBagConstraints.gridy = 11;
            gridBagLayout.setConstraints(panel2, gridBagConstraints);
            this.settingsDialog.add(panel2);
            this.fillChoices();
            this.settingsDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.settingsDialog);
            this.settingsDialog.setResizable(true);
            this.settingsDialog.pack();
        }
        this.choiceTE.select(this.term.getProperty("te"));
        this.choiceFN.select(this.term.getProperty("fn"));
        this.textFS.setText(this.term.getProperty("fs"));
        this.textCols.setText(String.valueOf(this.term.cols()));
        this.textRows.setText(String.valueOf(this.term.rows()));
        this.initColorSelect(this.choiceFG, this.textFG, this.term.getProperty("fg"));
        this.initColorSelect(this.choiceBG, this.textBG, this.term.getProperty("bg"));
        this.initColorSelect(this.choiceCC, this.textCC, this.term.getProperty("cc"));
        this.updateColors();
        object = this.term.savedGeomPos;
        if (((String)object).length() > 0) {
            this.cbInitPos.setState(true);
            this.updateInitPos();
            if (((String)object).equals("+0+0")) {
                this.cbUL.setState(true);
            } else if (((String)object).equals("-0+0")) {
                this.cbUR.setState(true);
            } else if (((String)object).equals("+0-0")) {
                this.cbLL.setState(true);
            } else if (((String)object).equals("-0-0")) {
                this.cbLR.setState(true);
            }
            this.textInitPos.setText((String)object);
        } else {
            this.cbInitPos.setState(false);
            this.updateInitPos();
        }
        this.lblAlert.setText("");
        AWTConvenience.placeDialog(this.settingsDialog);
        this.choiceTE.requestFocus();
        ((Component)this.settingsDialog).setVisible(true);
    }

    void initColorSelect(Choice choice, TextField textField, String string) {
        if (Character.isDigit(string.charAt(0))) {
            choice.select("custom rgb");
            textField.setText(string);
        } else {
            textField.setText("");
            textField.setEnabled(false);
            choice.select(string);
        }
    }

    void checkColorSelect(Choice choice, TextField textField) {
        int n = choice.getSelectedIndex();
        if (n == 0) {
            boolean bl = textField.isEnabled();
            if (!bl) {
                textField.setEditable(true);
                textField.setEnabled(true);
                textField.setBackground(SystemColor.text);
                textField.requestFocus();
            }
        } else {
            textField.setText("");
            textField.setEditable(false);
            textField.setEnabled(false);
            textField.setBackground(TerminalWin.termColors[n - 1]);
        }
    }

    void updateColors() {
        this.checkColorSelect(this.choiceFG, this.textFG);
        this.checkColorSelect(this.choiceBG, this.textBG);
        this.checkColorSelect(this.choiceCC, this.textCC);
    }

    String getSelectedColor(Choice choice, TextField textField) {
        String string = choice.getSelectedIndex() == 0 ? textField.getText() : choice.getSelectedItem();
        return string;
    }

    void updateInitPos() {
        if (this.cbInitPos.getState()) {
            this.textInitPos.setEnabled(true);
            this.cbUL.setEnabled(true);
            this.cbUR.setEnabled(true);
            this.cbLL.setEnabled(true);
            this.cbLR.setEnabled(true);
            if (this.cbUL.getState()) {
                this.textInitPos.setText("+0+0");
            } else if (this.cbUR.getState()) {
                this.textInitPos.setText("-0+0");
            } else if (this.cbLL.getState()) {
                this.textInitPos.setText("+0-0");
            } else if (this.cbLR.getState()) {
                this.textInitPos.setText("-0-0");
            }
        } else {
            this.textInitPos.setText("");
            this.textInitPos.setEnabled(false);
            this.cbUL.setEnabled(false);
            this.cbUR.setEnabled(false);
            this.cbLL.setEnabled(false);
            this.cbLR.setEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void fillChoices() {
        int n = 0;
        while (n < te.length) {
            this.choiceTE.add(te[n]);
            ++n;
        }
        n = 0;
        while (n < fn.length) {
            this.choiceFN.add(fn[n]);
            ++n;
        }
        this.choiceBG.add("custom rgb");
        this.choiceFG.add("custom rgb");
        this.choiceCC.add("custom rgb");
        n = 0;
        while (n < TerminalWin.termColorNames.length) {
            this.choiceBG.add(TerminalWin.termColorNames[n]);
            this.choiceFG.add(TerminalWin.termColorNames[n]);
            this.choiceCC.add(TerminalWin.termColorNames[n]);
            ++n;
        }
    }

    public final void termSettingsDialog2() {
        if (this.settingsDialog2 == null) {
            this.settingsDialog2 = new Dialog(this.term.ownerFrame, "Terminal Miscellaneous Settings", true);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.settingsDialog2.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(4, 4, 0, 0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridy = 0;
            Label label = new Label("Savelines:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog2.add(label);
            this.textSL = new TextField("", 4);
            gridBagLayout.setConstraints(this.textSL, gridBagConstraints);
            this.settingsDialog2.add(this.textSL);
            gridBagConstraints.gridy = 1;
            label = new Label("Scrollbar:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog2.add(label);
            this.choiceSB = new Choice();
            gridBagLayout.setConstraints(this.choiceSB, gridBagConstraints);
            this.settingsDialog2.add(this.choiceSB);
            int n = 0;
            while (n < sb.length) {
                this.choiceSB.add(sb[n]);
                ++n;
            }
            gridBagConstraints.gridy = 2;
            label = new Label("Resize gravity:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog2.add(label);
            this.choiceRG = new Choice();
            gridBagLayout.setConstraints(this.choiceRG, gridBagConstraints);
            this.settingsDialog2.add(this.choiceRG);
            n = 0;
            while (n < rg.length) {
                this.choiceRG.add(rg[n]);
                ++n;
            }
            gridBagConstraints.gridy = 3;
            label = new Label("Select delim.:");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            this.settingsDialog2.add(label);
            this.textSD = new TextField("", 4);
            gridBagLayout.setConstraints(this.textSD, gridBagConstraints);
            this.settingsDialog2.add(this.textSD);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 8;
            gridBagConstraints.insets = new Insets(4, 16, 0, 0);
            this.cbBS = new Checkbox("Backspace sends Delete");
            gridBagLayout.setConstraints(this.cbBS, gridBagConstraints);
            this.settingsDialog2.add(this.cbBS);
            gridBagConstraints.gridy = 5;
            this.cbDEL = new Checkbox("Delete sends Backspace");
            gridBagLayout.setConstraints(this.cbDEL, gridBagConstraints);
            this.settingsDialog2.add(this.cbDEL);
            this.lblAlert2 = new Label("", 1);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 6;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagLayout.setConstraints(this.lblAlert2, gridBagConstraints);
            this.settingsDialog2.add(this.lblAlert2);
            Panel panel = new Panel(new FlowLayout());
            Button button = new Button("OK");
            panel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        TerminalMenuHandlerFull.this.term.setProperty("sb", sb[TerminalMenuHandlerFull.this.choiceSB.getSelectedIndex()]);
                        TerminalMenuHandlerFull.this.term.setProperty("rg", rg[TerminalMenuHandlerFull.this.choiceRG.getSelectedIndex()]);
                        TerminalMenuHandlerFull.this.term.setProperty("sl", TerminalMenuHandlerFull.this.textSL.getText());
                        TerminalMenuHandlerFull.this.term.setProperty("sd", TerminalMenuHandlerFull.this.textSD.getText());
                        if (TerminalMenuHandlerFull.this.cbBS.getState()) {
                            TerminalMenuHandlerFull.this.term.setProperty("bs", "DEL");
                        } else {
                            TerminalMenuHandlerFull.this.term.setProperty("bs", "BS");
                        }
                        if (TerminalMenuHandlerFull.this.cbDEL.getState()) {
                            TerminalMenuHandlerFull.this.term.setProperty("de", "BS");
                        } else {
                            TerminalMenuHandlerFull.this.term.setProperty("de", "DEL");
                        }
                        ((Component)TerminalMenuHandlerFull.this.settingsDialog2).setVisible(false);
                    }
                    catch (Exception exception) {
                        TerminalMenuHandlerFull.this.lblAlert2.setText(exception.getMessage());
                    }
                }
            });
            button = new Button("Cancel");
            panel.add(button);
            button.addActionListener(new AWTConvenience.CloseAction(this.settingsDialog2));
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            this.settingsDialog2.add(panel);
            this.settingsDialog2.addWindowListener(new AWTConvenience.CloseAdapter(button));
            AWTConvenience.setBackgroundOfChildren(this.settingsDialog2);
            this.settingsDialog2.setResizable(true);
            this.settingsDialog2.pack();
        }
        this.choiceSB.select(this.term.getProperty("sb"));
        this.choiceRG.select(this.term.getProperty("rg"));
        this.textSL.setText(this.term.getProperty("sl"));
        String string = this.term.getProperty("sd");
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        this.textSD.setText(string);
        if (this.term.getProperty("bs").equals("DEL")) {
            this.cbBS.setState(true);
        } else {
            this.cbBS.setState(false);
        }
        if (this.term.getProperty("de").equals("BS")) {
            this.cbDEL.setState(true);
        } else {
            this.cbDEL.setState(false);
        }
        this.lblAlert2.setText("");
        AWTConvenience.placeDialog(this.settingsDialog2);
        this.textSL.requestFocus();
        ((Component)this.settingsDialog2).setVisible(true);
    }

    public final void findDialog() {
        if (this.findDialog == null) {
            this.findDialog = new Dialog(this.term.ownerFrame, "MindTerm - Find", false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.findDialog.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            this.label = new Label("Find:");
            gridBagLayout.setConstraints(this.label, gridBagConstraints);
            this.findDialog.add(this.label);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 5;
            this.findText = new TextField("", 26);
            gridBagLayout.setConstraints(this.findText, gridBagConstraints);
            this.findDialog.add(this.findText);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.ipadx = 4;
            gridBagConstraints.ipady = 4;
            gridBagConstraints.insets = new Insets(6, 3, 3, 6);
            this.findBut = new Button("Find");
            gridBagLayout.setConstraints(this.findBut, gridBagConstraints);
            this.findDialog.add(this.findBut);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 0;
            this.caseCheck = new Checkbox("Case sensitive");
            gridBagLayout.setConstraints(this.caseCheck, gridBagConstraints);
            this.findDialog.add(this.caseCheck);
            this.dirCheck = new Checkbox("Find backwards");
            gridBagLayout.setConstraints(this.dirCheck, gridBagConstraints);
            this.findDialog.add(this.dirCheck);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.ipadx = 4;
            gridBagConstraints.ipady = 4;
            gridBagConstraints.insets = new Insets(3, 3, 6, 6);
            gridBagConstraints.fill = 2;
            this.cancBut = new Button("Cancel");
            gridBagLayout.setConstraints(this.cancBut, gridBagConstraints);
            this.findDialog.add(this.cancBut);
            this.cancBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)TerminalMenuHandlerFull.this.findDialog).setVisible(false);
                    if (TerminalMenuHandlerFull.this.findLen > 0) {
                        TerminalMenuHandlerFull.this.term.clearSelection(TerminalMenuHandlerFull.this.curFindRow, TerminalMenuHandlerFull.this.curFindCol, TerminalMenuHandlerFull.this.curFindRow, TerminalMenuHandlerFull.this.curFindCol + TerminalMenuHandlerFull.this.findLen - 1);
                    }
                    TerminalMenuHandlerFull.this.curFindRow = 0;
                    TerminalMenuHandlerFull.this.curFindCol = 0;
                    TerminalMenuHandlerFull.this.findLen = 0;
                }
            });
            this.findBut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = TerminalMenuHandlerFull.this.findText.getText();
                    if (string != null && string.length() > 0) {
                        TerminalMenuHandlerFull.this.doFind();
                    }
                }
            });
            this.findDialog.addWindowListener(new AWTConvenience.CloseAdapter(this.cancBut));
            AWTConvenience.setBackgroundOfChildren(this.findDialog);
            AWTConvenience.setKeyListenerOfChildren(this.findDialog, new AWTConvenience.OKCancelAdapter(this.findBut, this.cancBut), null);
            this.findDialog.setResizable(true);
            this.findDialog.pack();
        }
        AWTConvenience.placeDialog(this.findDialog);
        this.findText.requestFocus();
        ((Component)this.findDialog).setVisible(true);
    }

    static final boolean doMatch(String string, char c, char[] cArray, int n, boolean bl, int n2) {
        if (bl) {
            if (cArray[n] != c) {
                return false;
            }
            String string2 = new String(cArray, n, n2);
            if (string2.equals(string)) {
                return true;
            }
        } else {
            if (Character.toLowerCase(cArray[n]) != c) {
                return false;
            }
            String string3 = new String(cArray, n, n2);
            if (string3.equalsIgnoreCase(string)) {
                return true;
            }
        }
        return false;
    }

    void doFind() {
        int n;
        char c;
        String string = this.findText.getText();
        int n2 = string.length();
        boolean bl = this.caseCheck.getState();
        boolean bl2 = this.dirCheck.getState();
        int n3 = this.term.saveVisTop + this.term.curRow;
        boolean bl3 = false;
        int n4 = 0;
        char c2 = c = bl ? string.charAt(0) : Character.toLowerCase(string.charAt(0));
        if (this.findLen > 0) {
            this.term.clearSelection(this.curFindRow, this.curFindCol, this.curFindRow, this.curFindCol + this.findLen - 1);
        }
        if (bl2) {
            int n5;
            if (this.findLen > 0) {
                n5 = this.curFindCol - 1;
            } else {
                this.curFindRow = n3;
                n5 = this.term.cols - n2;
            }
            n = this.curFindRow;
            block0: while (n >= 0) {
                n4 = n5;
                while (n4 >= 0) {
                    if (this.term.screen[n][n4] != '\u0000' && TerminalMenuHandlerFull.doMatch(string, c, this.term.screen[n], n4, bl, n2)) break block0;
                    --n4;
                }
                n5 = this.term.cols - n2;
                --n;
            }
            if (n >= 0) {
                bl3 = true;
            }
        } else {
            int n6 = this.curFindCol + this.findLen;
            n = this.curFindRow;
            block2: while (n < n3) {
                n4 = n6;
                while (n4 < this.term.cols - n2) {
                    if (this.term.screen[n][n4] != '\u0000' && TerminalMenuHandlerFull.doMatch(string, c, this.term.screen[n], n4, bl, n2)) break block2;
                    ++n4;
                }
                n6 = 0;
                ++n;
            }
            if (n < n3) {
                bl3 = true;
            }
        }
        if (bl3) {
            this.findLen = n2;
            if (this.term.saveVisTop < n) {
                this.term.visTop = this.term.saveVisTop;
            } else if (this.term.visTop > n || n - this.term.visTop > this.term.rows) {
                this.term.visTop = n;
            }
            this.term.updateScrollbarValues();
            this.term.makeAllDirty(false);
            this.term.makeSelection(n, n4, n, n4 + n2 - 1);
            this.curFindRow = n;
            this.curFindCol = n4;
            this.findLen = n2;
        } else {
            this.term.doBell();
            this.curFindRow = 0;
            this.curFindCol = 0;
            this.findLen = 0;
        }
    }
}

