/*
 * Decompiled with CFR 0.152.
 */
package mindbright.util;

public class HexDump {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String intToString(int n) {
        char[] cArray = new char[8];
        int n2 = 7;
        while (n2 >= 0) {
            cArray[n2] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    private static String toString(byte[] byArray) {
        return HexDump.toString(byArray, 0, byArray.length);
    }

    private static String toString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = n;
        int n4 = 0;
        while (n3 < n + n2) {
            byte by = byArray[n3++];
            cArray[n4++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n4++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static String formatHex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static void hexDump(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            String string = HexDump.formatHex(n3 + n, 8) + ": ";
            int n5 = n2 - n3;
            n5 = n5 > 16 ? 16 : n5;
            int n6 = 0;
            while (n6 < n5) {
                n4 = (byArray[n3 + n6] + 256) % 256;
                string = string + HexDump.formatHex(n4, 2);
                if (n6 % 2 == 1) {
                    string = string + " ";
                }
                ++n6;
            }
            while (n6 < 16) {
                string = string + "  ";
                if (n6 % 2 == 1) {
                    string = string + " ";
                }
                ++n6;
            }
            string = string + " ";
            n6 = 0;
            while (n6 < n5) {
                n4 = (byArray[n3 + n6] + 256) % 256;
                n4 = n4 < 32 || n4 >= 127 ? 46 : n4;
                string = string + (char)n4;
                ++n6;
            }
            System.out.println(string);
            n3 += 16;
        }
    }
}

