/* MAKETHM.CMD */
PARSE ARG identifier filepath descr

identifier = STRIP( TRANSLATE( identifier ))
filepath   = STRIP( TRANSLATE( filepath   ))
descr      = STRIP( descr )

IF identifier = '' THEN DO
    SAY 'Syntax: MAKETHM <identifier> [ <directory> [ <description> ] ]'
    SAY 'where'
    SAY '       <identifier>  = one-word theme identifier (1-8 alphanumeric characters)'
    SAY '       <directory>   = directory containing your theme source files'
    SAY '       <description> = brief description of theme (1-30 characters)'
    RETURN -1
END
IF filepath = '' THEN filepath = identifier
IF descr    = '' THEN descr    = identifier

current = DIRECTORY()
IF ( DIRECTORY( filepath ) = current ) THEN DO
    SAY 'Error: cannot change to directory' filepath'.'
    RETURN -1
END

source_rc  = identifier'.RC'
target_res = identifier'.RES'
target_idx = identifier'.IDX'

wait = 0
IF ( STREAM( source_rc,  'C', 'QUERY EXISTS') \= '') THEN DO
    SAY source_rc 'exists, will be overwritten.'
    wait = 1
END
IF ( STREAM( target_res, 'C', 'QUERY EXISTS') \= '') THEN DO
    SAY target_res 'exists, will be overwritten.'
    wait = 1
END
IF ( STREAM( target_idx, 'C', 'QUERY EXISTS') \= '') THEN DO
    SAY target_idx 'exists, will be overwritten.'
    wait = 1
END
IF wait = 1 THEN '@PAUSE'

SAY 'Creating description file for window theme "'descr'" ...'
CALL MakeIDX target_idx, identifier, descr

SAY
SAY 'Creating resource file' target_res 'using files in directory' filepath '...'
CALL MakeRC source_rc

'@rc.exe -n -r' source_rc

IF rc = 0 THEN DO
    SAY 'Done.'
    SAY
    SAY 'To install this theme, copy the files' target_res',' identifier'.BMP, and' target_idx
    SAY 'to the THEMEMGR directory (probably \ECS\SYSTEM\THEMEMGR on the boot volume),'
    SAY 'then change to that directory and run the command:'
    SAY
    SAY 'ADDTHEME' identifier
    SAY
END
ELSE DO
    SAY 'Errors were encountered.'
    SAY 'Make sure all the required files exist in the specified path.'
    SAY 'Also make sure the Resource Compiler (RC.EXE) is properly installed.'
END

RETURN rc


/*
 * MakeRC: Create the *.RC source file for the resource compiler.
 */
MakeRC: PROCEDURE
    ARG target
    IF ( STREAM( target, 'C', 'QUERY EXISTS') \= '') THEN '@ERASE' target
    CALL LINEOUT target, 'BITMAP 25  sysmen.bmp  '
    CALL LINEOUT target, 'BITMAP 26  min.bmp     '
    CALL LINEOUT target, 'BITMAP 27  max.bmp     '
    CALL LINEOUT target, 'BITMAP 28  rest.bmp    '
    CALL LINEOUT target, 'BITMAP 29  csysmen.bmp '
    CALL LINEOUT target, ''
    CALL LINEOUT target, 'BITMAP 30  sysmend.bmp '
    CALL LINEOUT target, 'BITMAP 31  mind.bmp    '
    CALL LINEOUT target, 'BITMAP 32  maxd.bmp    '
    CALL LINEOUT target, 'BITMAP 33  restd.bmp   '
    CALL LINEOUT target, 'BITMAP 34  csysmend.bmp'
    CALL LINEOUT target, ''
    CALL LINEOUT target, 'BITMAP 48  buttons.bmp '
    CALL LINEOUT target, 'BITMAP 50  hide.bmp    '
    CALL LINEOUT target, 'BITMAP 51  hided.bmp   '
    CALL LINEOUT target, 'BITMAP 52  close.bmp   '
    CALL LINEOUT target, 'BITMAP 53  closed.bmp  '
    CALL LINEOUT target
RETURN


/*
 * MakeIDX: Create the theme description file.
 */
MakeIDX: PROCEDURE
    PARSE ARG idx, shortname, longname

    IF ( STREAM( idx, 'C', 'QUERY EXISTS') \= '') THEN '@ERASE' idx
    CALL LINEOUT idx, ' ' || LEFT( longname, 30 ) '  ' || LEFT( shortname'.DLL', 12 ) || '  ' || LEFT( shortname'.BMP', 12 )
    CALL LINEOUT idx
RETURN

