/* OS/2-REXX-Programm kzr.CMD, 05.12.1996   */
   "@ echo off"
   /* Diese hohe Genauigkeit ist an  d i e s e r  Stelle erforderlich,   */
   /* um einige der Teilstrings auf formale Fehler berprfen zu knnen. */
   numeric digits 100
   ND=20
   parse arg str
   str=strip(str)

   if (length(str)= 0) then
   do
     "view.exe kzr.inf"
     SIGNAL ende
   end
   ww=word(str, 1)
   l1=length(ww)
   lk=Pos(",", ww)
   p1=wordpos(" , ", str)

   if l1 <> lk then
   do
     if p1 = 0 then
     do
       Call kommav
       SIGNAL ende
     end
   end

   parse value str with ND ',' t1 op12 t2 op23

   if length(ND) = 0 then ND = 20
   numeric digits ND

   if length(op23) <> 0 then
   do
     Call anz1 op23
     SIGNAL ende
   end

   /* Intern mssen  t1  und  t2, wenn sie Dezimalbrche sind,  */
   /* den Dezimal-Punkt haben.                                  */
   sop = Pos(",", t1); if sop <> 0 then t1 = OverLay(".", t1, sop)
   sop = Pos(",", t2); if sop <> 0 then t2 = OverLay(".", t2, sop)

   if length(t1) = 0 | length(op12) = 0 | length(t2) = 0 then
   do
     Call unvoll
     SIGNAL ende
   end

   if op12='**' & Datatype(t2, N) <> 1 then
   do
     Call expNoRexx t2
     SIGNAL ende
   end

   if op12="**" & Datatype(t2, W) <> 1  then
   do
     Call expNoInt t2
     SIGNAL ende
   end

   select
     when op12='+'  then do;  Signal we; end
     when op12='-'  then do;  Signal we; end
     when op12='*'  then do;  Signal we; end
     when op12='/'  then do;  Signal we; end
     when op12=':'       then do; op12 = '/';  Signal we; end
     when op12='divganz' then do; op12 = '%';  Signal we; end
     when op12='divrest' then do; op12 = "//"; Signal we; end
     when op12='**' then do;  Signal we; end
     otherwise
     do
       Call falschop op12
       SIGNAL ende
     end
   end

we:
   if datatype(t1, N) <> 1 then
   do
     Call anzt1 t1
     SIGNAL ende
   end

   if datatype(t2, N) <> 1 then
   do
     Call anzt2 t2
     SIGNAL ende
   end

   select
     when op12="+"  then do; z=t1+t2;  signal wew; end
     when op12="-"  then do; z=t1-t2;  signal wew; end
     when op12="*"  then do; z=t1*t2;  signal wew; end
     when op12="/"  then do; z=t1/t2;  signal wew; end
     when op12="%"  then do; z=t1%t2;  signal wew; end
     when op12="//" then do; z=t1//t2; signal wew; end
     otherwise NOP
   end

   if op12="**" then
   do
     if t2 < 1.0E9 then
     do
       z=t1**t2
       signal wew
     end
     else
       Call expZuGross t2
       SIGNAL ende
     end
   end


wew:
   /* In dem die "Rechenaufgabe" nochmals anzeigende Kommandozeilen-String */
   /* sollen  t1  und  t2, wenn sie Dezimalbrche sind,                    */
   /* mit dem Dezimal-Komma gezeigt werden.                                */
   sop = Pos(".", t1); if sop <> 0 then t1 = OverLay(",", t1, sop)
   sop = Pos(".", t2); if sop <> 0 then t2 = OverLay(",", t2, sop)
   str=t1||" "||op12||" "||t2

   /* Das Ergebnis  z  soll, wenn es ein Dezimalbruch ist,  */
   /* mit den Dezimal-Komma angezeigt werden.               */
   sop = Pos(".", z)
   if sop <> 0 then z = OverLay(",", z, sop)

   say
   Call CsrAttrib "High";   Call Color "white"
   Call Charout,"Es wird intern mit  "
   Call Color "yellow"
   Call Charout,ND
   Call Color "white"
   Call Charout,"  Dezimalstellen gerechnet.";say; say
   Call Color "yellow"
   Call Charout,str; say; say
   Call Color "white"
   Call Charout," = "
   Call Color "green"
   Call Charout,z; say
   Call CsrAttrib "Normal"

ende:
EXIT

anzt1:
  say
  parse arg t1
  Call CsrAttrib "High";   Call Color "white"
  Call Charout,"          "
  Call Charout,t1
  Call Color "yellow"
  Call Charout,"  ist keine gltige REXX-Zahl !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

anzt2:
  say
  Call CsrAttrib "High";   Call Color "white"
  Call Charout,"          "
  Call Charout,t2
  Call Color "yellow"
  Call Charout,"  ist keine gltige REXX-Zahl !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

anz1:
  say
  parse arg op23
  Call CsrAttrib "High";   Call Color "Yellow"
  Call Charout,"Das Zeichen  "
  Call Color "white"
  Call Charout,op23
  Call Color "yellow"
  Call Charout,"  am Ende der Eingabe ist berflssig !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

falschop:
  say
  parse arg op12
  Call CsrAttrib "High";   Call Color "Yellow"
  Call Charout,"Das Zeichen (oder der String)  "
  Call Color "white"
  Call Charout,op12; say
  Call Color "yellow"
  Call Charout,"ist "
  Call Color "cyan"
  Call Charout,"keiner"
  Call Color "yellow"
  Call Charout," der mathematischer Operatoren"; say
  Call Color "white"
  Call Charout,"+"
  Call Color "yellow"
  Call Charout,", "
  Call Color "white"
  Call Charout,"-"
  Call Color "yellow"
  Call Charout,", "
  Call Color "white"
  Call Charout,"*"
  Call Color "yellow"
  Call Charout,", "
  Call Color "white"
  Call Charout,":"
  Call Color "yellow"
  Call Charout," (oder "
  Call Color "white"
  Call Charout,"/"
  Call Color "yellow"
  Call Charout,"), "
  Call Color "white"
  Call Charout,"divganz"
  Call Color "yellow"
  Call Charout," (intern: %) oder "
  Call Color "white"
  Call Charout,"divrest "
  Call Color "yellow"
  Call Charout,"(intern: //) !"; say; say
  Call Color "yellow"
  Call Charout,"Nheres ist in der "
  Call Color "white"
  Call Charout,"kzr.INF"
  Call Color "yellow"
  Call Charout," zu finden."
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

unvoll:
  say
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"Es sind nicht alle erforderlichen Engaben gemacht"; say
  Call Charout,"oder unbedingt erforderliche Leerzeichen vergessen worden !"; say; say
  Call Charout,"Oder ist vielleicht versehentlich"; say
  Call Charout,"der interne Operator  "
  Call Color "white"
  Call Charout,"%"
  Call Color "yellow"
  Call Charout,"   anstelle des externen Operators  "
  Call Color "white"
  Call Charout,"divganz"
  Call Color "yellow"
  Call Charout,"  oder";say
  Call Charout,"der interne Operator  "
  Call Color "white"
  Call Charout,"//"
  Call Color "yellow"
  Call Charout,"  anstelle des externen Operators  "
  Call Color "white"
  Call Charout,"divrest"
  Call Color "yellow"
  Call Charout,"  eingegeben";say
  Call Charout,"worden ?"; say
  Call Color "yellow"
  Call Charout,"Nheres ist in der "
  Call Color "white"
  Call Charout,"kzr.INF"
  Call Color "yellow"
  Call Charout," zu finden."
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

kommav:
  say
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"In dem Kommandozeilen-String mu nach dem Teilstring  "
  Call Color "cyan"
  Call Charout,"kzr"; say
  Call Color "yellow"
  Call Charout,"mindestens  "
  Call Color "green"
  Call Charout,"1"
  Call Color "yellow"
  Call Charout,"  Leerzeichen enthalten sein."; say
  Call Charout,"Darauf folgend, bevor die eigentliche ""Rechenaufgabe"" eingegeben wird,"; say
  Call Charout,"entweder";say
  Call Charout,"         ein "
  Call Color "cyan"
  Call Charout,"einzelnes Komma"
  Call Color "yellow"
  Call Charout," mit mindestens  "
  Call Color "green"
  Call Charout,"1"
  Call Color "yellow"
  Call Charout,"  Leerzeichen dahinter,"; say
  Call Charout,"oder";say
  Call Charout,"         eine "
  Call Color "cyan"
  Call Charout,"ganze Zahl > 1"
  Call Color "yellow"
  Call Charout,", gefolgt von"; say
  Call Charout,"         einem "
  Call Color "cyan"
  Call Charout,"einzelnen Komma"
  Call Color "yellow"
  Call Charout," mit mindestens  "
  Call Color "green"
  Call Charout,"1"
  Call Color "yellow"
  Call Charout,"  Leerzeichen dahinter."; say; say
  Call Charout,"Nheres ist in der "
  Call Color "white"
  Call Charout,"kzr.INF"
  Call Color "yellow"
  Call Charout," zu finden."
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

expNoInt:
  say
  parse arg t2
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"Der Exponent "
  Call Color "white"
  Call Charout,t2
  Call Color "yellow"
  Call Charout," ist nicht ganzzahlig !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

expNoRexx:
  say
  parse arg t2
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"Der Exponent "
  Call Color "white"
  Call Charout,t2
  Call Color "yellow"
  Call Charout,"  ist keine gltige REXX-Zahl !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return

expZuGross:
  say
  parse arg t2
  Call CsrAttrib "High";   Call Color "yellow"
  Call Charout,"Der Exponent "
  Call Color "white"
  Call Charout,t2
  Call Color "yellow"
  Call Charout,"  mu kleiner als 1.0E+9 sein !"
  say
  Beep(444, 200); Beep(628,300)
  Call CsrAttrib "Normal";
  return







Color: Procedure /* Call Color <ForeGround>,<BackGround> */
arg F,B
Colors = "BLACK RED GREEN YELLOW BLUE MAGENTA CYAN WHITE"
return CHAROUT(,D2C(27)"["WORDPOS(F,COLORS)+29";"WORDPOS(B,COLORS)+39";m")

CsrAttrib: Procedure  /* call CsrAttrib <Attrib> */
Arg A
attr = "NORMAL HIGH LOW ITALIC UNDERLINE BLINK RAPID REVERSE"
return CHAROUT(,D2C(27)"["WORDPOS(A,ATTR) - 1";m")

EndAll:
Call Color "White","Black"
CALL CsrAttrib "Normal"

