{
   *****************************************************************
   *                                                               *
   *                         UNIT MYLIB                            *
   *                                                               *
   *     Define rotinas e constantes de uso geral para uso em      *
   *                     qualquer programa                         *
   *                                                               *
   *****************************************************************
}

unit mylib;   {$L-,D-}

interface

uses crt;

const
   (* teclas *)
      branco   = #32;
      esc      = #27;
      enter    = #13;
      null     = #0;
      ff       = #12;
      bs       = #8;
      f1       = #59;
      f2       = #60;
      f3       = #61;
      f4       = #62;
      f5       = #63;
      f6       = #64;
      f7       = #65;
      f8       = #66;
      f9       = #67;
      f10      = #68;
      home     = #71;
      fim      = #79;
      esquerda = #75;
      direita  = #77;
      del      = #83;
   (* tipo de cursor *)
      normal   = false;
      insercao = true;

type strdata = string[8];

var esp : byte; (* define caracter Branco para Readstr *)

function maiusc(var strg : string) : string; (* converte uma string p/ maiusculas *)
procedure textwindow(xmin,ymin,xmax,ymax : byte;tipo_borda : boolean);
function sn : boolean; (* retorna TRUE se pressionado "S" e FALSE se "N" *)
procedure readstr(var st : string; tam : byte); (* le uma string de tamanho tam *)
procedure readnum(var num : longint; tam : byte);
procedure entradata(var data : strdata); (* retorna uma string com a data digitada *)
procedure converte(data : strdata; var ano,mes,dia : word); (* converte DATA em dia mes e ano *)
procedure tempo_gasto(hi,mi,si,h,m,s : word); (* mostra tempo decorrido entre hi:mi:si e h:m:s *)
procedure beep;  (* emite um sinal sonoro *)
procedure ledata(var ano,mes,dia : word); (* le uma data pelo teclado *)
procedure nocursor; (* esconde o cursor *)
procedure waitesc;(* aguarda o pressionar da tecla ESC *)
procedure setcursor(tipo_cursor : boolean);


implementation

uses dos;

function maiusc(var strg : string) : string;

var cont,
    tam   : integer;

begin
   tam:=length(strg);
   for cont:=1 to tam do
     case strg[cont] of
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        '' : strg[cont]:='';
        else strg[cont]:=upcase(strg[cont])
     end; (* case *)
  maiusc:= strg;
end; (* maiusc *)

procedure textwindow(xmin,ymin,xmax,ymax : byte;tipo_borda : boolean);

const contorno : array [false..true,1..6] of char =
                      (('','','','','',''),
                       ('','','','','',''));

var c        : byte;

begin
  window(1,1,80,25);
  gotoxy(xmin-1,ymin-1);
  write(contorno[tipo_borda,1]);
  for c:=xmin to xmax do
    write(contorno[tipo_borda,2]);
  write(contorno[tipo_borda,3]);
  gotoxy(xmin-1,ymax+1);
  write(contorno[tipo_borda,4]);
  for c:=xmin to xmax do
    write(contorno[tipo_borda,2]);
  write(contorno[tipo_borda,5]);
  for c:=ymin to ymax do
  begin
    gotoxy(xmin-1,c);
    write(contorno[tipo_borda,6]);
    gotoxy(xmax+1,c);
    write(contorno[tipo_borda,6]);
  end;
  window(xmin,ymin,xmax,ymax);
  clrscr;
end; (* textwindow *)

function sn : boolean;

var c : char;

begin
     repeat
        c:=upcase(readkey);
     until (c='S') or (c='N');
     write(c);
     sn:= c='S';
end; (* sn *)

procedure readstr(var st : string; tam : byte);

var c     : char;
    x,
    y,
    pos,
    fimst : byte;


procedure mostrastring;
var cont : byte;
begin
     gotoxy(x,y);
     write(st);
     for cont:=length(st) to fimst do
         write(chr(esp));
     gotoxy(x+pos-1,y);
end; (* mostrastring *)

procedure apagapalavra;
var espaco : boolean;
begin
  repeat
    espaco:=st[pos] = ' ';
    if pos = length(st)
       then delete(st,pos,1);
    if pos < length(st)
       then delete(st,pos,1);
  until ((st[pos] <> ' ') and espaco) or (pos = succ(length(st)));
end; (* apagapalavra *)

procedure controle(tecla : char);
begin
     if tecla = null
        then tecla:= readkey;
     case tecla of
          home     : pos:=1;
          fim      : pos:=length(st)+1;
          esquerda : if pos > 1
                       then dec(pos);
          direita  : if pos <= length(st)
                       then inc(pos);
          bs       : if pos > 1 then
                     begin
                       delete(st,pos-1,1);
                       dec(pos)
                     end;
          del      : if pos <= length(st)
                       then delete(st,pos,1);
          ^T       : apagapalavra;
          esc      : begin
                       st:='';
                       mostrastring;
                     end;
     end; (* case *)
end; (* controle *)

begin
     fimst:=tam-1;
     pos:=length(st) +1;
     x:=wherex;
     y:=wherey;
     repeat
       mostrastring;
       c:=readkey;
       case c of
         null,bs,esc,^T  : controle(c);
         enter           : ;
         else if length(st) < tam then
              begin
                insert(c,st,pos);
                inc(pos);
              end
              else beep;
       end; (* case *)
     until (c = esc) or (c = enter)
end; (* readstr *)

procedure readnum(var num : longint; tam : byte);

var c     : char;
    st    : string;
    x,
    y,
    pos   : byte;
    code  : longint;


procedure mostrastring;

begin
  gotoxy(x,y);
  write(st,' ':tam - length(st));
  gotoxy(x+pos-1,y);
end; (* mostrastring *)

procedure controle(tecla : char);
begin
     if tecla = null
        then tecla:= readkey;
     case tecla of
          home     : pos:=1;
          fim      : pos:=length(st)+1;
          esquerda : if pos > 1
                        then dec(pos);
          direita  : if pos <= length(st)
                        then inc(pos);
          bs       : if pos > 1
                        then begin
                             delete(st,pos-1,1);
                             dec(pos)
                             end;
          del      : if pos <= length(st)
                        then delete(st,pos,1);
          esc      : begin
                          st:='';
                          mostrastring;
                     end;
     end; (* case *)
end; (* controle *)

function getvalid : char;
var c : char;
begin
  repeat
    c := readkey;
  until (c in ['0'..'9']) or (c in [null,bs,esc,enter]);
  getvalid:= c;
end; (* getvalid *)

begin
     str(num,st);
     pos:=length(st) +1;
     x:=wherex;
     y:=wherey;
     repeat
           mostrastring;
           c:=getvalid;
           case c of
                null,bs,esc     : controle(c);
                enter           : ;
                else if length(st) < tam
                        then begin
                             insert(c,st,pos);
                             inc(pos);
                             end
                        else beep;
           end; (* case *)
     until (c = esc) or (c = enter);
     val(st,num,code);
end; (* readnum *)

procedure entradata(var data : strdata);

var c,
    col,
    lin,
    z   : integer;
    car : char;

procedure entra;

var x     : integer;
    carac : char;

begin (* entra *)
      gotoxy(c,lin);
      for x:=0 to z do
      begin
        repeat
          carac:=readkey;
        until (carac >= '0') and (carac <='9') or (carac = #13);
        if carac = #13
          then exit;
        gotoxy(c+x,lin);
        write(carac);
        data:=concat(data,carac);
      end; (* for *)
end; (* entra *)

begin (* entradata *)
  col:=wherex;
  lin:=wherey;
  repeat
    data:='';
    gotoxy(col,lin);
    z:=1;
    write('__/__/____');
    c:=col;
    entra;
    if data = '' then exit;
    c:=col+3;
    entra;
    c:=col+6;
    z:=3;
    entra;
    car:=readkey;
  until car=#13;
end; (* entradata *)

procedure tempo_gasto(hi,mi,si,h,m,s : word);

var difhor,
    difmin,
    difseg,
    tempo_inicial,
    tempo_final,
    tempo_total,
    resto           : word;

   function convseg(h,m,s : word) : word;

   begin
     convseg:=h*3600 + m*60 + s;
   end; (* convseg *)

begin
     tempo_inicial:=convseg(hi,mi,si);
     tempo_final:=convseg(h,m,s);
     tempo_total:=tempo_final - tempo_inicial;
     difhor:= tempo_total div 3600;
     resto:=tempo_total - difhor*3600;
     difmin:= resto div 60;
     difseg:=resto - (difmin*60);
     if difhor <> 0
        then write(difhor:2,' hora(s) ');
     if difmin <> 0
        then write(difmin:2,' minuto(s) ');
     if difseg <> 0
        then write(difseg:2,' segundo(s)');
end; (* tempo_gasto *)

procedure beep;
begin
{$IFDEF VIRTUALPASCAL}
  playsound(425,100);
{$ELSE}
  sound(425);
{$ENDIF}
end; (* beep *)

procedure converte(data : strdata; var ano,mes,dia : word);

var sano    : string[4];
    smes,
    sdia    : string[2];
    retorno : longint;

begin
  sano:=copy(data,5,4);
  val(sano,ano,retorno);
  smes:=copy(data,3,2);
  val(smes,mes,retorno);
  sdia:=copy(data,1,2);
  val(sdia,dia,retorno);
end; (* converte *)

procedure ledata(var ano,mes,dia : word);

var data          : strdata;
    dia_da_semana : word;
    x,
    y             : integer;

begin
     x:=wherex;
     y:=wherey;
     repeat
           gotoxy(x,y);
           entradata(data);
           converte(data,ano,mes,dia);
     until (dia>=1) and (dia<=31) and (mes>=1) and (mes<=12) or (data='');
     if data  = ''
        then begin
             getdate(ano,mes,dia,dia_da_semana);
             gotoxy(x,y);
             write(dia:2,'/',mes:2,'/',ano:4)
             end;
end; (* ledata *)

procedure waitesc;

var tec : char;

begin
  repeat
    tec:=readkey;
  until tec = esc;
end; (* waitesc *)

procedure nocursor; (* esconde o cursor *)

var at : word;

begin
  at:=textattr; (* salva cores atuais *)
  textcolor(($70 and at) div 16);
  write(' ',bs);
  textattr:=at;  (* restaura cores *)
end; (* nocursor *)

procedure setcursor(tipo_cursor : boolean);

begin
  (* Compatibilidade com DOS *) 
end; (* setcursor *)


initialization
  textcolor(lightgray);
  textbackground(black);
  esp:=ord(branco);
end. (* mylib *)