/* WorkPlaceCalendar v0.8 */
parse arg parameter
parse source . . ScriptFile

/* week start setup --------------------------*/
weekstart=0 /* 0 = Monday; 1 = Sunday */

/* editor setup -----------------------------*/
editprg="e.exe" /* editor for year calendar objects associated text files */


/* -------------------------------------------*/

if weekstart >< 0 & weekstart >< 1 then do
say 'found invalid week start number, must be 0 or 1'
exit
end


inst_drive = filespec("D", ScriptFile)
inst_path = filespec("P", scriptfile)
installpath=inst_drive||inst_path
iconpath=inst_drive||inst_path||'ICONS\'
termpath=inst_drive||inst_path||'TERMS\'
language = left(Value('Lang',,'OS2ENVIRONMENT'),2)


/* recognize parameter */
parameter=translate(parameter)
/* get date */
parse var parameter '/D:' cur_date .
if cur_date = "" then cur_date = date('S')
/* get mode */
parse var parameter '/Y:' BuildYearCalendar .
parse var parameter '/O:' object_id .
if object_id = "" then object_id = "<WP_Calendar>"
else object_id = "<"||object_id||">"

if rxfuncquery('SysLoadFuncs') then do
 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs
end


objecttext = BuildCalendar(cur_date)

if BuildYearCalendar = 1 then do /* format to 8 lines */
linecount = 0
dummy = objecttext
do until dummy = ""
 parse var dummy . '0d0a'x dummy
 linecount=linecount+1
end

do i = 1 to (10-linecount)
 objecttext = objecttext || '0d0a'x
end
end


parse var objecttext Day ' ' objecttext

Select
when BuildYearCalendar = 1 then dayicon=iconpath||'M'||strip(substr(cur_date, 5,2),'L','0')||'.ico' /* grey ico for month */
when DayOfWeek(substr(cur_date, 7,2)||'.'substr(cur_date, 5,2)||'.'substr(cur_date, 1,4)) = 7 then dayicon=iconpath||'R'||strip(substr(cur_date, 7,2),'L','0')||'.ico' /* red ico for sunday*/
otherwise dayicon=iconpath||'N'||strip(substr(cur_date, 7,2),'L','0')||'.ico' /* blue ico for weekday*/
end


/* create or upgrade object */

if BuildYearCalendar = 1 then do
 targetfolder = "<WPCALENDAR"||strip(substr(cur_date, 1,4))||">"
 file=substr(cur_date,1,4)||'-'||substr(cur_date,5,2)
 call SysCreateObject 'WPProgram',objecttext,targetfolder,,
  'OBJECTID='||object_id||';EXENAME='||editprg||';TITLE='||objecttext||';ICONFILE='||dayicon||';STARTUPDIR='||termpath||';PARAMETERS='||file||';',,
    'Update'
end
else do
 targetfolder = "<WP_DESKTOP>"
 call SysCreateObject 'WPProgram',objecttext,targetfolder,'OBJECTID='||object_id||';EXENAME='||ScriptFile||';TITLE='||objecttext||';ICONFILE='||dayicon||';','Update'
end

exit


BuildCalendar:
PROCEDURE expose language weekstart
arg cur_date

 cur_d = substr(cur_date, 7,2)
 cur_m = substr(cur_date, 5,2)
 cur_y = substr(cur_date, 1,4)
 week = WeekCount(cur_y||cur_m||'01')

 total_days=TotalDaysOfMonth(cur_date)



d1=strip(SysIni("USER", "PM_National", "sDecimal"),'T', '00'x)

Select
when weekstart=0 & language = "de" then string="KW   Mo  Di  Mi  Do  Fr  Sa  So"
when weekstart=1 & language = "de" then string="KW   So  Mo  Di  Mi  Do  Fr  Sa"
when weekstart=0 & language = "fr" then string="s.   Lu  Ma  Me  Je  Ve  Sa  Di"
when weekstart=1 & language = "fr" then string="s.   Di  Lu  Ma  Me  Je  Ve  Sa"
when weekstart=0 & language = "nl" then string="W#.   Ma  Di  Wo  Do  Vr  Za  Zo"
when weekstart=1 & language = "nl" then string="W#.   Zo  Ma  Di  Wo  Do  Vr  Za"
otherwise do
 if weekstart=0 then string ="We   Mo  Tu  We  Th  Fr  Sa  Su"
 else string = "We   Su  Mo  Tu  We  Th  Fr  Sa"
 end
end

string = GetMonth(cur_m) cur_y||'0d0a'x||string||'0d0a'x||right(week,2,'0')||' '

start_col = DayOfWeek('01.'||cur_m||'.'||cur_y)+weekstart

if start_col=8 then start_col=1

do i = 1 to start_col-1
string=string||'  --'
end


do day = 1 to total_days


string = string ||'  '||right(day,2,'0')

if (day + start_col-1)%7 == (day + start_col-1)/7  then do

        week = week + 1
        if day \= total_days then string = string ||'0d0a'x||right(week,2,'0')||' '
        end

/* fill last line */

if day = total_days then do until (day + start_col-1)%7 == (day + start_col-1)/7
if total_days = 31 & start_col=5 then leave
if total_days = 30 & start_col=6 then leave

string=string||'  --'
day = day +1
end

end


return(start_col string)




DayOfWeek: PROCEDURE
parse arg dd '.' mm '.' year

days = "7 1 2 3 4 5 6"

magic = 6 2 3 6 1 4 6 2 5 0 3 5
parse var year cent +2 yr

leap = year // 4 = 0 & (yr\=0 | cent//4=0)
dow=yr + yr%4 + (6-2*(cent//4)) + word(magic,mm) + dd
if mm < 3 & \leap then
   dow=dow+1
dow = dow // 7

return word(days,dow+1)


WeekCount: PROCEDURE expose weekstart
arg cur_date

 cur_d = substr(cur_date, 7,2)
 cur_m = substr(cur_date, 5,2)
 cur_y = substr(cur_date, 1,4)

/* count days from 1.1. to cur_date */
 DaysThisYear = cur_d

if cur_m > 1 then do i = 1 to cur_m - 1
 cur_m = right(i,2,'0')
 DaysThisYear=DaysThisYear+TotalDaysOfMonth(cur_y||cur_m||cur_d)
end

/* calculate weeks */

/* get day of 1.1. */

if weekstart = 1 then DaysOfFirstWeek = 8 - DayOfWeek("01.01."||cur_y)+6
else DaysOfFirstWeek = 8 - DayOfWeek("01.01."||cur_y)


DaysOFFollowingWeeks = DaysThisYear - DaysOfFirstWeek


if DaysOFFollowingWeeks > 0 then do
  if DaysOFFollowingWeeks / 7 == DaysOFFollowingWeeks%7 then DaysOFFollowingWeeks = DaysOFFollowingWeeks%7
  else DaysOFFollowingWeeks = DaysOFFollowingWeeks%7+1
end
else DaysOFFollowingWeeks=0


week = DaysOFFollowingWeeks
if DaysOfFirstWeek = 7 then week = week + 1


return(week)


TotalDaysOfMonth: PROCEDURE
parse arg cur_date

cur_m = substr(cur_date, 5,2)
cur_y = substr(cur_date, 1,4)


if cur_m = "01" | cur_m = "03" | cur_m = "05" | cur_m = "07" | cur_m = "08" | cur_m = "10" | cur_m = "12" then total_days = "31"
if cur_m = "04" | cur_m = "06" | cur_m = "09" | cur_m = "11" then total_days = "30"

if cur_m = "02" | cur_m = "2" then do
 if cur_y / 4 == cur_y%4 then total_days = "29"
 else total_days="28"
end

return(total_days)



GetMonth: Procedure expose language
parse arg cur_m

if language = "de" then Select
when cur_m = 1 then string =  'Januar'
when cur_m = 2 then string =  'Februar'
when cur_m = 3 then string =  'Mrz'
when cur_m = 4 then string =  'April'
when cur_m = 5 then string =  'Mai'
when cur_m = 6 then string =  'Juni'
when cur_m = 7 then string =  'Juli'
when cur_m = 8 then string =  'August'
when cur_m = 9 then string =  'September'
when cur_m = 10 then string = 'Oktober'
when cur_m = 11 then string = 'November'
when cur_m = 12 then string = 'Dezember'
otherwise string = 'Get Month ERROR'
end
if language = "fr" then
Select
  when cur_m = 1 then string =  "Janvier"
  when cur_m = 2 then string =  "Fvrier"
  when cur_m = 3 then string =  "Mars"
  when cur_m = 4 then string =  "Avril"
  when cur_m = 5 then string =  "Mai"
  when cur_m = 6 then string =  "Juin"
  when cur_m = 7 then string =  "Juillet"
  when cur_m = 8 then string =  "Aot"
  when cur_m = 9 then string =  "Septembre"
  when cur_m = 10 then string = "Octobre"
  when cur_m = 11 then string = "Novembre"
  when cur_m = 12 then string = "Dcembre"
  otherwise string = "ERREUR Get Month"
end
if language = "nl" then
Select
  when cur_m = 1 then string =  "Januari"
  when cur_m = 2 then string =  "Februari"
  when cur_m = 3 then string =  "Maart"
  when cur_m = 4 then string =  "April"
  when cur_m = 5 then string =  "Mei"
  when cur_m = 6 then string =  "Juni"
  when cur_m = 7 then string =  "Juli"
  when cur_m = 8 then string =  "Augustus"
  when cur_m = 9 then string =  "September"
  when cur_m = 10 then string = "Oktober"
  when cur_m = 11 then string = "November"
  when cur_m = 12 then string = "December"
  otherwise string = "ERREUR Get Month"
end
if language >< 'de' & language >< 'fr' & language >< 'nl' then Select
when cur_m = 1 then string =  'January'
when cur_m = 2 then string =  'February'
when cur_m = 3 then string =  'March'
when cur_m = 4 then string =  'April'
when cur_m = 5 then string =  'May'
when cur_m = 6 then string =  'June'
when cur_m = 7 then string =  'July'
when cur_m = 8 then string =  'August'
when cur_m = 9 then string =  'September'
when cur_m = 10 then string = 'October'
when cur_m = 11 then string = 'November'
when cur_m = 12 then string = 'December'
otherwise string = 'Get Month ERROR'
end

return(string)
