/* WCPrgObj.Cmd -- create a program object and start-up shadow for World Clock */

   Call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
   Call SysLoadFuncs

   Parse Arg Directory

   If Directory = ''
   Then Do
      Parse Source . . path
      Directory = Left(path, LastPos('\', path) - 1)
   End

   Title = 'World Clock'
   ExeName = 'WldClock.Exe'
   ObjectID = 'WldClock'
   BookName = 'WldClock.Inf'

   FolderSetUp = "OBJECTID=<WldClockFolder>;SETTINGS=YES;ICONVIEW=NORMAL;" || ,
      "ICONFILE=" || Directory || "\WCFolder.Ico" 

   Call SysCreateObject "WPFOLDER", Title, "<WP_DESKTOP>", FolderSetUp, "Update"
   Call SysSetObjectData "<WldClockFolder>", "OPEN=ICONVIEW"

   SetUp = "EXENAME=" || Directory || "\" || ExeName || ";" || ,
      "STARTUPDIR=" || Directory || ";OBJECTID=<" || ObjectID || ">"

   Call SysCreateObject "WPPROGRAM", Title, "<WldClockFolder>", SetUp, "Update"

   WebSetUp = "URL=http://Keystone-Software.com" 
   Call SysCreateObject "WPURL", "Keystone", "<WldClockFolder>", WebSetUp, "Update"
 
   BookSetUp = "EXENAME=VIEW.EXE;PARAMETERS=" || Directory || "\" || BookName
   Call SysCreateObject "WPPROGRAM", "World Clock Book", "<WldClockFolder>", BookSetUp, "Update"
 
   SetUp = "SHADOWID=<" || ObjectID || ">"
   Call SysCreateObject "WPSHADOW", Title, "<WP_START>", SetUp, "Update"
   Return
