#include "PC2.h"
#include "ClockMgr.h"
#include "PicPanel.h"
#include "BMP.h"
#include "Module.h"
#include "MdlMgr.h"
#include "defines.h"
#include <stdlib.h>
#include <unistd.h>


ClockManager :: ClockManager( HAB hab, PSZ iniFile )
{
    this->hini = PrfOpenProfile( hab, iniFile==NULL ? "PC2.INI" : iniFile );
    this->hab = hab;
    this->selecter = NULL;

    PicturePanel* pic =
	new PicturePanel( this, hab, HWND_DESKTOP, WS_ANIMATE );
    this->panel = pic;
    pic->init( this->hini );
    WinSetWindowText( pic->HwndFrame(), "Picture Clock / 2 V1.0" );

    for( int i=0; i<MAX_MODULES; i++ ) this->module[i] = NULL;

    if( this->hini == NULLHANDLE ){
	this->bitmap = new BMP( hab, DEFAULT_BMP );
	pic->pictureChanged();

	this->module[0] = new Module( this, hab, pic->HwndClient() );
	this->modules = 1;
	((Module*)this->module[0])->init( "DEFAULT.DLL", NULLHANDLE );
	WinSetWindowPos(
	    ((Module*)(this->module[0]))->HwndFrame(),
	    HWND_TOP,
	    0, 0, 100, 100,
	    SWP_NOADJUST | SWP_SIZE | SWP_MOVE | SWP_SHOW | SWP_ZORDER);
    }else{
      this->bitmap = new BMP( hab, (unsigned char*)NULL );
      ((BMP*)this->bitmap)->init( hab, this->hini );
      pic->pictureChanged();

printf( "Wallpaper loaded.\n" ); fflush( stdout );

      // o^Ă郂W[[h
      char string[10240];
      char *cp = string;
      char moduleName[1024];
      char *moduleFileName;

      getcwd( moduleName, 1024 );
      moduleFileName = moduleName + strlen(moduleName);
      *moduleFileName = '\\';
      moduleFileName++;
printf( "Current directory : %s.\n", moduleName ); fflush( stdout );

      PrfQueryProfileString(
	this->hini, PRF_APPNAME, PRF_MODULELIST,
        DEFAULT_MODULENAME, string, 10240 );
printf( "DLL list %s.\n", string ); fflush( stdout );
      for( int i=0; i<MAX_MODULES; i++ ){
	this->modules = i;
	if( *cp == '\0' ) break;
	sscanf( cp, "%[^ \0]", moduleFileName );
	for( ; *cp != ' ' && *cp != '\0'; cp++ );
	for( ; *cp == ' ' && *cp != '\0'; cp++ );
	this->module[i] = new Module( this, this->hab, pic->HwndClient() );
	((Module*)this->module[i])->init( moduleName, this->hini );
	if( ((Module*)this->module[i])->isReady() == FALSE){
	  delete this->module[i];
	  i--;
	  continue;
	}
printf( "Module %s loaded.(left:%s)\n", moduleName, cp ); fflush( stdout );
      }

printf( "Number of Module %d.\n", this->modules ); fflush( stdout );
    }

}


ClockManager :: ~ClockManager()
{
  PrfCloseProfile( this->hini );
  for( int i=0; i<this->modules; i++ ) delete ((Module*)this->module[i]);
  delete this->panel;
  delete this->bitmap;
}


void ClockManager :: saveSettings()
{
  if( MBID_YES == WinMessageBox(
				HWND_DESKTOP,
				((PicturePanel*)(this->panel))->HwndClient(),
				"ݒۑ܂",
				"Picture Clock / 2",
				0,
				MB_YESNO | MB_ICONQUESTION | MB_APPLMODAL ) )
    {
      ((PicturePanel*)(this->panel))->writeIni( this->hini );
      ((BMP*)(this->bitmap))->writeIni( this->hini );
      for( int i=0; i<this->modules; i++ )
	((Module*)(this->module[i]))->writeIni( this->hini );
    }
}


void ClockManager :: openModuleSelecter()
{
  if( this->selecter == NULL )
    (ModuleManager*)(this->selecter) =
      new ModuleManager( this, this->hab, this->hini );
  else
    WinSetActiveWindow
      ( HWND_DESKTOP, ((ModuleManager*)this->selecter)->HwndFrame() );
}


void ClockManager :: closeModuleSelecter()
{
  delete ((ModuleManager*)this->selecter);
  this->selecter = NULL;
}
