#include "Module.h"
#include "DLModule.h"
#include "PicPanel.h"
#include <stdlib.h>

Module :: Module( ClockManager* mgr, HAB hab, HWND parent )
    : TransparentWindow( mgr, hab, parent )
{
  this->module.size = sizeof(ModuleInfo);
  DosGetDateTime( &(this->module.datetime) );
  this->module.hwndFrame = this->hwndFrame;
  this->module.hwndClient = this->hwndClient;
  SWP swp;
  WinQueryWindowPos( this->hwndClient, &swp );
  this->module.width = swp.cx;
  this->module.height = swp.cy;
  this->module.buffer = new char[MODULE_BUFFERSIZE];

  this->hlib = NULLHANDLE;
  pPC2ModuleProcedure = NULL;
};


Module :: ~Module()
{
    this->PC2terminate( &(this->module) );
    if( this->hlib != NULLHANDLE ) WinDeleteLibrary( this->hab, this->hlib );
    delete this->module.buffer;
};


MRESULT EXPENTRY Module :: clientProc
	( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch( msg ){
  case WM_PAINT:
    {
      //	if( transFrame == FALSE ) break;
      HPS localHps = WinBeginPaint( this->hwndClient, NULLHANDLE, NULL );
      GpiErase( localHps );
      if( transClient == TRUE ) this->makeTransparent( localHps, TRUE );
      SWP swp;
      WinQueryWindowPos( this->hwndClient, &swp );
      this->drawTime( localHps, (ULONG)swp.cx, (ULONG)swp.cy );
      WinEndPaint( localHps );
      return (MRESULT)0;
    }

  case WM_TIMER:
    {
      DATETIME datetime;
      DosGetDateTime( &(this->module.datetime) );
      ULONG trg = this->trigger();
      this->transClient = ( trg & TRG_NODRAWBACK ) ? FALSE : TRUE;
      this->transFrame = ( trg & TRG_DRAWFRAME ) ? FALSE : TRUE;
      if( trg & TRG_CALLDRAW ){
	if( this->transFrame == FALSE )
	  WinInvalidateRect( this->hwndFrame, NULL, FALSE );
	WinInvalidateRect( this->hwndClient, NULL, FALSE );
      }
      return (MRESULT)0;
    }

  case WM_BUTTON1DBLCLK:
    WinPostMsg( this->hwndFrame, WM_QUIT, 0, 0 );
    return (MRESULT)TRUE;

  case WM_BUTTON2DOWN:
    WinPostMsg(((PicturePanel*)manager->Panel())->HwndClient(),
	       WM_BUTTON2DOWN, mp1, mp2 );
    return 0;

  case DM_DRAGOVER:
  case DM_DROP:
    return WinSendMsg
      (((PicturePanel*)manager->Panel())->HwndClient(), msg, mp1, mp2 );
  }

    return TransparentWindow :: clientProc( hwnd, msg, mp1, mp2 );
}


void Module :: drawTime( HPS hps, ULONG width, ULONG height )
{
    this->module.width = width;
    this->module.height = height;
    this->PC2drawTime( hps, &module );
}


ULONG Module :: trigger()
{
    return this->PC2trigger( &(this->module) );
}


void Module :: init( PSZ DLLname, HINI hini )
{
    // Load DLL
    if( this->hlib == NULLHANDLE ) WinDeleteLibrary( this->hab, this->hlib );

    if(NULLHANDLE==(this->hlib=WinLoadLibrary( this->hab, DLLname )) ) return;

    // Load procudure
    if( NULL == (this->pPC2ModuleProcedure =
	(MRESULT APIENTRY (*)( HWND, ULONG, MPARAM, MPARAM ))
	WinLoadProcedure( this->hab, this->hlib, "PC2ModuleProcedure" ) ) )
	{
	WinDeleteLibrary( this->hab, this->hlib );
	this->hlib == NULLHANDLE;
	return;
	}
    this->PC2init( hini, &(this->module) );

    ULONG state = LONGFROMMR((*pPC2ModuleProcedure)
			     (this->hwndClient, MDL_STATE, 0, 0 ));
    if( state & MDLSTATE_HIDE )
      WinSetWindowPos( this->hwndFrame, HWND_TOP, -100, -100 , 0, 0,
		       SWP_NOADJUST | SWP_SIZE | SWP_MOVE | SWP_SHOW );
}


void Module :: writeIni( HINI hini )
{
    this->PC2saveSettings( hini, &(this->module) );
}
