/* InstLang.cmd - Install language support for World Clock */

IF RxFuncQuery('SysLoadFuncs') THEN DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
END

CALL SysCls
progname = 'World Clock 1.4.0'
inifile = 'WCLOCK.INI'
IF STREAM(inifile,'C','QUERY EXISTS') = "" THEN DO
    SAY 'Problem! '||inifile||' file does not exist.'
    SAY 'Did you install '||progname||'?'
    SAY 'Press Enter to exit and correct error.'
    PULL answer
    Exit
END

SAY 'This procedure will add Language support for '||progname||':'
SAY 'Croatian, French, German, Slovenian and Swedish.'
SAY 'Press "Y" to start Installation, any other key to exit...'
ans = TRANSLATE(SysGetKey('ECHO'))
SELECT
    WHEN ans = 'Y' THEN NOP
    OTHERWISE CALL NoAction 'Installation aborted.'
END

SAY ' '
CALL SysIni inifile, 'Language', 'CROATIAN', 'English.inf'
CALL SysIni inifile, 'Language', 'DUTCH', 'Dutch.inf'
CALL SysIni inifile, 'Language', 'FRENCH', 'French.inf'
CALL SysIni inifile, 'Language', 'GERMAN', 'English.inf'
CALL SysIni inifile, 'Language', 'SLOVENIA', 'English.inf'
CALL SysIni inifile, 'Language', 'SWEDISH', 'Swedish.inf'

SAY ' '
InstallDir = Directory()
obj_tit.1 = 'Read me 1st^(Dutch)'
obj_set.1 = 'OBJECTID=<WCLOCK140_1STDUT>;EXENAME=E.exe;PARAMETERS='InstallDir'\ReadNl.1st;STARTUPDIR='InstallDir''
obj_tit.2 = 'Read me 1st^(French)'
obj_set.2 = 'OBJECTID=<WCLOCK140_1STFRE>;EXENAME=E.exe;PARAMETERS='InstallDir'\ReadFr.1st;STARTUPDIR='InstallDir''
obj_tit.3 = 'Read me 1st^(Swedish)'
obj_set.3 = 'OBJECTID=<WCLOCK140_1STSWE>;EXENAME=E.exe;PARAMETERS='InstallDir'\ReadSwe.1st;STARTUPDIR='InstallDir''
obj_tit.4 = progname||'^History (Dutch)'
obj_set.4 = 'OBJECTID=<WCLOCK140_HSTDUT>;EXENAME=E.exe;PARAMETERS='InstallDir'\HistNl.txt;STARTUPDIR='InstallDir''
obj_tit.5 = progname||'^History (French)'
obj_set.5 = 'OBJECTID=<WCLOCK140_HSTFRE>;EXENAME=E.exe;PARAMETERS='InstallDir'\HistFr.txt;STARTUPDIR='InstallDir''
obj_tit.6 = progname||'^History (Swedish)'
obj_set.6 = 'OBJECTID=<WCLOCK140_HSTSWE>;EXENAME=E.exe;PARAMETERS='InstallDir'\HistSwe.txt;STARTUPDIR='InstallDir''
obj_tit.7 = progname||'^manual (Dutch)'
obj_set.7 = 'OBJECTID=<WCLOCK140_HLPDUT>;EXENAME=View.exe;PARAMETERS='InstallDir'\Dutch.inf;STARTUPDIR='InstallDir''
obj_tit.8 = progname||'^manual (French)'
obj_set.8 = 'OBJECTID=<WCLOCK140_HLPFRE>;EXENAME=View.exe;PARAMETERS='InstallDir'\French.inf;STARTUPDIR='InstallDir''
obj_tit.9 = progname||'^manual (Swedish)'
obj_set.9 = 'OBJECTID=<WCLOCK140_HLPSWE>;EXENAME=View.exe;PARAMETERS='InstallDir'\Swedish.inf;STARTUPDIR='InstallDir''
objects.0 = 9
DO i = 1 TO objects.0
    dummy = SysCreateObject('WPProgram',obj_tit.i,'<WCLOCK140_FOLDER>',obj_set.i,'U')
    SAY TRANSLATE(obj_tit.i,' ','^')||' - '||rc1(dummy)
END

SAY ' '
SAY 'Installation finished! Press Enter to exit ...'
PULL answer
CALL SysCls
Exit

/* NoAction - abort Install */

NoAction:   PROCEDURE

PARSE ARG noinstmsg
SAY ' '
SAY noinstmsg
SAY 'Press any key to exit ...'
ans = SysGetKey('NOECHO')
Exit

/* End of NoAction */

/* rc1 - return code - SysCreateObject */

rc1:        PROCEDURE

PARSE ARG rcSysCreateObject
SELECT
    WHEN rcSysCreateObject = 0 THEN rc1 = 'Error'
    OTHERWISE rc1 = 'OK'
END
RETURN rc1

/* End of rc1 */

/* EOF InstLang.cmd */

