/* alwcnvrt.c */

#include <stdio.h>
#include <string.h>

#include "../../../units/common.src/bastypes.h"
#include "../../../units/common.src/os.h"

#define USHORT unsigned short
#define ULONG unsigned long
#define UCHAR unsigned char

#pragma pack(1)

typedef  union {
  long llaenge;
  UCHAR claenge[4];
}lwandel;

typedef  struct {
   char ckid[4];
   ULONG cksize;
   char fccType[4];
   char chu3[4];
   ULONG csize2;
   USHORT          usFormatTag;              /* Type of wave format */
   USHORT          usChannels;               /* Number of channels  */
   ULONG           ulSamplesPerSec;          /* Sampling rate       */
   ULONG           ulAvgBytesPerSec;         /* Avg bytes per sec   */
   USHORT          usBlockAlign;             /* Block Alignment in bytes */
   USHORT          usBitsPerSample;          /* Bits per sample     */
   char chu4[4];
   ULONG csize3;
   }chutyp;

typedef _Packed struct {
   char ckid[4];
   ULONG cksize;
   char fccType[4];
   char chu3[4];
   ULONG csize2;
   USHORT          usFormatTag;              /* Type of wave format */
   USHORT          usChannels;               /* Number of channels  */
   ULONG           ulSamplesPerSec;          /* Sampling rate       */
   ULONG           ulAvgBytesPerSec;         /* Avg bytes per sec   */
   USHORT          usBlockAlign;             /* Block Alignment in bytes */
   USHORT          usBitsPerSample;          /* Bits per sample     */
   USHORT          notknown;
   char chu4[4];
   ULONG csize3;
   ULONG csize4;
   char chu5[4];
   ULONG csize5;
   }chutyp2;

chutyp2 HeaderA={
{'R','I','F','F'}, /* Chunk id (FOURCC)                    */
0x00000000L,  /* Chunk Size (bytes)                   */
{'W','A','V','E'},
{'f','m','t',' '}, /* Chunk id (FOURCC)                    */
18L,   /* Chunk Size (bytes)                   */
0x0006,  /* Type of wave format */
1,   /* Number of channels  */
8000L,   /* Sampling rate       */
8000L,   /* Avg bytes per sec   */
1,   /* Block Alignment in bytes */
8,   /* Bits per sample     */
0,
{'f','a','c','t'}, /* Chunk id (FOURCC)                    */
4L,   /* Chunk Size (bytes)                   */
0x00000000L,  /* Chunk Size (bytes)                   */
{'d','a','t','a'}, /* Chunk id (FOURCC)                    */
0x00000000L  /* Chunk Size (bytes)                   */
};

chutyp Header8={
{'R','I','F','F'}, /* Chunk id (FOURCC)                    */
0x00000024L,  /* Chunk Size (bytes)                   */
{'W','A','V','E'},
{'f','m','t',' '}, /* Chunk id (FOURCC)                    */
16L,   /* Chunk Size (bytes)                   */
0x0001,  /* Type of wave format */
1,   /* Number of channels  */
8000L,   /* Sampling rate       */
8000L,   /* Avg bytes per sec   */
1,   /* Block Alignment in bytes */
8,   /* Bits per sample     */
{'d','a','t','a'}, /* Chunk id (FOURCC)                    */
0x00000000L  /* Chunk Size (bytes)                   */
};


chutyp Header16={
{'R','I','F','F'}, /* Chunk id (FOURCC)                    */
0x00000024L,  /* Chunk Size (bytes)                   */
{'W','A','V','E'},
{'f','m','t',' '}, /* Chunk id (FOURCC)                    */
16L,   /* Chunk Size (bytes)                   */
0x0001,  /* Type of wave format */
1,   /* Number of channels  */
8000L,   /* Sampling rate       */
16000L,   /* Avg bytes per sec   */
2,   /* Block Alignment in bytes */
16,   /* Bits per sample     */
{'d','a','t','a'}, /* Chunk id (FOURCC)                    */
0x00000000L  /* Chunk Size (bytes)                   */
};

UCHAR auheader[]={
'.' ,'s' ,'n' ,'d' ,0x00,0x00,0x00,0x1C,0x12,0x34,0x56,0x78,0x00,0x00,0x00,0x01,
0x00,0x00,0x1F,0x40,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00
};

UCHAR reverse_byte1[256]={
0x00,0x80,0x40,0xC0,0x20,0xA0,0x60,0xE0,0x10,0x90,0x50,0xD0,0x30,0xB0,0x70,0xF0,
0x08,0x88,0x48,0xC8,0x28,0xA8,0x68,0xE8,0x18,0x98,0x58,0xD8,0x38,0xB8,0x78,0xF8,
0x04,0x84,0x44,0xC4,0x24,0xA4,0x64,0xE4,0x14,0x94,0x54,0xD4,0x34,0xB4,0x74,0xF4,
0x0C,0x8C,0x4C,0xCC,0x2C,0xAC,0x6C,0xEC,0x1C,0x9C,0x5C,0xDC,0x3C,0xBC,0x7C,0xFC,
0x02,0x82,0x42,0xC2,0x22,0xA2,0x62,0xE2,0x12,0x92,0x52,0xD2,0x32,0xB2,0x72,0xF2,
0x0A,0x8A,0x4A,0xCA,0x2A,0xAA,0x6A,0xEA,0x1A,0x9A,0x5A,0xDA,0x3A,0xBA,0x7A,0xFA,
0x06,0x86,0x46,0xC6,0x26,0xA6,0x66,0xE6,0x16,0x96,0x56,0xD6,0x36,0xB6,0x76,0xF6,
0x0E,0x8E,0x4E,0xCE,0x2E,0xAE,0x6E,0xEE,0x1E,0x9E,0x5E,0xDE,0x3E,0xBE,0x7E,0xFE,
0x01,0x81,0x41,0xC1,0x21,0xA1,0x61,0xE1,0x11,0x91,0x51,0xD1,0x31,0xB1,0x71,0xF1,
0x09,0x89,0x49,0xC9,0x29,0xA9,0x69,0xE9,0x19,0x99,0x59,0xD9,0x39,0xB9,0x79,0xF9,
0x05,0x85,0x45,0xC5,0x25,0xA5,0x65,0xE5,0x15,0x95,0x55,0xD5,0x35,0xB5,0x75,0xF5,
0x0D,0x8D,0x4D,0xCD,0x2D,0xAD,0x6D,0xED,0x1D,0x9D,0x5D,0xDD,0x3D,0xBD,0x7D,0xFD,
0x03,0x83,0x43,0xC3,0x23,0xA3,0x63,0xE3,0x13,0x93,0x53,0xD3,0x33,0xB3,0x73,0xF3,
0x0B,0x8B,0x4B,0xCB,0x2B,0xAB,0x6B,0xEB,0x1B,0x9B,0x5B,0xDB,0x3B,0xBB,0x7B,0xFB,
0x07,0x87,0x47,0xC7,0x27,0xA7,0x67,0xE7,0x17,0x97,0x57,0xD7,0x37,0xB7,0x77,0xF7,
0x0F,0x8F,0x4F,0xCF,0x2F,0xAF,0x6F,0xEF,0x1F,0x9F,0x5F,0xDF,0x3F,0xBF,0x7F,0xFF
};

UCHAR al2ul[256]={
0x2A,0x2B,0x28,0x29,0x2E,0x2F,0x2C,0x2D,0x22,0x23,0x20,0x21,0x26,0x27,0x24,0x25,
0x39,0x3A,0x37,0x38,0x3D,0x3E,0x3B,0x3C,0x31,0x32,0x30,0x30,0x35,0x36,0x33,0x34,
0x0A,0x0B,0x08,0x09,0x0E,0x0F,0x0C,0x0D,0x02,0x03,0x00,0x01,0x06,0x07,0x04,0x05,
0x1A,0x1B,0x18,0x19,0x1E,0x1F,0x1C,0x1D,0x12,0x13,0x10,0x11,0x16,0x17,0x14,0x15,
0x62,0x63,0x60,0x61,0x66,0x67,0x64,0x65,0x5D,0x5D,0x5C,0x5C,0x5F,0x5F,0x5E,0x5E,
0x74,0x76,0x70,0x72,0x7C,0x7E,0x78,0x7A,0x6A,0x6B,0x68,0x69,0x6E,0x6F,0x6C,0x6D,
0x48,0x49,0x46,0x47,0x4C,0x4D,0x4A,0x4B,0x40,0x41,0x3F,0x3F,0x44,0x45,0x42,0x43,
0x56,0x57,0x54,0x55,0x5A,0x5B,0x58,0x59,0x4F,0x4F,0x4E,0x4E,0x52,0x53,0x50,0x51,
0xAA,0xAB,0xA8,0xA9,0xAE,0xAF,0xAC,0xAD,0xA2,0xA3,0xA0,0xA1,0xA6,0xA7,0xA4,0xA5,
0xB9,0xBA,0xB7,0xB8,0xBD,0xBE,0xBB,0xBC,0xB1,0xB2,0xB0,0xB0,0xB5,0xB6,0xB3,0xB4,
0x8A,0x8B,0x88,0x89,0x8E,0x8F,0x8C,0x8D,0x82,0x83,0x80,0x81,0x86,0x87,0x84,0x85,
0x9A,0x9B,0x98,0x99,0x9E,0x9F,0x9C,0x9D,0x92,0x93,0x90,0x91,0x96,0x97,0x94,0x95,
0xE2,0xE3,0xE0,0xE1,0xE6,0xE7,0xE4,0xE5,0xDD,0xDD,0xDC,0xDC,0xDF,0xDF,0xDE,0xDE,
0xF4,0xF6,0xF0,0xF2,0xFC,0xFE,0xF8,0xFA,0xEA,0xEB,0xE8,0xE9,0xEE,0xEF,0xEC,0xED,
0xC8,0xC9,0xC6,0xC7,0xCC,0xCD,0xCA,0xCB,0xC0,0xC1,0xBF,0xBF,0xC4,0xC5,0xC2,0xC3,
0xD6,0xD7,0xD4,0xD5,0xDA,0xDB,0xD8,0xD9,0xCF,0xCF,0xCE,0xCE,0xD2,0xD3,0xD0,0xD1
};

short ral2wav[256]={
(short)0xEA80,(short)0x1580,(short)0xFEA8,(short)0x0158,(short)0xAA00,(short)0x5600,(short)0xFAA0,(short)0x0560,
(short)0xF540,(short)0x0AC0,(short)0xFFA8,(short)0x0058,(short)0xD500,(short)0x2B00,(short)0xFD50,(short)0x02B0,
(short)0xE280,(short)0x1D80,(short)0xFE28,(short)0x01D8,(short)0x8A00,(short)0x7600,(short)0xF8A0,(short)0x0760,
(short)0xF140,(short)0x0EC0,(short)0xFF28,(short)0x00D8,(short)0xC500,(short)0x3B00,(short)0xFC50,(short)0x03B0,
(short)0xEE80,(short)0x1180,(short)0xFEE8,(short)0x0118,(short)0xBA00,(short)0x4600,(short)0xFBA0,(short)0x0460,
(short)0xF740,(short)0x08C0,(short)0xFFE8,(short)0x0018,(short)0xDD00,(short)0x2300,(short)0xFDD0,(short)0x0230,
(short)0xE680,(short)0x1980,(short)0xFE68,(short)0x0198,(short)0x9A00,(short)0x6600,(short)0xF9A0,(short)0x0660,
(short)0xF340,(short)0x0CC0,(short)0xFF68,(short)0x0098,(short)0xCD00,(short)0x3300,(short)0xFCD0,(short)0x0330,
(short)0xE880,(short)0x1780,(short)0xFE88,(short)0x0178,(short)0xA200,(short)0x5E00,(short)0xFA20,(short)0x05E0,
(short)0xF440,(short)0x0BC0,(short)0xFF88,(short)0x0078,(short)0xD100,(short)0x2F00,(short)0xFD10,(short)0x02F0,
(short)0xE080,(short)0x1F80,(short)0xFE08,(short)0x01F8,(short)0x8200,(short)0x7E00,(short)0xF820,(short)0x07E0,
(short)0xF040,(short)0x0FC0,(short)0xFF08,(short)0x00F8,(short)0xC100,(short)0x3F00,(short)0xFC10,(short)0x03F0,
(short)0xEC80,(short)0x1380,(short)0xFEC8,(short)0x0138,(short)0xB200,(short)0x4E00,(short)0xFB20,(short)0x04E0,
(short)0xF640,(short)0x09C0,(short)0xFFC8,(short)0x0038,(short)0xD900,(short)0x2700,(short)0xFD90,(short)0x0270,
(short)0xE480,(short)0x1B80,(short)0xFE48,(short)0x01B8,(short)0x9200,(short)0x6E00,(short)0xF920,(short)0x06E0,
(short)0xF240,(short)0x0DC0,(short)0xFF48,(short)0x00B8,(short)0xC900,(short)0x3700,(short)0xFC90,(short)0x0370,
(short)0xEB80,(short)0x1480,(short)0xFEB8,(short)0x0148,(short)0xAE00,(short)0x5200,(short)0xFAE0,(short)0x0520,
(short)0xF5C0,(short)0x0A40,(short)0xFFB8,(short)0x0048,(short)0xD700,(short)0x2900,(short)0xFD70,(short)0x0290,
(short)0xE380,(short)0x1C80,(short)0xFE38,(short)0x01C8,(short)0x8E00,(short)0x7200,(short)0xF8E0,(short)0x0720,
(short)0xF1C0,(short)0x0E40,(short)0xFF38,(short)0x00C8,(short)0xC700,(short)0x3900,(short)0xFC70,(short)0x0390,
(short)0xEF80,(short)0x1080,(short)0xFEF8,(short)0x0108,(short)0xBE00,(short)0x4200,(short)0xFBE0,(short)0x0420,
(short)0xF7C0,(short)0x0840,(short)0xFFF8,(short)0x0008,(short)0xDF00,(short)0x2100,(short)0xFDF0,(short)0x0210,
(short)0xE780,(short)0x1880,(short)0xFE78,(short)0x0188,(short)0x9E00,(short)0x6200,(short)0xF9E0,(short)0x0620,
(short)0xF3C0,(short)0x0C40,(short)0xFF78,(short)0x0088,(short)0xCF00,(short)0x3100,(short)0xFCF0,(short)0x0310,
(short)0xE980,(short)0x1680,(short)0xFE98,(short)0x0168,(short)0xA600,(short)0x5A00,(short)0xFA60,(short)0x05A0,
(short)0xF4C0,(short)0x0B40,(short)0xFF98,(short)0x0068,(short)0xD300,(short)0x2D00,(short)0xFD30,(short)0x02D0,
(short)0xE180,(short)0x1E80,(short)0xFE18,(short)0x01E8,(short)0x8600,(short)0x7A00,(short)0xF860,(short)0x07A0,
(short)0xF0C0,(short)0x0F40,(short)0xFF18,(short)0x00E8,(short)0xC300,(short)0x3D00,(short)0xFC30,(short)0x03D0,
(short)0xED80,(short)0x1280,(short)0xFED8,(short)0x0128,(short)0xB600,(short)0x4A00,(short)0xFB60,(short)0x04A0,
(short)0xF6C0,(short)0x0940,(short)0xFFD8,(short)0x0028,(short)0xDB00,(short)0x2500,(short)0xFDB0,(short)0x0250,
(short)0xE580,(short)0x1A80,(short)0xFE58,(short)0x01A8,(short)0x9600,(short)0x6A00,(short)0xF960,(short)0x06A0,
(short)0xF2C0,(short)0x0D40,(short)0xFF58,(short)0x00A8,(short)0xCB00,(short)0x3500,(short)0xFCB0,(short)0x0350};

void alw2wav (char *inname, char *outname, short mode)

 {
    FILE *instr,*outstr;
    unsigned char acha;
    lwandel laenge;
    long uu;

    instr  = fopen(inname , "rb");
    outstr = fopen(outname, "wb");

    fseek(instr,0L,SEEK_END);
    laenge.llaenge=ftell(instr);
    fseek(instr,0L,SEEK_SET);

    switch(mode)
      {
      case 0:
        Header16.cksize=laenge.llaenge*2+sizeof(Header16)-8;
        Header16.csize3=laenge.llaenge*2;
        fwrite(&Header16, sizeof(Header16), 1, outstr);
        fread(&acha,sizeof(acha),1,instr);
        while(!feof(instr))
          {
          fwrite(ral2wav+acha, 2, 1, outstr);
          fread(&acha,sizeof(acha),1,instr);
          }
        break;
      case 1:
        Header8.cksize=laenge.llaenge+sizeof(Header8)-8;
        Header8.csize3=laenge.llaenge;
        fwrite(&Header8, sizeof(Header8), 1, outstr);
        fread(&acha,sizeof(acha),1,instr);
        while(!feof(instr))
          {
          uu=128+*((char*)(ral2wav+acha)+1);
          fwrite(((char*)&uu), 1, 1, outstr);
          fread(&acha,sizeof(acha),1,instr);
          }
        break;
      case 2:
        HeaderA.cksize=laenge.llaenge+sizeof(HeaderA)-8;
        HeaderA.csize4=HeaderA.csize5=laenge.llaenge;
        fwrite(&HeaderA, sizeof(HeaderA), 1, outstr);
        fread(&acha,sizeof(acha),1,instr);
        while(!feof(instr))
          {
          fwrite(reverse_byte1+acha, 1, 1, outstr);
          fread(&acha,sizeof(acha),1,instr);
          }
        break;
      case 3:
        auheader[8]=laenge.claenge[0];
        auheader[9]=laenge.claenge[1];
        auheader[10]=laenge.claenge[2];
        auheader[11]=laenge.claenge[3];
        fwrite(&auheader, sizeof(auheader), 1, outstr);
        fread(&acha,sizeof(acha),1,instr);
        while(!feof(instr))
          {
          fwrite(al2ul+reverse_byte1[acha], 1, 1, outstr);
          fread(&acha,sizeof(acha),1,instr);
          }
        break;
      }

    fclose (instr);
    fclose (outstr);

    return;
 }
