#include <string.h>

#include "bastypes.h"
#include "com.h"
#include "comdisp.h"
#include "v24util.h"
#include "loadcapi.h"
#include "capi20.h"
#include "os.h"

#define COM_SEARCH_COM_FROM   1
#define COM_SEARCH_COM_TO     16

typedef enum { eNo, eEven, eMark, eOdd, eSpace } tParity;
typedef enum { eOne, eOne5, eTwo } tStopBits;

typedef struct sOptModem                    /* options for modem-connection */
{
  tU32 iDataBits;                           /* data-bits                    */
  tParity eParity;                          /* parity                       */
  tStopBits eStopBits;                      /* stop                         */
  tU8 cModemInit[128];                      /* init-string                  */
  tU8 cModemDial[128];                      /* dial-string                  */
}
tOptModem;


typedef struct sOptCapi                     /* options for capi-connection  */
{
  tU32 iDummyCapiOption;                    /* dummy-option                 */
}
tOptCapi;


typedef struct sComOpt                      /* options for a connection     */
{
  tDevType eDevType;                        /* type of device               */
  union                                     /* union containing options     */
  {
    tOptModem sModem;                       /* modem-options                */
    tOptCapi sCapi;                         /* capi-options                 */
  }
  uOpt;
}
tComOpt;

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComInit     ()
{
  return (xComDispInit());
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComExit     ()
{
  return (xComDispExit());
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComOpenDev (tComDevHandle *pDevHandle, tComEnumDev *pComDev)
{
  return (xComDispOpenDev(pDevHandle, pComDev));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComCloseDev (tComDevHandle DevHandle)
{
  return (xComDispCloseDev (DevHandle));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComConnect (tComDevHandle DevHandle, tU8* pDial)
{
  return (xComDispConnect (DevHandle, pDial));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComDisconnect (tComDevHandle DevHandle)
{
  return (xComDispDisconnect (DevHandle));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComWriteBlock (tComDevHandle DevHandle, tU8* pData, tU32 iLen , tU32 iWait)
{
  return (xComDispWriteBlock (DevHandle, pData, iLen , iWait));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComReadBlock (tComDevHandle DevHandle, tU8* pData, tU32 iLen, tU32 iWait)
{
  return (xComDispReadBlock (DevHandle, pData, iLen, iWait));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComReadDataAvailable (tComDevHandle   DevHandle)
{
  return (xComDispReadDataAvailable (DevHandle));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComCanWrite          (tComDevHandle   DevHandle)
{
  return (xComDispCanWrite(DevHandle));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComClearRxBuff       (tComDevHandle   DevHandle)
{
  return (xComDispClearRxBuff(DevHandle));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComClearTxBuff       (tComDevHandle   DevHandle)
{
  return (xComDispClearTxBuff(DevHandle));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComSetDiscIndCallback (tComDevHandle DevHandle, void (*ProcAddrParm)(void))
{
  return (xComDispSetDiscIndCallback (DevHandle, ProcAddrParm));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComSetConnIndCallback (tComDevHandle DevHandle, void (*ProcAddrParm)(void))
{
  return (xComDispSetConnIndCallback (DevHandle, ProcAddrParm));
}

/*===========================================================================
===========================================================================*/
/*===========================================================================
===========================================================================*/
/*===========================================================================
===========================================================================*/
/*===========================================================================
===========================================================================*/
/*===========================================================================
===========================================================================*/
/*===========================================================================
===========================================================================*/

tU32 xComGetProtName        (char* ProtName   , tProtType ProtType)
{
  switch (ProtType)
  {
  case eSms_D1            : strcpy (ProtName, NAME_ESMS_D1           ); break;
  case eSms_D2            : strcpy (ProtName, NAME_ESMS_D2           ); break;
  case eSms_Eplus         : strcpy (ProtName, NAME_ESMS_EPLUS        ); break;
  case eHdlc_X75_Trans    : strcpy (ProtName, NAME_EHDLC_X75_TRANS   ); break;
  case eHdlc_X75_T70nl    : strcpy (ProtName, NAME_EHDLC_X75_T70NL   ); break;
  case eHdlc_Trans_Trans  : strcpy (ProtName, NAME_EHDLC_TRANS_TRANS ); break;
  case eTrans_Trans_Trans : strcpy (ProtName, NAME_ETRANS_TRANS_TRANS); break;
  case eModem             : strcpy (ProtName, NAME_EMODEM            ); break;
  default                 : strcpy (ProtName, NAME_E_NO_PROT         ); break;
  }
  return (0);
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComGetDevTypeName     (char* DevTypeName, tDevType  DevType )
{
  switch (DevType)
  {
    case    eTaModem : strcpy (DevTypeName, NAME_TA_MODEM    ); break;
    case    eCapi20  : strcpy (DevTypeName, NAME_CAPI_20     ); break;
    case    eTapi    : strcpy (DevTypeName, NAME_TAPI        ); break;
    case    eTcpIp   : strcpy (DevTypeName, NAME_TCP_IP      ); break;
    case    ePipe    : strcpy (DevTypeName, NAME_PIPE        ); break;
    default          : strcpy (DevTypeName, NAME_E_NO_DEVTYPE); break;
  }
  return (0);
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComEnumDev  (tComEnumDev* pComDev, tU32 iNum)
{
  tU8 DevCnt=0;
  tU8 i;
  tU8 ComPort[200];
  tU8 DevDsc [200];
  tU8 help [2000];

  memset (pComDev, 0, iNum * sizeof(tComEnumDev));

/* search for TaModem */

  for (i=COM_SEARCH_COM_FROM; i<=COM_SEARCH_COM_TO; i++)
  {
    if (!xV24UtilSearchModem(i, i, ComPort, DevDsc))
    {
/* eTyp: */
      pComDev[DevCnt].eDevTyp = eTaModem;

/* cFound: */
      pComDev[DevCnt].cFound = TRUE;

/* cDevNam: */
      strcpy (pComDev[DevCnt].cDevNam, ComPort);

/* cDevDsc: */
      strcpy (pComDev[DevCnt].cDevDsc, "(");
      strcat (pComDev[DevCnt].cDevDsc, ComPort);
      strcat (pComDev[DevCnt].cDevDsc, ") ");
      strcat (pComDev[DevCnt].cDevDsc, DevDsc);

/* eProtList: */
      if (!strstr(pComDev[DevCnt].cDevDsc,"RVS-COM"))
      {
        pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eSms_D1;
        pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eSms_D2;
        pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eSms_Eplus;
        pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eModem;
      }

      DevCnt++;
    }
  }

/* search for CAPI */

  if (Capi20_LoadCapi(help))
  {
/* eTyp: */
    pComDev[DevCnt].eDevTyp = eCapi20;

/* cFound: */
    pComDev[DevCnt].cFound = TRUE;

/* cDevDsc: */
    strcpy (pComDev[DevCnt].cDevDsc, "(");;
    strcat (pComDev[DevCnt].cDevDsc, NAME_CAPI_20);;
    strcat (pComDev[DevCnt].cDevDsc, ") ");
    strcpy( DevDsc, "CSSRelValue=1" );       /* wegen acotec-subsystem..    */
    API_GET_MANUFACTURER_20( DevDsc );       /* CAPI Aufruf                 */
    strcat (pComDev[DevCnt].cDevDsc, DevDsc);

/* cDevNam: */
    Capi20_GetDevName (pComDev[DevCnt].cDevNam);

/* eProtList: */
    /* API_GET_PROFILE_20( buff, 1);  */   /* CAPI Aufruf                 */
    /*$problem: mte von get_profile anhngig sein... */
    pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eSms_D1;
    pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eSms_D2;
    pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eSms_Eplus;
    pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eHdlc_X75_Trans;
    pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eHdlc_X75_T70nl;
    pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eHdlc_Trans_Trans;
    pComDev[DevCnt].eProtList[pComDev[DevCnt].iProtNum++] = eTrans_Trans_Trans;

    DevCnt++;
    Capi20_UnLoadCapi();
  }

  /* search for anything else... */

/* eTyp: */
/* cFound: */
/* cDevDsc: */
/* cDevNam: */
/* eProtList: */

  /* end of search */

  return (DevCnt);
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComReadChar (tComDevHandle   DevHandle, tU8* pChar, tU32 iWait)
{
  return (xComReadBlock (DevHandle, pChar, 1, iWait));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComWriteChar (tComDevHandle   DevHandle, tU8 DataChar, tU32 iWait)
{
  return (xComWriteBlock (DevHandle, &DataChar, 1, iWait));
}

/*===========================================================================
*
*
*
*
*
===========================================================================*/

tU32 xComClearRxTxBuff     (tComDevHandle   DevHandle)
{
  return (xComClearRxBuff(DevHandle) | xComClearTxBuff(DevHandle));
}




