/*
                   ==========================================================
                   |                                                        |
                   | term.c  (example application)                          |
                   |                                                        |
                   ===========================|==============================
abstraction layer---------------------------- | -----------------------------
                   ===========================|==============================
                   |                                                        |
                   | com.c (shell modul for enum of all devices)            |
                   |                                                        |
                   ============|===========================|=================
                   ============|=============              |
                   |                        |              |
                   | v24util.c              |              |
                   | (routines for com enum)|              |
                   ==========================              |
                   ========================================|=================
                   |                                                        |
                   | comdisp.c  (dispatcher: v24, capi, ...)                |
                   |                                                        |
                   =========|==================|===================|=========
                            |          ========|=========  = = = = | = = = ==
                            |          |                |                   |
                            |          | comcapi.c      |  | comxxx.c       |
                            |          | (capi20 layer) |  | (more com...)
                            |          ========|=========  == = = =|= = = = =
os specific layer---------- | ---------------- | ----------------- | --------
                   =========|========  ========|=========  == = = =|= = = = =
                   |                |  |                |    os-depentend   |
                   | 3 x comv24_.c  |  | 2 x loadcap_.c |  | part           |
                   | (win,os2,lin)  |  | (win,os2)      |  | ( if needed )
                   ==================  ==================  = = = = = = = = ==

                   comv24w.c -> win    loadcapw.c -> win
                   comv24o.c -> os2    loadcapw.c -> os2
                   comv24l.c -> linux
*/

#ifndef COM_H
#define COM_H

#include "bastypes.h"

/* ------------------------------------------------------------------------
 * Type definitions
 * ------------------------------------------------------------------------ */

typedef enum                                /*                              */
{                                           /*                              */
  eTaModem,                                 /*                              */
  eCapi20,                                  /*                              */
  eTapi,                                    /*                              */
  eTcpIp,                                   /*                              */
  ePipe                                     /*                              */
                                            /*                              */
} tDevType;                                 /*                              */

typedef enum                                /*                              */
{                                           /*                              */
  eSms_D1,                                  /*                              */
  eSms_D2,                                  /*                              */
  eSms_Eplus,                               /*                              */
  eHdlc_X75_Trans,                          /*                              */
  eHdlc_X75_T70nl,                          /*                              */
  eHdlc_Trans_Trans,                        /*                              */
  eTrans_Trans_Trans,                       /*                              */
  eModem                                    /*                              */
                                            /*                              */
} tProtType;                                /*                              */

typedef struct sComDev                      /* describes a com-device       */
{
  tDevType  eDevTyp        ;                /* type of device               */
  tU8       cFound         ;                /* flag if dev is found         */
  tU8       cDevDsc   [256];                /* user-friendly description    */
  tU8       cDevNam   [256];                /* internal device name         */
  tU8       iProtNum       ;                /* number of supported protocols*/
  tProtType eProtList [256];                /* list of supported protocols  */
}
tComEnumDev;

typedef tU32 tComDevHandle;                 /* handle to a device           */

/* ------------------------------------------------------------------------
 * Common definitions
 * ------------------------------------------------------------------------ */

#define NAME_ESMS_D1             "SMS D1"             /*                    */
#define NAME_ESMS_D2             "SMS D2"             /*                    */
#define NAME_ESMS_EPLUS          "SMS E-PLUS"         /*                    */
#define NAME_EHDLC_X75_TRANS     "HDLC, X.75, TRANS"  /*                    */
#define NAME_EHDLC_X75_T70NL     "HDLC, X.75, T.70NL" /*                    */
#define NAME_EHDLC_TRANS_TRANS   "HDLC, TRANS, TRANS" /*                    */
#define NAME_ETRANS_TRANS_TRANS  "TRANS, TRANS, TRANS"/*                    */
#define NAME_EMODEM              "MODEM"              /*                    */
#define NAME_E_NO_PROT           "-"                  /*                    */

#define NAME_TA_MODEM            "Modem/Ta" /*                              */
#define NAME_CAPI_20             "CAPI 2.0" /*                              */
#define NAME_TAPI                "TAPI"     /*                              */
#define NAME_TCP_IP              "TCP/IP"   /*                              */
#define NAME_PIPE                "PIPE"     /*                              */
#define NAME_E_NO_DEVTYPE        "-"        /*                              */

#define DEV_DSC_TA_MODEM_UNKNOWN "Modem/Ta" /*                              */

#define COM_DIAL_TIMEOUT         40

/* ------------------------------------------------------------------------
 * Function Prototypes
 * ------------------------------------------------------------------------ */

/* functions that was resolved in com.c: */

tU32 xComEnumDev            (tComEnumDev* pComDev, tU32 iNum);
tU32 xComGetProtName        (char* ProtName   , tProtType ProtType);
tU32 xComGetDevTypeName     (char* DevTypeName, tDevType  DevType );
tU32 xComWriteChar          (tComDevHandle   DevHandle, tU8  DataChar, tU32 iWait);
tU32 xComReadChar           (tComDevHandle   DevHandle, tU8* pChar, tU32 iWait);

/* functions that goes thru the layers:                                     */
/*                                                                          */
/* these definitions was uses in com.c, comdisp.c and comv24.c with small   */
/* modifications (only in the function name:                                */
/*                                                                          */
/* e.g.:                                                                    */
/*       xComInit     -> com.c     (abstraction layer)                      */
/*       xComDispInit -> comdisp.c (dispatcher layer )                      */
/*       xComV24Init  -> comv24.c  (v.24 layer, exist for every os)         */
/*       xComCapiInit -> comcapi.c (capi layer)                             */
/*                                                                          */

tU32 xComInit               ();
tU32 xComExit               ();

tU32 xComOpenDev            (tComDevHandle *pDevHandle, tComEnumDev* pComDev);
tU32 xComCloseDev           (tComDevHandle   DevHandle);

tU32 xComConnect            (tComDevHandle   DevHandle, tU8* pDial);
tU32 xComDisconnect         (tComDevHandle   DevHandle);

tU32 xComCanWrite           (tComDevHandle   DevHandle);
tU32 xComWriteBlock         (tComDevHandle   DevHandle, tU8* pData, tU32 iLen, tU32 iWait);

tU32 xComReadDataAvailable  (tComDevHandle   DevHandle);
tU32 xComReadBlock          (tComDevHandle   DevHandle, tU8* pData, tU32 iLen, tU32 iWait);

tU32 xComClearRxBuff        (tComDevHandle   DevHandle);
tU32 xComClearTxBuff        (tComDevHandle   DevHandle);
tU32 xComClearRxTxBuff      (tComDevHandle   DevHandle);

tU32 xComSetDiscIndCallback (tComDevHandle DevHandle, void (*ProcAddrParm)(void));
tU32 xComSetConnIndCallback (tComDevHandle DevHandle, void (*ProcAddrParm)(void));

#endif

/* ------------------------------------------------------------------------
 * EOF
 * ------------------------------------------------------------------------ */

