#include <stdio.h>
#include <process.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>

#include "bastypes.h"

static char dbgfile[200];

/* ------------------------------------------------------------------------
 * ------------------------------------------------------------------------ */

void DbgInit()
{
  strcpy (dbgfile,"stdout");
  return;
}

/* ------------------------------------------------------------------------
 * ------------------------------------------------------------------------ */

void Dbg(const char* format, ...)
{
  va_list arglist;
  static FILE* f = 0;
  va_start(arglist, format);
  if(!dbgfile) return;
  else if(!stricmp(dbgfile,"stdout"))
  {
    vprintf(format, arglist);
    fflush(stdout);
  }
  else
  {
    if(!f && !(f = fopen(dbgfile,"w"))) return;
    vfprintf(f, format, arglist);
    fflush(f);
  }
}

/* ------------------------------------------------------------------------
 * ------------------------------------------------------------------------ */

void DbgDump(char* data, int len)
{
  int i, pos = 0;
  while(pos < len)
  {
    Dbg("0x%04x: ", pos);
    i = pos;
    while(i < pos+16)
      Dbg(((i+1)%4)?(i<len?"%02x ":"   "):(i<len?"%02x  ":"    "),(unsigned int)(unsigned char)data[i++]);
    Dbg("\"");
    i = pos;
    while(i < pos+16 && i < len)
      Dbg("%c", isprint(data[i])?data[i]:'.'), i++;
    Dbg("\"\n");
    pos = i;
  }
}

/* ------------------------------------------------------------------------
 * ------------------------------------------------------------------------ */

