#define calling_party_number_len     16+1
#define calling_party_subaddress_len 16+1
#define called_party_number_len      16+1
#define called_party_subaddress_len  16+1
#define bearerlen                    16+1
#define llc_len                      16+1
#define hlc_len                      16+1
#define additional_info_len          16+1
#define connected_number_len         16+1
#define connected_subaddress_len     16+1
#define ncpi_len                     16+1

#define BYTE unsigned char
#define WORD unsigned short
#define DWORD unsigned long

typedef struct st_capi_msg_hdr
{
  WORD  length;
  WORD  appid;
  BYTE  cmd;
  BYTE  subcmd;
  WORD  msgnum;
} CapiMsgHeader;

typedef struct st_alert_req
{
  CapiMsgHeader header;

  DWORD PLCI;
  BYTE  additional_info [additional_info_len];
} TAlertReqMsg;

typedef struct st_alert_conf
{
  CapiMsgHeader header;

  DWORD PLCI;
  WORD  info;
} TAlertConfMsg;

typedef struct st_listen_req
{
  CapiMsgHeader header;

  DWORD controller;
  DWORD info_mask;
  DWORD cip_mask;
  DWORD cip_mask2;
  BYTE ext[calling_party_number_len
          +calling_party_subaddress_len];
} TListenReqMsg;

typedef struct st_listen_conf
{
  CapiMsgHeader header;

  DWORD controller;
  WORD info;
} TListenConfMsg;

typedef struct st_connect_ind
{
  CapiMsgHeader header;

  DWORD  plci;
  WORD cip_value;
  BYTE ext[calling_party_number_len
          +calling_party_subaddress_len
          +called_party_number_len
          +called_party_subaddress_len
          +bearerlen
          +llc_len
          +hlc_len
          +additional_info_len];
} TConnectIndMsg;

typedef struct st_connect_resp
{
  CapiMsgHeader header;

  DWORD  plci;
  WORD   reject;
  BYTE   b_protocol_len;
  WORD   b1_protocol;
  WORD   b2_protocol;
  WORD   b3_protocol;
  BYTE   b1_configuration;
  BYTE   b2_configuration;
  BYTE   b3_configuration;
//  BYTE   global_configuration; // problem
  BYTE  ext[connected_number_len
           +connected_subaddress_len
           +llc_len
           +additional_info_len];

} TConnectRespMsg;

typedef struct st_conn_act_ind
{
  CapiMsgHeader header;

  DWORD plci;
  BYTE ext[connected_number_len
          +connected_subaddress_len
          +llc_len];

} TConnActInd;

typedef struct st_conn_act_resp
{
  CapiMsgHeader header;

  DWORD plci;
} TConnActResp;

typedef struct st_ncpi
{
  BYTE length;
  BYTE data[ncpi_len];
} TNCPI;

typedef struct st_conn_b3_ind
{
  CapiMsgHeader header;

  DWORD ncci;
  TNCPI ncpi;
} TConnB3Ind;

typedef struct st_conn_b3_resp
{
  CapiMsgHeader header;

  DWORD ncci;
  WORD reject;
  TNCPI ncpi;
} TConnB3Resp;

typedef struct st_conn_b3_act_ind
{
  CapiMsgHeader header;

  DWORD ncci;
  TNCPI ncpi;
} TConnB3ActInd;

typedef struct st_conn_b3_act_resp
{
  CapiMsgHeader header;

  DWORD ncci;
} TConnB3ActResp;

typedef struct st_data_b3_req
{
  CapiMsgHeader header;

  DWORD ncci;
  BYTE  *data;
  WORD data_length;
  WORD number;
  WORD flags;
} TDataB3Req;

typedef struct st_data_b3_conf
{
  CapiMsgHeader header;

  DWORD ncci;
  WORD number;
  WORD info;
} TDataB3Conf;

typedef struct st_data_b3_ind
{
  CapiMsgHeader header;

  DWORD ncci;
  BYTE  *  data;
  WORD data_length;
  WORD number;
  WORD flags;
} TDataB3Ind;

typedef struct st_data_b3_resp
{
  CapiMsgHeader header;

  DWORD ncci;
  WORD number;
} TDataB3Resp;

typedef struct st_disc_b3_ind
{
  CapiMsgHeader header;

  DWORD ncci;
  WORD info;
  TNCPI ncpi;
} TDiscB3Ind;

typedef struct st_disc_b3_resp
{
  CapiMsgHeader header;

  DWORD ncci;
} TDiscB3Resp;

typedef struct st_disc_req
{
  CapiMsgHeader header;

  DWORD plci;
  BYTE additional_info [additional_info_len];
} TDiscReq;

typedef struct st_disc_conf
{
  CapiMsgHeader header;

  DWORD plci;
  WORD info;
} TDiscConf;

typedef struct st_disc_ind
{
  CapiMsgHeader header;

  DWORD plci;
  WORD info;
} TDiscInd;

typedef struct st_disc_resp
{
  CapiMsgHeader header;

  DWORD plci;
} TDiscResp;

typedef struct st_conn_req
{
  CapiMsgHeader header;
  DWORD controller;
  WORD  cip_value;
  BYTE  ext[2048];
} TConnReq;

typedef struct st_conn_conf
{
  CapiMsgHeader header;
  DWORD plci;
  WORD  info;
} TConnConf;

typedef struct st_conn_b3_req
{
  CapiMsgHeader header;
  DWORD plci;
  BYTE  ncpi[1];
} TConnB3Req;

typedef struct st_conn_b3_conf
{
  CapiMsgHeader header;
  DWORD ncci;
  WORD  info;
} TConnB3Conf;


