#define INCL_DOSPROCESS
#define INCL_DOS

#include <os2.h>
#include <stdlib.h>
#include <string.h>

#include "..\common.src\bastypes.h"
#include "..\common.src\os.h"

void OsSleep (unsigned long msec)
{
  DosSleep (msec);
}

void OsBoot(void)
{
  HFILE hf;
  ULONG ul;
  ULONG p_len = 0;
  ULONG d_len = 0;

  DosSleep (5000);

  if (!DosOpen("DOS$",&hf,&ul,0,FILE_NORMAL,FILE_OPEN,OPEN_ACCESS_WRITEONLY|OPEN_SHARE_DENYNONE|OPEN_FLAGS_FAIL_ON_ERROR,0)) {
    DosShutdown(1);
    DosShutdown(0);
    DosDevIOCtl(hf,0xD5,0xAB,0,0,&p_len,0,0,&d_len);
    DosClose(hf);
  }
  return;
}

Thread_Id_Typ OsStartThread (void(*startaddr)(void *))
{
  return (_beginthread(startaddr,NULL,os2_stack_of_thread,NULL));
}

void          OsStopThread  (Thread_Id_Typ thread_id)
{
  DosKillThread (thread_id);
}

short OsFindFirst (FileInfoTyp *FileInfo, char *searchmask)
{
  short rc;

  FileInfo->FindHandle = HDIR_CREATE;
  FileInfo->FindCount  = 1;

  rc = DosFindFirst( searchmask,                       /* File pattern             */
                     &FileInfo->FindHandle,            /* Directory search handle  */
                     0,                                /* Search attribute         */
                     (PVOID) &FileInfo->FindBuffer,    /* Result buffer            */
                     sizeof(FILEFINDBUF3),             /* Result buffer length     */
                     &FileInfo->FindCount,             /* # of entries to find     */
                     FIL_STANDARD);                    /* Return level 1 file info */

  if (!rc) {
    strcpy (FileInfo->FileName,FileInfo->FindBuffer.achName);
    FileInfo->FileSize = FileInfo->FindBuffer.cbFile;
  } else {
    strcpy (FileInfo->FileName,"");
    FileInfo->FileSize = 0;
  }
  return (rc);
}

short OsFindNext  (FileInfoTyp *FileInfo)
{
  short rc;

  rc = DosFindNext(FileInfo->FindHandle,(PVOID) &FileInfo->FindBuffer,sizeof(FILEFINDBUF3),&FileInfo->FindCount);

  if (!rc) {
    strcpy (FileInfo->FileName,FileInfo->FindBuffer.achName);
    FileInfo->FileSize = FileInfo->FindBuffer.cbFile;
  } else {
    strcpy (FileInfo->FileName,"");
    FileInfo->FileSize = 0;
  }
  return (rc);

}

short OsFindClose (FileInfoTyp *FileInfo)
{
  return(DosFindClose(FileInfo->FindHandle ));
}

void  OSCreateMutexSem  (char *v1, HMTX *sem, unsigned long d2, unsigned long d3)
{
  DosCreateMutexSem (v1, sem, d2, d3);
}

void  OSCloseMutexSem   (HMTX *sem)
{
  DosCloseMutexSem (*sem);
}

void  OSRequestMutexSem (HMTX *sem, long d1)
{
  DosRequestMutexSem (*sem, d1);
}

void  OSReleaseMutexSem (HMTX *sem)
{
  DosReleaseMutexSem (*sem);
}

void  OSBeep (unsigned long frequency, unsigned long duration)
{
  DosBeep (frequency, duration);
}

void OSSetPriority (unsigned long class)
{
  switch (class) {
    case 0 : class = PRTYC_NOCHANGE         ; break;
    case 1 : class = PRTYC_IDLETIME         ; break;
    case 2 : class = PRTYC_REGULAR          ; break;
    case 3 : class = PRTYC_TIMECRITICAL     ; break;
    case 4 : class = PRTYC_FOREGROUNDSERVER ; break;
    default: class = PRTYC_REGULAR          ; break;
  }
  DosSetPriority (PRTYS_PROCESSTREE, class, 0L, 0L);
}

void  OSProcessAffinity (unsigned long affinity)
{
}


