/****************************************************************************/
/* REXX program to create IOC Demo Workplace Shell Objects                  */
/****************************************************************************/

/* parse command line */

parse source os kind command
parse upper arg iocpath

if (iocpath = '/?' | iocpath = '?') then
do
  say 'This program creates the Workplace shell objects for InfoOnCall for OS/2'
  say ''
  say 'Usage: IOCDESK [iocpath]'
  say ''
  say '  iocpath = directory where InfoOnCall is installed'
  say '            default value is the current directory'
  say ''
  exit(0)
end


/* define system functions */

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs


/* if no path given, use default */

if iocpath = '' then iocpath = directory()

/* check for directory existance */

rc = SysFileTree(iocpath, dir, D)
if (rc \= 0 | dir.0 = 0) then
do
  say command': Error - directory 'iocpath' does not exist.'
  exit(1)
end


/* create TTC folder and IOC icon */

call SysCreateObject 'WPFolder','TTC Computer Products','<WP_DESKTOP>','OBJECTID=<WP_IOC_FOLD>','R'
call SysCreateObject 'WPProgram','InfoOnCall Demo','<WP_IOC_FOLD>','ICONFILE='||iocpath||'\IOC.ICO;EXENAME='||iocpath||'\IOC.EXE;PROGTYPE=PM;OBJCTID=<WP_IOC>', 'R'


