/* PrtGpi.c program for Enhanced Printer Driver
 * FxPrint Copyright (c) 1993-1999 Keller Group Inc.  All rights reserved.
 */

/* If set, writes output to 'File.tif' instead of queuing to log */
#define DIRECT_TO_FILE	0

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_PM
#define INCL_GPI
#define INCL_SPL
#define INCL_SPLDOSPRINT
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

VOID
disp_error(
    const char *format,
    ... )
{
    va_list args;
    CHAR msg[ 256 ];

    va_start( args, format );
    vsprintf( msg, format, args );
    va_end( args );

    WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, msg, "PrtGpi", 0,
	MB_OK | MB_INFORMATION | MB_SYSTEMMODAL );
}

int
main(
    VOID )
{
    HAB prn_hab;
    HMQ prn_hmq;
    HDC prn_hdc = DEV_ERROR;
    HPS prn_hps = GPI_ERROR;
    ULONG rc, ul, index;
    LONG n;
    BYTE buf1[ 1024 ], buf2[ 1024 ];
    PCHAR cp;
    PPRQINFO3 prq3;
    PPRDINFO3 prd3;
    SIZEL sizl, page;
    SIZEF sizfx;
    POINTL ptl;
    FATTRS fat;
    DEVOPENSTRUC dop;
    PCHAR queue = "FxPrint";
    PCHAR title =
	"JoeFax";
#if !DIRECT_TO_FILE
    PCHAR from =
	">>FROM=Joe Developer,Joe's Development Inc,"
	"555-555-6666,555-555-7777\r";
    PCHAR to =
	">>TO=Technical Support,Keller Group Inc.,1 651 653-1987\r";
    PCHAR info =
	">>INFO=Please read this fax,Joe's Dev. Inc.,*\r";
    PCHAR at =
	">>AT=11p,1jan99\r";
#endif
    PCHAR text =
	"This is a test print, ok?";

    prn_hab = WinInitialize( 0 );
    prn_hmq = WinCreateMsgQueue( prn_hab, 0 );
    /* Not a full PM thread with msg loop, so ingore shutdown msgs */
    WinCancelShutdown( prn_hmq, TRUE );

    rc = SplQueryQueue( NULL, queue, 3,
	    buf1, sizeof( buf1 ), &ul );
    if ( rc != NO_ERROR ) {
	disp_error( "Can't find '%s' printer queue. (%u)", queue, rc );
	goto out;
    }
    prq3 = (PVOID)buf1;

    if ( SplQueryDevice( NULL, prq3->pszPrinters, 3,
	    buf2, sizeof( buf2 ), &ul ) != NO_ERROR ) {
	disp_error( "Can't find '%s' printer. (%u)", prq3->pszPrinters, rc );
	goto out;
    }
    prd3 = (PVOID)buf2;

    memset( &dop, 0, sizeof( DEVOPENSTRUC ) );
    dop.pszDriverName = prq3->pszDriverName;
    cp = strchr( dop.pszDriverName, '.' );
    if ( cp != NULL )
	*cp = '\0';
    dop.pdriv = prq3->pDriverData;
    dop.pszDataType = "PM_Q_RAW";
    dop.pszComment = title;
#if DIRECT_TO_FILE
    dop.pszLogAddress = "File.tif";
    prn_hdc = DevOpenDC( prn_hab, OD_DIRECT, "*",
	sizeof( dop ) / sizeof( PVOID ), (PVOID)&dop, 0 );
#else
    dop.pszLogAddress = prd3->pszLogAddr;
    prn_hdc = DevOpenDC( prn_hab, OD_QUEUED, "*",
	sizeof( dop ) / sizeof( PVOID ), (PVOID)&dop, 0 );
#endif
    if ( prn_hdc == DEV_ERROR ) {
	disp_error( "Open DC failed. (%04X)",
	    ERRORIDERROR( WinGetLastError( prn_hab ) ) );
	goto out;
    }

    sizl.cx = sizl.cy = 0;
    prn_hps = GpiCreatePS( prn_hab, prn_hdc, &sizl,
	GPIF_DEFAULT | GPIT_NORMAL | GPIA_ASSOC | PU_LOENGLISH );
    if ( prn_hps == GPI_ERROR ) {
	disp_error( "Create PS failed. (%04X)",
	    ERRORIDERROR( WinGetLastError( prn_hab ) ) );
	goto out;
    }

    DevQueryCaps( prn_hdc, CAPS_WIDTH, 2, (PVOID)&page );
    GpiConvert( prn_hps, CVTC_DEVICE, CVTC_WORLD, 1, (PVOID)&page );

    if ( DevEscape( prn_hdc, DEVESC_STARTDOC, (LONG)strlen( title ), title,
	    NULL, NULL ) != DEV_OK ) {
	disp_error( "StartDoc failed. (%04X)",
	    ERRORIDERROR( WinGetLastError( prn_hab ) ) );
	goto out;
    }

    memset( &fat, 0, sizeof( FATTRS ) );
    fat.usRecordLength = sizeof( FATTRS );
    fat.usCodePage = (USHORT)GpiQueryCp( prn_hps );
    fat.fsFontUse = FATTR_FONTUSE_TRANSFORMABLE;
    strcpy( fat.szFacename, "Helvetica Bold Italic" );
    GpiCreateLogFont( prn_hps, NULL, 1, &fat );
    GpiSetCharSet( prn_hps, 1 );
    sizfx.cx = MAKEFIXED( 40, 0 );
    sizfx.cy = sizfx.cx;
    GpiSetCharBox( prn_hps, &sizfx );

#if !DIRECT_TO_FILE
    /* Send spooling info to driver */
    DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( from ), from, NULL,NULL);
    DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( to ), to, NULL,NULL);
    DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( info ), info, NULL,NULL);
    DevEscape( prn_hdc, DEVESC_RAWDATA, (LONG)strlen( at ), at, NULL,NULL);
#endif

    ptl.x = (page.cx * 1) / 10;
    ptl.y = (page.cy * 1) / 10;
    GpiMove( prn_hps, &ptl );
    ptl.x = (page.cx * 9) / 10;
    ptl.y = (page.cy * 9) / 10;
    GpiBox( prn_hps, DRO_OUTLINE, &ptl, 50, 50 );

    ptl.x = (page.cx * 2) / 10;
    ptl.y = (page.cy * 8) / 10;
    GpiCharStringAt( prn_hps, &ptl, (LONG)strlen( text ), text );
    ptl.y = (page.cy * 7) / 10;
    GpiCharStringAt( prn_hps, &ptl, (LONG)strlen( text ), text );
    ptl.y = (page.cy * 6) / 10;
    GpiCharStringAt( prn_hps, &ptl, (LONG)strlen( text ), text );

    GpiSetLineWidth( prn_hps, MAKEFIXED( 25, 0 ) );
    ptl.x = (page.cx * 2) / 10;
    ptl.y = (page.cy * 2) / 10;
    GpiMove( prn_hps, &ptl );
    ptl.x = (page.cx * 8) / 10;
    ptl.y = (page.cy * 5) / 10;
    GpiBox( prn_hps, DRO_OUTLINE, &ptl, 100, 100 );

    index = 0;
    n = sizeof( index );
    if ( DevEscape( prn_hdc, DEVESC_ENDDOC, 0, NULL, &n, (PBYTE)&index )
	    == DEVESC_ERROR ) {
	disp_error( "EndDoc failed. (%04X)",
	    ERRORIDERROR( WinGetLastError( prn_hab ) ) );
	goto out;
    }
    if ( n == sizeof( index ) )
	disp_error( "Job spooled. Index=%u\n", index );

out:
    if ( prn_hps != GPI_ERROR )
	GpiDestroyPS( prn_hps );
    if ( prn_hdc != DEV_ERROR )
	DevCloseDC( prn_hdc );
    WinDestroyMsgQueue( prn_hmq );
    WinTerminate( prn_hab );
    return( 0 );
}
