/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *                                                                  *
 *    Please See COPYLEFT notice.                                   *
 *                                                                  *
 ********************************************************************/

# include	"crisp.h"

# define	FILENAME	"BUFFER"

void
_fatal_error()
{	int	win,
		buf,
		file_no,
		this_buf;
	string	prompt, tmp, file_name, buf_name;

	buf = create_buffer("*** CRISP Internal Error ***", NULL, 1);
	set_buffer(buf);
	insert("A fatal error has been detected with the software.\n");
	insert("CRISP  will attempt to save your modified buffers.\n");
	insert("\n");
	insert("It will  write  the  buffers  away to files called\n");
	insert("BUFFER.1, BUFFER.2, etc.\n");
	insert("\n");
	insert("It will not  overwrite the  original files in case\n");
	insert("the buffers have  been corrupted or it dies during\n");
	insert("the attempted salvage.\n");
	insert("\n");
	insert("You will be prompted to save each file.");
	top_of_buffer();
	
	win = sized_window(inq_lines(), inq_line_length(), "");
	set_window(win);
	attach_buffer(buf);
	refresh();
	message("");
	/*----------------------------------------
	/*   Now attempt to save the files.
	/*----------------------------------------*/
	this_buf = next_buffer(1);
	file_no = 1;
	
	while (this_buf != buf) {
		set_buffer(this_buf);
		
		if (!inq_system() && inq_modified()) {
			inq_names(file_name, NULL, buf_name);
			
			if (strlen(file_name) > 20)
				file_name = buf_name;
				
			sprintf(tmp, "Save %s as %s.%d ? (y/n) ", file_name, FILENAME, file_no);
			prompt = "x";
			
			while (index("NnYy", prompt) == 0)
				get_parm(NULL, prompt, tmp, 1);
			if (index("yY", prompt)) {
				sprintf(file_name, "%s.%d", FILENAME, file_no);
				write_buffer(file_name);
				++ file_no;
				}
			}
		this_buf = next_buffer(1);
		}
}
