/***********************************************************/
/*    													   */
/*    crisp.h											   */
/*    													   */
/*    Common definitions used by many CRISP macros		   */
/*    													   */
/***********************************************************/

# include	"alt.h"

# define	TRUE	1
# define	FALSE	0

/***********************************************************/
/*    Search and translate flags						   */
/***********************************************************/
# define	SF_BACKWARDS	0x0001	/* Search in backwards direction */
# define	SF_IGNORE_CASE	0x0002	/* Ignore case */
# define	SF_BLOCK		0x0004	/* Restrict search to current block */
# define	SF_UNIX			0x0008	/* Use Unix regular expressions */
# define	SF_LENGTH		0x0010	/* Return length of match */
# define	SF_NOT_REGEXP	0x0020	/* Dont treat as a regular expr */
# define	SF_GLOBAL		0x0040	/* Global translate */
# define	SF_PROMPT		0x0080	/* Prompt for translate changes */
# define	SF_MAXIMAL		0x0100	/* Maximal search mode */
# define	SF_NOTMATCH		0x0200	/* Find line NOT matching pattern */

/***********************************************************/
/*    Buffer flags										   */
/***********************************************************/
# define 	BF_CHANGED		0x0001	/* Buffer has been changed */
# define 	BF_BACKUP		0x0002	/* Buffer needs to be backed up */
# define	BF_READONLY		0x0004	/* Buffer is read-only */
# define	BF_READ			0x0008	/* Buffer has been read in */
# define	BF_EXEC			0x0010	/* Buffer contains executable image */
# define	BF_PROCESS		0x0020	/* Buffer is a process buffer */
# define	BF_BINARY		0x0040	/* Binary editing more */
# define	BF_ANSI			0x0080	/* Process ansi escape sequences */
# define	BF_TABS			0x0100	/* Buffer uses hard tabs */
# define	BF_SYSBUF		0x0200	/* Buffer is a system buffer */
# define	BF_LITERAL		0x0400	/* Shows all characters */
# define	BF_NO_UNDO		0x0800	/* Buffer has no undo */
# define	BF_NEW_FILE		0x1000	/* Buffer will create a new file */
# define	BF_CR_MODE		0x2000	/* Buffer is a "dos" text file CRLF */

/***********************************************************/
/*    Definitions for the edit_file primitive			   */
/***********************************************************/
# define	EDIT_NORMAL		0x0000	/* Guess file type */
# define	EDIT_BINARY		0x0001	/* Force file to be read in binary mode */
# define	EDIT_ASCII		0x0002	/* Force file to be read in ascii mode */
# define	EDIT_CR			0x0004	/* Force CR removal on input and write */
									/* them on output */

/***********************************************************/
/*    Region mark types									   */
/***********************************************************/
# define	MK_NONE			0
# define	MK_NORMAL		1
# define	MK_COLUMN		2
# define	MK_LINE			3
# define	MK_NONINC		4

/***********************************************************/
/*    Process flags										   */
/***********************************************************/
# define	PF_ECHO			0x0001
# define	PF_NOINSERT		0x0002
# define	PF_OVERWRITE	0x4000
# define	PF_WAIT			0x8000

/***********************************************************/
/*    Fields for search & translate						   */
/***********************************************************/
# define	ST_GLOBAL		1
# define	ST_REGEXP		1
# define	ST_CASE			1
# define	ST_BLOCK		1

/***********************************************************/
/*    Bits for file-selection. This may need changing	   */
/*    for different Unix systems.						   */
/***********************************************************/
# define	S_IFDIR			0x4000
# define	S_IFREG			0x8000

/***********************************************************/
/*    Registered macro types:							   */
/***********************************************************/
# define	REG_TYPED		0	/* Character typed */
# define	REG_EDIT		1	/* Different file edited */
# define	REG_ALT_H		2	/* ALT-H pressed in response to a prompt */
# define	REG_UNASSIGNED	3	/* Unassigned key pressed */
# define	REG_IDLE		4	/* Idle time expired */
# define	REG_EXIT		5	/* About to exit */
# define	REG_NEW			6	/* New file edited and readin */
# define	REG_CTRLC		7	/* CTRL-C (SIGINT) pressed */
								/* during macro execution */
# define	REG_INVALID		8	/* Invalid key pressed during */
# define	REG_INTERNAL	9	/* Reserved */
# define	REG_MOUSE		10	/* Monitor mouse movement */
# define	REG_PROC_INPUT	11	/* Process input available */
# define	REG_KEYBOARD	12	/* Keyboard buffer empty */

/***********************************************************/
/*    Flags for select_buffer() macro.					   */
/***********************************************************/
# define	SEL_NORMAL			0	/* Text is not centered */
# define	SEL_CENTER			1	/* Text is centered */
# define	SEL_TOP_OF_WINDOW	2	/* Make indicated line top of window */

/***********************************************************/
/*    Mouse object types.								   */
/**********************************************************/
# define	MOBJ_NOWHERE		0	/* Not in any window */
# define	MOBJ_LEFT_EDGE		1	/* Left bar of window */
# define	MOBJ_RIGHT_EDGE		2	/* Right bar of window */
# define	MOBJ_TOP_EDGE		3	/* Top line of window */
# define	MOBJ_BOTTOM_EDGE	4	/* Bottom line of window */
# define	MOBJ_INSIDE			5	/* Mouse inside window */

/***********************************************************/
/*    Flags controlling the display_mode() macro.		   */
/***********************************************************/
# define	DC_WINDOW			0x0001	/* Windows mode */
# define	DC_SHADOW			0x0002	/* Display shadow around popups */
# define	DC_SHADOW_SHOWTHRU 	0x0004	/* When displaying shadow, use reverse */
										/* of whats underneath the shadow */

/***********************************************************/
/*    Character map flag values.						   */
/***********************************************************/
# define	CMAP_TAB			1
# define	CMAP_BACKSPACE		2
# define	CMAP_ESCAPE			3

/***********************************************************/
/*    Following definitions are used to support the		   */
/*    BRIEF macro names for compatability.				   */
/***********************************************************/
# define	inq_environment(s)	getenv(s)

/***********************************************************/
/*    Manifest returned by inq_mode						   */
/***********************************************************/
# define	MODE_OVERTYPE	0
# define	MODE_INSERT		1

extern int errno;

# if defined( MACRO_DEBUG )
#  define DBG(x)		debug_pause(x)
# else
#  define DBG(x)
# endif

