/**********************************************************************/
/*                                                                    */
/*	Computer Information Marketing Service                        */
/*	======================================                        */
/*                                                                    */
/*  File:          modelines.cr                                       */
/*  Author:        Keith Walker                                       */
/*  Version:       1.00                                               */
/*  Created:       1 May 1991                      		      */
/*                                                                    */
/*  Copyright (c) 1991 CIMS Inc.                                      */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Provide crisp with modelines a'la vi                */
/*                                                                    */
/*   Minor  hack  by  P.  Fox to ensure filename and macro names are  */
/*   unique to 8 chars so that it is portable to DOS.		      */
/**********************************************************************/

/**********************************************************************/
/*   This  set  of  macros  give crisp a modelines feature a'la (the  */
/*   true  BSD)  vi.  You  can embed commands in either the first or  */
/*   last   LINES_TO_CHECK   lines.   These  commands  are  executed  */
/*   whenever  the  file  is  edited, the trigger being the REG_EDIT  */
/*   registry.     The     format     of     the     commands    is:  */
/*   cr:<command-1>:<command-2>:...:<command-n>:".  It  is important  */
/*   to  remember  the  final colon. The modeline can be on the line  */
/*   by  itself  or  surrounded by comments; the key is to start and  */
/*   end with a single colon.					      */
/*   								      */
/*   It  is  permissible to have multiple modelines, both at the top  */
/*   and  the  bottom,  up  to  the  number  in  the  LINES_TO_CHECK  */
/*   constant.							      */
/**********************************************************************/

#include "crisp.h"


#define LINES_TO_CHECK	5

void
modeline()
{
	register_macro(REG_EDIT, "do_modeline");
}
void
do_modeline()
{
	int i;
	string curline;

	/* process the first few lines */
	save_position();
	top_of_buffer();
	for (i = 0; i < LINES_TO_CHECK; i++) {
		curline = trim(ltrim(read()));
		if (index(curline, ":cr:"))
			process_modeline(curline);
		down();
	}
	/* process the final few lines */
	end_of_buffer();
	beginning_of_line();
	for (i = 0; i < LINES_TO_CHECK; i++) {
		curline = trim(ltrim(read()));
		if (index(curline, ":cr:"))
			process_modeline(curline);
		up();
	}
	restore_position();
}

void
process_modeline(string cmdline)
{
	list cmdlist;
	int i;
	      
	cmdline = substr(cmdline, index(cmdline, ":cr:"));
	cmdlist = split(cmdline, ":");
	for (i = 1; i < length_of_list(cmdlist) - 1; i++) {
		execute_macro(cmdlist[i]);
	}
}

/* :cr:tabs 5 9: */
