/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *                                                                  *
 ********************************************************************/

# include	"crisp.h"

void
telnet()
{
	string	host;
	if (get_parm(0, host) == 0)
		host = get_host_entry();
	if (host == "")
		return;
	telnet_rlogin("telnet", host);
}
void
rlogin()
{
	string	host;
	if (get_parm(0, host) == 0)
		host = get_host_entry();
	if (host == "")
		return;
	telnet_rlogin("rlogin", host);
}
void
telnet_rlogin(string prog, string host)
{
	string	cmd;

#ifdef OS2	
	create_shell(getenv("COMSPEC"), host + "-Buffer", PF_ECHO, "\r");
#else
	create_shell("/bin/sh", host + "-Buffer", PF_NOINSERT, "\r");
#endif
	cmd = prog + " " + host + "\n";
	insert(cmd);
	insert_process(cmd);
	sh_char_mode();
	refresh();
}

/*****************************************
/*   Macro to select an entry from the
/*   /etc/hosts file.
/*****************************************/
string
get_host_entry()
{
	int	curbuf,
		buf,
		win,
		line_no;
	string	host;
					 
	message("Press <Enter> to select a host.");
	curbuf = inq_buffer();
	buf = create_buffer("Remote Hosts", "/etc/hosts", 1);
	set_buffer(buf);
	
	/*----------------------------------------
	/*   Delete comment lines.
	/*----------------------------------------*/
	top_of_buffer();
	while (re_search(NULL, "^#|$") > 0)
		delete_line();
	top_of_buffer();
	re_translate(SF_GLOBAL, "^[0-9A-Fa-fxX.]+[ \t]+{[-a-zA-Z0-9.]+}$|{[ \t#]*$}", "\\0");
	sort_buffer();
	win = sized_window(inq_lines(), 20, "");
	line_no = select_buffer(buf, win, NULL, NULL, NULL, "");
	if (line_no >= 0)
		host = trim(ltrim(read()));

	delete_buffer(buf);
	set_buffer(curbuf);
	attach_buffer(curbuf);
	message("");
	return host;
}
