/********************************************************************
 *                                                                  *
 *      CRISP - Custom Reduced Instruction Set Programmers Editor   *
 *                                                                  *
 *      (C) Paul Fox, 1989                                          *
 *                                                                  *
 *    Please See COPYRIGHT notice.                                  *
 *                                                                  *
 ********************************************************************/
# include	"crisp.h"

/*
 * Fixes slashes
 */
string
fixslash (string str)
{
# if defined(OS2) || defined(MSDOS)
	int i;
	string tmpstr = str;

	i = 0;
	while ((i = index(tmpstr, "/")) != 0) {
		str = substr (tmpstr, 1, i - 1) + "\\" + substr (tmpstr, i + 1);
		tmpstr = str;
		}
# endif
	return str;
}

/*
 * Returns temporary directory
 */

string
tmpdir (void)
{
# if defined(UNIX)
	tmp = "/tmp";
# else
	string tmp = getenv("TMP");
	if (tmp == "") {
		tmp = getenv("TEMP");
		if (tmp == "")
			tmp = ".";
	}
# endif
	return tmp;
}

# if defined(MSDOS) || defined(OS2)
string envshell = "COMSPEC";
# else
string envshell = "SHELL";
# endif

string
getshell ()
{
	string sh = getenv(envshell);
	if (sh == "")
	{
# if defined(MSDOS)
		sh = "command.com";
# elif defined(OS2)
		sh = "cmd.exe";
# else
		sh = "/bin/sh";
# endif
	}
	return sh;
}

/*************************************************************
 *   Macro to execute a unix command and read the output into
 *   a buffer. The allocated buffer is returned.
 *
 *	perform_unix_command
 *		cmd	- Unix command to execute.
 *		header	- Header to display at top of window.
 *		[buf]	- If specified name of existing buffer to
 *			  apply command to otherwise, create a new one.
 **************************************************************/
int
perform_unix_command(string cmd, string header)
{
	string	file;
	int	tmp_buf, curbuf = inq_buffer();
# if defined(UNIX)
	string	sh = getshell();
# endif

	sprintf(file, "%s/cr%06d.out", tmpdir(), getpid());
	file = fixslash(file);

	/***********************************************/
	/*   We  want  to  redirect stderr, but doing  */
	/*   this  is  shell  dependent. We'll assume  */
	/*   that  unless  $SHELL  ends in 'csh' that  */
	/*   we   have  a  Bourne  shell  derivative,  */
	/*   i.e. /bin/sh, bash, ksh.		       */
	/***********************************************/
# if defined(UNIX)
	if (index(sh, "/"))
		sh = substr(sh, rindex(sh, "/") + 1);
	if (sh == "csh" || sh == "tcsh")
		cmd += ">&" + file;
	else
		cmd += ">" + file + " 2>&1";
	shell(cmd, 1);
# else
	/*************************************************/
	/* FIXME: No way of redirecting stderr with cmd! */
	/*************************************************/
	cmd += " >" + file;
	shell(cmd, 1);
# endif

	if (get_parm(2, tmp_buf) > 0)
	{
		set_buffer(tmp_buf);
		clear_buffer();
		read_file(file);
		top_of_buffer();
		set_buffer(curbuf);
	}
	else
		tmp_buf = create_buffer(header, file, 1);
	remove(file);
	set_buffer(curbuf);
	redraw();
	return(tmp_buf);
}

