;;
;; Sample startup file for GNU Emacs under emx
;;

;;
;; Enable 8-bit input.  set-input-mode must be called when running
;; Emacs -- calling it before dumping doesn't work.
;;
(set-input-mode nil nil 1)

;;
;; Under OS/2, "~/.netrc" is always world-readable.  Prevent angep-ftp
;; from complainining about bad protection of "~/.netrc".
;;
(setq ange-ftp-disable-netrc-security-check t)

;;
;; Specify additional frame parameters.
;;
(if (eq window-system 'pm)
    (setq default-frame-alist
          (append '((altgr-modifier . meta) ; AltGr (and AltCar) generate M-
                    (shortcuts . (alt-f4))  ; Disable all shortcuts but Alt+F4
                    (alt-modifier . alt)
                    (width . 120) (height . 45)
                    (bottom . 10) (left . 140)
                    (font . "10.System VIO")
;;                    (menu-font . "2.System VIO")
                    (menu-font . "8.Helv")) ; Use small font for menus
                  default-frame-alist)))

;;
;; Display characters 128 through 254 as-is for text mode and PM.
;; Without this statement, octal notation is used for these characters.
;;
(if (eq window-system 'x)
    (standard-display-european 1)
  (standard-display-8bit 128 254))

;; Use special symbols (which are not displayed as-is when occurring
;; in a buffer) for truncated screen lines, continued lines, for
;; displaying control characters, and for separating side-by-side
;; windows.
;;
(if (eq window-system 'x)
    nil
  (set-display-table-slot standard-display-table 'truncation      16)
  (set-display-table-slot standard-display-table 'wrap            31)
  (set-display-table-slot standard-display-table 'control         24)
  (set-display-table-slot standard-display-table 'vertical-border 186))

;;
;; Start the Emacsclient server process
;;
;(server-start)
;(require 'gnuserv)
;(gnuserv-start)
;(setq gnuserv-frame (selected-frame))

;;
;; Raise frame to the foreground if emacsclient requests a buffer.
;;
;;(add-hook 'server-request-hook
;;          '(lambda ()
;;             (make-frame-visible)
;;             (focus-frame (selected-frame))))

;;
;; Enable OS/2 on-line help.
;;
(autoload 'os2help "os2help" "OS/2 on-line help" t)
(setq os2help '("e:/emx/book/emxdev.ndx"
                "e:/ibmcpp/help/epmkwhlp.ndx"
                "e:/ibmcpp/help/cpp.ndx" ))
(global-set-key [C-f1] 'os2help)

;;
;; Call pm-edit-menu to let the Cut, Copy and Paste choices of the
;; Edit menu use the OS/2 clipboard.
;;
;; Call pm-files-menu to let the `Open File...' and `Save Buffer As...'
;; choices from the Files menu use OS/2's standard file dialog.
;;
;; Call remove-from-window-list to remove emacs.exe (the VIO window)
;; from the Window List.  You might want to uncomment that statement
;; if you use the PM interface and don't run Emacs manually.
;;
;; Call pm-session-bond to establish a bond between emacs.exe (the VIO
;; window) and pmemacs.exe (the PM windows).  If you select emacs.exe,
;; for instance by using the Window List, one of the PM windows will
;; be selected instead of emacs.exe.
;;
;; Set the foreground and background colors of the mode line.
;;
;; Use `bold' face instead of `bold-italic' face for info nodes.
;;
(if (eq window-system 'pm)
    (progn
      (pm-edit-menu)
      (pm-files-menu)
      ;;(remove-from-window-list)
      (pm-session-bond t)
      (set-face-background 'modeline "red")
      (set-face-foreground 'modeline "yellow")
      (make-face 'info-node)
      (copy-face 'bold 'info-node)))

;;
;; Switch to ISO 8859-1 if running under X
;; Type `M-x cp850-iso' to edit OS/2 files (code page 850) under X
;;
;;(if (memq window-system '(x pm))
;;    (progn
;;      (require 'iso-syntax)
;;      (require 'cp850-iso)))

;; End of site-start.el
