/* ************************************************************************** */
/*                Future Wave Editor for Russian resource                      */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*        Copyright (C) Future Wave Limited 1999.  All right reserved.        */
/* ************************************************************************** */
        arg  argPath

        '@echo off'
        trace off

        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
        call SysLoadFuncs;

        szPathFrom = '.\';
        szPathFwe  = getInstalledPath( argPath );

        if Stream( szPathFwe || 'Fwe.Exe', 'C', 'QUERY EXIST' ) <> '' then do
           'COPY FweRus.DLL' szPathFwe || 'FweRus.DLL  > NUL';

           say;
           say;
           say 'Successful installing Russian resource for FWE.';
        end
        else do
           say;
           say;
           say;
           say;
           say;
           say 'Not found "' || szPathFwe || 'FWE.EXE".';
           call Beep 500, 1000;
        end;

        say;
        say;

        call SysDropFuncs;
        exit;



getInstalledPath: procedure
        userPath = arg( 1 );

        if userPath <> '' then do
           if SubStr( userPath, length(userPath), 1 ) <> '\' then do
              szReturn = userPath || '\'
           end
           else do
              szReturn = userPath
           end;
        end
        else do
           szReturn = SysIni( 'USER', 'FutureWave_Editor', 'Path' );

           if szReturn = 'ERROR:' then do
              szReturn = '';
           end
           else do
              szReturn = Strip( szReturn, 'T', '00'x )
           end;
        end;

        return( szReturn );
