/* Update-Programm fr Rexxit 1.1 */
/* (C) Richard Sturm 1996         */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'; call SysLoadFuncs
/* -----------------------------------------------------------------------*/

call SysCurState 'OFF'

call hinsetzen 'blau'
call vorsetzen 'hellwei'
call leeren

call schreiben 5,10, 'Rexxit 1.1 Update'
call schreiben 6,10, '(C) Richard Sturm 1996'
call schreiben 18, 10, '(For more information see the README file.)'
call schreiben 19,10, '(Weitere Informationen entnehmen sie bitte der README-Datei.)'

arg Ursprungs_ini
if Ursprungs_ini = '' then do
   call Vorsetzen 'hellrot'
   call schreiben 11, 10, 'Error: You must drop a v1.0 INI-file onto this program!'
   call schreiben 13, 10, 'Fehler: Sie mssen eine V1.0-INI-Datei abwerfen!'
   return
   end

Stelle = lastpos('\', Ursprungs_ini)

if left(Ursprungs_ini, 1) = '"'
   then do
      Name = substr(Ursprungs_ini, Stelle + 1, length(Ursprungs_ini) - Stelle - 1)
      Ursprungs_ini = substr(Ursprungs_ini, 2, length(Ursprungs_ini) - 2)
      end
   else do
      Name = substr(Ursprungs_ini, Stelle + 1)
      end

Sprache = 'English / Deutsch'

select
   when Name = 'MEN.INI' | Name = 'MENU.INI' then do
      Ziel_ini = 'Code.ini'
      Sprache = SysIni(Ursprungs_ini, 'Conditions/If', 'IF')
      if Sprache <> 'ERROR:' 
         then Sprache = 'English'
         else Sprache = 'Deutsch'
      end
   when Name = 'SONST.INI' then Ziel_ini = 'Rexxit.ini' 
   otherwise do
      call Vorsetzen 'hellrot'
      call schreiben 11, 10, 'Error: Unknown INI-file!'
      call schreiben 13, 10, 'Fehler: Unbekannte INI-Datei!'
      return
      end
   end

Zahl = 10 /* Abstand der Punkte vom linken Rand */

call schreiben 11, 10, Name '->' Ziel_ini '('Sprache')'
call Vorsetzen 'hellgelb'

call SysIni Ursprungs_ini, 'ALL:', 'Anwendungen'

do I = 1 to Anwendungen.0 
   call SysIni Ursprungs_ini, Anwendungen.I, 'ALL:', 'Schluessel'
   do K = 1 to Schluessel.0
      Wert.K = SysIni(Ursprungs_ini, Anwendungen.I, Schluessel.K)

      Rc = SysIni(Ziel_ini, Anwendungen.I, Schluessel.K, Wert.K)
      if Rc <> '' then say 'Unknown Error / Unbekannter Fehler!'

      call Punkte
      end
   end

if Ziel_ini = 'Code.ini' then do

   if Sprache = 'English' then do
      call SysIni Ziel_ini, 'Functions/API-Functions', 'RXFUNCADD', 'rxfuncadd()'
      call Punkte
      call SysIni Ziel_ini, 'Functions/API-Functions', 'RXFUNCDROP', 'rxfuncdrop()'
      call Punkte
      call SysIni Ziel_ini, 'Functions/API-Functions', 'RXFUNCQUERY', 'rxfuncquery()'
      call Punkte
      call SysIni Ziel_ini, 'Functions/API-Functions', 'RXQUEUE GET', 'rxqueue("Get" newqueue)'
      call Punkte
      call SysIni Ziel_ini, 'Functions/API-Functions', 'RXQUEUE SET', 'rxqueue("Set" newqueue)'
      call Punkte
      call SysIni Ziel_ini, 'Functions/API-Functions', 'RXQUEUE DELETE', 'rxqueue("Delete" queue)'
      call Punkte
      call SysIni Ziel_ini, 'Functions/API-Functions', 'RXQUEUE CREATE', 'rxqueue("Create" [, queue])'

      end
   else do
      call SysIni Ziel_ini, 'Funktionen/API-Funktionen', 'RXFUNCADD', 'rxfuncadd()'
      call Punkte
      call SysIni Ziel_ini, 'Funktionen/API-Funktionen', 'RXFUNCDROP', 'rxfuncdrop()'
      call Punkte
      call SysIni Ziel_ini, 'Funktionen/API-Funktionen', 'RXFUNCQUERY', 'rxfuncquery()'
      call Punkte
      call SysIni Ziel_ini, 'Funktionen/API-Funktionen', 'RXQUEUE GET', 'rxqueue("Get" neuwschlname)'
      call Punkte
      call SysIni Ziel_ini, 'Funktionen/API-Funktionen', 'RXQUEUE SET', 'rxqueue("Set" neuwschlname)'
      call Punkte
      call SysIni Ziel_ini, 'Funktionen/API-Funktionen', 'RXQUEUE DELETE', 'rxqueue("Delete" wschlname)'
      call Punkte
      call SysIni Ziel_ini, 'Funktionen/API-Funktionen', 'RXQUEUE CREATE', 'rxqueue("Create" [, wschlname])'
      call Punkte
      end
   end
 
call leeren
call vorsetzen 'hellwei'
call schreiben 12, 35, 'Done / Fertig'

return

punkte:
if Zahl = 71 then do
   Zahl = 10
   call schreiben 13, 10, copies(' ', 70)
   end
call schreiben 13, Zahl, '.'
Zahl = Zahl + 1

return

/* ANSI-Schale fr Textbildschirm */ 

/* Lesen von Zeichen ab einer Bildschirmposition */
Lesen: procedure /*************************************/
parse arg Zeile, Spalte
Esc = '1B'x
select
   when arg() = 0 then
      nop
   when arg() = 2 then
      call charout , Esc || '['Zeile';'Spalte'H'
   otherwise do
      say 'FEHLER: Lesen bentigt entweder 0 oder 2 Argumente!'
      exit
      end
   end
parse pull S
return S

/* Schreiben von Zeichen ab einer Bildschirmposition */
Schreiben: procedure /*********************************/
parse arg Zeile, Spalte, Text
Esc = '1B'x
select
   when arg() = 1 then
      call charout , Zeile
   when arg() = 2 then
      call charout , Esc || '['Zeile';'Spalte'H'
   when arg() = 3 then
      call charout , Esc || '['Zeile';'Spalte'H'Text
   otherwise do
      say 'FEHLER: Schreiben bentigt 1, 2 oder 3 Argumente!'
      exit
      end
   end
return

/* Setzen der VORdergrundfarbe */
Vorsetzen: procedure expose Vordergrundcode Hintergrundcode /**********/
arg Farbe
Esc = '1B'x
select
   when pos('GEHEIM', Farbe)  > 0 then C = 8
   when pos('SCHWARZ', Farbe) > 0 then C = 30
   when pos('ROT', Farbe)     > 0 then C = 31
   when pos('GRN', Farbe)    > 0 then C = 32
   when pos('GELB', Farbe)    > 0 then C = 33
   when pos('BLAU', Farbe)    > 0 then C = 34
   when pos('MAGENTA', Farbe) > 0 then C = 35
   when pos('CYAN', Farbe)    > 0 then C = 36
   when pos('WEI', Farbe)    > 0 then C = 37
   otherwise do
      say 'FEHLER: Farbe ungltig fr Vordergrund!'
      exit
      end
   end
if left(Farbe, 4) = 'HELL'
   then
      C = '1;'C
   else do
      call charout , Esc || '[0m'
      if left(Hintergrundcode,1) = Esc then
         call charout , Hintergrundcode
      end
Vordergrundcode = Esc || '['C'm'
call charout , Vordergrundcode
return

/* Setzen der HINtergrundfarbe */
Hinsetzen: procedure expose Vordergrundcode Hintergrundcode /**********/
arg Farbe
Esc = '1B'x
select
   when pos('SCHWARZ', Farbe) > 0 then C = 40
   when pos('ROT', Farbe)     > 0 then C = 41
   when pos('GRN', Farbe)    > 0 then C = 42
   when pos('GELB', Farbe)    > 0 then C = 43
   when pos('BLAU', Farbe)    > 0 then C = 44
   when pos('MAGENTA', Farbe) > 0 then C = 45
   when pos('CYAN', Farbe)    > 0 then C = 46
   when pos('WEI', Farbe)    > 0 then C = 47
   otherwise do
      say 'FEHLER: Farbe ungltig fr Hintergrund!'
      exit
      end
   end
if left(Farbe, 4) = 'HELL'
   then
      C = '5;'C
   else do
      call charout , Esc || '[0m'
      if left(Vordergrundcode,1) = Esc then
         call charout , Vordergrundcode
      end
Hintergrundcode = Esc || '['C'm'
call charout , Hintergrundcode
return

/* Setzen, ob automatischer ZeilenUMbruch */
Umsetzen: procedure /**********************************/
arg Modus
Esc = '1B'x
select
   when Modus = 'aus' then
      Modus = 'h'
   when Modus = 'ein' then
      Modus = 'l'
   otherwise do
      say "FEHLER: Autom. Zeilenumbruch nur 'ein' oder 'aus'!"
      exit
      end
   end
call charout , Esc || '[=3h' || Esc || '[=7' || Modus
return

/* Lschen des Bildschirms bzw. Zeilenrests */
Leeren: procedure /************************************/
arg Parm
Esc = '1B'x
select
   when Parm = '' then
      call charout , Esc || '[2J'
   when Parm = 'REST' then
      call charout , Esc || '[K'
   otherwise do
      say 'FEHLER: Angabe ungltig fr Leeren!'
      exit
      end
   end
return






