
/* file keynames.h */

/* the following is a list of two byte key codes that the editor understands. */
/* Note that in addition the control codes are defined as (256 * '^' + 'A') for */
/* CTRL A and the alt key codes are defined as (256 * '%' + 'A') for ALT A. */

#define FUNC1 (256 * '$' + '1')
#define FUNC2 (256 * '$' + '2')
#define FUNC3 (256 * '$' + '3')
#define FUNC4 (256 * '$' + '4')
#define FUNC5 (256 * '$' + '5')
#define FUNC6 (256 * '$' + '6')
#define FUNC7 (256 * '$' + '7')
#define FUNC8 (256 * '$' + '8')
#define FUNC9 (256 * '$' + '9')
#define FUNC10 (256 * '$' + ':')
#define FUNC11 (256 * '$' + ';')
#define FUNC12 (256 * '$' + '<')
#define SFUNC1 (256 * '$' + '=')
#define SFUNC2 (256 * '$' + '>')
#define SFUNC3 (256 * '$' + '?')
#define SFUNC4 (256 * '$' + '@')
#define SFUNC5 (256 * '$' + 'A')
#define SFUNC6 (256 * '$' + 'B')
#define SFUNC7 (256 * '$' + 'C')
#define SFUNC8 (256 * '$' + 'D')
#define SFUNC9 (256 * '$' + 'E')
#define SFUNC10 (256 * '$' + 'F')
#define SFUNC11 (256 * '$' + 'G')
#define SFUNC12 (256 * '$' + 'H')
#define CFUNC1 (256 * '$' + 'I')
#define CFUNC2 (256 * '$' + 'J')
#define CFUNC3 (256 * '$' + 'K')
#define CFUNC4 (256 * '$' + 'L')
#define CFUNC5 (256 * '$' + 'M')
#define CFUNC6 (256 * '$' + 'N')
#define CFUNC7 (256 * '$' + 'O')
#define CFUNC8 (256 * '$' + 'P')
#define CFUNC9 (256 * '$' + 'Q')
#define CFUNC10 (256 * '$' + 'R')
#define CFUNC11 (256 * '$' + 'S')
#define CFUNC12 (256 * '$' + 'T')
#define AFUNC1 (256 * '$' + 'U')
#define AFUNC2 (256 * '$' + 'V')
#define AFUNC3 (256 * '$' + 'W')
#define AFUNC4 (256 * '$' + 'X')
#define AFUNC5 (256 * '$' + 'Y')
#define AFUNC6 (256 * '$' + 'Z')
#define AFUNC7 (256 * '$' + '[')
#define AFUNC8 (256 * '$' +  92)
#define AFUNC9 (256 * '$' + ']')
#define AFUNC10 (256 * '$' + '^')
#define AFUNC11 (256 * '$' + '_')
#define AFUNC12 (256 * '$' + 96)
#define SHFTTAB (256 * '^' + '!')
#define DELETEKEY (256 * '#' + '.')
#define INSERTKEY (256 * '#' + '0')
#define ENDKEY (256 * '#' + '1')
#define DOWNARROW (256 * '#' + '2')
#define PGDN (256 * '#' + '3')
#define LEFTARROW (256 * '#' + '4')
#define CENTERCURSOR (256 * '#' + '5')
#define RIGHTARROW (256 * '#' + '6')
#define HOMEKEY (256 * '#' + '7')
#define UPARROW (256 * '#' + '8')
#define PGUP (256 * '#' + '9')
#define CTRLDEL (256 * '#' + 'N')
#define CTRLINS (256 * '#' + 'P')
#define CTRLEND (256 * '#' + 'Q')
#define CTRLDOWN (256 * '#' + 'R')
#define CTRLPGDN (256 * '#' + 'S')
#define CTRLLEFT (256 * '#' + 'T')
#define CTRLKEY5 (256 * '#' + 'U')
#define CTRLRIGHT (256 * '#' + 'V')
#define CTRLHOME (256 * '#' + 'W')
#define CTRLUP (256 * '#' + 'X')
#define CTRLPGUP (256 * '#' + 'Y')
#define ALTDEL (256 * '#' + 'n')
#define ALTINS (256 * '#' + 'p')
#define ALTEND (256 * '#' + 'q')
#define ALTDOWN (256 * '#' + 'r')
#define ALTPGDN (256 * '#' + 's')
#define ALTLARROW (256 * '#' + 't')
#define ALTKEY5 (256 * '#' + 'u')
#define ALTRARROW (256 * '#' + 'v')
#define ALTHOME (256 * '#' + 'w')
#define ALTUP (256 * '#' + 'x')
#define ALTPGUP (256 * '#' + 'y')
#define CTRLA (256 * '^' + 'A')
#define CTRLB (256 * '^' + 'B')
#define CTRLC (256 * '^' + 'C')
#define CTRLD (256 * '^' + 'D')
#define CTRLE (256 * '^' + 'E')
#define CTRLF (256 * '^' + 'F')
#define CTRLG (256 * '^' + 'G')
#define CTRLH (256 * '^' + 'H')
#define BACKSPACE (256 * '^' + 'H')
#define CTRLI (256 * '^' + 'I')
#define TABKEY (256 * '^' + 'I')
#define CTRLJ (256 * '^' + 'J')
#define CTRLK (256 * '^' + 'K')
#define CTRLL (256 * '^' + 'L')
#define CTRLM (256 * '^' + 'M')
#define CRRET (256 * '^' + 'M')
#define CTRLN (256 * '^' + 'N')
#define CTRLO (256 * '^' + 'O')
#define CTRLP (256 * '^' + 'P')
#define CTRLQ (256 * '^' + 'Q')
#define CTRLR (256 * '^' + 'R')
#define CTRLS (256 * '^' + 'S')
#define CTRLT (256 * '^' + 'T')
#define CTRLU (256 * '^' + 'U')
#define CTRLV (256 * '^' + 'V')
#define CTRLW (256 * '^' + 'W')
#define CTRLX (256 * '^' + 'X')
#define CTRLY (256 * '^' + 'Y')
#define CTRLZ (256 * '^' + 'Z')
#define ESCKEY (256 * '^' + '[')
#define CTRLBSLASH (256 * '^' + '\\')
#define CTRLRBRCK (256 * '^' + ']')
#define CTRLCIRC (256 * '^' + '^')
#define CTRLUNDER (256 * '^' + '_')
#define CTRLBACK (256 * '^' + '?')
#define CTRLSPC (256 * '^' + '`')
#define TFOLDUP (256 * '^' + '-')
#define TUNFOLD (256 * '^' + '+')
#define ALTQ (256 * '%' + 'Q')
#define ALTW (256 * '%' + 'W')
#define ALTE (256 * '%' + 'E')
#define ALTR (256 * '%' + 'R')
#define ALTT (256 * '%' + 'T')
#define ALTY (256 * '%' + 'Y')
#define ALTU (256 * '%' + 'U')
#define ALTI (256 * '%' + 'I')
#define ALTO (256 * '%' + 'O')
#define ALTP (256 * '%' + 'P')
#define ALTA (256 * '%' + 'A')
#define ALTS (256 * '%' + 'S')
#define ALTD (256 * '%' + 'D')
#define ALTF (256 * '%' + 'F')
#define ALTG (256 * '%' + 'G')
#define ALTH (256 * '%' + 'H')
#define ALTJ (256 * '%' + 'J')
#define ALTK (256 * '%' + 'K')
#define ALTL (256 * '%' + 'L')
#define ALTZ (256 * '%' + 'Z')
#define ALTX (256 * '%' + 'X')
#define ALTC (256 * '%' + 'C')
#define ALTV (256 * '%' + 'V')
#define ALTB (256 * '%' + 'B')
#define ALTN (256 * '%' + 'N')
#define ALTM (256 * '%' + 'M')
#define ALT1 (256 * '%' + '1')
#define ALT2 (256 * '%' + '2')
#define ALT3 (256 * '%' + '3')
#define ALT4 (256 * '%' + '4')
#define ALT5 (256 * '%' + '5')
#define ALT6 (256 * '%' + '6')
#define ALT7 (256 * '%' + '7')
#define ALT8 (256 * '%' + '8')
#define ALT9 (256 * '%' + '9')
#define ALT0 (256 * '%' + '0')
#define ALTNUM (256 * '%' + '#')
#define ALTSTAR (256 * '%' + '*')
#define FOLDUP  (256 * '%' + '-')
#define UNFOLD  (256 * '%' + '+')

/* most of these are not real keyboard keys */
#define NOTHING (256 * '&' + '@')
#define REWRITE (256 * '&' + 'A')
#define HELPKEY (256 * '&' + 'B')
#define CMDKEY (256 * '&' + 'C')
#define WORDEND (256 * '&' + 'D')
#define WORDBEG (256 * '&' + 'E')
#define REVSEARCH (256 * '&' + 'F')
#define CONVMUL (256 * '&' + 'G')
#define ENDMUL (256 * '&' + 'H')
#define FIRSTWORD (256 * '&' + 'I')
#define SCRLEFT (256 * '&' + 'J')
#define SCRRIGHT (256 * '&' + 'K')
#define FRESHSTATUS (256 * '&' + 'L')
#define MACROLIM  (256 * '&' + 'M')
#define LITERAL (256 * '&' + 'N')
#define ECODE (256 * '&' + 'O')
#define COORD (256 * '&' + 'P')
#define SYSDONE (256 * '&' + 'Q')
#define SEARCHREP (256 * '&' + 'R')
#define HALTPNT (256 * '&' + 'S')
#define SINGSTEP (256 * '&' + 'T')
#define CTRLSHFTF (256 * '&' + 'U')
#define CLIPPASTE (256 * '&' + 'V')
#define CLIPCOPY  (256 * '&' + 'W')
#define CLIPDEL   (256 * '&' + 'X')
#define EXITAPP   (256 * '&' + 'Y')
#define ALTNMINUS (256 * '&' + 'Z')
#define TESTNEWER (256 * '&' + '[')
#define SAVEALL   (256 * '&' + '\\')
#define STEPOVER  (256 * '&' + ']')
#define STOPEXEC  (256 * '&' + '^')
#define RESETEXEC (256 * '&' + '_')

/* define dialog window pseudo codes. These can be used to open dialog windows */
#define SAVEASDIALOG (256 * '&' + '1')
#define CMDLINEDIALOG (256 * '&' + '2')
#define CONFIGDIALOG (256 * '&' + '3')
#define OPENDIALOG (256 * '&' + '4')
#define OTHERDIALOG (256 * '&' + '5')
#define FINDDIALOG (256 * '&' + '6')
#define REPLACEDIALOG (256 * '&' + '7')
#define PRINTDIALOG (256 * '&' + '8')         /* splot only */
#define EPSFILEDIALOG (256 * '&' + '9')       /* splot only */
#define METAFILEDIALOG (256 * '&' + ':')       /* splot only */
#define BMPFILEDIALOG (256 * '&' + ';')       /* splot only */

/* define scroll pseudo codes. Anded with a 24 bit number these cause a scroll */
#define SLEFT ('L' << 24)
#define SRIGHT ('R' << 24)
#define SUP ('U' << 24)
#define SDOWN ('D' << 24)
/* define special cursor move pseudo codes */
#define MLEFT ('l' << 24)
#define MRIGHT ('r' << 24)
#define MUP ('u' << 24)
#define MDOWN ('d' << 24)

/* end of file keynames.h */
