.* This file converted from BookMaster using BM2IPF version 2.4.1.
.* File for IPF version 1.0.
.* File for code page 850.
:userdoc.
:docprof toc=123456 .
:title.T - A Tiny Editor
:h1.Version Notice
:p.
:HP1.Version 2.20, October 1993:EHP1.
:p.This program was written by&colon.
:lines.
Tim Baldwin
&rbl.
IBM UK Laboratories
Hursley Park
Winchester
Hampshire, SO21 2JN
&rbl.
BALDWINT at WINVMB
baldy@vnet.ibm.com
:elines.
:h1.Preface
:p.This document describes :HP2.T:EHP2., a very small yet very powerful
full screen text editor for IBM PC, PS/2 and compatible machines.
The document is divided into two main parts&colon.
:link refid=userg reftype=hd.Using The Editor:elink. and :link refid=refer reftype=hd.Editor Reference:elink..
:p.Part 1 is a user's guide containing these sections&colon.
:ul.
:li.:HP2.:link refid=intro reftype=hd.Introduction:elink.:EHP2..
This describes :HP2.T:EHP2., giving an overview of its main features and
omissions.
It also details the hardware and software you will need to be able to
use the editor and how you can obtain a copy.
:li.:HP2.:link refid=start reftype=hd.Getting Started:elink.:EHP2..
This describes how to install :HP2.T:EHP2. ready for use.
It describes how to start up the editor, what the screen looks like and
how to use the help files.
:li.:HP2.:link refid=tedit reftype=hd.Editing:elink.:EHP2..
Contains a brief introduction to editing with :HP2.T:EHP2. describing
how to issue commands and functions and the basics of editing.
This section also covers searching and replacing, the word processing
features, the box drawing functions and describes how to print documents
when using the editor.
:li.:HP2.:link refid=custm reftype=hd.Customising:elink.:EHP2..
Describes how the editor can be customised to change the screen colours,
to redefine the keyboard functions and to alter some other special
editor settings.
:eul.
:p.Part 2 is the reference manual, divided into three sections&colon.
:ul.
:li.:HP2.:link refid=tcmds reftype=hd.Commands:elink.:EHP2..
An alphabetical list of all the editor's commands.
:li.:HP2.:link refid=kfunc reftype=hd.Keyboard Functions:elink.:EHP2..
An alphabetical list of all the editor's keyboard functions.
:li.:HP2.:link refid=tsets reftype=hd.Settings:elink.:EHP2..
An alphabetical list of all the editor's special settings.
:eul.
:p.Two appendices are also included&colon.
:ul.
:li.:HP2.:link refid=tmsgs reftype=hd.Messages:elink.:EHP2..
Lists all the messages :HP2.T:EHP2. can produce, giving the meaning of
the message and any possible action that may need to be taken.
:li.:HP2.:link refid=defks reftype=hd.User Definable Keys:elink.:EHP2..
Lists all the valid names and shift- combinations for the user-definable
keys.
:eul.
.***
:h1 id=userg.Using The Editor
:p.
.***
:h1 id=intro.Introduction
:p.:HP2.T:EHP2. is a full screen text editor for the IBM PC, PS/2 and
compatible family of machines.
Two versions of the editor are supplied, one to run under DOS and the
other to run under OS/2.
It is designed to be quick and easy to learn and simple to use, while
remaining both extremely powerful and very small - the DOS version being
under 10,000 bytes in size.
:p.A very small editor has a number of advantages&colon.
:ul.
:li.It may be used on machines with a limited amount of memory.  Even a
PC with a full 640K of base memory can have a large amount of this used
up when a number of terminate-and-stay-resident type programs are
installed - local area network drivers and terminal emulators are prime
examples.
:li.It may be used for editing large files that would be too large to
load into memory with a bigger editor.
:li.It may be invoked from inside other programs yet still have enough
free memory to edit a good sized file.
:li.It loads and starts very quickly indeed.
If you just wish to make a small change to your CONFIG.SYS file it can
be very frustrating to spend time waiting for a large word processor to
start up.
:li.It can be placed on a diskette without consuming much space.
This can be useful for those "emergency" diskettes used to boot up
and fix a system when all else fails.
:li.It can be placed on a RAM disk without consuming much space.
This can be useful for palmtop type machines which often have no disk
drives at all.
:eul.
.***
:h2 id=BM3.Features and Omissions
:p.:HP2.T:EHP2. has the following main features&colon.
:ul.
:li.Very small size, under 10,000 bytes.
:li.Fast, easy to use, full screen interface that adapts automatically
to use the full size of the display.
:li.Edits very large files, subject to available memory.
:li.Edits very long lines, up to 65,528 characters.
:li.Edits any number of files at once, subject to available memory.
:li.On screen help
:li.Very fast search and replace functions.
:li.Customisable keyboard mapping and screen colours.
:li.Any DOS or OS/2 command may be run without leaving the editor.
:li.A "right hand margin" and "word-spill" to allow some
simple word processing to be performed.
:li.Native DOS and OS/2 versions, which also run under Windows and
Windows/NT.
:li.OS/2 version has full support for the HPFS.
:eul.
:p.To keep :HP2.T:EHP2. small it necessarily lacks some of the more
advanced features of larger editors and word processors.
In particular&colon.
:ul.
:li.Copying and moving data can only be performed on blocks of one or
more whole lines.
:li.Word processing capabilities are very limited.
:li.No programmability, although the appearance and function may be
customised.
:li.No direct support for the mouse or a menu system.
:eul.
.***
:h2 id=BM4.What You Need
:p.:HP2.T:EHP2. should run on any IBM PC, PS/2 or compatible machine.
It needs PC-DOS or MS-DOS version 2.00 or later, or any version of OS/2.
The DOS version may also be run as a DOS application under Microsoft
Windows and both the DOS and OS/2 versions may be run under Windows/NT.
:p.When used with OS/2 or with appropriate versions of Windows it may be
run from both full screen and windowed command prompts, or may be
started by placing an object in one of the OS/2 folders or Windows
Program Manager groups.
:p.:HP2.T:EHP2. is available inside IBM by requesting the T PACKAGE from
PCTOOLS.
:p.:HP2.T:EHP2. is also made freely available outside IBM through the
Employee Written Software programme.
The file :font facename=Courier size=0x0.TINYED.ZIP:font facename=default. can be obtained through CompuServe, from
many BBS systems and via anonymous FTP from a number of sites (e.g.
software.watson.ibm.com).
The ZIP file should be unpacked with PKUNZIP to create the full package.
:p.The :HP2.T:EHP2. package contains&colon.
:dl compact tsize=18.
:dt.T.EXE
:dd.This is the DOS version of the editor program.
:dt.T2.EXE
:dd.This is the OS/2 version of the editor program.
:dt.TKEY.EXE
:dd.This is the customiser program.
It will run under both DOS and OS/2 and will customise either version of
the editor.
:dt.THELP.HLP
:dd.This is a simple help file for the standard editor configuration.
:dt.TKEYS.DEF
:dd.This is a sample custom definition file that describes the standard
editor configuration.
:dt.T.DOC
:dd.This is the full documentation in a plain ASCII printable format.
:edl.
:p.In addition the publicly available :font facename=Courier size=0x0.TINYED.ZIP:font facename=default. package
contains the following important file&colon.
:dl compact tsize=18..
:dt.LICENSE.TXT
:dd.This contains the terms and conditions under which IBM makes the
package available.
:edl.
.***
:h1 id=start.Getting Started
:p.This section describes how to get :HP2.T:EHP2. up and running, what
the screen looks like and how to ask for help.
.***
:h2 id=BM6.Starting T
:p.Only the program file (:font facename=Courier size=0x0.T.EXE:font facename=default. for DOS or
:font facename=Courier size=0x0.T2.EXE:font facename=default. for OS/2) is required to be able to use the editor;
this should be located in the current directory of the current drive, or
in a subdirectory listed in your PATH.
The other files are only required if you want to customise the editor or
if you want to use the supplied help file.
These other files would normally be kept on a separate diskette or in
their own subdirectory (which need not be in the PATH).
:p.If you use OS/2 exclusively or use both DOS and OS/2 but keep your
DOS and OS/2 programs in separate subdirectories you might want to
rename the OS/2 executable to :font facename=Courier size=0x0.T.EXE:font facename=default. also.
This avoids having to remember whether to type T or T2 depending on the
environment you are using.
:p.Since :HP2.T:EHP2. is so small it makes sense to put it on a RAMDRIVE
if you have one installed, this means that it will load almost
instantly.
:p.To start :HP2.T:EHP2. simply enter the following command at the DOS
or OS/2 prompt&colon.
:xmp.
     T  <filename> <filename> ...
 or  T2 <filename> <filename> ...
:exmp.
:p.
You can put any number, including zero, of file names after the
:font facename=Courier size=0x0.T:font facename=default. command and :HP2.T:EHP2. will load each file you list into
its memory.
If you are using the OS/2 HPFS and your file names include spaces you
must specify the name inside double quotes, so :HP2.T:EHP2. does not
think it is two separate file names.
.***
:h2 id=BM7.Screen Layout
:p.The :HP2.T:EHP2. screen is divided into four areas&colon.
:ol.
:li.The :HP1.Message Line:EHP1. and the :HP1.Help Line:EHP1..
:p.The bottom line of the screen is used to display error and
informational messages.
When no messages are displayed this line shows instead a single line of
"help".
Typically the functions assigned to the F-keys are displayed, but this
can be customised to whatever you find useful.
:li.The :HP1.Status Line:EHP1..
:p.Above the message line is the status line.
This shows the name of the current document and the line and column
number of the position of the cursor within the document.
If a right-hand margin has been set this will also be displayed
following an "M" margin indicator.
The current typing mode (either "replace" or "insert") is also
indicated.
:li.The :HP1.Command Line:EHP1..
:p.Above the status line is the command line.
Any any valid :HP2.T:EHP2. command may be entered here.
:li.The :HP1.Data Area:EHP1..
:p.The rest of the screen is used to display the document being edited.
:eol.
:p.The size of the data area is automatically adjusted to fill the whole
of the screen.
Most modern displays can show more than 25 lines and many can show more
than 80 columns.
:HP2.T:EHP2. itself cannot change the size of the display but it will
use the full size of the screen that is available when it is started.
So to see rather more data on the screen first switch to a mode that
shows more than 25 lines then invoke :HP2.T:EHP2..
For example, the following command will switch to a 43 line 80 column
mode under OS/2 or DOS (this needs DOS 4.00 or later)&colon.
:xmp.
     MODE CO80,43
:exmp.
.***
:h2 id=BM8.The Help File
:p.:HP2.T:EHP2. is supplied with a simple help file which describes the
default key settings and the commands available.
When using :HP2.T:EHP2. for the first time ensure that the help file
:font facename=Courier size=0x0.THELP.HLP:font facename=default. is available in the current directory of the
current drive.
Later you can customise the editor to allow the help file to be kept
somewhere else.
:p.Press the F1 key to load and display the help file.
Then use the PgUp and PgDn keys to view the various help panels it
contains.
If you have a 40-column display use the Home and End keys to view the
left and right hand panels.
.***
:h1 id=tedit.Editing
:p.This section gives a brief introduction to editing with :HP2.T:EHP2..
It assumes the editor is used in its default configuration, as supplied.
Later sections describe how to customise the editor.
Anyone who is familiar with the IBM Personal Editor will recognise the
way :HP2.T:EHP2. works immediately and should be able to skip most of
this section - although a glance at :link refid=wordp reftype=hd.Word Processing:elink. and
:link refid=boxes reftype=hd.Drawing Boxes:elink. might be worthwhile.
.***
:h2 id=BM10.Keyboard Functions
:p.Most of the services that :HP2.T:EHP2. can perform are accessed
through :HP1.keyboard functions:EHP1..
These functions are invoked by pressing the key or key combination to
which the function is assigned.
Many functions are assigned to obvious keys, for example the
:HP4.LEFT:EHP4. function (which moves the cursor one character to the
left) is assigned to the cursor Left key, the :HP4.RIGHT:EHP4. function
(to move the cursor right) to the cursor Right key and so on.
Other functions are assigned to key combinations that it is hoped
provide some sort of mnemonic for the function concerned, so for example
the :HP4.REPEAT LINE:EHP4. function (to duplicate the current line) is
assigned to Alt-R, the :HP4.SPLIT LINE:EHP4. function (to split the
current line) to Alt-S and so on.
Full details of these keyboard functions and the keys to which they are
assigned can be found in :link refid=kfunc reftype=hd.Keyboard Functions:elink..
.***
:h2 id=BM11.Simple Editing
:p.If :HP2.T:EHP2. is started without any filename (by just entering
:font facename=Courier size=0x0.T:font facename=default. on the command line) it displays and edits a new, empty,
unnamed document.
A "Top of File" marker line indicates the top of the document
and an "End of File" marker indicates the end.
These marker lines are not part of the document and may not be edited,
although the cursor may be moved onto them.
.***
:h3 id=BM12.The Command Line
:p.The cursor is initially placed on the command line, which is the
third line up from the bottom of the screen.
Any :HP2.T:EHP2. command can be entered on the command line and it is
executed when the Enter key is pressed.
As a command is typed mistakes can be corrected using the functions
:HP4.LEFT:EHP4., :HP4.RIGHT:EHP4. and :HP4.BACKSPACE:EHP4. (assigned to
the cursor Left, cursor Right and the Backspace keys, respectively).
When the editor is in "replace" mode any characters typed overwrite
those already on the screen; when in "insert" mode any characters
to the right of the cursor are shifted right to make room for the new
text.
Switch between "insert" and "replace" mode by using the
function :HP4.INSERT TOGGLE:EHP4. (assigned to the Ins key).
:p.When on the command line the cursor Up and cursor Down keys recall
any previous commands entered.
These can then either be entered again directly by pressing Enter or can
be altered before being reused.
.***
:h3 id=BM13.The Data Area
:p.The cursor may be switched between the data area and the command line
by using the function :HP4.COMMAND TOGGLE:EHP4. (Esc key).
When the cursor is on the command line a :HP1.shadow cursor:EHP1. marks
the position in the data where the real cursor will appear when the
function :HP4.COMMAND TOGGLE:EHP4. is used.
:p.When the cursor is in the data area it may be moved anywhere between
the "Top of File" and "End of File" marker lines.
At any place text may be typed from the keyboard.
If the editor is in "replace" mode any text typed will overwrite
whatever was there before, if it is in "insert" mode anything to
the right of the cursor will be shifted to the right to make room for
the new text.
:p.To add a new line use the function :HP4.INSERT LINE:EHP4.
(Ctrl-Enter) and to delete a line use the function :HP4.DELETE
LINE:EHP4. (Ctrl-Backspace).
Alternatively if the editor is in "insert" mode just pressing Enter
will insert a new blank line (using the function :HP4.NEW LINE:EHP4.).
.***
:h3 id=BM14.Marking and Copying Lines
:p.A block of one or more lines may be marked by pressing the function
:HP4.SET MARK:EHP4. (Alt-L) on the first and last lines of the required
block.
:p.Marked blocks may be deleted using the function :HP4.DELETE
MARK:EHP4. (Alt-D) or they be moved or copied somewhere else.
To move or copy a mark first position the cursor at the line above the
desired new position, then use either the function
:HP4.MOVE MARK:EHP4. (Alt-M) or :HP4.COPY MARK:EHP4. (Alt-C).
:p.Marked blocks are also useful for limiting the scope of a CHANGE or
LOCATE command (described later).
:p.It is also possible to shift all marked lines one character to the
left or right by using the functions :HP4.MARK LEFT:EHP4. (Shift-F7) or
:HP4.MARK RIGHT:EHP4. (Shift-F8) respectively.
This can be used to indent blocks of code when writing programs, for
example.
:p.To duplicate a copy of the current line just use the function
:HP4.REPEAT LINE:EHP4. (Alt-R).
.***
:h3 id=BM15.Saving Documents
:p.If a document has a name (displayed on the status line) it can be
saved to disk simply by using the function :HP4.SAVE:EHP4. (F2); once
saved you may quit the document with the function :HP4.QUIT:EHP4. (F3).
Alternately you can perform a save and quit in one operation by using
the function :HP4.SAFE FILE:EHP4. (F4).
If a document doesn't have a name you must give it one&colon. either use the
NAME command to name the document or use the SAVE or FILE commands along
with a filename parameter.
:note.Using the function :HP4.SAFE FILE:EHP4. (F4) will not cause the
document to be written to disk if it has not been changed.
If you want to force an unchanged document to be re-written to disk
simply use the FILE command from the command line.
.***
:h3 id=BM16.Working On Several Documents
:p.:HP2.T:EHP2. can edit any number of documents at once.
The documents are held in an :HP1.edit ring:EHP1., and although only one
can be displayed on the screen at one time, you can cycle through the
ring by using the functions :HP4.NEXT FILE:EHP4. (F10) or :HP4.PREVIOUS
FILE:EHP4. (F11).
The actual number of documents you can hold in the ring depends on the
size of each document and how much memory your machine has; each
document has to be completely loaded in memory.
:p.To load multiple documents you can either enter several filenames
when :HP2.T:EHP2. is started from the command line, or you can issue
EDIT commands to load more files once :HP2.T:EHP2. is running.
:p.The marked line functions :HP4.MOVE MARK:EHP4. (Alt-M) and :HP4.COPY
MARK:EHP4. (Alt-C) are particularly useful when editing several
documents as lines can be moved and copied to and from different
documents.
.***
:h2 id=BM17.Search and Replace
:p.
.***
:h3 id=BM18.Searching
:p.To search for a particular word or phrase in a document switch onto
the command line and use the LOCATE command.
In its simplest form you just enter a command rather like this&colon.
:xmp.
     /word
:exmp.
:p.
This will search the document for the next occurrence of "word".
:HP2.T:EHP2. will only search from the current position forwards, so to
search from the top you first need to move to the top by using the
function :HP4.TOP OF FILE:EHP4. (Ctrl-Home).
:p.Having found a match you can repeat the search to find the next match
simply by using the function :HP4.REPEAT FIND:EHP4. (Alt-F).
If no further matches can be found before the end of the document the
message "No match found" will be displayed.
:p.Normally LOCATE commands are case-sensitive i.e. a search for
"word" would not find "WORD" or even "Word".
To do a case-insensitive search add the "c" option to the command,
like this&colon.
:xmp.
     /word/c
:exmp.
.***
:h3 id=BM19.Replacing
:p.To change one word or phrase into something else switch onto the
command line and use the CHANGE command, for example&colon.
:xmp.
     C/this/that
:exmp.
:p.
This will search for the next occurrence of the word "this" and
then prompt for an action with the message "Yes/No/Go/Last/Quit?".
Hit either Y, N, G, L or Q as appropriate&colon.
:dl compact tsize=8..
:dt.Yes
:dd.To change this occurrence of "this" into "that" and to
search for the next occurrence of "this".
:dt.No
:dd.To skip this change, but to continue searching.
:dt.Go
:dd.To make this change and all further changes to the end of the
document without any further prompting.
:dt.Last
:dd.To make this change and to stop searching, so this becomes the last
change.
:dt.Quit
:dd.To skip this change and stop searching.
:edl.
:p.To avoid the prompt message and to make all changes straightaway add
the "*" option to the command&colon.
:xmp.
     C/this/that/*
:exmp.
.***
:h2 id=wordp.Word Processing
:p.:HP2.T:EHP2. is not designed to be a word processor, but it does
provide some very simple word processing functions that are useful for
creating quick notes or for entering marked-up documents that will later
be formatted with a batch formatter.
.***
:h3 id=BM21.The Right Margin and Word Spill
:p.The command MARGIN allows a right hand margin column to be set.
When a margin is set the status line indicates its column number with
"M nnn".
To set the right hand margin to column 72 you would enter the command&colon.
:xmp.
     MARGIN 72
:exmp.
:p.
As text is entered into the document any words that are typed across
the right hand margin are automatically word-spilled onto a new inserted
line.
This means it is possible to type whole paragraphs without having to
worry about hitting Enter at the end of each line.
As words spill onto a new line they are automatically indented from the
left hand side so as they align under the first non-blank character of
the line above.
This makes it very simple to leave a left margin or to enter whole
sections indented.
.***
:h3 id=BM22.The ADJUST LINE Function
:p.If corrections need to be made to text entered with a right margin
the text will not be reflowed automatically to keep the margins correct;
in fact after making a number of corrections it will tend to end up in
rather a mess.
The function :HP4.ADJUST LINE:EHP4. (Alt-A) is provided to tidy up this
mess and re-align everything correctly.
:HP4.ADJUST LINE:EHP4. is performed by pressing Alt-A and will adjust
the current line to the current right margin setting.
If the line is too short it will be filled out with words from the next
line down and if it is too long it will be split in two.
As with the word-spill, when :HP4.ADJUST LINE:EHP4. spills words onto
the next line they are aligned under the first non-blank character of
the preceding line.
:p.:HP4.ADJUST LINE:EHP4. will ignore blank lines, skipping over them
and moving the cursor to the next line down, and if a line needs to be
split in two the cursor will move down to the split-off portion.
This makes re-adjusting whole paragraphs very simple, just place the
cursor on the first line of the paragraph and keep pressing Alt-A until
it is re-flowed correctly.
:note.When a line is too short and :HP4.ADJUST LINE:EHP4. fills with
words from the next line, these words are joined to the line with just
one intervening blank.
If before the :HP4.ADJUST LINE:EHP4. the last character happened to be a
full stop at the end of a sentence you may need to go back and insert an
extra space to maintain the convention of two blanks following a
sentence end.
.***
:h2 id=boxes.Drawing Boxes
:p.The PC character set contains a group of special symbols that can be
used to draw boxes.
:HP2.T:EHP2. assigns the box corner and intersection characters to the
keys Alt-1 to Alt-9.
As a reminder of which box corner is assigned to which key, just look at
the numeric keypad which is arranged like this&colon.
:xmp.
     7  8  9
     4  5  6
     1  2  3
:exmp.
:p.
So the Alt-7 key produces a top left box corner, the Alt-3 a bottom
right and so on.
Remember that the keypad just provides a mnemonic - you must actually
enter characters using the Alt-key and the numerals along the top of the
main keyboard area.
:p.The horizontal line is assigned to Alt-- (Alt-minus) and the
vertical line to Alt-= (Alt-equals).
These two may need reassigning to use other keys on non-English language
keyboards, where the "-" and "=" keys don't appear on the top
row just after the numerals.
This can be done by customising the editor (see :link refid=custm reftype=hd.Customising:elink.).
.***
:h2 id=BM24.Printing
:p.To print the current document switch onto the command line and enter
the PRINT command.
No special facilities are provided for formatted printing, the PRINT
command will simply write a copy of the current document to the printer.
If used with no parameters PRINT will write to the device
:font facename=Courier size=0x0.PRN:font facename=default., which for most people will be the printer attached to
their machine.
If you have a serially attached printer or use a LAN printer you may
need to specify the printer device, for example&colon.
:xmp.
     PRINT COM1
 or  PRINT LPT2
:exmp.
:p.
To print a piece of a document first mark the block of lines to be
printed, then use the PUT command to write them to a device.
A device must be specified with the PUT command, so normally you would
use&colon.
:xmp.
     PUT PRN
:exmp.
.***
:h3 id=BM25.Printer Control Codes
:p.You may embed printer control codes directly in your documents if you
want to produce special effects such as bold or emphasised.
You will need to refer to your printer's documentation to determine
exactly which control codes are available and what they do.
:p.Control codes can normally be entered directly using the keypad on
the right of the keyboard&colon. hold down the Alt key and type the decimal
value of the required control code on the keypad then release the Alt
key.
The control code should appear at the cursor position, most control
codes show up on the screen as odd little symbols.
:p.Some codes can also be entered using other keys, but these will
require the use of the function :HP4.ESCAPE:EHP4. (Alt-X).
For example to enter a form feed (ASCII value 12) you can either use the
keypad method described above (hold down Alt, key 1 2 on the keypad and
release Alt), or press :HP4.ESCAPE:EHP4. (Alt-X) followed by Ctrl-L
("L" being the 12th letter of the alphabet).
.***
:h3 id=BM26.Printer Set Up
:p.You may prefer not to place the printer control codes directly in
the document, but to keep the document as plain, readable text.
But you may want to send a few special characters to the printer before
printing a document, perhaps to switch the printer to NLQ mode.
:p.These printer set up sequences can be issued with a :font facename=Courier size=0x0.DOS
ECHO:font facename=default. command, for example to put a Proprinter into NLQ mode issue
the following command&colon.
:xmp.
     DOS ECHO xG >PRN
:exmp.
:p.
where the "x" should be an ASCII "Esc" control code entered
by hitting Alt-X followed by the Esc key.
.***
:h1 id=custm.Customising
:p.This section describes how you can customise :HP2.T:EHP2. to match
your own preferences for screen colours, keyboard layouts and special
settings.
Even if you like :HP2.T:EHP2. exactly the way it is supplied and don't
want to change any of the colours or keys, you will probably still need
to customise some of the special settings, at least to tell the editor
where you keep its help file.
:p.To customise :HP2.T:EHP2. you must first construct a :HP1.custom
definition file:EHP1., which is described in detail in the next section.
Then use the :font facename=Courier size=0x0.TKEY.EXE:font facename=default. customiser program to customise your
copy of the editor, by entering this command on the DOS or OS/2 command
line&colon.
:xmp.
     TKEY  custom.DEF  editor.EXE
:exmp.
:p.
Replace ":font facename=Courier size=0x0.custom.DEF:font facename=default." with the name of your custom
definition file and replace ":font facename=Courier size=0x0.editor.EXE:font facename=default." with the name
the editor you want to customise.
Unless you tell it otherwise TKEY will assume the custom definition file
has an extension of :font facename=Courier size=0x0..DEF:font facename=default. and the editor of :font facename=Courier size=0x0..EXE:font facename=default..
So to customise both the DOS and the OS/2 versions with a custom
definition file called :font facename=Courier size=0x0.TCUST.DEF:font facename=default. you would use the two
commands&colon.
:xmp.
     TKEY TCUST T
 and TKEY TCUST T2
:exmp.
:p.
Once the customising is complete the changes are recorded permanently
inside the editor's .EXE file.
You no longer need either the TKEY program or your custom definition
file, unless you decide to make further changes.
.***
:h2 id=BM28.The Custom Definition File
:p.The custom definition file contains a description of the way you want
:HP2.T:EHP2. to be configured.
An example of a custom definition file is supplied with :HP2.T:EHP2.,
this is called :font facename=Courier size=0x0.TKEYS.DEF:font facename=default. and contains the description of the
default configuration.
This file serves as a good example of how to write a custom definition,
but should be used for reference only.
You should create your own custom definition file and call it something
other than :font facename=Courier size=0x0.TKEYS.DEF:font facename=default..
This will ensure that if you ever obtain a new copy the
:HP2.T:EHP2. package you do not lose any changes you made.
Of course a good way to start your own definition file would be to copy
:font facename=Courier size=0x0.TKEYS.DEF:font facename=default. under another name.
:p.The custom definition file contains four sorts of item.
Normally each item is placed on a new line, although one item can be
split over several lines or several items can be placed on one line if
desired.
:ol.
:li.Comments.
:p.Comments are ignored by the customiser program and serve to make the
definition file more readable.
Comments come in three flavours&colon.
:ol.
:li.Anything between the comment markers :font facename=Courier size=0x0./*:font facename=default. and
:font facename=Courier size=0x0.*/:font facename=default..
Comments of this sort can extend over several lines if required.
:li.Anything between the comment marker :font facename=Courier size=0x0.//:font facename=default. and the end of the
line.
:li.Several special words and symbols are also ignored&colon. blank lines,
blank spaces, ON, OF, TO, IS, ; (semicolon) and = (equals sign)..
:eol.
:li.Colour and Mono Commands
:p.Colour and Mono commands define the colours used for the various
parts of the screen on different types of display.
:li.Key Commands
:p.Key commands assign keyboard functions or single characters to keys.
:li.Set Commands
:p.Set commands alter the editor's special settings.
:eol.
:p.In the following descriptions uppercase will be used to indicate
keywords and lowercase to indicate parameters you must enter.
Items in angle brackets are optional.
In your custom definition file you may use any mixture of upper- or
lowercase.
.***
:h3 id=BM29.Colour and Mono Commands
:xmp.
     COLOUR area = <attr> fgcol ON <attr> bgcol
 or  COLOR  area = <attr> fgcol ON <attr> bgcol
 or  MONO   area = <attr> style
:exmp.
:p.
Colour and Mono commands define the colours that will be used for the
various areas of the screen.
Two forms of the command can be used, indicated by the keywords COLOUR
(spelled COLOR if you prefer) or MONO.
The COLOUR colours are used on colour screens and the MONO colours are
used on monochrome screens or colour screens when in a black-and-white
mode (this latter feature can be useful when a colour adapter is driving
a monochrome screen, as is often the case with LCD portables).
:p.The following parameters should be provided&colon.
:dl compact tsize=10.
:dt.area
:dd.is an area of the screen.  It should be one of&colon.
:sl compact.
:li.DATA LINES
:li.MARK LINES
:li.SHOW LINES
:li.SHADOW CURSOR
:li.STATUS LINE
:li.HELP LINE
:li.MESSAGE LINE
:esl.
:lp.Most of these refer to the obvious screen items or areas.
SHOW LINES refers to those lines displayed in the data area that are not
a part of the actual document being edited (for example the "Top of
File" marker line).
:dt.attr
:dd.is one or more attributes associated with the colour or style it
precedes.
It can be omitted if no attributes are required or specified as one or
more of&colon.
:sl compact.
:li.BRIGHT or LIGHT
:li.BLINKING
:esl.
:dt.fgcol
:dd.is the foreground colour for colour displays, specified as one of&colon.
:sl compact.
:li.BLACK
:li.BLUE
:li.GREEN
:li.TURQUOISE or CYAN
:li.RED
:li.PINK or MAGENTA
:li.BROWN
:li.WHITE
:li.GREY or GRAY
:li.YELLOW
:esl.
:dt.bgcol
:dd.is the background colour for colour displays specified from the same
choices as the foreground colours.
Only the BRIGHT (or LIGHT) attribute may precede the background colour.
:dt.style
:dd.is the style of text used for monochrome displays specified as one
of&colon.
:sl compact.
:li.NORMAL
:li.REVERSE
:li.UNDERLINE
:esl.
:edl.
:note.Not all combinations of attributes and colours or styles are
meaningful or useable on all systems, although the customiser program
may accept them.
In particular the BRIGHT attribute has no effect on the REVERSE style,
the UNDERLINED style may not always be available, the colour YELLOW is
the same as BRIGHT BROWN and the colour GREY is the same as BRIGHT
BLACK.
Also note that on some machines a BRIGHT background will actually
produce a BLINKING foreground instead - bear this in mind if YELLOW
(i.e. BRIGHT BROWN) or GREY (i.e. BRIGHT BLACK) are chosen as background
colours.
.***
:h3 id=BM30.Key Commands
:xmp.
     KEY <shift->keyname = function
 or  DEF <shift->keyname = function
 or  KEY <shift->keyname = character
 or  DEF <shift->keyname = character
:exmp.
:p.
Key commands assign the editor's keyboard functions or single ASCII
characters to user definable keys.
The parameters are&colon.
:dl compact tsize=15.
:dt.shift-
:dd.is the shift key that must be pressed.
It is omitted for unshifted keys or specified as one of&colon.
:dl compact tsize=6..
:dt.S-
:dd.for either of the shift keys
:dt.C-
:dd.for the Ctrl key
:dt.A-
:dd.for the Alt key
:edl.
:dt.keyname
:dd.is chosen from&colon.
:sl compact.
:li.A to Z
:li.0 to 9
:li.F1 to F12
:li.- (the minus key)
:li.= (the equals key)
:li.&lbrk. (the open square bracket key)
:li.&rbrk. (the close square bracket key)
:li.&bslash. (the backslash key)
:li.ESC
:li.TAB
:li.BACKSPACE
:li.ENTER
:li.PADENTER
:li.HOME
:li.END
:li.PGUP
:li.PGDN
:li.UP
:li.DOWN
:li.LEFT
:li.RIGHT
:li.INS
:li.DEL
:li.PAD5
:esl.
:lp.Not all shift-keyname combinations are valid, and some are not
available for use on the older PC keyboard (the one with 10 F-keys over
on the left).
See :link refid=defks reftype=hd.User Definable Keys:elink. for a full list of combinations.
:dt.function
:dd.is one of the keyboard functions.
The full list of keyboard functions is defined in :link refid=kfunc reftype=hd.Keyboard Functions:elink..
:dt.character
:dd.is a single ASCII character.
This can either be specified as the character itself in quotes, or using
the form&colon.
:xmp.
     ASCII nnn
:exmp.
:p.
where :font facename=Courier size=0x0.nnn:font facename=default. is the character's ASCII code point.
This allows characters not normally present on the keyboard (such as the
box drawing characters) to be assigned to keys.
:edl.
.***
:h3 id=BM31.Set Commands
:xmp.
     SET item = value
:exmp.
:p.
Set commands allow customising of the special editor settings.
These are described in detail in :link refid=tsets reftype=hd.Settings:elink..
.***
:h2 id=thelp.The HELP and USER Functions
:p.The :HP4.HELP:EHP4. and :HP4.USER:EHP4. keyboard functions are rather
special and quite powerful features.
The :HP4.HELP:EHP4. and :HP4.USER:EHP4. functions work in an identical
way, the fact that one is called "HELP" is only really to suggest a
good use for the function.
Once you are familiar with the way :HP2.T:EHP2. works you may decide you
no longer really need a help system, and you can then use the
:HP4.HELP:EHP4. function for something else completely.
:p.The functions are defined by two items in the custom definition file.
Firstly the keyboard function is assigned to key, and secondly a
:HP2.T:EHP2. command is assigned to the function.
For example&colon.
:xmp.
     KEY F1 = HELP
     SET HELP COMMAND = "EDIT THELP.HLP"
:exmp.
:p.
In this example the :HP4.HELP:EHP4. keyboard function is assigned to
the F1 key and the function is then assigned the command "EDIT
THELP.HLP".
:p.When the :HP4.HELP:EHP4. keyboard function is pressed (i.e. F1 is
pressed) :HP2.T:EHP2. will execute the assigned command, just as if it
had been typed on the command line.
In this example it will therefore load and display a help file.
:p.The command that is assigned to the function can be any command that
could be entered on the :HP2.T:EHP2. command line, so some other useful
applications might be&colon.
:ul.
:li.Use the standard :HP2.T:EHP2. help file but locate it in the
:font facename=Courier size=0x0.&bslash.EDITORS:font facename=default. subdirectory on the C&colon. drive&colon.
:xmp.
     KEY F1 = HELP
     SET HELP COMMAND = "T C&colon.&bslash.EDITORS&bslash.THELP.HLP":exmp.
:li.Set Alt-P to print the current document to COM1&colon.
:xmp.
     KEY A-P = USER
     SET USER COMMAND = "PRINT COM1":exmp.
:li.Set Alt-H to invoke an external HELP program for a subject called
"T"&colon.
:xmp.
     KEY A-H = HELP
     SET HELP COMMAND = "DOS HELP T":exmp.
:li.Set the F5 key to shell out to a DOS or OS/2 command prompt&colon.
:xmp.
     KEY F5 = USER
     SET USER COMMAND = "DOS":exmp.
:eul.
.***
:h2 id=keybd.The Enhanced Keyboard
:p.Most recent PCs and all PS/2s come with IBM's Enhanced Keyboard.
This is the keyboard with twelve function keys arranged across the top
and an extra set of cursor control keys between the typewriter keys and
the numeric keypad.
Older PCs and some notebook style machines have a keyboard with just ten
function keys.
To make use of the extra keys on the Enhanced Keyboard a program must
work in a different way from that which was used to handle the old-style
keyboards, if the old-style interface is used only the subset of keys
present on the older keyboard will be recognised.
:p.:HP2.T:EHP2. attempts to determine which type of keyboard interface
to use, so that if an Enhanced Keyboard is attached all its keys will be
available.
However the tests used to decide which type of keyboard is present can
be fooled by some non-IBM BIOSs and by some older TSR programs that were
created before the Enhanced Keyboard was available.
This usually shows up as a problem when the editor starts&colon. the command
line becomes full of a repeated character and the editor hangs.
:p.In situations like these you must force :HP2.T:EHP2. to use the old
keyboard interface by putting this line in your custom definition file&colon.
:xmp.
     SET KEYBOARD TYPE = STANDARD
:exmp.
.***
:h1 id=refer.Editor Reference
:p.
.***
:h1 id=tcmds.Commands
:p.This section describes each of the commands that may be entered on
the :HP2.T:EHP2. command line.
In describing the syntax of the commands, uppercase letters are used for
the command name and lowercase letters for any parameters you must
supply.
Optional parameters are enclosed in angle brackets.
Commands may actually be entered in any mixture of upper- or lowercase.
:p.Where the parameters call for a :font facename=Courier size=0x0.filename:font facename=default. any valid DOS or
OS/2 file name may be used.
This may include the drive letter and directory path if required; if
none is given the current drive and directory will be used, following
the normal conventions.
When using the OS/2 High Performance File System (HPFS) filenames are
not limited to the DOS "8-dot-3" format and any upper- or lowercase
characters used will be preserved.
.***
:h2 id=BM36.APPEND
:xmp.
     APPEND filename
:exmp.
:p.The currently marked lines are written to the file
":font facename=Courier size=0x0.filename:font facename=default.".
The lines are added to the end of the file, preserving any former
contents.
The file is created if it does not exist.
.***
:h2 id=chang.CHANGE
:xmp.
     C /target/replacement</options>
:exmp.
:p.The next occurrence of the text ":font facename=Courier size=0x0.target:font facename=default." starting
from the current cursor position, is located.
Then the message "Yes/No/Go/Last/Quit?" is displayed, to which you
should reply with one of&colon.
:dl compact tsize=4..
:dt.Y
:dd.to change this instance of ":font facename=Courier size=0x0.target:font facename=default." into
":font facename=Courier size=0x0.replacement:font facename=default.".
The next occurrence of ":font facename=Courier size=0x0.target:font facename=default." is then found and the
process repeats.
:dt.N
:dd.to not change this instance of ":font facename=Courier size=0x0.target:font facename=default.", but to
continue searching for the next occurrence.
:dt.G
:dd.to change this instance of ":font facename=Courier size=0x0.target:font facename=default." into
":font facename=Courier size=0x0.replacement:font facename=default." and then to change all further instances
(until to end of the document) without further prompting.
:dt.L
:dd.to change this instance of ":font facename=Courier size=0x0.target:font facename=default." into
":font facename=Courier size=0x0.replacement:font facename=default." and then to stop the command, so this
becomes the last change made.
:dt.Q
:dd.to stop the change command without making any further changes.
:edl.
:p.The ":font facename=Courier size=0x0./:font facename=default." character is a delimiter and can be replaced
with any character that does not occur in either the
":font facename=Courier size=0x0.target:font facename=default." or the ":font facename=Courier size=0x0.replacement:font facename=default.".
Note that the delimiter is the first non-blank character following the
:font facename=Courier size=0x0.C:font facename=default. command.
:p.Following a final delimiter any of these options may be used&colon.
:dl compact tsize=4..
:dt.m
:dd.to restrict the changes to the marked lines only.
:dt.*
:dd.to change all occurrences of ":font facename=Courier size=0x0.target:font facename=default." to
":font facename=Courier size=0x0.replacement:font facename=default." without prompting.
:edl.
:note.Change commands are always case-sensitive.
.***
:h2 id=BM38.DOS
:xmp.
     DOS <command>
 or  .<command>
:exmp.
:p.A secondary DOS or OS/2 shell is started to execute the
":font facename=Courier size=0x0.command:font facename=default.".
A full stop may be used as a quick abbreviation for the word DOS.
:p.If no ":font facename=Courier size=0x0.command:font facename=default." is given the DOS or OS/2 command line
prompt will appear.
You can return to :HP2.T:EHP2. by entering the command :font facename=Courier size=0x0.EXIT:font facename=default..
.***
:h2 id=BM39.EDIT
:xmp.
     EDIT <filename>
 or  E <filename>
 or  T <filename>
:exmp.
:p.If a ":font facename=Courier size=0x0.filename:font facename=default." is given :HP2.T:EHP2. will switch
directly to display that document.
The file will be loaded from disk, if it is not already in the edit
ring.
:p.If no ":font facename=Courier size=0x0.filename:font facename=default." is given the next document in the
edit ring will be selected.
.***
:h2 id=BM40.FILE
:xmp.
     FILE <filename>
 or  F <filename>
:exmp.
:p.The current document will be saved to disk and then removed from the
edit ring.
If a ":font facename=Courier size=0x0.filename:font facename=default." is given the document will be saved
under this name, otherwise the name shown on the status line will be
used.
.***
:h2 id=BM41.GET
:xmp.
     GET filename
:exmp.
:p.The contents of ":font facename=Courier size=0x0.filename:font facename=default." will be inserted into the
current document following the current line.
.***
:h2 id=BM42.GOTO
:xmp.
     GOTO linenum
 or  linenum
:exmp.
:p.Line number ":font facename=Courier size=0x0.linenum:font facename=default." will become the current line
and will be displayed on the focus line.
If ":font facename=Courier size=0x0.linenum:font facename=default." is bigger than the number of lines in the
document the last line will become the current line.
The word GOTO is optional, just entering the required
":font facename=Courier size=0x0.linenum:font facename=default." on the command line is sufficient.
.***
:h2 id=BM43.LOCATE
:xmp.
     L /target</options>
 or  /target</options>
:exmp.
:p.The next occurrence of the text ":font facename=Courier size=0x0.target:font facename=default.", starting
from the current cursor position, will be located and displayed on the
focus line.
If the ":font facename=Courier size=0x0.L /target:font facename=default." form of the command is used the
delimiter, &odq.:font facename=Courier size=0x0./:font facename=default.&cdq., may be replaced by any character that
does not occur in ":font facename=Courier size=0x0.target:font facename=default.".
:p.Following a final delimiter any of these options may be used&colon.
:dl compact tsize=4..
:dt.m
:dd.to restrict the search to the marked lines only.
:dt.e
:dd.to force an exact-case match.
:dt.c
:dd.to force an any-case match.
(Apologies to non-English speakers&colon. only the 26 letters "a" to
"z" are correctly handled.)
:edl.
:Note.if neither :font facename=Courier size=0x0.e:font facename=default. nor :font facename=Courier size=0x0.c:font facename=default. is given the editor's
EXACT MATCH setting is used.
This may be customised - refer to :link refid=custm reftype=hd.Customising:elink. for more details.
.***
:h2 id=BM44.MARGIN
:xmp.
     MARGIN column
 or  M column
:exmp.
:p.The right hand margin will be set to ":font facename=Courier size=0x0.column:font facename=default.".
To remove the right hand margin enter a column value of zero.
The margin column is displayed on the status line in the form "M
nnn".
:p.The margin is used by the word-spill features&colon. as words are typed
across the margin column they are automatically spilled onto the next
line.
It is also used by the :HP4.ADJUST LINE:EHP4. keyboard function (see
:link refid=wordp reftype=hd.Word Processing:elink.).
.***
:h2 id=BM45.NAME
:xmp.
     NAME <name>
 or  N <name>
:exmp.
:p.The current document will be renamed to ":font facename=Courier size=0x0.name:font facename=default.".
.***
:h2 id=BM46.PRINT
:xmp.
     PRINT <device>
:exmp.
:p.The current document will be printed.
It is printed to the named ":font facename=Courier size=0x0.device:font facename=default.", if one is
specified, otherwise the device :font facename=Courier size=0x0.PRN:font facename=default. is used.
.***
:h2 id=BM47.PUT
:xmp.
    PUT filename
:exmp.
:p.The currently marked lines will be written to the file
":font facename=Courier size=0x0.filename:font facename=default.".
Any former contents of the file are lost.
:note.The marked lines can be printed using the command :font facename=Courier size=0x0.PUT
PRN:font facename=default..
.***
:h2 id=BM48.QUIT
:xmp.
     QUIT <ALL>
 or  Q <ALL>
:exmp.
:p.If used without the ":font facename=Courier size=0x0.ALL:font facename=default." parameter the current
document will be removed from the edit ring.
It will not be saved to disk.
If any changes have been made, since the document was last saved, the
message "Throw away changes? (y/n)" is displayed; hit either Y or
N as appropriate.
:p.If the ":font facename=Courier size=0x0.ALL:font facename=default." parameter is specified all the current
documents will be discarded without saving any changes and the editor
will end and return to the operating system.
This parameter should be used with care.
.***
:h2 id=BM49.SAVE
:xmp.
     SAVE <filename>
 or  S <filename>
:exmp.
:p.The current document will be saved to disk.
If a ":font facename=Courier size=0x0.filename:font facename=default." is given the document will be saved
under this name, otherwise the name shown on the status line will be
used.
.***
:h2 id=BM50.VERSION
:xmp.
     VER
:exmp.
:p.The :HP2.T:EHP2. name, version number and copyright notice will be
displayed.
.***
:h1 id=kfunc.Keyboard Functions
:p.This section describes each of the keyboard functions that are
available to the editor.
Keyboard functions are invoked by pressing the key to which they have
been assigned.
This assignment is made in a custom definition file using entries of the
form&colon.
:xmp.
     KEY key = function
 or  DEF key = function
:exmp.
:p.The descriptions which follow include the default key to which the
function is assigned.
.***
:h2 id=BM52.ADJUST LINE
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.A:EHP2.
:p.Adjusts the current line to the right hand margin setting.
If the line extends beyond the margin it is split; if it does not reach
the margin it is filled with words from the next line.
If a split occurs and the special setting AUTOMATIC INDENT is ON (see
:link refid=tsets reftype=hd.Settings:elink.), the split-off portion will align under the first
non-blank character of the previous line.
:p.:HP4.ADJUST LINE:EHP4. will ignore blank lines and, when a line is
split, the cursor will move to the split-off portion.
This makes it particularly simple to re-adjust a paragraph after making
changes or altering the right hand margin.
.***
:h2 id=BM53.BACKSPACE
:p.Default key&colon. :HP2.Backspace:EHP2.
:p.Deletes the character to the left of the cursor, and moves the cursor
one character to the left.
.***
:h2 id=BM54.CLEAR MARK
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.U:EHP2.
:p.Un-marks any marked lines.
.***
:h2 id=BM55.COMMAND TOGGLE
:p.Default key&colon. :HP2.Esc:EHP2.
:p.Switches the cursor between the command line and the data area.
When the cursor is on the command line a :HP1.shadow cursor:EHP1. marks
the current position in the data.
.***
:h2 id=BM56.COPY MARK
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.C:EHP2.
:p.Inserts a copy the marked lines following the current line.
If there are several documents in the edit ring this may be used to copy
lines from one document to another.
.***
:h2 id=BM57.DELETE CHARACTER
:p.Default key&colon. :HP2.Del:EHP2.
:p.Deletes the character at the cursor.
.***
:h2 id=BM58.DELETE LINE
:p.Default key&colon. :HP2.Ctrl:EHP2.-:HP2.Backspace:EHP2.
:p.Deletes the current line.
.***
:h2 id=BM59.DELETE MARK
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.D:EHP2.
:p.Deletes the marked lines.
.***
:h2 id=BM60.DOWN
:p.Default key&colon. :HP2.Down:EHP2.
:p.Moves the cursor down one line.
.***
:h2 id=BM61.EDIT
:p.Default key&colon. :HP2.F8:EHP2.
:p.Switches to the command line and keys in the command EDIT, ready for
you to enter a filename.
.***
:h2 id=BM62.END OF FILE
:p.Default key&colon. :HP2.Ctrl:EHP2.-:HP2.End:EHP2.
:p.Makes the current line the last line in the document, and positions
this line at the bottom of the screen.
.***
:h2 id=BM63.END OF LINE
:p.Default key&colon. :HP2.End:EHP2.
:p.Moves the cursor to the position one character after the last
character on the current line.
.***
:h2 id=BM64.END OF MARK
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.E:EHP2.
:p.Makes the current line the last marked line, and positions this line
on the focus line.
If the marked lines are in a different document that document will
become the current document.
.***
:h2 id=BM65.END OF SCREEN
:p.Default key&colon. :HP2.Ctrl:EHP2.-:HP2.PgDn:EHP2.
:p.Moves the cursor to the last line of the document on the screen.
.***
:h2 id=BM66.ESCAPE
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.X:EHP2.
:p.This allows the entry of ASCII characters using keys on the keyboard
that would normally perform a function.
Typically this is useful when entering printer control codes into a
document.
:p.For example to enter the ASCII "Esc" character first use the
:HP4.ESCAPE:EHP4. function then press the Esc key.
:p.It is also possible to enter any ASCII character from 1 to 255 using
the numeric keypad on the right of the keyboard.
Press and hold the Alt key then type the decimal ASCII value on the
keypad, release the Alt key and the character will appear.
Using the keypad in this way does not require the :HP4.ESCAPE:EHP4.
function.
:note.To enter an ASCII NUL (character code 0) use the Ctrl-2 key.
.***
:h2 id=BM67.FILE
:p.Default key&colon. None
:p.Writes the current document to disk using the name shown on the
status line, then removes the document from the edit ring.
.***
:h2 id=BM68.FOCUS
:p.Default key&colon. :HP2.F12:EHP2.
:p.This places the current line onto the defined screen focus line.
The focus line is defined by the special setting FOCUS LINE (see
:link refid=tsets reftype=hd.Settings:elink.).
.***
:h2 id=BM69.HELP
:p.Default key&colon. :HP2.F1:EHP2.
:p.Causes the command specified by the special setting HELP COMMAND (see
:link refid=tsets reftype=hd.Settings:elink.) to be executed.
Refer to :link refid=thelp reftype=hd.The HELP and USER Functions:elink. for more details about using the
:HP4.HELP:EHP4. function.
.***
:h2 id=BM70.INSERT LINE
:p.Default key&colon. :HP2.Ctrl:EHP2.-:HP2.Enter:EHP2. and
:HP2.Ctrl:EHP2.-:HP2.PadEnter:EHP2.
:p.Inserts a new blank line following the current line.
If the special setting AUTOMATIC INDENT is ON the cursor will be aligned
under the first non-blank character of the preceding line.
.***
:h2 id=BM71.INSERT TOGGLE
:p.Default key&colon. :HP2.Ins:EHP2.
:p.Toggles the editor between "insert" and "replace" modes.
The shape of the cursor and the Rep/Ins indicator on the status line
show which mode is active.
.***
:h2 id=BM72.JOIN LINE
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.J:EHP2.
:p.Joins together the current line and the following line.
The lines are joined with a single blank between them.
.***
:h2 id=BM73.LEFT
:p.Default key&colon. :HP2.Left:EHP2.
:p.Moves the cursor one character to the left.
.***
:h2 id=BM74.MARK LEFT
:p.Default key&colon. :HP2.Shift:EHP2.-:HP2.F7:EHP2.
:p.The marked lines are shifted one character to the left.
Only the characters to the right of the cursor position are shifted, so
if you want to shift the whole line be sure to first position the cursor
at the left hand edge.
Any characters moved to the left of the cursor column are lost.
.***
:h2 id=BM75.MARK RIGHT
:p.Default key&colon. :HP2.Shift:EHP2.-:HP2.F8:EHP2.
:p.The marked lines are shifted one character to the right.
Only the characters to the right of the cursor position are shifted, so
if you want to shift the whole line be sure to first position the cursor
at the left hand edge.
.***
:h2 id=BM76.MOVE MARK
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.M:EHP2.
:p.Moves the marked lines so they come after the current line.
If there are several documents in the edit ring this may be used to move
lines from one document to another.
.***
:h2 id=BM77.NAME
:p.Default key&colon. :HP2.F7:EHP2.
:p.Switches to the command line and keys in the command NAME, ready for
you to enter a new document name.
.***
:h2 id=BM78.NEW LINE
:p.Default key&colon. :HP2.Enter:EHP2.
:p.If in "insert" mode this will perform an
:HP4.INSERT LINE:EHP4. function, if in "replace" mode it will
perform a :HP4.NEXT LINE:EHP4. function.
.***
:h2 id=BM79.NEXT FILE
:p.Default key&colon. :HP2.F10:EHP2.
:p.Makes the next document in the edit ring the current document.
.***
:h2 id=BM80.NEXT LINE
:p.Default key&colon. :HP2.PadEnter:EHP2.
:p.Moves the cursor to the start of the next line in the document.
.***
:h2 id=BM81.NEXT TAB
:p.Default key&colon. :HP2.Tab:EHP2.
:p.Moves the cursor right to the next tab stop.
Tab stops are defined by the special setting TAB SPACING (see
:link refid=tsets reftype=hd.Settings:elink.).
.***
:h2 id=BM82.NEXT WORD
:p.Default key&colon. :HP2.Ctrl:EHP2.-:HP2.Right:EHP2.
:p.Moves the cursor to the first character of the next word on the line.
A word is considered to be sequence of non-blank characters.
.***
:h2 id=BM83.NOTHING
:p.This function does nothing.
It is used when customising the editor to remove the default function
from a key.
.***
:h2 id=BM84.PAGE DOWN
:p.Default key&colon. :HP2.PgDn:EHP2.
:p.Scrolls the current document down by one screen-full.
.***
:h2 id=BM85.PAGE UP
:p.Default key&colon. :HP2.PgUp:EHP2.
:p.Scrolls the current document up by one screen-full.
.***
:h2 id=BM86.PREVIOUS FILE
:p.Default keys&colon. :HP2.F11:EHP2.
:p.Makes the previous document in the edit ring the current document.
.***
:h2 id=BM87.PREVIOUS TAB
:p.Default key&colon. :HP2.Shift:EHP2.-:HP2.Tab:EHP2.
:p.Moves the cursor left to the previous tab stop.
Tab stops are defined by the special setting TAB SPACING (see
:link refid=tsets reftype=hd.Settings:elink.).
.***
:h2 id=BM88.PREVIOUS WORD
:p.Default key&colon. :HP2.Ctrl:EHP2.-:HP2.Left:EHP2.
:p.Moves the cursor to the first character of the previous word on the
line.
A word is considered to be sequence of non-blank characters.
.***
:h2 id=BM89.QUIT
:p.Default key&colon. :HP2.F3:EHP2.
:p.Removes the current document from the edit ring.
If changes have been made to the document since it was last saved the
message "Throw away changes? (y/n)" is displayed; hit either Y or
N as appropriate.
.***
:h2 id=BM90.REPEAT FIND
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.F:EHP2.
:p.Repeats the last LOCATE command that was issued.
.***
:h2 id=BM91.REPEAT LINE
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.R:EHP2.
:p.Inserts a copy of the current line immediately following the current
line.
.***
:h2 id=BM92.RIGHT
:p.Default key&colon. :HP2.Right:EHP2.
:p.Moves the cursor one character to the right.
.***
:h2 id=BM93.SAFE FILE
:p.Default key&colon. :HP2.F4:EHP2.
:p.If the document has changed this performs the :HP4.FILE:EHP4.
function, if the document has not changed it performs a :HP4.QUIT:EHP4..
.***
:h2 id=BM94.SAVE
:p.Default key&colon. :HP2.F2:EHP2.
:p.Writes the current document to disk under the name shown on the
status line.
.***
:h2 id=BM95.SCROLL DOWN
:p.Default key&colon. :HP2.Shift:EHP2.-:HP2.F4:EHP2.
:p.Scrolls the entire screen down by one line.
.***
:h2 id=BM96.SCROLL LEFT
:p.Default key&colon. :HP2.Shift:EHP2.-:HP2.F1:EHP2.
:p.Scrolls the entire screen left by one character.
.***
:h2 id=BM97.SCROLL RIGHT
:p.Default key&colon. :HP2.Shift:EHP2.-:HP2.F2:EHP2.
:p.Scrolls the entire screen right by one character.
.***
:h2 id=BM98.SCROLL UP
:p.Default key&colon. :HP2.Shift:EHP2.-:HP2.F3:EHP2.
:p.Scrolls the entire screen up by one line.
.***
:h2 id=BM99.SET MARK
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.L:EHP2.
:p.Marks one or more lines thus&colon.
:ul.
:li.If no lines are marked the current line only is marked.
:li.If one or more lines are already marked and the current line is
outside the mark, the mark is extended to include the current line.
:li.If one or more lines are already marked and the current line is
inside the mark, the mark is shrunk so the current line becomes the
bottom of the mark.
:eul.
.***
:h2 id=BM100.SPLIT LINE
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.S:EHP2.
:p.Splits the current line into two at the cursor position.
If the special setting AUTOMATIC INDENT is ON the split-off portion
aligns under the first non-blank character of the preceding line.
.***
:h2 id=BM101.START OF LINE
:p.Default key&colon. :HP2.Home:EHP2.
:p.Moves the cursor to the beginning of the current line.
.***
:h2 id=BM102.TOP OF FILE
:p.Default key&colon. :HP2.Ctrl:EHP2.-:HP2.Home:EHP2.
:p.Makes the current line the first line in the document, and positions
this line at the top of the screen.
.***
:h2 id=BM103.TOP OF MARK
:p.Default key&colon. :HP2.Alt:EHP2.-:HP2.Y:EHP2.
:p.Makes the current line the first marked line.
If the marked lines are in a different document that document will
become the current document.
.***
:h2 id=BM104.TOP OF SCREEN
:p.Default key&colon. :HP2.Ctrl:EHP2.-:HP2.PgUp:EHP2.
:p.Moves the cursor to the first line of the document on the screen.
.***
:h2 id=BM105.TRUNCATE LINE
:p.Default keys&colon. :HP2.Alt:EHP2.-:HP2.T:EHP2.
:p.Deletes all the characters on the current line to the right of the
cursor.
.***
:h2 id=BM106.UNDO
:p.Default key&colon. :HP2.F9:EHP2.
:p.Provides a very limited error recovery.
Any changes made to the current line are undone.
.***
:h2 id=BM107.UP
:p.Default key&colon. :HP2.Up:EHP2.
:p.Moves the cursor up one line.
.***
:h2 id=BM108.USER
:p.Default key&colon. :HP2.F5:EHP2.
:p.Causes the command specified by the special setting USER COMMAND (see
:link refid=tsets reftype=hd.Settings:elink.) to be executed.
Refer to :link refid=thelp reftype=hd.The HELP and USER Functions:elink. for more information about the
:HP4.USER:EHP4. function.
.***
:h1 id=tsets.Settings
:p.This section describes each of the special settings that may be
defined when customising the editor.
These are entered in a custom definition file using entries of the form&colon.
:xmp.
     SET item = value
:exmp.
.***
:h2 id=BM110.AUTOMATIC INDENT
:xmp.
     SET AUTOMATIC INDENT = ON
 or  SET AUTOMATIC INDENT = OFF
:exmp.
:p.This defines what the cursor will do when a new line is inserted.
If it is set ON the cursor will be automatically indented so it aligns
under the first non-blank character of the preceding line.
If it is set OFF the cursor will always move to the left hand edge.
:p.The action of word-spill and the functions :HP4.SPLIT LINE:EHP4. and
:HP4.ADJUST LINE:EHP4. are also affected by this setting.
.***
:h2 id=BM111.CGA SNOW
:xmp.
     SET CGA SNOW = ON
 or  SET CGA SNOW = OFF
:exmp.
:p.The old CGA card for the PC can produce "snow" on the display if
the display is updated at the wrong times.
This can be eliminated but at the expense of slowing down scrolling
speed.
When set to OFF :HP2.T:EHP2. will look for the presence of the old CGA
card and if it finds one it will ensure the snow does not occur.
When set to ON :HP2.T:EHP2. will not attempt to eliminate the snow.
:p.Some types of display may appear to :HP2.T:EHP2. as the old CGA
adapter when in fact they are not and so could never create the snow
problem.
This is true for PCJrs, 3270PCs, some clone displays and the LCD
displays found on many older laptops.
When using one of these displays setting CGA SNOW to ON may improve
scrolling speed somewhat.
:p.This setting is ignored if a more recent display adapter (EGA, VGA,
SVGA etc.) is installed, since these can never suffer from the
"snow" problem.
.***
:h2 id=BM112.COMMAND RECALL
:xmp.
     SET COMMAND RECALL = ON
 or  SET COMMAND RECALL = OFF
:exmp.
:p.This specifies whether or not previous command line commands will be
kept available for recall by the cursor up and cursor down keys.
If it is set ON command line commands are saved, if it is set OFF
commands cannot be recalled.
.***
:h2 id=BM113.COMMAND TOGGLE
:xmp.
     SET COMMAND TOGGLE = DATA
 or  SET COMMAND TOGGLE = COMMAND
:exmp.
:p.This determines whether, when a new document is loaded, the cursor
starts in the data area or on the command line.
.***
:h2 id=BM114.EXACT MATCH
:xmp.
     SET EXACT MATCH = ON
 or  SET EXACT MATCH = OFF
:exmp.
:p.This determines whether, by default, LOCATE commands take account of
upper and lower case during searching.
If set ON the search must match exactly, if set OFF upper and lower case
are considered identical.
The default can always be overridden with the locate command options
"e" or "c".
:note.Exact case match searches are very much faster and would be
preferable when searching large documents.
.***
:h2 id=BM115.FOCUS LINE
:xmp.
     SET FOCUS LINE = row
 or  SET FOCUS LINE = -row
 or  SET FOCUS LINE = OFF
:exmp.
:p.The FOCUS LINE is the line within the data area that is used to
display the current line when the :HP4.FOCUS:EHP4. keyboard function is
used.
It is also the line used to display the result of a LOCATE or GOTO
command.
The line may be specified as a positive number from the top of the
screen or a negative number from the bottom of the screen.
:p.If set to OFF no focus row is defined.
The :HP4.FOCUS:EHP4. function will have no effect and the target of
LOCATE and GOTO commands will be displayed on whatever line currently
contains the cursor.
.***
:h2 id=BM116.HELP COMMAND
:xmp.
     SET HELP COMMAND = command
:exmp.
:p.The ":font facename=Courier size=0x0.command:font facename=default." should be a enclosed in single or
double quotes.
It is the :HP2.T:EHP2. command that will be executed when the
:HP4.HELP:EHP4. keyboard function is pressed.
Any valid :HP2.T:EHP2. command can be given.
:p.For example&colon.
:xmp.
     SET HELP COMMAND = "T THELP.HLP"
:exmp.
.***
:h2 id=BM117.HELP LINE
:xmp.
     SET HELP LINE = text
:exmp.
:p.The ":font facename=Courier size=0x0.text:font facename=default." should be enclosed in single or double
quotes.
It is the text that will be displayed on the bottom line of the screen
when there are no messages.
:p.Several ":font facename=Courier size=0x0.text:font facename=default." strings may be specified and they will
concatenated together, this can be useful if you want to split the text
over more than one line.
:p.For example&colon.
:xmp.
     SET HELP LINE = "F1=Help F2=Save F3=Quit"
:exmp.
.***
:h2 id=BM118.INSERT CURSOR
:xmp.
     SET INSERT CURSOR = LINE
 or  SET INSERT CURSOR = HALF
 or  SET INSERT CURSOR = FULL
:exmp.
:p.This sets the shape of the cursor that is used when :HP2.T:EHP2. is
in "insert" typing mode.
LINE uses an underscore line cursor, HALF uses a half-height character
block and FULL uses a full-height character block.
.***
:h2 id=BM119.INSERT TOGGLE
:xmp.
     SET INSERT TOGGLE = REPLACE
 or  SET INSERT TOGGLE = INSERT
:exmp.
:p.This determines whether :HP2.T:EHP2. initially starts up in
"insert" or "replace" mode.
.***
:h2 id=BM120.KEYBOARD TYPE
:xmp.
     SET KEYBOARD TYPE = DEFAULT
 or  SET KEYBOARD TYPE = STANDARD
:exmp.
:p.If set to DEFAULT :HP2.T:EHP2. will test if an Enhanced Keyboard
(with 12 F-keys across the top) is installed and if it finds one it will
automatically make full use of it.
:p.If set to STANDARD :HP2.T:EHP2. will assume the keyboard is an old
style keyboard (with 10 F-keys over on the left).
This provides compatibility with some clone BIOSs and with some older
TSR programs, but loses the ability to use the newer keys like F11 and
F12.
See :link refid=keybd reftype=hd.The Enhanced Keyboard:elink. for more details.
.***
:h2 id=BM121.LINE END
:xmp.
     SET LINE END = DEFAULT
 or  SET LINE END = DOS
 or  SET LINE END = UNIX
:exmp.
:p.This determines how line ends will be interpreted when files are read
from and written to disk.
If set to DOS line ends are indicated by the pair of characters hex 0D
(carriage return) followed by hex 0A (line feed), as is the standard for
DOS applications.
If set to UNIX lines ends are indicated by the single character hex 0A
(new line), as is the standard for UNIX applications.
:p.When set to DEFAULT, :HP2.T:EHP2. will read both DOS and UNIX style
files and will always write DOS style files.
.***
:h2 id=BM122.REPLACE CURSOR
:xmp.
     SET REPLACE CURSOR = LINE
 or  SET REPLACE CURSOR = HALF
 or  SET REPLACE CURSOR = FULL
:exmp.
:p.This sets the shape of the cursor that is used when :HP2.T:EHP2. is
in "replace" typing mode.
LINE uses an underscore line cursor, HALF uses a half-height character
block and FULL uses a full-height character block.
.***
:h2 id=BM123.RIGHT MARGIN
:xmp.
     SET RIGHT MARGIN = column
 or  SET RIGHT MARGIN = OFF
:exmp.
:p.This sets an initial right hand margin column.
See :link refid=wordp reftype=hd.Word Processing:elink. for details about the function of the margin.
If set to OFF no initial margin is set.
.***
:h2 id=BM124.SEGMENT SIZE
:xmp.
     SET SEGMENT SIZE = DEFAULT
 or  SET SEGMENT SIZE = size
:exmp.
:p.This determines the size of the storage segments that
:HP2.T:EHP2. obtains from the operating system.
It should be set to a number between 8 and 64 which specifies the
segment size in K-bytes, or to DEFAULT which gives the best size for the
operating system.
In turn this segment size determines the maximum line length that can be
handled; the maximum being a few bytes less than the segment size.
:p.In general DOS works best with smaller segment sizes and OS/2 works
better with larger sizes.
Setting DEFAULT will provide 8K segments under DOS and 64K under OS/2.
.***
:h2 id=BM125.TAB EXPAND
:xmp.
     SET TAB EXPAND = ON
 or  SET TAB EXPAND = OFF
:exmp.
:p.This setting determines how :HP2.T:EHP2. will treat tab characters in
documents that are read from disk.
If set ON tabs will be expanded with spaces up to the next tab stop (as
determined by the TAB SPACING setting).
If set OFF tabs are treated just like any other character.
:note.If set ON the tabs are expanded to spaces as the document is
loaded from disk and are then discarded.
If the document is saved it will not contain the original tab
characters.
.***
:h2 id=BM126.TAB SPACING
:xmp.
     SET TAB SPACING = number
:exmp.
:p.Tabs are equally spaced across the document starting from column 1.
The spacing is set with this option.
:p.For example&colon.
:xmp.
     SET TAB SPACING = 8
:exmp.
.***
:h2 id=BM127.USER COMMAND
:xmp.
     SET USER COMMAND = command
:exmp.
:p.The ":font facename=Courier size=0x0.command:font facename=default." should be enclosed in single or double
quotes.
It is the :HP2.T:EHP2. command that will be executed when the
:HP4.USER:EHP4. keyboard function is pressed.
Any valid :HP2.T:EHP2. command can given.
:p.For example&colon.
:xmp.
     SET USER COMMAND = "DOS"
:exmp.
.***
:h1 id=tmsgs.Messages
:p.This section provides a list of all the messages that
:HP2.T:EHP2. produces.
It gives the reasons for each message and the action that should be
taken.
:p.Except where noted these messages will all be displayed in the
editor's message line and will be removed at the next keystroke.
:p.:HP2.Cannot call OS:EHP2.
:p.The DOS command was unable to start up a secondary DOS or OS/2
command processor.
Normally this indicates that there is not enough free memory, you will
have to remove some documents from the ring if you want to issue the DOS
command.
:p.If you believe there is enough free memory and the problem still
exists it may be that DOS cannot locate its command processor.
From the DOS prompt issue the command :font facename=Courier size=0x0.SET:font facename=default.; you should see a
series of lines one of which is of this form indicating where your copy
of COMMAND.COM is located&colon.
:xmp.
     COMSPEC=d&colon.&bslash.path&bslash.COMMAND.COM
:exmp.
:p.If this is not present or is incorrect you may need to add a :font facename=Courier size=0x0.SET
COMSPEC=:font facename=default. line to your AUTOEXEC.BAT file.
:p.:HP2.Cannot open file:EHP2.
:p.:HP2.T:EHP2. is unable to open the requested disk file.
Normally this means that the filename is invalid for some reason,
perhaps it contains characters not valid in a file name, or perhaps it
conflicts with the name of a device or directory already on the disk.
:p.On a diskette system it may also indicate that the diskette drive is
not ready, perhaps it does not contain a diskette or the drive door is
open.
:p.:HP2.Error reading file:EHP2.
:p.An error occurred while a document was being read from disk.
This is rare error and might indicate there are problems with the disk.
:p.:HP2.Error writing file - NOT saved:EHP2.
:p.An error occurred while a document was being written to disk.
Normally this means the disk became full while the file was being
written.
You should save the file to another disk, one that has enough free
space.
:p.:HP2.File not found:EHP2.
:p.You attempted to GET a file that does not exist.
Check the spelling of the filename, maybe the file you want is not in
the current directory and so needs a drive and/or directory path
pre-pended to it.
:p.:HP2.Incorrect parameter:EHP2.
:p.The parameter supplied to a :HP2.T:EHP2. command was incorrect.
For the GOTO and MARGIN command the parameter must be a number less than
65535, for the QUIT command no parameter other than ALL is valid.
:p.:HP2.Line too long:EHP2.
:p.This message indicates an attempt was made to load or to create a
line longer than the maximum possible line length.
If this happens while loading a file the load will be aborted, the
document in memory will be incomplete so you should QUIT straight away
without saving.
Maximum line length is affected by the SEGMENT SIZE special setting -
refer to :link refid=tsets reftype=hd.Settings:elink. for more details.
:p.:HP2.Loading...:EHP2.
:p.Displays while a document is being loaded from disk.
:p.:HP2.Mark already set:EHP2.
:p.You tried to mark a line, but a mark already exists in another
document in the ring, only one document at a time may contain a mark.
If you no longer require the other mark first use the function
:HP4.CLEAR MARK:EHP4..
:p.:HP2.New file:EHP2.
:p.You asked to edit a document that does not exist on disk.
:HP2.T:EHP2. has created a new empty document with the name you
specified.
:p.:HP2.No filename given:EHP2.
:p.The commands GET, PUT and APPEND must have a filename parameter
specified.
:p.:HP2.No marked lines:EHP2.
:p.The commands PUT and APPEND work on the currently marked lines.
Some lines must be marked if the command is used.
:p.:HP2.No match found:EHP2.
:p.The ":font facename=Courier size=0x0.target:font facename=default." specified in a LOCATE or CHANGE command
cannot be found.
Remember that these commands only search from the current position
forwards to the end of the document.
To search from the top first use the function :HP4.TOP OF FILE:EHP4..
:p.:HP2.Out of memory:EHP2.
:p.:HP2.T:EHP2. has run out of memory, you should save one or more of
the documents in the ring to make space before continuing.
Most :HP2.T:EHP2. commands and functions have no effect while the "Out
of memory" condition exists.
:p.:HP2.Press any key to continue:EHP2.
:p.This message is printed by the secondary DOS or OS/2 command shell
started by the DOS command.
It is produced just before the command shell returns to :HP2.T:EHP2.,
and allows you some time to read whatever output is on the screen.
:p.:HP2.Printer not ready:EHP2.
:p.The PRINT command could not complete correctly.
This may mean the printer is not turned on or set online, or it is not
connected, or that it has run out of paper.
Or any number of other reasons that cause printers to fail.
:p.:HP2.Printing...:EHP2.
:p.Displays while a document is being printed.
:p.:HP2.Saving...:EHP2.
:p.Displays while a document is being saved.
:p.:HP2.Source and destination conflict:EHP2.
:p.You cannot move or copy marked lines on top of themselves.
Move the cursor out of the marked area and try again.
:p.:HP2.T cannot be started:EHP2.
:p.This message is printed by DOS if, when :HP2.T:EHP2. is first loaded,
there is not enough free memory get it started.
This can happen if you have a lot of TSR type programs loaded or if you
are nested inside several other applications.
:p.:HP2.Throw away changes? (y/n):EHP2.
:p.You tried to QUIT a document that has been changed since it was last
saved.
This message gives you a chance to save changes if the QUIT was selected
accidentally.
:p.:HP2.Type a character...:EHP2.
:p.The :HP4.ESCAPE:EHP4. function takes the next character entered on
the keyboard as an absolute ASCII code and enters it into the document.
While :HP4.ESCAPE:EHP4. is waiting for this character it displays a
message.
:p.:HP2.Unknown command:EHP2.
:p.You entered a command on the command line that is not a
:HP2.T:EHP2. command.
Check the spelling of the command, or precede it by the word DOS (or a
full stop) if it is a DOS or OS/2 command rather than a
:HP2.T:EHP2. command.
:p.:HP2.Yes/No/Go/Last/Quit?:EHP2.
:p.The CHANGE command issues this message when it finds its
":font facename=Courier size=0x0.target:font facename=default." text.
Refer to :link refid=chang reftype=hd.CHANGE:elink. for details of the CHANGE command.
.***
:h1 id=defks.User Definable Keys
:p.This section lists all the valid names and combinations of the user
definable keys that can be entered in a custom definition file.
:p.Keys shown in parentheses are only available with the Enhanced
Keyboard.
spilt=no mindepth=p5.
:font facename='System Monospaced' size=15x12.:lines.
Ŀ
          Unshifted Keys                                                      
Ĵ
 Esc            Enter          Tab            Backspace      (PadEnter)   
Ĵ
 F1             F2             F3             F4             F5           
Ĵ
 F6             F7             F8             F9             F10          
Ĵ
 (F11)          (F12)                                                     
Ĵ
 Home           End            PgUp           PgDn                        
Ĵ
 Left           Right          Up             Down                        
Ĵ
 Ins            Del            (Pad5)                                     

:elines.:font facename=default size=0x0.
:font facename='System Monospaced' size=15x12.:lines.
Ŀ
          Shift Keys                                                          
Ĵ
 s-Tab                                                                    
Ĵ
 s-F1           s-F2           s-F3           s-F4           s-F5         
Ĵ
 s-F6           s-F7           s-F8           s-F9           s-F10        
Ĵ
 (s-F11)        (s-F12)                                                   

:elines.:font facename=default size=0x0.
:font facename='System Monospaced' size=15x12.:lines.
Ŀ
          Ctrl Keys                                                           
Ĵ
 c-Enter        (c-Tab)        c-Backspace    (c-PadEnter)                
Ĵ
 c-a            c-b            c-c            c-d            c-e          
Ĵ
 c-f            c-g            c-h            c-i            c-j          
Ĵ
 c-k            c-l            c-m            c-n            c-o          
Ĵ
 c-p            c-q            c-r            c-s            c-t          
Ĵ
 c-u            c-v            c-w            c-x            c-y          
Ĵ
 c-z                                                                      
Ĵ
 c-2            c-6                                                       
Ĵ
 c-F1           c-F2           c-F3           c-F4           c-F5         
Ĵ
 c-F6           c-F7           c-F8           c-F9           c-F10        
Ĵ
 (c-F11)        (c-F12)                                                   
Ĵ
 c-Home         c-End          c-PgUp         c-PgDn                      
Ĵ
 c-Left         c-Right        (c-Up)         (c-Down)                    
Ĵ
 (c-Ins)        (c-Del)        (c-Pad5)                                   
Ĵ
 c--            c-[            c-]            c-\                         

:elines.:font facename=default size=0x0.
:font facename='System Monospaced' size=15x12.:lines.
鎎
          Alt Keys                                                            
ǎ
 (a-Enter)      (a-Tab)        (a-Backspace)  (a-PadEnter)                
ǎ
 a-a            a-b            a-c            a-d            a-e          
ǎ
 a-f            a-g            a-h            a-i            a-j          
ǎ
 a-k            a-l            a-m            a-n            a-o          
ǎ
 a-p            a-q            a-r            a-s            a-t          
ǎ
 a-u            a-v            a-w            a-x            a-y          
ǎ
 a-z                                                                      
ǎ
 a-1            a-2            a-3            a-4            a-5          
ǎ
 a-6            a-7            a-8            a-9            a-0          
ǎ
 a-F1           a-F2           a-F3           a-F4           a-F5         
ǎ
 a-F6           a-F7           a-F8           a-F9           a-F10        
ǎ
 (a-F11)        (a-F12)                                                   
ǎ
 (a-Home)       (a-End)        (a-PgUp)       (a-PgDn)                    
ǎ
 (a-Left)       (a-Right)      (a-Up)         (a-Down)                    
ǎ
 (a-Ins)        (a-Del)                                                   
ǎ
 a            a-=                                                       
ǎ

:elines.:font facename=default size=0x0.
:euserdoc.
