#ifndef SLICKC_H
#define SLICKC_H


#define HVAR   int
#define VSHVAR  int
#define VSHREFVAR VSHVAR
//typedef void *VSPVOID;
//typedef char *VSPSZ;

#define VSPVOID void *
#define VSPSZ const char *

extern "C" {
#define VSHVAR_RC    1
#define VSHVAR_DOT   2

   struct VSARGTYPE {
      int kind;
 #define VSARGTYPE_INT      0
 #define VSARGTYPE_LONG     1
 #define VSARGTYPE_HREFVAR  2
 #define VSARGTYPE_PSZ      3
 #define VSARGTYPE_PLSTR    4
 #define VSARGTYPE_HVAR     5
      union {
         int i;
         long l;
         VSHVAR hvar;  // This case is easier to remember than hVar
         VSHVAR hVar;
         const char *psz;
         VSLSTR *plstr;
      }u;
   };

// Note that xprintf and mprintf only work with some compilers
// Not sure what compilers are compatible.

// Windows: xprintf,mprintf,dfprintf works only with Visual C++
// UNIX: mprintf not supported
void xprintf(char *s, ...);  // Display in scrolling window
void mprintf(char *s, ...);  // Display in message box
void dfprintf(char *s, ...); // Append to debug file. VERY SLOW.
                             // Opens and closes file on each call.

// Use vsSay to implement your own xprintf
void VSAPI vsprintln(const char *pBuf,int BufLen=-1);
void VSAPI vsprint(const char *pBuf,int BufLen=-1);

#include <vskeys.h>
char *VSAPI vsEvent2Name(int event,char *pszName,int MaxNameLen,char option='L' /*SLC*/,int *pMaxNameLen=0, int version=0);
int VSAPI vsEvent2Index(int event,int version=0);
int VSAPI vsIndex2Event(int index,int version=0);
int VSAPI vsSetEventTabIndex(int keytab_index,int key_index,int index,int version=0);
int VSAPI vsEventTabIndex(int root_keytab_index,int mode_keytab_index,
                          int key_index,int return_used_keytab=0,int version=0);
void VSAPI vsCallKey(int wid,int event,const char *pszShowKeys=0,int Reserved=1,int version=0);
VSHVAR VSAPI vsHvarNextEl(VSHVAR hvarArrayOrHashTab,HVAR hvarstart);
int VSAPI vsHvarIsEmpty(VSHVAR hvar);
void VSAPI vsHvarMakeEmpty(VSHVAR hvar);
VSHVAR VSAPI vsHvarArrayEl(VSHVAR hVarArrayEl,int i);
int VSAPI vsHvarArrayLength(HVAR hvar);
VSHVAR VSAPI vsHvarHashtabEl(VSHVAR hVarHashtab,const char *pBuf,int BufLen=-1);
VSPLSTR VSAPI vsHvarGetLstr(VSHVAR hVar);
void VSAPI vsHvarArrayDeleteEl(HVAR hvarArray,int start,int Nofitems=1);
void VSAPI vsHvarHashtabDeleteEl(HVAR hvarHashtab,const char *pBuf,int BufLen=-1);
int VSAPI vsHvarGetI(VSHVAR hVar);
int VSAPI vsHvarSetI(VSHVAR hVar,int value);
int VSAPI vsHvarSetB(VSHVAR hVar,void *pBuf,int BufLen);
int VSAPI vsHvarSetZ(VSHVAR hVar,const char *pszValue);
void VSAPI vsDllInit(void);
void VSAPI vsDllExit(void);

int VSAPI vsQNofInternalClipboards(void);
int VSAPI vsLibExport(const char *func_proto_p,const char *name_info_p,int arg2,void *pfn);
int VSAPI vsDllExport(const char *pszFuncProto,const char *pszNameInfo,int arg2);
int VSAPI vsPropGetI(int wid,int prop_id);
int VSAPI vsPropGetZ(int wid,int prop_id,char *pszValue,int ValueLen,int *pValueLen=0);
int VSAPI vsPropGetB(int wid,int prop_id,void *pBuf,int BufLen,int *pBufLen=0);

void VSAPI vsPropSetI(int wid,int prop_id,int value);
void VSAPI vsPropSetZ(int wid,int prop_id,const char *pszValue);
void VSAPI vsPropSetB(int wid,int prop_id,const void *pBuf,int BufLen);

int VSAPI vsFileOpen(const char *pszFilename,int option);
int VSAPI vsFileClose(int fh);
int VSAPI vsFileRead(int fh,void *pBuf,int BufLen);
int VSAPI vsFileWrite(int fh,const void *pBuf,int BufLen);
long VSAPI vsFileSeek(int fh,long seekpos,int option);
int VSAPI vsFileFlush(int fh);
int VSAPI vsFileMove(const char *pszDestFilename,const char *pszSrcFilename);


#define VSTYPE_PROC      0x1
#define VSTYPE_VAR       0x4
#define VSTYPE_EVENTTAB  0x8
#define VSTYPE_COMMAND   0x10
#define VSTYPE_GVAR      0x20
#define VSTYPE_GPROC     0x40
#define VSTYPE_MODULE    0x80
#define VSTYPE_PICTURE   0x100
#define VSTYPE_BUFFER    0x200
#define VSTYPE_OBJECT    0x400
#define VSTYPEC_OBJECTMASK    0xf800
#define VSTYPEC_OBJECTSHIFT   11
#define VSTYPE_INFO      0x10000
#define VSTYPE_MISC      0x20000000
#define VSTYPE_DLLCALL   0x40000   /* Entries with this flag MUST also have the
                                  VSTYPE_COMMAND or VSTYPE_PROC flag. */
#define VSTYPE_DLLMODULE 0x80000
#define VSTYPE_BUILT_IN  0x40000000

#define vsoi2type(oi) (VSTYPE_OBJECT|(oi<<VSTYPEC_OBJECTSHIFT))


int VSAPI vsNameSetInfo(int index,char *pInfo,int InfoLen= -1);
char *VSAPI vsNameInfo(int index,char *pszInfo,int MaxInfoLen,int *pMaxInfoLen=0);
int VSAPI vsNameType(int index);
long VSAPI vsNameCallable(int index);
long VSAPI vsNameDllAddr(int index);
char *VSAPI vsNameName(int index,char *pszName,int MaxNameLen,int *pMaxNameLen=0);
int VSAPI vsNameInsert(const char *pszName,int kind,const char *pszInfo=0,int reserved=0);
void VSAPI vsNameDelete(int index,int reserved=0);
int VSAPI vsNameReplace(int index,const char *pszName,const char *pszInfo=0,int reserved=0);
int VSAPI vsNameMatch(const char *pszNamePrefix,int start,int flags);
int VSAPI vsFindIndex(const char *pszName,int flags);
void VSAPI vsCallIndex(int wid,int index,int Nofargs,VSARGTYPE *pArgList);

int VSAPI vsSetEnv(const char *pszName,const char *pszValue);
char * VSAPI vsGetEnv(const char *pszName);
void VSAPI vsFree(void *pBuf);
void *VSAPI vsAlloc(int len);
void *VSAPI vsRealloc(void *pBuf,int len);

VSHVAR VSAPI vsGetVar(int index);

VSHVAR VSAPI vsArg(int ParamNum);

char * VSAPI vsZLstrcpy(char *pszDest,VSPLSTR plstrSource,int DestLen);


int VSAPI vsHvarFree(VSHVAR hVar);
VSHVAR VSAPI vsHvarAlloc(VSHVAR InitTohVar=0);
int VSAPI vsHvarGetLstr2(VSHVAR hVar,VSLSTR **pplstr,VSLSTR *ptemps);

int VSAPI vsHvarGetBool(VSHVAR hVar,int *pbool);
int VSAPI vsHvarGetI2(VSHVAR hVar,int *pi);
int VSAPI vsHvarIsInt(VSHVAR hVar);
int VSAPI vsHvarSetL(VSHVAR hVar,long i);
int VSAPI vsHvarSetLstr(VSHVAR hVar,VSLSTR *plstr);



#define VSVF_FREE     0   // Variable is on free list
               // If you get this, you screwed up with pointers.
#define VSVF_LSTR     2
#define VSVF_INT      3
#define VSVF_ARRAY    4
#define VSVF_HASHTAB  5
#define VSVF_PTR      7
#define VSVF_EMPTY    8
#define VSVF_FUNPTR   9

int VSAPI vsHvarFormat(VSHVAR hVar);

int vsShell(const char *pszCommand,const char *pszOptions,const char *pszAltShell);

void VSAPI vsPropSetL(int wid,int prop_id,long value);
long VSAPI vsPropGetL(int wid,int prop_id);
int VSAPI vsTopLstr(VSPLSTR *pplstr);

#define VSSTRPOSFLAG_IGNORE_CASE  1
#define VSSTRPOSFLAG_RE    2
#define VSSTRPOSFLAG_WORD  4
//#define VSSTRPOSFLAG_EXACT 8
//#define VSSTRPOSFLAG_VERSION 16
#define VSSTRPOSFLAG_UNIXRE 32
#define VSSTRPOSFLAG_BINARY  64
#define VSSTRPOSFLAG_BRIEFRE 128

int VSAPI vsStrPos(const char *pSearchFor,int SearchForLen,const char *pBuf,int BufLen,
                int start,int SearchFlags);
int VSAPI vsStrPosMatchLength(int MatchGroup);
int VSAPI vsStrPosMatchStart(int MatchGroup);
int VSAPI vsStrLastPos(const char *pSearchFor,int SearchForLen,const char *pBuf,int BufLen,
                int start,int SearchFlags);


}

#endif
