/*
$VerboseHistory: ada.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/07/1998  Time:05:03p
 * Updated in \vault\vsship30a\
 * Last Modified: 01/07/1998 05:01p
 * Comment:
 * Changed to support enhanced tagging
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 08/28/1997 10:35a
 * Comment:
 * Adding new 3.0 stuff
*/
/* 11/19/1996 - Ada95 support courtesy of Pat Rogers */

/*for Ada syntax expansion/indenting may be accessed from SLICK's
  file extension setup menu (CONFIG, "File extension setup...").

  The extension specific options is a string of five numbers separated
  with spaces with the following meaning:

    Position       Option
       1             Minimum abbreviation.  Defaults to 1.  Specify large
                     value to avoid abbreviation expansion.
       2             Keyword case.  Values may be 0,1, or 2 which correspond
                     to lower case, upper case, and capitalized.  Default
                     is 0.
       3             Begin/end style. Not applicable to Ada.

       4             reserved.
       5             reserved.

*/
#include "slick.sh"

#define EXTENSION 'ada'
#define MODE_NAME 'Ada'

/* Spell keywords the same as Pascal */
static _str word_case(s)
{
   parse name_info(p_index) with . . . scase .;
   if ( scase==0 ) {
      return(lowcase(s)); /* Lower case language key words. */
   } else if ( scase==1 ) {
      return(upcase(s));    /* Upper case language key words. */
   }
   if (substr(s,1,1) == ' ') {
      i=verify(s,' '\t);
      if (!i) {
         return(s);
      }
   } else {
      i=1;
   }
   return(substr(s,1,i-1):+upcase(substr(s,i,1)):+lowcase(substr(s,i+1)));  /* Capitalize */
}

/* This command forces the current buffer to be in Ada mode. */
/* Unfortunately, this command only changes the mode-name, tab options, */
/* word wrap options, and mode key table. */
/* Not necessary for syntax expansion and indenting. */
_command void ada_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   /* The SELECT_EDIT_MODE procedure can find the file extension setup */
   /* data by passing it the 'ada' extension. */

   call select_edit_mode('ada');
}

/* This command is bound to the ENTER key.  It looks at the text around the */
/* cursor to decide whether to indent another level.  If it does not, the */
/* root key table definition for the ENTER key is called. */
_command void ada_enter () name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style .;
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) ||
         ada_expand_enter(p_SyntaxIndent,expand) ) {
       call_root_key(ENTER);
   } else {
      _undo('S');
   }
}

/* This command is bound to the SPACE BAR key.  It looks at the text around */
/* the cursor to decide whether insert an expanded template.  If it does not, */
/* the root key table definition for the SPACE BAR key is called. */
_command void ada_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   was_space=(last_event():==' ');
   parse name_info(_edit_window().p_index) with . expand . . be_style .;
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      ada_expand_space(p_SyntaxIndent,be_style) ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ');
         } else {
            keyin(' ');
         }
      }
   } else if (_argument=='') {
      _undo('S');
   }
}

/* These constant strings have been defined to make the syntax
 expansion and indenting more data driven and to speed up
 determining whether special processing must be performed. There
 must be a space before and after each key word. */

/* Words must be in sorted order */
#define ENTER_WORDS (' accept begin case else elsif if loop procedure record':+\
                   ' select while ')
#define EXPAND_WORDS (' abort abstract accept access aliased array begin case constant declare delay ':+\
                   ' delta digits else elsif entry exception exit for function generic if limited ':+\
                   ' loop others package pragma private procedure protected raise range record ':+\
                   ' renames requeue return reverse select separate subtype tagged task terminate ':+\
                   ' type until when while with ')
#define DECL_WORDS ' type declare '
#define NAMED_END ' accept function package procedure task '
#define LABEL_WORDS ' declare begin loop while for '
#define RESERVED_WORDS (' abort abs abstract accept access aliased all and array at begin body case constant declare delay':+\
                     ' delta digits do else elsif end entry exception exit for function generic goto if in is limited':+\
                     ' loop mod new not null of or others out package pragma private procedure protected raise range record':+\
                     ' rem renames requeue return reverse select separate subtype tagged task terminate':+\
                     ' then type until use when while with xor ')


static _str space_words[]={
   'abort','abstract','accept','access','aliased','array','begin','case','constant','declare','delay',
   'delta','digits','else','elsif','entry','exception','exit','for','function','generic','if','limited',
   'loop','others','package','pragma','private','procedure','protected','raise','range','record',
   'renames','requeue','return','reverse','select','separate','subtype','tagged','task','terminate',
   'type','until','when','while','with'};

/* Returns non-zero number if fall through to enter key required */
static _str ada_expand_enter(syntax_indent,expand)
{
   status=0;
   get_line(line);
   width=(pos('[~ \t]',line,1,'r')-1);

   /* strip comments and get the first word */
   parse line with line '--' .;
   
   // Check for a label.  Two cases: a label by itself on
   // a line, or a label on the same line as expanded text.
   if ( pos(':',line) ) { // found a colon, which might be for a label
      parse line with '[ \t]@','r' temp_label ':' remainder '--','r' .;
      if ( remainder == '' ) { // may be a label for next line
         if ( temp_label != '' && remainder == '' ) {
            //this is a stand-alone label
            indent_on_enter(syntax_indent);
            return(0); //don't do the keyword evaluation below, and no need for root enter key
         }
      } else { // something after the potential label
         parse temp_label with temp_label ':b','r' label_remainder;
         //messagenwait("temp_label is '"temp_label"'")
         if ( pos(temp_label,RESERVED_WORDS) == 0 ) { // really is a labeled statment
            // the following is the same as the original, except parses remainder
            parse remainder with '[~ \t]','r' +0 word ':b','r' func_name '[ (]','r' rest ' |$|--','r' .;
            first_word=lowcase(word);
         } else { // treat in the usual way, for such things as 'protected T( X : Integer ) is'
            //messagenwait("seeing nonlabeled laine")
            parse line with '[~ \t]','r' +0 word ':b','r' func_name '[ (]','r' rest ' |$|--','r' .;
            first_word=lowcase(word);
         }
      }
   } else { // no colon on this line so treat in the original way
      parse line with '[~ \t]','r' +0 word ':b','r' func_name '[ (]','r' rest ' |$|--','r' .;
      first_word=lowcase(word);
   }
   
   //messageNwait('first_word='first_word'  func_name='func_name'  rest='rest);
   if ( first_word=='entry' ) {
      if ( declarative_part() ) {
          insert_line indent_string(width);
      } else { // body
          down(2); // to the 'end;', if this is the first time
          get_line(next_line);
          if ( pos('end;',next_line) ) {
             replace_line(substr(next_line,1,length(next_line)-1)' 'func_name';');
             up(); // to the 'begin'
             maybe_end_line();
             indent_on_enter(syntax_indent);
          } else {
             up(2);
          }
      }
   } else if ( first_word=='accept' ) { // no 'begin'
       down(); // to the 'end;'
       get_line(next_line);
       replace_line(substr(next_line,1,length(next_line)-1)' 'func_name';');
       up();
       maybe_end_line();
       indent_on_enter(syntax_indent);
   } else if ( first_word=='for' ) {
      // move to fields of 'for' statement
      line=expand_tabs(line);
      parse lowcase(line) with before 'in';
      if ( length(before)+1>=p_col ) {
         p_col=length(before)+4;  //move to the next field
      } else { //ready for sequence_of_statements
         maybe_end_line();
         call indent_on_enter(syntax_indent);
      }
   } else if ( first_word=='package' ) {
      // not expanding package declarations due to generic instantations etc.
      // should only expand the body if this is the last line in the buffer
      file_status=down();
      if (file_status==BOTTOM_OF_FILE_RC) {  // should really be if "no text following"...
         if ( lowcase(func_name)=='body' ) {
            //message("package body at eof")
            insert_line(indent_string(width+syntax_indent));
            // no 'begin' since not frequently needed
            insert_line(indent_string(width)word_case('end ')rest';');
            up(2);
            insert_line(indent_string(width+syntax_indent));
            insert_line(indent_string(width+syntax_indent));
            insert_line(indent_string(width+syntax_indent));
            insert_line(indent_string(width+syntax_indent));
            up();
         } else {
            //message("eof but not a package body")
            maybe_end_line();
            indent_on_enter(syntax_indent);
         }
      } else {
         //message("not at eof")
         up(); // since went down to check for eof
         maybe_end_line();
         indent_on_enter(syntax_indent);
      }
   } else if ( first_word=='protected' ) {
      //messagenwait("seeing protected")
      if ( lowcase(func_name)=='body' ) {
         down();
         get_line(next_line);
         j=pos(';',next_line)-1;
         if ( j>=1 ) {
            replace_line(substr(next_line,1,j):+' 'rest';');
         }
         up();
      } else if ( lowcase(func_name)=='type' ) {
         //messagenwait("seeing type")
         insert_line(indent_string(width)word_case('private'));
         down();
         get_line(next_line);
         j=pos(';',next_line)-1;
         if ( j>=1 ) {
            parse rest with func_name '[ (]','r' rest;
            replace_line(substr(next_line,1,j):+' 'func_name';');
         }
         up(2);
      } else { // object declaration
         //messagenwait("seeing object")
         insert_line(indent_string(width)word_case('private'));
         down();  // to the 'end;'
         get_line(next_line);
         replace_line(substr(next_line,1,length(next_line)-1)' 'func_name';');
         up(2);
      }
      maybe_end_line();
      indent_on_enter(syntax_indent);
   } else if ( first_word=='task' ) {
      if ( lowcase(func_name)=='body' ) {
         insert_line(indent_string(width):+word_case('begin'));
         down();
         get_line(next_line);
         j=pos(';',next_line)-1;
         if ( j>=1 ) {
            replace_line(substr(next_line,1,j):+' 'rest';');
         }
      } else if (lowcase(func_name)=='type' ) {
         down();
         get_line(next_line);
         j=pos(';',next_line)-1;
         if ( j>=1 ) {
            parse rest with func_name '[ (]','r' rest;
            replace_line(substr(next_line,1,j):+' 'func_name';');
         }
      } else { // object declaration
         down(); // to the 'end;'
         get_line(next_line);
         replace_line(substr(next_line,1,length(next_line)-1)' 'func_name';');
      }
      up();
      maybe_end_line();
      indent_on_enter(syntax_indent);
   } else if ( pos(' 'first_word' ',ENTER_WORDS,1) ) {
      maybe_end_line();
      indent_on_enter(syntax_indent);
   } else {
     status=1;     // just do a normal enter key
   }
   return(status);
}

/* Returns non-zero number if fall through to space bar key required */
static _str ada_expand_space(syntax_indent,be_style)
{
   /* Put first word of line in lower case into word variable. */
   get_line(line);
   line=strip(line,'T');
   
   /* procede only for cursor on first word */
   if ( p_col!=text_col(line)+1 ) {
      return(1);
   }
   word=strip(line);
   aliasfilename='';
   if ( word=='') {
      return(1);    /* Fall through to space bar key. */
   }
   
   label='';
   if ( pos(':',line,1) == 0 ) { // no colon on this line
      orig_word=lowcase(strip(line));
      word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename);
      if (word!=''&&aliasfilename!='') {
         if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
            _insert_text(' ');
            return(0);
         }
         col=p_col-length(orig_word);
         if (col==1) {
            line_prefix='';
         } else {
            line_prefix=indent_string(col-1);
         }
         replace_line(line_prefix);
         p_col=col;
         return(expand_alias(word,'',aliasfilename));
      }
      if ( word=='') {
         return(1);    /* Fall through to space bar key. */
      }
      // look on the previous line for a stand-alone label
      // Rather than go hunting, the label, if any, must be only 1 line up.
      // This will be ok since a label is never the first line of a program unit.
      up();
      get_line(label_line);
      colon_pos=pos(':',label_line);
      if ( colon_pos != 0 ) { // found a colon, which might be for a label
         parse label_line with '[ \t]@','r' temp_label ':' remainder '--','r' .;
         if ( remainder == '' ) { // a label for previous line
            if ( temp_label != '' ) { //found a label
               if ( pos(' 'word' ',LABEL_WORDS) != 0 ) { // the word is allowed to have a label
                  label=' 'strip(temp_label);
               } else { // illegal label word
                  down();
                  message("Only these can have a statement identifier: "LABEL_WORDS);
                  return(1);
               } // legal label word
            } // is an attempted label
         } // could be a label
      } // found colon
      down();
      line=substr(line,1,length(line)-length(orig_word)):+word_case(word);
      width=text_col(line,length(line)-length(word)+1,'i')-1
   } else { // found ':'
      parse line with '[ \t]@','r' label ':' remainder;
      if ( pos('=',remainder,1) == 1 ) { // found assignment operation
         return(1); //fall through to space bar key
      }
      // Treat as a label, even if it won't be, such as in variable declarations.
      // Since we only use it where allowed, this isn't a problem.
      label=' 'strip(label);
      if (remainder=='') {
         return(1);
      }
      orig_word=lowcase(strip(remainder));
      word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename);
      if (word!=''&&aliasfilename!='') {
         if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
            _insert_text(' ');
            return(0);
         }
         col=p_col-length(orig_word);
         if (col==1) {
            line_prefix='';
         } else {
            line_prefix=indent_string(col-1);
         }
         replace_line(line_prefix);
         p_col=col;
         return(expand_alias(word,'',aliasfilename));
      }
      if ( word=='') {
         return(1);    /* Fall through to space bar key. */
      }
      if ( pos(' 'word' ',LABEL_WORDS) == 0 ) { // these can't have a label!
         message("Only these can have a statement identifier: "LABEL_WORDS);
         return(1);
      }
      line=substr(line,1,length(line)-length(orig_word)):+word_case(word);
      width=text_col(line,pos(label,line),'i')
   }
   
   // Insert the appropriate template based on the reserved word
   if ( word=='accept' ) {
      replace_line(line:+' ':+word_case(' do'));
      insert_line(indent_string(width)word_case('end;'));
      up();
      p_col=p_col+3;
      insert_mode();
      return(0);
   } else if ( word=='if' ) {
      replace_line(line:+' ':+word_case(' then'));
      insert_line(indent_string(width)word_case('end if;'));
      up();
      p_col=width+4;
      insert_mode();
      return(0);
   } else if ( word=='for' ) {
      if (label !='') { // expand it here since it must be a statement
         new_line=line:+' ':+word_case(' in  loop');
         replace_line(new_line);
         insert_line(indent_string(width)word_case('end loop'):+label';');
         up();
         p_col=length(new_line)-8;
         insert_mode();
      } else { // leave it alone due to attribute clauses, etc. (use alias facility)
         replace_line(line);
         _end_line();
         return(1);
      }
      return(0);
   } else if ( word=='begin' ) {
      replace_line(line);
      if (label != '') {
         insert_line(indent_string(width)word_case('end'):+label';');
         up();
         insert_line(indent_string(width+syntax_indent));
         insert_mode();
         return(0);
      } else {
         unit_name=associated_decl();
         if (unit_name != '') {
            insert_line(indent_string(width)word_case('end')' 'unit_name';');
            up();
            insert_line(indent_string(width+syntax_indent));
            insert_mode();
            return(0);
         } else {
            insert_line(indent_string(width)word_case('end')';');
            up();
            insert_line(indent_string(width+syntax_indent));
            insert_mode();
            return(0);
         }
      }
   } else if ( word=='task' ) {
      replace_line(line:+word_case('  is'));
      insert_line(indent_string(width)word_case('end;'));
      up();
      p_col=width+length(word)+2;
      insert_mode();
      return(0);
   } else if ( word=='protected' ) {
      replace_line(line:+word_case('  is'));
      insert_line(indent_string(width)word_case('end;'));
      up();
      p_col=width+length(word)+2;
      insert_mode();
      return(0);
   } else if ( word=='while' ) {
      new_line=line:+word_case('  loop');
      replace_line(new_line);
      insert_line(indent_string(width)word_case('end loop'):+label';');
      up();
      p_col=length(new_line)-4;
      insert_mode();
      return(0);
   } else if ( word=='record' || word=='select' ) {
      replace_line(line);
      insert_line(indent_string(width):+word_case('end '):+word_case(word';'));
      up();
      insert_line(indent_string(width+syntax_indent));
      insert_mode();
      return(0);
   } else if ( word=='case' ) {
      replace_line(line:+word_case('  is'));
      insert_line(indent_string(width)word_case('end case;'));
      up;p_col=width+6;
      insert_mode();
      return(0);
   } else if ( word=='exception' ) {
      replace_line(word_case(line):+' ');
      insert_line(indent_string(width+syntax_indent)word_case('when =>'));
      p_col=width+syntax_indent+6;
      insert_mode();
      return(0);
   } else if ( word=='entry' ) {
      if ( declarative_part() ) { //entry declaration
        return(1);
      } else { //entry body
        replace_line(line:+'  when  is');
        insert_line(indent_string(width):+word_case('begin'));
        insert_line(indent_string(width):+word_case('end;'));
        up(2);
        p_col=width+length(word)+2;
      }
      insert_mode();
      return(0);
   } else if ( word=='loop' ) {
      replace_line(line);
      insert_line(indent_string(width):+word_case('end loop'):+label';');
      up();
      insert_line(indent_string(width+syntax_indent));
      insert_mode();
      return(0);
   } else if ( word=='elsif' ) {
      replace_line(line:+' ':+word_case(' then'));
      p_col=width+7;
      return(0);
   } else if ( word=='declare' ) {
      replace_line(line);
      insert_line(indent_string(width):+word_case('begin'));
      insert_line(indent_string(width):+word_case('end'):+label';');
      up(2);
      indent_on_enter(syntax_indent);
      insert_mode();
      return(0);
   } else if ( pos(' 'word' ',EXPAND_WORDS) ) {
      replace_line(line:+' ');
      _end_line();
      return(0);
   }

   return(1);  // Do output a space...
}


static void maybe_end_line() {
   if (name_on_key(ENTER)=='split-insert-line') {
     _end_line();
   }
}

static int declarative_part() {
   result=0; //false
   up_count=0;
   status=up();
   while (status==0) {
      ++up_count;
      get_line(prev_line);
      parse prev_line with '[~ \t]','r' +0 prev_first_word ':b','r' prev_second_word '([~a-zA-Z0-9_.])','r' rest ' |$|--','r' .
      if ( prev_first_word=='task' ||
           prev_first_word=='protected' ||
           prev_first_word=='package' ) {
         if ( prev_second_word=='body' ) {
            result=0; //false
            break;
         } else {
            result=1; //true
            break;
         }
      }
      status=up();
   } // loop
   down(up_count);
   return(result);
}

#define word_sep '([~a-zA-Z0-9_]|^|$)'
#define identifier '[a-zA-Z0-9_]'


static void insert_mode()
{
   if ( ! _insert_state() ) _insert_toggle();
} // insert_mode

static int instantiation(first_line)
{
   // check for an instantiation *on the same line* as the subprogram decl
   if ( pos(word_sep'is'word_sep'new', first_line, 1, 'r') ) {
      //messagenwait("encountered subprogram instantiation")
      return(1);
   }

   // check for instantiation on multiple lines
   down();
   get_line(next_line);
   parse next_line with '[~ \t]','r' +0 word1 ':b','r' word2 ';' rest ' |$|--','r' .
   if (word1 == 'new') {
      up();
      return(1);
   } else {
      up();
   }
   return(0); // default result
} // instantiation

static int significant_end(this_line)
{
   // 'end;' and 'end identifier' are significant, all others are not
   if ( pos('end;',this_line,1) ) {
      return(1);
   }
   parse this_line with '[~ \t]','r' +0 word1 ':b','r' word2 ';' rest ' |$|--','r' .
   if ( word1=='end' && (word2 != 'loop' && word2 != 'record' && word2 != 'if')  ) {
      return(1);
   }
   return(0);
} // significant_end

static _str associated_decl()
{
   block_count=0;
   expecting_declaration=0;
   result='';
   up_count=0;

   status=up();
   while (status==0) {
      up_count=up_count+1;
      get_line(prev_line);
      if ( pos('begin',prev_line) ) {
         //messagenwait("encountered 'begin' with block_count "block_count)
         if (block_count == 0) {
           break;
         } else {
            block_count=block_count+1;
         }
      } else if ( significant_end(prev_line) ) {
         //messagenwait( "encountered significant 'end'")
         block_count=block_count-1;
         expecting_declaration=1;
      } else if ( pos(word_sep'{procedure|function}'word_sep, prev_line, 1, 'r') ) {
         // found subprogram keyword
         //messagenwait('subprogram encountered')
         if ( ! instantiation(prev_line) ) {
            if (expecting_declaration) { // found decl for previously encountered begin/end
               //messagenwait("ignoring expected subprogrm decl")
               expecting_declaration=0;
            } else { // use this one
               parse prev_line with '[ \t]@','r' word1 ':b','r' id  '([~a-zA-Z0-9_.])','r' rest
               result=id;
               break;
            } // block_count check
         } // instantiation check
      } // if word of interest
      status=up();
   } // loop
   down(up_count);
   return(result);
} // associated_decl

defload()
{
   _no_filename_index=find_index('ada-get-filename',PROC_TYPE);
   setup_info='MN='MODE_NAME',TABS=+3,MA=1 74 1,':+
               'KEYTAB=ada_keys,WW=1,IWT=0,ST=0,';
   compile_info='';
   syntax_info='3 1 1 1 0 1 0';
   be_info='(begin)|(end)';
   create_ext(kt_index,EXTENSION,'',MODE_NAME,setup_info,compile_info,
              syntax_info,be_info);
   create_ext(kt_index,'adb',EXTENSION);
   create_ext(kt_index,'ads',EXTENSION);
}

/* ada_get_filename performs the following;
      1) if new view info supplied then switch to new view
      2) capture current buffer view info
      3) reverse search for "compiling " at beginning of line
      4) set filename='' if "compiling " not found
         or set filename to value on line after "compiling"
      5) reset old view
*/
_str ada_get_filename(var filename)
{
   if ( arg(2)!='' ) {    /* swicth to new view if needed */
      get_view_id(view_id);
      activate_view(arg(2));
   }
   p=point();ln=point('L');cl=p_col;left_edge=p_left_edge;cursor_y=p_cursor_y;
   search('^compiling ','ri-');
   if ( rc ) {
      filename='';
   } else {
      get_line(cur_line);
      parse cur_line with . filename;
      goto_point(p,ln);p_col=cl;set_scroll_pos(left_edge,cursor_y);
   }
   if ( arg(2)!='' ) {
      activate_view(view_id);
   }
   return('');
}



/******* Ada_proc_search performs the following:
      1) searches for a "function|task|procedure|package|subtype|end"
      2) search for the termination of the above search to determin if
         it is a "proc", a "proto" or a compiler directive.
      3) matches up the found item with the request from the caller
         [note that if caller requests null then every valid tag returned]
      4) loops until reqested item found or bottom of file.

********/
_str ada_proc_search(var proc_name,find_first)
{
   static _str package_name;
   if (find_first) {
      package_name='';
   }
   for (;;) {
      search('^[ \t]*(end|function|task|procedure|package|subtype):b\c','ri@');
      if ( rc ) {
         return(rc); /* search failed */
      }
      //parse proc_name with name '(' kind ')';
      //parse kind with class_name ':' kind;
      //if ( kind=='' ) {
      //   kind=class_name;
      //   class_name='';
      //}
      tag_tree_decompose_tag(proc_name, name, class_name, kind, df);
      get_line(line);
      parse line with line'--' .;
      parse line with ada_type n1 n2 .;
      if (pos('(', n1)) {
         parse n1 with n1 '(' n2;
      }
      ada_type=lowcase(ada_type);
      cnt=0;
      lin_cnt=p_line;
      if (n2:==';' || lastpos(';',n1)==length(n1)) {
         parse n1 with n1 ';';
         proto=1;
      } else if (n2:=='is') {
         proto=0;
      } else if (n2:=='return') {
         proto=0;
      } else {
         for (;;) {
            line=strip(line);
            l=length(line);
            strt=lastpos(' ',line);
            if ( l>3 ) {
               if ( strt==0 ) {
                  strt=1;
               }
               term=lowcase(substr(line,strt));
               if (pos('):bis',line,1,'R') && term=='is') {
                  proto=0;
                  break;
               } else if (pos('return', line, 1) && term=='is') {
                  proto=0;
                  break;
               } else if (pos('renames?*;', line, 1,'R')) {
                  proto=0;
                  break;
               } else if ( term=='separate;' ) {
                  proto='X';
                  break;
               } else if ( pos(')?*;',line,1,'R') /*&& lastpos(';',line)==l*/) {
                  proto=1;
                  break;
               }
            }
            down();
            if ( rc ) {
               return(rc);
            }
            cnt=cnt+1;
            if ( cnt>=20 ) {
               proto='X';
               break;
            }
            get_line(line);
            parse line with line'--' .;
         }
      }
      p_line=lin_cnt;
      if ( ada_type=='package' || ada_type=='task' ) {
         if ( lowcase(n1)!='body' && proto==0 ) {
            proto=1;
         }
         if ( lowcase(n1)=='type' || lowcase(n1)=='body' ) {
            n1=n2;
         }
      }
      
      // hit end of package body?
      if (ada_type=='end') {
         if (lowcase(n1)==lowcase(package_name)) {
            package_name='';
         }
         continue;
      }

      /* stop for proc match and not proto, or just prototypes if kind = proto*/
      if ( name==n1 ) {
         if ( kind=='proto' && proto==1 ) {
            break;
         } else if ( kind=='func' && proto==0 ) {
            break;
         } else if ( kind=='package' && ada_type=='package') {
            break;
         } else if ( kind=='typedef' && ada_type=='subtype') {
            break;
         }

      } else if ( name=='' && proto!='X' ) {
         dbflag=VS_TAGFLAG_inclass;
         dbtype='';
         if (ada_type=='package') {
            dbtype='package';
            package_name=n1;
            dbflag='';
         } else if (ada_type=='subtype') {
            dbtype='typedef';
         } else if ( proto==1 ) {
            dbtype='proto';
            dbflag='';
         } else if ( proto==0 ) {
            dbtype='func';
         }
         if (dbtype!='') {
            if (package_name=='' || ada_type=='package') {
               proc_name=n1'('dbtype')';
            } else {
               proc_name=n1'('package_name':'dbtype')'dbflag;
            }
            break;
         }
      }
   }
   return(0);
}

