/*
    Supports Microsoft Visual C++ 4.x and 5.0
    Borland C++ Builder 3.x
    Visual Cafe, Visual J++, Sun's JDK, JBuilder, SuperCede 

*/
// #define _ntGetRegistryValue  GetRestistryValue
//#define _ntRegQueryValue _ntregqueryvalue
//#define _ntRegFindValue  RegFindValue

#include "slick.sh"


static _str javaList[];
static _str cppList[];

/*
 Function Name:  autotag
 
 Parameters:  None
 
 Description: Autotag searches for the base directories for visual c++ and
              most Java development applications, and creates tag files 
              for these applications.
              
 
 Returns:    0 if successful
 
 */

//_command autotag() name_info(','READ_ONLY_ARG2|ICON_ARG2|NCW_ARG2|EDITORCTL_ARG2)
defmain()
{

   javaList._makeempty();
   cppList._makeempty();

   //vcppPath =  getVcppIncludePath();
   getJavaIncludePath(javaList);
   getCppIncludePath(cppList,VisualCppPath);

   if (arg(1) != "") {
      vspath=arg(1);
   } else {
      vspath=_config_path();
   }

   result=show('-modal _temp_form',cppList, VisualCppPath,javaList, vspath);
   index=find_index('_temp_form',oi2type(OI_FORM));
   //delete_name(index);  Lets leave this form for better speed
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   //_message_box('param 1 '_param1' param 2 ' _param2' param 3 '_param3' param 4 ' _param4' param 5 ' _param5' param 6' _param6);
   if (_param1!="") {
      //If the Create C++ Tag file was enabled...
#if __UNIX__
      status=create_cpp_tagfile(_param1, _param3:+'ucpp.vtg');
#else
      status=create_cpp_tagfile(_param1, _param3:+'cpp.vtg');
#endif
      if (status) {
         return(status);
      }
   }
   if (_param4!="") {
      //If have maketag arguments for Java
#if __UNIX__
      status=create_java_tagfile(_param4, _param6:+'ujava.vtg');
#else
      status=create_java_tagfile(_param4, _param6:+'java.vtg');
#endif
      if (status) {
         return(status);
      }
   }
   return(0);
}

static _str create_cpp_autotag_args(_str cppPath)
{
   //Gather the arguments for make_tags
   cmdargs='';
   vcppFlag=0;

#if __UNIX__
   include_path=cppPath;
   cmdargs=cmdargs:+' "'include_path:+'*.h"';
   return(cmdargs);
#else
   // IF NOT borland C++
   if (!isdirectory(cppPath:+'VCL')) {
      //We are tagging Visual C++
      vcppFlag=1;
   }
   include_path=cppPath:+'include\';
   if ( isdirectory(include_path) ) {
      //add the relevant files from the Visual C++ include directory
      cmdargs=cmdargs:+' "'include_path:+'*."';
      cmdargs=cmdargs:+' "'include_path:+'*.h"';
      cmdargs=cmdargs:+' "'include_path:+'*.hpp"';
      cmdargs=cmdargs:+' "'include_path:+'*.inl"';

   }
   if (vcppFlag) {
      include_path=cppPath:+'mfc\';
      if ( isdirectory(include_path) ) {
         //Add the relevant files from the MFC directory
         cmdargs=cmdargs:+' "'include_path:+'*.h"';
         cmdargs=cmdargs:+' "'include_path:+'*.cpp"';
      }

      include_path=cppPath:+'atl\';
      if ( isdirectory(include_path) ) {
         //Add the relevant files from the ATL directory
         cmdargs=cmdargs:+' "'include_path:+'*.h"';
         cmdargs=cmdargs:+' "'include_path:+'*.cpp"';
      }
      include_path=cppPath:+'crt\';
      if ( isdirectory(include_path) ) {
         //Add the relevant files from the ATL directory
         cmdargs=cmdargs:+' "'include_path:+'*."';
         cmdargs=cmdargs:+' "'include_path:+'*.h"';
         cmdargs=cmdargs:+' "'include_path:+'*.c"';
         cmdargs=cmdargs:+' "'include_path:+'*.cpp"';
      }
   }
   return(cmdargs);
#endif
}
/*
 Function Name:  create_cpp_tagfile
 
 Parameters:     None
 
 Description:    Creates a tag file for Visual C++ Development Studio
 
 Returns:        Status
 
 */

static int create_cpp_tagfile(_str cmdargs, _str cppTagFileName) {

   TagFileName=cppTagFileName;
   cppTagFileName= maybe_quote_filename(cppTagFileName);

   make_tag_cmd='-t -c -n "C Run-Times" -o ';
   make_tag_cmd=make_tag_cmd:+cppTagFileName:+' ':+cmdargs;
   status=make_tags(make_tag_cmd);
   if (!status) {
      set_exttagfiles('c 'cppTagFileName,true /* append*/);
      _config_modify|=CFGMODIFY_DEFDATA;
      ext='c';ext=refer_ext(_file_case(ext));
      name='def-tagfiles-'ext;
      index=find_index(name,MISC_TYPE);
      if (index) {
         list=_replace_envvars(name_info(index));
         vcpp_TagFileName=strip_filename(TagFileName,'N'):+'visualcpp.vtg';
         list=PATHSEP:+list:+PATHSEP;
         parse list with  b4 (PATHSEP:+vcpp_TagFileName:+PATHSEP),_fpos_case after;
         if (b4!=list) {
            list=strip(b4:+PATHSEP:+after,'B',PATHSEP);
            list=stranslate(list,PATHSEP,PATHSEP:+PATHSEP);
            set_name_info(index,_encode_vsroot(list,true,false));
         }
         
      }
      // Remove beta test visualcpp.vtg
   }
   return(status);

}

/*
 Function Name:getCppIncludePath

 Parameters:  cppList:  The list of Cpp paths

 Description: Gathers the list of C++ IDE paths 

 Returns:     None

 */

void getCppIncludePath(_str (&cppList)[], _str &VisualCppPath){

   VisualCppPath="";
   cppPath ='';
   cppPath=getVcppIncludePath();
   if (cppPath !='') {
      cppList[cppList._length()]=cppPath;
      VisualCppPath=cppPath;
   }
   cppPath=get_BCB_path();
   if (cppPath !='') {
      cppList[cppList._length()]=cppPath;
   }
#if __UNIX__
   cppList[cppList._length()] = "/usr/include";
#endif
}

/*
 Function Name:get_BCB_path

 Parameters:  None

 Description: Gets the path to BCB from the PATH environment variable.  I
              have been unable to find a registry value, so this is it for
              the moment

 Returns:     path to BCB

 */

static _str get_BCB_path(){

#if __UNIX__
   return("");
#else
   //Check and see if the executable is in the path
   BCBPath=path_search("bcb.exe","Path","P");
   if (BCBPath!='') {
      //If found, strip  'bin' off the path.
      BCBPath2= substr(BCBPath,1,(pathlen(BCBPath)-1));
      subdirname=strip_filename(BCBPath2,'PDE');
      if (file_eq(subdirname,'bin')) {
         BCBPath=strip_filename(BCBPath2,'N');
         BCBPath=strip_filename(BCBPath, 'NE');
         return(BCBPath);
      }
   }
   //Check to see if it is in the registry
   //HKEY_LOCAL_MACHINE\SOFTWARE\Borland\C++Builder
   BCBPath=_ntGetRegistryValue(HKEY_LOCAL_MACHINE,'SOFTWARE\Borland\C++Builder','','RootDir',1);
   if (BCBPath!="") {
      if (last_char(BCBPath) != FILESEP) {
         BCBPath =BCBPath:+FILESEP;
      }
      if (create_cpp_autotag_args(BCBPath) == '') {
         return('');
      }
   }

   return(BCBPath);
#endif
}

/*
 Function Name:getVcppIncludePath
 
 Parameters:   None
 
 Author:       Chris Cunning
 
 Description:  Scans for the spyxx.exe in the path flag environment
               variable.  If located, it removes the bin and exits.  If
               not located, checks the registry for MSDEV.EXE.  If it
               fails to located the directory in the default listing,
               it will search for stdio.h, assuming that it will find
               it in the Visual C++ include directory 
 
 Returns:      String containing the path to Visual C++'s include files.
 
 */
static _str getVcppIncludePath (){

#if __UNIX__
   return("");
#else
   vcppPath =_ntGetRegistryValue(HKEY_LOCAL_MACHINE,'SOFTWARE\Microsoft\DevStudio','Products\Microsoft Visual C++','ProductDir',1);
   if (last_char(vcppPath) != FILESEP && vcppPath !='') {
      vcppPath =vcppPath:+FILESEP;
   }
   if (vcppPath!="") {

      if (create_cpp_autotag_args(vcppPath) == '') {
         vcppPath = '';
      }
      return(vcppPath);
   }
   //Check the registry for msdev's location
   vcppPath=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\mdpfile\\shell\\open\\command","");
   //If there are any quotes on, we want to strip them off
   vcppPath=strip(vcppPath,'B','"');
   if ( vcppPath != '' ) {
      //strip off the msdev.exe "%1" arguments
      vcppPath=strip_filename(vcppPath,'N');

      //If the last subdirectory in the path is bin, strip it off
      if (last_char(vcppPath) == FILESEP) {
         vcppPath2= substr(vcppPath,1,(pathlen(vcppPath)-1));
         subdirname=strip_filename(vcppPath2,'PDE');
         if (file_eq(subdirname,'bin')) {
            vcppPath=strip_filename(vcppPath2,'N');
         } else {
            vcppPath='';
         }
      }

      if (vcppPath!='') {
         //If the last subdirectory in the path is SharedIDE, strip it off
         if (last_char(vcppPath) == FILESEP) {
            vcppPath2= substr(vcppPath,1,(pathlen(vcppPath)-1));
            subdirname=strip_filename(vcppPath2,'PDE');
            if (file_eq(subdirname,'SharedIDE')) {
               //We have version 5.0 or greater
               vcppPath=strip_filename(vcppPath2,'N');
               //Add The default pathname for Visual C++
               vcppPath= vcppPath:+'vc\';
            }
         }

         if (isdirectory(vcppPath) && create_cpp_autotag_args(vcppPath) != '') {
            return(vcppPath);
         } else {
            vcppPath='';
         }
      }

   }
   vcppPath=path_search("tracer.exe","PATH","P");
   if (vcppPath!='') {
      //If found, strip  'bin' off the path.
      vcppPath2= substr(vcppPath,1,(pathlen(vcppPath)-1));
      subdirname=strip_filename(vcppPath2,'PDE');
      if (file_eq(subdirname,'bin')) {
         vcppPath=strip_filename(vcppPath2,'N');
         vcppPath=strip_filename(vcppPath, 'NE');
         if (create_cpp_autotag_args(vcppPath) == '') {
            vcppPath = '';
         }
         return(vcppPath);
      }
   }
   if (create_cpp_autotag_args(vcppPath) == '') {
      vcppPath = '';
   }

   return(vcppPath);
#endif
}

/*
 Function Name:create_Java_tagfile
 
 Parameters:   None
 
 Description:  Creates a global tag file for Symantec Visual Cafe
 
 Returns:     Status
 
 */
static int create_java_tagfile(_str cmdargs,_str javaTagFileName) {

   javaTagFileName=maybe_quote_filename(javaTagFileName);

   //Check to see if there is a previous copy of VisualCafe.vtg
   make_tag_cmd='-t -c -n "Java Run-Times" -o ';
   make_tag_cmd= make_tag_cmd:+javaTagFileName:+' ':+cmdargs;
   //_message_box(' make_tag_cmd 'make_tag_cmd);
   status=make_tags(make_tag_cmd);
   //_message_box('status='status' javaTagFileName='javaTagFileName);
   if (!status) {
      set_exttagfiles('java 'javaTagFileName,true /* append*/);
      set_exttagfiles('js 'javaTagFileName,true /* append*/);
      _config_modify|=CFGMODIFY_DEFDATA;
   }
   return(status); 
}
/*
 Function Name:getJavaIncludePath
 
 Parameters:   None
 
 Author:       Chris Cunning
 
 Description:  Scans for the javac.exe in the path flag environment
               variable.  If located, it removes the bin and exits.  If
               not located, checks the registry for Specific Values 
 
 Returns:      String containing the path to Visual Cafe's include files.
 
 */
void getJavaIncludePath(_str (&javaList)[])
{
   javaPath ='';
   javaPath=get_Navigator_path()
   if (javaPath !='') {
      javaList[javaList._length()]=javaPath;
   }
   javaPath=get_jbuilder_path();
   if (javaPath !='') {
      javaList[javaList._length()]=javaPath;
   }
   javaPath=get_vcafe_path();
   if (javaPath !='') {
      javaList[javaList._length()]=javaPath;
   }
   javaPath=get_jpp_path();
   if (javaPath !='') {
      javaList[javaList._length()]=javaPath;
   }
   javaPath=get_JDK_path();
   if (javaPath !='') {
      javaList[javaList._length()]=javaPath;
   }
   javaPath=get_Supercede_path();
   if (javaPath !='') {
      javaList[javaList._length()]=javaPath;
   }
   if (javaPath=="") {
      get_javac_from_path(javaList);
   }
}

static _str get_Navigator_path()
{
#if __UNIX__
   return("");
#else
   javaPath=_ntGetRegistryValue(HKEY_LOCAL_MACHINE,'SOFTWARE\Netscape\Netscape Navigator','Main','Java Directory',1);
   //HKEY_LOCAL_MACHINE\SOFTWARE\Netscape\Netscape Navigator\4.04 (en)\Main
   
   if (last_char(javaPath) != FILESEP && javaPath !='') {
      javaPath =javaPath:+FILESEP;
   }
   if (javaPath !='' && create_java_autotag_args(javaPath) == '') {
      javaPath = '';
   }
   return(javaPath);
#endif
}


static _str get_Supercede_path()
{
#if __UNIX__
   return("");
#else
   javaPath=_ntGetRegistryValue(HKEY_LOCAL_MACHINE,'SOFTWARE\SuperCede\SuperCede','','Install Path',1);

   if (last_char(javaPath) != FILESEP && javaPath !='') {
      javaPath =javaPath:+FILESEP;
   }
   if (javaPath !='' && create_java_autotag_args(javaPath) == '') {
      javaPath = '';
   }
   return(javaPath);
#endif
}
static _str get_JDK_path(){
#if __UNIX__
   _str javaPath;
   if (machine() == "LINUX") {
      javaPath = "/usr/lib/java";
   } else {
      javaPath = "/usr/java";
   }
   return(javaPath);
#else
   javaPath=_ntGetRegistryValue(HKEY_LOCAL_MACHINE,'SOFTWARE\JavaSoft\Java Development Kit','','JavaHome',1);

   if (last_char(javaPath) != FILESEP && javaPath !='') {
      javaPath =javaPath:+FILESEP;
   }
   if (javaPath !='' && create_java_autotag_args(javaPath) == '') {
      javaPath = '';
   }
   return(javaPath);
#endif
}

void get_javac_from_path( _str (& javaList)[]){
   javaPath='';
#if __UNIX__
   // This is not reliable on UNIX because javac can be a link from
   // /usr/bin to its actual location elsewhere.
   // Skip this check on UNIX.
#else
   javaPath=path_search("javac.exe","PATH","P");
   if (javaPath!='') {
      //Otherwise strip  'bin' off the path.
      javaPath2= substr(javaPath,1,(pathlen(javaPath)-1));
      subdirname=strip_filename(javaPath2,'PDE');
      if (file_eq(subdirname,'bin')) {
         javaPath=strip_filename(javaPath2,'N');
         javaPath=strip_filename(javaPath, 'NE');
         javaList[javaList._length()]= javaPath;
         javaPath='';
      } else {
         javaPath='';
      }
   }
#endif
}

static _str get_vcafe_path(){
#if __UNIX__
   return("");
#else
   //Check for Visual Cafe
   javaPath=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\VisualCafeProject.Document\\shell\\open\\command","");
   if (javaPath != '') {
      javaPath=clean_javaPath(javaPath);

   }
   if (javaPath !='' && create_java_autotag_args(javaPath) == '') {
      javaPath = '';
   }
   return(javaPath);
#endif
}

static _str get_jbuilder_path(){
#if __UNIX__
   return("");
#else
   //Check for JBuilder
   javaPath=_ntRegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Classes\\JBuilder.ProjectFile\\Shell\\Open\\Command","");
   if (javaPath !='') {
      javaPath=clean_javaPath(javaPath);
   }
   if (javaPath !='' && create_java_autotag_args(javaPath) == '') {
      javaPath = '';
   }
   return(javaPath);
#endif
}

static _str get_jpp_path(){
#if __UNIX__
   return("");
#else
   //Check for J++ 6.0
   status=_ntRegFindValue(HKEY_LOCAL_MACHINE,'SOFTWARE\Microsoft\Java VM','LibsDirectory',javaPath);
   if (javaPath!="" && last_char(javaPath)==FILESEP) {
      javaPath=substr(javaPath,1,length(javaPath)-1);
   }
   if (javaPath!="") {
      javaPath=strip_filename(javaPath,'N');
   }
   if (javaPath != '') {
      javaPath2= javaPath:+'Packages';
      if (isdirectory(javaPath2)) {
         javaPath2= javaPath2:+FILESEP:+'*.zip';
         if ((file_match(maybe_quote_filename(javaPath2):+'  -p',1)) !='') {
            if (javaPath !='' && create_java_autotag_args(javaPath) == '') {
               javaPath = '';
            }
            return(javaPath);
         }
      }
   }
   //Check for J++ 1.0
   if (javaPath != '') {
      //javaPath=javaPath:+'Java':+FILESEP;
      if (isdirectory(javaPath)) {
         javaPath2=javaPath2:+'classes':+FILESEP:+'classes.zip';
         if ((file_match(maybe_quote_filename(javaPath2)'  -p',1))== '') {
            javaPath='';
         }
      } else {
         javaPath="";
      }
   }
   if (create_java_autotag_args(javaPath) == '') {
      javaPath = '';
   }

   return(javaPath);
#endif
}


static _str clean_javaPath( _str javaPath){
   if ( javaPath != '' ) {
      javaPath=strip(javaPath,'B','"');
      //strip off the javac.exe "%1" arguments
      javaPath=strip_filename(javaPath,'N');

      //If the last subdirectory in the path is bin, strip it off
      if (last_char(javaPath) == FILESEP && javaPath !='') {
         javaPath2= substr(javaPath,1,(pathlen(javaPath)-1));
         subdirname=strip_filename(javaPath2,'PDE');
         if (file_eq(subdirname,'bin')) {
            javaPath=strip_filename(javaPath2,'N');
         } else {
            javaPath='';
         }
      }
      if (javaPath!='') {
         if (!isdirectory(javaPath)) {
            javaPath='';
         }
      }
   }
   return(javaPath);

}

/*
 Function Name:create_java_autotag_args
 
 Parameters:  javaPath
 
 Description: determines what aregument paths should be set for make_tags
 
 Returns:     the command argument for make_tags
 
 */
static _str create_java_autotag_args(_str javaPath){
   cmdargs='';
   JppFlag=0;
   LibsFound=0;

#if __UNIX__
   //Get the .java files from the src subdirectory
   include_path=javaPath:+'src':+FILESEP;
   if ( isdirectory(include_path) ) {
      cmdargs=cmdargs:+' "'include_path:+'*.java"';
      SrcFound=1;
   } else {
      //If there is no src subdirectory, get the src.zip file
      include_path=javaPath;
      include_path='"'include_path:+'src.zip"';
      if ((file_match(include_path'  -p',1))!= '') {
         cmdargs=cmdargs:+' 'include_path;
         SrcFound=1;
      }
   }
   return(cmdargs);
#else
   status=_ntRegFindValue(HKEY_LOCAL_MACHINE,'SOFTWARE\Microsoft\Java VM','LibsDirectory',test_javaPath);
   if (test_javaPath!='') {
      if (test_javaPath!="" && last_char(test_javaPath)==FILESEP) {
         test_javaPath=substr(test_javaPath,1,length(javaPath)-1);
      }
      test_javaPath=strip_filename(test_javaPath,'N');

      if (last_char(test_javaPath)!=FILESEP) {
         test_javaPath=test_javaPath:+FILESEP;
      }
      JppFlag=file_eq(test_javaPath,javaPath);
   }
   if (JppFlag) {
      include_path = javaPath:+'Packages':+FILESEP;
      if (isdirectory(include_path)) {
         cmdargs=cmdargs:+' "':+include_path:+'*.zip"';
         if ((file_match(maybe_quote_filename(include_path:+'*.zip'):+' -p',1))!='') {
            //messageNwait('cmdargs 'cmdargs);
            return(cmdargs);
         }
      }
      include_path = javaPath:+'Classes':+FILESEP;
      if (isdirectory(include_path)) {
         cmdargs=cmdargs:+' "':+include_path:+'classes.zip"';
         if ((file_match(maybe_quote_filename(include_path:+'classes.zip'):+' -p',1))!='') {
            //messageNwait('cmdargs2 'cmdargs);
            return(cmdargs);
         }
      }
   }
   //Vcafe, Jbuilder, and J++ you have to add the java subdirectory
   // if we retrieved the value from the registry.
   if (last_char(javaPath) == FILESEP) {
      javaPath2= substr(javaPath,1,(pathlen(javaPath)-1));
      subdirname=strip_filename(javaPath2,'P');
      if (!file_eq(subdirname,'java')) {
         javaPath2=javaPath:+'java':+FILESEP;
         if (isdirectory(javaPath2)) {
            javaPath=javaPath2;
         }
      }
   }
   //It's not Supercede, so its JDK, VCafe, or Jbuilder

   //Get the .java files from the src subdirectory
   include_path=javaPath:+'src':+FILESEP;
   if ( isdirectory(include_path) ) {
      cmdargs=cmdargs:+' "'include_path:+'*.java"';
      LibsFound=1;
   } else {
/*
      Source does not help if its compressed.  Might 
      as well tag libriaries.

      //If there is no src subdirectory, get the src.zip file
      include_path=javaPath;
      include_path='"'include_path:+'src.zip"';
      if (file_match(include_path'  -p',1)!= '') {
         cmdargs=cmdargs:+' 'include_path;
         LibsFound=1;
      }
*/
   }
   if (!LibsFound) {
      //Get the classes.zip file from the lib subdirectory
      include_path=javaPath:+'lib':+FILESEP;
      if ( isdirectory(include_path)) {
         // JDK 1.1, 1.2, JBuilder
         if (file_match(maybe_quote_filename(include_path:+'classes.zip')' -p',1)!= '') {
            cmdargs=cmdargs:+' "'include_path:+'classes.zip"';
            LibsFound=true;
         }
         if (file_match(maybe_quote_filename(include_path:+'*.jar'),1)!= '') {
            cmdargs=cmdargs:+' "'include_path:+'*.jar"';
            LibsFound=true;
         }
         include_path=javaPath:+'jre':+FILESEP:+'lib':+FILESEP;
         if ( isdirectory(include_path)) {
            if (file_match(maybe_quote_filename(include_path:+'*.jar'),1)!= '') {
               cmdargs=cmdargs:+' "'include_path:+'*.jar"';
               LibsFound=true;
            }
         }
         include_path=javaPath:+'jre':+FILESEP:+'lib':+FILESEP:+'ext':+FILESEP;;
         if ( isdirectory(include_path)) {
            if (file_match(maybe_quote_filename(include_path:+'*.jar'),1)!= '') {
               cmdargs=cmdargs:+' "'include_path:+'*.jar"';
               LibsFound=true;
            }
         }
      }
      if (!LibsFound) {
         // Visual Cafe
         include_path=javaPath:+'classes':+FILESEP;
         if ( isdirectory(include_path)) {
            LibsFound=true;
            cmdargs=cmdargs:+' "'include_path:+'*.jar"';
         }
      }
   }
   if (!LibsFound) {
      //Check for SuperCede
      include_path=javaPath:+'jre':+FILESEP;
      if (isdirectory(include_path)) {
         //We are dealing with Supercede, so we need the .jar files
         cmdargs=cmdargs:+' "'include_path:+'*.jar"';
      }
   }
   return(cmdargs);
#endif
}

defeventtab _temp_form


ctlBrowsedir.lbutton_up()
{
   wid=p_window_id;
   result=show('-modal _cd_form','Choose Directory',1,1,1);
   if ( result=='' ) {
      return('');
   }
   p_window_id=wid.p_prev;
   result=strip(result,'B','"');
   if (last_char(result) != FILESEP) {
      result=result :+ FILESEP;
   }
   result=maybe_quote_filename(result);
   p_text=result;
   end_line();
   _set_focus();
   return(''); 
}

ctlcreate_cppfile.lbutton_up()
{
   if (ctlcreate_cppfile.p_value) {
      ctlcppsource.p_enabled    =1;
      ctlcppdest.p_enabled      =1;
      ctlcppsrcbrowse.p_enabled =1;
      ctlcppdestbrowse.p_enabled=1;
   } else {
      ctlcppsource.p_enabled    =0;
      ctlcppdest.p_enabled      =0;
      ctlcppsrcbrowse.p_enabled =0;
      ctlcppdestbrowse.p_enabled=0;
   }

}
ctlcreate_javafile.lbutton_up()
{
   if (ctlcreate_javafile.p_value) {
      ctljavasource.p_enabled    =1;
      ctljavadest.p_enabled      =1;
      ctljavasrcbrowse.p_enabled =1;
      ctljavadestbrowse.p_enabled=1;
   } else {
      ctljavasource.p_enabled    =0;
      ctljavadest.p_enabled      =0;
      ctljavasrcbrowse.p_enabled =0;
      ctljavadestbrowse.p_enabled=0;
   }

}


static _str cleanlist()[]{
   _str x[];
   x._makeempty();
   return(x);

}

void ctlok.on_create(_str cppList[]=cleanlist(), _str VisualCppPath="", _str javaList[]= cleanlist(),_str vspath="")
{
   //cppsource.p_text = vcppPath;
   //Load the combo listbox for Cpp Paths
   for (x=0; x < cppList._length(); x++) {
      ctlcppsource.p_cb_list_box._lbadd_item(cppList[x]);
   }
   ctlcppsource.p_cb_list_box._lbsort("a":+_fpos_case);
   ctlcppsource.p_cb_list_box._remove_duplicates(_fpos_case);

   wid=p_window_id;
   p_window_id=ctlcppsource.p_cb_list_box;
   _lbtop();
   p_window_id=wid;
   if (VisualCppPath!="") {
      ctlcppsource.p_text=VisualCppPath;
   } else {
      ctlcppsource.p_text= ctlcppsource.p_cb_list_box._lbget_text();
   }

   //Load the combo listbox for Java Paths
   for (x=0; x < javaList._length(); x++) {
       ctljavasource.p_cb_list_box._lbadd_item(javaList[x]);
    }
   ctljavasource.p_cb_list_box._lbsort("a":+_fpos_case);
   ctljavasource.p_cb_list_box._remove_duplicates(_fpos_case);

   wid=p_window_id;
   p_window_id=ctljavasource.p_cb_list_box;
   _lbtop();
   p_window_id=wid;
   ctljavasource.p_text=ctljavasource.p_cb_list_box._lbget_text();

   ctlcppdest.p_text=vspath;
   ctljavadest.p_text=vspath;

   if (ctljavadest.p_text == '') {
      ctljavadest.p_text=getcwd();
      ctljavadest.p_text=ctljavadest.p_text:+'\';
   }
   if (cppList._length() > 0) {
      ctlcreate_cppfile.p_value =1;
   } else {
      ctlcreate_cppfile.p_value =0;
      ctlcppsource.p_enabled    =0;
      ctlcppdest.p_enabled      =0;
      ctlcppsrcbrowse.p_enabled =0;
      ctlcppdestbrowse.p_enabled=0;
   }

   if (ctlcppdest.p_text == '') {
      ctlcppdest.p_text=getcwd();
      ctlcppdest.p_text=ctlcppdest.p_text:+'\';
   }
   if (javaList._length() > 0) {
      ctlcreate_javafile.p_value =1;
   } else {
      ctlcreate_javafile.p_value =0;
      ctljavasource.p_enabled    =0;
      ctljavadest.p_enabled      =0;
      ctljavasrcbrowse.p_enabled =0;
      ctljavadestbrowse.p_enabled=0;
   }

#if __UNIX__
   // Uncheck Java for non-Solaris platform
   if (file_match(ctljavasource.p_text,1) == "") {
      ctlcreate_javafile.p_value = 0;
      ctljavasource.p_enabled    =0;
      ctljavadest.p_enabled      =0;
      ctljavasrcbrowse.p_enabled =0;
      ctljavadestbrowse.p_enabled=0;
   }
#endif
}
boolean CheckForSupportedPackages(_str list[],_str &UserPath)
{

   for (x = 0; x < list._length(); x++) {
      path = list[x];
      if (last_char(path) != FILESEP && path != '') {
         path= path:+FILESEP;
      }
      if (path!="" && 
          length(UserPath)>=length(path) &&
          file_eq(path,substr(UserPath,1,length(path)))
          ) {
         UserPath=path;
         return(true);
      }
   }
   return(false);
}
void ctlok.lbutton_up()
{
   foundSupportedCPPPackage=0;
   cppPath=strip(ctlcppsource.p_text,'B','"');
   _param3=strip(ctlcppdest.p_text,'B','"');

   JavaPath= strip(ctljavasource.p_text,'B','"');
   _param6=strip(ctljavadest.p_text,'B','"');

   if (last_char(cppPath) != FILESEP) {
      cppPath=cppPath:+FILESEP;
   }
   if (last_char(_param3) != FILESEP) {
      _param3= _param3:+FILESEP;
   }
   if (last_char(JavaPath) != FILESEP) {
      JavaPath= JavaPath:+FILESEP;
   }
   if (last_char(_param6) != FILESEP) {
      _param6= _param6:+FILESEP;
   }

   _param4="";
   if (ctlcreate_javafile.p_value) {
      if (!isdirectory(JavaPath)) {
         _message_box('Path for Java Source files does not exist');
         return;
      }
      if (!isdirectory(_param6)) {
         _message_box('Path for Java Tag file does not exist');
         return;
      }
      foundSupportedJavaPackage=CheckForSupportedPackages(javaList,JavaPath);
      if (foundSupportedJavaPackage) { 
         _param4= create_java_autotag_args(JavaPath);
         if (_param4 == '') {
            _message_box(nls('Java source files not found'));
            return;
         }
      } else {
         // Check if the user installed source for Java
         foundSource=false;
         /*if (!foundSource && 
             file_match('-p +t 'maybe_quote_filename(JavaPath:+"Object.java"),1)!="") {
            foundSource=1;
         } */
         /*if (!foundSource && 
             file_match('-p +t 'maybe_quote_filename(JavaPath:+"System.java"),1)!="") {
            foundSource=1;
         } */
         if (!foundSource && 
             file_match('-p +t 'maybe_quote_filename(JavaPath:+"String.java"),1)!="") {
            foundSource=true;
         }
         classes_zip="";
         if (!foundSource) {
            classes_zip=file_match('-p +t 'maybe_quote_filename(JavaPath:+"classes.zip"),1);
         }

         if (foundSource) {
            _param4 = JavaPath:+'*.java';
         }  else if (classes_zip!="") {
            _param4 = JavaPath:+'classes.zip';
         } else {
            _message_box(nls('Java source files not found'));
            return;
         }
         // Look for Object.java
         // Look for System.java
         // Look for String.java
      }
   }
   _param1= "";
   if (ctlcreate_cppfile.p_value) {
      if (!isdirectory(cppPath)) {
         _message_box('Path for C++ source files not found');
         return;
      }
      if (!isdirectory(_param3)) {
         _message_box('Path for C++ Tag file does not exist');
         return;
      }
      foundSupportedCPPPackage=CheckForSupportedPackages(cppList,cppPath);
      if (foundSupportedCPPPackage) { 
         _param1=create_cpp_autotag_args(cppPath);
         if (_param1 == '') {
            _message_box(nls('Path for Visual C++ or C++ Builder source files does not exist.'));
            return;
         }
      }else{
         // Check if this set of wildcards is in our def_file_types
         i=pos('C Files',def_file_types,1,'r'_fpos_case);
         if (i) {
            // Set wildcards to this one.
            parse substr(def_file_types,i) with '('wildcards')';
         }
         ext_list='';
         while (wildcards !='') {
            parse wildcards with ext';'wildcards;
            ext_list=ext_list:+' ':+cppPath:+ext;
         }
         ext_list = strip(ext_list,'B');
         //messageNwait('ext_list 'ext_list);
         _param1=ext_list;
      }
   }

   p_active_form._delete_window(1);

}

#if __UNIX__
_form _temp_form {
   p_backcolor=0x80000005
   p_border_style=BDS_DIALOG_BOX
   p_caption='Automatic tagging for Java and C/C++ Run-Time Libraries'
   p_clip_controls=FALSE
   p_forecolor=0x80000008
   p_height=6216
   p_width=6888
   p_x=4130
   p_y=1963
   _label  {
      p_alignment=AL_LEFT
      p_auto_size=FALSE
      p_backcolor=0x80000005
      p_border_style=BDS_SUNKEN
      p_caption="Visual SlickEdit's Context Tagging (Auto Function Help, Auto List Members), Class Browser, and Current Symbol Tab tools require tag files for run-time libraries.  By creating these run-time library tag files, Visual SlickEdit saves time you would otherwise spend searching for code.\r\rTo create tag files for Java and C/C++, enter the base directory for your Java and C/C++ package (if it is not already listed), as well as the destination of your tag file. For source files other than C/C++ and Java, you can create a tag file using our Tag Files dialog box (\"Search\",\"Tag Files...\")."
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_forecolor=0x80000008
      p_height=1965
      p_tab_index=0
      p_width=6660
      p_word_wrap=TRUE
      p_x=105
      p_y=90
   }
   _frame  {
      p_backcolor=0x80000005
      p_caption='C/C++ run-time libraries'
      p_clip_controls=TRUE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_forecolor=0x80000008
      p_height=1740
      p_tab_index=2
      p_width=6660
      p_x=105
      p_y=2160
      _check_box ctlcreate_cppfile {
         p_alignment=AL_LEFT
         p_backcolor=0x80000005
         p_caption='Create tag file for C++ run-time libraries'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=216
         p_style=PSCH_AUTO2STATE
         p_tab_index=1
         p_tab_stop=TRUE
         p_value=0
         p_width=3779
         p_x=240
         p_y=360
      }
      _combo_box ctlcppsource {
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_case_sensitive=FALSE
         p_completion=NONE_ARG
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=338
         p_style=PSCBO_EDIT
         p_tab_index=2
         p_tab_stop=TRUE
         p_width=4500
         p_x=1080
         p_y=735
         p_eventtab2=_ul2_combobx
      }
      _command_button ctlcppsrcbrowse {
         p_cancel=FALSE
         p_caption='Browse...'
         p_default=FALSE
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_height=360
         p_tab_index=3
         p_tab_stop=TRUE
         p_width=925
         p_x=5614
         p_y=720
         p_eventtab=_temp_form.ctlBrowsedir
      }
      _text_box ctlcppdest {
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_FIXED_SINGLE
         p_completion=FILE_ARG
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=338
         p_tab_index=5
         p_tab_stop=TRUE
         p_width=4500
         p_x=1080
         p_y=1275
         p_eventtab2=_ul2_textbox
      }
      _command_button ctlcppdestbrowse {
         p_cancel=FALSE
         p_caption='Browse...'
         p_default=FALSE
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_height=360
         p_tab_index=6
         p_tab_stop=TRUE
         p_width=925
         p_x=5629
         p_y=1230
         p_eventtab=_temp_form.ctlBrowsedir
      }
      _label  {
         p_alignment=AL_LEFT
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_NONE
         p_caption='Source:'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=182
         p_tab_index=7
         p_width=602
         p_word_wrap=FALSE
         p_x=120
         p_y=765
      }
      _label  {
         p_alignment=AL_LEFT
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_NONE
         p_caption='Destination:'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=182
         p_tab_index=8
         p_width=910
         p_word_wrap=FALSE
         p_x=105
         p_y=1305
      }
   }
   _frame  {
      p_backcolor=0x80000005
      p_caption='Java run-time libraries'
      p_clip_controls=TRUE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_forecolor=0x80000008
      p_height=1680
      p_tab_index=2
      p_width=6645
      p_x=105
      p_y=3990
      _check_box ctlcreate_javafile {
         p_alignment=AL_LEFT
         p_backcolor=0x80000005
         p_caption='Create tag file for Java run-time libraries'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=204
         p_style=PSCH_AUTO2STATE
         p_tab_index=9
         p_tab_stop=TRUE
         p_value=0
         p_width=3720
         p_x=240
         p_y=360
      }
      _label  {
         p_alignment=AL_LEFT
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_NONE
         p_caption='Source:'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=182
         p_tab_index=10
         p_width=602
         p_word_wrap=FALSE
         p_x=120
         p_y=735
      }
      _combo_box ctljavasource {
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_case_sensitive=FALSE
         p_completion=NONE_ARG
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=338
         p_style=PSCBO_EDIT
         p_tab_index=11
         p_tab_stop=TRUE
         p_width=4500
         p_x=1080
         p_y=675
         p_eventtab2=_ul2_combobx
      }
      _command_button ctljavasrcbrowse {
         p_cancel=FALSE
         p_caption='Browse...'
         p_default=FALSE
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_height=360
         p_tab_index=12
         p_tab_stop=TRUE
         p_width=925
         p_x=5614
         p_y=645
         p_eventtab=_temp_form.ctlBrowsedir
      }
      _label  {
         p_alignment=AL_LEFT
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_NONE
         p_caption='Destination:'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=182
         p_tab_index=13
         p_width=910
         p_word_wrap=FALSE
         p_x=120
         p_y=1245
      }
      _text_box ctljavadest {
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_FIXED_SINGLE
         p_completion=FILE_ARG
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=338
         p_tab_index=14
         p_tab_stop=TRUE
         p_width=4500
         p_x=1080
         p_y=1215
         p_eventtab2=_ul2_textbox
      }
      _command_button ctljavadestbrowse {
         p_cancel=FALSE
         p_caption='Browse...'
         p_default=FALSE
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_height=360
         p_tab_index=15
         p_tab_stop=TRUE
         p_width=925
         p_x=5614
         p_y=1170
         p_eventtab=_temp_form.ctlBrowsedir
      }
   }
   _command_button ctlok {
      p_cancel=FALSE
      p_caption='Create tag file(s)'
      p_default=TRUE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_height=375
      p_tab_index=3
      p_tab_stop=TRUE
      p_width=1626
      p_x=1953
      p_y=5775
   }
   _command_button  {
      p_cancel=TRUE
      p_caption='Cancel'
      p_default=FALSE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_height=375
      p_tab_index=4
      p_tab_stop=TRUE
      p_width=930
      p_x=3900
      p_y=5775
   }
}
#else
_form _temp_form {
   p_backcolor=0x80000005
   p_border_style=BDS_DIALOG_BOX
   p_caption='Automatic tagging for Java and C/C++ Run-Time Libraries'
   p_clip_controls=FALSE
   p_forecolor=0x80000008
   p_height=6216
   p_width=6888
   p_x=4716
   p_y=1404
   _label  {
      p_alignment=AL_LEFT
      p_auto_size=FALSE
      p_backcolor=0x80000005
      p_border_style=BDS_SUNKEN
      p_caption="Visual SlickEdit's Context Tagging (Auto Function Help, Auto List Members), Class Browser, and Current Symbol Tab tools require tag files for run-time libraries.  By creating these run-time library tag files, Visual SlickEdit saves time you would otherwise spend searching for code.\r\rTo create tag files for Java and C/C++, enter the base directory for your Java and C/C++ package (if it is not already listed), as well as the destination of your tag file. For source files other than C/C++ and Java, you can create a tag file using our Tag Files dialog box (\"Search\",\"Tag Files...\")."
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_forecolor=0x80000008
      p_height=1965
      p_tab_index=0
      p_width=6660
      p_word_wrap=TRUE
      p_x=105
      p_y=90
   }
   _frame  {
      p_backcolor=0x80000005
      p_caption='C/C++ run-time libraries'
      p_clip_controls=TRUE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_forecolor=0x80000008
      p_height=1740
      p_tab_index=2
      p_width=6660
      p_x=105
      p_y=2160
      _check_box ctlcreate_cppfile {
         p_alignment=AL_LEFT
         p_backcolor=0x80000005
         p_caption='Create tag file for C++ run-time libraries'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=216
         p_style=PSCH_AUTO2STATE
         p_tab_index=1
         p_tab_stop=TRUE
         p_value=0
         p_width=3135
         p_x=240
         p_y=360
      }
      _combo_box ctlcppsource {
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_case_sensitive=FALSE
         p_completion=NONE_ARG
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=276
         p_style=PSCBO_EDIT
         p_tab_index=2
         p_tab_stop=TRUE
         p_width=4500
         p_x=1080
         p_y=735
         p_eventtab2=_ul2_combobx
      }
      _command_button ctlcppsrcbrowse {
         p_cancel=FALSE
         p_caption='Browse...'
         p_default=FALSE
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_height=360
         p_tab_index=3
         p_tab_stop=TRUE
         p_width=855
         p_x=5670
         p_y=720
         p_eventtab=_temp_form.ctlBrowsedir
      }
      _text_box ctlcppdest {
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_FIXED_SINGLE
         p_completion=FILE_ARG
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=276
         p_tab_index=5
         p_tab_stop=TRUE
         p_width=4500
         p_x=1080
         p_y=1275
         p_eventtab2=_ul2_textbox
      }
      _command_button ctlcppdestbrowse {
         p_cancel=FALSE
         p_caption='Browse...'
         p_default=FALSE
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_height=360
         p_tab_index=6
         p_tab_stop=TRUE
         p_width=855
         p_x=5685
         p_y=1230
         p_eventtab=_temp_form.ctlBrowsedir
      }
      _label  {
         p_alignment=AL_LEFT
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_NONE
         p_caption='Source:'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=192
         p_tab_index=7
         p_width=552
         p_word_wrap=FALSE
         p_x=120
         p_y=765
      }
      _label  {
         p_alignment=AL_LEFT
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_NONE
         p_caption='Destination:'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=192
         p_tab_index=8
         p_width=840
         p_word_wrap=FALSE
         p_x=105
         p_y=1305
      }
   }
   _frame  {
      p_backcolor=0x80000005
      p_caption='Java run-time libraries'
      p_clip_controls=TRUE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_forecolor=0x80000008
      p_height=1680
      p_tab_index=2
      p_width=6645
      p_x=105
      p_y=3990
      _check_box ctlcreate_javafile {
         p_alignment=AL_LEFT
         p_backcolor=0x80000005
         p_caption='Create tag file for Java run-time libraries'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=204
         p_style=PSCH_AUTO2STATE
         p_tab_index=9
         p_tab_stop=TRUE
         p_value=0
         p_width=3090
         p_x=240
         p_y=360
      }
      _label  {
         p_alignment=AL_LEFT
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_NONE
         p_caption='Source:'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=192
         p_tab_index=10
         p_width=552
         p_word_wrap=FALSE
         p_x=120
         p_y=735
      }
      _combo_box ctljavasource {
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_case_sensitive=FALSE
         p_completion=NONE_ARG
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=276
         p_style=PSCBO_EDIT
         p_tab_index=11
         p_tab_stop=TRUE
         p_width=4500
         p_x=1080
         p_y=675
         p_eventtab2=_ul2_combobx
      }
      _command_button ctljavasrcbrowse {
         p_cancel=FALSE
         p_caption='Browse...'
         p_default=FALSE
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_height=360
         p_tab_index=12
         p_tab_stop=TRUE
         p_width=855
         p_x=5670
         p_y=645
         p_eventtab=_temp_form.ctlBrowsedir
      }
      _label  {
         p_alignment=AL_LEFT
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_NONE
         p_caption='Destination:'
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=192
         p_tab_index=13
         p_width=840
         p_word_wrap=FALSE
         p_x=120
         p_y=1245
      }
      _text_box ctljavadest {
         p_auto_size=TRUE
         p_backcolor=0x80000005
         p_border_style=BDS_FIXED_SINGLE
         p_completion=FILE_ARG
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_forecolor=0x80000008
         p_height=276
         p_tab_index=14
         p_tab_stop=TRUE
         p_width=4500
         p_x=1080
         p_y=1215
         p_eventtab2=_ul2_textbox
      }
      _command_button ctljavadestbrowse {
         p_cancel=FALSE
         p_caption='Browse...'
         p_default=FALSE
         p_font_bold=FALSE
         p_font_italic=FALSE
         p_font_name='MS Sans Serif'
         p_font_size=8
         p_font_underline=FALSE
         p_height=360
         p_tab_index=15
         p_tab_stop=TRUE
         p_width=855
         p_x=5670
         p_y=1170
         p_eventtab=_temp_form.ctlBrowsedir
      }
   }
   _command_button ctlok {
      p_cancel=FALSE
      p_caption='Create tag file(s)'
      p_default=TRUE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_height=375
      p_tab_index=3
      p_tab_stop=TRUE
      p_width=1430
      p_x=2065
      p_y=5775
   }
   _command_button  {
      p_cancel=TRUE
      p_caption='Cancel'
      p_default=FALSE
      p_font_bold=FALSE
      p_font_italic=FALSE
      p_font_name='MS Sans Serif'
      p_font_size=8
      p_font_underline=FALSE
      p_height=375
      p_tab_index=4
      p_tab_stop=TRUE
      p_width=930
      p_x=3900
      p_y=5775
   }
}
#endif
