/*
$VerboseHistory: b2k.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:07:33a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 07:33a
 * Comment:
 * Changed message box to use question mark icon.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:35p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

typeless vi_mode_eventtab=0;

_command gui_bind_to_key() name_info(','EDITORCTL_ARG2)
{
  _macro_delete_line()
   result=show('-modal _b2k_form')
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   if (result!=1) {
      execute(result)
      return(rc);
   }
   return(0);
}
defeventtab _b2k_form
_b2kcommand.'_'()
{
   keyin('-');
}
_b2kdelete.lbutton_up()
{
   name=_b2kcommand.p_text;
   result=_message_box(nls("Delete macro '%s'?",name),'',MB_ICONQUESTION|MB_YESNOCANCEL)
   if (result==IDCANCEL || result==IDNO) {
      return(COMMAND_CANCELLED_RC);
   }
   _macro('m',_macro('s'))
   _macro_call('_delete_macro',name);
   status=_delete_macro(name);
   if (!status) {
      status=_b2kcommand._cbi_search('','$');
      if (!status) {
         _b2kcommand.p_cb_list_box._lbdelete_item();
      }
   }
   _b2kcommand.p_text='';
}
_b2kcmdhelp.lbutton_up()
{
   help(_b2kcommand.p_text);
}
_b2krun.lbutton_up()
{
   p_active_form._delete_window(_b2kcommand.p_text);
}
_b2kedit.lbutton_up()
{
   p_active_form._delete_window('find-proc -n '_b2kcommand.p_text);
}
#define EDITORCTL_WID _b2kcommand.p_user
void _b2kcommand.on_create()
{
   _macro('m',_macro('s'));
   wid=_form_parent();
   if (!wid || !wid._isEditorCtl()) {
      EDITORCTL_WID=HIDDEN_WINDOW_ID;
      ext='';
   } else {
      EDITORCTL_WID=wid;
      ext=EDITORCTL_WID.p_extension;
   }

   if( def_keys=='vi-keys' ) {   // Are we in vi emulation?
      // We will store the language-specific event-table so we don't have to repeatedly recalculate
      setup_index=find_index('def-setup-'ext,MISC_TYPE);
      if( !setup_index ) {
         setup_index=find_index('def-setup-fundamental',MISC_TYPE);
      }
      parse name_info(setup_index) with . ',' . ',' . ',' 'KEYTAB=' ktab_name ',' .;
      ktab_index=find_index(ktab_name,EVENTTAB_TYPE);
      if( !ktab_index ) {
         ktab_index=_default_keys;
      }
      vi_mode_eventtab=ktab_index;   // This will hold the index to the language-specific event-table
   }

   allow_editrun=arg(1) || arg(1)=='';
   title=arg(2);
   initial_command=arg(3);
   completion=arg(4);
   if (!allow_editrun) {
      _b2kedit.p_visible=_b2krun.p_visible=0;
   }
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
      _b2kedit.p_visible=false;
   }
   if (title!='') {
      p_active_form.p_caption=title;
   }
   if (completion!='') {
      p_completion=completion;
      parse p_completion with prefix ':' flags
      index=find_index(prefix'-match',PROC_TYPE);
      name=call_index('',1,index);
      for (;;) {
         if (name=='') break;
         p_cb_list_box._lbadd_item(name);
         name=call_index('',0,index);
      }
      _b2kcmdhelp.p_visible=0;
   } else {
      p_cb_list_box._insert_name_list(COMMAND_TYPE);
      _b2kdelete.p_visible=0;
   }
   p_case_sensitive=1;
   p_cb_list_box._lbsort('e')
   p_cb_list_box.top();
   p_text=initial_command;
   if (_modename_eq(EDITORCTL_WID.p_mode_name,'Fundamental') ||
       EDITORCTL_WID==HIDDEN_WINDOW_ID) {
      _b2kall.p_enabled=0;
   }
   if( def_keys=='vi-keys' ) {
      _b2kall.p_caption='Affect All Insert &Modes';
      _b2k_vi_command.p_visible=1;
      _b2k_vi_command.p_value=0;
   } else {
      _b2k_vi_command.p_visible=0;
   }
   _macro('m',_macro('s'))
}

_b2kcommand.on_change(reason)
{

   lbtext=p_cb_list_box._lbget_text();
   if (lbtext=='' || !name_eq(lbtext,p_text)) {
      _b2kbound_to.p_caption='';
      _b2kdelete.p_enabled=_b2kcmdhelp.p_enabled=_b2kedit.p_enabled=_b2krun.p_enabled=_b2kbind.p_enabled=0;
      return('');
   }
   _b2kdelete.p_enabled=_b2kcmdhelp.p_enabled=_b2kedit.p_enabled=_b2krun.p_enabled=1;
   old_mode_eventtab=EDITORCTL_WID.p_mode_eventtab;
   if (_b2kall.p_value) {
      EDITORCTL_WID.p_mode_eventtab=_default_keys;
   }
   _macro('m',0);
   _b2kbound_to.p_caption=EDITORCTL_WID.where_is(lbtext,1);
   _macro('m',_macro('s'));
   EDITORCTL_WID.p_mode_eventtab=old_mode_eventtab;
   _b2kbind.p_enabled=(_b2kkeys.p_text:!='');
}
_b2kadd.lbutton_up()
{
   orig_caption=p_caption;
   p_caption='Adding...To Abort Click Here';
   event=get_event();
   if (event==ESC) {
      result=_message_box('Add <Esc> Key?','',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result!=IDYES) {
         p_caption=orig_caption;
         return('');
      }
   }
   if (event==LBUTTON_DOWN) {
      if (mou_last_x('m')>=0 && mou_last_x('m')<p_width &&
          mou_last_y('m')>=0 && mou_last_y('m')<p_height){
         p_caption=orig_caption;
         return('');
      }
   }
   if (event:!=ESC) {
      event=_select_mouse_event(event)
      if (event:==ESC) {
         p_caption=orig_caption;
         return('');
      }
   }
   //_b2kadd.p_user contains binary length follow by binary string event.  Can
   // contain more than one or none.
   _b2kadd.p_user=_b2kadd.p_user:+_chr(length(event)):+event;
   text=_b2kkeys.p_text;
   if (text=='') {
      text=_key_for_display(event);
   } else {
      text=text' '_key_for_display(event);
   }
   _b2kkeys.p_user=text;
   _b2kkeys.p_text=text;
   p_caption=orig_caption;
}
_b2kall.lbutton_up()
{
   /* 4/19/94 HERE - CANNOT bind a command for vi command-mode and insert-mode at the same time */
   if( def_keys=='vi-keys' ) {
      if( _b2kall.p_value ) _b2k_vi_command.p_value=0;
   }
   /* **** */

   _b2kcommand.call_event('',_control _b2kcommand,ON_CHANGE,'');
   _b2kkeys.call_event('',_control _b2kkeys,ON_CHANGE,'');
}
_b2k_vi_command.lbutton_up()
{
   /* 4/19/94 HERE - CANNOT bind a command for vi command-mode and insert-mode at the same time */
   if( def_keys=='vi-keys' ) {
      if( _b2k_vi_command.p_value ) {
         _b2kall.p_value=0;
      } else if( !_b2kall.p_enabled ) {
         _b2kall.p_value=1;
      }
   }
   /* **** */

   _b2kcommand.call_event('',_control _b2kcommand,ON_CHANGE,'');
   _b2kkeys.call_event('',_control _b2kkeys,ON_CHANGE,'');
}
_b2kclear.lbutton_up()
{
   // Warning: order of assignments matters a lot
   _b2kkeys.p_text=_b2kkeys.p_user=_b2kadd.p_user='';
}
_b2kkeys.on_change()
{
   /* 4/19/94 HERE - check for vi emulation */
   vi_keys_idx=0;
   if( def_keys=='vi-keys' ) {
      vi_keys_idx=find_index('vi-command-keys',EVENTTAB_TYPE);
      if( !vi_keys_idx ) {
         _message_box('Can''t find event-table:  "vi-command-keys"')
         return('');
      }
   }
   /* **** */

   // _b2kkeys.p_user contains old p_text value before user modified p_text
   if (p_text!=_b2kkeys.p_user) {
      _beep();
      _message_box('Use "Add key or Mouse Click" button to add events here')
      p_text=_b2kkeys.p_user;
      return('');
   }
   key_sequence=_b2kadd.p_user;
   if (key_sequence=='') {
      _b2kcurbind.p_caption='';
      _b2kbind.p_enabled=0;
      _b2kunbind.p_enabled=0;
      return('');
   }
   _b2kcommand.call_event('',_control _b2kcommand,ON_CHANGE,'');
   root=mode=_default_keys
   /* 4/19/94 HERE - added check for '_b2k_vi_command.p_value' */
   if ( !_b2kall.p_value ) {
      if( vi_keys_idx ) {   // Are we in vi emulation?
         if( !_b2k_vi_command.p_value ) {
            root=mode=vi_mode_eventtab;   // This holds the language-specific event-table index
         } else {
            root=mode=vi_keys_idx;
         }
      } else {
         root=mode=EDITORCTL_WID.p_mode_eventtab;
      }
   }
   /* **** */

   for (i=0;;) {
      stringlen=_asc(substr(key_sequence,1,1));
      event=substr(key_sequence,2,stringlen);
      key_sequence=substr(key_sequence,stringlen+2);
      index=eventtab_index(root,mode,event2index(event));
#if 0 // Why not just show the exact binding
      if ( name_name(index)=='case-indirect') {
         if ( k>='a' && k<='z' ) {
            k=upcase(k);
         } else {
            k=lowcase(k);
         }
         index=eventtab_index(root,mode,event2index(event));
      }
#endif
      if ( name_type(index)== EVENTTAB_TYPE) {
         root=index;mode=index;
         if (!length(key_sequence)) {
            _b2kcurbind.p_caption=nls('Is Bound To An Event Table');
            _b2kunbind.p_enabled=1;
            return('');
         }
      } else {
         if (length(key_sequence)>0) {
            index=0;
            return('');
         }
         break;
      }
   }
   if (name_name(index)!='') {
      _b2kcurbind.p_caption='Is Bound To: 'name_name(index)
      _b2kunbind.p_enabled=1;
   } else {
      _b2kcurbind.p_caption='';
      _b2kunbind.p_enabled=0;
   }
}
_b2kunbind.lbutton_up()
{
   if( def_keys=='vi-keys' && _b2k_vi_command.p_value ) {
      status=EDITORCTL_WID._b2k_bind1('',_b2kadd.p_user,0,'CU');
   } else {
      status=EDITORCTL_WID._b2k_bind1('',_b2kadd.p_user,_b2kall.p_value,'u');
   }
   _b2kkeys.call_event('',_control _b2kkeys,ON_CHANGE,'');
}
_b2kquit.lbutton_up()
{
   p_active_form._delete_window(1);
}
_b2kbind.lbutton_up()
{
   if( def_keys=='vi-keys' && _b2k_vi_command.p_value ) {
      status=EDITORCTL_WID._b2k_bind1(_b2kcommand.p_text,_b2kadd.p_user,0,'C');
   } else {
      status=EDITORCTL_WID._b2k_bind1(_b2kcommand.p_text,_b2kadd.p_user,_b2kall.p_value);
   }
   _b2kkeys.call_event('',_control _b2kkeys,ON_CHANGE,'');
   _b2kclear.call_event(_b2kclear,LBUTTON_UP);
   return(status);
}
static _b2k_bind1(command,key_sequence,effect_all_modes,...)
{
   //IF in VI emulation AND bind/unbind key to command mode only
   if (def_keys=='vi-keys' && substr(arg(4),1,1)=='C') {
      idx=find_index('vi-command-keys',EVENTTAB_TYPE);
      if( !idx ) {
         _message_box('Can''t find event-table:  "vi-command-keys"');
         status=1;
      } else {
         old_eventtab=p_mode_eventtab;   // Save this
         p_mode_eventtab=idx;
         status=_b2k_bind2(1,command,key_sequence,0,arg(4));
         p_mode_eventtab=old_eventtab;   // Restore old event-table
      }
   } else if( def_keys=='vi-keys' && !effect_all_modes ) {
      old_eventtab=p_mode_eventtab;   // Save this
      p_mode_eventtab=vi_mode_eventtab;
      status=_b2k_bind2(1,command,key_sequence,0,arg(4));
      p_mode_eventtab=old_eventtab;   // Restore old event-table
   } else {
      status=_b2k_bind2(1,command,key_sequence,effect_all_modes,arg(4));
   }
   return(status);
}
int _b2k_bind(_str command,_str key_sequence,boolean effect_all_modes)
{
   orig_wid=p_window_id;
   if (!_isEditorCtl()) {
      p_window_id=HIDDEN_WINDOW_ID;
   }
   //IF in VI emulation AND bind/unbind key to command mode only
   if (def_keys=='vi-keys' && substr(arg(4),1,1)=='C') {
      idx=find_index('vi-command-keys',EVENTTAB_TYPE);
      if( !idx ) {
         _message_box('Can''t find event-table:  "vi-command-keys"');
         status=1;
      } else {
         old_eventtab=p_mode_eventtab;   // Save this
         p_mode_eventtab=idx;
         status=_b2k_bind1(command,key_sequence,0,arg(4));
         p_mode_eventtab=old_eventtab;   // Restore old event-table
      }
   } else if( def_keys=='vi-keys' && !effect_all_modes ) {
      old_eventtab=p_mode_eventtab;   // Save this
      p_mode_eventtab=vi_mode_eventtab;
      status=_b2k_bind1(command,key_sequence,0,arg(4));
      p_mode_eventtab=old_eventtab;
   } else {
      status=_b2k_bind2(0,command,key_sequence,effect_all_modes,arg(4));
   }
   return(status);
}
void _maybeMakeModeEventTab()
{
   was_ext_keytab=p_mode_eventtab==find_index('ext-keys',EVENTTAB_TYPE);
   if (p_mode_eventtab==_default_keys || was_ext_keytab ){
      extension=p_extension;
      setup_index = find_index('def-setup-'extension, MISC_TYPE);
      parse name_info(setup_index) with 'MN=' mode_name ',' 'TABS=' tabs','\
        'MA=' margins ',' 'KEYTAB=' keytab_name ',' rest;
      keytab_name=extension:+'-keys';
      if (find_index(keytab_name,EVENTTAB_TYPE)) {
         for (i=2;;++i) {
            name=keytab_name:+i;
            if (!find_index(name,EVENTTAB_TYPE)) {
               keytab_name=name;
               break;
            }
         }
      } 
      p_mode_eventtab=vi_mode_eventtab=
         insert_name(keytab_name,EVENTTAB_TYPE);
      if (was_ext_keytab) {
         set_eventtab_index(p_mode_eventtab,event2index(' '),
                            find_index('ext-space',COMMAND_TYPE));
      }
      new_setup_info = 'MN='mode_name',TABS='tabs',MA='margins\
        ',KEYTAB='keytab_name','rest;
      set_name_info(setup_index,new_setup_info);
      _config_modify|=CFGMODIFY_DEFDATA;
      _config_modify|=CFGMODIFY_KEYS;
   }
}
static _b2k_bind2(in_b2k_form,command,key_sequence,effect_all_modes)
{
   unbind_option= pos('U',upcase(arg(5)));
   if (command=='' && !unbind_option) {
      if (!in_b2k_form) return(1);
      _message_box(nls('Select a command'))
      p_window_id=_b2kcommand;_set_focus();
      return(1);
   }
   if (key_sequence:=='') {
      if (!in_b2k_form) return(1);
      _message_box(nls('Key sequence not defined'))
      p_window_id=_b2kadd;_set_focus();
      return(1);
   }
   cmd_index=0;
   if (!unbind_option) {
      cmd_index=find_index(command,COMMAND_TYPE)
      if (!cmd_index) {
         if (!in_b2k_form) return(1);
         _message_box(nls("Command '%s' not found",command))
         p_window_id=_b2kcommand;_set_focus();
         return(1);
      }
   }
   orig_key_sequence=key_sequence
   root=mode=_default_keys
   if (!effect_all_modes) {
      _maybeMakeModeEventTab();
      root=mode=p_mode_eventtab;
   }
   keyname='';
   for (i=0;;) {
      stringlen=_asc(substr(key_sequence,1,1));
      event=substr(key_sequence,2,stringlen);
      key_sequence=substr(key_sequence,stringlen+2);
      index=eventtab_index(root,mode,event2index(event))
      keyname=keyname:+_key_for_display(event)' ';
#if 0 // Why not just show the exact binding
      if ( name_name(index)=='case-indirect') {
         if ( k>='a' && k<='z' ) {
            k=upcase(k);
         } else {
            k=lowcase(k);
         }
         index=eventtab_index(root,mode,event2index(event));
      }
#endif
      if (length(key_sequence)==0) {
         if (!unbind_option) {
            keytab_used=mode;
         } else {
            keytab_used=eventtab_index(root,mode,event2index(event),'u');
         }
         break;
      }
      if ( name_type(index)== EVENTTAB_TYPE) {
         root=mode=index;
      } else {
         new_etab_name='default-keys:':+substr(keyname,1,length(keyname)-1)
         eventtab_i=find_index(new_etab_name,EVENTTAB_TYPE);
         if (!eventtab_i) {
            eventtab_i=insert_name(new_etab_name,EVENTTAB_TYPE);
         }
         if ( ! eventtab_i ) {
            _message_box(nls("Could not create key table")". "get_message(eventtab_i));
            return(rc);
         }
         keytab_used=eventtab_index(root,mode,event2index(event),'u');
         set_eventtab_index keytab_used,event2index(event),eventtab_i;
         root=mode=eventtab_i;
      }
   }
   keyname=strip(keyname);
   old_cmd_index=eventtab_index(keytab_used,keytab_used,event2index(event));
   set_eventtab_index keytab_used,event2index(event),cmd_index;
   menu_index=0;
   if (effect_all_modes) {
      if (unbind_option) {
         menu_index=find_index(_cur_mdi_menu,oi2type(OI_MENU));
         _menu_unbind(_mdi.p_menu_handle,menu_index,
                    old_cmd_index,keyname);
      } else {
         if (name_type(old_cmd_index) & EVENTTAB_TYPE) {
            menu_mdi_bind_all();
         } else {
            menu_index=find_index(_cur_mdi_menu,oi2type(OI_MENU));
            _menu_bind(_mdi.p_menu_handle,menu_index,
                       name_name(cmd_index),keyname,'B');
         }
      }
   }
   _set_object_modify(menu_index);
   _config_modify|= CFGMODIFY_KEYS;
   if (in_b2k_form) {
      _macro('m',_macro('s'));
      _macro_append('// Warning: Binary key strings likely to change in future releases');
      _macro_append('_b2k_bind('_quote(command)','_quote(orig_key_sequence)','_quote(effect_all_modes)','_quote(arg(5))');');
   }
   if (_issysmenu_key(substr(orig_key_sequence,2))) {
      _update_sysmenu_bindings();
   }
   return(0);
}
