#include "slick.sh"

#define BOX_INI_FILENAME "box.ini"
#define BOX_USER_INI_FILENAME "ubox.ini"

#define SAVING_SETTINGS _ctl_extension.p_user
#define CURRENT_EXT     _ctl_ok.p_user

static _str _box_ini_filename;
static _str _box_user_ini_filename;

typedef struct {
   _str tlc;
   _str trc;
   _str blc;
   _str brc;
   _str bhside;
   _str thside;
   _str lvside;
   _str rvside;
   _str comment_left;
   _str comment_right;
   int  comment_col;
   boolean firstline_is_top;
   boolean lastline_is_bottom;
} _settings_t;
static  _settings_t _settings:[];
static  _settings_t _orig_settings:[];

defeventtab _comment_box_form
_ctl_ok.on_create()
{
   ext=arg(1);

   _init_ini_files();

   _settings._makeempty();

   buf_name='';
   if (ext=='') {
      wid=_form_parent();
      if (!wid || !wid._isEditorCtl()) {
         ext='fundamental';
      } else {
         ext=wid.p_extension;
      }
      CURRENT_EXT=ext;
   } else {
      CURRENT_EXT=refer_ext(ext,buf_name);
   }
   caption='Comment Setup for';
   if( ext=='fundamental' ) {
      caption=caption' 'CURRENT_EXT;
   } else {
      caption=caption' .'CURRENT_EXT;
   }
   p_active_form.p_caption=caption;
   _update_settings();
}

_ctl_ok.on_destroy()
{
   // Empty the _settings hash table so it doesn't get stored in the state file
   _settings._makeempty();
   _orig_settings._makeempty();
}

_ctl_ok.lbutton_up()
{
   if( CURRENT_EXT!='' ) {
      _get_form_settings(_settings:[CURRENT_EXT]);
   }

   // Now go through and save all the settings
   for( i._makeempty();; ) {
      _settings._nextel(i);
      if( i._isempty() ) break;
      if( _settings:[i]!=_orig_settings:[i] ) {
         if( _save_settings(i,_settings:[i]) ) {
            _message_box('Error saving settings for extension .'i);
            return('');
         }
      }
   }

   p_active_form._delete_window();
}

_ctl_enable_comment_col.lbutton_up()
{
   _ctl_comment_col.p_enabled=(_ctl_enable_comment_col.p_value!=0);
}

_ctl_firstline_is_top.lbutton_up()
{
   _ctl_thside.p_enabled= !_ctl_firstline_is_top.p_value;
}

_ctl_lastline_is_bottom.lbutton_up()
{
   _ctl_bhside.p_enabled= !_ctl_lastline_is_bottom.p_value;
}

static int _update_settings()
{
   _settings_t p;

   ext=CURRENT_EXT;

   // Fill in the box settings for the extension
   p.tlc='';
   p.thside='';
   p.trc='';
   p.lvside='';
   p.rvside='';
   p.blc='';
   p.bhside='';
   p.brc='';
   p.comment_left='';
   p.comment_right='';
   p.comment_col=0;
   p.firstline_is_top=false;
   p.lastline_is_bottom=false;
   if( ext!='' ) {
      if( !_settings:[ext]._isempty() ) {
         p=_settings:[ext];
         tlc=p.tlc;
         trc=p.trc;
         blc=p.blc;
         brc=p.brc;
         bhside=p.bhside;
         thside=p.thside;
         lvside=p.lvside;
         rvside=p.rvside;
         comment_left=p.comment_left;
         comment_right=p.comment_right;
         comment_col=p.comment_col;
         firstline_is_top=p.firstline_is_top;
         lastline_is_bottom=p.lastline_is_bottom;
      } else {
         if( _comment_get_settings(ext,_settings) ) {
            _message_box('There is currently no comment setup information for 'CURRENT_EXT);
         } else {
            p=_settings:[ext];
            _orig_settings:[ext]=p;
         }
      }
   } else {
      return(1);
   }
   _ctl_tlc.p_text    =p.tlc;
   _ctl_thside.p_text =p.thside;
   _ctl_trc.p_text    =p.trc;
   _ctl_lvside.p_text =p.lvside;
   _ctl_rvside.p_text =p.rvside;
   _ctl_blc.p_text    =p.blc;
   _ctl_bhside.p_text =p.bhside;
   _ctl_brc.p_text    =p.brc;
   _ctl_left.p_text   =p.comment_left;
   _ctl_right.p_text  =p.comment_right;
   if( isinteger(p.comment_col) && p.comment_col>0 ) {
      _ctl_enable_comment_col.p_value=1;
      _ctl_comment_col.p_text=p.comment_col;
   } else {
      _ctl_enable_comment_col.p_value=0;
      _ctl_comment_col.p_text=0;
   }
   if( p.firstline_is_top ) _ctl_firstline_is_top.p_value=1;
   if( p.lastline_is_bottom ) _ctl_lastline_is_bottom.p_value=1;
   call_event(_ctl_enable_comment_col,LBUTTON_UP);
   call_event(_ctl_firstline_is_top,LBUTTON_UP);
   call_event(_ctl_lastline_is_bottom,LBUTTON_UP);

   return(0);
}

static int _get_form_settings(_settings_t (&p))
{
   tlc    =strip(_ctl_tlc.p_text,'T');
   thside =strip(_ctl_thside.p_text,'T');
   trc    =strip(_ctl_trc.p_text,'T');
   lvside =strip(_ctl_lvside.p_text,'T');
   rvside =strip(_ctl_rvside.p_text,'T');
   blc    =strip(_ctl_blc.p_text,'T');
   bhside =strip(_ctl_bhside.p_text,'T');
   brc    =strip(_ctl_brc.p_text,'T');
   comment_left  =strip(_ctl_left.p_text,'T');
   comment_right =strip(_ctl_right.p_text,'T');
   comment_col=0;
   if( _ctl_enable_comment_col.p_value ) {
      comment_col=_ctl_comment_col.p_text;
      if( comment_col=='' ) {
         comment_col=0;
      } else {
         if( !isinteger(comment_col) || comment_col<0 ) {
            _message_box('Invalid comment column');
            p_window_id=_ctl_comment_col;
            _set_sel(1,length(p_text)+1);_set_focus();
            return(1);
         }
      }
   }
   firstline_is_top=false;
   lastline_is_bottom=false;
   if( _ctl_firstline_is_top.p_value ) firstline_is_top=true;
   if( _ctl_lastline_is_bottom.p_value ) lastline_is_bottom=true;

   p.tlc    =tlc;
   p.thside =thside;
   p.trc    =trc;
   p.lvside =lvside;
   p.rvside =rvside;
   p.blc    =blc;
   p.bhside =bhside;
   p.brc    =brc;
   p.comment_left  =comment_left;
   p.comment_right =comment_right
   p.comment_col=comment_col;
   p.firstline_is_top=firstline_is_top;
   p.lastline_is_bottom=lastline_is_bottom;

   return(0);
}

_command int box() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK|VSARG2_REQUIRES_AB_SELECTION)
{
   _settings_t s;

   if( !select_active() ) {
      _message_box('No selection active');
      return(1);
   }

   stype=_select_type();

   if( arg()>1 ) {
      s.tlc=arg(1);
      s.trc=arg(2);
      s.blc=arg(3)
      s.brc=arg(4);
      s.bhside=arg(5);
      s.thside=arg(6);
      s.lvside=arg(7);
      s.rvside=arg(8);
      s.comment_col=0;   // Hardcode this
      s.firstline_is_top=false;
      s.lastline_is_bottom=false;
   } else {
      parse arg(1) with ext .;
      if( ext=='' ) {
         ext=p_extension;
      }
      orig_ext=ext;
      if( ext!='' ) {
         _settings_t temp:[];
         if( _init_ini_files() ) return(1);
         if( _comment_get_settings(ext,temp) ) {
            _message_box('No comments setup for 'orig_ext);
            return(1);
         }
         s=temp:[ext];
      } else {
         _message_box('No comments setup for 'orig_ext);
         return(1);
      }
   }
   save_pos(p);
   if( stype=='LINE' ) {
      width=longest_line_in_selection()+1;
      start_col=1;end_col=width;
   } else if( stype=='BLOCK' ) {
      _get_selinfo(start_col,end_col,dummy);
      width=end_col-start_col+1;
   } else {
      // stype=='CHAR'
      _select_type('','L','LINE');
      width=longest_line_in_selection();
      start_col=1;end_col=width;
      stype='LINE';
   }
   leftmostcol=MAX_LINE;
   comment_col=0;
   if( stype=='LINE' && s.comment_col ) {
      leftmostcol=_leftmost_col_in_selection();
      if( leftmostcol<s.comment_col ) {
         comment_col=s.comment_col;
      }
   }
   noflines=count_lines_in_selection();

   firstline_is_top=s.firstline_is_top;
   lastline_is_bottom=s.lastline_is_bottom;

   _begin_select();

   // Test for special case of boxing a single line
   single_line=0;
   save_pos(p2);   // So the scroll pos does not change
   if( down() ) {
      single_line=1;
   } else {
      single_line= (_end_select_compare()>0 || noflines==1)?(1):(0);
      up();
   }
   restore_pos(p2);

   down_count=0;
   if( firstline_is_top ) {
      get_line(line);
      if( stype=='LINE' ) {
         line=strip(line,'T');
      }
      before=expand_tabs(line,1,start_col-1,'S');
      middle=expand_tabs(line,start_col,width);
      after=expand_tabs(line,end_col+1,-1,'S');
      if( comment_col ) {
         // It's a line selection, so can blast 'before'
         before=indent_string(comment_col-1);
         middle=substr(middle,leftmostcol);
      }
      topsidelen=length(middle);   /* Save this just in case we need to use it
                                    * later to re-select.
                                    */
      if( single_line && lastline_is_bottom ) {
         new_line=before:+s.tlc' ':+middle:+' 's.brc:+after;
      } else {
         new_line=before:+s.tlc' ':+middle:+' 's.trc:+after;
      }
      new_line=strip(new_line,'T');
      replace_line(new_line);
      if( !single_line ) down();
   } else {
      topside='';
      /* +2 for the space on either side of boxed line
       * +length(lvside) for the left side of box
       * +length(rvside) for the right side of box
       * -length(tlc) for top-left-corner box chars
       * -length(trc) for top-right-corner box chars
       */
      topsidelen=width+2+length(s.lvside)+length(s.rvside)-length(s.tlc)-length(s.trc);
      if( topsidelen<0 ) topsidelen=0;   // Just in case
      if( s.thside!='' ) {
         topside=substr('',1,topsidelen,s.thside);
      }
      get_line(line);
      if( comment_col ) {
         // It's a line selection, so there is nothing before 'start_col'
         replace_line(indent_string(comment_col-1):+s.tlc:+topside:+s.trc);
      } else {
         replace_line(substr('',1,start_col-1):+s.tlc:+topside:+s.trc);
      }
      insert_line(line);
   }
   i=0;
   if( !(single_line && (firstline_is_top || lastline_is_bottom)) &&
       !(noflines==2 && firstline_is_top && lastline_is_bottom) ) {
      for( ;; ) {
         get_line(line);
         if( stype=='LINE' ) {
            line=strip(line,'T');
         }
         before=expand_tabs(line,1,start_col-1,'S');
         middle=expand_tabs(line,start_col,width);
         after=expand_tabs(line,end_col+1,-1,'S');
         if( comment_col ) {
            // It's a line selection, so can blast 'before'
            before=indent_string(comment_col-1);
            middle=substr(middle,leftmostcol);
         }
         new_line=before:+s.lvside' ':+middle:+' 's.rvside:+after;
         new_line=strip(new_line,'T');
         replace_line(new_line);
         ++i;
         status=down();
         if( status ) break;
         if( _end_select_compare()>0 ||
             (lastline_is_bottom && !_end_select_compare()) ) {
            break;
         }
      }
      if( !status && !(lastline_is_bottom && !_end_select_compare()) ) {
         up();
      }
   }
   down_count+=i;

   if( lastline_is_bottom ) {
      if( !(single_line && firstline_is_top) ) {
         get_line(line);
         if( stype=='LINE' ) {
            line=strip(line,'T');
         }
         before=expand_tabs(line,1,start_col-1,'S');
         middle=expand_tabs(line,start_col,width);
         after=expand_tabs(line,end_col+1,-1,'S');
         if( comment_col ) {
            // It's a line selection, so can blast 'before'
            before=indent_string(comment_col-1);
            middle=substr(middle,leftmostcol);
         }
         bottomsidelen=length(middle);   /* Save this just in case we need to use it
                                          * later to re-select.
                                          */
         new_line=before:+s.blc' ':+middle:+' 's.brc:+after;
         new_line=strip(new_line,'T');
         replace_line(new_line);
         ++down_count;
      }
   } else {
      bottomside='';
      bottomsidelen=width+2+length(s.lvside)+length(s.rvside)-length(s.blc)-length(s.brc);
      if( bottomsidelen<0 ) bottomsidelen=0;   // Just in case
      if( s.bhside!='' ) {
         bottomside=substr('',1,bottomsidelen,s.bhside);
      }
      if( comment_col ) {
         // It's a line selection, so there is nothing before 'start_col'
         insert_line(indent_string(comment_col-1):+s.blc:+bottomside:+s.brc);
      } else {
         insert_line(substr('',1,start_col-1):+s.blc:+bottomside:+s.brc);
      }
      ++down_count;
   }

   // Now re-select the text inside the box
   _begin_select();_deselect();
   if( stype=='LINE' ) {
      _select_line();
      down(down_count);
      _select_line();
      _begin_select();p_col=1;
   } else {
      _select_block();
      down(down_count);
      if( single_line && firstline_is_top && lastline_is_bottom ) {
         p_col+=length(s.tlc' ')+topsidelen+length(' 's.brc)-1;
      } else {
         if( lastline_is_bottom ) {
            p_col+=length(s.blc' ')+bottomsidelen+length(' 's.brc)-1;
         } else {
            p_col+=length(s.blc)+bottomsidelen+length(s.brc)-1;
         }
      }
      _select_block();
      _begin_select();
   }

   return(0);
}

_command int box_erase() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   _settings_t s;

   if( !select_active() ) {
      _message_box('No selection active');
      return(1);
   }

   stype=_select_type();

   if( arg()>1 ) {
      s.tlc=arg(1);
      s.trc=arg(2);
      s.blc=arg(3)
      s.brc=arg(4);
      s.bhside=arg(5);
      s.thside=arg(6);
      s.lvside=arg(7);
      s.rvside=arg(8);
      s.comment_col=0;
      s.firstline_is_top=false;
      s.lastline_is_bottom=false;
   } else {
      parse arg(1) with param .;
      ext=param;
      orig_ext=ext;
      if( ext=='' ) {
         ext=p_extension;
         orig_ext=ext;
      }
      if( ext!='' ) {
         _settings_t temp:[];

         if( _init_ini_files() ) return(1);
         if( _comment_get_settings(ext,temp) ) {
            _message_box('No comments setup for 'orig_ext);
            return(1);
         }
         s=temp:[ext];
      } else {
         _message_box('No comments setup for 'orig_ext);
         return(1);
      }
   }

   _undo('S');   // So we can quickly undo if a problem
   save_pos(p);
   if( stype=='LINE' ) {
      width=longest_line_in_selection();
      start_col=1;end_col=width;
   } else if( stype=='BLOCK' ) {
      _get_selinfo(start_col,end_col,dummy);
      width=end_col-start_col+1;
   } else {
      // stype=='CHAR'
      _select_type('','L','LINE');
      width=longest_line_in_selection();
      start_col=1;end_col=width;
      stype='LINE';
   }
   noflines=count_lines_in_selection();

   _begin_select();

   // Test for special case of a single line
   single_line=0;
   save_pos(p2);   // So the scroll pos does not change
   if( down() ) {
      single_line=1;
   } else {
      if( down() ) {
         single_line=1;
      } else {
         single_line= (_end_select_compare()>0 || noflines==1)?(1):(0);
         up();
      }
   }
   restore_pos(p2);

   count=0;
   firstline_is_top=s.firstline_is_top;
   lastline_is_bottom=s.lastline_is_bottom;
   if( single_line && firstline_is_top && lastline_is_bottom ) {
      ss=_escape_re_chars(s.tlc' '):+'?@':+_escape_re_chars(' 's.brc);
      get_line(line);
      if( !pos('{#0'ss'}',expand_tabs(line),1,'er') ) {
         _message_box('Bad comment');
         return(1);
      }
      before=expand_tabs(line,1,pos('S0')-1,'S');
      midlen=pos('0')-length(s.tlc' ')-length(s.brc);
      middle=expand_tabs(line,pos('S0')+length(s.tlc' '),midlen);
      after=strip(expand_tabs(line,pos('S0')+pos('0'),-1,'S'),'T');
      if( after=='' ) {
         after='';
         // There is nothing after the middle part, so strip trailing spaces from middle
         middle=strip(middle,'T');
      }
      replace_line(before:+middle:+after);
      ++count;
   } else {
      if( firstline_is_top ) {
         ss=_escape_re_chars(s.tlc' '):+'?@';
         // trc might be '', so don't want to look for something that's not there
         if( s.trc!='' ) {
            ss=ss:+_escape_re_chars(' 's.trc);
         }

         get_line(line);
         if( !pos('{#0'ss'}',expand_tabs(line),1,'er') ) {
            _message_box('Bad comment');
            return(1);
         }
         before=expand_tabs(line,1,pos('S0')-1,'S');
         midlen=pos('0')-length(s.tlc' ');
         // trc might be '', so don't want to look for something that's not there
         if( s.trc!='' ) {
            midlen=midlen-length(' 's.trc);
         }
         middle=expand_tabs(line,pos('S0')+length(s.tlc' '),midlen);
         after=strip(expand_tabs(line,pos('S0')+pos('0'),-1,'S'),'T');
         if( after=='' ) {
            after='';
            // There is nothing after the middle part, so strip trailing spaces from middle
            middle=strip(middle,'T');
         }
         replace_line(before:+middle:+after);
         if( down() ) {
            _message_box('Bad comment');
            _undo();
            return(1);
         }
         ++count;
      } else {
         get_line(line);
         ss=_escape_re_chars(s.tlc):+'('_escape_re_chars(s.thside)')@':+_escape_re_chars(s.trc);
         if( !pos('{#0'ss'}',expand_tabs(line),1,'er') ) {
            _message_box('Bad comment');
            return(1);
         }
         before=expand_tabs(line,1,pos('S0')-1,'S');
         after=expand_tabs(line,pos('S0')+pos('0'),-1,'S');
         if( before=='' && after=='' ) {
            // The entire line is the top of the comment box
            _delete_line();
         } else {
            replace_line(before:+after);
            if( down() ) {
               _message_box('Bad comment');
               _undo();
               return(1);
            }
         }
      }

   }

   status=0;
   if( !(single_line && firstline_is_top ) ) {
      ss=_escape_re_chars(s.lvside' '):+'?@';
      // rvside might be '', so don't want to look for something that's not there
      if( s.rvside!='' ) {
         ss=ss:+_escape_re_chars(' 's.rvside);
      }
      i=0;
      for( ;; ) {
         if( _end_select_compare()>=0 ) break;
         get_line(line);
         if( !pos('{#0'ss'}',expand_tabs(line),1,'er') ) {
            if( s.lastline_is_bottom ) {
               ss2=_escape_re_chars(s.blc):+'?@':+_escape_re_chars(s.brc);
            } else {
               ss2=_escape_re_chars(s.blc):+'('_escape_re_chars(s.bhside)')@':+_escape_re_chars(s.brc);
            }
            if( pos(ss2,expand_tabs(line),1,'er') ) break;
            _message_box('Bad comment');
            _undo();
            return(1);
         }
         before=expand_tabs(line,1,pos('S0')-1,'S');
         midlen=pos('0')-length(s.lvside' ');
         // rvside might be '', so don't want to look for something that's not there
         if( s.rvside!='' ) {
            midlen=midlen-length(' 's.rvside);
         }
         middle=expand_tabs(line,pos('S0')+length(s.lvside' '),midlen);
         after=strip(expand_tabs(line,pos('S0')+pos('0'),-1,'S'),'T');
         if( after=='' ) {
            after='';
            // There is nothing after the middle part, so strip trailing spaces from middle
            middle=strip(middle,'T');
         }
         replace_line(before:+middle:+after);
         ++i;
         status=down();
         if( status ) break;
      }
      if( i ) count+=i;
   }
   if( status ) {
      _message_box('Bad comment');
      _undo();
      return(1);
   }

   if( lastline_is_bottom ) {
      if( !(single_line && firstline_is_top) ) {
         get_line(line);
         ss=_escape_re_chars(s.blc):+'?@':+_escape_re_chars(s.brc);
         if( !pos('{#0'ss'}',expand_tabs(line),1,'er') ) {
            _message_box('Bad comment');
            _undo();
            return(1);
         }
         before=expand_tabs(line,1,pos('S0')-1,'S');
         midlen=pos('0')-length(s.blc' ');
         // brc might be '', so don't want to look for something that's not there
         if( s.brc!='' ) {
            midlen=midlen-length(' 's.brc);
         }
         middle=expand_tabs(line,pos('S0')+length(s.blc' '),midlen);
         after=strip(expand_tabs(line,pos('S0')+pos('0'),-1,'S'),'T');
         if( after=='' ) {
            after='';
            // There is nothing after the middle part, so strip trailing spaces from middle
            middle=strip(middle,'T');
         }
         replace_line(before:+middle:+after);
         ++count;
      }
   } else {
      get_line(line);
      ss=_escape_re_chars(s.blc):+'('_escape_re_chars(s.bhside)')@':+_escape_re_chars(s.brc);
      if( !pos('{#0'ss'}',expand_tabs(line),1,'er') ) {
         _message_box('Bad comment');
         _undo();
         return(1);
      }
      _delete_line();
   }

   // Now re-select the text that was inside the box
   _begin_select();_deselect();
   if( stype=='LINE' ) {
      _select_line();
      if( count ) down(count-1);
      _select_line();
      _begin_select();p_col=1;
   } else {
      // stype=='BLOCK'
      _select_block();
      if( count ) down(count-1);
      /* +width for width of block selection
       * -length(tlc) for length of top-left-corner box chars
       * -length(trc) for length of top-right-corner box chars
       * -2 for the space on either side of boxed line
       */
      p_col+=width-length(s.tlc)-length(s.trc)-2-1;_select_block();
      _begin_select();
   }

   return(0);
}

_command void comment_setup() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK|VSARG2_NOEXIT_SCROLL|
                                        VSARG2_ICON|VSARG2_READ_ONLY)
{
   show("-modal _comment_box_form");
}
_command int comment() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK|VSARG2_REQUIRES_AB_SELECTION)
{
   _settings_t s;

   if( !select_active() ) {
      _message_box('No selection active');
      return(1);
   }

   stype=_select_type();

   if( arg()>1 ) {
      s.comment_left=arg(1);
      s.comment_right=arg(2);
      s.comment_col=0;   // Hardcode this
   } else {
      parse arg(1) with param .;
      ext=param;
      orig_ext=ext;
      if( ext=='' ) {
         ext=p_extension;
         orig_ext=ext;
      }
      if( ext!='' ) {
         _settings_t temp:[];
         if( _init_ini_files() ) return(1);
         if( _comment_get_settings(ext,temp) ) {
            _message_box('There is currently no comment setup information for 'orig_ext);
            return(1);
         }
         s=temp:[ext];
      } else {
         _message_box('There is currently no comment setup information for 'orig_ext);
         return(1);
      }
   }
   if( s.comment_left=='' && s.comment_right=='' ) {
      _message_box('There is currently no comment setup information for 'orig_ext);
      return(1);
   }
   save_pos(p);
   if( stype=='LINE' ) {
      width=longest_line_in_selection()+1;
      start_col=1;end_col=width;
   } else if( stype=='BLOCK' ) {
      _get_selinfo(start_col,end_col,dummy);
      width=end_col-start_col+1;
   } else {
      // stype=='CHAR'
      _select_type('','L','LINE');
      width=longest_line_in_selection();
      start_col=1;end_col=width;
      stype='LINE';
   }
   leftmostcol=MAX_LINE;
   comment_col=0;
   if( stype=='LINE' && s.comment_col ) {
      leftmostcol=_leftmost_col_in_selection();
      if( leftmostcol<s.comment_col ) {
         comment_col=s.comment_col;
      }
   }

   _begin_select();
   i=0;
   for( ;; ) {
      get_line(line);
      if( stype=='LINE' ) {
         line=strip(line,'T');
      }
      before=expand_tabs(line,1,start_col-1,'S');
      middle=expand_tabs(line,start_col,width);
      after=expand_tabs(line,end_col+1,-1,'S');
      if( comment_col ) {
         // It's a line selection, so can blast 'before'
         before=indent_string(comment_col-1);
         middle=substr(middle,leftmostcol);
      }
      new_line=before:+s.comment_left' ':+middle:+' 's.comment_right:+after;
      new_line=strip(new_line,'T');
      replace_line(new_line);
      ++i;
      status=down();
      if( status ) break;
      if( _end_select_compare()>0 ) break;
   }
   if( !status ) {
      up();
   }

   _begin_select();_deselect();
   if( stype=='LINE' ) {
      _select_line();
      if( i ) down(i-1);
      _select_line();
      _begin_select();p_col=1;
   } else {
      _select_block();
      if( i ) down(i-1);
      /* +width for width of block selection
       * +length(comment_left) for length of left-side comment chars
       * +length(comment_right) for length of right-side comment chars
       * +2 for the space on either side of boxed line
       */
      p_col+=width+length(s.comment_left)+length(s.comment_right)+2;
      _select_block();
      _begin_select();
   }

   return(0);
}

_command int comment_erase() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   _settings_t s;

   if( !select_active() ) {
      _message_box('No selection active');
      return(1);
   }

   stype=_select_type();

   if( arg()>1 ) {
      s.comment_left=arg(1);
      s.comment_right=arg(2);
   } else {
      parse arg(1) with param .;
      ext=param;
      orig_ext=ext;
      if( ext=='' ) {
         ext=p_extension;
         orig_ext=ext;
      }
      if( ext!='' ) {
         _settings_t temp:[];

         if( _init_ini_files() ) return(1);
         if( _comment_get_settings(ext,temp) ) {
            _message_box('There is currently no comment setup information for 'orig_ext);
            return(1);
         }
         s=temp:[ext];
      } else {
         _message_box('There is currently no comment setup information for 'orig_ext);
         return(1);
      }
   }
   if( s.comment_left=='' && s.comment_right=='' ) {
      _message_box('There is currently no comment setup information for 'orig_ext);
      return(1);
   }

   _undo('S');   // So we can quickly undo if a problem
   save_pos(p);
   if( stype=='LINE' ) {
      width=longest_line_in_selection();
      start_col=1;end_col=width;
   } else if( stype=='BLOCK' ) {
      _get_selinfo(start_col,end_col,dummy);
      width=end_col-start_col+1;
   } else {
      // stype=='CHAR'
      _select_type('','L','LINE');
      width=longest_line_in_selection();
      start_col=1;end_col=width;
      stype='LINE';
   }

   _begin_select();
   ss=_escape_re_chars(s.comment_left' '):+'?@':+_escape_re_chars(' 's.comment_right);
   i=0;
   for( ;; ) {
      get_line(line);
      if( !pos('{#0'ss'}',expand_tabs(line),1,'er') ) {
         _message_box('Bad comment');
         _undo();
         return(1);
      }
      before=expand_tabs(line,1,pos('S0')-1,'S');
      middle=expand_tabs(line,pos('S0')+length(s.comment_left' '),pos('0')-length(s.comment_left' ')-length(' 's.comment_right));
      after=strip(expand_tabs(line,pos('S0')+pos('0'),-1,'S'),'T');
      if( after=='' ) {
         // There is nothing after the middle part, so strip trailing spaces from middle
         middle=strip(middle,'T');
      }
      replace_line(before:+middle:+after);
      ++i;
      status=down();
      if( status ) break;
      if( _end_select_compare()>0 ) break;
   }
   if( status ) {
      _message_box('Bad comment');
      _undo();
      return(1);
   }

   _begin_select();_deselect();
   if( stype=='LINE' ) {
      _select_line();
      if( i ) down(i-1);
      _select_line();
      _begin_select();p_col=1;
   } else {
      // stype=='BLOCK'
      _select_block();
      if( i ) down(i-1);
      /* +width for width of block selection
       * -length(comment_left) for length of left-side comment chars
       * -length(comment_right) for length of right-side comment chars
       * -2 for the space on either side of boxed line
       */
      p_col+=width-length(s.comment_left)-length(s.comment_right)-2-1;_select_block();
      _begin_select();
   }

   return(0);
}

/*
 * \s=space
 * \e=empty
 */
static _str _xlat_ini2chars(_str str)
{
   new_str=str;
   new_str=stranslate(new_str,' ','\s');
   new_str=stranslate(new_str,'','\e');

   return(new_str);
}

static _str _xlat_chars2ini(_str str)
{
   new_str=str;
   if( new_str=='' ) {
      new_str='\e';
   } else {
      new_str=stranslate(new_str,'\s',' ');
   }

   return(new_str);
}

static void _box_parse_settings(_str line,
                                _str &tlc,_str &trc,
                                _str &blc,_str &brc,
                                _str &bhside,_str &thside,
                                _str &lvside,_str &rvside)
{
   tlc=eq_name2value('tlc',line);
   trc=eq_name2value('trc',line);
   blc=eq_name2value('blc',line);
   brc=eq_name2value('brc',line);
   bhside=eq_name2value('bhside',line);
   thside=eq_name2value('thside',line);
   lvside=eq_name2value('lvside',line);
   rvside=eq_name2value('rvside',line);

   return;
}

static void _comment_parse_settings(_str line,
                                    _str &comment_left,_str &comment_right)
{
   comment_left=eq_name2value('left',line);
   comment_right=eq_name2value('right',line);

   return;
}

static int _comment_get_settings(ext,_settings_t (&p):[])
{
   status=1;
   if( ext!='' ) {

      // Check the user settings first
      status=_ini_get_value(_box_user_ini_filename,ext,'boxchars',line);
      if( !status ) {
         _box_parse_settings(line,tlc,trc,blc,brc,bhside,thside,lvside,rvside);
         p:[ext].tlc=_xlat_ini2chars(tlc);
         p:[ext].trc=_xlat_ini2chars(trc);
         p:[ext].blc=_xlat_ini2chars(blc);
         p:[ext].brc=_xlat_ini2chars(brc);
         p:[ext].bhside=_xlat_ini2chars(bhside);
         p:[ext].thside=_xlat_ini2chars(thside);
         p:[ext].lvside=_xlat_ini2chars(lvside);
         p:[ext].rvside=_xlat_ini2chars(rvside);
         status=_ini_get_value(_box_user_ini_filename,ext,'nonboxchars',line);
         if( !status ) {
            _comment_parse_settings(line,comment_left,comment_right);
            p:[ext].comment_left=_xlat_ini2chars(comment_left);
            p:[ext].comment_right=_xlat_ini2chars(comment_right);
         } else {
            p:[ext].comment_left='';
            p:[ext].comment_right='';
         }
         status=_ini_get_value(_box_user_ini_filename,ext,'comment_col',line);
         if( !status ) {
            p:[ext].comment_col=(int)line;
         } else {
            p:[ext].comment_col=0;
         }
         status=_ini_get_value(_box_user_ini_filename,ext,'firstline_is_top',line);
         if( !status ) {
            p:[ext].firstline_is_top=(line!=0);
         } else {
            p:[ext].firstline_is_top=false;
         }
         status=_ini_get_value(_box_user_ini_filename,ext,'lastline_is_bottom',line);
         if( !status ) {
            p:[ext].lastline_is_bottom=(line!=0);
         } else {
            p:[ext].lastline_is_bottom=false;
         }
         return(0);
      }

      // Now check the global settings
      status=_ini_get_value(_box_ini_filename,ext,'boxchars',line);
      if( !status ) {
         _box_parse_settings(line,tlc,trc,blc,brc,bhside,thside,lvside,rvside);
         p:[ext].tlc=_xlat_ini2chars(tlc);
         p:[ext].trc=_xlat_ini2chars(trc);
         p:[ext].blc=_xlat_ini2chars(blc);
         p:[ext].brc=_xlat_ini2chars(brc);
         p:[ext].bhside=_xlat_ini2chars(bhside);
         p:[ext].thside=_xlat_ini2chars(thside);
         p:[ext].lvside=_xlat_ini2chars(lvside);
         p:[ext].rvside=_xlat_ini2chars(rvside);
         status=_ini_get_value(_box_ini_filename,ext,'nonboxchars',line);
         if( !status ) {
            _comment_parse_settings(line,comment_left,comment_right);
            p:[ext].comment_left=_xlat_ini2chars(comment_left);
            p:[ext].comment_right=_xlat_ini2chars(comment_right);
         } else {
            p:[ext].comment_left='';
            p:[ext].comment_right='';
         }
         status=_ini_get_value(_box_ini_filename,ext,'comment_col',line);
         if( !status ) {
            p:[ext].comment_col=(int)line;
         } else {
            p:[ext].comment_col=0;
         }
         status=_ini_get_value(_box_user_ini_filename,ext,'firstline_is_top',line);
         if( !status ) {
            p:[ext].firstline_is_top=(line!=0);
         } else {
            p:[ext].firstline_is_top=false;
         }
         status=_ini_get_value(_box_user_ini_filename,ext,'lastline_is_bottom',line);
         if( !status ) {
            p:[ext].lastline_is_bottom=(line!=0);
         } else {
            p:[ext].lastline_is_bottom=false;
         }
         status=0;
      }
   }

   return(status);
}

static int _save_settings(_str ext,_settings_t p)
{
   line='tlc='_xlat_chars2ini(p.tlc):+
       ' trc='_xlat_chars2ini(p.trc):+
       ' blc='_xlat_chars2ini(p.blc):+
       ' brc='_xlat_chars2ini(p.brc):+
       ' bhside='_xlat_chars2ini(p.bhside):+
       ' thside='_xlat_chars2ini(p.thside):+
       ' lvside='_xlat_chars2ini(p.lvside):+
       ' rvside='_xlat_chars2ini(p.rvside);
   status=_ini_set_value(_box_user_ini_filename,ext,'boxchars',line);
   if( status ) return(status);
   line='left='_xlat_chars2ini(p.comment_left):+
       ' right='_xlat_chars2ini(p.comment_right);
   status=_ini_set_value(_box_user_ini_filename,ext,'nonboxchars',line);
   if( status ) return(status);
   line=p.comment_col;
   status=_ini_set_value(_box_user_ini_filename,ext,'comment_col',line);
   line= (p.firstline_is_top)?(1):(0);
   status=_ini_set_value(_box_user_ini_filename,ext,'firstline_is_top',line);
   line= (p.lastline_is_bottom)?(1):(0);
   status=_ini_set_value(_box_user_ini_filename,ext,'lastline_is_bottom',line);

   return(status);
}

#define FIELD_WIDTH 13

static void dbase_say_box(tlc,trc,blc,brc,hside,vside)
{
   _get_selinfo(first_col,last_col,buf_id);
   _begin_select();
   width=last_col-first_col-1;
   if( width<0 ) {
      width=0;
   }
   cursor_y=p_cursor_y;
   count=count_lines_in_selection();
   _begin_select();
   if( def_line_insert=='B' ) {
      up();
   }
   top_side=substr('',1,width,hside);
   insert_line(substr('@ 'first_col','cursor_y+1,1,FIELD_WIDTH)' SAY "':+
                      tlc:+top_side:+trc'"');
   for( i=1;i<=(count-2) ;++i ) {
      insert_line(substr('@ ROW()+1,'cursor_y+1,1,FIELD_WIDTH)' SAY "':+
                  vside:+substr('',1,width):+vside'"');
   }
   insert_line(substr('@ ROW()+1,'cursor_y+1,1,FIELD_WIDTH)' SAY "':+
                      blc:+top_side:+brc'"');
   _deselect();
}

static int _leftmost_col_in_selection()
{
   if( !select_active() ) {
      _message_box('No selection active');
      return(MAX_LINE);
   }
   save_pos(p);
   throw_out_last_line=0;
   if( _select_type()=='CHAR' ) {
      _get_selinfo(dummy,end_col,dummy);
      if( end_col==1 ) {
         // Throw out the last line of the character selection
         throw_out_last_line=1;
      }
   }
   status=_begin_select(arg(1));
   if( status ) return(MAX_LINE);
   leftmostcol=_first_non_blank_col(MAX_LINE);
   for( ;; ) {
      if( down() ||
          _end_select_compare(arg(1))>0 ||
          (throw_out_last_line && !_end_select_compare(arg(1))) ) {
         break;
      }
      col=_first_non_blank_col(MAX_LINE);
      if( col<leftmostcol ) {
         leftmostcol=col;
      }
   }
   restore_pos(p);
   return(leftmostcol);
}

static _str _maybe_create_user_ini_file()
{
   status=0;
   filenopath=BOX_USER_INI_FILENAME;
   filename=_config_path():+filenopath;
   global_filename=slick_path_search(filenopath);
   if( global_filename!="" && file_match("-p "maybe_quote_filename(filename),1)=="" &&
       !file_eq(global_filename,filename) ) {
      // Make copy of global configuration file.
      copy_file(global_filename,filename);
   } else if( file_match("-p "maybe_quote_filename(filename),1)=="" ) {
      // Doesn't exist so create it
      orig_view_id=_create_temp_view(temp_view_id);
      p_buf_name=_config_path():+filenopath;
      status=_save_file('+o');
      if( status ) {
         filename='';
      }
      activate_view(orig_view_id);
      _delete_temp_view(temp_view_id);
   }

   if( status ) {
      return('');
   }
   return(filename);
}

static int _init_ini_files()
{
   _box_ini_filename=slick_path_search(BOX_INI_FILENAME);
   _box_user_ini_filename=_maybe_create_user_ini_file();
   if( _box_user_ini_filename=='' ) {
      _message_box('Cannot find or create configuration file "':+BOX_USER_INI_FILENAME:+'"');
      return(1);
   }

   return(0);
}

