/*
$VerboseHistory: ccode.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:07:56a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 07:56a
 * Comment:
 * Enhanced color coding
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

#define COMMENT_MULTILINE  1
#define COMMENT_SINGLELINE 2
#define MAX_MLCOMMENTS 4

struct COMMENT_TYPE {
   //Applies to both
   int type;
   _str delim1
   _str cf_or_l;
   int startcol;

   //Multiline specific
   _str delim2;
   _str colorname;
   int lastchar;
   int nesting;
   _str idchars
   _str keywords;
   _str attributes:[];//3:02pm 1/6/1998 For html embedded languages

   //Line specific
   int endcol;
   int repeat;
   int precededbyblank;
};
struct CLEXDEF {
   boolean  case_sensitive;
   _str filename;//File where the lexer came from
   _str idchars;
   _str styles;
   _str keywords;
   _str cskeywords;
   _str ppkeywords;
   _str symbol1;
   _str symbol2;
   _str symbol3;
   _str symbol4;
   COMMENT_TYPE comments[];
};

defeventtab _cc_form
/*

   BE CAREFUL, THIS LIST MAYBE INCOMPLETE!!! BEFORE YOU USE A CONTROL'S P_USER
   PROPERTY, SEARCH THIS FILE TO BE SURE THAT IT HAS NOT ALREADY BEEN USED.

  p_active_form.p_user   says don't update list
  _ctlok.p_user          clex files list
  list1.p_user           view id with the changes that we need to make
  _ctlnew_name.p_user    HASTAB list of all lexers to save 3:27pm 4/2/1996
  _ctlkeywords.p_user    name of the last type chosen
  _ctllexer_list.p_user  name of the last lexer chosen
  _ctlstyles.p_user      name of file that the current lexer is in
  _ctlcolors.p_user      if 1, means that _ctlexer_list.on_change is running
                         (no logic to the choice of this one, I'm just running
                         out)

  Be sure to get new complete.e (I added a case insensitive option to
  _remove_duplicates).

  Also, get a new color.e, I think that I just modified the on_create event to
  take an argument.
*/

#define LLOnChangeRunning _ctlcolors.p_user


static CLEXDEF new_keyword_table:[];
//Had to make this typeless because I need an array in one case

_str _FindLexerFile(lexername)
{
   orig_view_id=p_view_id;
   status=_ini_get_section(_config_path():+USER_LEXER_FILENAME,lexername,temp_view_id);
   if (status) {
      filename=slick_path_search(SYSTEM_LEXER_FILENAME);
      status=_ini_get_section(filename,lexername,temp_view_id);
      if (status) {
         return('');
      }
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
      return(filename);
   }
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   return(_config_path():+USER_LEXER_FILENAME);
}

static int get_lexer_info(filenamelist,lexername,var lexer_view_id/*,var filename_used*/)
{
   orig_view_id=p_view_id;
   for (;;) {
      parse filenamelist with filename (PATHSEP) filenamelist;
      filename=slick_path_search(filename);
      if (filename=='') break;
      arg(4)=strip_filename(filename,'p');
      status=_ini_get_section(filename,lexername,lexer_view_id);
      if (status) continue else {
         p_view_id=orig_view_id;
         return(0);
      }
   }
   return(status);
}

_ctlok.on_create()
{
   lexer_name=arg(1);
   wid=_form_parent();
   if (lexer_name=="" && wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
      lexer_name=wid.p_lexer_name;
      //ctlBufName.p_enabled=0;
   } 
   //new_keyword_table=_notinit;
   //This cannot be here because the function is re-entrant
   _ctllexer_list.p_cb_list_box._lbclear();
   //_ctlok.p_user=filenamelist=def_clex_files;
   _ctlok.p_user=filenamelist=LEXER_FILE_LIST;
   wid=p_window_id;p_window_id=_ctllexer_list.p_cb_list_box;
   for (;;) {
      parse filenamelist with filename (PATHSEP) filenamelist;
      if (filename=='') break;
      afilename=slick_path_search(filename);
      //VSLICKCONFIG is not necessarily covered by slick_path_search, so I am
      //throwing this in to cover all the bases 11:56am 4/4/1996
      if (afilename!='') {
         _ini_list_sections(afilename);
      }
   }
   p_window_id=wid;
   if (new_keyword_table._varformat()!=VF_EMPTY) {
      for (i._makeempty();;) {
         ptr=&new_keyword_table._nextel(i);
         if (i._isempty()) break;
         status=_ctllexer_list.p_cb_list_box._lbsearch(i);
         if (status) {
            _ctllexer_list.p_cb_list_box._lbadd_item(i);
         }
      }
      _ctllexer_list.p_cb_list_box._lbtop();
   }
   wid=p_window_id;p_window_id=_control _ctllexer_list.p_cb_list_box;
   _lbsort('i');
   _remove_duplicates();
   _lbtop();
   _ctlkeywords.p_value=1;
   _ctlkeywords.p_user='keywords';
   _ctlnew_name.p_user=0;
   //_ctllexer_list.p_user=_ctllexer_list.p_text;
   p_active_form.p_user=0;
   _lbtop();
   status=1
   if (lexer_name!='' && lexer_name!='fundamental') {
      status=_lbsearch(lexer_name);
      if (!status) {
         p_parent.p_text=_lbget_text();
      }else {
         AddNewLexer(lexer_name);
      }
   }else{
      //If no lexer or fundamental, just show the first thing in the list
      p_parent.p_text=_lbget_text();
   }
   _lbselect_line();
   p_window_id=wid;
}

_ctlok.on_destroy()
{
   new_keyword_table._makeempty();
   //show('-mdi _var_editor_form','',&new_keyword_table);
}

static void AddLexerToModList()
{
   fid=p_active_form;
   if (p_active_form.p_name!='_cc_form') {
      //return;
      fid=_find_formobj('_cc_form','N');
      if (!fid) return;
   }
   _str temp:[];
   if (fid._ctlnew_name.p_user._varformat()==VF_HASHTAB) {
      temp=fid._ctlnew_name.p_user;
   }
   temp:[fid._ctllexer_list.p_user]=1;
   fid._ctlnew_name.p_user=temp;
   _nocheck _control _ctlstyles;
   fid._ctlstyles.p_user=USER_LEXER_FILENAME;//If the lexer is modified we now want it
                                     //written to the user file
}

_ctlcase_sensitive.lbutton_up()
{
   AddLexerToModList();
}

_ctlcase_sensitive.on_create()
{
#if 0
   new_keyword_table=_notinit;
   //can't put this on the other on create because it is re-entrant.
#endif

/*
   11:15am 4/9/1996
   This just caused me a LOT of grief.  I should not need this, because it
   new_keyword_table is set to _notinit on_destroy.  I am just leaving this here
   as a note so that I can get rid of this later when I am certain that it works
*/
}
_ctlcancel.lbutton_up()
{
#if 1  //Add this back in when done
   if (_ctlnew_name.p_user._varformat()==VF_HASHTAB) {//Has been changed to list
      temp=_ctlnew_name.p_user;
      result=_message_box(nls("Changes have been made.\n\nExit Anyway?"),
                          '',
                          MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result!=IDYES) return('');
   }
#endif
   p_active_form._delete_window(COMMAND_CANCELLED_RC);
}

static int active_keyword_rb()
{
   if (_ctlkeywords.p_value)    return(_ctlkeywords);
   if (_ctlcs_keywords.p_value) return(_ctlcs_keywords);
   if (_ctlpp_keywords.p_value) return(_ctlpp_keywords);
   if (_ctlsymbol1.p_value)     return(_ctlsymbol1);
   if (_ctlsymbol2.p_value)     return(_ctlsymbol2);
   if (_ctlsymbol3.p_value)     return(_ctlsymbol3);
   if (_ctlsymbol4.p_value)     return(_ctlsymbol4);
   return(-1);
}

_ctlfollow_idchars.on_change()
{
   if (p_active_form.p_visible && !LLOnChangeRunning) {
      AddLexerToModList();
   }
}

_ctlstart_idchars.on_change()
{
   if (p_active_form.p_visible && !LLOnChangeRunning) {
      AddLexerToModList();
   }
}

_ctllexer_list.on_change(reason)
{
   LLOnChangeRunning=1;
   if (!p_active_form.p_user) {
      active_keyword_rb().call_event(active_keyword_rb(),LBUTTON_UP);
      _ctllexer_list.p_user=_ctllexer_list.p_text;
   }
#if 0
   if (lowcase(_ctllexer_list.p_text)=='html') {
      _ctlcomment.p_caption='Tags...';
   }else{
      _ctlcomment.p_caption='Comments...';
   }
#endif
   orig_view_id=p_view_id;
   _ctlcase_sensitive.p_value=0;
   _ctlstart_idchars.p_text='';
   _ctlfollow_idchars.p_text='';
   //Reset all the values

   //We need to check and see if the lexer is loaded.  Any field should be ok
   if (new_keyword_table:[_ctllexer_list.p_text].case_sensitive._varformat()!=VF_EMPTY) {
      _ctlcase_sensitive.p_value=(int)new_keyword_table:[_ctllexer_list.p_text].case_sensitive;
      idchars=new_keyword_table:[_ctllexer_list.p_text].idchars;
      parse idchars with start follow;
      _ctlstart_idchars.p_text=start;
      _ctlfollow_idchars.p_text=follow;
   }else{
      orig_view_id=p_view_id;
      filename=_FindLexerFile(_ctllexer_list.p_text);
      status=_ini_get_section(filename,
                              _ctllexer_list.p_text,
                              lexer_view_id);
      if (!status) {
         p_view_id=lexer_view_id;
         top();up();
         status=search('^( |\t)@idchars','@ri');
         if (!status) {
            get_line(line);
            parse line with '=' val;
            p_view_id=orig_view_id
            parse val with start follow;
            _ctlstart_idchars.p_text=start;
            _ctlfollow_idchars.p_text=follow;
            //_ctlid_chars.p_text=val;
            p_view_id=lexer_view_id
         }
         top();up();
         status=search('^( |\t)@case-sensitive','@ri');
         if (!status) {
            get_line(line);
            parse line with '=' val;
            p_view_id=orig_view_id
            _ctlcase_sensitive.p_value=(int)(lowcase(val)=='y');
            p_view_id=lexer_view_id
         }
         _delete_temp_view(lexer_view_id);
      }else{
         if (status!=STRING_NOT_FOUND_RC) {
            _message_box(nls("Could not open lexer file '%s'\n\n%s",
                         filename,get_message(status)));
         }
      }
   }
   p_view_id=orig_view_id;
   _ctllexer_list.p_user=_ctllexer_list.p_text;
   //_ctlkeywords.call_event(_ctlkeywords,LBUTTON_UP);
   LLOnChangeRunning=0;
}

static void AddNewLexer(_str LexerName)
{
   wid=p_window_id;p_window_id=_ctllexer_list.p_cb_list_box;
   save_pos(p);
   _lbtop();_lbup();
   status=_lbsearch(LexerName,'i');
   //p_window_id=wid;
   if (!status) {
      _message_box(nls("A lexer definition named '%s' already exists.",LexerName));
      p_window_id=wid;
      _ctllexer_list.p_text=_ctllexer_list.p_cb_list_box._lbget_text();
      return;
   }
   restore_pos(p);
   new_keyword_table:[LexerName].idchars='a-zA-Z 0-9_';
   new_keyword_table:[LexerName].case_sensitive=0;
   wid=p_window_id;p_window_id=_ctllexer_list.p_cb_list_box;
   _lbadd_item(LexerName);
   _lbsort('i');
   _lbsearch(LexerName,'i');
   p_parent.p_text=_lbget_text();
   _ctlstart_idchars.p_text='a-zA-Z';
   _ctlfollow_idchars.p_text='0-9_';
   _ctlcase_sensitive.p_value=0;
   p_window_id=wid;
}

_ctlnew.lbutton_up()
{
   result=show('-modal _textbox_form',
               'Enter New Lexer Name',
               0, //Flags
               '',//Width
               '',//Help item
               '',//Button List
               '',//Retrieve Name
               'New Lexer Name:' //Prompt
             );
   if (result!='') {
      name=_param1;
      AddNewLexer(name);
   }
}

_ctldelete_name.lbutton_up()
{
   ff=1;
   p_window_id=_control list1;
   while (!_lbfind_selected(1)) {
      _lbdelete_item();
   }
   _lbselect_line();
   AddLexerToModList();
   wid=_find_control('ctlattributes');
   if (wid) {
      wid.p_enabled=list1.p_Noflines!=0;
   }
}
void _ctlget.lbutton_up()
{
   result=_OpenDialog('-modal '_stdform('_open_form'),
               'Get File',
               '*.*',
               'All Files (*.*)',
               OFN_FILEMUSTEXIST,  //OFN_FILEMUSTEXIST can create new file.
               '',
               '',
               '');
   if (result=='') return;
   filename=result;
   list1wid=list1;
   mou_hour_glass(1);
   status=_open_temp_view(result,temp_view_id,orig_view_id,'+d');
   if (status) {
      _message_box(nls("Could not open %s\n\n%s",filename,get_message(status)));
      return;
   }
   p_view_id=temp_view_id;
   top();up();
   while (!down()) {
      get_line(line);
      for (;;) {
         parse line with cur line;
         if (cur=='') break;
         list1wid._lbadd_item(cur);
      }
   }
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   wid=p_window_id;p_window_id=list1;
   #if 1   /* HERE - 11/6/1996 - by Rodney */
   _lbdeselect_all();
   AddLexerToModList();
   #endif
   _lbsort();
   _lbtop();
   _remove_duplicates();
   _lbtop();
   _lbselect_line();
   p_window_id=wid;
   mou_hour_glass(0);
}

static _str make_list(listwid)
{
   wid=p_window_id;p_window_id=listwid;
   list='';
   _lbtop();_lbup();
   while (!_lbdown()) {
      text=strip(_lbget_text());
      if (list=='') {
         list=text;
      }else{
         list=list' 'text;
      }
   }
   p_window_id=wid;
   return(list);
}

static void add_to_str(_str &str,_str newinfo)
{
   spacer=' ';
   if (arg(3)!='') spacer=arg(3);
   if (str=='') {
      str=newinfo;
   }else{
      str=str:+spacer:+newinfo;
   }
}

static _str * GetPointerToCurrentList()
{
   if (arg(1)=='') {
      LexerName=_ctllexer_list.p_text;
   }else{
      LexerName=arg(1);
   }
   if (_ctlkeywords.p_value) {
      return(&new_keyword_table:[LexerName].keywords);
   }else if (_ctlcs_keywords.p_value) {
      return(&new_keyword_table:[LexerName].cskeywords);
   }else if (_ctlpp_keywords.p_value) {
      return(&new_keyword_table:[LexerName].ppkeywords);
   }else if (_ctlsymbol1.p_value) {
      return(&new_keyword_table:[LexerName].symbol1);
   }else if (_ctlsymbol2.p_value) {
      return(&new_keyword_table:[LexerName].symbol2);
   }else if (_ctlsymbol3.p_value) {
      return(&new_keyword_table:[LexerName].symbol3);
   }else if (_ctlsymbol4.p_value) {
      return(&new_keyword_table:[LexerName].symbol4);
   }else{
      _message_box(nls("GetPointerToCurrentList:Should never get here. Call MicroEdge"));
      return(0);
   }
}
static _str * GetPointerToLastList()
{
   if (arg(1)=='') {
      LexerName=_ctllexer_list.p_user;
   }else{
      LexerName=arg(1);
   }
   if (lowcase(_ctlkeywords.p_user=='keywords')) {
      return(&new_keyword_table:[LexerName].keywords);
   }else if (_ctlkeywords.p_user=='cskeywords') {
      return(&new_keyword_table:[LexerName].cskeywords);
   }else if (_ctlkeywords.p_user=='ppkeywords') {
      return(&new_keyword_table:[LexerName].ppkeywords);
   }else if (_ctlkeywords.p_user=='symbol1') {
      return(&new_keyword_table:[LexerName].symbol1);
   }else if (_ctlkeywords.p_user=='symbol2') {
      return(&new_keyword_table:[LexerName].symbol2);
   }else if (_ctlkeywords.p_user=='symbol3') {
      return(&new_keyword_table:[LexerName].symbol3);
   }else if (_ctlkeywords.p_user=='symbol4') {
      return(&new_keyword_table:[LexerName].symbol4);
   }else{
      _message_box(nls("Should never get here. Call MicroEdge"));
      return(0);
   }
}

static _str ItemTable[]={"keywords","cskeywords","ppkeywords","symbol1","symbol2","symbol3","symbol4"};

static void LoadComments(COMMENT_TYPE (&comments)[])
{
   COMMENT_TYPE temp;
   top();up();
   count=0;

   comments._makeempty();

   last_mlc_subscript=-1;
   while (!search('^( |\t)@(linecomment|mlcomment)','@ri>')) {
      get_line(line);
      temp=process_comment(line);
      //new_keyword_table:[_ctlok.p_user].comments[count]=temp;
      if (temp.type==COMMENT_MULTILINE) {
         status=search('^( |\t)@(linecomment|mlcomment|mlckeywords|keywordattrs)','@ri>');
         mlckeywords='';
         _str MLCKeywordAttrs:[];
         if (!status) {
            get_line(line);
            line=strip(line);
            if (lowcase(substr(line,1,11))=='mlckeywords') {
               outerloop:
               for (;;) {
                  parse line with '=' line;
                  for (;;) {
                     parse line with cur line;
                     if (cur=='') break;
                     if (mlckeywords=='') {
                        mlckeywords=cur;
                     }else{
                        mlckeywords=mlckeywords' 'cur;
                     }
                  }
                  status=search('^( |\t)@(linecomment|mlcomment|mlckeywords|keywordattrs)','@ri>');
                  if (status) break;
                  get_line(line);
                  while (lowcase(substr(line,1,12))=='keywordattrs') {
                     get_line(line);
                     line=strip(line);
                     parse line with '=' keyword attrs;
                     MLCKeywordAttrs:[keyword]=strip(attrs);
                     status=search('^( |\t)@(linecomment|mlcomment|mlckeywords|keywordattrs)','@ri>');
                     if (status) break;
                     if (lowcase( substr(line,1,12) )!='keywordattrs') {
                        up();
                        break outerloop;
                     }
                  }
                  if (lowcase(substr(line,1,11))!='mlckeywords') {
                     //11:29pm 4/23/1997
                     //Added this so that rest of the file didn't get skipped
                     up();
                     break;
                  }
               }
            }else {
               up();_end_line();
            }
         }
         temp.keywords=mlckeywords;
         temp.attributes=MLCKeywordAttrs;
      }
      comments[count]=temp;
      ++count;
   }
}

static void LoadLexer(int lexer_view_id,CLEXDEF &Lexer,.../*,toinsert,wid*/)
{
   orig_view_id=p_view_id;
   p_view_id=lexer_view_id;
   toinsert=arg(3);
   wid=arg(4);
   for (i=0;i<ItemTable._length();++i) {
      word=ItemTable[i];
      top();up();
      str='';
      while (!search('^'word' @=','@ri>')) {
         get_line(line);
         _end_line();
         parse line with (word) '=' line;
         for (;;) {
            parse line with cur line;
            if (cur=='') break;
            if (word==toinsert) {
               wid.list1._lbadd_item(cur);
            }
            if (str=='') {
               str=cur;
            }else{
               str=str' 'cur;
            }
         }
      }
      switch (word) {
      case 'keywords':
         Lexer.keywords=str;break;
      case 'cskeywords':
         Lexer.cskeywords=str;break;
      case 'ppkeywords':
         Lexer.ppkeywords=str;break;
      case 'symbol1':
         Lexer.symbol1=str;break;
      case 'symbol2':
         Lexer.symbol2=str;break;
      case 'symbol3':
         Lexer.symbol3=str;break;
      case 'symbol4':
         Lexer.symbol4=str;break;
      }
      str='';
   }
   LoadComments(comments);
   Lexer.comments=comments;
   top();up();
   status=search('^styles @=','ri@');
   if (status) {
      Lexer.styles='';
   }else{
      get_line(line);
      parse line with '=' Lexer.styles;
   }
   p_view_id=orig_view_id;
}

//This is the event handler for all the radio buttons.  Loads the information
//If it is not in memory
_ctlkeywords.lbutton_up()
{
   orig_view_id=p_view_id;
   word=stranslate(p_caption,'','&');
   word=lowcase(stranslate(word,'',' '));
   if (!p_active_form.p_user) {
      new_keyword_table:[_ctllexer_list.p_user].idchars=_ctlstart_idchars.p_text' '_ctlfollow_idchars.p_text;
      new_keyword_table:[_ctllexer_list.p_user].case_sensitive=_ctlcase_sensitive.p_value!=0;
      new_keyword_table:[_ctllexer_list.p_user].filename=_ctlstyles.p_user;
      //Come back to this
      tempptr=GetPointerToLastList();
      *tempptr=make_list(list1);
      //new_keyword_table:[_ctllexer_list.p_user]:[_ctlkeywords.p_user]=make_list(list1);
      //new_keyword_table:[_ctllexer_list.p_user]:['styles']=get_styles();
   }
   list1._lbclear();
   tempptr=GetPointerToCurrentList();
   if (new_keyword_table:[_ctllexer_list.p_text]._varformat()==VF_EMPTY||
       tempptr->_varformat()==VF_EMPTY) {
      //The information for this lexer is not in memory
      filename_used='';
      filename=_FindLexerFile(_ctllexer_list.p_text);
      status=_ini_get_section(filename,_ctllexer_list.p_text,lexer_view_id);
       _ctlstyles.p_user=filename;
      if (!status) {
         LoadLexer(lexer_view_id,new_keyword_table:[_ctllexer_list.p_text],word,list1);
         _delete_temp_view(lexer_view_id);
         p_window_id=list1
         _lbsort();
         _remove_duplicates();
         _lbtop();
         _lbselect_line();
      }
   }else{
      //keyword_list=new_keyword_table:[_ctllexer_list.p_text]:[word];
      keyword_list=*tempptr;
      for (;;) {
         parse keyword_list with cur keyword_list;
         if (cur=='') break;
         list1._lbadd_item(cur);
      }
      list1._lbtop();
      list1._lbselect_line();
   }
   _ctlkeywords.p_user=word;
   _ctllexer_list.p_user=_ctllexer_list.p_text;
   _ctldelete_lexer.p_enabled=!file_eq(strip_filename(_ctlstyles.p_user,'P'),SYSTEM_LEXER_FILENAME);
}

static void ReplaceKeywordList(_str ListType,_str List)
{
   if (List._varformat()==VF_EMPTY) {
      return;
   }
   //First Delete all existing lines that start with ListType
   top();up();
   while (!search('^'_escape_re_chars(ListType),'wr@')) {
      _delete_line();up();
   }

   line=ListType'=';
   bottom();//Nothing can be in front of the lines that are for idchars, etc.
   for (;;) {
      parse List with cur List;
      if (cur=='') {
         if (line!=ListType'=') {
            insert_line(line);
         }
         break;
      }
      line=line' 'cur;
      if (length(line)>70) {
         insert_line(line);
         line=ListType'=';
      }
   }
}

static void ReplaceStylesLine(_str Styles)
{
   top();up();
   status=search('^styles( |\t)@=','ri@');
   if (!status) {
      _delete_line();
      up();
   }else{
      bottom();
   }
   if (Styles._varformat()==VF_EMPTY) {
   }else{
      insert_line('styles='Styles);
   }
}

int _ctlok.lbutton_up()
{
   fid=p_active_form;
   //I cannot figure out why these lines were here
   //_ctlcase_sensitive.p_value=lowcase(new_keyword_table:[_ctllexer_list.p_text].case_sensitive);
   //_ctlid_chars.p_text=new_keyword_table:[_ctllexer_list.p_text].idchars;
   if (!p_active_form.p_user) {
      new_keyword_table:[_ctllexer_list.p_user].idchars=_ctlstart_idchars.p_text' '_ctlfollow_idchars.p_text;
      new_keyword_table:[_ctllexer_list.p_user].case_sensitive=_ctlcase_sensitive.p_value!=0;
      new_keyword_table:[_ctllexer_list.p_user].filename=_ctlstyles.p_user;
      tempptr=GetPointerToLastList();
      *tempptr=make_list(list1);
      //new_keyword_table:[_ctllexer_list.p_user]:[_ctlkeywords.p_user]=make_list(list1);
   }
   mou_hour_glass(1);
   orig_view_id=p_view_id;
   lexer_view_id='';
   status=0;
   for (hashindex._makeempty();;) {
      if (lexer_view_id!='') {
         _delete_temp_view(lexer_view_id);
         lexer_view_id='';
      }
      ptr=&new_keyword_table._nextel(hashindex);
      if (hashindex._isempty()) {
         break;
      }
      lexername=hashindex;
      temp=_ctlnew_name.p_user;
      if (temp._varformat()!=VF_HASHTAB || !temp._indexin(lexername)) {
         continue;
      }
      //filename=_FindLexerFile(lexername);
      filename=slick_path_search(new_keyword_table:[lexername].filename);
      if (filename!='') {
         status=_ini_get_section(filename,lexername,lexer_view_id);
         if (status) {
            //Section does not currently exist in this file
            orig_view_id=_create_temp_view(lexer_view_id);
            if (orig_view_id) status=0;
            p_view_id=orig_view_id;
         }
      }else{
         orig_view_id=_create_temp_view(lexer_view_id);
         //Have to keep filename for new user file to be used later 11:10am 4/4/1996
         filename=_config_path():+USER_LEXER_FILENAME;
         if (orig_view_id) status=0;
         p_view_id=orig_view_id;
         //parse _ctlok.p_user with filename ';' .
         //I don't think that this applies anymore 11:41am 4/3/1996
      }
      message(nls("Working on color lexer file '%s'",filename));
      if (!status) {
         p_view_id=lexer_view_id;

         top();up();
         while (!search('^mlckeywords','r@i')) {
            _delete_line();up();
         }

         top();up();
         status=search('^( |\t)@idchars','ir@');
         if (!status) _delete_line();
         top();
         insert_line('idchars='new_keyword_table:[lexername].idchars);
         top();up()
         status=search('^( |\t)@case-sensitive','ir@');
         if (!status) _delete_line();
         top();
         if (new_keyword_table:[lexername].case_sensitive) {
            ch='y';
         }else{
            ch='n'
         }
         insert_line('case-sensitive='ch);
         ReplaceKeywordList("keywords",new_keyword_table:[lexername].keywords);
         ReplaceKeywordList("cskeywords",new_keyword_table:[lexername].cskeywords);
         ReplaceKeywordList("ppkeywords",new_keyword_table:[lexername].ppkeywords);
         ReplaceKeywordList("symbol1",new_keyword_table:[lexername].symbol1);
         ReplaceKeywordList("symbol2",new_keyword_table:[lexername].symbol2);
         ReplaceKeywordList("symbol3",new_keyword_table:[lexername].symbol3);
         ReplaceKeywordList("symbol4",new_keyword_table:[lexername].symbol4);
         ReplaceStylesLine(new_keyword_table:[lexername].styles);

         p_line=0;
         while (!search('^( |\t)@mlcomment( |\t)@=','r@')) {
            _delete_line();up();
         }
         p_line=0;
         while (!search('^( |\t)@linecomment( |\t)@=','r@')) {
            _delete_line();up();
         }
         p_line=0;
         while (!search('^( |\t)@mlckeywords( |\t)@=','r@')) {
            _delete_line();up();
         }
         p_line=0;
         while (!search('^( |\t)@keywordattrs( |\t)@=','r@')) {
            _delete_line();up();
         }
         bottom();//Don't want to put anything in front of id-chars and case-sensitive
         comments=new_keyword_table:[lexername].comments;
         for (i=0;i<comments._length();++i) {
            COMMENT_TYPE temp;
            temp=comments[i];
            switch (temp.type) {
            case COMMENT_MULTILINE:
               line='mlcomment='temp.delim1;
               if (!temp.startcol) {
                  line=line' 'temp.delim2;
                  if (temp.nesting) {
                     line=line' nesting';
                  }
                  if (temp.idchars!='') {
                     line=line' followedby 'temp.idchars;
                  }
                  if (temp.colorname!='') {
                     line=line' 'temp.colorname;
                  }
               }else{
                  line=line' 'temp.startcol;
                  if (temp.cf_or_l!='') {
                     line=line' 'temp.cf_or_l;
                  }
                  line=line' 'temp.delim2
                  if (temp.lastchar) {
                     line=line' lastchar';
                  }
               }
               insert_line(line);
               if (temp.keywords!='') {
                  bottom();
                  keyword_list=temp.keywords;
                  line='';
                  for (;;) {
                     if (line=='') {
                        line='mlckeywords=';
                     }
                     parse keyword_list with cur keyword_list;
                     if (cur=='') {
                        break;
                     }
                     line=line' 'cur;
                     if (length(line)>70) {
                        insert_line(line);
                        line='';
                     }
                  }
                  if (line!='') insert_line(line);
                  bottom();
                  if (temp.attributes._varformat()==VF_HASHTAB) {
                     for (hi._makeempty();;) {
                        temp.attributes._nextel(hi);
                        if (hi._isempty()) break;
                        if (temp.attributes:[hi]!='') {
                           insert_line('keywordattrs='hi' 'temp.attributes:[hi]);
                        }
                     }
                  }
               }
               break;
            case COMMENT_SINGLELINE:
               delim=temp.delim1;
               if (CCNeedQuotes(delim)) {
                  delim=CCEscapeChars(delim);
               }
               line='linecomment='delim;
               if (temp.startcol) {
                  line=line' 'temp.startcol;
                  if (temp.repeat) {
                     //Will put in redundant info if we aren't careful
                     if (temp.cf_or_l!='+') {
                        line=line'+';
                     }
                  }else if (temp.endcol) {
                     line=line'-'temp.endcol;
                  }
               }
               if (temp.precededbyblank) {
                  line=line' precededbyblank';
               }
               if (temp.cf_or_l!='') {
                  if (temp.cf_or_l=='+') {
                     sep='';
                  }else{
                     sep=' ';
                  }
                  line=line:+sep:+temp.cf_or_l;
               }
               insert_line(line);
               break;
            }
         }
         //break;
      }
      p_view_id=orig_view_id;
      message(nls("Writing color lexer file '%s'",filename));
      status=_ini_put_section(filename,lexername,lexer_view_id);
      if (status) {
         _message_box(nls("Could not write to color lexer file %s.\n\n%s",filename,get_message(status)));
      }
      p_view_id=orig_view_id;//Paranoia
      lexer_view_id='';//I don't know what this does
   }
   if (lexer_view_id!='') {
      _delete_temp_view(lexer_view_id);
      lexer_view_id='';
   }
   p_view_id=orig_view_id;//Paranoia
   delete_lexers(_ctldelete_lexer.p_user);
   filenamelist=_ctlok.p_user
   for (;;) {
      parse filenamelist with cur (PATHSEP) filenamelist;
      if (cur=='') break;
      filename=slick_path_search(cur);
      if (filename=='') continue;
      message(nls("Reloading color lexer file '%s'",filename));
      status=cload(filename);
      if (status) {
         _message_box(nls("Could not cload file '%s'\n\n%s",cur,get_message(status)));
      }
   }
   clear_message();
   mou_hour_glass(0);

   p_active_form._delete_window(0);
   return(0);
}

_ctlnew_name.lbutton_up()
{
   name=show('-modal _textbox_form',
             'Enter New Keywords',
             0, //Flags
             '',//Width
             '',//Help item
             '',//button list
             '',//retrieve name
             'New Keywords:' //prompt
             );
   if (name!='') {
      wid=p_window_id;p_window_id=_control list1;
      _lbdeselect_all();
      AddLexerToModList();
      name=_param1;
      parse name with first_word .;
      for (;;) {
         parse name with word name;
         if (word=='') break;
         ch=_ctlcase_sensitive.p_value?'e':'';
         if (!_lbsearch(word,ch)) {
            _message_box(nls("%s already exists in the list",word));
         }else{
            _lbadd_item(word);
         }
      }
      _lbsort();
      _lbtop();
      _lbsearch(first_word);
      _lbselect_line();
      p_window_id=wid;
   }
}

//Deletes the section and the header too
static int myini_delete_section(filename,section_name)
{
   if (!pos('\+b( |\t)',filename,1,'ir')) {
      status=_open_temp_view(filename,ini_view_id,view_id,'+d')
   }else{
      status=_open_temp_view(filename,ini_view_id,view_id)
   }
   if (status) return(status);
   get_view_id orig_view_id
   activate_view ini_view_id
   top();up();
   status=_ini_delete_section2(section_name);
   if (!status) {
      top();up();
      status=search('^\['section_name'\]','@ri');
      if (!status) {
         _delete_line();
      }
      _save_file('+o');
   }
   activate_view orig_view_id
   _delete_temp_view(ini_view_id);
   activate_view view_id;
   return(status);
}

static delete_lexers(_str list)
{
   for (;;) {
      parse list with cur list;
      if (cur=='') break;
      filename=_FindLexerFile(cur);
      if (filename!='') myini_delete_section(filename,cur);
   }
}

void _ctldelete_lexer.lbutton_up()
{
   lexername=_ctllexer_list.p_text;
   if (lexername!='') {
      result=_message_box(nls("Are you sure that you wish to delete the lexer '%s'",lexername),'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result!=IDYES) return;
      _ctllexer_list.p_cb_list_box._lbdelete_item();
      _ctllexer_list.p_text=_ctllexer_list.p_cb_list_box._lbget_text();
      if (_ctldelete_lexer.p_user=='') {
         _ctldelete_lexer.p_user=lexername;
      }else{
         _ctldelete_lexer.p_user=_ctldelete_lexer.p_user' 'lexername;
      }
   }
}

_ctlstyles.lbutton_up()
{
   status=show('-modal _cc_styles_form',_ctllexer_list.p_text);
   if (status && status!='') {
      AddLexerToModList();  // Need to save color coding info
   }
}

_ctlcomment.lbutton_up()
{
    result=show('-modal _cc_comment_form',_ctllexer_list.p_text);
    if (result&&result!='') {
       AddLexerToModList();  // Need to save color coding info
    }
}

_ctlcolors.lbutton_up()
{
   word=stranslate(active_keyword_rb().p_caption,'','&');
   word=lowcase(stranslate(word,'',' '));
   switch (word) {
   case 'keywords':
   case 'cskeywords':
      word='keyword';break;
   case 'ppkeywords':
      word='preprocess';break;
   }
   show('-modal _color_form',word);
}

defeventtab _cc_styles_form

static void ShutOffControls(_str ControlList)
{
   for (;;) {
      parse ControlList with wid ControlList;
      if (wid=='') break;
      if (p_window_id!=wid) wid.p_value=0;
   }
}

_ctldqbsml.lbutton_up()
{
   if (p_value) {
      sqlist=(_control _ctlsqmultiline)' '(_control _ctlsqbsml)' '(_control _ctlsqterminate);
      dqlist=(_control _ctldqmultiline)' '(_control _ctldqbsml)' '(_control _ctldqterminate);
      if (pos('_ctldq',p_name)==1) {
         ShutOffControls(dqlist)
      }else if (pos('_ctlsq',p_name)==1) {
         ShutOffControls(sqlist)
      }
   }
}

_ctlok.on_create()
{
   orig_view_id=p_view_id;
   lexername=arg(1);
   p_active_form.p_caption='Styles for 'lexername;
   filenamelist=p_active_form.p_parent._ctlok.p_user;
   _ctlok.p_user=filenamelist;
   p_active_form.p_user=lexername;
   if (new_keyword_table:[lexername].styles._varformat()!=VF_EMPTY) {
      line=new_keyword_table:[lexername].styles;
      for (;;) {
         parse line with cur line;
         if (cur=='') break;
         cur=lowcase(cur);
         if (cur=='hexh') {
            _ctlhex_intelasm.p_value=1;
         }else if (cur=='xhex') {
            _ctlhex_c.p_value=1;
         }else if (cur=='amphhex') {
            _ctlhex_basic.p_value=1;
         }else if (cur=='dollarhex') {
            _ctlhex_motorollaasm.p_value=1;
         }

         if (cur=='dqdoubles') {
            _ctldqd.p_value=1;
         }else if (cur=='dqbackslash') {
            _ctldqbs.p_value=1;
         }else if (cur=='dqlen1') {
            _ctldqchar.p_value=1;
         }else if (cur=='dqbackslashml') {
            _ctldqbsml.p_value=1;
         }else if (cur=='dqmultiline') {
            _ctldqmultiline.p_value=1;
         }else if (cur=='dqterminate') {
            _ctldqterminate.p_value=1;
         }
         if (cur=='sqdoubles') {
            _ctlsqd.p_value=1;
         }else if (cur=='sqbackslash') {
            _ctlsqbs.p_value=1;
         }else if (cur=='sqlen1') {
            _ctlsqchar.p_value=1;
         }else if (cur=='sqbackslashml') {
            _ctlsqbsml.p_value=1;
         }else if (cur=='sqmultiline') {
            _ctlsqmultiline.p_value=1;
         }else if (cur=='sqterminate') {
            _ctlsqterminate.p_value=1;
         }
         if (cur=='octo') {
            _ctloct_intelasm_o.p_value=1;
         }else if (cur=='octq') {
            _ctloct_intelasm_q.p_value=1;
         }else if (cur=='ampooct') {
            _ctloct_basic.p_value=1;
         }
         if (cur=='linenum') {
            _ctllinenums.p_value=1;
         }
         if (cur=='poundbase') {
            _ctlpound_base.p_value=1;
         }
         if (cur=='underlineint') {
            _ctlint_underscores.p_value=1;
         }
         if (cur=='nonumbers') {
            _ctlno_numbers.p_value=1;
         }

         //2:06pm 6/5/1997
         //Adding support for the new keywords that Clark added
         //packageimport idparenfunction
         if (cur=='idparenfunction') {
            ctlidparenfunction.p_value=1;
         }
         if (cur=='packageimport') {
            ctlpackageimport.p_value=1;
         }
         
         if (cur=='html') {
            ctlhtml.p_value=1;
         }

         if (cur=='backslashescapechars') {
            ctlbs_escape_chars.p_value=1;
         }
         if (cur=='heredocument') {
            ctlhere_document.p_value=1;
         }
         if (cur=='perl') {
            ctlperl.p_value=1;
         }
      }
   }else{
      //Taking out this message because there is no styles information if the user
      //is starting a new lexer
      //_message_box(nls("No styles information loaded."));
   }
   //p_view_id=orig_view_id;
   //_ctlok.p_user=get_state();
   _ctldqbsml.call_event(_ctldqbsml,LBUTTON_UP);
   _ctldqmultiline.call_event(_ctldqmultiline,LBUTTON_UP);
   _ctlsqbsml.call_event(_ctlsqbsml,LBUTTON_UP);
   _ctlsqmultiline.call_event(_ctlsqmultiline,LBUTTON_UP);
}

static _str get_state()
{
   state=_ctlhex_c.p_value:+_ctlhex_intelasm.p_value:+_ctlhex_motorollaasm.p_value:+_ctlhex_basic.p_value:+\
         _ctloct_intelasm_o.p_value:+_ctloct_intelasm_q.p_value:+_ctloct_basic.p_value:+\
         _ctldqd.p_value:+_ctldqbs.p_value:+_ctldqchar.p_value:+_ctldqbsml.p_value:+\
         _ctlsqd.p_value:+_ctlsqbs.p_value:+_ctlsqchar.p_value:+_ctlsqbsml.p_value:+\
         _ctllinenums.p_value:+_ctlno_numbers.p_value:+_ctlint_underscores.p_value:+_ctlpound_base.p_value;
   return(state);
}

_ctldqd.lbutton_up()
{
   dqnames=' _ctldqd _ctldqbs _ctldqchar ';
   sqnames=' _ctlsqd _ctlsqbs _ctlsqchar ';
   if (pos(' 'p_name' ',dqnames)) {
      if (p_name=='_ctldqd') {
         _ctldqbs.p_value=_ctldqchar.p_value=0;
      }else if (p_name=='_ctldqbs') {
         _ctldqd.p_value=_ctldqchar.p_value=0;
      }else if (p_name=='_ctldqchar') {
         _ctldqd.p_value=_ctldqbs.p_value=0;
      }
   }else if (pos(' 'p_name' ',sqnames)) {
      if (p_name=='_ctlsqd') {
         _ctlsqbs.p_value=_ctlsqchar.p_value=0;
      }else if (p_name=='_ctlsqbs') {
         _ctlsqd.p_value=_ctlsqchar.p_value=0;
      }else if (p_name=='_ctlsqchar') {
         _ctlsqd.p_value=_ctlsqbs.p_value=0;
      }
   }
}

static _str get_styles()
{
   str='';
   if (_ctllinenums.p_value && _ctllinenums.p_enabled) {
      add_to_str(str,'linenum');
   }
   if (_ctlpound_base.p_value && _ctlpound_base.p_enabled) {
      add_to_str(str,'poundbase');
   }
   if (_ctlint_underscores.p_value && _ctlint_underscores.p_enabled) {
      add_to_str(str,'underlineint');
   }
   if (_ctlhex_c.p_value && _ctlhex_c.p_enabled) {
      add_to_str(str,'xhex');
   }
   if (_ctlhex_intelasm.p_value && _ctlhex_intelasm.p_enabled) {
      add_to_str(str,'hexh');
   }
   if (_ctlhex_motorollaasm.p_value && _ctlhex_motorollaasm.p_enabled) {
      add_to_str(str,'dollarhex');
   }
   if (_ctlhex_basic.p_value && _ctlhex_basic.p_enabled) {
      add_to_str(str,'amphhex');
   }
   if (_ctloct_intelasm_o.p_value && _ctloct_intelasm_o.p_enabled) {
      add_to_str(str,'octo');
   }
   if (_ctloct_intelasm_q.p_value && _ctloct_intelasm_q.p_enabled) {
      add_to_str(str,'octq');
   }
   if (_ctloct_basic.p_value && _ctloct_basic.p_enabled) {
      add_to_str(str,'ampooct');
   }
   if (_ctldqd.p_value && _ctldqd.p_enabled) {
      add_to_str(str,'dqdoubles');
   }
   if (_ctldqbs.p_value && _ctldqbs.p_enabled) {
      add_to_str(str,'dqbackslash');
   }
   if (_ctldqchar.p_value && _ctldqchar.p_enabled) {
      add_to_str(str,'dqlen1');
   }
   if (_ctlno_numbers.p_value && _ctlno_numbers.p_enabled) {
      add_to_str(str,'nonumbers');
   }
   if (_ctldqbsml.p_value && _ctldqbsml.p_enabled) {
      add_to_str(str,'dqbackslashml');
   }
   if (_ctldqmultiline.p_value && _ctldqmultiline.p_enabled) {
      add_to_str(str,'dqmultiline');
   }
   if (_ctldqterminate.p_value && _ctldqterminate.p_enabled) {
      add_to_str(str,'dqterminate');
   }
   if (_ctlsqd.p_value && _ctlsqd.p_enabled) {
      add_to_str(str,'sqdoubles');
   }
   if (_ctlsqbs.p_value && _ctlsqbs.p_enabled) {
      add_to_str(str,'sqbackslash');
   }
   if (_ctlsqchar.p_value && _ctlsqchar.p_enabled) {
      add_to_str(str,'sqlen1');
   }
   if (_ctlsqbsml.p_value && _ctlsqbsml.p_enabled) {
      add_to_str(str,'sqbackslashml');
   }
   if (_ctlsqmultiline.p_value && _ctlsqmultiline.p_enabled) {
      add_to_str(str,'sqmultiline');
   }
   if (_ctlsqterminate.p_value && _ctlsqterminate.p_enabled) {
      add_to_str(str,'sqterminate');
   }
   if (ctlidparenfunction.p_value && ctlidparenfunction.p_enabled) {
      add_to_str(str,'idparenfunction');
   }
   if (ctlpackageimport.p_value && ctlpackageimport.p_enabled) {
      add_to_str(str,'packageimport');
   }
   if (ctlhtml.p_value && ctlhtml.p_enabled) {
      add_to_str(str,'html');
   }
   if (ctlbs_escape_chars.p_value) {
      add_to_str(str,'backslashescapechars');
   }
   if (ctlhere_document.p_value) {
      add_to_str(str,'heredocument');
   }
   if (ctlperl.p_value) {
      add_to_str(str,'perl');
   }
   return(str);
}

_ctlok.lbutton_up()
{
   new_keyword_table:[p_active_form.p_user].styles=get_styles();
   //returning 1 means that we need to save this lexer
   p_active_form._delete_window(/*get_state()!=_ctlok.p_user*/1);
}

static int ArrayComp(one,two)
{
   if (one._length()!=two._length()) {
      return(0);
   }
   for (i=0;i<one._length();++i) {
      if (one[i]!=two[i]) {
         return(0);
      }
   }
   return(1);
}

static boolean ArrayCompare(typeless one,typeless two)
{
   notequal=(one._length()!=two._length());
   if (notequal) return(notequal);
   for (i=0;i<one._length();++i) {
      if (one[i]!=two[i]) {
         return(true);
      }
   }
   return(false);
}

defeventtab _cc_comment_form
_ctlcancel.lbutton_up()
{
   temp1=_ctlcancel.p_user;
   temp2=_ctledit.p_user;
   notequal=(temp1._length()!=temp2._length());
   extent=min(temp1._length(),temp2._length())
   if (!notequal) {
      for (i=0;i<extent;++i) {
         notequal=ArrayCompare(temp1[i],temp2[i]);
         if (notequal) break;
      }
   }
   if (notequal) {
      result=_message_box(nls("Changes have been made.\n\nExit Anyway?"),
                          '',
                          MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result!=IDYES) return('');
   }
   p_active_form._delete_window(0);
}

static _str GetCommentType(COMMENT_TYPE comment)
{
   if (comment.type==COMMENT_MULTILINE) {
      return('MultiLine');
   }
   if (comment.type==COMMENT_SINGLELINE) {
      return('LineComment');
   }
   return('');
}

_ctlok.on_create()
{
   linenum='';
   COMMENT_TYPE temparray[],temp;

   temparray._makeempty();

   if (_ctlok.p_user=='') {
      _ctlok.p_user=arg(1);//Lexer name
      p_active_form.p_caption='Comments for '_ctlok.p_user;
   }else{
      linenum=list1.p_line;
      list1._lbclear();
   }
   if (new_keyword_table:[_ctlok.p_user].comments._varformat()==VF_EMPTY) {
      filename=_FindLexerFile(_ctlok.p_user);
      if (filename!='') {
         orig_view_id=p_view_id;
         status=_ini_get_section(filename,_ctlok.p_user,lexer_view_id);
         if (status) {
            _message_box(nls("Could not open lexer file '%s'\n\n%s",filename,get_message(status)));
         }else{
            p_view_id=lexer_view_id;
            top();up();
            count=0;
            last_mlc_subscript=-1;
            while (!search('^( |\t)@(linecomment|mlcomment)','@ri>')) {
               get_line(line);
               temp=process_comment(line);
               //new_keyword_table:[_ctlok.p_user].comments[count]=temp;
               p_view_id=lexer_view_id;
               if (temp.type==COMMENT_MULTILINE) {
                  status=search('^( |\t)@(linecomment|mlcomment|mlckeywords)','@ri>');
                  mlckeywords='';
                  if (!status) {
                     get_line(line);
                     line=strip(line);
                     if (lowcase(substr(line,1,11))=='mlckeywords') {
                        for (;;) {
                           parse line with '=' line;
                           for (;;) {
                              parse line with cur line;
                              if (cur=='') break;
                              if (mlckeywords=='') {
                                 mlckeywords=cur;
                              }else{
                                 mlckeywords=mlckeywords' 'cur;
                              }
                           }
                           status=search('^( |\t)@(linecomment|mlcomment|mlckeywords)','@ri>');
                           if (status) break;
                           get_line(line);
                           if (lowcase(substr(line,1,11))!='mlckeywords') break;
                        }
                     }else{
                        up();_end_line();
                     }
                  }
                  temp.keywords=mlckeywords;
               }
               p_view_id=orig_view_id;
               new_keyword_table:[_ctlok.p_user].comments[count]=temp;
               p_view_id=lexer_view_id;
               ++count;
            }
         }
         p_view_id=orig_view_id;
         _delete_temp_view(lexer_view_id);
      }
   }else{
      temparray=new_keyword_table:[_ctlok.p_user].comments;
   }
   if (_ctledit.p_user._varformat()==VF_ARRAY) {
      temparray=_ctledit.p_user;
   }else{
      temparray=new_keyword_table:[_ctlok.p_user].comments;
      _ctledit.p_user=new_keyword_table:[_ctlok.p_user].comments;
   }
   for (i=0;i<temparray._length();++i) {
      if (temparray[i].delim1==''&&temparray[i].delim2=='') {
         list1._lbadd_item(GetCommentType(temparray[i])"\t"temparray[i].startcol"\t");
      }else{
         list1._lbadd_item(GetCommentType(temparray[i])"\t":+temparray[i].delim1:+"\t"temparray[i].delim2);
      }
   }
   wid=p_window_id;p_window_id=list1;
   _col_width(0,1200);
   _col_width(1,500);
   _col_width(2,500);
   _lbtop();
   if (linenum!='') {
      p_line=linenum;
   }
   _lbselect_line();
   p_window_id=wid;
   if (_ctlcancel.p_user._varformat()!=VF_ARRAY) {
      _ctlcancel.p_user=temparray;
   }
}


static void FindEndOfComment(_str buffer,int &start)
{
   i=start;
   for (;i<=length(buffer);++i) {
      ch=substr(buffer,i,1);
      if (ch=='\') {
         ++i;
         continue;
      }
      if (ch=='"') {
         start=i;
         return;
      }
   }
}

static _str CCProcessEscapeChars(_str string)
{
   temp=string;
   temp=stranslate(temp,'\','\\');
   temp=stranslate(temp,'"','\"');
   return(temp);
}

static boolean CCNeedQuotes(_str string)
{
   return(pos(' ',string) || substr(string,1,1)=='"');
}
static _str CCEscapeChars(_str string)
{
   temp=string;
   temp=stranslate(temp,'\\','\');
   temp=stranslate(temp,'\"','"');
   return('"'temp'"');
}

static _str MaybeStrip2Quotes(_str string)
{
   if (substr(string,1,1)!='"') return(string);
   string=substr(string,2);
   if (length(string)==1) {
      if (string=='"') return('');
      return(string);
   }
   string=substr(string,1,length(string)-1);
   return(string);
}

static COMMENT_TYPE process_comment(_str commentline)
{
   COMMENT_TYPE comment;
   init_comment(comment);

   parse commentline with field '=' info
   field=lowcase(strip(field));
   info=strip(info);
   buffer=info;
   start=1;
   switch (field) {
   case 'mlcomment':
      line="MultiLine\t";
      comment.type=COMMENT_MULTILINE;
      comment.delim1=next_token(buffer,start,start,field);
      tok=next_token(buffer,start,start,field);
      if (isinteger(tok)) {
            //start_symbol start_col [checfirst|leading] endsymbol [lastchar]
         comment.startcol=tok;//col3=tok;
         if (start>=0) {//has to be
            tok=next_token(buffer,start,start,field);
            switch (lowcase(tok)) {
            case 'checkfirst':
            case 'leading':
               //col4=tok;
               comment.cf_or_l=tok;
               break;
            default:
               //delim2=tok;
               comment.delim2=tok;
               break;
            }
         }
         if (start>=0) {
            tok=next_token(buffer,start,start,field);
            //if (delim2=='') delim2=tok;
            if (comment.delim2=='') comment.delim2=tok;
         }
         if (start>=0) {
            tok=next_token(buffer,start,start,field);
            //col5=tok;
            if (lowcase(tok)=='lastchar') {
               comment.lastchar=1;
            }
         }
         //comment.nesting=0;comment.startcol=0;comment.colorname='';comment.idchars='';
      }else{//start_symbol end_symbol [nesting] [followed_by idchars] [colorname]
         comment.delim2=tok;//delim2=tok;
         if (start>=0) {
            tok=next_token(buffer,start,start,field);
            switch (lowcase(tok)) {
            case 'followedby':
               comment.nesting=0;//col3='';
               //This has just got to be right
               //col4=tok;//get followedby//col4=col4' 'next_token(buffer,start,start);//get idchars
               comment.idchars=tok;
               comment.idchars=next_token(buffer,start,start,field);//get idchars
               break;
            case 'nesting':
               comment.nesting=1;//col3=tok;break;
            default:
               comment.colorname=tok;
            }
            if (start>=0) {
               for (;;) {
                  tok=next_token(buffer,start,start,field);
                  switch (tok) {
                  case 'followedby':
                     comment.nesting=0;//col3='';
                     //This has just got to be right
                     comment.idchars=tok;
                     comment.idchars=next_token(buffer,start,start,field);//get idchars
                     break;
                  default:
                     //must be the color name
                     comment.colorname=tok;//col5=tok;
                  }
                  if (start<0) break;
               }
            }
         }
      }
      return(comment);
   case 'linecomment':
      comment.type=COMMENT_SINGLELINE;
      line="LineComment\t";
      tok=next_token(buffer,start,next,field);
      start=next;
      if (isinteger(tok)) {
         comment.startcol=tok;//scol=tok;
         tok=next_token(buffer,start,start,field);
         switch (tok) {
         case '+':
            comment.repeat=1;//range='+'
            break;
         case '-':
            //range='-';
            tok=next_token(buffer,start,start,field);
            comment.endcol=tok;//ecol=tok;
            break;
         }
         if (start>=0) {
            comment.cf_or_l=next_token(buffer,start,start,field);
         }
         return(comment);
         //line=line"\t"delim"\t"scol"\t"range"\t"ecol"\t"cf_or_l;
      }else{
         comment.delim1=tok;
         comment.delim1=MaybeStrip2Quotes(comment.delim1);
         comment.delim1=CCProcessEscapeChars(comment.delim1);
         if (start>=0) {
            tok=next_token(buffer,start,start,field);
            if (isinteger(tok)) {
               comment.startcol=tok;//scol=tok;
               if (start>=0) {
                  oldstart=start;
                  tok=next_token(buffer,start,start,field);
                  switch (tok) {
                  case '+':
                     comment.repeat=1;//range='+'
                     break;
                  case '-':
                     //range='-';
                     tok=next_token(buffer,start,start,field);
                     comment.endcol=tok;
                     tok=next_token(buffer,start,start,field);
                     if (tok) {
                        if (tok=='checkfirst') {
                           comment.cf_or_l=tok;
                        }
                     }
                     break;
                  }
                  if (oldstart>=0) {
                     //comment.cf_or_l=next_token(buffer,start,start);
                     comment.cf_or_l=tok;
                  }
               }
            }else{
               if (tok=='precededbyblank') {
                  comment.precededbyblank=1;
               }else if (lowcase(tok)=='checkfirst' ||
                         lowcase(tok)=='leading') {
                  comment.cf_or_l=tok;
               }
            }
         }
         return(comment);
      }
      break;
   default:
      _message_box('Internal error processing color coding entry.  Call MicroEdge');
      stop
      return(comment);
   }
}

static _str next_token(_str &buffer,int start,int &next,_str type)
{
   temp='';
   if (buffer=='') {
      next=-1;
      return("");
   }
   if (start>length(buffer)) {
      next=-1;
      return('');
   }
   buffer=strip(substr(buffer,start));
   if (start==1) {
      //return everything up to first space, unless it starts with a nubmer
      if (isinteger(substr(buffer,1,1))) {
         for (i=1;i<=length(buffer);++i) {
            ch=substr(buffer,i,1);
            if (isinteger(ch)) {
               temp=temp:+ch;
               if ( (type=='linecomment' && (temp=='+'||temp=='-')) 
                    ||temp=='='||temp=='>'||temp=='<!') {
                  next=i+1;
                  return(temp);
               }
            }else{
               break;
            }
         }
         //next=pos('~[ |\t]',buffer,i,'r');
         next=i;
         return(temp);
      }else{
         if (substr(buffer,start,1)=='"') {
            i=start+1;
            FindEndOfComment(buffer,i);
            temp=substr(buffer,start,start+i-1);
            start=i;
            return(temp);
         }else{
            p=pos(' |\t|$',buffer,start,'r');
            if (p>1) {
               temp=substr(buffer,1,p-1);
            }
            if ( (pos('$',buffer,p,'r')<pos(' |\t',buffer,p,'r')) ||
                 !pos(' |\t',buffer,p,'r')) {
               next=-1;
            }else{
               next=pos('~[ |\t|$]',buffer,p+1,'r');
            }
            //next=p+1;
            return(temp);
         }
      }
   }
   startint=isinteger(substr(buffer,1,1));
   if (!startint) {
      for (i=1;i<=length(buffer);++i) {
         ch=substr(buffer,i,1);
         p=pos(' |\t',ch,1,'r');
         if (!p) {
            temp=temp:+ch;
            if ( (type=='linecomment' && (temp=='+'||temp=='-') ) 
                 ||temp=='='||temp=='>'||temp=='<!') {
               next=i+1;
               return(temp);
            }
         }else{
            next=i;
            return(temp);
         }
      }
   }else{
      for (i=1;i<=length(buffer);++i) {
         ch=substr(buffer,i,1);
         if (isinteger(ch)) {
            temp=temp:+ch;
         }else{break;}
      }
      if (i>length(buffer)) {
         next=-1;
      }else{
         next=i;
      }
      return(temp);
   }
   if (i>length(buffer)) {
      next=-1;//culprit
   }else{
      next=i+1;
   }
   return(temp);
}


list1.lbutton_double_click()
{
   _ctledit.call_event(_ctledit,LBUTTON_UP);
}

void _ctledit.lbutton_up()
{
   wid=_get_focus();
   line=list1._lbget_text();
   if (line=='') return;
   parse line with type.;
   switch (type) {
   case 'LineComment':
      temp=_ctledit.p_user;
      result=show('-modal _cc_comment_l_form',
                  &temp[list1.p_line-1],
                  _ctlok.p_user,
                  list1.p_line-1);
      _ctledit.p_user=temp;
      _ctlok.call_event(_ctlok,ON_CREATE);
      break;
   case 'MultiLine':
      temp=_ctledit.p_user;
      result=show('-modal _cc_comment_ml_form',
                  &(temp[list1.p_line-1]),
                  _ctlok.p_user,
                  list1.p_line-1);
      _ctledit.p_user=temp;
      _ctlok.call_event(_ctlok,ON_CREATE);
      break;
   }
   list1.p_user=!result;
}

static int number_ml_comments()
{
   wid=p_window_id;p_window_id=_control list1;
   count=0;
   save_pos(p);
   top();up();
   while (!down()) {
      get_line(line);
      parse substr(line,2) with type "\t" .;
      if (type=='MultiLine') ++count;
   }
   restore_pos(p);
   p_window_id=wid;
   return(count);
}

void _ctlnew.lbutton_up()
{
   COMMENT_TYPE temp;

   init_comment(temp);
   type=show('-modal _cc_comment_type_form',number_ml_comments());
   if (type=='') return;
   switch (type) {
   case COMMENT_MULTILINE:
      result=show('-modal _cc_comment_ml_form',
                  &temp,
                  _ctlok.p_user,
                  list1.p_Noflines-1);
      if (!result) {
         temp2=_ctledit.p_user;//Get the comment array
         temp2[list1.p_Noflines]=temp;//Insert this element
         _ctledit.p_user=temp2;//Replace the array
         _ctlok.call_event(_ctlok,ON_CREATE);//Refresh the list
      }
      break;
   case COMMENT_SINGLELINE:
      result=show('-modal _cc_comment_l_form',
                  &temp,
                  _ctlok.p_user,
                  list1.p_Noflines-1);
      if (!result) {
         temp2=_ctledit.p_user;//Get the comment array
         temp2[list1.p_Noflines]=temp;//Insert this element
         _ctledit.p_user=temp2;//Replace the array
         _ctlok.call_event(_ctlok,ON_CREATE);//Refresh the list
      }
      break;
   }
   list1.p_user=!result;
}

_ctlok.lbutton_up()
{
   new_keyword_table:[_ctlok.p_user].comments=_ctledit.p_user;
   p_active_form._delete_window(1);//1 Means that the lexer was modified
}

_ctldelete.lbutton_up()
{
   temp=_ctledit.p_user;
   temp._deleteel(list1.p_line-1,1);
   _ctledit.p_user=temp;
   list1._lbdelete_item();
   list1._lbselect_line();
}

defeventtab _cc_comment_l_form
_ctldelim_text.on_change()
{
   val=(length(_ctldelim_text.p_text)==1 && isinteger(_ctlstartcol.p_text))
   _ctlcheckfirst.p_enabled=val;
   if (_ctldelim_text.p_text!='') {
      ctlpreceded.p_enabled=1;
   }else{
      ctlpreceded.p_enabled=1;
   }
}

static void set_preceded_limitations()
{
   ctlpreceded.p_user=1;
   if (ctlpreceded.p_value) {
      _ctlleading.p_enabled=0;
      _ctlcheckfirst.p_enabled=0;
      _ctlrest.p_enabled=0;
      label3.p_enabled=0;
      _ctlstartcol.p_enabled=0;
      _ctlendcol.p_enabled=0;
   }else{
      _ctlleading.p_enabled=1;
      _ctlcheckfirst.p_enabled=1;
      _ctlrest.p_enabled=1;
      label3.p_enabled=1;
      _ctlstartcol.p_enabled=1;
      _ctlendcol.p_enabled=1;
   }
   if (_ctlendcol.p_enabled && _ctlendcol.p_text!='') {
      _ctlrest.p_enabled=0;
   }else{
      _ctlrest.p_enabled=1;
   }
   if (p_window_id!=_ctlendcol) {
      //If it just changed, I don't think that we would need to disable it
      _ctlendcol.p_enabled=(_ctlstartcol.p_text!='' && (!_ctlrest.p_value/*&&_ctlrest.p_enabled*/));
   }
   if (_ctlstartcol.p_text=='') {
      _ctlrest.p_enabled=0;
   }else{
      _ctlrest.p_enabled=1;
   }
   val=(length(_ctldelim_text.p_text)==1 && isinteger(_ctlstartcol.p_text))
   _ctlcheckfirst.p_enabled=val;
   update_message_label();
}

ctlpreceded.lbutton_up()
{
   set_preceded_limitations();
}

void _cc_comment_l_form.on_load()
{
   if (_ctldelim.p_value) {
      _ctldelim_text._set_focus();
      _ctldelim_text._set_sel(1,length(_ctldelim_text.p_text)+1);
   }
}

void _ctlok.on_create()
{
   if (arg(1)._varformat()!=VF_PTR) {//Hit Shift-Space Bar
      p_active_form._delete_window(0);
      _mdi.show('-modal _cc_form');
      return;
   }
   _ctlmessage_label.p_visible=0;
   COMMENT_TYPE *comment;
   comment=arg(1);lexername=arg(2);commentnum=arg(3)+1;
   _ctlok.p_user=comment;
   p_active_form.p_caption=lexername" Line Comment "commentnum;
   _ctlendcol.p_enabled=0;
   if (comment->precededbyblank) {
      ctlpreceded.p_value=1;
   }
   if (comment->startcol && comment->delim1=='') {
      _ctlaftercol.p_text=comment->startcol;
      _ctlaftercol_rb.p_value=1;
   }else{
      //Order is important here
      _ctlrest.p_value=comment->repeat;
      if (comment->startcol) {
         _ctlstartcol.p_text=comment->startcol;
         if (comment->endcol) {
            _ctlendcol.p_text=comment->endcol;
         }
      }
      _ctldelim.p_value=1;
      _ctldelim_text.p_text=comment->delim1;
      switch (lowcase(comment->cf_or_l)) {
      case 'checkfirst':
         _ctlcheckfirst.p_value=1;
         break;
      case 'leading':
         _ctlleading.p_value=1;
         break;
      }
   }
   _ctlstartcol.call_event(_ctlstartcol,ON_CHANGE);
   set_preceded_limitations();
}

void _ctlaftercol_rb.lbutton_up()
{
   switch (p_name) {
   case '_ctldelim':
      _delim_options_frame.disable_all_controls(1);
      _ctlstartcol.call_event(_ctlstartcol,ON_CHANGE);
      _ctlaftercol.p_enabled=0;
      p_window_id=_ctldelim_text;
      _ctldelim_text._set_focus();
      _ctldelim_text._set_sel(1,length(_ctldelim_text.p_text)+1);
      break;
   case '_ctlaftercol_rb':
      _delim_options_frame.disable_all_controls();
      _ctlaftercol.p_enabled=1;
      _ctlaftercol._set_focus();
      break;
   }
}

static void update_message_label()
{
   if (_ctlstartcol.p_text=='') {
      _ctlmessage_label.p_visible=0;
   }else{
      _ctlmessage_label.p_visible=1;
      if (!isinteger(_ctlstartcol.p_text) ||
         (_ctlendcol.p_text!='' && !isinteger(_ctlendcol.p_text))) {
         _ctlmessage_label.p_caption="Value must be an integer";
         _ctlmessage_label.p_forecolor=0x0000FF;//Red
      }else if (isinteger(_ctlstartcol.p_text) && isinteger(_ctlendcol.p_text) &&
                _ctlendcol.p_text<=_ctlstartcol.p_text) {
         _ctlmessage_label.p_caption="Startcol must occur after endcol";
         _ctlmessage_label.p_forecolor=0x0000FF;//Red
      }else{
         _ctlmessage_label.p_visible=1;
         _ctlmessage_label.p_forecolor=0x000000;//Black
         if (_ctlendcol.p_text=='') {
            if (_ctlrest.p_enabled && _ctlrest.p_value) {
               _ctlmessage_label.p_caption="Delimiter functions anywhere after column "_ctlstartcol.p_text;
            }else{
               _ctlmessage_label.p_caption="Delimiter functions only when in column "_ctlstartcol.p_text;
            }
         }else{
            if (_ctlrest.p_enabled && _ctlrest.p_value) {
               _ctlmessage_label.p_caption="Delimiter functions anywhere after column "_ctlstartcol.p_text;
            }else{
               _ctlmessage_label.p_caption="Delimiter functions between columns "_ctlstartcol.p_text" and "_ctlendcol.p_text;
            }
         }
      }
   }
}

_ctlrest.lbutton_up()
{
#if 0
   if (p_name=='_ctlcheckfirst') {
      _ctlrest.p_value=0;
   }else if (p_name=='_ctlrest') {
      _ctlcheckfirst.p_value=0;
   }
#endif
   _ctlstartcol.call_event(_ctlstartcol,ON_CHANGE);
}

_ctlstartcol.on_change()
{
   if (_ctlendcol.p_enabled && _ctlendcol.p_text!='') {
      _ctlrest.p_enabled=0;
   }else{
      _ctlrest.p_enabled=1;
   }
   if (p_window_id!=_ctlendcol) {
      //If it just changed, I don't think that we would need to disable it
      _ctlendcol.p_enabled=(_ctlstartcol.p_text!='' && (!_ctlrest.p_value&&_ctlrest.p_enabled));
   }
   if (_ctlstartcol.p_text=='') {
      _ctlrest.p_enabled=0;
   }else{
      _ctlrest.p_enabled=1;
   }
   val=(length(_ctldelim_text.p_text)==1 && isinteger(_ctlstartcol.p_text))
   _ctlcheckfirst.p_enabled=val;
   update_message_label();
}

static void disable_all_controls()
{
   val=(arg(1)=='')?0:1;
   p_enabled=val;
   wid=p_window_id;
   while (p_child) {
      p_window_id=p_child;
      firstwid=p_window_id;
      for (;;) {
         p_window_id=p_next;
         p_enabled=val;
         if (p_window_id==firstwid) break;
      }
   }
   p_window_id=wid;
}

static void init_comment(COMMENT_TYPE &comment)
{
   comment.type=0;
   comment.delim1='';
   comment.cf_or_l='';
   comment.startcol=0;

   comment.delim2='';
   comment.colorname='';
   comment.lastchar=0;
   comment.nesting=0;
   comment.idchars='';
   comment.keywords='';

   comment.endcol=0;
   comment.repeat=0;
   comment.precededbyblank=0;
}

_ctlcheckfirst.lbutton_up()
{
   if (p_name=='_ctlcheckfirst') {
      _ctlleading.p_value=0;
   }else if (p_name=='_ctlleading') {
      _ctlcheckfirst.p_value=0;
   }
}

int _ctlok.lbutton_up()
{
   COMMENT_TYPE *comment;
   comment=_ctlok.p_user;

   COMMENT_TYPE temp
   init_comment(temp);
   delimtext=strip(_ctldelim_text.p_text);
   //Can't do this here....
   //delimtext=CCEscapeChars(delimtext);
   temp.type=COMMENT_SINGLELINE;
   if (_ctlaftercol_rb.p_value) {
      if (isinteger(strip(_ctlaftercol.p_text)) && _ctlaftercol.p_text>0) {
         temp.startcol=(int)_ctlaftercol.p_text;
      }else{
         _ctlaftercol._text_box_error("Column numbers must be an integer value.");
         return 1;
      }
   }else{
      if (delimtext=='') {
         _message_box(nls("You must specify a delimeter."));
         p_window_id=_ctldelim_text;
         _ctldelim_text._set_focus();
         return 1;
      }else{
         temp.delim1=strip(delimtext);
      }
      if (_ctlleading.p_value) {
         temp.cf_or_l='leading';
      }
      if (_ctlcheckfirst.p_value && _ctlcheckfirst.p_enabled) {
         temp.cf_or_l='checkfirst';
      }
      if (_ctlrest.p_enabled && _ctlrest.p_value) {
         temp.repeat=1;
      }
      if (ctlpreceded.p_enabled && ctlpreceded.p_value) {
         temp.precededbyblank=1
      }
      if (_ctlstartcol.p_enabled && _ctlstartcol.p_text!='') {
         if (isinteger(_ctlstartcol.p_text)) {
            temp.startcol=(int)_ctlstartcol.p_text;
            if (isinteger(_ctlendcol.p_text)) {
               temp.endcol=(int)_ctlendcol.p_text;
            }else{
               if (_ctlendcol.p_text!='') {
                  _ctlendcol._text_box_error("Column numbers must be an integer value.");
                  return 1;
               }
            }
         }else{
            if (_ctlstartcol.p_text!='') {
               _ctlstartcol._text_box_error("Column numbers must be an integer value.");
               return 1;
            }
         }
      }
   }
   *comment=temp;

   p_active_form._delete_window(0);//This was a 1, don't know why Dan 4:49pm 4/8/1996
   return(0);
}

defeventtab _cc_comment_ml_form
_ctlnew_name.lbutton_up()
{
   name=show('-modal _textbox_form',
             'Enter New Keywords',
             0, //Flags
             '',//Width
             '',//Help item
             '',//buttonlist
             '',//retrieve
             'New Keywords:' //prompt
             );
   if (name!='') {
      AddLexerToModList();
      name=_param1;
      wid=p_window_id;p_window_id=_control list1;
      parse name with first_word .;
      for (;;) {
         parse name with word name;
         if (word=='') break;
         _lbadd_item(word);
      }
      _lbsort();
      _lbtop();
      _lbsearch(first_word);
      _lbselect_line();
      p_window_id=wid;
   }
   ctlattributes.p_enabled=list1.p_Noflines!=0;
}

#define AttributeTable list1.p_user

_ctlok.on_create()
{
   COMMENT_TYPE *comment;
   comment=arg(1);
   _ctlok.p_user=comment;
   lexername=arg(2);
   commentnum=arg(3)+1;
   p_active_form.p_caption=lexername' Multi-Line Comment 'commentnum;
   _ctladvanced._dmless();
   wid=p_window_id;p_window_id=_control _ctlcolor_name.p_cb_list_box;
   if (!p_Noflines) {
      _lbadd_item('KeywordColor');
      _lbadd_item('NumberColor');
      _lbadd_item('StringColor');
      _lbadd_item('CommentColor');
      _lbadd_item('PPKeywordColor');
      _lbadd_item('LineNumColor');
      _lbadd_item('Symbol1Color');
      _lbadd_item('Symbol2Color');
      _lbadd_item('Symbol3Color');
      _lbadd_item('Symbol4Color');
      _lbtop();
   }
   p_window_id=_ctlcolor_name;
   p_text=p_cb_list_box._lbget_text();
   p_window_id=wid;

   //Setup dialog box
   _ctldelim1.p_text=comment->delim1;
   _ctldelim2.p_text=comment->delim2;
   if (comment->startcol) {
      _ctlstartcol.p_text=comment->startcol;
   }
   _ctlidchars.p_text=comment->idchars;

   color=comment->colorname;
   if (color=='') color='CommentColor';
   _ctlcolor_name.p_cb_list_box._lbsearch(color,'i');
   _ctlcolor_name.p_text=_ctlcolor_name.p_cb_list_box._lbget_text();

   _ctlnesting.p_value=comment->nesting;
   _ctlcheckfirst.p_value=(int)(comment->cf_or_l=='checkfirst');
   _ctlleading.p_value=(int)(comment->cf_or_l=='leading');
   _ctllastchar.p_value=comment->lastchar;
   _ctlstartcol.call_event(_ctlstartcol,ON_CHANGE);
   if (comment->keywords!='') {
      keywords=comment->keywords;
      for (;;) {
         parse keywords with cur keywords;
         if (cur=='') break;
         list1._lbadd_item(strip(cur));
      }
      list1._lbtop();
      list1._lbselect_line();
      AttributeTable=comment->attributes;
   }
   ctlattributes.p_enabled=list1.p_Noflines!=0;
}

void ctlattributes.lbutton_up()
{
   temp=AttributeTable;
   keyword=list1._lbget_text();
   if (temp._varformat()!=VF_HASHTAB ||
       !temp._indexin(keyword)) {
      attribute='';
   }else{
      attribute=temp:[keyword];
   }
   status=show('-modal _textbox_form',
               'Attributes for 'keyword,
               0,//flags
               '',//width
               '',//help item
               '',//reserved
               '',//retrieve name
               'Attributes:'attribute);
   if (status!='') {
      newattribute=_param1;
      temp:[keyword]=newattribute;
      AttributeTable=temp;
      AddLexerToModList();
   }
}

void _ctlok.lbutton_up()
{
   COMMENT_TYPE *comment;
   comment=_ctlok.p_user;

   COMMENT_TYPE temp;
   init_comment(temp);
   temp.type=COMMENT_MULTILINE;
   //Do a whole bunch of error checking
   if (_ctldelim1.p_text=='') {
      _ctldelim1._text_box_error("You must specifiy two comment delimiters for a multi-line comment.");
      return;
   }
   if (_ctldelim2.p_text=='') {
      _ctldelim2._text_box_error("You must specifiy two comment delimiters for a multi-line comment.");
      return;
   }
   if (pos(':v',_ctldelim1.p_text,1,'r')==1) {
      _ctldelim1._text_box_error("Currently, a comment delimiter may not be a valid identifer.");
      return;
   }
   if (pos(':v',_ctldelim2.p_text,1,'r')==1) {
      _ctldelim2._text_box_error("Currently, a comment delimiter may not be a valid identifer.");
      return;
   }
   if (_ctlstartcol.p_text!='' && !isinteger(_ctlstartcol.p_text)) {
      _ctlstartcol._text_box_error("Start Column must be an intger.");
      return;
   }
   status=_ctlcheckfirst.call_event(_ctlcheckfirst,LBUTTON_UP);
   status=_ctllastchar.call_event(_ctllastchar,LBUTTON_UP);
   if (status) {
      return;
   }
   //Finish error checking

   temp.delim1=_ctldelim1.p_text;
   temp.delim2=_ctldelim2.p_text;
   temp.startcol=(_ctlstartcol.p_text=='')?0:(int)_ctlstartcol.p_text;
   if (_ctlcolor_name.p_text!='CommentColor') {
      temp.colorname=_ctlcolor_name.p_text;
   }else{
      temp.colorname='';
   }
   temp.idchars=_ctlidchars.p_text;
   if (_ctlcheckfirst.p_enabled && _ctlcheckfirst.p_value) {
      temp.cf_or_l='checkfirst';
   }else if (_ctlleading.p_enabled && _ctlleading.p_value) {
      temp.cf_or_l='leading';
   }
   temp.lastchar=(int)(_ctllastchar.p_enabled && _ctllastchar.p_value);
   temp.nesting=(int)(_ctlnesting.p_enabled && _ctlnesting.p_value);
   wid=p_window_id;p_window_id=list1;
   _lbtop();_lbup();
   keyword_list='';
   while (!_lbdown()) {
      keyword=_lbget_text();
      if (keyword_list=='') {
         keyword_list=keyword;
      }else{
         keyword_list=keyword_list' 'keyword;
      }
   }
   temp.keywords=keyword_list;
   //_ctlok.p_user=temp;

   //Now we have to clean up the attributes
   dellist='';
   temp.attributes=AttributeTable;
   if (temp.attributes._varformat()==VF_HASHTAB) {
      for (hi._makeempty();;) {
         temp.attributes._nextel(hi);
         if (hi._isempty()) break;
         if (!pos(' 'hi' ',' 'keyword_list' ')) dellist=dellist' 'hi;
      }
   }
   for (;;) {
      parse dellist with cur dellist;
      if (cur=='') break;
      temp.attributes._deleteel(cur);
   }
   *comment=temp;
   p_window_id=wid;
   p_active_form._delete_window(0);//This was a 1, don't know why 4:50pm 4/8/1996
}

_ctladvanced.lbutton_up()
{
   _dmmoreless();
}

_ctldelim1.on_change()
{
   if (_ctlcheckfirst.p_value && length(_ctldelim1.p_text)>1) {
      _ctldelim1._text_box_error("When the 'Color code whole line' option is on, Delimiter 1 is limited to 1 character in length.");
   }
}

_ctldelim2.on_change()
{
   if ((_ctllastchar.p_value&&_ctllastchar.p_enabled) && length(_ctldelim2.p_text)>1) {
      _ctldelim2._text_box_error("When the 'Color code whole line' option is on, Delimiter 2 is limited to 1 character in length.");
   }
}

int _ctllastchar.lbutton_up()
{
   if (_ctllastchar.p_value) {
      if (length(strip(_ctldelim2.p_text))>1) {
         p_value=0;
         if (arg(1)=='') {
            _ctldelim2._text_box_error("When the 'Color code whole line' option is on, Delimiter 2 is limited to 1 character in length.");
         }
         return(1);
      }
   }
   return(0);
}

int _ctlcheckfirst.lbutton_up()
{
   _ctlleading.p_value=(int)!p_value;
   if (_ctlcheckfirst.p_value) {
      if (length(strip(_ctldelim1.p_text))>1) {
         p_value=0;
         if (arg(1)=='') {
            _ctldelim1._text_box_error("When the 'Color code whole line' option is on, Delimiter 1 is limited to 1 character in length.");
         }
         return(1);
      }
   }
   return(0);
}

_ctlstartcol.on_change()
{
   if (isinteger(_ctlstartcol.p_text)||_ctlstartcol.p_text!='') {
      _ctlcheckfirst.p_enabled=1;
      _ctlleading.p_enabled=1;
      _ctllastchar.p_enabled=1;
      _ctlnesting.p_enabled=0;
      _ctlidchars.p_enabled=0;
      _ctlcolor_name.p_enabled=0;
      _ctlcolor_label.p_enabled=0;
      _ctlidchars_label.p_enabled=0;
   }else{
      _ctlcheckfirst.p_enabled=0;
      _ctlleading.p_enabled=0;
      _ctllastchar.p_enabled=0;
      _ctlnesting.p_enabled=1;
      _ctlidchars.p_enabled=1;
      _ctlcolor_name.p_enabled=1;
      _ctlcolor_label.p_enabled=1;
      _ctlidchars_label.p_enabled=1;
   }
}

defeventtab _cc_comment_type_form

_ctlok.on_create()
{
   num_ml_comments=arg(1);
   if (num_ml_comments>=MAX_MLCOMMENTS) {
      _ctlml_com.p_enabled=0;
   }
}

_ctlok.lbutton_up()
{
   if (_ctlml_com.p_value) {
      p_active_form._delete_window(COMMENT_MULTILINE);
   }else if (_ctll_com.p_value) {
      p_active_form._delete_window(COMMENT_SINGLELINE);
   }
}

_str vlx_proc_search(var proc_name,boolean find_first)
{
   boolean proc_was_null=false;
   if ( proc_name:=='' ) {
      proc_was_null=true;
      proc_name='[^\]]#'
   } else {
      parse proc_name with proc_name '(' rest;
   }
   _str search_key='^[\[]'proc_name'[\]]';
   if ( find_first ) {
      search search_key,'ri';
   } else {
      repeat_search;
   }
   if (!rc) {
      get_line(line)
      parse line with '[' proc_name ']';
      proc_name=proc_name;
   }
   return(rc)
}

