/*
$VerboseHistory: compile.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:08:22a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 08:22a
 * Comment:
 * Changed to add new project support.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:37p
 * Comment:
 * Adding new 3.0 stuff
*/
/*************************************************************
*  Rules for substituting parts of buffer name into compile  *
*  command.                                                  *
*                                                            *
*         *      Buffer name                                 *
*         *p     Path of buffer name with backslash          *
*         *d     Drive with : of buffer name                 *
*         *n     Buffer name without extension or path       *
*         *f     Buffer name without path                    *
*         *e     Buffer name extension without dot           *
*         **     Star                                        *
*************************************************************/
_str
   def_make_project='make'
   ,no_concur_proc='PCDOS SEQ386'

#include 'slick.sh'
#define COMMAND_FILE '$compile.tmp'
#define PARSE_CHAR '%'


_str
   def_auto_reset,       /* If non-zero, reset-next-error is called. */
                         /* before a compile or make commands is executed. */
   def_process=1,        /* Leave process buffer active when exec commands. */
   def_save_on_compile='1 0';//0=no save, 1=save current file, 2=save all files
                             //compile make
_command void clear_pbuffer() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   orig_buf_id=p_buf_id;
   if(!load_files('+q +b .process')) {
      //there is a process buffer
      _lbclear();
      set_next_error();
      p_buf_id=orig_buf_id;
   }
}

int _OnUpdate_project_compile(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
_command project_compile(_str buf_name="",_str info="",int cmdlist_view_id=0,boolean buf_name_is_file_list=false)
{
   word='';
   if ( buf_name != '') {
      if (!buf_name_is_file_list) {
         buf_name= absolute(buf_name);
      }
   } else {
      if (_isEditorCtl()) {
         buf_name=p_buf_name;
         word=cur_word(junk);
      } else {
         buf_name='';
      }
   }
   ext=get_extension(buf_name);
   if ( file_eq('.'ext,_macro_ext) || file_eq(ext,'cmd') ) {
      if ( _need_to_save2(buf_name,1)) {
         status=_save_non_active(buf_name);
         if ( status ) {
            return(status)
         }
      }
      status=st(buf_name)
      return(status);
   }
   status=_project_command("COMPILER",'compile',buf_name,word,info,cmdlist_view_id);
   return(status)
}
void _cdb4compile(_str flags)
{
   // IF we are running under WINDOWS 3.1 OR running under OS/2
   if (_win32s()==1 || machine()=='OS2386' || _project_name=="") return;

   if (pos("nochangedir",flags)) {
      return;
   }

   // Change to project directory:
   status=_ini_get_value(_project_get_filename(),_project_get_section("COMPILER"),"WORKINGDIR",info);
   if (status||info=="") {
      return;
   }
   dir=_parse_project_command(info,"","","");
   if (!file_eq(getcwd(),dir)) {
      cd(maybe_quote_filename(dir));
   }
}
int _OnUpdate_project_make(CMDUI &cmdui,int target_wid,_str command)
{
   parse command with . params;
   command='project_build 'params;
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
int _OnUpdate_project_build(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
_command project_make,project_build(...) name_info(','VSARG2_EDITORCTL)
{
   if (arg(1)=='') {
      cmdname='make';
   } else {
      cmdname='rebuild';
   }
   return(_project_command2(_project_get_section("COMPILER"),cmdname));
}
int _OnUpdate_project_rebuild(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
_command project_rebuild() name_info(','VSARG2_EDITORCTL)
{
   return(project_make('rebuild'));
}
int _OnUpdate_project_user1(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
_command project_user1() name_info(','VSARG2_EDITORCTL)
{/* was rebuild */
   return(_project_command2(_project_get_section("COMPILER"),"user1"));
}
int _OnUpdate_project_debug(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
_command project_debug() name_info(','VSARG2_EDITORCTL)
{
   return(_project_command2(_project_get_section("COMPILER"),'debug'));
}
int _OnUpdate_project_execute(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
_command project_execute() name_info(','VSARG2_EDITORCTL)
{
   return(_project_command2(_project_get_section("COMPILER"),'execute'));
}
int _OnUpdate_project_user2(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
_command project_user2() name_info(','VSARG2_EDITORCTL)
{/* was rsrcedit */
   return(_project_command2(_project_get_section("COMPILER"),'user2'));
}
int _OnUpdate_project_usertool(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
_command project_usertool() name_info(','VSARG2_EDITORCTL)
{
   return(_project_command2(_project_get_section("COMPILER"),arg(1)));
}
int _OnUpdate_project_help(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdateProjectCommand(cmdui,target_wid,command));
}
_command project_help() name_info(','VSARG2_EDITORCTL)
{
   return(_project_command2(_project_get_section("COMPILER"),'help'));
}
int _project_command2(section_name, field_name)
{
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_ALLOW_DIALOG_ACCESS_TO_PROJECTS)) {
      _beep();
      return(1);
   }
   buf_name='';
   word='';
   if (_isEditorCtl()) {
      buf_name=p_buf_name
      word=cur_word(junk)
   }
   status=_project_command(section_name,field_name,buf_name,word);
   return(status);
}
_str _project_command(_str section_name,_str field_name,_str buf_name,_str word,_str info="",int cmdlist_view_id=0)
{
   status=0;
   // project_name=_project_current(buf_name);
   //status=_project_get_info2(buf_name,field_name,info,word,'e')
   if (info=='') {
      status=_ini_get_value(_project_get_filename(), _project_get_section(section_name), field_name, info, "default");
   }
   pname=(_project_name=='')?_project_get_section(section_name):_project_name;
   parse info with flags ',' compile_command;
   if (compile_command=='' && _isEditorCtl()) {
      ext=p_extension;
      status=_ini_get_value(slick_path_search(PRJ_DEFAULT_FILE),'.'ext, field_name, info, "default");
      parse info with flags',' compile_command
   }
   if (status||compile_command=='') {
      _message_box(nls("This project command is not defined for the project %s\n\nFrom the Project menu select \"Properties...\" and select the Tools tab", pname));
      return(status);
   }
   tempCmdLine = stranslate(compile_command,"","%%");

   // Save option is per command in the option flags. If "save*" is missing
   // from the options flag, its absence implies saveNone.
   int fallbackToDefault;
   fallbackToDefault = 1;
   save_option=0;
   if (pos("save",flags)) {
      fallbackToDefault = 0;
      if (pos("savecurrent",flags)) {
         save_option = 1;
      } else if (pos("savemodified",flags)) {
         save_option = 3;
      } else if (pos("saveall",flags)) {
         save_option = 2;
      }
   }

   // The user will have to explicitly set def_save_on_compile. Fallback
   // to def_save_on_compile is only valid for compile, build, and rebuild.
   if (fallbackToDefault) {
      if (buf_name!='' && _isEditorCtl() && file_eq(buf_name,p_buf_name) 
          && pos("(%f)|(%p)|(%n)|(%e)",tempCmdLine,1,"RI")) {
         parse def_save_on_compile with save_option .
      } else if (field_name=='make' || field_name=='rebuild') {
         parse def_save_on_compile with . save_option;
      }
   }

   // Honor save options:
   if (save_option) {
      if (save_option==1) {
         if ( buf_name!="" && _need_to_save2(buf_name,1)) {
            status=_save_non_active(buf_name);
            if (status) return(status);
         }
      }else if (save_option==2) {
         status=_mdi.p_child.save_all('',1 /* skip unnamed files */);
         if (status) return(status);
      }else if (save_option==3) {
         _mdi.p_child.list_modified();
      }
   }
   tag_close_bsc();
   compile_command=_parse_project_command(compile_command, buf_name, pname, word);
   if (cmdlist_view_id) {
      int orig_view_id;
      get_view_id(orig_view_id);
      activate_view(cmdlist_view_id);
      insert_line(compile_command);
      activate_view(orig_view_id);
      return(0);
   }
   if ( pos('concur',flags,1,'i') && pos("clear",flags)) {
      _mdi.p_child.clear_pbuffer();
   }
   _cdb4compile(flags);
   if ( pos('concur',flags,1,'i')) {
      if ( def_auto_reset ) reset_next_error();
      if (machine()=='OS2386') {
         index=find_index('_get_apptype',DLLCALL_TYPE);
         if (!index) {
            _dllexport("int vsapptyp:_get_apptype(VSPSZ pszFilename)");
            index=1;
         }
         if (index) {
            parse compile_command with pgmname .
            pgmname=slick_path_search(pgmname,'p')
            parse pgmname with a b c
            if (b!='' && pos('command.com',a,1,'i')) {
               // For some weird reason, must run two copies of command.com for this to work.
               compile_command='dospipe command /c command /c 'compile_command
            } else {
               if (pgmname!='' && _get_apptype(pgmname)==3) {  // If this is a DOS app
                  compile_command='dospipe 'compile_command;
               }
            }
         }
      }
      status=concur_command(compile_command,def_process)
   } else if ( pos('capture',flags,1,'i')) {
      if ( def_auto_reset ) reset_next_error();
      status=dos('-e 'compile_command)
   } else {
      temp=compile_command;
      pgmname=parse_file(temp);
      index=find_index(pgmname,COMMAND_TYPE);
      if (index) {
         status=execute(compile_command,'');
      } else {
         temp=slick_path_search(pgmname,'p');
         if (temp=='') {
            message2=".\n\nFrom the Project menu, select \"Properties...\" and select the Tools tab to change tool command."
            _message_box(nls("Program %s not found",pgmname)message2)
            return(FILE_NOT_FOUND_RC);
         }
         status=shell(compile_command,'ap')
      }
   }
   return(status)

}
#if 0
_str _project_get_info2(buf_name,field_name,var info,cur_word)
{
   display_error=arg(5)!=''
   project_name=_project_current(buf_name);
   status=_project_get_info(project_name,
                           field_name,info)
   info=_parse_project_command(info,buf_name,project_name,cur_word)
   project_name2='';
   if (status!=FILE_NOT_FOUND_RC && info=='' && substr(project_name,1,1)!='.') {
      project_name2='.'_bufname2ext(buf_name);
      status=_project_get_info(project_name2,field_name,info)
      info=_parse_project_command(info,p_buf_name,project_name2,cur_word)
   }
   if (info=='' && display_error) {
      message2="\n\nUse the List Projects command to select a project.  Then select \"Edit settings...\"."
      if (project_name2!='') {
         _message_box(nls("Field %s not defined for project '%s' or '%s'.",field_name,project_name,project_name2)message2)
      } else {
         _message_box(nls("Field %s not defined for project '%s'.",field_name,project_name)message2)
      }
      status=1;
   }
   return(status);
}
#endif
_str _parse_project_command(_str command,_str buf_name,_str project_name,_str cword /* ,line*/)
{
   j=1;
   for (;;) {
     j=pos(PARSE_CHAR,command,j)
     if ( ! j ) { break }
     ch=upcase(substr(command,j+1,1));
     len=2
     if ( ch=='P' ) {
       s=strip_filename(buf_name,'N')
     } else if ( ch=='Q' ) {
        count=substr(command,j+2,1);
        if (!isinteger(count)) {
           s='';
        } else {
           len=3;
           s=strip_filename(buf_name,'N')
#if _NAME_HAS_DRIVE
           s=strip_filename(s,'D');
           --count;
#endif
           while (count>0) {
              parse substr(s,2) with (FILESEP) +0 s
              --count;
           }
        }
     } else if ( ch=='F' ) {
       s=buf_name;
     } else if ( ch=='N' ) {
       s=strip_filename(buf_name,'PE')
     } else if ( ch=='M') {
        k= pos('[A-Za-z0-9_]',command,j+2,'r');
        if (!k) {
           return(command);
        }
        l= pos('%',command,k)
        if (!l) {
           return(command);
        } 
        w= l-k;
        macCommand= substr(command,k,w);
        //messageNwait("macName "macName);
        s= execute(macCommand);
        len= l-j+1;
     } else if ( ch=='E' ) {
       s=get_extension(buf_name,'.')
     } else if (ch=='R'){
        ch2=upcase(substr(command,j+2,1));
        switch (ch2) {
        case 'D':
        case 'V':
           len=3;
           s=project_name;
           if ( substr(s,2,1)==':' ) {
             s=substr(s,1,2)
           } else {
             s='';
           }
           break;
        case 'E':
           len=3;
           s=get_extension(project_name,'.');
           break;
        case 'N':
           len=3;
           s=strip_filename(project_name,'PE');
           break;
        case 'P':
           len=3;
           s=strip_filename(project_name,'N');
           break;
        default:
           s=project_name;
        }
     } else if (ch=='W'){
       s=cword;
     } else if (ch=='I') {
        s=''
        if (project_name!='') {
           _ini_get_value(project_name, _project_get_section("COMPILER"), "INCLUDEDIRS", info);
           info=_parse_project_command(info, '', '', '');
           for (;;) {
              if (info=='') break;
              parse info with dirname ';' info
              s=s:+'-I'dirname' '
           }
        }
     } else if (ch=='L'){
       s=arg(5);
     } else if (isdigit(ch)){
       k=verify(command,'0123456789','',j+1)
       if ( k==0 ) k=length(command)+1;
       if ( k-j-1>3 ) k=j+4;
       len=k-j;
       num=substr(command,j+1,k-j-1);
       s=word(arg(5),num);
     } else if ( ch=='V' || ch=='D') {
       s=buf_name;
       if ( substr(s,2,1)==':' ) {
         s=substr(s,1,2)
       } else {
         s=''
       }
     } else if ( ch=='(' ) {
        k=pos(')',command,j+1)
        s=''
        if (k) {
           len=k-j+1
           envvar_name=substr(command,j+2,len-3)
           s=get_env(envvar_name)
        }
     } else if ( ch==PARSE_CHAR ) {
       s=PARSE_CHAR
     } else {
       len=1
       /* insert pc filename */
       s=''
     }
     command=substr(command,1,j-1):+s:+substr(command,j+len)
     j=j+length(s);
   }
   return(command)
}

xnext_error2()
{
   /* remove error file if one already present. */
   if ( _error_file=='' ) {
      _error_file=absolute(COMPILE_ERROR_FILE)
   }
   filename=buf_match(absolute(_error_file),1,'X')
   // IF error buffer already exists?
   if ( filename!='') {
      options='+l +d +r '
   } else {
      options='+l +d '
   }
   get_view_id view_id
   if (iswildcard(_error_file)) {
      status=FILE_NOT_FOUND_RC;
   } else if (file_match('-p 'maybe_quote_filename(_error_file),1)!=''){
      status=edit(' +bp 'options maybe_quote_filename(_error_file))
   } else {
      status=FILE_NOT_FOUND_RC;
   }
   if ( status ) {
      if (status==FILE_NOT_FOUND_RC) {
         message nls("File '%s' not found",maybe_quote_filename(_error_file))
      } else {
         message get_message(status)
      }
      return(status)
   }
   return(next_error())
}
void quit_error_file()
{
   if ( arg(1)!='' ) {
      filename=absolute(arg(1))
   } else {
      filename=absolute(COMPILE_ERROR_FILE)
   }
   if ( buf_match(filename,1)=='' ) {
      return;
   }
   status=edit('+q +b 'filename);
   if (!status) {
      p_modify=0;
      quit();
   }
}
_command int javamake(_str cmdline="") name_info(','VSARG2_EDITORCTL)
{
   parse cmdline with option output_path;
   if (option=="-d") {
      if (output_path!=""){ 
         if( last_char(output_path)!=FILESEP) {
            output_path=output_path:+FILESEP;
         }
         output_path=absolute(output_path);
      }
   } else {
      output_path="";
   }

   if (_project_name == '') {
      //Check to see if Project is Active
      _message_box('No Project Open', 'Error!',0);
      return(1);
   }
#if 1
   field_name='compile';
   status=_ini_get_value(_project_get_filename(), 'COMPILER', field_name, info, "");
   if (info=="") {
      status=_ini_get_value(slick_path_search(PRJ_DEFAULT_FILE),'.java', field_name, info, "");
   }
   if (info!='') {
      parse info with flags ',' compile_command;
      compile_command=stranslate(compile_command,'%f','"%f"');
      info=flags:+',':+compile_command;
   }

   status =_ini_get_section(_project_name,'FILES',listviewid);
   //Get file list from .vpj file
   if (status) {
      return(status);
   }
   orig_view_id = p_view_id;
   p_view_id = listviewid;
   _str hashtab:[][];
   top();up();
   while (!down()) {
      get_line(line);
      if (line!="") {
         file=strip_filename(line,'p');
         hashtab:[file][hashtab:[file]._length()]=line;
      }
   }
   get_view_id(listviewid);
   top();up();
   _str file_list="";


   int old_warning_string_length=_default_option(VSOPTION_WARNING_STRING_LENGTH);
   _default_option(VSOPTION_WARNING_STRING_LENGTH,MAXINT);
   while (!down()) {
      //Check each of the files and see if it needs to be recompiled
      get_line(javafile);
      if (javafile!='') {
         javafile= strip(javafile,'B');
         ext= get_extension(javafile);
         if (file_eq(ext,'java')) {
            classfile= '';
            if (output_path!="") {
               classfile= strip_filename(javafile,'PE');
            } else {
               classfile= strip_filename(javafile,'E');
            }
            classfile= output_path:+classfile:+'.class';
            doCompile=false;
            classfileDate=_file_date(classfile,'B');
            //messageNwait('ne='(file_match(' -p 'maybe_quote_filename(classfile),1)== '')' .class<.java '(classfileDate<_file_date(javafile,'B'))' dep='_JavaCheckDependancies(classfile,hashtab,classfileDate));
            //messageNwait('classfile='classfile);
            //messageNwait('f='javafile' classfileDate='classfileDate' fd='_file_date(javafile,'B'));
            if (file_match(' -p 'maybe_quote_filename(classfile),1)== '' || 
                classfileDate<_file_date(javafile,'B') ||
                _JavaCheckDependancies(classfile,hashtab,classfileDate)
                ) {
               doCompile=true;
            }
            //messageNwait('doCompile='doCompile);
            if (doCompile) {
               file_list=file_list:+' 'maybe_quote_filename(javafile);
               /*status=project_compile(javafile, info:+" "cmdline,cmdlist_view_id);
               //Compile the file using the new compile command
               if (status) {
                  break;
               } */
               activate_view(listviewid);
            }
         }
      }
   }
   _default_option(VSOPTION_WARNING_STRING_LENGTH,old_warning_string_length);
   _delete_temp_view(listviewid);

   if (file_list!="") {
      project_compile(file_list,info,0,true);
   } else {
      _message_box("All Java project files have been compiled");
   }

   p_view_id=orig_view_id;
   return(0);
#else
   field_name='compile';
   status=_ini_get_value(_project_get_filename(), 'COMPILER', field_name, info, "");
   if (info=="") {
      status=_ini_get_value(slick_path_search(PRJ_DEFAULT_FILE),'.java', field_name, info, "");
   }
   status =_ini_get_section(_project_name,'FILES',listviewid);
   //Get file list from .vpj file
   if (status) {
      return(status);
   }
   orig_view_id = p_view_id;
   p_view_id = listviewid;
   _str hashtab:[][];
   top();up();
   while (!down()) {
      get_line(line);
      if (line!="") {
         file=strip_filename(line,'p');
         hashtab:[file][hashtab:[file]._length()]=line;
      }
   }
   listviewid=_create_temp_view(cmdlist_view_id);
   activate_view(listviewid);
   top();up();
   while (!down()) {
      //Check each of the files and see if it needs to be recompiled
      get_line(javafile);
      if (javafile!='') {
         javafile= strip(javafile,'B');
         ext= get_extension(javafile);
         if (file_eq(ext,'java')) {
            classfile= '';
            if (output_path!="") {
               classfile= strip_filename(javafile,'PE');
            } else {
               classfile= strip_filename(javafile,'E');
            }
            classfile= output_path:+classfile:+'.class';
            doCompile=false;
            classfileDate=_file_date(classfile,'B');
            //messageNwait('f='javafile' docomp='(classfileDate<_file_date(javafile,'B')' exists='(file_match(' -p 'maybe_quote_filename(classfile),1))));
            if (file_match(' -p 'maybe_quote_filename(classfile),1)== '' || 
                classfileDate<_file_date(javafile,'B') ||
                _JavaCheckDependancies(classfile,hashtab,classfileDate)
                ) {
               doCompile=true;
            }
            //messageNwait('doCompile='doCompile);
            if (doCompile) {
               status=project_compile(javafile, info:+" "cmdline,cmdlist_view_id);
               //Compile the file using the new compile command
               if (status) {
                  break;
               }
               activate_view(listviewid);
            }
         }
      }
   }
   _delete_temp_view(listviewid);

   activate_view(cmdlist_view_id);
   if (p_Noflines) {
#if __UNIX__
      batch_filename=mktemp();
      top();up();
      insert_line("#!/bin/sh");
      for (;;) {
         if (down()) {
            break;
         }
         get_line(line);
         replace_line("echo "line);
         insert_line(line);
         insert_line("if [ $? != 0 ]; then");
         insert_line("   /bin/rm batch_filename");
         insert_line("   exit");
         insert_line("fi");
      }
#else
      top();up();
      insert_line("@echo off");
      /*
          Create a batch file name
      */
      if (substr(machine(),1,2)=='NT') {
         batch_filename=_temp_path():+"mkjava.bat";
      } else {
         batch_filename=_temp_path():+"mkjava.cmd";
      }
      for (;;) {
         if (down()) {
            break;
         }
         get_line(line);
         replace_line("echo "line);
         insert_line(line);
         insert_line("if errorlevel 1 goto out");
      }
      insert_line(':out');
      insert_line('echo '_chr(7));
      insert_line("@echo on");
#endif
      p_buf_name=batch_filename;
      status=_save_file("+o");
      _delete_temp_view(cmdlist_view_id);
      activate_view(orig_view_id);
      if (status) {
         _message_box(nls("Unable to write temp batch file '%s'",batch_filename));
      } else {
         start_process(false,true,true);
         concur_command(batch_filename);
      }
   } else {
      _message_box("All Java project files have been compiled");
   }

   p_view_id=orig_view_id;
   return(0);
#endif

}
/*
   This functions check dependancies of the file specified against
   other files in the project.
   
   Returns true if need to compile this source file
*/
static boolean _JavaCheckDependancies(_str classfile,_str (&hashtab):[][],_str classfileDate)
{
   _str classList[];

   status=_JavaGetClassRefList(classfile,classList);
   if (status) {
      // Invalid file format or file I/O error
      return(false);
   }
   javafile= strip_filename(absolute(classfile),'E')'.java';
   int count=classList._length();
   for (i=1;i<count;++i) {
      file=classList[i]'.java';
      x=lastpos('/',file);
      if (x) {
         file=substr(file,x+1);
      }
      if (hashtab._indexin(file)) {
         list=hashtab:[file];
         for (j=0;j<list._length();++j) {
            filename=list[j];
            if (!file_eq(javafile,filename) &&
                _file_date(filename,'B')>classfileDate
                ) {
               //messageNwait('class 'classfile' dep='filename);
               return(true);
            }
         }
      }
   }
   return(false);
}
