/*
$VerboseHistory: fileman.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:08:57a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 08:56a
 * Comment:
 * Added support for Explorer style open dialog.
 * Change message box to display question mark icon.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:32p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
/* Usage: subcopy source dest_path                               */
/*                                                               */
#include "slick.sh"
int _shell_wid;

//_command show();
_command void fileman() name_info(','VSARG2_REQUIRES_MDI)
{
   _macro_delete_line();
   append_option=arg(1)!=''
   result = show('-modal _fileman_form',(append_option)?'Append Files':'');
   if (result == '') {
      return;
   }

   _macro('m',_macro('s'))
   if (append_option) {
      _macro_call('append_dir',result);
      status = append_dir(result);      //Result should have path information
   } else {
      _macro_call('dir',result);
      status = dir(result);      //Result should have path information
   }
   if (status) {
      _message_box(nls("Unable to list files '%s'\n\n",result):+
                   get_message(status));
   }
}

defeventtab _fileman_form


_lffiles.on_create()
{
   _retrieve_prev_form();
}


_ok.on_create()
{
   if (arg(1) != '') {
      p_active_form.p_caption = arg(1);
   }
}


_ok.lbutton_up()
{

   orig_wid=p_window_id;
   result=_lffiles.p_text;
   if (result=='') {
      result=ALLFILES_RE
   }
   if (result!='' && (_lfsubdir.p_value)) {
      result= '+t 'result
   }
   tree_option=''
   line=result;
   Noffiles=0;
   one_file_found=0;
   first_file_not_found='';
   for (;;) {
      word = parse_file(line);
      if (word=='') break;
      ch=substr(word,1,1);
      if (ch=='-' || ch=='+') {
         option=upcase(substr(word,2));
         switch (option) {
         case 'T':
            tree_option='+t'
            break;
         default:
            _message_box('Invalid switch')
            p_window_id=_lffiles;_set_sel(1,length(p_text)+1);_set_focus();
            return(1)
         }
      } else {
         ++Noffiles;
         if(isdirectory(word)){
         } else if (file_match('-pd 'tree_option' 'word,1)=='') {
            _message_box(nls('File "%s" not found',word))
            p_window_id=_lffiles;_set_sel(1,length(p_text)+1);_set_focus();
            return(1);
         }
      }
   }
   result=_lffiles.p_text;
   if (result=='') {
      result=ALLFILES_RE
   }
   if (_lfsubdir.p_value) {
      ret_val = '+t -d 'result;
   }else{
      ret_val = result;
   }
   if (_lfhidden.p_value) {
      ret_val='+h 'ret_val
   }
   if (_lfsystem.p_value) {
      ret_val='+s 'ret_val
   }
   _save_form_response();
   p_active_form._delete_window(ret_val)
}

_str _fm_subcopy()
{
   dest_path=arg(1)
   source=parse_file(dest_path)
   if ( source=='' || dest_path=='' ) {
      message nls('Usage: subcopy source dest_path')
      return(1)
   }
   if ( last_char(dest_path)==FILESEP ) {
      dest_path=substr(dest_path,1,length(dest_path)-1)
   }
   source_path=strip_filename(absolute(source),'N')
   add_slash=''
   for (;;) {
      if ( substr(dest_path,1,3)!='..'FILESEP && dest_path!='..' ) {
         break
      }
      parse source_path with (FILESEP) source_path (FILESEP) +0 source_path
      dest_path=substr(dest_path,4)
      add_slash=FILESEP
   }
   name_part=strip_filename(source,'P')
   if ( ! __UNIX__ && (_dbcsSubstr(dest_path,2,1)==':' || substr(dest_path,1,2):=='\\') ) {
      add_slash=''
   }
   if ( dest_path=='' ) {
      add_slash=''
   }
   destfilename=add_slash:+dest_path:+strip_filename(source_path,'d'):+name_part
   /* messageNwait('df='destfilename' d='dest_path' s='strip_filename(source_path,'d')' n='name_part) */
   return(fileman_command('subcopy 'arg(1),'-simple-copy',source,destfilename,arg(2)))

}
   _nocheck _control list1

_str fileman_command(msg,operation,source,destfilename,arg2)
{
   line=operation " "maybe_quote_filename(source) " "maybe_quote_filename(destfilename)
   if ( arg2!='' ) {
      shell_wait=arg2 & PAUSE_COMMAND
   } else {
      shell_wait=0
   }
   parse line with proc_name args
   index=find_index(proc_name,PROC_TYPE|COMMAND_TYPE);
   first_time=! shell_wait
   for (;;) {
      if ( ! first_time ) {
         if ( _iswindow_valid(_shell_wid)) {
            _shell_wid.list1.insert_line msg
            _shell_wid.list1.refresh()
         }
         first_time=0
      }
      if (index) {
         status=call_index(args,index)
      } else{
         status=execute(line,"")
      }
      if ( ! status ) break;
      path=substr(destfilename,1,pathlen(destfilename)-1)
      /*  failure caused because directory does not exist */
      if ( status==PATH_NOT_FOUND_RC && ! isdirectory(path) ) {
         /* try to create the directory */
         status= make_path(absolute(path),1)
         if ( status ) {
            /* Can recover from access denied or insufficient disk space */
            status=recover_from_error(status,destfilename)
            if ( status ) {
               break
            }
         }
         continue
      }
      status=recover_from_error(status,destfilename)
      if ( status ) {
         break
      }
   }
   if ( shell_wait ) {
      if ( status<0 && isinteger(status) ) {
         if ( _iswindow_valid(_shell_wid)) {
            _shell_wid.list1.insert_line get_message(status)
            _shell_wid.list1.refresh()
         }
      }
   }
   if ( status==2 ) {  /* skip status? */
      return(0)
   }
   return(status)


}
//
// Second argument is not documented and is intended for fileman mode.
//
int make_path(path,...)
{
   shell_messages=(arg()>=2) && arg(2)
   if ( last_char(path)==FILESEP ) {
      /* Remove ending FILESEP */
      path=substr(path,1,length(path)-1)
   }
   prevpath=substr(path,1,pathlen(path)-1)
   if ( length(prevpath)>2 ) {
     /* if previous directory doesn't exist make it first */
     /* else return */
     if ( ! isdirectory(prevpath) ) {
       status= make_path(prevpath,shell_messages);
       if ( status ) { return(status) }
     }
   }
   /* make this directory */
   if ( shell_messages ) {
      if ( _iswindow_valid(_shell_wid)) {
         _shell_wid.list1.insert_line 'mkdir 'path
         _shell_wid.list1.refresh()
      }
   }
   status=mkdir(path);
   return(status)
}



static _str recover_from_error(status,dest)
{
   if ( status==INSUFFICIENT_DISK_SPACE_RC || status==ERROR_CREATING_DIRECTORY_RC ) {
#if __PCDOS__
      if ( status==INSUFFICIENT_DISK_SPACE_RC ) {
         text=nls('You have run out of disk space')
      } else {
         text=nls('Error creating directory entry.  Assuming you have run out of disk space')
      }
      result=_message_box(text"\n\n"nls('Do you have a spare formatted or unformatted disk?'),'',MB_YESNOCANCEL|MB_ICONQUESTION)
      if ( result!=IDYES ) {
         return(status)
      }
      result=_message_box(nls('Please insert disk in drive %s',upcase(substr(absolute(dest),1,2))),'',MB_OKCANCEL);
      if ( result!=IDOK ) {
         return(status)
      }
#else
      if ( status==INSUFFICIENT_DISK_SPACE_RC ) {
         _message_box(nls('You have run out of disk space'));
      } else {
         _message_box(nls("Error creating directory entry.  The possible causes are listed below."):+"\n\n":+
             '    1. 'nls('You may not have access for creating this directory.')"\n":+
             '    2. 'nls('You may have run out of disk space.')"\n":+
             '    3. 'nls('You may have hit an operating system limit.')"\n");
      }
      return(status);
#endif
   } else if ( status==DRIVE_NOT_READY_RC ) {
      result=_message_box(nls('Please close the door of drive %s',upcase(substr(absolute(dest),1,2))),
                          '',MB_OKCANCEL);
      if ( result!=IDOK ) {
         return(status)
      }
   } else if ( status==DISK_IS_WRITE_PROTECTED_RC ) {
      result=_message_box(nls('Drive %s is write protected',upcase(substr(absolute(dest),1,2))),
                          '',MB_OKCANCEL);
      if ( result!=IDOK ) {
         return(status)
      }
   } else if ( status==GENERAL_FAILURE_RC || status==SECTOR_NOT_FOUND_RC ) {
      result=_message_box(nls('Drive %s is not formatted',upcase(substr(absolute(dest),1,2)))"\n\n":+
                          nls('Would you like your disk formatted?'),
                          '',MB_YESNOCANCEL|MB_ICONQUESTION)
      if ( result!=IDYES ) {
         return(status)
      }
      for (;;) {
         result = show('-modal _textbox_form',
                       'Format',             //Caption
                       0,                    //Flags
                       '',                   //use default textbox width
                       '',                   //Help item
                       '',                   //Font(no support yet)
                       '',                   //Retrieve Name
                                             //Prompt
                       nls('Edit format command:'):+'format 'upcase(substr(absolute(dest),1,2))

                       );
         if (result == '') {
            return(status);
         }
         line=_param1
         line2=line
         name=parse_file(line2)
         if ( path_search(name,'PATH','P')=='' ) {
            _message_box(nls("Format program '%s' not found",name));
         } else {
            if ( _iswindow_valid(_shell_wid)) {
               _shell_wid.list1.insert_line line
               _shell_wid.list1.refresh()
            }
            status=execute(line,"")
            if (!status) break;
            if ( rc==FILE_NOT_FOUND_RC ) {
               _message_box(nls("Format program '%s' not found",name));
            } else {
               _message_box(nls("Error running format")"\n\n"get_message(status));
            }
         }
      }
      test_event();  // Refresh the screen after format
   } else if ( rc==ACCESS_DENIED_RC ) {
      result=_message_box(nls('Access has been denied to Source or dest file')"\n\n":+
                      nls('Skip this file?'),
                      '',MB_YESNOCANCEL|MB_ICONQUESTION);
      if ( result==IDCANCEL ) {   /* Escape */
         return(status)
      }
      if ( result==IDNO) {   /* No */
         return(0)
      }
      return(2)            /* Return skip rc */
   } else {
      if (status<0) {
         _message_box(get_message(status));
      }
      return(status)
   }
   return(0)
}

_str _fm_copy()
{
   return(file_move_or_copy(arg(1),arg(2),'copy'))

}
_str _fm_move()
{
   return(file_move_or_copy(arg(1),arg(2),'move'))

}
static _str file_move_or_copy(arg1,arg2,operation)
{
   source=parse_file(arg1)
   dest_path=arg1
   if ( source=='' || dest_path=='' ) {
      return(1)
   }
   if ( last_char(dest_path)!=FILESEP ) {
      dest_path=dest_path:+FILESEP
   }
   destfilename=dest_path:+strip_filename(absolute(source),'P')
   return(fileman_command('file-'operation " "arg1,'-simple-'operation,source,destfilename,arg2))

}
_str _simple_copy()
{
   dest=arg(1)
   source=parse_file(dest)
   status=copy_file(source,dest);
   return(status)

}
_str _simple_move()
{
   dest=arg(1)
   source=parse_file(dest)
   copy_file source,dest
   if ( ! rc ) {
     delete_file source
   }
   return(rc)

}
_str _fm_erase()
{
   status=delete_file(arg(1));
   if ( status==FILE_NOT_FOUND_RC ) status=0;
   return(status);
}
_command chmod() name_info(FILE_ARG',')
{
   _macro_delete_line();
   files=arg(1);
   permissions=strip(parse_file(files),'B','"');
   for (;;) {
      parse permissions with p1 permissions
      if (p1=='') break;
      _chmod(p1' 'files);
   }
   if ( rc && last_index('','w')) {
      message get_message(rc)
   }
   _macro_call('chmod', arg(1));
   return(rc)

}
_str def_prompt
static void fileman_prompt(arg1,append_to_prompt,caption,prompt,help_item)
{
   parse append_to_prompt with proc_name .
   proc_name=translate(proc_name,'_','-')
   _macro_delete_line();
   if (arg1=='') {
      result = show('-modal _textbox_form',
                    caption,              //Captions
                    TB_RETRIEVE_INIT,     //Flags
                    '',                   //use default textbox width
                    help_item,            //Help item
                    '',                   //Font(no support yet)
                    proc_name,            //Retrieve Name
                    prompt                //Prompt
                    );
      if (result == '') {
         return;
      }
      arg1=_param1;
   }
   _macro('m',_macro('s'))
   param1=append_to_prompt' ':+arg1
   _macro_append('for_select('_quote(param1)','PAUSE_COMMAND');')
   for_select(param1,PAUSE_COMMAND)

}
//  This command is not supported in a keyboard macro
_command void fileman_backup() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   fileman_prompt(arg(1),'-fm-subcopy %f',nls('Backup'),nls('Backup Files to Directory'),'backup dialog box')
}
//  This command is not supported in a keyboard macro
_command void fileman_copy() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   fileman_prompt(arg(1),'-fm-copy %f',nls('Copy'),nls('Copy Files to Directory'),'copy dialog box')
}
//  This command is not supported in a keyboard macro
_command void fileman_move() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   fileman_prompt(arg(1),'-fm-move %f',nls('Move'),nls('Move Files to Directory'),'move dialog box')
}
_command fileman_delete() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   result=_message_box(nls('Delete Selected Files?'),'',MB_YESNOCANCEL|MB_ICONQUESTION);
   if (result!=IDYES) {
      cancel();
      return(COMMAND_CANCELLED_RC);
   }
   return(for_select('_fm_erase %f',PAUSE_COMMAND))
}
_command fileman_edit() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
  return(for_select('edit %f',0,'1'))
}
_command fileman_attr() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   shell_wait=1;
   _macro_delete_line();
   result=arg(1)
   if (result=='') {
#if __UNIX__
      result=show('-modal _unixfmattr_form','','',nls("?Sets the Read and Write permissions of the selected files."));
#else
      result=show('-modal _fmattr_form','','',nls("?Sets the Read Only, Hidden, System, and Archive attributes of the selected files."));
#endif
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      parse result with . plus minus
      if (_param2=='+') plus='';
      if (_param3=='-') minus='';
      result=maybe_quote_filename(_param2' '_param3);
   }
   _macro('m',_macro('s'))
   param1='chmod 'result' %f'
   _macro_call('for_select',param1,shell_wait);
   status=for_select(param1,shell_wait);
   return(status);

}
_command fileman_space() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   if ( command_state() ) {
      maybe_normal_character()
   } else {
      get_line line
      if ( substr(line,1,1)=='>' ) {
         replace_line ' 'substr(line,2)
         return(-1)
      }
      replace_line '>'substr(line,2)
      return(1)
   }

}
_command void fileman_select_up() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   fileman_set_select_up('>')

}
_command void fileman_deselect_up() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   fileman_set_select_up(' ')

}
_command void fileman_select_down() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   fileman_set_select_down('>')
}
_command void fileman_deselect_down() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   fileman_set_select_down(' ')

}
static void fileman_set_select_up(ch)
{
   if ( command_state() ) {
      maybe_normal_character()
   } else {
      get_line line
      replace_line ch:+substr(line,2)
      up
   }

}
static void fileman_set_select_down(ch)
{
   if ( command_state() ) {
      maybe_normal_character()
   } else {
      get_line line
      replace_line ch:+substr(line,2)
      down
   }

}
_command void fileman_help() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   help('The Visual SlickEdit File Manager')

}
_command void fileman_keyin_name() name_info(','VSARG2_CMDLINE)
{
   _macro_delete_line();
   if ( command_state() ) {
      _edit_window().get_line line
      keyin pcfilename(line)
   }
   _macro_call('fileman_keyin_name')
}
_command read_list() name_info(FILE_ARG','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   arg1=arg(1);
   if (arg1=='') {
      _macro_delete_line();
      result=_OpenDialog(_stdform('_open_form')' -modal',
           'Read List', ALLFILES_RE,
           "All Files ("ALLFILES_RE")",
           OFN_FILEMUSTEXIST,
           '',          // Default extensions
           '',          // Initial filename
           '',          // Initial directory
           'read_list', // Retrieve name
           'read list dialog box'  // Help item
           )
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      _macro('m',_macro('s'))
      _macro_call('read_list',result);
      arg1=result;
   }
   bottom
   status=get(arg1,'','A')   /* Get list from disk */
   if ( status ) {
      return(status)
   }
   message nls('Reading new file size, date, time , and attributes...')
   down
   get_line line
   first_ch=substr(line,1,2)
   if ( first_ch=='' || first_ch=='>' ) {
      start_col=DIR_FILE_COL
   } else {
      start_col=1
   }
   for (;;) {
      if ( start_col!=1 ) {
         get_line line
         name=pcfile(line)
      } else {
         get_line name
      }
      if ( name!='.' && name!='..' ) {
         if ( start_col!=1 ) {
            name=pcfilename(line)
         }
         linenum=p_line
         _delete_line
         if ( p_line==linenum ) {
            up
         }
         if ( iswildcard(name) ) {
            status=insert_file_list('+P 'arg(3) " "name);
         } else {
            status=insert_file_list('+RHSDP 'arg(3) " "name);
            /* get_line line */
            /* up;_delete_line */
            /* replace_line ' 'substr(line,2) */
         }
         if ( status && ! iswildcard(name) ) {
            message(nls("Error reading '%s'",name)". "get_message(status));
            return(status)
         } else if (status) {
            message get_message(status)
         }
      }
      
      if ( down() ) {
         rc=0
         break
      }
   }
   clear_message
   old_line=p_line
   top;get_line line
   if ( line=='' ) {
      _delete_line
      old_line=old_line-1
   }
   p_line=old_line
   return(0)


}
_command write_list() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   params=arg(1);
   if (params=='') {
      _macro_delete_line();
      result=_OpenDialog(_stdform('_open_form')' -new -mdi -modal',
           'Write List',
           '',     // Initial wildcards
           "All Files ("ALLFILES_RE")",
           OFN_SAVEAS|OFN_DELAYFILELIST|OFN_KEEPOLDFILE,
           '',      // Default extensions
           '',      // Initial filename
           '',          // Initial directory
           'write_list', // Retrieve name
           'write list dialog box'  // Help item
           )
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      _macro('m',_macro('s'))
      _macro_call('write',result);
      params=result;
   }
   filename=parse_file(params)
   load_files '+c +t 'filename
   if ( rc ) {
      return(rc)
   }
   _delete_line
   if ( params=='' ) {
      params='%f'
   }
   _prev_view
   top
   search '^>','r'
   if ( rc ) {
      message nls('Select file(s) first.')
      _next_view;_delete_buffer;_quit_view
      return(1)
   }
   for (;;) {
      if ( rc ) {
         break
      }
      get_line line
      _next_view
      name=pcfile(line)
      if ( name!='.' && name!='..' && ! pos('<DIR>',line)  ) {
         insert_line parsecommand(params,line)
      }
      _prev_view
      repeat_search
   }
   _next_view
   status=save();_delete_buffer;_quit_view
   return(status)

}
_command edit_with() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   command=arg(1)
   filename=parse_file(command)
   status= edit(filename)
   if ( status ) {
      return(status)
   }
   top
   execute(command,"");
   if ( rc==STRING_NOT_FOUND_RC ) {
      rc=0;
   }
   status=rc
   if ( p_modify ) {
      select=nls_letter_prompt(nls('File has been modified.  Save file (~y or ~n)?'))
      if ( select==1 ) {
         status=save()
         if ( status ) {
            return(status)
         }
      }
   }
   if ( ! status ) {
      quit()
   }
   return(status)

}
_str prepeat_search()
{
   repeat_search
   return(rc)

}
_str psearch(string,options)
{
   search string,options
   return(rc)

}
zap_line()
{
   p=point()
   _delete_line;
   if ( p==point() ) { /* On same line number? */
      /* Got to end of previous line. */
      up
   }
   _end_line
   return(0)

}
defeventtab _fmulsrch_form
_findok.lbutton_up()
{
   _save_form_response();
   _param1=text1.p_text;
   _param2='';
   if (_findcase.p_value) {
      _param2='E';
   } else {
      _param2='I';
   }
   if (_findword.p_value) {
      _param2=_param2:+'W';
   }
   if (_findre.p_value) {
      _param2=_param2:+'R';
   }
   p_active_form._delete_window(0);
}
_findok.on_create()
{
   _retrieve_prev_form();
}
_command unlist_search() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   arg1=arg(1);
   arg3=arg(3);
   if (arg3=='') arg3='I';
   if (arg1=='') {
      _macro_delete_line();
      result=show('-modal _fmulsrch_form');
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      arg1=_param1;arg3=_param2;
      _macro('m',_macro('s'))
      _macro_call('process_list','psearch',arg1,arg3,'prepeat-search','zap-line')
   }
   status=process_list('psearch',arg1,arg3,'prepeat-search','zap-line');
   return(status);
}
_command unlist_all() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   mark=_alloc_selection();
   if ( mark<0 ) {
      return(mark)
   }
   top;_select_line mark
   bottom;_select_line mark
   _delete_selection mark
   _free_selection mark
   _begin_line;p_modify=0
   return(0)

}
_command void unlist_select() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   column_process_list(1,1,'^>','zap-line','r')
}
_command gui_unlist_ext() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   _macro_delete_line();
   result = show('-modal _textbox_form',
                 'Unlist Extension',             //Captions
                 TB_RETRIEVE_INIT,               //Flags
                 '',                             //use default textbox width
                 'gui_unlist_ext',               //Help item
                 '',                             //Font(no support yet)
                 'unlist_ext',                   //Retrieve Name
                 'Unlist files with extension'   //Prompt
                 );
   if (result == '') {
      return(COMMAND_CANCELLED_RC);
   }
   result=_param1;
   _macro('m',_macro('s'))
   _macro_call('unlist_ext',result)
   return(unlist_ext(result))
}
_command unlist_ext() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   arg1=arg(1)
   if (substr(arg1,1,1)=='.') arg1=substr(arg1,2);
   if ( arg1=='<' ) {
      arg1=prompt()
   }
   if ( arg1=='' ) {
      //search_string='(\\|\:)([~.\[\]\:\\/<>|=+;, \t]#)$'
#if __PCDOS__
      sep1='(\\|\:)'
      sep2='\\'
#elif __UNIX__
      sep1='//'
      sep2='//'
#else
      sep1='\:'
      sep2='\:'
#endif
      sep='\'FILESEP
      search_string=sep1'[~.'sep1']*$'
   } else {
      search_string='.'arg1'$'
   }
   status=column_process_list(DIR_FILE_COL,255-DIR_FILE_COL,
                            search_string,'zap_line','r'_fpos_case)
   return(status);
}
_command unlist_attr() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   _macro_delete_line();
   result=arg(1)
   if (result=='') {
#if __UNIX__
      result=show('-modal _unixfmattr_form',nls('Unlist Files With Attribute'),'unlist_attr',
          nls("?Deletes lines in file list of files with read/write permissions matching the attributes specified."));
#else
      result=show('-modal _fmattr_form',nls('Unlist Files With Permissions'),'unlist_attr',
          nls("?Deletes lines in file list of files with Read Only, Hidden, System, and Archive attributes matching the attributes specified."));
#endif
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      result=_param1;
   }
   _macro('m',_macro('s'))
   _macro_call('unlist_attr',result)
   status=column_process_list(DIR_ATTR_COL,DIR_ATTR_WIDTH,
                            attr_case(result),'zap-line','r')
   return(status);
}
_command void fileman_select_all() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   select_all();
}
_command void select_all() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_TEXT_BOX|VSARG2_READ_ONLY)
{
   if (command_state()) {
      _set_sel(1,length(p_text)+1);
      return;
   }
   if (_modename_eq(p_mode_name,'fileman')) {
      set_select('>')
   } else {
      //save_pos(p);

      top;deselect();
      if (_on_line0()) {
         return;
      }
      if ( def_persistent_select=='Y' ) {
         mstyle='EP'
      } else {
         mstyle='E'
      }
      if ( _select_type()=='' ) {
         status=_select_line('',mstyle);
         if (status) {
            message get_message(status);
            return;
         }
      }
      bottom;
      status=_select_line('',mstyle);
   }
}
_command void deselect_all() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   set_select(' ')
}
void set_select(ch)
{
   top
   for (;;) {
      get_line line
      replace_line ch:+substr(line,2)
      down
      if ( rc ) {
         break
      }
   }

}
_command void select_mark() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL|VSARG2_MARK)
{
   set_mark_select('>');
}
_command void deselect_mark() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL|VSARG2_MARK)
{
   set_mark_select(' ');

}
void set_mark_select(ch)
{
   _get_selinfo(first_col,last_col,buf_id);
   if ( rc || buf_id!=p_buf_id ) {
      message  get_message(TEXT_NOT_SELECTED_RC)
      return;
   }
   _begin_select
   for (;;) {
      get_line(line);
      replace_line(ch:+substr(line,2));
      down();
      if ( rc || _end_select_compare()>0 ) {
         break
      }
   }

}
_command void select_reverse() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   top
   for (;;) {
      get_line line
      if ( substr(line,1,1)=='>' ) {
         replace_line ' ':+substr(line,2)
      } else {
         replace_line '>':+substr(line,2)
      }
      down
      if ( rc ) {
         break
      }
   }

}
_command gui_select_ext() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   _macro_delete_line();
   result = show('-modal _textbox_form',
                 'Select Extension',             //Captions
                 TB_RETRIEVE_INIT,               //Flags
                 '',                             //use default textbox width
                 'gui_select_ext',               //Help item
                 '',                             //Font(no support yet)
                 'select_ext',                   //Retrieve Name
                 'Select files with extension'   //Prompt
                 );
   if (result == '') {
      return(COMMAND_CANCELLED_RC);
   }
   result=_param1;
   _macro('m',_macro('s'))
   _macro_call('select_ext',result)
   return(select_ext(result))
}
/*
_command void select_ext()
{
   arg1=arg(1)
   if (substr(arg1,1,1)=='.') arg1=substr(arg1,2);
   if ( arg1=='<' ) {
      arg1=prompt()
   }
   if ( arg1=='' ) {
      //search_string='(\\|\:)([~.\[\]\:\\/<>|=+;, \t]#)$'
#if __PCDOS__
      sep1='(\\|\:)'
      sep2='\\'
#elif __UNIX__
      sep1='//'
      sep2='//'
#else
      sep1='\:'
      sep2='\:'
#endif
      sep='\'FILESEP
      search_string=sep1'[~.'sep1']*$'
   } else {
      search_string='.'arg1'$'
   }
   column_process_list(DIR_FILE_COL,255-DIR_FILE_COL,
                            search_string,'_fselect_line','r'_fpos_case)

}
*/
_command void select_ext() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   // Go thru the list of extensions:
   extensions = arg(1);
   while (1) {
      parse extensions with arg1 extensions;
      if (arg1 == "") break;
      if (substr(arg1,1,1)=='.') arg1=substr(arg1,2);
      if ( arg1=='<' ) {
         arg1=prompt()
      }
      if ( arg1=='' ) {
         //search_string='(\\|\:)([~.\[\]\:\\/<>|=+;, \t]#)$'
   #if __PCDOS__
         sep1='(\\|\:)'
         sep2='\\'
   #elif __UNIX__
         sep1='//'
         sep2='//'
   #else
         sep1='\:'
         sep2='\:'
   #endif
         sep='\'FILESEP
         search_string=sep1'[~.'sep1']*$'
      } else {
         search_string='.'arg1'$'
      }
      column_process_list(DIR_FILE_COL,255-DIR_FILE_COL,
                               search_string,'_fselect_line','r'_fpos_case)
   }
}
_command select_attr() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   _macro_delete_line();
   result=arg(1)
   if (result=='') {
#if __UNIX__
      result=show('-modal _unixfmattr_form',nls('Select Files With Permissions'),'select_attr',nls("?Selects files in the list with read/write permissions which match the permissions specified."));
#else
      result=show('-modal _fmattr_form',nls('Select Files With Attribute'),'select_attr',nls("?Selects files in the list with Read Only, Hidden, System, and Archive attributes which match the attributes specified."));
#endif
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      result=_param1;
   }
   _macro('m',_macro('s'))
   _macro_call('select_attr',result)
   status=column_process_list(DIR_ATTR_COL,DIR_ATTR_WIDTH,
                            attr_case(result),'_fselect_line','r')
   return(status);

}
_str _fselect_line()
{
   get_line line
   replace_line '>':+substr(line,2)
   return(0)
}
/*

   The filemanager uses this function to delete entries from the file
   list and select entries in the file list.

   INPUT

      search_fun        Name of procedure to perform first search.
                        The call looks like this:

                          search_fun(search_string,search_options)

                        Search function must return non zero status
                        if string is not found.  Use a pre-existing
                        search function such as "psearch" if possible.

      search_string     Search string given as argument to search_fun
                        and repeat_search_fun.

      search_options    Options given as argument to search_fun and
                        repeat_search_fun.  The character 'm' must
                        mean searching within a marked area.  The
                        character '*' means perform action without
                        prompting.  By default, the user is prompted
                        with "Yes/No/Last/Go/Quit?" before the action
                        is performed.


      repeat_search_fun Name of procedure to proform subsequent searching.
                        The call looks like this:

                          repeat_search_fun(search_string,search_options)

                        Search function must return non zero status
                        if string is not found.  Use a pre-existing
                        search function such as "psearch" or
                        "prepeat-search" if possible.

      action_fun        Name of procedure which operates on lines.
                        Use a pre-existing action function
                        such as "zap-line" or "_fselect_line" if
                        possible.


  OUTPUT

    *  Returns 0 if successful

*/

_str process_list(search_fun,search_string,search_options,
                     repeat_search_fun,action_fun)
{
   search_index       = find_index(search_fun,PROC_TYPE|COMMAND_TYPE)
   repeat_search_index= find_index(repeat_search_fun,PROC_TYPE|COMMAND_TYPE)
   action_index       = find_index(action_fun,PROC_TYPE|COMMAND_TYPE)
   if ( ! index_callable(search_index) ||
       ! index_callable(repeat_search_index) ||
       ! index_callable(action_index) ) {
     message  'process-list:  'nls('Could not find function')
     return(STRING_NOT_FOUND_RC)
   }
   old_scroll_style=_scroll_style()
   _scroll_style('c')
   msg=nls_strip_chars(nls_chars,"~Yes/~No/~Last/~Go/~Quit ?")
   status=call_index(search_string,search_options,search_index)
   found_one=0
   go=pos('*',search_options);done=0
   for (;;) {
     if ( status ) { break }
     found_one=1
     down
     done=rc    /* last line of file? */
     if ( ! done ) {
       up
     }
     if ( go ) {
       status=call_index(action_index)
     } else {
       message msg
       for (;;) {
          k=upcase(get_event())
          select=pos(k,nls_chars)
          if ( select==1 ) {
            status=call_index(action_index)
            break
          } else if ( select==2 ) {
             down;_begin_line
             break
          } else if ( select==3 ) {
            status=call_index(action_index)
            done=1
            break
          } else if ( select==4 ) {
            go=1;clear_message
            status=call_index(action_index)
            break
          } else if ( select==5 || iscancel(k) ) {
            done=1
            break
          }
       }
     }
     if ( done || status ) {
        if ( done ) { clear_message }
        break
     }
     status=call_index(search_string,search_options,repeat_search_index)
   }
   _scroll_style(old_scroll_style)
   if ( status==0 ) {
     clear_message
   }
   if ( found_one && status==STRING_NOT_FOUND_RC ) {
     clear_message
     status=0
   }
   return(status)



/*
File Attribute         ; return select-attr   ;popup-help select-attr command
File extension         ; return select-ext    ;popup-help select-ext  command
   unlist-ext */

}
_str column_process_list(first_col,col_width,search_string,action_fun)
{
   old_mark=_duplicate_selection('')   /* save activae mark id. */
   mark=_alloc_selection()
   if ( mark<0 ) {
      return(mark);
   }
   bottom;p_col=first_col+col_width-1;_select_block mark
   top   ;p_col=first_col;_select_block mark;
   _show_selection mark
   repeat_search_fun='prepeat-search'
   if ( first_col==1 && action_fun:=='zap-line' ) {
      repeat_search_fun='psearch'
   }
   process_list('psearch',search_string,'*m'arg(5),repeat_search_fun,action_fun)
   _show_selection old_mark
   _free_selection mark
   return(0)

}
defeventtab _fmreplace_form
_replaceok.lbutton_up()
{
   _save_form_response();
   _param1=_findstring.p_text;
   options='';
   if (_findcase.p_value) {
      options='E';
   } else {
      options='I';
   }
   if (_findword.p_value) {
      options=options:+'W';
   }
   if (_findre.p_value) {
      options=options:+'R';
   }
   if (_findcursorend.p_value) {
      options=options:+'>';
   }
   _param2=_replacestring.p_text;
   _param3=options;
   p_active_form._delete_window(0);
}
_replaceok.on_create()
{
   _retrieve_prev_form();
}
_command fileman_replace() name_info(','VSARG2_REQUIRES_FILEMAN_MODE|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   _macro_delete_line()
   search_string=arg(1);
   replace_string=arg(2);
   options=arg(3);
   if (search_string=='') {
      result=show('-modal _fmreplace_form');
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      _macro('m',_macro('s'))
      search_string=_param1;
      replace_string=_param2;
      options=_param3;
   }
   orig_wid=p_window_id;
   orig_buf_id=p_buf_id;
   atbuflist=_lbmulti_select_result('','','1');
   if (atbuflist=='') {
      _message_box('No files selected');
      return(1);
   }
   _macro_call('fileman_replace',search_string,replace_string,options);
   status=_mfreplace(search_string,replace_string,options,'',atbuflist);
   last_file=rc;
   if (last_file!='') {
      new_wid=p_window_id;
      new_buf_id=p_buf_id;
      p_window_id=orig_wid;
      p_buf_id=orig_buf_id;
      // Position cursor in file manager list where user aborted
      save_pos(p);
      top();
      status=search(last_file,_fpos_case);
      for (;;) {
         if (status) break;
         if (p_col==DIR_FILE_COL) break;  // Found it
         status=repeat_search();
      }
      if (status) restore_pos(p);
      p_window_id=new_wid;
      p_buf_id=new_buf_id;
   }
   return(status);
}
static _str find_search_delim(var ch,search_string,replace_string)
{
   status=1
   for (i=0; i<=27 ; ++i) {
      ch=_chr(i)
      if ( pos(ch,search_string) ) {
         continue
      }
      if ( pos(ch,replace_string) ) {
         continue
      }
      status=0
      break
   }
   return(status)
}
#if !__UNIX__
defeventtab _fmattr_form
_fmok.on_create()
{
   p_active_form.p_help=arg(3);
   if (arg(1)!='') {
      p_active_form.p_caption=arg(1);
      p_active_form.p_name=arg(2);
   } else {
      _fmddont_care.p_enabled=0;
      _fmdon.p_enabled=0;
      _fmdoff.p_enabled=0;
   }
   _retrieve_prev_form();
}
_fmok.lbutton_up()
{
   _param1='';   // unlist-attr results
   _param2='+';  // +attr results
   _param3='-';  // -attr results

   if (_fmrdont_care.p_value) {
      _param1=_param1:+'?';
   } else if (_fmron.p_value) {
      _param1=_param1:+'R';
      _param2=_param2:+'R';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+'R';
   }
   if (_fmhdont_care.p_value) {
      _param1=_param1:+'?';
   } else if (_fmhon.p_value) {
      _param1=_param1:+'H';
      _param2=_param2:+'H';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+'H';
   }
   if (_fmsdont_care.p_value) {
      _param1=_param1:+'?';
   } else if (_fmson.p_value) {
      _param1=_param1:+'S';
      _param2=_param2:+'S';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+'S';
   }
   if (_fmddont_care.p_value) {
      _param1=_param1:+'?';
   } else if (_fmdon.p_value) {
      _param1=_param1:+'D';
      _param2=_param2:+'D';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+'D';
   }
   if (_fmadont_care.p_value) {
      _param1=_param1:+'?';
   } else if (_fmaon.p_value) {
      _param1=_param1:+'A';
      _param2=_param2:+'A';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+'A';
   }
   _save_form_response();
   p_active_form._delete_window(1);
}
#endif
#if __UNIX__
defeventtab _unixfmattr_form
_fmok.on_create()
{
   p_active_form.p_help=arg(3);
   if (arg(1)!='') {
      p_active_form.p_caption=arg(1);
      p_active_form.p_name=arg(2);
   } else {
      ctldir.p_enabled=0;
   }
   _retrieve_prev_form();
}
_fmok.lbutton_up()
{
   _param1='';   // unlist-attr results
   _param2='';  // +attr results
   _param3='';  // -attr results


   if (ctldir.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctldir.p_value) {
      _param1=_param1:+'d';
   } else {
      _param1=_param1:+'-';
   }
   if (ctluserread.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctluserread.p_value) {
      _param1=_param1:+'r';
      _param2=_param2' u+r';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+' u-r';
   }
   if (ctluserwrite.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctluserwrite.p_value) {
      _param1=_param1:+'w';
      _param2=_param2' u+w';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+' u-w';
   }
   if (ctluserexec.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctluserexec.p_value) {
      _param1=_param1:+'x';
      _param2=_param2' u+x';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+' u-x';
   }


   if (ctlgroupread.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctlgroupread.p_value) {
      _param1=_param1:+'r';
      _param2=_param2' g+r';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+' g-r';
   }
   if (ctlgroupwrite.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctlgroupwrite.p_value) {
      _param1=_param1:+'w';
      _param2=_param2' g+w';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+' g-w';
   }
   if (ctlgroupexec.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctlgroupexec.p_value) {
      _param1=_param1:+'x';
      _param2=_param2' g+x';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+' g-x';
   }

   if (ctlotherread.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctlotherread.p_value) {
      _param1=_param1:+'r';
      _param2=_param2' o+r';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+' o-r';
   }
   if (ctlotherwrite.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctlotherwrite.p_value) {
      _param1=_param1:+'w';
      _param2=_param2' o+w';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+' o-w';
   }
   if (ctlotherexec.p_value==2) {
      _param1=_param1:+'?';
   } else if (ctlotherexec.p_value) {
      _param1=_param1:+'x';
      _param2=_param2' o+x';
   } else {
      _param1=_param1:+'-';
      _param3=_param3:+' o-x';
   }


   _save_form_response();
   p_active_form._delete_window(1);
}
#endif
