#pragma option(redeclvars,on)
/*
  cmdline commands          gui commands
--------------------------------------------
  reverse_regex_search      gui_find_backward_regex
  regex_search              gui_find_regex
  query_replace             gui_replace
  replace_string            gui_replace_go
  regex_replace             gui_replace_regex

  prompt_load               gui_load
  prompt_cd                 gui_cd
  set_var                   gui_set_var

  visit_file                gui_visit_file
  goto_tag                  gui_push_tag
  prompt_dir                fileman
  goto_line                 gui_goto_line
  get                       gui_insert_file
  put                       gui_write_selection
  make_tags                 gui_make_tags
  edit                      gui_open
  bind_to_key               gui_bind_to_key
  save_macro                gui_save_macro
*/

defeventtab default_keys
def '*'=rexx_star
//Remove VI key bindings
def 'c-6'=
def 'c-2'=
def 'c-['=
def  '}'=

def 'C-LBUTTON-DOWN'=mou_gnu_track_insert
def on_drop_files=_on_drop_files
def on_vsb_page_down=_sb_page_down
def on_vsb_page_up=_sb_page_up
def on_vsb_top=top_of_buffer
def on_vsb_bottom=bottom_of_buffer
def on_vsb_line_down=fast_scroll
def on_vsb_line_up=fast_scroll
def on_vsb_thumb_pos=_vsb_thumb_pos
def on_vsb_thumb_track=_vsb_thumb_pos

def on_sb_end_scroll=fast_scroll
def on_hsb_line_down=fast_scroll
def on_hsb_line_up=fast_scroll
def on_hsb_top=scroll_begin_line
def on_hsb_bottom=scroll_end_line
def on_hsb_page_down=_sb_page_right
def on_hsb_page_up=_sb_page_left
def on_hsb_thumb_pos=_hsb_thumb_pos
def on_hsb_thumb_track=_hsb_thumb_pos

def on_resize=_on_resize
def on_close=_on_close

//def rbutton_down=mou_split_window
def 'c-ins'=copy_to_clipboard
def 's-del'=cut
def 's-ins'=paste
def 's-left'=cua_select
def 's-right'=cua_select
def 's-up'=cua_select
def 's-down'=cua_select
def 's-home'=cua_select
def 's-end'=cua_select
def 's-pgdn'=cua_select
def 's-pgup'=cua_select
def 's-c-home'=cua_select
def 's-c-end'=cua_select
def 's-c-left'=cua_select
def 's-c-right'=cua_select
def lbutton_down=mou_click
def lbutton_double_click=mou_select_word
def lbutton_triple_click=mou_select_line
// Removed to support Microsoft IntelliMouse
//def mbutton_down=mou_paste
def 's-lbutton_down'=mou_extend_selection
def  'on_select'=_on_select

// These commands are too important to be overriden
// by the other commands
def 'c-s-,'=complete_prev
def 'c-s-.'=complete_next
//def  'C-S-.'= mark_end_of_buffer
//def  'C-S-,'= mark_beginning_of_buffer

def  'a-f6'=
def  'C- '=expand_alias
def  'a-backspace'= cut_prev_word
def  'C-F4'= close_window
def  'C-F6'= next_window
def  'C-S-F6'= prev_window
def  'C-S-F8'= next_buffer
def  'A-F4'= safe_exit

def  'C-A'= begin_line
def  'C-B'= cursor_left
def  'C-C'= stop_process
def  'C-D'= linewrap_delete_char
def  'C-E'= end_line
def  'C-F'= cursor_right
def  'C-G'= abort
def  'C-H'= gnu_help
def  'C-I'= indent_previous
def  'C-J'= split_insert_line
def  'C-K'= cut_end_line
def  'C-L'= center_line
//def  'C-M'= split_insert_line
def  'C-M'= wh
def  'C-N'= cursor_down
def  'C-O'= split_line
def  'C-P'= cursor_up
def  'C-Q'= quote_key
def  'C-R'= reverse_i_search
def  'C-S'= i_search
def  'C-T'= gnu_transpose_chars
def  'C-U'= argument
def  'C-V'= page_down
def  'C-W'= cut_region
def  'C-Y'= emacs_paste
def  'C-Z'= minmdi
def  'C-['= esc_alt_prefix
def  'C-]'= find_matching_paren
def  'C-^'= ctrl_prefix
def  'C-S-\'= gnu_filter
// This is probably over kill
// undo is every where.
def  'C-_'= undo_cursor
def  'C-/'= undo
def  'C-.'= push_tag
def  'C-,'= pop_bookmark
def  'C-='= diff
def  'C-S-2'= emacs_select_char
def  ' '= maybe_complete
def  ')'= keyin_match_paren
def  '?'= maybe_list_matches
def  'C-2'= emacs_select_char
def  'S- '= keyin_space
def  'C-0'-'C-9'= gnu_ctrl_argument
def  'C-A-B'= prev_level
def  'C-A-F'= next_level
def  'C-A-H'= cut_prev_word
def  'C-A-K'= cut_level
def  'C-A-R'= reverse_regex_search
def  'C-A-S'= regex_search
def  'C-A-W'= append_next_cut
def  'C-A-\'= indent_region
def  'C-A-^'= ctrl_prefix

def  'A-!'= shell_command
def  'A-@'= select_next_word
def  'A-$'= spell_check_word

def  'A-%'= query_replace
def  'A-&'= replace_string
def  'A-)'= find_delimiter
def  'A-*'= regex_replace
def  'A--'= alt_argument

// Emacs users will probably not mind losing
// there bindings for these powerful commands
def 'a-.'=list_symbols
def 'a-,'=function_argument_help

//def  'A-,'= pop_bookmark     //Also Bound to C-,
//def  'A-.'= push_tag         //Also Bound to C-.
def  'A-0'-'A-9'= gnu_alt_argument
def  'A-<'= top_of_buffer
def  'A-='= count_lines_region
def  'A->'= bottom_of_buffer
def  'A-?'= help
def  'A-|'= gnu_filter
def  'A-{'= prev_paragraph
def  'A-\'= gnu_delete_space
def  'A-}'= next_paragraph
def  'A-~'= modify_toggle
def  'A-a'= prev_sentence
def  'A-b'= prev_word
def  'A-c'= cap_word
def  'A-d'= cut_word
def  'A-e'= next_sentence
def  'A-f'= next_word
def  'A-g'= gui_goto_line
def  'A-h'= select_paragraph
def  'A-i'= move_text_tab
def  'A-j'= split_insert_line
def  'A-k'= cut_sentence
def  'A-l'= lowcase_selection
//def  'A-l'= gnu_lowcase_word
def  'A-m'= first_non_blank
def  'A-n'= keyin_buf_name
def  'A-o'= overlay_block_selection
def  'A-p'= config
def  'A-q'= reflow_paragraph
def  'A-r'= move_window_line
def  'A-s'= center_within_margins
def  'A-t'= gnu_transpose_words
def  'A-u'= cap_word
def  'A-v'= page_up
def  'A-w'= copy_region
def  'A-x'= cmdline_toggle
def  'A-y'= list_clipboards
// Nice command but list_clipboards is more user friendly
//def  'A-y'= enum_paste
def  'A-z'= zap_to_char
def  'A-S'= center_paragraph
def  'A-~'= modify_toggle
def  'A-^'= join_line
def  'ENTER'= split_insert_line
//def  'TAB'= tab
def  'TAB'= move_text_tab
def  'ESC'= esc_alt_prefix
def  'BACKSPACE'= linewrap_rubout
def  'HOME'= begin_line
def  'END'= end_line
def  'LEFT'= cursor_left
def  'RIGHT'= cursor_right
def  'UP'= cursor_up
def  'DOWN'= cursor_down
def  'PAD-5'= center_line
def  'PGUP'= page_up
def  'PGDN'= page_down
def  'DEL'= linewrap_delete_char
def  'INS'= insert_toggle
def  'A-PAD-MINUS'= alt_argument
def  'A-LEFT'= prev_word
def  'A-RIGHT'= next_word
def  'A-UP'= prev_paragraph
def  'A-DOWN'= next_paragraph
def  'A-PGUP'= page_up_next_window
def  'A-PGDN'= page_down_next_window
def  'A-DEL'= delete_prev_word
def  'A-HOME'= home_next_window
def  'A-END'= end_next_window
def  'C-ENTER'= split_insert_line
def  'C-TAB'= next_window
def  'C-BACKSPACE'= cut_prev_word
def  'C-HOME'= top_of_buffer
def  'C-END'= bottom_of_buffer
def  'C-LEFT'= prev_word
def  'C-RIGHT'= next_word
def  'C-UP'= prev_sentence
def  'C-DOWN'= next_sentence
def  'C-PGUP'= expand_window
def  'C-PGDN'= shrink_window
def  'S-TAB'= cbacktab
def  'F1'= help
def  'F2'= cmdline_toggle
def  'F3'= prompt_load
def  'F4'= bind_to_key
def  'F5'= where_is
def  'F6'= what_is
def  'F7'= prompt_cd
def  'F8'= set_var
def  'F9'= undo
def  'F10'=
def  'F11' = select_line
def  'F12'= load
def  'S-F1'= scroll_up
def  'S-F2'= scroll_down
def  'S-F3'= scroll_left
def  'S-F4'= scroll_right
def  'S-F5'= center_line
def  'S-F6'= resync
def  'S-F7'= shift_selection_left
def  'S-F8'= shift_selection_right
def  'S-F9'= redo
def  'S-F10'= project_compile
def  'A-F1'= api_index
def  'A-F2'= move_edge
def  'A-F3'= create_tile
def  'A-F4'= safe_exit
def  'A-F5'= project_build
def  'A-F6'= project_compile
def  'A-F7'= move_mdi
def  'A-F8'= prev_buffer
def  'A-F9'= redo
def  'A-F10'= next_error
def  'A-F11'= deselect
def  'A-F12'= quit
def  'C-F1'= upcase_selection
def  'C-F2'= compare
def  'C-F3'= save_config
def  'C-F4'= lowcase_selection
def  'C-F5'= project_build
def  'C-F6'= project_compile
def  'C-F7'= copy_to_file
def  'C-F8'= set_var
def  'C-F9'= undo_cursor
def  'C-F10'= resync
def  'C-F11'= record_macro_toggle
def  'C-F12'= record_macro_end_execute
def  'C-X' '/'= alias_cd
def  'C-X' 'C-A'= copy_word
def  'C-X' 'C-B'= list_buffers
def  'C-X' 'C-C'= safe_exit
def  'C-X' 'C-D'= prompt_dir
def  'C-X' 'C-E'= dos
def  'C-X' 'C-F'= edit
def  'C-X' 'C-H'= pop_bookmark
def  'C-X' 'C-I'= indent_rigidly
//def  'C-X' 'C-J'= bottom_of_buffer
def  'C-X' 'C-J'= dir
def  'C-X' 'C-L'= lowcase_selection
def  'C-X' 'C-M'= start_process
def  'C-X' 'C-N'= next_error
def  'C-X' 'C-O'= delete_blank_lines
def  'C-X' 'C-P'= mark_whole_buffer
def  'C-X' 'C-R'= find_file_read_only
def  'C-X' 'C-S'= save
def  'C-X' 'C-T'= transpose_lines
def  'C-X' 'C-U'= upcase_selection
def  'C-X' 'C-V'= visit_file
def  'C-X' 'C-W'= save_as
def  'C-X' 'C-X'= exchange_point_and_mark
def  'C-X' 'C-Y'= list_clipboards
//def  'C-X' 'C-Z'= resume
def  'C-X' 'C-Z'= minmdi
def  'C-X' 'C-^'= ctrl_prefix
//def  'C-X' 'C-['= alt_prefix
def  'C-X' 'C-['= page_up
def  'C-X' 'C-]'= page_down
def  'C-X' 'A-ESC' = last_command
def  'C-X' 'C-A-[' = last_command
def  'C-X' '/'= alias_cd
def  'C-X' '('= record_macro_toggle
def  'C-X' ')'= end_recording
def  'C-C' 'C'= stop_process
def  'C-C' '{'= shrink_window_vertically
def  'C-C' '}'= enlarge_window_vertically
def  'C-U' 'A-.'= push_tag
def  'C-U' '-' 'A-.'= pop_bookmark
def  'C-X' '+'= balance_windows
def  'C-X' '-'= shrink_window_if_larger_than_buffer
def  'C-X' '^'= enlarge_window
def  'C-X' ','= push_tag
def  'C-X' "'"= next_error
def  'C-X' '.'= gnu_goto_tag
def  'C-X' '0'= kill_window
def  'C-X' '1'= one_window
def  'C-X' '2'= hsplit_window
def  'C-X' '3'= vsplit_window
def  'C-X' '4' 'C-F'= edit_other_window
def  'C-X' '4' 'C-J'= dir_other_window
def  'C-X' '4' '.'= find_other_tag
def  'C-X' '4' 'b'= switch_other_buffer
def  'C-X' '4' 'd'= prompt_other_dir
def  'C-X' '4' 'f'= edit_other_window
def  'C-X' '4' 'r'= find_file_other_read_only
def  'C-X' '4' 'ENTER'= dir_other_window
def  'C-X' '5'= vsplit_window
def  'C-X' '6' '2'= vsplit_window
def  'C-X' 'r' 'd'= delete_selection
def  'C-X' 'r' 'k'= gnu_kill_rectangle
def  'C-X' 'r' 'l'= goto_bookmark
def  'C-X' 'r' 'o'= gnu_indent_selection
def  'C-X' 'r' 'y'= gnu_yank_rectangle
def  'C-X' '<'= scroll_left
def  'C-X' '>'= scroll_right
//def  'C-X' '='= show_point
def  'C-X' '='= what_cursor_position
def  'C-X' 'A'-'Z'= case_indirect
def  'C-X' 'b'= select_buffer
def  'C-X' 'c'= compare
def  'C-X' 'd'= prompt_dir
def  'C-X' 'e'= last_macro
def  'C-X' 'f'= margins
def  'C-X' 'g'= goto_line
def  'C-X' 'h'= mark_whole_buffer
def  'C-X' 'i'= get
def  'C-X' 'k'= emacs_quit
def  'C-X' 'l'= count_lines
def  'C-X' 'm'= project_build
def  'C-X' 'n'-'o'= next_window
def  'C-X' 'p'= prev_window
//def  'C-X' 'r'= redo  This is bound to an event table.

// This is different but better than GNU Emacs
def  'C-X' 's'= list_modified
//def  'c-x' 's'=gnu_save_some_buffers

def  'C-X' 'u'= undo
def  'C-X' 'w'= put
def  'C-X' 'C-A-I'= tabify_region
def  'C-X' 'C-A-^'= ctrl_prefix
def  'C-X' 'A-,'= select_tag_file
def  'C-X' 'A-.'= make_tags
def  'C-X' 'A-b'= list_buffers
def  'C-X' 'A-i'= untabify_region
def  'C-X' 'A-n'= save_macro
def  'C-X' 'ENTER'= start_process
def  'C-X' 'TAB'= indent_rigidly
def  'C-X' 'S-TAB'= move_text_backtab

def  'C-S-B'= list_buffers
def  'C-S-C'= append_to_clipboard
def  'C-S-E'= list_errors
def  'C-S-H'= hex
def  'C-S-I'= reverse_i_search
def  'C-S-J'= goto_bookmark
def  'C-S-K'= cut_word
def  'C-S-L'= lowcase_selection
def  'C-S-M'= start_process
def  'C-S-N'= next_window
def  'C-S-P'= prev_window
def  'C-S-R'= my_refresh
def  'C-S-S'= set_next_error
def  'C-S-U'= upcase_selection
def  'C-S-V'= list_clipboards
def  'C-S-W'= prev_window
def  'C-S-X'= append_cut
def  'C-S-Y'= paste_replace_word
def  'C-S-,'= mark_beginning_of_buffer
def  'C-S-.'= mark_end_of_buffer
def  'C-S-TAB'= prev_window
def  'C-S-HOME'= cua_select
def  'C-S-END'= cua_select
def  'C-S-LEFT'= cua_select
def  'C-S-RIGHT'= cua_select
def  'C-S-UP'= prev_error
def  'C-S-DOWN'= next_error
//def  FKEYTEXT = nls("F1=Help F2=Cmd F3=Load F4=Bind F5=Wher  F6=What F7=Cd F8=SetVar F9=Undo F10=Menu")

defeventtab c_keys
def 'C-I'= gnu_ctab
def 'TAB'= gnu_ctab
def  ' '= c_space
def  '('= auto_functionhelp_key
def  '.'= auto_codehelp_key
def 'C- '=codehelp_complete
def  ':'= c_colon
def  '<'= auto_functionhelp_key
def  '>'= auto_codehelp_key
def  '{'= c_begin
def  '}'= c_endbrace
def  'ENTER'= c_enter
//def  "A-'"= move_past_close_and_reindent
//def  'A-('= space_paren
//def  'A-;'= c_indent_for_comment
//def  'C-X' ';'= set_comment_column

defeventtab pascal_keys
def  ' '= pascal_space
def  'ENTER'= pascal_enter
def  'n'= pascal_n
def  'N'= pascal_n
def  'd'= pascal_d
def  'D'= pascal_d
def  'y'= pascal_y
def  'Y'= pascal_y

defeventtab slick_keys
def  ' '= slick_space
def  "A-'"= move_past_close_and_reindent
def  '('= auto_functionhelp_key
def  '_'= auto_codehelp_key
def 'C- '=codehelp_complete
def  '{'= c_begin
def  '}'= c_endbrace
def  'C-A-Q'= gnu_c_rendent_selection
def  'ENTER'= slick_enter
def  'TAB'= gnu_ctab

defeventtab html_keys
def  'TAB'= gnu_html_tab

defeventtab fileman_keys
//def  'C-['-'C-_'= maybe_normal_character
def  ' '= fileman_space
def  '!'= gnu_fileman_shell
def  '"'-'b'= maybe_normal_character
def  'c'= gnu_fileman_copy
def  'd'-'f'= maybe_normal_character
def  'h'-'j'= maybe_normal_character
def  'k'= gnu_unlist_select
def  'l'= gnu_fileman_refresh
def  'm'-'r'= maybe_normal_character
def  's'= gnu_fsort
def  't'-''= maybe_normal_character
def  'a-A'= select_all
def  'a-B'= fileman_backup
def  'a-C'= fileman_copy
def  'a-D'= fileman_delete
def  'a-E'= fileman_edit
def  'a-G'= fileman_replace
def  'a-M'= fileman_move
def  'a-N'= fileman_keyin_name
def  'a-O'= fsort
def  'a-R'= for_select
def  'a-T'= fileman_attr
def  'ENTER'= fileman_enter
def  'lbutton-double-click'=fileman_enter
def  'S-UP'= fileman_select_up
def  'S-DOWN'= fileman_select_down
def  'S-PGUP'= fileman_deselect_up
def  'S-PGDN'= fileman_deselect_down
def  'F1'= fileman_help

defeventtab process_keys
def  'C-U'=
def  'C-A'= process_begin_line
def  'C-H'= process_rubout
def  'C-U'= argument
def  'ENTER'= process_enter
def  'BACKSPACE'= process_rubout
def  'HOME'= process_begin_line
def  'UP'= process_up
def  'DOWN'= process_down
def  'lbutton-double-click'=cursor_error


#include 'slick.sh'
  typeless def_gui;
  typeless def_keys;

  typeless def_alt_menu;
  typeless def_preplace;
  typeless def_buflist;

  typeless def_deselect_paste;
  typeless def_persistent_select;
  typeless def_advanced_select;
  typeless def_select_style;

  typeless def_updown_col;
  typeless def_hack_tabs;
  typeless def_line_insert;

  typeless def_next_word_style;
  typeless def_top_bottom_style;
  typeless def_linewrap;
  typeless def_cursorwrap;
  typeless def_jmp_on_tab;
  typeless def_pull;

  // Operate on current word starting from cursor.
  typeless def_from_cursor;
  typeless def_word_delim;
  typeless def_restore_cursor;
  typeless def_modal_tab;
  typeless def_one_file;
  typeless def_leave_selected;
  typeless def_click_past_end;
  boolean def_word_continue;

defmain()
{
   def_switchbuf_cd=true;
  _config_modify|=CFGMODIFY_OPTION|CFGMODIFY_KEYS;
  def_process_tab_output=0;
  def_click_past_end=0;
  def_gui=0;
  def_keys = 'gnuemacs-keys';

  def_alt_menu=0;
  def_preplace=0;
  def_buflist=3;

  def_deselect_paste=1;
  def_persistent_select='N';
  def_advanced_select='P';
  def_select_style = 'CN';
  def_scursor_style=0;

  def_updown_col=1;
  def_hack_tabs=1;
  def_line_insert = 'A';

  def_next_word_style = 'E';
  def_top_bottom_style = '0';
  def_linewrap = '0';
  def_cursorwrap= '1';
  def_jmp_on_tab = '1';
  def_pull = '0';

  // Operate on current word starting from cursor.
  def_from_cursor = '1';
  def_word_delim = '0';
  def_restore_cursor = '1';
  def_modal_tab = 0;
  if (_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_ONE_FILE_PER_WINDOW) {
     def_one_file='';
  }
  def_leave_selected=0;
  def_word_continue=true;

  replace_def_data("def-setup-fundamental","MN=Fundamental,TABS=+8,MA=1 74 1,KEYTAB=,WW=1,IWT=1,ST=0,");
  replace_def_data("def-setup-process","MN=Process,TABS=+8,MA=1 74 1,KEYTAB=process-keys,WW=1,IWT=1,ST=0,");
  replace_def_data("def-setup-c","MN=C,TABS=+8,MA=1 74 1,KEYTAB=c-keys,WW=1,IWT=1,ST=0,");
  replace_def_data("def-setup-h","@c");
  replace_def_data("def-setup-cpp","@c");
  replace_def_data("def-setup-cxx","@c");
  replace_def_data("def-setup-pas","MN=Pascal,TABS=+8,MA=1 74 1,KEYTAB=pascal-keys,WW=1,IWT=1,ST=0,");
  replace_def_data("def-setup-sh","@e");
  replace_def_data("def-begin-end-pas","(begin),(case)|(end);I");
  replace_def_data("def-begin-end-c","(#ifdef),(#ifndef),(#if)|(#endif)");
  replace_def_data("def-options-c","4 1 1 0 4 1 1");
  replace_def_data("def-options-pas","3 1 1 0 0 1 0");
  replace_def_data("def-options-e","3 1 1 0 4 1 0");
  replace_def_data("def-setup-e","MN=Slick-C,TABS=+3,MA=1 74 1,KEYTAB=slick-keys,WW=1,IWT=0,ST=0,");
  replace_def_data("def-begin-end-e","(#if)|(#endif) (loop)|(endloop) (for)|(endfor) (do)|(end) (while)|(endwhile) (if)|(endif);I");
  replace_def_data("def-begin-end-asm","(proc)|(endp) (macro)|(endm);I");
  replace_def_data("def-setup-asm","MN=Assembly,TABS=+8,MA=1 74,KEYTAB=,WW=1,IWT=1,ST=0,");
  replace_def_data("def-options-java","4 1 1 0 4 1 1");
  replace_def_data("def-setup-java",'MN=Java,TABS=+8,MA=1 74 1,KEYTAB=c-keys,WW=1,IWT=1,ST=0,IN=2,WC=A-Za-z0-9_$,LN=java,CF=1,');
  //replace_def_data("def-setup-jav","@java");
  replace_def_data("def-setup-s","MN=Assembly,TABS=+8,MA=1 74,KEYTAB=,WW=1,IWT=1,ST=0,");
  replace_def_data("def-setup-bourneshell",'MN=Bourne Shell,TABS=+8,MA=1 74 1,KEYTAB=ext_keys,WW=1,IWT=1,ST=0,IN=2,WC=A-Za-z0-9_$,LN=Bourne Shell,CF=1,LNL=0,');
  replace_def_data("def-options-bourneshell",'3 1 1 0 0 3 0');
  replace_def_data("def-options-csh",'3 1 1 0 0 3 0');
  replace_def_data("def-setup-csh",'MN=C Shell,TABS=+8,MA=1 74 1,KEYTAB=ext_keys,WW=1,IWT=1,ST=0,IN=2,WC=A-Za-z0-9_$,LN=C Shell,CF=1,LNL=0,');

  _scroll_style('S 1');
  _search_case('I');
  _update_sysmenu_bindings();
   menu_mdi_bind_all();
   _default_option('n','');
   def_brief_word=0;
   rc=0;
}
static void replace_def_data(name,info)
{
   index=find_index(name,MISC_TYPE);
   if ( index ) {
      set_name_info(index,info);
   } else {
      insert_name(name,MISC_TYPE,info);
   }

}
