/*
$VerboseHistory: main.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:32a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:31a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:37p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"

_str st_batch_mode=0    /* Used by ST command to indicate DEFMAIN -p option. */
_str _macro_ext;

static _str gconfig_path;
int def_vcpp_version=0;
typeless _argument='';
typeless _arg_complete='';
int def_ctags_flags=2;
boolean def_switchbuf_cd=false;
int def_codehelp_flags=VSCODEHELPFLAG_AUTO_FUNCTION_HELP|VSCODEHELPFLAG_AUTO_LIST_MEMBERS|VSCODEHELPFLAG_RESERVED_ON|
                       VSCODEHELPFLAG_INSERT_OPEN_PAREN|VSCODEHELPFLAG_SPACE_INSERTS_SPACE|
                       VSCODEHELPFLAG_DISPLAY_FUNCTION_COMMENTS|VSCODEHELPFLAG_DISPLAY_MEMBER_COMMENTS;
int def_codehelp_idle=0;  // Are stuff seems pretty fast now
                           // Try this for a while and maybe
                           // back off to 50 milliseconds if
                           // we think its necessary.


//
//  Set initial values for global variables defined in slick.sh
//
_str _help_file_spec=''
   ,def_load_options="-L"
   ,def_save_options="-O"
   ,def_tab_ext=""
   ,def_preload_ext=""
   ,def_select_style="E"
   ,def_persistent_select='Y'
   ,def_advanced_select=''
   ,def_scursor_style=''
   ,def_line_insert="A"
   ,def_exit_process=''
   ,def_user_args=''
   ,_error_file=''
   ,def_keys=''
   ,def_prompt=''
#if __PCDOS__
   ,_fpos_case="I"
#else
   ,_fpos_case=""
#endif
   ,_macro_ext=''
   ,_tag_pass=''
   ,def_file_types=''
   ,def_qmark_complete=''
   ,def_one_file='+w'
   ,def_scroll_speeds='30.0 20.3 10.4 10.6'
   ,def_next_word_style
   ,def_top_bottom_style
   ,def_pmatch_style2=1
   ,def_leave_selected=''
   ,def_gui=''
   ,def_alt_menu=''
   ,def_modal_tab=''
   ,def_wh='vslick.idx'
   ,def_who='%(HELPNDX);cmdref.inf'
   ,def_cua_textbox=''
   ,def_mdi_menu=_MDIMENU
   ,_cur_mdi_menu=_MDIMENU
   ,def_keydisp='L'
   ,def_as_timer_amounts='m1 m1 0'
   ,def_as_directory      // Default directory for AutoSave
   ,def_mffind_style=2
#if __UNIX__
   ,COMPILE_ERROR_FILE="vserrors.tmp"
#else
   ,COMPILE_ERROR_FILE="$errors.tmp"
#endif
   ,def_tprint_cheader="%f"
   ,def_tprint_cfooter="%p"
   /*
   options -->   print_flags,blank_lines_after_header,
                 blank_lines_before_footer,lines_per_page,
                 columns_per_line,linenums_every,
   */
   ,def_tprint_options=(TPRINT_FORM_FEED_AFTER_LAST_PAGE):+
                       ",2,2,60,80,0"
   ,def_tprint_lheader,def_tprint_lfooter
   ,def_tprint_rheader,def_tprint_rfooter
   ,def_tprint_command="lp -c -o nobanner %f"   // Optional command which prints file
   ,def_tprint_filter    // Optional filter to filter buffer text
                         // before printing.
   ,def_tprint_device="/dev/lp0"
   ,def_leading_codes
   ,def_trailing_codes
   //,def_mdibb='_mdibutton_bar_form'    // Name of default button bar
   ,def_max_loadall='1 500'

#if __UNIX__
   _str def_sellist_font='courier,12';
   _str def_jsellist_font='OEM Fixed Font';
#else
   _str def_sellist_font='courier,10';
   _str def_jsellist_font='OEM Fixed Font';
#endif
   //_str def_color_scheme="VSE Default";
   _str def_color_scheme="(init)";
   _str def_embedded_color_scheme="(init)";
_str   def_save_on_compile='1 0'; //0=no save, 1=save current file, 2=save all files
_str _compiler_default; // Default compiler package when create new project.
boolean def_fast_open=0;
int def_tag_cache_size=4000;  // 4 megabytes
int def_tagwin_flags= -1;  // Turn on every thing just incase we add more flags in the next release
int def_proctree_flags= -1;  // Turn on every thing just incase we add more flags in the next release
int def_autotag_flags2=AUTOTAG_ON_SAVE|AUTOTAG_BUFFERS|AUTOTAG_SYMBOLS|AUTOTAG_FILES_PROJECT_ONLY|AUTOTAG_CURRENT_CONTEXT;
int def_pmatch_max_diff = 20000;
int def_updown_col=0;
int def_change_dir=OFN_CHANGEDIR;
boolean def_copy_noselection=true;
boolean def_enter_indent=0;
boolean def_auto_landscape=1;
boolean def_cursorwrap=0;
boolean def_hack_tabs=0;
boolean def_restore_cursor=0;
boolean def_pull=1;
boolean def_jmp_on_tab=1;
boolean def_linewrap=0;
boolean def_reflow_next=0;
boolean def_pmatch_style=0;
boolean def_stay_on_cmdline=0;
boolean def_start_on_cmdline=0;
boolean def_start_on_first=0;
boolean def_exit_file_list=0;
boolean def_delay_filelist=1;
int def_auto_restore=0;
boolean def_deselect_paste=0;
boolean def_ignore_tcase=1;
boolean def_keep_dir=0;
boolean def_from_cursor=0;   // Set to one in EMACS emul. Effects some word functions.
boolean def_unix_expansion=__UNIX__;  // Expand ~ and $ like UNIX shells.
boolean def_process_tab_output=1;  // Default concurrent process output to tab in output toolbar
int def_help_flags=HF_CLOSE;
int def_mouse_menu_style=2;    // MM_MARK_FIRST
boolean def_brief_word=0;
int def_cd=3;
int def_max_filehist=9;
int def_actapp=ACTAPP_AUTORELOADON|ACTAPP_AUTOREADONLY;
int def_vcflags=VCF_SET_READ_ONLY;
int def_as_flags = AS_ASDIR;    // AutoSave flags
int def_restore_flags= RF_CWD|RF_PROJECTFILES;
int def_init_delay=50;
int _display_wid=0;

int def_read_ahead_lines= 500;
int def_clipboards= 15;
int def_max_filepos=200;
int def_compile_flags=COMPILEFLAG_CDB4COMPILE;
int def_max_fhlen=40;      // Maximum length of filenames under menus
int def_err=0;
int _config_modify=0;
int def_mfsearch_init_flags=MFSEARCH_INIT_HISTORY;
int def_exit_flags=EXIT_CONFIG_ALWAYS/*|EXIT_FILES_PROMPT*/;
int def_re_search=UNIXRE_SEARCH;
#if __UNIX__
   boolean def_autoclipboard=1
#else
   boolean def_autoclipboard=0
#endif

boolean _no_mdi_bind_all=0;
boolean def_cfgfiles=1;
boolean def_localsta=1;
int def_max_autosave=500;//Largest file in K to autosave
int def_diff_options=0;  // Passed to DLL. Ignore leading,trailing...
int def_diff_edit_options=DIFF_AUTO_JUMP|DIFF_SHOW_GAUGE|DIFF_START_AT_FIRST_DIFF;
int def_diff_view_options=DIFF_VIEW_DIFFERENT_FILES|DIFF_VIEW_VIEWED_FILES|DIFF_VIEW_MISSING_FILES1|DIFF_VIEW_MISSING_FILES2;
boolean def_dragdrop=true;
int def_seldisp_flags=SELDISP_SHOWPROCCOMMENTS;
int def_seldisp_maxlevel=6;
int def_vcpp_flags=VCPP_ADD_VSE_MENU;
int def_mfflags=1;
_str def_bgtag_options='30 10 3';
int def_buffer_retag=TAG_DEFAULT_BUFFER_RETAG_INTERVAL;

defload()
{
   if ( find_index('st',COMMAND_TYPE) ) return;
   _default_keys=find_index('default-keys',EVENTTAB_TYPE);
   set_eventtab_index(_default_keys,event2index(F3),find_index('quit-view',COMMAND_TYPE));
   def_actapp&=~ACTAPP_AUTOREADONLY;
   execute('addons ',"");    // run the addons module to add all other modules.
   def_actapp|=ACTAPP_AUTOREADONLY;
   if ( rc && rc!=2 ) {
      process_make_rc(rc,'addons');
   }
   if ( ! rc ) {
     clear_message();   // If messages at bottom, erase it.
   }
#if KEEP
   get_fkeytext(text,option);
   if ( option!='S') {    // Zoom the window
      one_window();
   }
#endif

}
int _loadrc;
_str makeNload(module)
{
   message(nls('making:')' 'module);
   if ( pos(' ',module) ) module='"'module'"';
   _make(module);
   process_make_rc(rc,module);
   filename=module;
   _loadrc= -1;
   _load(filename,'r');
   status=_loadrc;;
   if ( status ) {
      if ( substr(status,1,1)!='-' ) {
         status=1;
      }
     _message_box(nls("Error loading module:")" ":+module:+".  "get_message(status))
     if ( find_index('st',COMMAND_TYPE) ) {
        status=1;stop();
     } else {
        exit(1);
     }
   }
   return(status);
}
void save_pos(typeless &p,...)
{
   if (arg(2)!="") {
      p='r'p_RLine" "p_col " "p_hex_nibble" "p_cursor_y " "p_left_edge' 'point();
   } else {
      p=point('l') " "p_col " "p_hex_nibble" "p_cursor_y " "p_left_edge' 'point();
   }
}
void restore_pos(typeless p)
{
   parse p with linenum col hex_nibble cursor_y left_edge p;
   if ( substr(linenum,1,1)=='r' ) {  /* Use real line number? */
      p_RLine=(int)substr(linenum,2);
   } else {
      goto_point(p,linenum);
   }
   p_col=col;p_hex_nibble=hex_nibble;
   set_scroll_pos(left_edge,cursor_y);
}
/* Display a message making sure to preserve as much of the editor */
/* state as possible.  If the editor is writing its output to a */
/* shell window the shell window is closed. */
void messageNwait(...)
{
   // since the refresh below may make the command line window active */
   // if the current window is the hidden window, save and restore the window. */
   old_wid=p_window_id;
   // IF this is an editor control
   event=last_event();
   if (p_view_id<0) {
      // Doing refresh can change the current line if
      // we are in selective display
      save_pos(p);
      if (p_object!=OI_DESKTOP && p_active_form.p_enabled && p_active_form.p_visible) {
         refresh();
      }
      message(arg(1));
      k=get_event();
      restore_pos(p);
   } else {
      if (p_object!=OI_DESKTOP && p_active_form.p_enabled && p_active_form.p_visible) {
         refresh();
      }
      message(arg(1));
      k=get_event();
   }
   last_event(event);
   clear_message();
   p_window_id=old_wid;
}
_command void quit_view() name_info(','VSARG2_ICON|VSARG2_REQUIRES_MDI_EDITORCTL)
{
  _quit_view();
}

// Save _config_modify flags caused by a transfer configuration
// separate from _config_modify so user is not configused by
// Save Configuration? message_box.
static int gcfgTransferModifyFlags;

_command gui_save_config() name_info(','VSARG2_EDITORCTL)
{
   // IF no user config mods AND no automatic config mods
   if (!_config_modify && !gcfgTransferModifyFlags) return(0);
   // IF user modified the configuration.
   if (_config_modify) {
      result=_message_box('Save configuration?','Configuration Not Saved',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDCANCEL) {
         return(COMMAND_CANCELLED_RC);
      }
      if (result==IDNO) {
         return(0);
      }
   }
   return(save_config());
}
_command int save_config() name_info(','VSARG2_EDITORCTL)
{
   if (!_config_modify && !gcfgTransferModifyFlags) return(0);
   old_config_modify=_config_modify;
   _config_modify|=gcfgTransferModifyFlags;
   status=save_config2();
   if (status) {
      _config_modify=old_config_modify;
   } else {
      gcfgTransferModifyFlags=0;
   }
   return(status);
}
/*
   _firstinit() is called before definit() functions
*/
_firstinit()
{
   _hit_defmain=false;
   gtag_filelist_cache_updated=false;
   // Force a reference to some variables so they get created
   // and are not removed.
   if (0) {  // YES WE WANT 0 HERE.
      // DONT EXECUTE ANYTHING HERE
      _compiler_default='';
   }
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_ONE_FILE_PER_WINDOW)) {
      def_one_file='+w';
   }
   parse _default_color(CFG_FUNCTION) with fg bg .;
   if (bg==fg) {
      parse _default_color(CFG_WINDOW_TEXT) with fg bg .;
      _default_color(CFG_FUNCTION,fg,bg);
   }
   parse _default_color(CFG_ATTRIBUTE) with fg bg .;
   if (bg==fg) {
      parse _default_color(CFG_FUNCTION) with fg bg flags;
      _default_color(CFG_ATTRIBUTE,fg,bg,flags);
   }
   gconfig_path="";
   _config_modify=0;gcfgTransferModifyFlags=0;
   statename=editor_name('s');
   if (statename!='') {
      //statepath=strip_filename(statename,'n');
      path=_config_path();
   } else {
      _mdi._ShowWindow();  // Show window using OS argument
      _cmdline.p_visible=0;
   }
   bool=statename!='' /*&& !file_eq(path,statepath)*/ &&
       def_cfgfiles;
   // IF we are not creating a state file AND user wants cfg files
   //    AND user wants local state file
   if (bool && def_localsta) {
      bool=false;
      // Not sure if we will always want to compare directories.  Its
      // a weird case where user specified state file from command line.
      //
      if (_default_option(VSOPTION_APPLY_LOCAL_STATE_FILE_CHANGES)) {
         //_message_box('VSOPTION_APPLY_LOCAL_STATE_FILE_CHANGES');
         bool=true;
      }
   }
   if (bool) {
#if !__UNIX__
      get_env(_SLICKCONFIG);
      status=rc;
      if (status) {
         path=_macro_path();
      }

#endif
      // Must run USERSYSO_FILE first so have correct button bar resource.
      // USERDEFS_FILES sets button bar.
      _in_firstinit=1;
      filename=maybe_quote_filename(path:+USERSYSO_FILE:+_macro_ext);
      usersyso_exists=false;
      if(file_match('-p 'filename,1)!='' ) {
         status=shell(filename);
         //messageNwait('status h2='status);
         usersyso_exists=true;
      }
      _no_mdi_bind_all=1;
      old_modify=_config_modify;
      filename=maybe_quote_filename(path:+USERDEFS_FILE:+_macro_ext);
      if(file_match('-p 'filename,1)!='' ) {
         status=shell(filename);
      }
      _config_modify=old_modify;
      _no_mdi_bind_all=0;
      filename=maybe_quote_filename(path:+USERMACS_FILE:+_macro_ext);

      if(file_match('-p 'filename,1)!='' ) {
         make_rc=_make(filename);
         if ( make_rc ) {
           if ( make_rc==FILE_NOT_FOUND_RC ) {
             popup_message(nls("File '%s' not found",filename))
           } else {
             if ( make_rc==1  ) {  /* rc from Slick Translator? */
                //ST already processed message.
             } else {
               popup_message(nls("Unable to make '%s'",filename)".  "get_message(make_rc))
             }
           }
         } else {
            status=_load(filename,'r')
         }
      }
      // Load all user add macro files and DLLs
      rest=def_macfiles;
      switch (def_keys) {
      case 'brief-keys':
         index=find_index('briefsch.ex',MODULE_TYPE);
         if (!index) {
            rest=rest' argument.ex briefsch.ex briefutl.ex editflst.ex poperror.ex'
         }
         break;
      case 'vi-keys':
         index=find_index('ex.ex',MODULE_TYPE);
         if (!index) {
            rest=rest' ex.ex vi.ex vicmode.ex viimode.ex'
         }
         break;
      case 'gnuemacs-keys':
         index=find_index('gemacs.ex',MODULE_TYPE);
         if (!index) {
            rest=rest' argument.ex prefix.ex emacs.ex gemacs.ex';
         }
         break;
      case 'emacs-keys':
         index=find_index('emacs.ex',MODULE_TYPE);
         if (!index) {
            rest=rest' argument.ex prefix.ex emacs.ex';
         }
         break;
      }
      for (;;) {
         module=parse_file(rest);
         if (module=='') break;
         if (file_eq(module,'delphi.ex')) {
            continue;
         }
         index=find_index(module,MODULE_TYPE|DLLMODULE_TYPE);
         if (!index) {
            ext=get_extension(module);
            // If this is a Slick-C macro
            if (file_eq(ext,'ex')) {
               filename=_config_path():+substr(module,1,length(module)-1);
               if (file_match('-p 'maybe_quote_filename(filename),1)=='') {
                  filename=_config_path():+substr(module,1,length(module));
                  filename=file_match('-p 'maybe_quote_filename(filename),1);
               }
               if (filename=='') {
                  filename=macro_path_search(substr(module,1,length(module)-1));
                  if (filename=='') {
                     filename=macro_path_search(substr(module,1,length(module)));
                  }
               }
               if (filename!='') {
                  // Don't worry about message here.
                  load(filename);
               } else {
                  _macfile_delete(module,'');
               }
            } else {
               filename=slick_path_search1(module);
               if (filename!='') {
                  dload(filename);
               } else {
                 _macfile_delete(module,'');
               }
            }
         }
      }
      // We must have this for epsilon emulation.
      // Go ahead and do it for any configuration,
      // if several users complain, we can change this.
      kt_index=find_index('default_keys',EVENTTAB_TYPE);
      set_eventtab_index(kt_index,event2index(name2event('A-.')),find_index('list_symbols',COMMAND_TYPE));
      set_eventtab_index(kt_index,event2index(name2event('A-,')),find_index('function_argument_help',COMMAND_TYPE));
      filename=maybe_quote_filename(path:+USEROBJS_FILE:+_macro_ext);
      if(file_match('-p 'filename,1)!='' ) {
         status=shell(filename);
         //messageNwait('status h2='status);
      }
      if (def_localsta) {
         // We are transfer configuration from a previous version.
         menu_mdi_bind_all();
         _CfgTransferDone();
         gcfgTransferModifyFlags|=CFGMODIFY_SYSRESOURCE|CFGMODIFY_MUSTSAVESTATE;
      } else if (!usersyso_exists){
         // We must transfer menu bindings to this new version of
         // the editor.  This will cause a USERSYSO_FILE to be
         // generated with the _mdi_menu resource.
         menu_mdi_bind_all();
         gcfgTransferModifyFlags|=CFGMODIFY_SYSRESOURCE;
      }
      _EnhanceHTMLSetup();
      _in_firstinit=0;
   }
   _config_modify=0;
   // IF we have a 2.0 constant value for UNIXRE_SEARCH
   if (def_re_search==0x80) {
      // convert it to the new 3.0 value
      def_re_search=UNIXRE_SEARCH;
   }
}

definit()
{
   gconfig_path="";
   _macro_ext=get_env("VSLICKEXT");
   if (_macro_ext=="") {
      _macro_ext=".e";
   }
}
static _str option_present(var option,cmdline,word_options)
{
   for (;;) {
      parse word_options with option word_options
      if ( option=='' ) {
         return(0)
      }
      if (isalpha(substr(cmdline,1,1))) {
         len=pos(' ',cmdline)-1;
      } else {
         len=1;
      }
      if (len<0) len=length(cmdline);
      if ( !stricmp(option,substr(cmdline,1,len)) ) {
         return(1)
      }
   }

}
int _DefaultUndoSteps()
{
   if ( pos('\+u(\:{:i}|)',def_load_options,'','ri') ) {
      /* Set default undo steps for temp buffer. */
      undo_steps=substr(def_load_options,pos('s0'),pos('0'))
      if ( undo_steps=='' ) {
         undo_steps=300
      }
      return(undo_steps);
   }
   return(0);
}
static void doExecList(_str (&ExecList)[])
{
   for (i=0;i<ExecList._length();++i) {
      execute(ExecList[i],"");
   }
}
  #define DEFMAIN_OPTIONS 'H M R P # SUT FN MDIHIDE'
defmain()
{
   _hit_defmain=true;
   /*
      Here we call dllinit functions.  These dllinit functions
      must be called before autorestore.
   */
   call_list("dllinit_");
#if __UNIX__
   //file_match('/xxx/yyy/zzz',1);
   local_dir=_config_path()
   /* make sure the local configuration directory is created. */
   if ( ! isdirectory(local_dir) ) {
      status=make_path(local_dir,'0')   /* Give no shell messages options. */
      if ( status ) {  /* Error trying to create path. */
         popup_message(nls('Unable to create configuration directory "%s"',local_dir)'.  'get_message(status))
      }
   }
#endif
   _in_firstinit=0;
   orig_cwd=getcwd();
   p_window_id=_edit_window()
#if !_MDI_INTERFACE
   if ( p_buf_name=='' && def_keys=='emacs-keys' ) {
      p_buf_name='.main'
   }
   p_undo_steps=_DefaultUndoSteps();
#endif
  cmdline=arg(1)
  st_batch_mode=0
  macro_program=''
  terminal_file_spec='';
  if (def_auto_restore) {
     restore_options="I";
  } else {
     restore_options="IN";
  }
  restore_options2='IN';
  mdi_menu_loaded=0;
  _project_name="";
  _str ExecList[];
  mdihide=false;
  for (;;) {
     cmdline=strip(cmdline,'L')
     if ( substr(cmdline,1,1)=='"' && substr(cmdline,2,1)=='-' &&
        option_present(option,substr(cmdline,3),DEFMAIN_OPTIONS)
        ) {
        cmdline=substr(cmdline,2,length(option)+1):+'"'strip(substr(cmdline,length(option)+3),'L')
     }
     if ( ! verify(cmdline,'-+','M') ) {
        if ( cmdline=='' && macro_program=='') {
           cmdline='-r restore ':+restore_options;
        } else {
           if (!mdi_menu_loaded) {
              mdi_menu_loaded=1;
              _load_mdi_menu();
           }
           temp=cmdline;
           filename=strip(parse_file(temp),"B",'"');
           ext=get_extension(filename);
           if (file_eq(ext,'vpj')) {
              project_open(filename,"","I");
              // IF we are restoring files in project
              if (def_restore_flags & RF_PROJECTFILES) {
                 // Don't restore files or project name
                 restore_options2=restore_options="IGN";
              } else {
                 // Unfortunately, since the editor used the wrong
                 // MDI frame size, we don't restore files/windows here.
                 // We can probably correct this in version 3.0
                 // Don't restore files or project name.
                 restore_options2=restore_options="IGN";
              }
              cmdline=temp;
              continue;
           }
           break;
        }
     }
     /* Not an invocation option? */
     if ( substr(cmdline,1,1)!='-' ||
        ! option_present(option,substr(cmdline,2),DEFMAIN_OPTIONS) ) {
        break
     }
     cmdline=substr(cmdline,length(option)+2)
     if ( option=='H') {
        _help_file_spec=parse_file(cmdline)
     } else if ( option=='M' ) {
        _cur_mdi_menu=parse_file(cmdline)
     } else if ( option=='R' ) {
        no_exit=1
        macro_program=cmdline
        break
     } else if ( option=='P' ) {
        no_exit=0
        macro_program=cmdline
        break
     } else if ( option=='#' ) {
        rest=strip(parse_file(cmdline),'B','"');
        ExecList[ExecList._length()]=rest;
     } else if (option=='FN') {
        break;
     } else if (option=='MDIHIDE') {
        //4:48pm 4/20/1998
        //Dan Added for hidden mdi startup support.
        //Do not show mdi
        mdihide=true;
        _default_option(VSOPTION_MDI_SHOW_WINDOW_FLAGS,SW_HIDE);
     }
  }
  if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_MENUS)) {
     _cur_mdi_menu="";
  }
  if (!mdi_menu_loaded && !mdihide) {
     _load_mdi_menu();
  }
#if KEEP
  /* Create the menu bar window. */
  index=find_index('one-window',COMMAND_TYPE)
  if ( index_callable(index) ) {
     call_index(index)
  }
#endif
  if ( macro_program!='' ) {
     /* Running SLICK inside concurrent process buffer? */
     if ( no_exit && get_env('SLKRUNS')==1 ) {
        /* Get out of here. */
        exit(1)
     }
     if ( ! no_exit ) {
        st_batch_mode=1
     }
     parse macro_program with cmdname .;
     if (cmdname!='restore') {
        // No files are restore here.
        if (!mdihide) {
           restore(restore_options2);
        }
        execute(macro_program,"");
        doExecList(ExecList);
     } else {
        if (!mdihide) {
           execute(macro_program,"");
        }
        doExecList(ExecList);
     }
     /*if (index_callable(find_index('_restore_all_bookmarks',PROC_TYPE))) {
        _restore_all_bookmarks();
     } */
     st_batch_mode=0;
     if ( rc=='' ) { rc=0 }
     if ( no_exit ) {
        if ( def_start_on_cmdline ) {
           cursor_command();
        }
        if (_project_name!="") {
           focus_wid=_get_focus();
           _project_run_macro();
           if (focus_wid) focus_wid._set_focus();
        }
        stop();
     }
     exit(rc)
  }
  /* insert the user's command into the command retrieve file.*/
  restore(restore_options2);
  if (_project_name!="") {
     focus_wid=_get_focus();
     _project_run_macro();
     if (focus_wid) focus_wid._set_focus();
  }
  append_retrieve_command('e 'strip(cmdline))
  doExecList(ExecList);
#if _MDI_INTERFACE
  if (cmdline!='' ) {
     if (orig_cwd!=getcwd()) {
        new_cwd=getcwd();
        chdir orig_cwd,1
        edit(cmdline,def_vcflags & VCF_AUTO_CHECKOUT)
        chdir new_cwd,1
     } else {
        edit(cmdline,def_vcflags & VCF_AUTO_CHECKOUT)
     }
  }
#else
  empty_file_buf_id=p_buf_id
  if ( cmdline!='' ) {
     edit(cmdline,def_vcflags & VCF_AUTO_CHECKOUT)
  }
  /* Get fileid of empty file in the top ring already create by E */
  /* if user has selected file(s) to edit get rid of the empty file. */
  if ( empty_file_buf_id!=p_buf_id ) {   /* Any files loaded? */
     /* quit empty file */
     buf_id=p_buf_id
     load_files '+bi 'empty_file_buf_id
     quit()
     /* activate the last loaded file. */
     load_files '+bi 'buf_id
  } else {
     select_edit_mode()
  }
#endif
  if ( def_start_on_cmdline ) {
     cursor_command
  }
  /* Running SLICK inside concurrent process buffer? */
  if ( get_env('SLKRUNS')==1 ) {
     /* Get out of here. */
     exit(1)
  }
  /*if (index_callable(find_index('_restore_all_bookmarks',PROC_TYPE))) {
     _restore_all_bookmarks();
  } */
}

void process_make_rc(_str error_code,_str module)
{
  if ( error_code ) {
     /* messageNwait('error_code='error_code' module='module) */
    index=find_index('st',COMMAND_TYPE)
    if ( error_code==FILE_NOT_FOUND_RC ) {
       message nls("Can't find module:")" ":+module
       rc=2;stop;
    } else {
      if ( error_code==1  ) {  /* rc from Slick Translator? */
         if ( ! index ) {  /* message already displayed by st command? */
            message  nls("Error compiling or loading:")" ":+module:+".  Compilation failure."
         }
      } else {
        if ( index ) {
           refresh
        }
        message  nls("Error compiling or loading:")" ":+module:+".  "get_message((int)error_code)
      }
      if ( index ) { rc=2;stop } else exit(1);
    }
  }
}
//def a_5=fexit
_command void fexit()
{
   if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
      if ( delphiIsRunning() ) {
         delphi_stop(1);
      }
   }
   //9:36am 7/2/1998
   //This frees the handle to vsscc.dll that is loaded by vshlp.dll in
   //_InsertProjectFileList.
   //If this doesn't happen, the editor crashes on exit w/o any debug info
   //(Not even a cancel button)
   if (substr(machine(),1,2)=='NT' && index_callable(find_index('_FreeSccDll',PROC_TYPE))) {
      _FreeSccDll();
   }
   exit(1);
}
_str _config_path()
{
   if (arg(1)=="") {
      if (gconfig_path!="") {
         return(gconfig_path);
      }
      gconfig_path=_config_path2();
      return(gconfig_path);
   }
   return(_config_path2(arg(1)));
}
/* Return absolute path of users local configuration directory with */
/* trailing file separator. */
static _str _config_path2()
{
#if __UNIX__
   local_dir=get_env(_SLICKCONFIG)
   if ( local_dir!='' ) {
      if ( last_char(local_dir)!=FILESEP ) {
         local_dir=local_dir:+FILESEP
      }
      return(absolute(local_dir))
   }
   path=get_env("HOME")
   if ( rc ) {
      /*  Home env var not defined so return null string */
      return('')
   }
   if ( last_char(path)!=FILESEP ) {
      path=path:+FILESEP
   }
   path=path:+'.vslick'
   if ( last_char(path)!=FILESEP ) {
      path=path:+FILESEP
   }
   return(absolute(path))
#else
   path=get_env(_SLICKCONFIG)
   if ( path=='' ) {
      if (lowcase(arg(1))=='n') {
         return('')
      }
      path_list=get_env('VSLICKPATH');
      //
      // Could editor_name('s') to get location of state file.  However,
      // editor_name('s') returns a null string when you build the state file.
      //
      for (;;) {
         if (path_list=='') break;
         parse path_list with path (PATHSEP) path_list;
         if (last_char(path)!=FILESEP) {
            path=path:+FILESEP;
         }
         if (file_match('-p 'maybe_quote_filename(path:+_VLX_FILE),1)!='' ||
             file_match('-p 'maybe_quote_filename(path:+_ALIAS_FILE),1)!='') {
            return(absolute(path));
         }
      }
      return(editor_name('p'));
   }
   if ( last_char(path)!=FILESEP ) {
      path=path:+FILESEP
   }
   return(absolute(path))
#endif

}
static void _CfgTransferDone()
{
   _default_option(VSOPTION_MACRO_SOURCE_LEVEL,1);
}
_str slick_path_search(_str name)
{
   new_name=''
   if ( get_env(_SLICKPATH)!='' ) {
      new_name=path_search(name,_SLICKPATH,arg(2));
   }
   if ( new_name=='' ) {
      new_name=path_search(name,'PATH',arg(2))
   }
   return(new_name);
}
_str slick_path_search1(_str name,...)
{
   new_name=''
   if ( get_env(_SLICKPATH)!='' ) {
      new_name=path_search(name,_SLICKPATH,arg(2));
   }
   return(new_name);
}
_str misc_path_search(_str name)
{
   if ( get_env(_SLICKMISC)=='' ) {
      return(slick_path_search1(name,arg(2)));
   }
   filename=path_search(name,_SLICKMISC,'s'arg(2));
   if (filename=='' && file_eq(get_extension(name),'hlp')) {
      filename=slick_path_search1(name,arg(2));
   }
   return(filename);
}
_str bitmap_path_search(_str name)
{
   if ( get_env("VSLICKBITMAPS")=='' ) {
      return(slick_path_search1(name,arg(2)));
   }
   filename=path_search(name,"VSLICKBITMAPS",'s'arg(2));
   return(filename);
}
_str macro_path_search(_str name)
{
   if ( get_env(_SLICKMACROS)=='' ) {
      return(slick_path_search1(name,arg(2)));
   }
   return(path_search(name,_SLICKMACROS,'s'arg(2)));
}

void _EnhanceHTMLSetup()
{
   //"def-setup-html",'MN=HTML,TABS=+8,MA=1 74 1,KEYTAB=default-keys,WW=1,IWT=0,ST=0,IN=1,WC=A-Za-z0-9_$,LN=HTML,CF=1,')
   index=find_index("def-setup-html",MISC_TYPE);
   if (index) {
      parse name_info(index) with text1 'KEYTAB='keytab_name','rest;
      if (keytab_name=='default-keys' || keytab_name=='') {
         keytab_name='html-keys';
      }
      info=text1'KEYTAB='keytab_name','rest;
      set_name_info(index,info);
   }
}
