/*
$VerboseHistory: perl.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:46a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:46a
 * Comment:
 * Added support for faster tagging.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
/*
  Don't modify this code unless defining extension specific
  aliases do not suit your needs.   For example, if you
  want your brace style to be:

       if () {
          }

  Use the Extension Options dialog box ("Other", "Configuration...",
  "File Extension Setup...") and press the the "Alias" button to
  display the Alias Editor dialog box.  Press the New button, type
  "if" for the name of the alias and press <Enter>.  Enter the
  following text into the upper right editor control:

       if (%\c) {
       %\i}

  The  %\c indicates where the cursor will be placed after the
  "if" alias is expanded.  The %\i specifies to indent by the
  Extension Specific "Syntax Indent" amount define in the
  "Extension Options" dialog box.  Check the "Indent With Tabs"
  check box on the Extension Options dialog box if you want
  the %\i option to indent using tab characters.

*/
/*
  Options for Perl syntax expansion/indenting may be accessed from the
  Extension Options dialog ("Other", "Configuration...",
  "File Extension Setup...").

  The extension specific options is a string of five numbers separated
  with spaces with the following meaning:

    Position       Option
       1             Minimum abbreviation.  Defaults to 1.  Specify large
                     value to avoid abbreviation expansion.
       2             reserved.
       3             begin/end style.  Begin/end style may be 0,1, or 2
                     as show below.  Add 4 to the begin end style if you
                     want braces inserted when syntax expansion occurs
                     (main and do insert braces anyway).  Typing a begin
                     brace, '{', inserts an end brace when appropriate
                     (unless you unbind the key).  If you want a blank
                     line inserted in between, add 8 to the begin end
                     style.  Default is 4.

                      Style 0
                          if () {
                             ++i;
                          }

                      Style 1
                          if ()
                          {
                             ++i;
                          }

                      Style 2
                          if ()
                            {
                            ++i;
                            }


       4             Indent first level of code.  Default is 1.
                     Specify 0 if you want first level statements to
                     start in column 1.
*/
#include 'slick.sh'

#define STYLE1_FLAG 1
#define STYLE2_FLAG 2
#define BRACE_INSERT_FLAG 4
#define BRACE_INSERT_LINE_FLAG 8
#define NO_SPACE_BEFORE_PAREN 16   // "if(" or "if ("

#define MODE_NAME 'Perl'
#define EXTENSION 'pl'

#if 1
defload()
{
   setup_info='MN='MODE_NAME',TABS=+8,MA=1 74 1,':+
               'KEYTAB='MODE_NAME'-keys,WW=1,IWT=0,ST=0,'
   compile_info='0 perl *;'
   syntax_info='3 1 1 0 4 1 0'
   be_info=''
   create_ext(kt_index,EXTENSION,'',MODE_NAME,setup_info,compile_info,
              syntax_info,be_info)
   create_ext(kt_index,'pm',EXTENSION);

   if ( kt_index ) {
      set_eventtab_index(kt_index,event2index(name2event('{')),
                         find_index('perl-begin',COMMAND_TYPE));
      set_eventtab_index kt_index,event2index(name2event('}')),
                         find_index('perl-endbrace',COMMAND_TYPE)
   }
}
#endif

_command void perl_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode('pl')
}
_command void perl_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) || perl_expand_enter(p_SyntaxIndent,expand,be_style,indent_fl) ) {
      call_root_key(ENTER)
   } else if (_argument=='') {
      _undo 'S'
   }

}
_command void perl_space() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   
   was_space=(last_event():==' ')
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
         perl_expand_space(p_SyntaxIndent,be_style,indent_fl) ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ')
         } else {
            keyin ' '
         }
      }
   } else if (_argument=='') {
      _undo 'S'
   }
}
defeventtab perl_keys
def ':'=perl_key
def '('=perl_key
_command void perl_colon() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   keyin(':');
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .
   if (!command_state()) {
      left();cfg=_clex_find(0,'g');
      right();
   }
   if ( command_state() || p_SyntaxIndent<0 ||
      _in_comment() || cfg==CFG_STRING) {
   } else {
      if (_c_do_colon() &&
          (def_codehelp_flags&VSCODEHELPFLAG_AUTO_LIST_MEMBERS)
         ) {
         _do_list_members(true,false);
      }
   /*} else if (_argument=='') {
      _undo('S');*/
   }
}
_command void perl_key() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   if (command_state()) {
      call_root_key(last_event());;
      return;
   }
   if(_EmbeddedLanguageKey(last_event())) return;
   switch (last_event()) {
   case ':':
      keyin(':');
      if (def_codehelp_flags&VSCODEHELPFLAG_AUTO_LIST_MEMBERS) {
         _do_list_members(true,false);
      }
      return;
   case '(':
      auto_functionhelp_key();
      return;
   }
   call_root_key(last_event());
}
_command void perl_begin() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_CMDLINE)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .
   if ( command_state() || _in_comment() || !expand ||
       perl_expand_begin(expand,p_SyntaxIndent,be_style,indent_fl) ) {
      call_root_key('{')
   } else if (_argument=='') {
      _undo 'S'
   }

}
_command void perl_endbrace() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   if(_EmbeddedLanguageKey(last_event())) return;
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .
   keyin '}'
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment() ) {
   } else if (_argument=='') {
      get_line line
      if (line=='}') {
         col=perl_endbrace_col(be_style);
         if (col) {
            replace_line indent_string(col-1):+'}';
            p_col=col+1;
         }
      }
      _undo 'S'
   }
}

/* Returns column where end brace should go.
   Returns 0 if this function does not know the column where the
   end brace should go.
 */
int perl_endbrace_col(be_style)
{
   if (p_lexer_name=='') {
      return(0);
   }
   save_pos(p);
   --p_col;
   // Find matching begin brace
   status=_find_matching_paren(def_pmatch_max_diff);
   if (status) {
      restore_pos(p);
      return(0);
   }
   // Assume end brace is at level 0
   if (p_col==1) {
      restore_pos(p);
      return(1);
   }
   begin_brace_col=p_col;
   // Check if the first char before open brace is close paren
   col= find_block_col();
   if (!col) {
      restore_pos(p);
      return(0);
   }
   style=(be_style & (STYLE1_FLAG|STYLE2_FLAG));
   if (style!=0) {
      restore_pos(p);
      return(begin_brace_col);
   }
   restore_pos(p);
   return(col);
}

static int find_block_col()
{
   --p_col;
   if (_clex_skip_blanks('-')) return(0);
   if (get_text()!=')') {
      if (_clex_find(0,'g')!=CFG_KEYWORD) {
         return(0);
      }
      word=cur_word(col);
      if (word=='do' || word=='else') {
         first_non_blank();
         return(p_col);
         //return(p_col-length(word)+1);
      }
      return(0);
   }
   status=_find_matching_paren(def_pmatch_max_diff);
   if (status) return(0);
   if (p_col==1) return(1);
   --p_col;

   if (_clex_skip_blanks('-')) return(0);
   if (_clex_find(0,'g')!=CFG_KEYWORD) {
      return(0);
   }
   word=cur_word(col);
   if (pos(' 'word' ',' if while foreach for elsif ')) {
      first_non_blank();
      return(p_col);
      //return(p_col-length(word)+1);
   }
   return(0);
}
#define EXPAND_WORDS ' do else for foreach last next package require unless '
#if __VERSION__>=1.8
static _str space_words[]={'do',
                           'else','elsif',
                           'for','foreach',
                           'if',
                           'last','local',
                           'next',
                           'package','print',
                           'require','return',
                           'select','sub',
                           'unless',
                           'while'};
#else
   SPACE_WORDS=' do else elsif for foreach if last local next package ':+
               'print require return select sub unless while ';

#endif


perl_get_info(var Noflines,var cur_line,var first_word,var last_word,
              var rest,var non_blank_col,var semi,var prev_semi)
{
   save_pos(old_pos);
   first_word='';last_word='';non_blank_col=p_col;
   if (arg(9)=='') {
      for (j=0; ; ++j) {
         get_line cur_line
         if ( cur_line!='' ) {
            parse cur_line with line '#' /* Strip comment on current line. */
            parse line with before_brace '{' +0 last_word
            parse strip(line,'L') with first_word '[({:; \t]','r' +0 rest
            last_word=strip(last_word)
            parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .;
            syntax_indent=p_SyntaxIndent;
            if (last_word=='{' && !(be_style & STYLE2_FLAG)) {
               save_pos(p2);
               p_col=text_col(before_brace);
               _clex_skip_blanks('-');
               status=1;
               if (get_text()==')') {
                  status=_find_matching_paren(def_pmatch_max_diff);
               }
               if (!status) {
                  status=1;
                  if (p_col==1) {
                     up();_end_line();
                  } else {
                     left
                  }
                  _clex_skip_blanks('-');
                  if (_clex_find(0,'g')==CFG_KEYWORD) {
                     kwd=cur_word(junk);
                     status=!pos(' 'kwd' ',' if while foreach for ');
                  }
               }
               if (status) {
                  non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I')
                  restore_pos(p2);
               } else {
                  get_line(line);
                  non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I')
                  /* Use non blank of start of if, do, while, foreach, unless, or for. */
               }
            } else {
               non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I')
            }
            Noflines=j;
            break;
         }
         if ( up() ) {
            restore_pos(old_pos);
            return(1);
         }
         if (j>=100) {
            restore_pos(old_pos);
            return(1);
         }
      }
   } else {
      orig_col=p_col;
      for (j=0;  ; ++j) {
         get_line cur_line
         _begin_line();
         i=verify(cur_line,' '\t);
         if ( i ) p_col=text_col(cur_line,i,'I');
         if ( cur_line!='' && _clex_find(0,'g')!=CFG_COMMENT) {
            parse cur_line with line '#' /* Strip comment on current line. */
            parse line with before_brace '{' +0 last_word
            parse strip(line,'L') with first_word '[({:; \t]','r' +0 rest
            last_word=strip(last_word)
            parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .;
            syntax_indent=p_SyntaxIndent;
            if (last_word=='{' && !(be_style & STYLE2_FLAG)) {
               save_pos(p2);
               p_col=text_col(before_brace);
               _clex_skip_blanks('-');
               status=1;
               if (get_text()==')') {
                  status=_find_matching_paren(def_pmatch_max_diff);
               }
               if (!status) {
                  status=1;
                  if (p_col==1) {
                     up();_end_line();
                  } else {
                     left
                  }
                  _clex_skip_blanks('-');
                  if (_clex_find(0,'g')==CFG_KEYWORD) {
                     kwd=cur_word(junk);
                     status=!pos(' 'kwd' ',' if while foreach for ');
                  }
               }
               if (status) {
                  non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I')
                  restore_pos(p2);
               } else {
                  get_line(line);
                  non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I')
                  /* Use non blank of start of if, do, while, unless, foreach, or for. */
               }
            } else {
               non_blank_col=text_col(line,pos('[~ \t]|$',line,1,'r'),'I')
            }
            Noflines=j;
            break;
         }
         if ( up() ) {
            restore_pos(old_pos);
            return(1);
         }
         if (j>=100) {
            restore_pos(old_pos);
            return(1);
         }
      }
      if (!j) p_col=orig_col;
   }
   p='';
   if ( j ) {
      p=1;
   }
   semi=stat_has_semi(p);
   prev_semi=prev_stat_has_semi();
   restore_pos(old_pos);
   return(0);
}
/* Returns non-zero number if pass through to enter key required */
static typeless perl_expand_enter(syntax_indent,expand,be_style,indent_fl)
{
   if(_EmbeddedLanguageKey(last_event())) return(0);
   status=perl_get_info(Noflines,cur_line,first_word,last_word,rest,
                        non_blank_col,semi,prev_semi)
   if (status) return(1);
   status=0
   style1=be_style & STYLE1_FLAG;
   style2=be_style & STYLE2_FLAG;
   if ( expand && ! Noflines ) {
      if ( (first_word=='for' || first_word=='foreach') &&
            name_on_key(ENTER):=='nosplit-insert-line' ) {
         if ( name_on_key(ENTER):!='nosplit-insert-line' ) {
            if ( (style1) || semi ) {
               return(1)
            }
            indent_on_enter(syntax_indent)
            return(0)
         }
         /* tab to fields of Perl for statement */
         line=expand_tabs(cur_line)
         semi1_col=pos(';',line,p_col)
         if ( semi1_col>0 && semi1_col>=p_col ) {
            p_col=semi1_col+2
         } else {
            semi2_col=pos(';',line,semi1_col+1)
            if ( (semi2_col>0) && (semi2_col>=p_col) ) {
               p_col=semi2_col+2
            } else {
               if ( style1 || semi ) {
                  return(1)
               }
               indent_on_enter(syntax_indent)
            }
         }
      } else {
         status=1
      }
   } else {
     status=1
   }
   if ( status ) {  /* try some more? Indenting only. */
      status=0;
      col=perl_indent_col(cur_line,first_word,last_word,non_blank_col,semi,prev_semi,Noflines)
      indent_on_enter('',col)
   }
   return(status)

}

typeless perl_indent_col(cur_line,first_word,last_word,non_blank_col,semi,prev_semi,Noflines /*,pasting_open_brace2 */)
{
   pasting_open_brace2=arg(8);   // pasting open brace in style2
   parse name_info(p_index) with syntax_indent expand . . be_style indent_fl UseContOnParameters .;
   if ( syntax_indent=='' ) {
      return(non_blank_col);
   }
   syntax_indent=p_SyntaxIndent;
   style2=be_style & STYLE2_FLAG;
   is_structure=pos(' 'first_word' ',' if do while foreach for ')
   level1_brace=substr(cur_line,1,1)=='{'
   past_non_blank=p_col>non_blank_col || name_on_key(ENTER)=='nosplit-insert-line';
   /* messageNwait('is_struct='is_structure' semi='semi' psemi='prev_semi' firstw='first_word' lastw='last_word) */

   save_pos(p);
   up(Noflines);get_line(line);
   // Check for statement like this
   //
   //   if ( func(a,b,
   //          c,(d),(e) )) return;
   //
   //  look for last paren which matches to paren on different line.
   //
   if (Noflines) {
      i=length(line);
   } else {
      i=text_col(line,p_col,'p')-1;
   }
   //i=text_col(expand_tabs(line,1,p_col-1));
   //messageNwait('line='line' i='i);
   //old_col=p_col;
   pline=point();
   for (;;) {
      if (i<=0) break;
      j=lastpos(')',line,i);
      if (!j) break;
      p_col=text_col(line,j,'I');
      color=_clex_find(0,'g');
      //messageNwait('h1');
      if (color==CFG_COMMENT || color==CFG_STRING) {
         i=j-1;
         continue;
      }
      //messageNwait('try');
      status=_find_matching_paren(def_pmatch_max_diff);
      if (status) break;
      if (pline!=point()) {
         //messageNwait('special case');
         first_non_blank();
         non_blank_col=p_col;
         get_line(line);
         parse line with word .
         is_structure=pos(' 'word' ',' if do while foreach for ')
         //restore_pos(p);
         //return(col);
      }
      i=j-1;
   }
   restore_pos(p);
   if (
      (last_word=='{' && (! style2 || level1_brace) && indent_fl && past_non_blank) ||     /* Line end with '{' ?*/
      (is_structure && ! semi && past_non_blank && pasting_open_brace2!=1) ||
       pos('(\}|)else$',strip(cur_line),1,'r') || (first_word=='else' && !semi) ||
       (is_structure && last_word=='{' && past_non_blank) ) {
      //messageNwait('case1');
      return(non_blank_col+syntax_indent)
      /* Look for spaces, end brace, spaces, comment */
   } else if ( (pos('^([ \t])*\}([ \t]*)(\\|\#|$)',cur_line,1,'r') && style2)|| (semi && ! prev_semi)) {
      // OK we are a little lazy here. If the dangling statement is not indented
      // correctly, then neither will this statement.
      //
      //     if (
      //             )
      //             i=1;
      //         <end up here> and should be aligned with if
      //
      //messageNwait('case2');
      col=non_blank_col-syntax_indent;
      if ( col<=0 ) {
         col=1
      }
      if ( col==1 && indent_fl ) {
         return(non_blank_col)
      }
      return(col)
   }
   return(non_blank_col)

}
static typeless perl_expand_space(syntax_indent,be_style,indent_fl)
{
   if(_EmbeddedLanguageKey(last_event())) return(0);
   status=0
   get_line orig_line
   line=strip(orig_line,'T')
   orig_word=strip(line)
   if ( p_col!=text_col(line)+1 ) {
      return(1)
   }
   if_special_case=0;
   aliasfilename='';
#if __VERSION__>=1.8
   word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename)
#else
   word=min_abbrev(orig_word,SPACE_WORDS,name_info(p_index))
#endif
   if (aliasfilename!=''&&word!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   #if 1
   if ( word=='') {
      // Check for ) unless
      parse orig_line with . '\)|last|next','r' +0 first_word second_word rest
      if ((first_word==')' || first_word=='last' || first_word=='next') &&
           second_word!='' && rest=='' && second_word:==substr('unless',1,length(second_word))) {
         keyin(substr('unless ',length(second_word)+1));
         return(0)
      }
      #if 0
      // Check for else if or } else if
      if (first_word=='else' && orig_word==substr('else if',1,length(orig_word))) {
         word='else if'
         if_special_case=1;
      } else if (second_word=='else' && rest!='' && orig_word==substr('} else if',1,length(orig_word))) {
         word='} else if'
         if_special_case=1;
      } else if (first_word=='}else' && second_word!='' && orig_word==substr('}else if',1,length(orig_word))) {
         word='}else if'
         if_special_case=1;
      } else {
         return(1)
      }
      #endif
   }
   #endif
   if ( word=='') return(1);

   maybespace=(be_style & NO_SPACE_BEFORE_PAREN)?'':' ';
   line=substr(line,1,length(line)-length(orig_word)):+word
   width=text_col(line,length(line)-length(word)+1,'i')-1
   style1=be_style & STYLE1_FLAG
   style2=be_style & STYLE2_FLAG
   e1=' {'
   #if 1
   if (! (word=='do' && !style2 && !style1) ) {
      if ( (be_style & (STYLE1_FLAG|STYLE2_FLAG)) ||
         ! (be_style & BRACE_INSERT_FLAG) ) {
         e1=''
      }
   }
   #endif
   if ( word=='elsif' ) {
      replace_line line:+maybespace:+'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( word=='for' ) {
      replace_line line:+maybespace'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   #if 0
   } else if ( word=='foreach' ) {
      replace_line line:+maybespace'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   #endif
   } else if ( word=='if' || if_special_case) {
      replace_line line:+maybespace:+'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   #if 0
   } else if( word=='local' ) {
      replace_line line:+maybespace:+'();'
      p_col=width+length(word:+maybespace)+2;
   #endif
   } else if ( word=='next' || word=='last' ) {
      if ( orig_word==word ) {
         keyin(' ');
      } else {
         replace_line indent_string(width)word
         _end_line
      }
   } else if ( word=='print' ) {
      if ( orig_word=='print' ) {
         keyin(' ');
      } else {
         replace_line indent_string(width)'print '
         _end_line
      }
   } else if ( word=='private') {
      replace_line line:+':'
      _end_line
   } else if ( word=='return' ) {
      if (orig_word=='return') {
         keyin ' '
      } else {
         replace_line indent_string(width)'return '
         _end_line
      }
   } else if( word=='select' ) {
      replace_line line:+maybespace:+'();'
      p_col=width+length(word:+maybespace)+2;
   } else if ( word=='sub' ) {
      perl_insert_sub();
   #if 0
   } else if ( word=='unless' ) {
      replace_line line:+maybespace'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   #endif
   } else if ( word=='while' ) {
      replace_line line:+maybespace'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( pos(' 'word' ',EXPAND_WORDS) ) {
      replace_line indent_string(width)word' '
      _end_line
   } else {
     status=1
   }
   return status
}
static perl_expand_begin(expand,syntax_indent,be_style,indent_fl)
{
   if(_EmbeddedLanguageKey(last_event())) return(0);
   brace_indent=0
   keyin '{'
   get_line line
   pcol=text_col(line,p_col,'P')
   last_word=''
   if ( pcol-2>0 ) {
      i=lastpos('[~ ]',line,pcol-2,'r')
      if ( i && substr(line,i,1)==')' ) {
         parse substr(line,pcol-1) with  last_word '/\*|//','r'
      }
   }
   if ( line!='{' ) {
      if ( last_word!='{' ) {
         parse line with first_word second_word
         parse line with '}' word '{' +0 last_word '#'
         if ( (last_word!='{' || word!='else') &&
              first_word!='do' && first_word!='for' && first_word!='foreach' ) {
            return(0);
         }
      }
      if ( be_style & STYLE2_FLAG ) {
         brace_indent=syntax_indent
         be_style= be_style & ~(STYLE1_FLAG|STYLE2_FLAG|BRACE_INSERT_FLAG)
      }
   } else if ( ! (be_style & STYLE2_FLAG) ) {
      if ( ! prev_stat_has_semi() ) {
         old_col=p_col
         up
         if ( ! rc ) {
            first_non_blank();p_col=p_col+syntax_indent+1
            down
         }
         col=p_col-syntax_indent-1
         if ( col<1 ) {
            col=1
         }
         if ( col<old_col ) {
            replace_line indent_string(col-1)'{'
         }
      }
   }
   first_non_blank()
   if ( expand ) {
      col=p_col-1;
      if ( (col && (be_style & STYLE2_FLAG)) || (! (indent_fl+col)) ) {
         syntax_indent=0;
      }
      insert_line(indent_string(col+brace_indent));
      perl_endbrace();
      up;_end_line;
      if ((be_style & BRACE_INSERT_LINE_FLAG) ) {
         perl_enter();
      }
#if 0
      if ( be_style & BRACE_INSERT_LINE_FLAG ) {
         insert_line indent_string(col+syntax_indent)
      }
      insert_line indent_string(col+brace_indent)'}'
      up;_end_line
#endif
   } else {
      _end_line
   }
   return(0)

}
static typeless prev_stat_has_semi()
{
   status=1
   up;
   if ( ! rc ) {
      col=p_col;_end_line;get_line line
      parse line with line '\#','r'
      /* parse line with line '{' +0 last_word */
      /* parse line with first_word rest */
      /* status=stat_has_semi() or line='}' or line='' or last_word='{' */
      line=strip(line,'T');
      if (last_char(line)==')') {
         save_pos(p);
         p_col=text_col(line);
         status=_find_matching_paren(def_pmatch_max_diff);
         if (!status) {
            status=search('[~( \t]','@-r');
            if (!status) {
               if (!_clex_find(0,'g')==CFG_KEYWORD) {
                  status=1;
               } else {
                  kwd=cur_word(junk);
                  status=!pos(' 'kwd' ',' if do while foreach for ');
               }
            }
         }
         restore_pos(p);
      } else {
         status=last_char(line)!=')' && ! pos('(\}|)else$',line,1,'r')
      }
      down
      p_col=col
   }
   return(status)
}
static typeless stat_has_semi()
{
   get_line line
   parse line with line '#'
   line=strip(line,'T')
   name=name_on_key(ENTER)
   return((last_char(line):==';' || last_char(line):=='}') &&
            (
               ! (( name=='split-insert-line' ||
                     (name=='maybe-split-insert-line' && _insert_state())
                    ) && (p_col<=text_col(line) && arg(1)=='')
                   )
            )
         )

}
static void maybe_insert_braces(syntax_indent,be_style,width,word)
{
   col=width+length(word)+3
   if (be_style & NO_SPACE_BEFORE_PAREN) --col;
   if ( be_style & STYLE2_FLAG ) {
      width=width+syntax_indent
   }
   if ( be_style & BRACE_INSERT_FLAG ) {
      up_count=1
      if ( be_style & (STYLE1_FLAG|STYLE2_FLAG) ) {
         up_count=up_count+1
         insert_line  indent_string(width)'{'
      }
      if ( be_style & BRACE_INSERT_LINE_FLAG ) {
         up_count=up_count+1
         insert_line indent_string(width+syntax_indent)
      }
      insert_line indent_string(width)'}'
      up up_count;
   }
   p_col=col
   if ( ! _insert_state() ) { _insert_toggle }
}
/*
   It is no longer necessary to modify this function to
   create your own sub style.  Just define an extension
   specific alias.  See comment at the top of this file.
*/
static typeless perl_insert_sub()
{
   parse name_info(p_index) with . . . . be_style indent_fl .;
   syntax_indent=p_SyntaxIndent;
   if( !((be_style&BRACE_INSERT_FLAG) && (be_style&STYLE2_FLAG)) ) {
      syntax_indent=0;
   }
   up_count=0;
   if( be_style&BRACE_INSERT_FLAG ) {
      up_count=1;
      if( (be_style&STYLE1_FLAG) || (be_style&STYLE2_FLAG) ) {
         ++up_count;
         replace_line('sub ');
         insert_line(indent_string(syntax_indent):+'{');
      } else {
         replace_line('sub  {');
      }
      if( be_style&BRACE_INSERT_LINE_FLAG ) {
         ++up_count;
         insert_line('');
      }
      insert_line(indent_string(syntax_indent):+'}');
   } else {
      replace_line('sub ');
      _end_line();
   }

   up(up_count);
   p_col=5;   // Put cursor after 'sub ' so user can keyin the name

   return(0);
}


/* =========== Perl Tagging Support ================== */
_str def_perl_proto;

static _str gpackage_name;
static int gtag_pass;
static typeless gtag_pass_orig_pos;
static _str _perl_get_current_package()
{
   name_re='{[A-Za-z0-9_]#}';
   after_struct_id='[\t ]*;'
   struct_re='^package[\t ]+':+name_re:+after_struct_id;
   save_pos(p);
   status=search(struct_re,'-@re');
   //say('struct_re='struct_re);
   if (!status) {
      restore_pos(p);
      word=get_text(match_length('0'),match_length('S0'));
      return(word);
   }
   return("");
}
void _pl_after_UpdateContext()
{
   name_re='{[A-Za-z0-9_]#}';
   after_struct_id='[\t ]*;'
   struct_re='^package[\t ]+':+name_re:+after_struct_id;
   save_pos(p);
   status=search(struct_re,'-@re');
   //say('struct_re='struct_re);
   if (!status) {
      restore_pos(p);
      word=get_text(match_length('0'),match_length('S0'));
      status=search(struct_re,'@re');
      if (status) {
         bottom();
      }
      int context_id = tag_find_context(word,1,1,0,'');
      if (context_id > 0) {
         tag_end_context(context_id, p_line, _nrseek());
         top();          context_id = tag_current_context();
         bottom();       context_id = tag_current_context();
         restore_pos(p); context_id = tag_current_context();
         //say("_perl_get_current_package: context_id="context_id);
      } else {
         restore_pos(p);
      }
   }
}
int pl_proc_search1(var proc_name,find_first)
{
   orig_proc_name=proc_name;
   if ( find_first ) {
      /* Pickup Perl prototype in code file. */
      gpackage_name='';
      perl_proto=def_perl_proto;
      save_pos(gtag_pass_orig_pos);
      gtag_pass=1;
      if (p_line>1 || (p_line==1 && p_col>1)) {
         // Determine current package
         gpackage_name=_perl_get_current_package();
      }

      if ( proc_name:=='' ) {
         status=search('^[ \t]@(sub|package)[ \t]#[\~A-Za-z0-9_]#((\:\:|\x27)[\~A-Za-z0-9_]#|)\c[ \t]*($|\{|;)','@er');
      } else {
         tag_tree_decompose_tag(proc_name, name, class_name, kind, df);
         if ( kind=='proto' ) {
            if ( class_name!='' ) {
               return(pl_proc_search2(proc_name,1))
            }
            perl_proto=1;
         } else if ( kind=='func' || kind:=='' ) {
            perl_proto=0;
         } else {
            return(pl_proc_search2(proc_name,1))
         }
         if ( class_name!='' ) {
            name=class_name'(\:\:|\x27)'name
         }
         status=search(name,'@er>w=[\~A-Za-z0-9_]');
      }
   } else {
      if ( gtag_pass==2 ) {
         return(pl_proc_search2(proc_name,0))
      }
      status=repeat_search();
   }
   for (;;) {
      if ( status ) {
         if ( gtag_pass==1 && (proc_name:=='' || pos(':',proc_name)) ) {
            goto_point(gtag_pass_orig_pos);
            gtag_pass=2;
            if ( proc_name:!='' ) {
               return(pl_proc_search2(proc_name,1))
            }
         }
         return(status)
      }
      get_line(line);
      line=expand_tabs(line);
      /* Strip trailing comment.  */
      i=pos('#',line);
      comment="";
      if ( i ) {
         comment=substr(line,i+1);
         line=substr(line,1,i-1);
      }
      /* The IF below is required for FIND-TAG and not MAKE-TAGS. */
      if ( substr(line,1,7):=='package' ) {
         parse line with line ';'
         i=lastpos('[ *]',strip(translate(line,' ',\t)),'','r')
         word=strip(substr(line,i+1));
         proc_name=word:+'(package)';
         gpackage_name=word;
         return(0);
      } else if (pos('[A-Za-z_]',substr(line,1,1),1,'r')) {
         kind='func';
         line=strip(line,'T');
         if ( last_char(line):==';' ) {
            /* Found a prototype */
            if ( ! perl_proto ) {
               /* Not looking for proto types. */
               status=repeat_search();
               continue;
            }
            line=substr(line,1,length(line)-1);
            kind='proto'
         } else if ( perl_proto && orig_proc_name!='' ) {
            /* Looking for Perl prototype of a specific name.  Not a procedure. */
            status=repeat_search();
            continue;
         }
         parse line with line '{';
         i=lastpos('[ *]',strip(translate(line,' ',\t)),'','r');
         tag_name=strip(substr(line,i+1));
         //say('proc_name='proc_name);
         /* x27 =' (apostrophe) */
         class_name="";
         if ( pos('{#1\:\:|\x27}',tag_name,1,'r') ) {
            if ( orig_proc_name!='' && ! pos(':',orig_proc_name) ) {
               /* Don't want procedure with class */
               status=repeat_search();
               continue
            }
            delim=substr(tag_name,pos('S1'),pos('1'));
            parse tag_name with class_name (delim) tag_name;
         } else if (gpackage_name!='') {
            class_name=gpackage_name;
         }
         if (class_name=='main' || class_name=='') {
            class_name="";
            tag_flags=0;
         } else {
            tag_flags=VS_TAGFLAG_inclass;
         }
         signature="";
         return_type="";
         if (comment!="") {
            parse comment with '(' signature')' 'return' return_type;
            signature=strip(signature);
            return_type=strip(return_type);
         } else {
            // look for local(...)= @_;
            //      OR 
            // look for my(...)= @_;
            save_pos(p);
            if(!down()) {
               for (;;) {
                  get_line(line);
                  parse line with line '[{#]','r';
                  if (line!="") {
                     parse line with '(local|my)[ \t(]','r' rest;
                     if (rest=="") {
                        break;
                     }
                     parse rest with maybe_signature '\)[ \t]*=|=','r' value ';';
                     if (value=='@_') {
                        signature=strip(maybe_signature);
                        break;
                     }
                  }
                  if (down()) {
                     break;
                  }
               }
               restore_pos(p);
            }

         }
         proc_name=tag_tree_compose_tag(tag_name,class_name,kind,tag_flags,signature,return_type);
         return(0)
      }
      status=repeat_search();
   }
}

static int pl_proc_search2(var proc_name,find_first)
{
   orig_proc_name=proc_name
   if ( find_first ) {
      if ( proc_name:=='' ) {
         name_re='{[A-Za-z0-9_]#}';
      } else {
         tag_tree_decompose_tag(proc_name, name, class_name, kind, df);
         name_re='{'name'}'
         name_re=stranslate(name_re, '[:]', ':');
      }
      after_struct_id='[\t ]*;'
      struct_re='^package[\t ]+':+name_re:+after_struct_id;
      status=search(struct_re,'@re');
   } else {
      status=repeat_search();
   }
   for (;;) {
      if ( status) {
         return(status);
      }
      get_line line
      line=expand_tabs(line)
      if ( substr(line,p_col,7):!='package' ||
         (p_col!=1 && substr(line,p_col-1,1)!='') ) {
         /* Found incorrect case */
         status=repeat_search();
         continue
      }
      word=get_text(match_length('0'),match_length('S0'))
      proc_name=word:+'(package)'
      gpackage_name=word;
      break;
   }
   return(0)

}

int pl_proc_search(_str &proc_name,int find_first)
{
   return(_EmbeddedProcSearch(pl_proc_search1,proc_name,find_first,arg(3),arg(4)));
}
int _pl_get_idexp(_str (&errorArgs)[],
                 boolean PossibleOperator,
                 _str &prefixexp,
                 _str &lastid,int &lastidstart_col,
                 int &lastidstart_offset,
                 int &info_flags,
                 typeless &otherinfo
                )
{
   status=_c_get_idexp(errorArgs,PossibleOperator,prefixexp,lastid,lastidstart_col,lastidstart_offset,info_flags,otherinfo);
   if (status) {
      return(status);
   }
   if(prefixexp!="") {
      parse prefixexp with firstname"::";
      if (firstname=='main'/* || substr(prefixexp,1,2)=='::'*/) {
         prefixexp="::";
      }
      return(0);
   }
   //_str package_name=_perl_get_current_package(true);
   // Add package context
   //if (package_name!="" && package_name!="main") {
   //   if (prefixexp=="") {
   //      prefixexp=package_name;
   //   } else {
   //      prefixexp=package_name"::"prefixexp;
   //   }
   //}
   return(0);
}
int _pl_fcthelp_get_start(_str (&errorArgs)[],
                         boolean OperatorTyped,
                         boolean cursorInsideArgumentList,
                         int &FunctionNameOffset,
                         int &ArgumentStartOffset,
                         int &flags
                         )
{
   return(_c_fcthelp_get_start(errorArgs,OperatorTyped,cursorInsideArgumentList,FunctionNameOffset,ArgumentStartOffset,flags));
}
int _pl_fcthelp_get(_str (&errorArgs)[],
                      VSAUTOCODE_ARG_INFO (&FunctionHelp_list)[],
                      boolean &FunctionHelp_list_changed,
                      int &FunctionHelp_cursor_x,
                      _str &FunctionHelp_HelpWord,
                      int FunctionNameStartOffset,
                      int flags
                      )
{
   return(_c_fcthelp_get(errorArgs,
                         FunctionHelp_list,FunctionHelp_list_changed,
                         FunctionHelp_cursor_x,
                         FunctionHelp_HelpWord,
                         FunctionNameStartOffset,flags));
}
int _pl_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,_str prefixexp,_str lastid,_str lastid_prefix,int lastidstart_offset,_str expected_type,int info_flags,typeless otherinfo)
{
   //say("_pl_insert_context_tags("prefixexp","lastid","lastid_prefix")");
   // id followed by paren, then limit search to functions
   errorArgs._makeempty();
   boolean funcs_only = false;
   if (info_flags & VSAUTOCODEINFO_LASTID_FOLLOWED_BY_PAREN) {
      funcs_only = true;
   }

   // watch out for unwelcome 'new' as prefix expression
   if (strip(prefixexp)=='new') {
      prefixexp='';
   }

   // set up for (possibly) incremental update
   cb_prepare_expand(0, p_window_id, TREE_ROOT_INDEX);
   int status, first_index = _TreeGetFirstChildIndex(TREE_ROOT_INDEX);

   // get the current class from the context
   typeless tag_files = tags_filenamea(editorctl_wid.p_extension);
   editorctl_wid._UpdateContext(true);
   editorctl_wid._UpdateLocals(true);
   _str cur_class_name = '';
   int context_id = editorctl_wid.tag_current_context();
   if (context_id > 0) {
      tag_get_detail2(VS_TAGDETAIL_context_type, context_id, cur_type_name);
      tag_get_detail2(VS_TAGDETAIL_context_class, context_id, cur_class_name);
      if (tag_tree_type_is_class(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, class_name);
         cur_class_name = tag_join_class_name(class_name, cur_class_name, tag_files, true);
      } else if (tag_tree_type_is_package(cur_type_name)) {
         tag_get_detail2(VS_TAGDETAIL_context_name, context_id, cur_class_name);
      }
   }

   // how many of each match did we find?
   int locals_count  = 0;
   int symbols_count = 0;
   int members_count = 0;
   int globals_count = 0;
   static _str    globals_lastid;
   static _str    symbols_lastid;
   static _str    members_lastid;
   static boolean symbols_truncated;
   static boolean globals_truncated;
   static boolean members_truncated;
   if (first_index <= 0) {
      symbols_truncated = true;
      globals_truncated = true;
      members_truncated = true;
   }

   // no prefix expression, update globals and symbols from current context
   if (prefixexp == '') {
      int locals_root  = 0;
      int members_root = 0;
      int symbols_root = 0;
      int globals_root = 0;

      // first time here, set up categories, otherwise, find them...
      if (first_index <= 0) {

         // FIRST TIME INSERTING ITEMS
         _TreeSetUserInfo(TREE_ROOT_INDEX, 0); // do not search/sort root level
         locals_root   = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         if (cur_class_name != '') {
            members_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members, TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         }
         symbols_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer,  TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);
         globals_root  = _TreeAddItem(TREE_ROOT_INDEX, VSCODEHELP_TITLE_globals, TREE_ADD_AS_CHILD, _pic_fldclos, _pic_project, 1);

         // insert locals
         editorctl_wid._CodeHelpListContextLocals(p_window_id,locals_root,tag_files,
                                                  lastid,lastid_prefix,'',
                                                  VS_TAGFILTER_ANYTHING,VS_TAGCONTEXT_ANYTHING,
                                                  locals_count,VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
      } else {
         // INCREMENTAL UPDATE
         locals_root  = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_locals);
         symbols_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_buffer);
         members_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_members);
         globals_root = _TreeSearch(TREE_ROOT_INDEX, VSCODEHELP_TITLE_globals);
         // for non-incremental items, count the actual number of items
         if (locals_root > 0) {
            locals_count = _TreeGetNumChildren(locals_root);
         }
         if (members_root > 0) {
            members_root = _TreeGetNumChildren(members_root);
         }
      }

      // update the symbols from current buffer, give case-sensitive matches preference
      if (symbols_truncated || pos(symbols_lastid, lastid_prefix)!=1) {
         if (symbols_root > 0) {
            _TreeBeginUpdate(symbols_root);
            _str no_tag_files[]; no_tag_files._makeempty();
            int context_flags = 0;
            if (funcs_only) context_flags |= VS_TAGCONTEXT_ONLY_funcs;
            editorctl_wid._CodeHelpListContextGlobals(p_window_id,symbols_root,
                                                      true,no_tag_files,lastid,lastid_prefix,
                                                      VS_TAGFILTER_ANYTHING,context_flags,
                                                      symbols_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            if (symbols_count==0 && context_flags!=0) {
               // desparate, try again
               context_flags = 0;
               editorctl_wid._CodeHelpListContextGlobals(p_window_id,symbols_root,
                                                         true,no_tag_files,lastid,lastid_prefix,
                                                         VS_TAGFILTER_ANYTHING,context_flags,
                                                         symbols_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            }
            _TreeEndUpdate(symbols_root);
         }
         symbols_lastid = lastid_prefix;
         symbols_truncated = (symbols_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      }

      // update the globals, make sure that case-sensitive matches get preference
      //say("trunc="globals_truncated"glid="globals_lastid"lp="lastid_prefix);
      if (globals_truncated || pos(globals_lastid, lastid_prefix)!=1) {
         if (globals_root > 0) {
            _TreeBeginUpdate(globals_root);
            int context_flags = VS_TAGCONTEXT_ONLY_non_static;
            if (funcs_only) context_flags |= VS_TAGCONTEXT_ONLY_funcs;
            editorctl_wid._CodeHelpListContextGlobals(p_window_id,globals_root,
                                                      true,tag_files,lastid,lastid_prefix,
                                                      VS_TAGFILTER_ANYTHING,context_flags,
                                                      globals_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            if (globals_count==0 && context_flags!=0) {
               // desparate, try again
               context_flags = 0;
               editorctl_wid._CodeHelpListContextGlobals(p_window_id,globals_root,
                                                         true,tag_files,lastid,lastid_prefix,
                                                         VS_TAGFILTER_ANYTHING,context_flags,
                                                         globals_count,VSCODEHELP_MAXLISTGLOBALSYMBOLS);
            }
            _TreeEndUpdate(globals_root);
         }
         globals_lastid = lastid_prefix;
         globals_truncated = (globals_count >= VSCODEHELP_MAXLISTGLOBALSYMBOLS)? true : false;
      }

      // update the symbols from current buffer, 
      // give case-sensitive matches preference
      if (members_truncated || pos(members_lastid, lastid_prefix)!=1) {
         if (members_root > 0) {
            _TreeBeginUpdate(members_root);
            editorctl_wid._ListMembersInContext(p_window_id, members_root, 
                                                false, funcs_only, 
                                                false, false, false, true,
                                                members_count, 
                                                VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            editorctl_wid._ListMembersInContext(p_window_id, members_root, 
                                                false, funcs_only, 
                                                false, false, false, false,
                                                members_count, 
                                                VSCODEHELP_MAXLISTMEMBERSSYMBOLS);
            _TreeEndUpdate(members_root);
         }
         members_lastid = lastid_prefix;
         members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;
      }

      // all done
      errorArgs[1] = lastid;
      int total_count = symbols_count+locals_count+globals_count+members_count;
      return (total_count>0)? 0 : VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }

   // already up to date?
   if (!members_truncated && pos(members_lastid, lastid_prefix)==1) {
      return 0;
   }

   // analyse prefix expression to determine effective class type
   int c_return_flags = 0;
   _str dummy_tag = '';
   status = editorctl_wid._c_get_type_of_prefix(errorArgs, prefixexp, match_class,
                                                false, pointer_count, 
                                                c_return_flags, dummy_tags);
   //say("MATCH_CLASS="match_class" status="status" c_return_flags="c_return_flags);
   if (status) {
      return status;
   }
   int context_flags = VS_TAGCONTEXT_ONLY_inclass;
   if (c_return_flags & VSCODEHELP_RETURN_TYPE_STATIC_ONLY) {
      context_flags |= VS_TAGCONTEXT_ONLY_static;
   }
   if (!(c_return_flags & VSCODEHELP_RETURN_TYPE_GLOBALS_ONLY)) {
      context_flags |= VS_TAGCONTEXT_ALLOW_locals;
   }
   _TreeSetUserInfo(TREE_ROOT_INDEX, 1); // search/sort root level
   _TreeBeginUpdate(TREE_ROOT_INDEX);
   editorctl_wid._ListSymbolsInClass(lastid, match_class,
                                     p_window_id, TREE_ROOT_INDEX, 0,
                                     members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                     VS_TAGFILTER_ANYTHING, context_flags,
                                     false, true);
   if (lastid != lastid_prefix) {
      editorctl_wid._ListSymbolsInClass(lastid_prefix, match_class,
                                        p_window_id, TREE_ROOT_INDEX, 0,
                                        members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                        VS_TAGFILTER_ANYTHING, context_flags,
                                        false, true);
   }
   if (lastid_prefix != '') {
      editorctl_wid._ListSymbolsInClass('' /*lastid*/, match_class,
                                        p_window_id, TREE_ROOT_INDEX, 0,
                                        members_count, VSCODEHELP_MAXLISTMEMBERSSYMBOLS,
                                        VS_TAGFILTER_ANYTHING, context_flags,
                                        false, false);
   }
   _TreeEndUpdate(TREE_ROOT_INDEX);
   members_lastid = lastid_prefix;
   members_truncated = (members_count >= VSCODEHELP_MAXLISTMEMBERSSYMBOLS)? true : false;

   // Return 0 indicating success if anything was found
   if (members_count <= 0) {
      errorArgs[1] = (lastid == '')? match_class : lastid;
      return VSCODEHELPRC_NO_SYMBOLS_FOUND;
   }
   return 0;
}
int _pl_find_context_tags(_str (&errorArgs)[],_str prefixexp,
                          _str lastid,int lastidstart_offset,
                          int info_flags,typeless otherinfo,
                          boolean find_parents,int max_matches,
                          boolean exact_match,boolean case_sensitive)
{
   return(_c_find_context_tags(errorArgs,prefixexp,lastid,lastidstart_offset,info_flags,otherinfo,false,max_matches,exact_match,case_sensitive));
}
int _pl_MaybeBuildTagFile(int &tfindex)
{
   ext='pl';
   tfindex=find_index('def-tagfiles-'ext,MISC_TYPE);
   // IF the user does not have an extension specific tag file for Slick-C
   status=0;
   tagfilename=absolute(_config_path():+'perl.vtg');
   if (!tfindex || name_info(tfindex)=='' ||
       tag_read_db(tagfilename)==FILE_NOT_FOUND_RC) {
      // Tag the Slick-C macros
      tag_close_db(tagfilename);
      //status=tag_create_db(filename);
      slickc_filename=path_search('maketags'_macro_ext,'VSLICKMACROS');
      if (slickc_filename=="") {
         slickc_filename=path_search('maketags'_macro_ext'x','VSLICKMACROS');
      }
      if (slickc_filename!='') {
         path=strip_filename(slickc_filename,'n');
         extra_file=get_env('VSROOT'):+'builtins.'ext;
         extra_file=file_match('-p 'maybe_quote_filename(extra_file),1);
#if 1
         perl_binary=path_search("perl","","P");
         std_libs="";
         if (perl_binary!="") {
            alternate_shell=file_match('-p /bin/sh',1);
            if ( alternate_shell=='' ) {
               alternate_shell=path_search('sh');
            }
            _str temp_file=mktemp();
            line=maybe_quote_filename(perl_binary)' -V >'maybe_quote_filename(temp_file)' 2>&1';
            mou_hour_glass(1);
            shell(line,'pq',alternate_shell);
            status=_open_temp_view(temp_file,temp_view_id,orig_view_id);
            //status=_open_temp_view("/tmp/junk1",temp_view_id,orig_view_id);
            delete_file(temp_file);
            if (!status) {
               status=search('^[ \t]*\@INC\:',"r");
               if (!status) {
                   get_line(line);
                   parse line with ':' rest;
                   if (rest!="") {
                      for (;;) {
                         parse rest with path rest;
                         if (path=="") {
                            break;
                         }
                         if (last_char(path)!=FILESEP) {
                            path=path:+FILESEP;
                         }
                         if (path=="."FILESEP) {
                            continue;
                         }
                         std_libs=std_libs" "maybe_quote_filename(path:+"*.pl");
                         std_libs=std_libs" "maybe_quote_filename(path:+"*.pm");
                      }
                   } else {
                      for (;;) {
                         if (down()) {
                            break;
                         }
                         get_line(path);
                         if (path=="") {
                            break;
                         }
                         path=strip(path);
                         if (last_char(path)!=FILESEP) {
                            path=path:+FILESEP;
                         }
                         if (path=="."FILESEP) {
                            continue;
                         }
                         std_libs=std_libs" "maybe_quote_filename(path:+"*.pl");
                         std_libs=std_libs" "maybe_quote_filename(path:+"*.pm");
                      }
                   }
               }
               _delete_temp_view(temp_view_id);
               activate_view(orig_view_id);
            }
         }
         status=shell('maketags -n "Perl Run-Times" -o 'maybe_quote_filename(tagfilename)' 'std_libs' 'maybe_quote_filename(extra_file));
#else 
         perl_binary=path_search("perl","","P");
         std_libs="";
         if (perl_binary!="") {
            path=strip_filename(perl_binary,"n");
            if (last_char(path)==FILESEP) {
               path=substr(path,1,length(path)-1);
            }
            name=strip_filename(path,"p");
            if (name=="bin") {
               path=strip_filename(path,"n");
            }
            if (last_char(path)!=FILESEP) {
               path=path:+FILESEP;
            }
            std_libs=maybe_quote_filename(path:+"*.pl");
            std_libs=std_libs" "maybe_quote_filename(path:+"*.pm");
         }
         status=shell('maketags -t -o 'maybe_quote_filename(tagfilename)' 'std_libs' 'maybe_quote_filename(extra_file));
#endif
         if (!tfindex) {
            tfindex=insert_name('def-tagfiles-'ext,MISC_TYPE,_encode_vsroot(tagfilename,true,false));
         } else {
            set_name_info(tfindex,_encode_vsroot(tagfilename,true,false));
         }
         _config_modify|=CFGMODIFY_DEFDATA;
         _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
         _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
         //stop();
         //_message('abort');
         //return(0);
      } else {
         status=1;
      }
   }
   return(status);
}
