/*
$VerboseHistory: project.e$
*/
#include 'slick.sh'

#define PROJECT_MINFORMWIDTH 5300
#define PROJECT_MINFORMHEIGHT 3000

#define MenuOpen _pic_fldopen
#define MenuClose _pic_fldclos
#define MenuItem _pic_file

#define PROJPROPTAB_FILES 0
#define PROJPROPTAB_DIRECTORIES 1
#define PROJPROPTAB_TOOLS 2
#define PROJPROPTAB_FILTERS 3
#define PROJPROPTAB_OPENCOMMAND 4

#define AssociatedMakefile       ctlassociate.p_user
#define PROJECT_FILE_LIST_MODIFIED  _srcfile_list.p_user
#define REFRESH_BUTTON_PRESSED   ctlrefresh.p_user
//AssociatedMakefile is the makefilename and type, separated by a tab

#if __UNIX__
   #define  C_WILDCARDS   "*.c;*.cxx;*.cpp;*.h;*.hpp"
#else
   #define  C_WILDCARDS   "*.c;*.cxx;*.cpp;*.h;*.hpp;*.inl"
#endif

#define TOOLNAMEKEYPREFIX "usertool_"

static _str _project_load_callback(reason,var result,key);
static _str gProjectName;
static typeless macroflags;
static typeless macromax_Noflines;
static typeless macromax_filesize;

// If 1, ignore on_change events to _openfile_list:
static int gProjectIgnoreOnChange = 0;

_control _prjinclude_dirs,_prjtag_files,_prjref_files
#if __UNIX__
   #define PRJ_DEFAULT_FILE 'uproject.slk'
   #define PRJ_PACKS_FILE 'uprjpack.slk'
#else
   #define PRJ_DEFAULT_FILE 'project.slk'
   #define PRJ_PACKS_FILE 'prjpacks.slk'
#endif
#define PRJ_TAG_FILE_EXT '.vtg'
#define PRJ_FILE_EXT '.vpj'
#define MIN_SPACE_BEFORE_PATH 200

static _str filterDefaultName[] = {
   "Source Files"
   ,"Header Files"
   ,"Resource Files"
   ,"Bitmaps"
   ,"Other Files"
};

// Note: We have to use a hash table for pattern, app command, and file association
//       because the user project file may have the filter names in a different order
//       from what we default here. These hash tables are keyed on the lowcased
//       filter names.
static _str filterDefaultPattern:[] = {
#if __UNIX__
   "source files"    => "*.c;*.C;*.cc;*.cpp;*.cxx;*.hxx;*.prg;*.pas;*.dpr;*.asm;*.bas;*.java;*.sc;*.e"
   ,"header files"   => "*.h;*.H;*.hh;*.hpp;*.inc;*.sh"
   ,"resource files" => "*.rc;*.ico;*.cur;*.dlg"
   ,"bitmaps"        => "*.bmp;*.xpm;*.xbm"
   ,"other files"    => ALLFILES_RE
#else
   "source files"    => "*.c;*.cpp;*.cxx;*.hxx;*.prg;*.pas;*.dpr;*.asm;*.bas;*.java;*.sc;*.e"
   ,"header files"   => "*.h;*.hpp;*.inc;*.sh"
   ,"resource files" => "*.rc;*.ico;*.cur;*.dlg"
   ,"bitmaps"        => "*.bmp"
   ,"other files"    => ALLFILES_RE
#endif
   };
static int filterDefaultFileAssociation:[] = {
#if __UNIX__
   "source files"    => 0
   ,"header files"   => 0
   ,"resource files" => 0
   ,"bitmaps"        => 0
   ,"other files"    => 0
#else
   "source files"    => 0
   ,"header files"   => 0
   ,"resource files" => 1
   ,"bitmaps"        => 1
   ,"other files"    => 0
#endif
};
static _str filterDefaultAppCommand:[] = {
#if __UNIX__
   "source files"    => ""
   ,"header files"   => ""
   ,"resource files" => ""
   ,"bitmaps"        => "xv %f"
   ,"other files"    => ""
#else
   "source files"    => ""
   ,"header files"   => ""
   ,"resource files" => ""
   ,"bitmaps"        => ""
   ,"other files"    => ""
#endif
};

// Set _compiler_default to non-null to define a default compiler package:
_str _compiler_default;
static _str _compiler_restore = "";

#define saveNone 0
#define saveCurrent 1
#define saveAll 2
#define saveModified 3

static struct ProjectToolStruct {
   _str name;             // tool name displayed in combo box
   _str nameKey;          // key to tool info in project file
   _str menuCmd;          // menu command
   _str cmd;              // command line
   _str caption;          // menu caption
   _str accel;            // menu key bindings
   int outputConcur;      // 1=output to concurrent process buffer
   int captureOutput;     // 1=capture output
   int hideIfNoCmd;       // 1=hide from menu if command line is ""
   int clearProcessBuf;   // 1=clear the process buffer
   int saveOptions;       // 0=none,1=current,2=all,3=modified
   int changeDir;         // 1=change to project directory
   int explicitSave;      // 1=explicit save option: option was from project file
                          //  or directly selected using toggle buttons. This is set
                          //  to 0 when project file does not specify explicit save
                          //  options and we default to def_save_on_compile
};
static ProjectToolStruct projectToolList[];
static ProjectToolStruct projectToolListSaved[];
static int projectToolListStateSaved = 0;
static ProjectToolStruct predefToolList[] = {
   {"Compile",   "compile", "project-compile", "",  "&Compile",  "",  1,1,0, 0,saveCurrent,1}
   ,{"Build",    "make",    "project-build",   "",  "&Build",    "",  1,1,0, 0,saveNone,1}
   ,{"Rebuild",  "rebuild", "project-rebuild", "",  "&Rebuild",  "",  1,1,0, 0,saveNone,1}
   ,{"Debug",    "debug",   "project-debug",   "",  "&Debug",    "",  0,0,0, 0,saveNone,1}
   ,{"Execute",  "execute", "project-execute", "",  "E&xecute",  "",  0,0,0, 0,saveNone,1}
   ,{"User 1",   "user1",   "project-user1",   "",  "User 1",    "",  0,0,1, 0,saveNone,1}
   ,{"User 2",   "user2",   "project-user2",   "",  "User 2",    "",  0,0,1, 0,saveNone,1}
};
static ProjectToolStruct projectExtensionProjectsHT:[][];

static struct ProjectFilterStruct {
   _str name;             // filter name
   _str pattern;          // filter pattern: each subpattern semicolon separated
   _str command;          // application command
   int useFileAssoc;      // 1=use file association (Windows only)
};
static ProjectFilterStruct projectFilterList[];
static int gProjectIgnoreToolSaveOptions = 0;


definit()
{
   // Read and parse all the extension projects tools:
   initPredefinedToolList();
   readAndParseAllExtensionProjects();

   // Initialize the project tool table:
   // We need this tool table initialized and consistent at all
   // times to update the menubar's project menu.
   initPredefinedToolList();
   _in_project_close=false;
   rc=0;
}
void _project_refresh()
{
   _tbSetRefreshBy(VSTBREFRESHBY_PROJECT);
   initPredefinedToolList();
   readAndParseAllExtensionProjects();

   // Initialize the project tool table:
   // We need this tool table initialized and consistent at all
   // times to update the menubar's project menu.
   initPredefinedToolList();
   if (_project_name!="") {
      readAndParseProjectToolList(_project_name,"COMPILER",0,junk);

      //Just in case tag files for project were modified
      _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
      // Just in case there is an associaed makefile
      MaybeUpdateProjectToMakeFile(1,0);
      // Just in case project files were modified
      toolbarUpdateFilterList(_project_name);
   }
}

static void adjust_filespec(_str &vslickpathfilename)
{
#if !__UNIX__
   comspec=get_env("COMSPEC")" /c";
   if (file_eq(substr(vslickpathfilename,1,length(comspec)),comspec)) {
      vslickpathfilename=strip(substr(vslickpathfilename,length(comspec)+1));
      if (machine()!="OS2386") {
          if (file_match("-p "vslickpathfilename".bat",1)!="") {
             vslickpathfilename=vslickpathfilename".bat";
             return;
          }
      }
      if (file_match("-p "vslickpathfilename".cmd",1)!="") {
         vslickpathfilename=vslickpathfilename".cmd";
         return;
      }
   }
#endif
}
static _str whichpath( filename )
{
   if (filename=="") { return( "" ); }
   // We want this one to act like user typed command on command line
   // except we don't look for internal editor commands.
   vslickpathfilename=slick_path_search(filename,"M");
   // We want this one to act like user is at shell prompt.
   pathfilename=path_search(filename,"","P");
   adjust_filespec(vslickpathfilename);
   adjust_filespec(pathfilename);
   //sticky_message("VSLICKPATH found <"vslickpathfilename">   PATH found <"pathfilename">");
   return( pathfilename );
}
static int parseExeAndFileCommand( _str cmd, _str filename, _str & execmd )
{
   //messageNwait("cmd="cmd);
   endw = "";
   temp = cmd;
   execmd = cmd;
   qtemp = maybe_quote_filename(temp);
   for (;;) {
      //messageNwait( "b4 qtemp="qtemp );
      fn = file_match("-p "qtemp, 1 );
      if ( fn != "" ) {
         execmd = qtemp" "endw;
         //messageNwait( "a1 cmd="execmd );
         return( 0 );
      }
      fullpath = whichpath( qtemp );
      if ( (fullpath != "") && (fullpath == qtemp) ) {
         execmd = qtemp" "endw;
         //messageNwait( "a3 cmd="execmd );
         return( 0 );
      }
      w = strip_last_word( temp );
      //messageNwait( "w="w );
      if ( temp == "" ) {
         //messageNwait( "a2 cmd="execmd );
         return( 1 );
      }
      // Replace name specifier with the buffer name:
      addfile = 0;
      if ( pos( "%F", w ) ) {
         parse w with p1 "%F" p2;
         addfile = 1;
      } else if ( pos( "%f", w )  ) {
         parse w with p1 "%f" p2;
         addfile = 1;
      } else if ( pos( "%1", w ) ) {
         parse w with p1 "%1" p2;
         addfile = 1;
      } else {
         if ( endw != "" ) endw = w" "endw;
         else endw = w;
      }
      if ( addfile ) {
         p1 = stranslate( p1,'','"');
         p2 = stranslate( p2,'','"');
         w = p1 filename p2;
         w = maybe_quote_filename( w );
         if ( endw != "" ) endw = w" "endw;
         else endw = w;
      }
      //messageNwait( "endw="endw );
      qtemp = maybe_quote_filename(temp);
   }
}
_command project_save()
{
   if (_project_name=='') return('');
   if (arg(1)=='') {
      //_ini_get_value(_project_name, "AUTO RESTORE", state_name, workspace_name,"STATE");
      workspace_name=get_workspace_name(1);
      if (workspace_name=='') {
         workspace_name="STATE";
      }
   }else{
      workspace_name=arg(1);
   }
   if (workspace_name!="STATE") {
      workspace_name="STATE.":+workspace_name;
   }
   view_id=_create_temp_view(temp_view_id);
   activate_view view_id;

   save_window_config('','p',temp_view_id);
   _ini_put_section(_project_name, workspace_name, temp_view_id);
   //_ini_set_value(_project_name, "AUTO RESTORE", "state_name", workspace_name);
}

static get_workspace_name()
{
   status=_open_temp_view(_project_name, temp_view_id, orig_view_id);
   if (status) {
      return('');
   }
   p_view_id=temp_view_id;
   temp_view_id=_create_temp_view(list_view_id);
   p_view_id=list_view_id;
   insert_line(' Default Desktop');
   p_view_id=temp_view_id;
   top();up();
   for (;;) {
      status=search('^\[STATE\.','@ri');
      if (status) {
         break;
      }
      get_line(line);_end_line();
      parse line with 'STATE.' workspace_name ']' .
      p_view_id=list_view_id;
      insert_line(' 'workspace_name);
      p_view_id=temp_view_id;
   }
   p_view_id=list_view_id;
   if (p_noflines==1) {
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
      _delete_temp_view(list_view_id);
      return('');
   }
   flags=SL_SELECTCLINE|SL_VIEWID;
   if (arg(1)==1) {
      flags=flags|SL_COMBO;
   }
   result=show('-modal _sellist_form',
               'Choose A Desktop',
               flags,
               list_view_id,
               '',
               '',
               '',
               '');
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   return(result);
}

_command project_restore()
{
   if (_project_name=='') {
      _message_box(nls("There is no project open."));
      return('');
   }
   status=list_modified(nls("Save Changes Before Closing"));
   if (status&&(status!=COMMAND_CANCELLED_RC)) {
      return(status);
   }
   if (arg(1)!='') {
      workspace_name='STATE.':+arg(1);
   }else{
      //_ini_get_value(_project_name, "AUTO RESTORE", "state_name", workspace_name, "STATE");
      name=get_workspace_name()
      if (name=='' || name=='Default Desktop') {
         workspace_name="STATE";
      }else{
         workspace_name="STATE."name;
      }
   }
   close_all2(keep_process_up(_project_name, workspace_name))
   status=_ini_get_section(_project_name, workspace_name, temp_view_id);
   if (status) {
      _message_box(nls("Could not find restore information in %s.",_project_name));
      return(1);
   }
   restore('', temp_view_id);
   _delete_temp_view(temp_view_id);
}
/* End Multiple Desktop Support */

int _OnUpdate_project_edit(CMDUI &cmdui,int target_wid,_str command)
{
    return(_OnUpdate_project_close(cmdui,target_wid,command));
}
_command void project_edit()
{
   _macro_delete_line();

   // No global project name ==> No project opened!
   if (_project_name=='') {
      editorctl_wid=p_window_id;
      if (!_isEditorCtl()) {
         if (_no_child_windows()) {
            _message_box(nls("There must be a window to set up extension specific project information."));
            return;
         }
         editorctl_wid=_mdi.p_child;
      }
      show('-mdi -modal _project_form','.'editorctl_wid.p_extension);
      return;
   }
   old_delay_filelist=def_delay_filelist;
   def_delay_filelist=0;
   mou_hour_glass(1);
   result=show('-mdi -modal _project_form',
        '',
        _last_wildcards,      // Initial wildcards
        //'*.c;*.h',
        def_file_types,
        OFN_ALLOWMULTISELECT|((def_delay_filelist)?OFN_DELAYFILELIST:0)|SL_INVERT,
        '',      // Default extension
        '',      // Initial filename
        '',      // Initial directory
        '',
        '',
        _project_name/*This is the name of the project to show source files for*/
        );
   mou_hour_glass(0);
   def_delay_filelist=old_delay_filelist;
}

int _OnUpdate_project_open(CMDUI &cmdui,int target_wid,_str command)
{
   parse command with cmdname filename;
   if (filename=="") {
      return(MF_ENABLED);
   }
   if (file_eq(strip(filename,'B','"'),_project_name)) {
      return(MF_ENABLED|MF_CHECKED);
   }
   return(MF_ENABLED|MF_UNCHECKED);
}
_command void project_open()  name_info(FILE_ARG'*,')
{
   _macro_delete_line();
   was_recording=_macro();
   result=arg(1);
   compiler_name=arg(2);
   restoring_from_invocation=arg(3);
   if (result=='') {
      _param2='';
      /*
      result=show('-mdi -modal _project_open_form -reinit',
               'Open Project',
               '*'PRJ_FILE_EXT,
               'Project Files(*'PRJ_FILE_EXT'), All Files('ALLFILES_RE')',
               OFN_FILEMUSTEXIST
               );
      */
      format_list='Project Files(*'PRJ_FILE_EXT'), All Files('ALLFILES_RE')';
      result=_OpenDialog(_stdform('_open_form')' -new -mdi -modal',
           'Open Project',
           '',     // Initial wildcards
           format_list,  // file types
           OFN_FILEMUSTEXIST,
           PRJ_FILE_EXT,      // Default extensions
           '',      // Initial filename
           '',      // Initial directory
           '',      // Reserved
           "Open Project dialog box"
           );
      if (result=='') {
         return;
      }
      if (_param2!='') {
         compiler_name=_param2;
      }
   }
   _macro('m',was_recording);
   if (compiler_name!='') {
      new_project_name=absolute(strip(result));
      _macro_call('project_open',result,compiler_name);
      if (_project_name!='') {
         //9:30pm 8/21/1997
         //arg(1)!='' means no callbacks
         status=project_close('',false,false);
         if (status) return;
      } else {
         if (def_restore_flags & RF_PROJECTFILES) {
            status=close_all2();
            if (status) return;
         }
      }
      call_list('_prjclose_');
      _project_name=new_project_name;
      _tbSetRefreshBy(VSTBREFRESHBY_PROJECT);
      _menu_add_prjhist(_project_name);
      if (compiler_name!='') {
         name=slick_path_search(PRJ_PACKS_FILE);
         status=_ini_get_section(name, compiler_name, ini_view_id);
         if (!status) {
            _ini_put_section(_project_name, _project_get_section("COMPILER"),ini_view_id);
         }
      }
      //_ini_get_value(_project_name, "COMPILER", 'tagfiles', info,'');_project_tagfiles=info;
      result=show('-modal _project_form',
           '',
           _last_wildcards,      // Initial wildcards
           //'*.c;*.h',
           def_file_types,
           OFN_ALLOWMULTISELECT|((def_delay_filelist)?OFN_DELAYFILELIST:0)|SL_INVERT,
           '',      // Default extension
           '',      // Initial filename
           '',      // Initial directory
           '',
           '',
           _project_name,/*This is the name of the project to show source files for*/
           0
           )
      toolbarUpdateFilterList(_project_name);
      return;
   }
   _macro_call('project_open',result);
   filename=absolute(result);
   if (file_match(maybe_quote_filename(filename)' -p', 1)=='') {
      _message_box(nls("Could not find project file %s.\n\nYou may wish to use New on the Open Project Dialog box.", filename));
      return;
   }
   if (filename==absolute(_project_name)) {
      return;
   }
   if (_project_name!=''){
      /*
         For now, when 
         
             Restore Project Files is on,
             and Restore Process Buffer is off
             and a process buffer is up in a window
             
         we close the process buffer.  No one has
         complained about this.
      */
      status=project_close('' /*keep_process_up(filename)*/,false,false);
      if( status ) return;
   }
   _project_name=filename;
   _tbSetRefreshBy(VSTBREFRESHBY_PROJECT);
   _menu_add_prjhist(_project_name);
   get_view_id(view_id);
   preloaded=0;
   // status=_ini_get_value(_project_name, "COMPILER",'tagfiles',info,'');_project_tagfiles=info;
#if 0
   status=_ini_get_value(_project_get_filename(),"AUTO RESTORE",'preload', info)
   if (lowcase(info)=='y') {
      preload_files();
      preloaded=1;
   }
#endif
   //status=_ini_get_value(_project_get_filename(),"AUTO RESTORE",'auto_restore', info)
   if (def_restore_flags & RF_PROJECTFILES) {
      //_ini_get_value(_project_name, "AUTO RESTORE", "state_name", workspace_name,'STATE');
      workspace_name="STATE";
      status=_ini_get_section(_project_get_filename(), workspace_name, ini_view_id);
      activate_view(view_id);
      if (!status) {
         restore(restoring_from_invocation,ini_view_id);
         _delete_temp_view(ini_view_id);
      }
   }
   _ini_get_value(_project_name,"COMPILER","WORKINGDIR",cwd);
   cwd=_parse_project_command(cwd, '', _project_get_filename(),'');
   if (cwd!='') cd(cwd);
   _project_run_macro();

   // Initialize the project tool table:
   // We need this tool table initialized and consistent at all
   // times to update the menubar's project menu.
   initPredefinedToolList();
   readAndParseProjectToolList(_project_name,"COMPILER",0,junk);

   //9:19am 8/14/1997
   //Dan added for browser support
   _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
   _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   MaybeUpdateProjectToMakeFile(1,0);
   toolbarUpdateFilterList(_project_name);
   /*if (file_match('-p 'maybe_quote_filename(strip_filename(_project_name,'e'):+TAG_FILE_EXT),1)=="") {
      // If we don't have a project tag file.
      _project_update_files_retag(true,false,false,true);
   } */
}
void _project_run_macro()
{
   _ini_get_value(_project_name,"COMPILER","MACRO",line);
   line=_ini_xlat_multiline(line);
   for (;;) {
      if (line=='') break;
      parse line with command (_chr(13)) line
      execute(command);
   }
   call_list('_prjopen_');
}

/*
_command project_rename()
{
   if (_project_name=='') {
      _message_box(nls("There is Currently No Project Open"));
      return('');
   }
   result=show('-modal _project_rename_form');
   if (result=='') {
      return('');
   }
   if (get_extension(result)=='') {
      result=result:+'.vpj';
   }
   if (file_match(result' -p',1)!='') {
      _message_box(nls("Project %s already exists.", result));
      return('');
   }
   old_name=_project_name;
#if __UNIX__
   status=shell('mv 'old_name' 'result);
#else
   status=shell('ren 'old_name' 'strip_filename(result,'p'));
#endif
   filename=absolute(result);
   if (file_match(filename:+' -p',1)=='') {
      _message_box(nls("Could not rename %s to %s.\n\n%s may already exist",_project_name,result, result));
      return('');
   }
   _project_name=absolute(result);
   status=_menu_find(_mdi.p_menu_handle,'prjhist',menu_handle,menu_pos,'C');
   if (!status) {
      _menu_delete(menu_handle,menu_pos+1);
      _menu_add_prjhist(_project_name);
      _menu_set_state(menu_handle,menu_pos+1,MF_CHECKED,'p');
   } else {
      _menu_add_prjhist(_project_name);
   }
   return(_project_name);
}
*/
int _OnUpdate_project_close(CMDUI &cmdui,int target_wid,_str command)
{
   if (_project_name=='') {
      if (translate(command,'_','-') :=='project_edit') {
         if (_no_child_windows()) {
            return(MF_GRAYED);
         }
         return(MF_ENABLED);
      }
      return(MF_GRAYED);
   }
   return(MF_ENABLED);
}

_command int project_close(_str notused="",
                           boolean save_project_state_during_auto_restore=false,
                           boolean DoTagFileRefresh=true)
{
   _in_project_close=true;
   //save_project_state_during_auto_restore=arg(2)=='X';
   //DoTagFileRefresh=arg(3)
   if (_project_name=='') {
      _in_project_close=false;
      return(0);
   }
   toolbarSaveExpansion(_project_name);
   orig_view_id=_create_temp_view(temp_view_id);
   activate_view orig_view_id;

   workspace_name="STATE";
   status=_open_temp_view(_project_get_filename(),ini_view_id,orig_view_id,'+d')
   if (!status) {
      activate_view orig_view_id
      save_window_config('','p',temp_view_id);
      activate_view ini_view_id;
      status=_ini_put_section2(workspace_name, temp_view_id);
      // Delete ini buffer and view
      _delete_buffer();_quit_view();
   }
   _delete_temp_view(temp_view_id);
   tag_close_bsc();
   activate_view(orig_view_id);
   // IF we are NOT saving state because we are exiting the editor
   if (!save_project_state_during_auto_restore) {
      if (def_restore_flags & RF_PROJECTFILES) {
         status=close_all2();
         _in_project_close=false;
         if (status) return(1);
      }
      tag_close_db(strip_filename(_project_name,'E'):+TAG_FILE_EXT);
      _project_name='';
      _tbSetRefreshBy(VSTBREFRESHBY_PROJECT);
      toolbarUpdateFilterList("");
      //_project_tagfiles='';
   }
   //9:19am 8/14/1997
   //Dan added for completeness
   if (!save_project_state_during_auto_restore) {
      call_list('_prjclose_');
   }
   //9:19am 8/14/1997
   //Dan added for browser support
   if (DoTagFileRefresh) {
      _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   }
   _in_project_close=false;
   return(0);
}

_command void project_new()
{
   _macro_delete_line();
   was_recording=_macro();
   _str result;
   compiler_name="";
   result = show('-modal _project_new_form');
   if (result=='') {
      return;
   }
   if (_param2!='') {
      compiler_name=_param2;
   }
   //messageNwait("projectname="result" compiler_name="compiler_name);
   _macro('m',was_recording);

   // If there is an open project, close it:
   new_project_name=absolute(strip(result));
   _macro_call('project_open',result,compiler_name);
   if (_project_name!='') {
      //9:30pm 8/21/1997
      //arg(1)!='' means no callbacks
      status=project_close('',false,false);
      if (status) return;
   } else {
      if (def_restore_flags & RF_PROJECTFILES) {
         status=close_all2();
         if (status) return;
      }
   }
   call_list('_prjclose_');

   // Init menu item for new project:
   _project_name=new_project_name;
   // Create the project tag file
   project_tag_filename=strip_filename(_project_name,'E'):+TAG_FILE_EXT;
   tag_close_db(project_tag_filename);
   tag_create_db(project_tag_filename);
   tag_close_db(project_tag_filename);
   _tbSetRefreshBy(VSTBREFRESHBY_PROJECT);
   _menu_add_prjhist(_project_name);

   // Init the default project properties and show the properties form:
   name=slick_path_search(PRJ_PACKS_FILE);
   status=_ini_get_section(name, compiler_name, ini_view_id);
   if (!status) {
      _ini_put_section(_project_name, _project_get_section("COMPILER"),ini_view_id);
      _ini_get_value(_project_name,_project_get_section("COMPILER"),"execute",result);
      new_result=stranslate(result,_param1,"%<e");
      if (new_result!=result) {
         _ini_set_value(_project_name,_project_get_section("COMPILER"),"execute",new_result);
      }
      _ini_get_value(_project_name,_project_get_section("COMPILER"),"debug",result);
      new_result=stranslate(result,_param1,"%<e");
      if (new_result!=result) {
         _ini_set_value(_project_name,_project_get_section("COMPILER"),"debug",new_result);
      }
   }
   result=show('-modal _project_form',
        '',
        _last_wildcards,      // Initial wildcards
        //'*.c;*.h',
        def_file_types,
        OFN_ALLOWMULTISELECT|((def_delay_filelist)?OFN_DELAYFILELIST:0)|SL_INVERT,
        '',      // Default extension
        '',      // Initial filename
        '',      // Initial directory
        '',
        '',
        _project_name,/*This is the name of the project to show source files for*/
        0
        )
   toolbarUpdateFilterList(_project_name);
   return;
}
int _OnUpdate_project_save_as(CMDUI &cmdui,int target_wid,_str command)
{
    return(_OnUpdate_project_close(cmdui,target_wid,command));
}

/*
   Save the current project under a different name.
*/
_command int project_save_as()
{
   if (_project_name=='') return(0);
   orig_wid=p_window_id;
   format_list='Project Files(*'PRJ_FILE_EXT'), All Files('ALLFILES_RE')';
   result=_OpenDialog(_stdform('_open_form')' -new -mdi -modal',
        'Save Project As',
        '',     // Initial wildcards
        //'*.c;*.h',
        format_list,  // file types
        OFN_SAVEAS/*OFN_KEEPOLDFILE|*/,
        PRJ_FILE_EXT,      // Default extensions
        maybe_quote_filename(_project_name)      // Initial filename
   );
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   _str newProjectDiskFileName;
   newProjectDiskFileName = result;
   //messageNwait('newProjectDiskFileName='newProjectDiskFileName);

   // This check makes sure that we are not overwriting the current
   // project file:
   if (newProjectDiskFileName :!= _project_name) {
      // Delete the new project file on disk, if it exists:
      // This is for the case of "overwriting an existing project file")
      if (file_match(newProjectDiskFileName' -p',1)!='') {
         status = delete_file(newProjectDiskFileName);
         if (status) {
            return(status);
         }
      }
      // Copy the original project file over to the new project file:
      status = copy_file(_project_name, newProjectDiskFileName);
      if (status) {
         return(status);
      }
   }

   // Save the current project state to the new project file:
   //
   // It is possible that the new project file is the same as the
   // current project.  If this is the case, the net effect is an
   // updated project file.
   orig_view_id=_create_temp_view(temp_view_id);
   activate_view orig_view_id;
   workspace_name="STATE";
   status=_open_temp_view(newProjectDiskFileName,ini_view_id,orig_view_id,'+d')
   if (!status) {
      activate_view orig_view_id
      save_window_config('','p',temp_view_id);
      activate_view ini_view_id;
      status=_ini_put_section2(workspace_name, temp_view_id);
      // Delete ini buffer and view
      _delete_buffer();_quit_view();
   }
   _delete_temp_view(temp_view_id);
   activate_view orig_view_id;

   // New project name:
   _project_name= newProjectDiskFileName;
   _tbSetRefreshBy(VSTBREFRESHBY_PROJECT);

   _menu_add_prjhist(_project_name);
   return(0);
}

_str _project_get_filename()
{
   if (_project_name!='') {
      project_filename=_project_name;
   }else{
      project_filename=slick_path_search(PRJ_DEFAULT_FILE);
   }
   return(project_filename);
}

_str _project_get_section(...)
{
   if (_project_name=='') {
      return('.'_mdi.p_child.p_extension);
   }
   return(arg(1));
}

_str def_max_prjhist;
boolean _project_save_restore_done;

int _srg_project()
{
   // If restoring with no files or restoring with files
   if (arg(1)=='N' || arg(1)=='R') {
      // Only restore project if user has selected to restore current directory
      parse arg(2) with Noffiles project_name
      if (!def_max_prjhist || !_mdi.p_menu_handle || !Noffiles) {
         down(Noffiles);
      } else {
         for (i=1;i<=Noffiles;++i) {
            down
            if (i<=def_max_prjhist) {
               get_line(filename);
               _menu_add_prjhist(filename);
            }
         }
      }
      // Project could have been openned because the user specified
      // a project file name as an invocation argument
      // IF a project is not already openned
      if (_project_name=="") {
         _project_name=project_name;
         //_tbSetRefreshBy(VSTBREFRESHBY_PROJECT);
      }
      if (_project_name!="") {
         _menu_add_prjhist(_project_name);
         _project_refresh();
         /*
         // Initialize the project tool table:
         // We need this tool table initialized and consistent at all
         // times to update the menubar's project menu.
         initPredefinedToolList();
         readAndParseProjectToolList(_project_name,"COMPILER",0);
         */

      }
      if (_isscc(def_vc_system) && machine()=='NT386') {
         _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcsproject',vcsproject,'')
         vcs=substr(def_vc_system,5);
         if (vcs!=vsSccGetCurProjectInfo(VSSCC_PROVIDER_NAME)) {
            status=vsSccInit(vcs);
            if (status) {
               _message_box(nls("Could not initialize %s",def_vc_system));
               _message_box(nls("status=%s",status));
               return(status);
            }
         }
         _ini_get_value(_project_get_filename(),_vcs_project_get_section("COMPILER"), 'vcslocalpath',vcslocalpath,'')

         //Order is important here...
         vcsproject=substr(vcsproject,SCC_PREFIX_LENGTH+1);
         vcslocalpath=substr(vcslocalpath,SCC_PREFIX_LENGTH+1);

         if (substr(vcsproject,1,length(vcs':'))==vcs:+':') {
            prjvcs=substr(vcsproject,1,length(vcs));
            vcsproject=substr(vcsproject,length(vcs':')+1);
         }

         if (substr(vcslocalpath,1,length(vcs':'))==vcs:+':') {
            localpathvcs=substr(vcslocalpath,1,length(vcs));
            vcslocalpath=substr(vcslocalpath,length(vcs':')+1);
         }

         //vcsproject=MaybeStripLeadingVCSName(vcsproject,prjvcs);
         //vcslocalpath=MaybeStripLeadingVCSName(vcslocalpath,localpathvcs);

         if (prjvcs==vcs && localpathvcs==vcs && vcsproject!='') {
            //use project and local_path because they are the stripped versions(no SCC:)
            status=vsSccOpenProject(0,'',vcsproject,vcslocalpath);
            if (status) {
               _message_box(nls("Could not open %s project %s",vcs,vcsproject));
               vsSccCloseProject();
               //return(status);
               //don't want to stop restore...
            }
         }
      }
   } else {
      if (_project_save_restore_done) {
         return(0);
      }
      //2:30pm 10/29/1998
      //arg(1) is not used
      //The 'X' as the second argument means that we are just saving project
      //information. '' as the 3rd argument means do not refresh tag files
      project_close('',true,false /* No Tag File refresh*/);
      count=0;
      if (def_max_prjhist && _mdi.p_menu_handle) {
         // Look for the menu files separator
         status=_menu_find(_mdi.p_menu_handle,'prjhist',dash_mh,dash_pos,'c');
         count=0;
         if (! status) {
            Nofitems=_menu_info(dash_mh,'c');
            for (i=Nofitems-1; i>=dash_pos+1 ;++count,--i) {
               _menu_get_state(dash_mh,i,flags,'p',caption,command);
               parse command with . filename;
               insert_line(strip(filename,'B',"\""));
            }
            up(count);
         }
      }
      insert_line("PROJECT: "count" "_project_name);
      down(count);
   }
   return(0);
}

#if 0
_str spit_file()
{
   /*THIS IS JUST FOR DEBUGGING*/
   top();up();
   for (;;) {
      if (down()) {
         break;
      }
      get_line line;
      messageNwait('line='line);
   }
}
#endif

defeventtab _project_form;
// Desc:  Get the list of tools for the the current project.
void projectToolGetList(_str (&toolNameList)[],    // Tool name displayed in combo box
                                                   // "Build" or "API Help"
                        _str (&toolCaptionList)[], // menu caption
                                                   // "&Build" or "Tornado API &Help"
                        _str (&toolMenuCmdList)[], // menu command project-build or
                                                   // project-usertool usertool_api_help
                        _str (&toolCmdList)[],     // command line to parse in parts and execute
                        _str extension
                        )
{
   // If the project tool list is empty, initialize it with
   // the predefined tool list:
   if (projectToolList._length() == 0) {
      initPredefinedToolList();
   }

   // If there is no real project open, check to see if there
   // is an extension project and use it:
   if (_project_name == "") {
      _str ext;
      ext = "." :+ _file_case(extension);
      if (extension!="" && projectExtensionProjectsHT._indexin(ext)) {
         projectToolList = projectExtensionProjectsHT:[ext];
      } else {
         initPredefinedToolList();
      }
   }

   // Build the arrays tool for the menu system:
   // Only list the tools that are supposed to be shown.
   toolNameList._makeempty();
   toolCaptionList._makeempty();
   toolMenuCmdList._makeempty();
   toolCmdList._makeempty();
   int i;
   int count;
   count = 0;
   for (i=0; i<projectToolList._length(); i++) {
      _str text, cmdLine;

      // If tool does not have a command and there is an
      // active buffer, try to use the command from
      // the extension project of the active buffer's extension.
      cmdLine = projectToolList[i].cmd;
      if (cmdLine == "" && _project_name != "") {
         // IF we have a target extension
         if (extension!="") {
            _str ext;
            ext= _file_case(".":+extension);
            if (projectExtensionProjectsHT._indexin(ext)) {
               ProjectToolStruct tempToolList[];
               tempToolList = projectExtensionProjectsHT:[ext];
               int toolIndex;
               if (isToolNameInProjectToolTable(tempToolList,
                        projectToolList[i].name,toolIndex)) {
                  if (tempToolList[toolIndex].cmd != "") {
                     cmdLine = tempToolList[toolIndex].cmd;
                     //say("Using "ext" "projectToolList[i].name" "cmdLine);
                  }
               }
            }
         }
      }

      // If tool still does not have a command...
      if (projectToolList[i].hideIfNoCmd && cmdLine == "") continue;
      toolNameList[count] = projectToolList[i].name;
      text = projectToolList[i].caption;
      if (projectToolList[i].accel != "") {
         text = text :+ "\t" :+ projectToolList[i].accel;
      }
      toolCaptionList[count] = text;

      // For non-predefined user tools, concat the tool key:
      text = projectToolList[i].menuCmd;
      if (i >= predefToolList._length()) {
         text = text :+ " " :+ projectToolList[i].nameKey;
      }
      toolMenuCmdList[count] = text;

      // If the command line requires a file name (or variations of it)
      // or a current word, and there is no edit window, treat the
      // item as if it has no command line:
      _str tempCmdLine;
      tempCmdLine = stranslate(cmdLine,"","%%");
      if (extension=="" &&
            pos("(%f)|(%p)|(%n)|(%e)|(%w)",tempCmdLine,1,"RI")
         ) {
         cmdLine = "";
      } else if (_project_name=="" && pos("(%r)|(%rp)|(%rn)",tempCmdLine,1,"RI")) {
         cmdLine = "";
      }
      toolCmdList[count] = cmdLine;

      //say(toolNameList[count]" "toolMenuCmdList[count]);
      count++;
   }
}
void ctlToolDelete.lbutton_up()
{
   // Make sure the tool to be deleted is not one of the
   // predefined ones:
   // (This cenario can not happen because the Delete button
   //  should be grayed out at this time.)
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   if (toolIndex < predefToolList._length()) {
      return;
   }

   // Delete tool from list:
   // We do this by moving every upper entries down one index
   // and deleting the last known element in the array.
   int count;
   count = projectToolList._length();
   int i;
   for (i=toolIndex; i<(count-1); i++) {
      projectToolList[i] = projectToolList[i+1];
   }
   projectToolList._deleteel(count-1);

   // Delete the entry from the list box:
   int listwid;
   listwid = ctlToolName.p_cb_list_box;
   listwid.p_line = toolIndex + 1;
   listwid._lbdelete_item();

   // Select the next item in the list box:
   ctlToolName.p_text = listwid._lbget_text();
}
void ctlToolNew.lbutton_up()
{
   // Prompt the user for a new tool name:
   _str result;
   result = show('-modal _textbox_form',
                 'New Project Tool',             //Captions
                 0,                              //Flags
                 2000,                           //use default textbox width
                 '?Type a name for the new tool and press ENTER to add the tool.',   //Help item
                 '',                             //Font(no support yet)
                 '',                //Retrieve Name
                 'New Tool Name:'//Prompt
                 );
   //_param1 = '' if someone presses ok on an empty box
   if (result == '' || _param1 == '') {
      return;
   }
   //messageNwait("_param1="_param1);
   _str name;
   name = _param1;
   name = strip(name);  // strip any leading and trailing spaces

   // Make sure that there are no colons or commas in tool name:
   if (pos(":",name) || pos(",",name)) {
      _message_box(nls("Tool name cannot contain ':' (colon) or ',' (comma)."));
      return;
   }

   // Check to make sure that the new tool name does not
   // already exist:
   int toolIndex;
   if (isToolNameInProjectToolTable(projectToolList,name,toolIndex)) {
      _message_box(nls("Tool '%s' already exists in project.",name));
      return;
   }

   // Create a new tool:
   ProjectToolStruct toolInfo;
   toolInfo.name = name;
   name = translate(name,"_"," ");
   toolInfo.nameKey = lowcase(TOOLNAMEKEYPREFIX :+ name);
   toolInfo.cmd = "";
   toolInfo.menuCmd = "project-usertool";
   toolInfo.caption = "&" :+ toolInfo.name;
   toolInfo.outputConcur = 0;
   toolInfo.captureOutput = 0;
   toolInfo.hideIfNoCmd = 1;
   toolInfo.accel = "";
   toolInfo.clearProcessBuf = 0;
   toolInfo.saveOptions = saveNone;
   toolInfo.changeDir = 1;
   toolInfo.explicitSave = 1;  // new tool always default to explicit save

   // Append the new tool to the end of the tool list:
   toolIndex = projectToolList._length();
   projectToolList[toolIndex] = toolInfo;
   int listwid;
   listwid = ctlToolName.p_cb_list_box;
   listwid._lbbottom();
   listwid._lbadd_item(toolInfo.name);

   // Select the new tool and put focus on the command text box:
   ctlToolName.p_text = toolInfo.name;
   ctlToolCmdLine._set_focus();
   ctlToolCmdLine._set_sel(1);  // move text cursor to start of line
}
void ctlToolHide.lbutton_up()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].hideIfNoCmd = ctlToolHide.p_value;
}
void ctlToolClearProcessBuf.lbutton_up()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].clearProcessBuf = ctlToolClearProcessBuf.p_value;
}
void ctlToolCaptureOutput.lbutton_up()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].captureOutput = ctlToolCaptureOutput.p_value;
   if (!p_value) {
      ctlToolOutputToConcur.p_value=0;
      ctlToolOutputToConcur.p_enabled = false;
      ctlToolClearProcessBuf.p_value=0;
      ctlToolClearProcessBuf.p_enabled = false;
   } else {
      ctlToolOutputToConcur.p_value=0;
      ctlToolOutputToConcur.p_enabled = true;
      ctlToolClearProcessBuf.p_value=0;
      ctlToolClearProcessBuf.p_enabled = false;
      //If ctlToolOutputToConcur.p_value is false, this is supposed to be disabled - DWH
   }
}
void ctlToolOutputToConcur.lbutton_up()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].outputConcur = ctlToolOutputToConcur.p_value;
   if (projectToolList[toolIndex].outputConcur) {
      ctlToolClearProcessBuf.p_enabled = true;
   } else {
      ctlToolClearProcessBuf.p_enabled = false;
      ctlToolClearProcessBuf.p_value = 0;
   }
}
void ctlToolMenuCaption.on_change()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].caption = ctlToolMenuCaption.p_text;
}
void ctlToolCmdLine.on_change()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].cmd = ctlToolCmdLine.p_text;

   // Check the original option flag from the project file and see if there
   // is an explicit set for the save options. If the save option was not
   // explicitly set by the project file or by the user clicking on the
   // toggle buttons, parse the command as the user types and selects the
   // save option based on def_save_on_compile. Otherwise, don't do anything.
   if (!projectToolList[toolIndex].explicitSave) {
      _str tOption;
      _str key;
      key = projectToolList[toolIndex].nameKey;
      tOption = "0";
      if (pos("(%f)|(%p)|(%n)|(%e)",projectToolList[toolIndex].cmd,1,"RI")) {
         parse def_save_on_compile with tOption .;
      } else if (key == "make" || key == "rebuild") {
         parse def_save_on_compile with . tOption;
      }
      projectToolList[toolIndex].saveOptions = (int)tOption;  // values already mapped to constants so we can do this crude assignment
      updateSaveOptions(projectToolList[toolIndex].saveOptions);
   }
}
void ctlToolSaveCurrent.lbutton_up()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].saveOptions = saveCurrent;
   if (!gProjectIgnoreToolSaveOptions) {
      projectToolList[toolIndex].explicitSave = 1;
   }
}
void ctlToolSaveAll.lbutton_up()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].saveOptions = saveAll;
   if (!gProjectIgnoreToolSaveOptions) {
      projectToolList[toolIndex].explicitSave = 1;
   }
}
void ctlToolSaveModified.lbutton_up()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].saveOptions = saveModified;
   if (!gProjectIgnoreToolSaveOptions) {
      projectToolList[toolIndex].explicitSave = 1;
   }
}
void ctlToolSaveNone.lbutton_up()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].saveOptions = saveNone;
   if (!gProjectIgnoreToolSaveOptions) {
      projectToolList[toolIndex].explicitSave = 1;
   }
}
void ctlToolChangeDir.lbutton_up()
{
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   projectToolList[toolIndex].changeDir = ctlToolChangeDir.p_value;
}

// Desc: Make sure save options are consistent with each other.
static void updateSaveOptions(int saveOptions)
{
   // Set this global flag to differentiate between a programmatic set/clear
   // of the toggle buttons (like what's being done in this code) and a user
   // actually clicking on the toggle buttons.
   gProjectIgnoreToolSaveOptions = 1;

   // Change the radio buttons values.
   switch (saveOptions) {
   case saveNone:
      ctlToolSaveCurrent.p_value = 0;
      ctlToolSaveAll.p_value = 0;
      ctlToolSaveModified.p_value = 0;
      ctlToolSaveNone.p_value = 1;
      break;
   case saveCurrent:
      ctlToolSaveCurrent.p_value = 1;
      ctlToolSaveAll.p_value = 0;
      ctlToolSaveModified.p_value = 0;
      ctlToolSaveNone.p_value = 0;
      break;
   case saveAll:
      ctlToolSaveCurrent.p_value = 0;
      ctlToolSaveAll.p_value = 1;
      ctlToolSaveModified.p_value = 0;
      ctlToolSaveNone.p_value = 0;
      break;
   case saveModified:
      ctlToolSaveCurrent.p_value = 0;
      ctlToolSaveAll.p_value = 0;
      ctlToolSaveModified.p_value = 1;
      ctlToolSaveNone.p_value = 0;
      break;
   }
   gProjectIgnoreToolSaveOptions = 0;
}

// Desc:  Tool name has just been changed.  Make sure all controls
//        related to this newly selected tool name is updated.
void ctlToolName.on_change(reason)
{
   // From the tool name, find out the tool index and
   // init the text boxes:
   int toolIndex;
   isToolNameInProjectToolTable(projectToolList,ctlToolName.p_text,toolIndex);
   _str cmdLine;
   cmdLine = projectToolList[toolIndex].cmd;
   ctlToolMenuCaption.p_ReadOnly = false;  // temporarily turn off read-only so that we can update caption

   // If tool does not have a command line, we default a few things.
   // Otherwise just fill in.
   if (cmdLine == "") {
      ctlToolCmdLine.p_text = "";
      ctlToolMenuCaption.p_text = projectToolList[toolIndex].caption;
      if (toolIndex < predefToolList._length()) {
         ctlToolOutputToConcur.p_value = projectToolList[toolIndex].outputConcur;
         ctlToolCaptureOutput.p_value = projectToolList[toolIndex].captureOutput;
      } else {
         ctlToolOutputToConcur.p_value = 0;
         ctlToolCaptureOutput.p_value = 0;
      }
   } else {
      ctlToolCmdLine.p_text = cmdLine;
      ctlToolMenuCaption.p_text = projectToolList[toolIndex].caption;
      ctlToolOutputToConcur.p_value = projectToolList[toolIndex].outputConcur;
      ctlToolCaptureOutput.p_value = projectToolList[toolIndex].captureOutput;
   }
   ctlToolHide.p_value = projectToolList[toolIndex].hideIfNoCmd;
   ctlToolClearProcessBuf.p_value = projectToolList[toolIndex].clearProcessBuf;
   updateSaveOptions(projectToolList[toolIndex].saveOptions);
   ctlToolChangeDir.p_value = projectToolList[toolIndex].changeDir;

   // Disable a few things for predefined tools:
   if (toolIndex < predefToolList._length()) {
      ctlToolMenuCaption.p_ReadOnly = true;
      ctlToolDelete.p_enabled = false;
   } else {
      ctlToolMenuCaption.p_ReadOnly = false;
      ctlToolDelete.p_enabled = true;
   }

   // If not capturing output, disable output to process buffer and clear process
   // buffer toggle buttons.
   if (ctlToolCaptureOutput.p_value) {
      ctlToolOutputToConcur.p_enabled = true;
      ctlToolClearProcessBuf.p_enabled = true;
   } else {
      ctlToolOutputToConcur.p_enabled = false;
      ctlToolClearProcessBuf.p_enabled = false;
   }
   if (ctlToolOutputToConcur.p_value) {
      ctlToolClearProcessBuf.p_enabled = true;
   } else {
      ctlToolClearProcessBuf.p_enabled = false;
      ctlToolClearProcessBuf.p_value = 0;
   }
}
void _proj_prop_sstab.'A-t'()
{
   if (_proj_prop_sstab.p_ActiveTab == PROJPROPTAB_FILES) {
      p_window_id=_control _openfile_types;
      _set_focus();
      call_event(p_window_id,F4);
   }
}
void _proj_prop_sstab.'A-v'()
{
   if (_proj_prop_sstab.p_ActiveTab == PROJPROPTAB_FILES) {
      p_window_id=_control _opendrives;
      _set_focus();
      call_event(p_window_id,F4);
   }
}
static void oncreate_proj_prop_sstab()
{
   typeless ht:[];
   typeless tl;
   tl = _proj_prop_sstab.p_user;
   if (tl._varformat() == VF_HASHTAB) ht = _proj_prop_sstab.p_user;
   //ht:["def_compile_flags"] = def_compile_flags;
   //ht:["def_save_on_compile"] = def_save_on_compile;
   _proj_prop_sstab.p_user = ht;
}

//-----------------------------------------------------------------------------------
// New Filter Code

static void filterEnableMoveUpDown()
{
   if (ctlFilterNameList.p_line <= 1) {
      if (ctlFilterMoveUp.p_enabled != FALSE) {
         ctlFilterMoveUp.p_enabled = FALSE;
      }
   } else {
      if (ctlFilterMoveUp.p_enabled != TRUE) {
         ctlFilterMoveUp.p_enabled = TRUE;
      }
   }
   if (ctlFilterNameList.p_line == 0
       || ctlFilterNameList.p_line == ctlFilterNameList.p_Noflines) {
      if (ctlFilterMoveDown.p_enabled != FALSE) {
         ctlFilterMoveDown.p_enabled = FALSE;
      }
   } else {
      if (ctlFilterMoveDown.p_enabled != TRUE) {
         ctlFilterMoveDown.p_enabled = TRUE;
      }
   }
}

static void filterMoveUp(int wid)
{
   // Move the line up in the listbox:
   int currLine;
   currLine = wid.p_line;
   text = wid._lbget_text();
   wid.p_line = currLine - 1;
   text2 = wid._lbget_text();
   wid._lbset_item(text);
   wid.p_line = currLine;
   wid._lbset_item(text2);
   wid.p_line = currLine - 1;
   wid._lbselect_line();
   filterEnableMoveUpDown();

   // Move the line up in the data structure list:
   int ii;
   ii = currLine - 1;
   ProjectFilterStruct temp;
   temp = projectFilterList[ii];
   projectFilterList[ii] = projectFilterList[ii-1];
   projectFilterList[ii-1] = temp;
}
static void filterMoveDown(int wid)
{
   // Move the line up in the listbox:
   int currLine;
   currLine = wid.p_line;
   text = wid._lbget_text();
   wid.p_line = currLine + 1;
   text2 = wid._lbget_text();
   wid._lbset_item(text);
   wid.p_line = currLine;
   wid._lbset_item(text2);
   wid.p_line = currLine + 1;
   wid._lbselect_line();
   filterEnableMoveUpDown();

   // Move the line down in the data structure list:
   int ii;
   ii = currLine - 1;
   ProjectFilterStruct temp;
   temp = projectFilterList[ii];
   projectFilterList[ii] = projectFilterList[ii+1];
   projectFilterList[ii+1] = temp;
}

// Desc: From the internal data structure, rebuild the filter parameter
//       list to be stored in project file.
static void filterBuildLists(_str & nameList, _str & patternList
                             ,_str & cmdList, _str & useAssocList)
{
   int ii;
   int iiCount;
   iiCount = projectFilterList._length();
   nameList = "";
   patternList = "";
   cmdList = "";
   useAssocList = "";
   for (ii=0; ii<iiCount; ii++) {
      nameList = nameList :+ projectFilterList[ii].name :+ "\\n";
      patternList = patternList :+ projectFilterList[ii].pattern :+ "\\n";
      if (projectFilterList[ii].command != "") {
         _str text;
         text = stranslate(projectFilterList[ii].command,'\\','\');
         cmdList = cmdList :+ text :+ "\\n";
      } else {
         cmdList = cmdList :+ projectFilterList[ii].command :+ "\\n";
      }
      tmp = "0";
      if (projectFilterList[ii].useFileAssoc) tmp = "1";
      useAssocList = useAssocList :+ tmp :+ " ";
   }
}

static int okFilter(int & modified)
{
   modified = 0;
   typeless ht:[];
   ht = _proj_prop_sstab.p_user;
   p_window_id = _control _proj_prop_sstab;

   // Build filter parameter string list:
   _str nameList, patternList, commandList, useAssocList;
   filterBuildLists(nameList, patternList, commandList, useAssocList);

   // If the parameters have been changed, update the project section.
   _macro('m',_macro('s'))
   if (ht._indexin("filterNameL") && nameList != ht:["filterNameL"]) {
      _ini_set_value(_project_get_filename(),"COMPILER", "FILTERNAME",nameList);
      _macro_call("_ini_set_value", _project_get_filename(),
                  "COMPILER", "FILTERNAME", nameList);
      modified = 1;
   }
   if (ht._indexin("filterPatternL") && patternList != ht:["filterPatternL"]) {
      _ini_set_value(_project_get_filename(),"COMPILER", "FILTERPATTERN",patternList);
      _macro_call("_ini_set_value", _project_get_filename(),
                  "COMPILER", "FILTERPATTERN", patternList);
      modified = 1;
   }
   if (ht._indexin("filterAppCommandL") && commandList != ht:["filterAppCommandL"]) {
      _ini_set_value(_project_get_filename(),"COMPILER", "FILTERAPPCOMMAND",commandList);
      _macro_call("_ini_set_value", _project_get_filename(),
                  "COMPILER", "FILTERAPPCOMMAND", commandList);
      modified = 1;
   }
   if (ht._indexin("filterAssocTypeL") && useAssocList != ht:["filterAssocTypeL"]) {
      _ini_set_value(_project_get_filename(),"COMPILER",
                     "FILTERASSOCIATEFILETYPES",useAssocList);
      _macro_call("_ini_set_value", _project_get_filename(),
                  "COMPILER", "FILTERASSOCIATEFILETYPES", useAssocList);
      modified = 1;
   }
   return(0);
}

void ctlFilterDelete.lbutton_up()
{
   // Delete entry from data structure:
   int ii;
   ii = ctlFilterNameList.p_line - 1;
   int iiCount;
   iiCount = projectFilterList._length();
   for (; ii<(iiCount-1); ii++) {
      projectFilterList[ii] = projectFilterList[ii+1];
   }
   projectFilterList[iiCount-1]._makeempty();
   iiCount = projectFilterList._length();

   // Remove line from listbox:
   ctlFilterNameList._lbdelete_item();
   if (ctlFilterNameList.p_Noflines) {
      ctlFilterNameList._lbselect_line();
      filterUpdateNameList();
   } else {
      ctlFilterDelete.p_enabled = false;
      ctlFilterPattern.p_enabled = false;
      ctlFilterPattern.p_text = "";
      ctlFilterUseFileAssociation.p_value = 0;
      ctlFilterApp.p_text = "";
      ctlFilterApp.p_enabled = false;
      ctlFilterAppCmdButton.p_enabled = false;
   }
   ctlFilterNameList._set_focus();
   ctlFilterDelete.p_default=false;
   _ok.p_default=true;
}

// Desc: Check to see if filter name is already in the project filter list.
//       If it is, return the index in the list.
// Retn: 1 found, 0 not
static int isFilterNameInProjectFilterTable(_str name, int & toolIndex)
{
   int iiCount = projectFilterList._length();
   for (ii=0; ii<iiCount; ii++) {
      if (!stricmp(name, projectFilterList[ii].name)) {
         toolIndex = ii;
         return(1);
      }
   }
   return(0);
}

void ctlFilterNew.lbutton_up()
{
   // Prompt the user for a new tool name:
   _str result;
   result = show('-modal _textbox_form',
                 'New Project File Filter',      //Caption
                 0,                              //Flags
                 2000,                           //use default textbox width
                 '?Type a name for the new filter and press ENTER to add the filter.',   //Help item
                 '',                             //Font(no support yet)
                 '',                //Retrieve Name
                 'New Filter Name:' //Prompt
                 );
   //_param1 = '' if someone presses ok on an empty box
   if (result == '' || _param1 == '') {
      return;
   }
   _str name;
   name = _param1;
   name = strip(name);  // strip any leading and trailing spaces

   // Make sure that there are no colons or commas in filter name:
   if (pos("[^A-Za-z0-9_ ]", name, 1, 'r')) {
      _message_box(nls("Filter name can only contain alphanumeric characters."));
      return;
   }

   // Check to make sure that the new filter name does not
   // already exist:
   int filterIndex;
   if (isFilterNameInProjectFilterTable(name, filterIndex)) {
      _message_box(nls("Filter '%s' already exists in project.",name));
      return;
   }

   // Create a new tool:
   ProjectFilterStruct filterInfo;
   filterInfo.name = name;
   filterInfo.pattern = "";
   filterInfo.command = "";
   filterInfo.useFileAssoc = 0;

   // Append the new tool to the end of the tool list:
   filterIndex = projectFilterList._length();
   projectFilterList[filterIndex] = filterInfo;
   ctlFilterNameList._lbbottom();
   ctlFilterNameList._lbadd_item(name);

   // Select the new tool and put focus on the command text box:
   ctlFilterNameList._lbselect_line();
   filterUpdateNameList();
   ctlFilterPattern._set_focus();
   ctlFilterPattern._set_sel(1);  // move text cursor to start of line
}

void ctlFilterMoveUp.lbutton_up()
{
   filterMoveUp(ctlFilterNameList.p_window_id);

   // Give focus to the command text box and the default RETURN
   // to the OK button.
   ctlFilterPattern._set_focus();
   ctlFilterMoveUp.p_default=false;
   _ok.p_default=true;
}

void ctlFilterMoveDown.lbutton_up()
{
   filterMoveDown(ctlFilterNameList.p_window_id);

   // Give focus to the command text box and the default RETURN
   // to the OK button.
   ctlFilterPattern._set_focus();
   ctlFilterMoveUp.p_default=false;
   _ok.p_default=true;
}

void ctlFilterPattern.on_change()
{
   int ii;
   ii = ctlFilterNameList.p_line - 1;
   if (ii < 0) return;
   projectFilterList[ii].pattern = ctlFilterPattern.p_text;
}

void ctlFilterApp.on_change()
{
   int ii;
   ii = ctlFilterNameList.p_line - 1;
   if (ii < 0) return;
   projectFilterList[ii].command = ctlFilterApp.p_text;
}

void ctlFilterUseFileAssociation.lbutton_up()
{
   int ii;
   ii = ctlFilterNameList.p_line - 1;
   projectFilterList[ii].useFileAssoc = ctlFilterUseFileAssociation.p_value;
   ctlFilterApp.p_enabled= !p_value;
}

// Desc: Update the filter name list.
static void filterUpdateNameList()
{
   int ii = ctlFilterNameList.p_line;
   ii--;
   ctlFilterPattern.p_enabled = true;
   ctlFilterPattern.p_text = projectFilterList[ii].pattern;
#if __UNIX__
   ctlFilterUseFileAssociation.p_value = 0;
   ctlFilterApp.p_text = projectFilterList[ii].command;
   ctlFilterApp.p_enabled = true;
   ctlFilterAppCmdButton.p_enabled = true;
#else
   if (projectFilterList[ii].useFileAssoc) {
      if (machine() == "OS2386") {
         ctlFilterUseFileAssociation.p_value = 0;
         ctlFilterApp.p_enabled = true;
         ctlFilterAppCmdButton.p_enabled = true;
      } else {
         ctlFilterUseFileAssociation.p_value = 1;
         ctlFilterApp.p_enabled = false;
         ctlFilterAppCmdButton.p_enabled = false;
      }
      ctlFilterApp.p_text = projectFilterList[ii].command;
   } else {
      ctlFilterUseFileAssociation.p_value = 0;
      ctlFilterApp.p_enabled = true;
      ctlFilterAppCmdButton.p_enabled = true;
      ctlFilterApp.p_text = projectFilterList[ii].command;
   }
#endif
   filterEnableMoveUpDown();
   ctlFilterDelete.p_enabled = true;
}

void ctlFilterNameList.on_change(reason)
{
   filterUpdateNameList();
}

static void oncreateFilterNameList()
{
   _str result, result2, filterNameL, filterPatternL, filterAssocTypeL;
   _str filterAppCommandL;
   _str line;
   int rc, rc1, rc2, rc3, rc4;
   int i;
   int count;

   // Fill in the list of filter names:
   rc1 = _ini_get_value(_project_get_filename(),"COMPILER",
                  "FILTERNAME",filterNameL);
   rc2 = _ini_get_value(_project_get_filename(),"COMPILER",
                  "FILTERPATTERN",filterPatternL);
   if (rc2) filterPatternL = "";
   rc3 = _ini_get_value(_project_get_filename(),"COMPILER",
                  "FILTERASSOCIATEFILETYPES",filterAssocTypeL);
   if (rc3) filterAssocTypeL = "";
   rc4 = _ini_get_value(_project_get_filename(),"COMPILER",
                  "FILTERAPPCOMMAND",filterAppCommandL);
   if (rc4) filterAppCommandL = "";
   if (rc1) {
      // If the section is not defined for this project, use the default filters:
      result = "";
      count = 0;
      for (i=0; i<filterDefaultName._length(); i++) {
         result = result :+ filterDefaultName[i] :+ "\\n";
         count++;
      }
      filterNameL = result;
   }

   // Parse the list of filter names. If there is no such information
   // the project file, get the filters from the default filter list.
   int iiCount;
   iiCount = 0;
   projectFilterList._makeempty();
   typeless ht:[];
   typeless tl;
   tl = _proj_prop_sstab.p_user;
   if (tl._varformat() == VF_HASHTAB) ht = _proj_prop_sstab.p_user;
   result = _ini_xlat_multiline(filterNameL);
   for (;;) {
      if (result=='') break;
      line=_parse_line(result);
      projectFilterList[iiCount].name = line;
      iiCount++;
   }

   // Parse list of filter patterns:
   _str tKey;
   int ii;
   result = _ini_xlat_multiline(filterPatternL);
   for (ii=0; ii < iiCount; ii++) {
      if (result=='') {
         tKey = lowcase(projectFilterList[ii].name);
         line = "";
         if (filterDefaultPattern._indexin(tKey)) {
            line = filterDefaultPattern:[tKey];
         }
      } else {
         line=_parse_line(result);
      }
      projectFilterList[ii].pattern = line;
   }

   // Parse list of filter application command:
   result = _ini_xlat_multiline(filterAppCommandL);
   for (ii=0; ii < iiCount; ii++) {
      if (result=='') {
         tKey = lowcase(projectFilterList[ii].name);
         line = "";
         if (filterDefaultAppCommand._indexin(tKey)) {
            line = filterDefaultAppCommand:[tKey];
         }
      } else {
         line=_parse_line(result);
      }
      projectFilterList[ii].command = line;
   }

   // Parse list of "use file association":
   result = filterAssocTypeL;
   for (ii=0; ii < iiCount; ii++) {
      _str atype;
      if (result=='') {
         tKey = lowcase(projectFilterList[ii].name);
         projectFilterList[ii].useFileAssoc = 0;
         if (filterDefaultFileAssociation._indexin(tKey)) {
            line = filterDefaultFileAssociation:[tKey];
            projectFilterList[ii].useFileAssoc = (int)line;
         }
      } else {
         parse result with atype result;
         if (atype == "") atype = 0;
         projectFilterList[ii].useFileAssoc = (int)atype;
      }
   }

   // Save these original filter values for later comparison.
   _str nameList, patternList, commandList, useAssocList;
   filterBuildLists(nameList, patternList, commandList, useAssocList);
   ht:["filterNameL"] = nameList;
   ht:["filterPatternL"] = patternList;
   ht:["filterAppCommandL"] = commandList;
   ht:["filterAssocTypeL"] = useAssocList;
   _proj_prop_sstab.p_user = ht;

   // Insert the filter names into the listbox:
   ctlFilterNameList.top();
   for (ii=0; ii < iiCount; ii++) {
      ctlFilterNameList._lbadd_item(projectFilterList[ii].name);
   }
   ctlFilterNameList.top();
   ctlFilterNameList._lbselect_line();
   filterUpdateNameList();

   // Default disabling buttons:
   ctlFilterNew.p_enabled = true;
   ctlFilterDelete.p_enabled = false;
   ctlFilterMoveUp.p_enabled = false;
   ctlFilterMoveDown.p_enabled = false;
#if __UNIX__
   ctlFilterUseFileAssociation.p_enabled = false;
#endif
}


//-----------------------------------------------------------------------------------
void _opencancel.lbutton_up()
{
   fid = p_active_form;
   //_save_form_response();
   value = _proj_prop_sstab.p_ActiveTab;
   _append_retrieve( _proj_prop_sstab, value );
   fid._delete_window(0);
}
static void oncreateFiles(_str fileToBeSelected)
{
   // Check to see if there is a file to be selected in the project
   // file list:

   //say( "oncreateFiles" );
   form_wid=p_active_form
   _ok.p_user=getcwd();
   //if (!sstIsControlExists("_srcfile_list")) return;

   //_srcfile_list.p_user=arg(10);
   PROJECT_FILE_LIST_MODIFIED=0;  // List is not modified.

   _openfn.p_cb_picture.p_visible=0;
   _openfile_list.p_multi_select=MS_EXTENDED;
   fid=p_active_form;

   //p_active_form.p_caption="Source Files For ":+gProjectName;
   p_active_form.p_caption="Project Properties For ":+gProjectName;
   if (_project_name!='') {
      _ini_get_value(_project_name,"ASSOCIATION",'makefile',makefile,'');
      _ini_get_value(_project_name,"ASSOCIATION",'makefiletype',makefiletype,'');
      AssociatedMakefile=makefile"\t"makefiletype;
   }

   int cid;
   cid = _find_control("_proj_prop_sstab");
   status=get_filelist(fid);
   // Select file in project's file list:
   if (fileToBeSelected != "") {
      fid._srcfile_list._lbtop();
      fid._srcfile_list._lbup();
      while (!fid._srcfile_list._lbdown()) {
         _str line;
         line = fid._srcfile_list._lbget_text();
         if (line != fileToBeSelected) continue;
         fid._srcfile_list._lbselect_line();
         break;
      }
   } else {
      fid._srcfile_list._lbtop();
   }

   _project_nofselected.p_caption='0 of '_srcfile_list.p_noflines' Files Selected'
   if (status) {
      return;
   } else {
      _openfind_file.p_visible=0;
      _set_opencd(getcwd());
   }

   // Update all controls associated with the _srcfile_list and _openfile_list:
   updateControlsAssociatedWithOpenFileList();
   updateControlsAssociatedWithSrcFileList();
}

// Desc:  Check to see if the specified tool key is already
//        in tool table.  Tool key is the key used to identify
//        which tool in the project file.
//        If in table, the index to the tool is returned in toolIndex.
// Retn:  1 for in table, 0 for not
static int isToolKeyInProjectToolTable(_str key, int & toolIndex)
{
   toolIndex = 0;
   int i;
   for (i=0; i<projectToolList._length(); i++) {
      if (!stricmp(key, projectToolList[i].nameKey)) {
         toolIndex = i;
         return(1);
      }
   }
   return(0);
}

// Desc:  Check to see if the specified tool name is already
//        in tool table.  Tool name is the text used in the
//        tool name combo box.  It is also the name that the user
//        assigns to a new key.
//        If in table, the index to the tool is returned in toolIndex.
// Retn:  1 for in table, 0 for not
static int isToolNameInProjectToolTable(typeless & atoolList,
                                        _str name, int & toolIndex)
{
   toolIndex = 0;
   int i;
   for (i=0; i<atoolList._length(); i++) {
      ProjectToolStruct toolInfo;
      toolInfo = atoolList[i];
      if (!stricmp(name, toolInfo.name)) {
         toolIndex = i;
         return(1);
      }
   }
   return(0);
}

// Desc:  Check to see if the specified key is a valid key.
// Retn:  1 for yes, 0 for no.
static int isToolKeyValid(_str key)
{
   // Check to see if the key is one of the predefined tools:
   int i;
   for (i=0; i<predefToolList._length(); i++) {
      if (!stricmp(key, predefToolList[i].nameKey)) {
         return(1);
      }
   }

   // Maybe a new key:
   // Make sure key has a valid tool name key prefix.
   if (pos(TOOLNAMEKEYPREFIX, key, 1, "I")) {
      return(1);
   }
   return(0);
}

// Desc:  Initialize the project tool list with the
//        list of predefined tools.
static void initPredefinedToolList()
{
   // Init the predefined tools:
   projectToolList._makeempty();
   int i;
   for (i=0; i<predefToolList._length(); i++) {
      projectToolList[i] = predefToolList[i];
   }
}

// Desc:  Check the key bindings for each of the tool
//        command and update the accelerator text.
static void updateToolAccelText()
{
   // Find out all the key bindings for the project tools:
   // If there are more than one key bindings for a command,
   // take the first one.
   int i;
   for (i=0; i<projectToolList._length(); i++) {
      _str key_binding_list;
      projectToolList[i].accel = "";

      // Don't show accel for new user defined tools:
      if (i >= predefToolList._length()) {
         continue;
      }

      // Find all the key bindings for the command:
      int index;
      index= find_index(projectToolList[i].menuCmd,COMMAND_TYPE);
      if (!index) continue;
      key_binding_list="";
      append_key_bindings(index,key_binding_list,'',
                          _default_keys,
                          _mdi.p_child.p_mode_eventtab);
      key_binding_list = strip(key_binding_list);
      if (key_binding_list == "") continue;

      // If more than one bindings, use the first one:
      int p1;
      p1 = pos(",",key_binding_list);
      if (p1) key_binding_list = substr(key_binding_list,1,p1-1);
      projectToolList[i].accel = key_binding_list;
      //say(projectToolList[i].name" "projectToolList[i].accel);
   }
}

// Desc:  Read and parse all known extension projects.
// Retn:  0 for OK, 1 for error.
static int readAndParseAllExtensionProjects()
{
   // Build a list of extension projects:
   _str extensionList[];
   int extCount;
   extensionList._makeempty();
   extCount = 0;
   _str filename;
   filename=slick_path_search(PRJ_DEFAULT_FILE);
   view_id=_create_temp_view(temp_view_id);
   _ini_list_sections(filename);
   _lbtop();_lbup();
   while (!_lbdown()) {
      text=_lbget_text();
      if (pos(".",text) != 1) continue;
      extensionList[extCount] = text;
      extCount++;
   }
   activate_view view_id;
   _delete_temp_view(temp_view_id);

   // Read and parse each extension project:
   // Save the tools for the extension project in a global
   // hash table.
   int i;
   for (i=0; i<extensionList._length(); i++) {
      int status;
      //say(extensionList[i]);
      status = readAndParseProjectToolList(filename,
               extensionList[i], 0, junk);
      if (status) continue;
      projectExtensionProjectsHT:[extensionList[i]] = projectToolList;
   }

   return(0);
}

// Desc:  Read and parse the project's section containing
//        the tools.
// Retn:  0 for OK, 1 for error.
static int readAndParseProjectToolList(
         _str projectFileName, _str sectionName,
         int initDirectoryControls, typeless &ht)
{
   // Read the section data from project file:
   int status;
   status=_ini_get_section(projectFileName, sectionName, temp_view_id);
   if (status) {
      updateToolAccelText();
      return(1);
   }

   // Go thru the section and fill the tools' hash table:
   int first;
   first = 1;
   for (;;) {
      // Get the next text line from the temp view:
      // If no more, delete the temp view and its buffer.
      status=_ini_parse_line(temp_view_id, fname, info, first);
      if (status) {
         break;
      }
      parse info with cb_info ',' info;
      _str key;
      key = lowcase(fname);
      first=0;

      // Make sure tool name key is valid:
      if (!isToolKeyValid(key)) {
         // This is not a valid name key, check to see if it
         // is a working directory, include dir, or tag files:
         if (initDirectoryControls) {
            if (key == "workingdir") {
               _prjworking_dir.p_text = cb_info;
               ht:["_prjworking_dir"] = _prjworking_dir.p_text;
            } else if (key == "includedirs") {
               _prjinclude_dirs.p_text = cb_info;
               ht:["_prjinclude_dirs"] = _prjinclude_dirs.p_text;
            } else if (key == "tagfiles") {
               _prjtag_files.p_text = cb_info;
               ht:["_prjtag_files"] = _prjtag_files.p_text;
            } else if (key == "reffile") {
               _prjref_files.p_text = cb_info;
               ht:["_prjref_files"] = _prjref_files.p_text;
            }
         }

         // None of the above...  Must be some other keys
         // in the section.  Ignore them all!
         continue;
      }

      /*
         Fill in the tool info taken from the project file:

            compile=concur|capture,mycompile
            make=concur|capture,makevnt -!
            rebuild=concur|capture,remakevnt -!

            newtool1=concur|capture|New Tool 1,newtoolcmd -u -B
      */

      // Extract the options text:
      // options text must be before a ':' (which indicates the start of the tool name).
      _str optionsText;
      int p1;
      optionsText = cb_info;
      p1 = pos(":",cb_info);
      if (p1) optionsText = substr(cb_info,1,p1-1);

      ProjectToolStruct toolinfo;
      int toolIndex;
      if (isToolKeyInProjectToolTable(key,toolIndex)) {
         // At this time, the only tools in the table are the
         // predefined tools.
         // We only need to fill in the tool command and modes.
         projectToolList[toolIndex].cmd = info;
         if (key == "compile" || key == "make" || key == "rebuild") {
            projectToolList[toolIndex].outputConcur = (int)(info=='' || pos('concur', optionsText));
            projectToolList[toolIndex].captureOutput = (int)(info=='' || pos('capture', optionsText));
         } else {
            projectToolList[toolIndex].outputConcur = pos('concur', optionsText);
            projectToolList[toolIndex].captureOutput = pos('capture', optionsText);
         }
         projectToolList[toolIndex].hideIfNoCmd = pos('hide', optionsText);
         projectToolList[toolIndex].clearProcessBuf = pos('clear', optionsText);
         projectToolList[toolIndex].saveOptions = saveNone;
         projectToolList[toolIndex].explicitSave = 0;
         if (pos('savecurrent', optionsText)) {
            projectToolList[toolIndex].saveOptions = saveCurrent;
            projectToolList[toolIndex].explicitSave = 1;
         } else if (pos('saveall', optionsText)) {
            projectToolList[toolIndex].saveOptions = saveAll;
            projectToolList[toolIndex].explicitSave = 1;
         } else if (pos('savemodified', optionsText)) {
            projectToolList[toolIndex].saveOptions = saveModified;
            projectToolList[toolIndex].explicitSave = 1;
         } else if (pos('savenone', optionsText)) {
            projectToolList[toolIndex].saveOptions = saveNone;
            projectToolList[toolIndex].explicitSave = 1;
         } else {
            // Can't find any new "save*" options. Check the def_save_on_compile for
            // tools with command with %f, %p,... specifying a file.
            _str tOption;
            if (pos("(%f)|(%p)|(%n)|(%e)",projectToolList[toolIndex].cmd,1,"RI")) {
               parse def_save_on_compile with tOption .;
               projectToolList[toolIndex].saveOptions = (int)tOption;  // values already mapped to constants so we can do this crude assignment
            } else if (key == "make" || key == "rebuild") {
               parse def_save_on_compile with . tOption;
               projectToolList[toolIndex].saveOptions = (int)tOption;  // values already mapped to constants so we can do this crude assignment
            }
         }
         projectToolList[toolIndex].changeDir = (int)!pos('nochangedir', optionsText);

         // Adjust a few things for correctness. If we are not capturing the output,
         // we should not output to concur buffer or clear buffer.
         if (!projectToolList[toolIndex].captureOutput) {
            projectToolList[toolIndex].outputConcur = 0;
            projectToolList[toolIndex].clearProcessBuf = 0;
         }

         // Force user1 and user2 to hide if there is no command line:
         if (key == "user1" || key == "user2") {
            projectToolList[toolIndex].hideIfNoCmd = 1;
         }
      } else {
         // New tool:
         // For a new tool, we need to parse the tool name for the combo box
         // and the menu caption.  The new tool data from the section has the
         // following format:
         //
         //    newtool1=concur|capture|hide|:New Tool 1:Menu Tool 1,newtoolcmd -u -B
         //             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
         //                                 ^^^^^^^^ ^^^^^^^^^^^^^
         //    newtool1=concur|:New Tool 1:Menu Tool 1,newtoolcmd -u -B
         //             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
         //                     ^^^^^^^^^^ ^^^^^^^^^^^
         //    newtool1=:New Tool 1:Menu Tool 1,newtoolcmd -u -B
         //             ^^^^^^^^^^^^^^^^^^^^^^^
         //              ^^^^^^^^^^ ^^^^^^^^^^^
         int p1;
         toolinfo.nameKey = key;
         toolinfo.name = key;
         toolinfo.caption = key;
         p1 = pos(":", cb_info);
         if (p1) {
            // Extract tool name and menu caption:
            int p2;
            p2 = pos(":", cb_info, p1+1);  // locate menu caption
            if (!p2) {
               // No menu caption, use tool name instead:
               toolinfo.name = substr(cb_info, p1+1);
               toolinfo.caption = toolinfo.name;
            } else {
               // Have both tool name and menu caption:
               toolinfo.name = substr(cb_info, p1+1, p2-p1-1);
               toolinfo.caption = substr(cb_info, p2+1);
            }
         }
         toolinfo.cmd = info;
         toolinfo.menuCmd = "project-usertool";
         if (key == "compile" || key == "make" || key == "rebuild") {
            toolinfo.outputConcur = (int)(info=='' || pos('concur', optionsText));
            toolinfo.captureOutput = (int)(info=='' || pos('capture', optionsText));
         } else {
            toolinfo.outputConcur = pos('concur', optionsText);
            toolinfo.captureOutput = pos('capture', optionsText);
         }
         toolinfo.hideIfNoCmd = pos('hide', optionsText);
         toolinfo.clearProcessBuf = pos('clear', optionsText);
         toolinfo.saveOptions = saveNone;
         toolinfo.explicitSave = 0;
         if (pos('savecurrent', optionsText)) {
            toolinfo.saveOptions = saveCurrent;
            toolinfo.explicitSave = 1;
         } else if (pos('saveall', optionsText)) {
            toolinfo.saveOptions = saveAll;
            toolinfo.explicitSave = 1;
         } else if (pos('savemodified', optionsText)) {
            toolinfo.saveOptions = saveModified;
            toolinfo.explicitSave = 1;
         } else if (pos('savenone', optionsText)) {
            toolinfo.saveOptions = saveNone;
            toolinfo.explicitSave = 1;
         } else {
            // Can't find any new "save*" options. Check the def_save_on_compile for
            // tools with command with %f, %p,... specifying a file.
            _str tOption;
            if (pos("(%f)|(%p)|(%n)|(%e)",toolinfo.cmd,1,"RI")) {
               parse def_save_on_compile with tOption .;
               toolinfo.saveOptions = (int)tOption;
            } else if (key == "make" || key == "rebuild") {
               parse def_save_on_compile with . tOption;
               toolinfo.saveOptions = (int)tOption;
            }
         }
         toolinfo.changeDir = (int)!pos('nochangedir', optionsText);

         // Adjust a few things for correctness. If we are not capturing the output,
         // we should not output to concur buffer or clear buffer.
         if (!toolinfo.captureOutput) {
            toolinfo.outputConcur = 0;
            toolinfo.clearProcessBuf = 0;
         }

         toolIndex = projectToolList._length();
         projectToolList[toolIndex] = toolinfo;
      }
   }

   // Update the accelerator text for each of the tools:
   updateToolAccelText();
   return(0);
}

// Desc:  Fills in the Tools tab.
// Retn:  0 for OK, 1 for error
static int oncreateTools(_str projName)
{
   typeless ht:[];
   typeless tl;
   tl = _proj_prop_sstab.p_user;
   if (tl._varformat() == VF_HASHTAB) ht = _proj_prop_sstab.p_user;

   _str project_name;
   project_name = "";
   if (projName != "") { // extension project
      project_name=projName;
      p_active_form.p_caption='Project Properties For 'project_name;
      _ini_get_value(projName,"ASSOCIATION",'makefile',makefilename,'');
      _ini_get_value(projName,"ASSOCIATION",'makefiletype',makefiletype,'');
      AssociatedMakefile=makefilename"\t"makefiletype;
   } else {              // real project
      project_name = _project_name;
   }
   if (substr(project_name,1,1)=='.') {
      section=project_name;
      // Use the extension project file in the user's configuration directory:
      //pfilename=slick_path_search(PRJ_DEFAULT_FILE);
      pfilename = _config_path():+PRJ_DEFAULT_FILE;
   } else {
      section=_project_get_section("COMPILER");
      pfilename=_project_get_filename();
   }

   // Save the section and project file name:
   _prjworklab.p_user=section;
   _prjworking_dir.p_user=pfilename;

   // For extension projects, disable the working directory:
   if (substr(project_name,1,1)=='.') {  // extension project
      _prjworking_dir.p_enabled = false;
      _prjworking_dir.p_next.p_enabled = false;
      _prjworking_dir.p_text = "";
   }

   // If we are editing the properties for an extension project and
   // there is currently a real project opened, we need to save the
   // global projectToolList[] which contains the current state
   // of the project tools for that real project.
   if (substr(project_name,1,1)=='.' && _project_name != "") {
      projectToolListSaved = projectToolList;
      projectToolListStateSaved  = 1;
   }

   // Init the predefined tools:
   initPredefinedToolList();

   // Read and parse the section data from project file:
   int status;
   status = readAndParseProjectToolList(pfilename, section, 1, ht);
   if (status) {
      // If we can't read the extension project, it may be a new extension
      // project so we just let it go:
      if (pos(".",section) != 1) {
         _message_box(nls("Unable to read section '%s' from project %s.",section,pfilename));
         return(1);
      }
   }

   // Now that we have the complete hash table, initialize the combo box:
   int listwid;
   listwid = ctlToolName.p_cb_list_box;
   for (i=0; i<projectToolList._length(); i++) {
      //messageNwait("i="i" "projectToolList[i].name" "projectToolList[i].cmd);
      listwid._lbadd_item(projectToolList[i].name);
   }

   // Restore the previous tool selection.
   // If none, select the first tool.
   int found;
   _str lastSelectedTool;
   lastSelectedTool = _retrieve_value("_project_form.toolNameSelected");
   found = 0;
   for (i=0; i<projectToolList._length(); i++) {
      if (!stricmp(lastSelectedTool,projectToolList[i].name)) {
         ctlToolName.p_text = projectToolList[i].name;
         found = 1;
         break;
      }
   }
   if (!found) {
      ctlToolName.p_text = projectToolList[0].name;
   }

   // Update the extension project hash table:
   if (substr(project_name,1,1)=='.') {
      projectExtensionProjectsHT:[lowcase(project_name)] = projectToolList;
   }

   // Store the entire initial tool table into the hash table so that
   // we can later check changes:
   ht:["projectToolList"] = projectToolList;

   _proj_prop_sstab.p_user = ht;
   return( 0 );
}
static void setMacroText(typeless caption,typeless flags,typeless input,typeless reserved,
                     typeless help,typeless max_Noflines,typeless max_filesize,
                     typeless font, typeless margins)
{
   if (flags=='') {
      flags=EDC_OUTPUTINI|EDC_INPUTINI;
   }
   if (flags & EDC_INPUTINI) {
      input=_ini_xlat_multiline(input);
   }
   macroflags=flags;
   macromax_Noflines=max_Noflines;
   macromax_filesize=max_filesize;

   /*
   if (!sstIsControlExists("list1")) {
      sstSetProp("list1","p_text",input);
      return;
   }
   */
   p_window_id=_control list1;
   _delete_line();
   input=input;
   for (;;) {
      if (input=='') break;
      line=_parse_line(input);
      insert_line(line);
   }
   if (!p_Noflines) {
      insert_line('');
   }
   top();
   p_word_wrap_style=p_word_wrap_style&(~WORD_WRAP_WWS);
}
static int oncreateMacro()
{
   typeless ht:[];
   typeless tl;
   tl = _proj_prop_sstab.p_user;
   if (tl._varformat() == VF_HASHTAB) ht = _proj_prop_sstab.p_user;

   //if (!sstIsControlExists("_compileLabel")) return( 0 );
   _ini_get_value(_project_get_filename(),"COMPILER","MACRO",result);
   ht:["macro"] = result;
   setMacroText('Project Macro',
            EDC_INPUTINI|EDC_OUTPUTINI,
            result, // Initial value
            '',   // Reserved.
            '',   // Help
            '',   // max Noflines
            9999999,  // max_filesize
            '',   // font
            ''    // margins
           );
   _proj_prop_sstab.p_user = ht;
   return( 0 );
}
/*
static void oncreateCompileOptions()
{
   /*
   if (sstIsPropInHash("_comp_none","p_value")) {
#if 0
      _comp_none.p_value = sstGetProp2("_comp_none","p_value",1);
      _comp_curr.p_value = sstGetProp2("_comp_curr","p_value",1);
      _comp_all.p_value = sstGetProp2("_comp_all","p_value",1);
      ctlcomplistmodified.p_value = sstGetProp2("ctlcomplistmodified","p_value",1);
      _make_none.p_value = sstGetProp2("_make_none","p_value",1);
      _make_curr.p_value = sstGetProp2("_make_curr","p_value",1);
      _make_all.p_value = sstGetProp2("_make_all","p_value",1);
      ctlmakelistmodified.p_value = sstGetProp2("ctlmakelistmodified","p_value",1);
      _clear_pbuffer.p_value = sstGetProp2("_clear_pbuffer","p_value",1);
      ctlcdb4compile.p_value = sstGetProp2("ctlcdb4compile","p_value",1);
#endif
      if (_win32s()==1 || machine()=='OS2386') {
         ctlcdb4compile.p_enabled=0;
      }
      return;
   }
   */

   //if (!sstIsControlExists("_comp_none")) return;
   //_macro('m',_macro('s'))
   parse def_save_on_compile with compile make;
   switch (strip(compile)) {
   case 0:
      _comp_none.p_value=1;
      break;
   case 1:
      _comp_curr.p_value=1;
      break;
   case 2:
      _comp_all.p_value=1;
      break;
   case 3:
      ctlcomplistmodified.p_value=1;
      break;
   }
   switch (strip(make)) {
   case 0:
      _make_none.p_value=1;
      break;
   case 1:
      _make_curr.p_value=1;
      break;
   case 2:
      _make_all.p_value=1;
      break;
   case 3:
      ctlmakelistmodified.p_value=1;
      break;
   }
   _clear_pbuffer.p_value=(def_compile_flags & COMPILEFLAG_CLEARPROCESSBUFFER)?1:0;
   ctlcdb4compile.p_value=(def_compile_flags & COMPILEFLAG_CDB4COMPILE)?1:0;
   ctlOutputToMDI.p_value=(int)(def_process_tab_output==0);
   if (_win32s()==1 || machine()=='OS2386') {
      ctlcdb4compile.p_enabled=0;
   }
   //_macro_append("def_compile_flags="def_compile_flags";");
}
*/
defeventtab _project_form._opendir_list _inherit _open_form._opendir_list;
static int getParentSSTab( int ctl )
{
   if (ctl.p_object == OI_SSTAB) return(ctl);
   parent = ctl.p_parent;
   while (parent) {
      if (parent.p_object == OI_SSTAB) return( parent );
      parent = parent.p_parent;
   }
   return( 0 );
}
_opendir_list.on_change(reason)
{
   int fid;
   fid = p_active_form;
   switch (reason) {
   case CHANGE_PATH:
      {
         // Size windows style open dialog
         width=_find_longest_line();
         cwidth=_dx2lx(p_xyscale_mode,p_client_width-p_windent_x);
         cwidth=cwidth-_twips_per_pixel_x()*5;
         if (width>cwidth) {
            diff_x=width-cwidth;
            p_active_form.p_width=p_active_form.p_width+diff_x;
            p_width=p_width+diff_x;
            tabctl = getParentSSTab(p_window_id);
            if (tabctl) tabctl.p_width = tabctl.p_width + diff_x;

            // Files tab:
            ctlhelp.p_x+=diff_x;
            _openchange_dir.p_x+=diff_x;
            _openinvert.p_x+=diff_x;
            _openfind_file.p_x+=diff_x;
            wid=_find_control("_changename");
            if (wid) wid.p_x+=diff_x;
            wid=_find_control("ctlassociate");
            if (wid) wid.p_x+=diff_x;
            _project_nofselected.p_x+=diff_x;
            _srcfile_list.p_width+=diff_x;
            wid=_find_control("_opendrives");
            if (wid) wid.p_width+=diff_x;
            _addall.p_x+=diff_x;
            _add.p_x+=diff_x;
            _addtree.p_x+=diff_x;
            _invert.p_x+=diff_x;
            _remove.p_x+=diff_x;
            _remove_all.p_x+=diff_x;
            ctlrefresh.p_x+=diff_x;

            // Directories tab:
            _prjworking_dir.p_width+=diff_x;
            _prjinclude_dirs.p_width+=diff_x;
            _prjtag_files.p_width+=diff_x;
            _prjref_files.p_width+=diff_x;
            _browsedir1.p_x+=diff_x;
            _browsedir2.p_x+=diff_x;
            _browsefile.p_x+=diff_x;
            _browserefs.p_x+=diff_x;
            ctlHelpLabelDir.p_width+=diff_x;

            // Tools tab:
            ctlToolCmdLine.p_width+=diff_x;
            ctlToolCmdLineButton.p_x+=diff_x;
            ctlToolMenuCaption.p_width+=diff_x;
            ctlHelpLabelTools.p_width+=diff_x;

            /*
            // Compile options tab:
            _saveCompileFrame.p_x+=diff_x intdiv 2;
            _saveMakeFrame.p_x+=diff_x intdiv 2;
            ctlHelpLabelCompile.p_width+=diff_x;
            */

            // Filters tab:
            ctlFilterNameList.p_width += diff_x;
            ctlFilterNew.p_x += diff_x;
            ctlFilterDelete.p_x += diff_x;
            ctlFilterMoveUp.p_x += diff_x;
            ctlFilterMoveDown.p_x += diff_x;
            ctlFilterParams.p_width += diff_x;
            ctlFilterPattern.p_width += diff_x;
            ctlFilterApp.p_width += diff_x;
            ctlFilterAppCmdButton.p_x += diff_x;
            ctlHelpLabelFilter.p_width+=diff_x;

            // Open Command tab:
            list1.p_width+=diff_x;
            ctlHelpLabelOpenCmd.p_width+=diff_x;
         }
      }

      // Update the directory list:
      path=_dlpath();
      _set_opencd(path);
      wildcards=_openfn.p_text;
      if (!iswildcard(wildcards)) {
         wildcards=_open_get_wildcards();
      }

      // Update the _openfile_list:
      _openfile_list._flfilename(wildcards,path)

      // Don't want the combo box text selected
      _openfn._set_sel(1);
      fid.removeMatchedEntriesFromOpenFileList();
   }
}
_openfile_types.on_change()
{
   parse _openfile_list._flfilename() with ';'old_files
   old_text=_openfn.p_text;
   parse p_cb_list_box._lbget_seltext() with '('files')'
   if ((_open_flags() & OFN_SAVEAS_FORMAT)) {
      //_openok.call_event(_openok,LBUTTON_UP);
   } else {
      if (files!='') {
         _openfile_list._flfilename(files,_opendir_list._dlpath());
         _openfn.p_text=files;
         if ((_open_flags() & OFN_SAVEAS) && old_files==files) {
            _openfn.set_command old_text,1
         } else {
            _openfn.p_text=files
         }
         _openfn._set_sel(1)
      }
   }
   removeMatchedEntriesFromOpenFileList();
}
_openfile_types.on_destroy()
{
   // This can happen if destroy the window because user wants to edit
   // the dialog
   parse _openfile_types.p_text with '('_last_wildcards')';
}

// Desc:  Get the current directory of the _opendir_list.
//        This may be the current directory or it may also
//        a Windows UNC name.
static _str getCurrentDir()
{
   // Check to see if this is a UNC name:
   _str currPath;
   currPath = _opencd.p_caption;
   if (pos("\\\\", currPath) == 1) {
      //messageNwait("getCurrentDir p_user2="_opendir_list.p_user2);
      //return(currPath);
      return(_opendir_list.p_user2);
   }

   // Return the current directory:
   return(getcwd());
}

// Desc:  Go thru the _srcfile_list and remove entries that exists
//        in the _openfile_list.
static void removeMatchedEntriesFromOpenFileList()
{
   // If project source file list is not modified, do nothing:
   if (PROJECT_FILE_LIST_MODIFIED=="") {
      return;
   }

   // Build the current directory path:
   _str currPath;
   currPath = getCurrentDir();
   if (last_char(currPath)!=FILESEP) {
      currPath=currPath:+FILESEP;
   }
#if !__UNIX__
   currPath = lowcase(currPath);
#endif

   int currLine = _srcfile_list.p_line;

   // Build a hash table of entries in the _openfile_list:
   int OpenFileListHashTab:[];
   OpenFileListHashTab._makeempty();
   _openfile_list._lbtop();_openfile_list._lbup();
   while (!_openfile_list._lbdown()) {
      filename=_openfile_list._lbget_text();
      OpenFileListHashTab:[_file_case(currPath:+filename)]=_openfile_list.p_line;
   }

   // Go thru the _srcfile_list:
   // If an entry exists in the hash table, mark the corresponding entry
   // in the _openfile_list with "" for deletion later:
   _srcfile_list._lbtop();_srcfile_list._lbup();
   while (!_srcfile_list._lbdown()) {
      filename=_srcfile_list._lbget_text();
      // Special case for "associated project files":
      if (substr(filename,1,1)=='*') {
         filename=substr(filename,2);
      }
      int *p;
      p=OpenFileListHashTab._indexin(_file_case(filename));
      if (p) {
         _openfile_list.p_line=*p;
         _openfile_list._lbset_item('');
      }
   }

   // Go thru the marked entries ("") in _openfile_list and remove them:
   _openfile_list._lbtop();_openfile_list._lbup();
   while (!_openfile_list._lbdown()) {
      if(_openfile_list._lbget_text()=='') {
         _openfile_list._lbdelete_item();
         _openfile_list._lbup();
      }
   }

   if (currLine) {
      _srcfile_list.p_line = currLine;
   }
   _openfile_list._lbtop();

   // Update # selected entries label for the _openfile_list:
   _opennofselected.p_caption=_openfile_list.p_Nofselected' of '_openfile_list.p_noflines' Files Selected'
}
static void oncreate_remove_all()
{
   if (machine()=='OS2386') {
      ctlassociate.p_visible=false;
   }
   removeMatchedEntriesFromOpenFileList();
}
defeventtab _project_form._openfn _inherit _open_form._openfn;
_openfn.enter()
{
   /* If multiple files may be selected in the file list box. */
   if (_openfn.p_text=='') {
      //_openfile_list._flfilename(_openfn.p_text,'',1); // Refresh File list
      //next_eventtab=defeventtab _open_form._openfn
      //call_event(next_eventtab, ON_CHANGE,'E');
      _ok.call_event(_ok, LBUTTON_UP);
   } else {
      // Ignore any on_change events to the _openfile_list:
      // This prevents any temporary state changes of the controls
      // associated with the _openfile_list.  If we don't have the
      // gProjectIgnoreOnChange boolean, control like _addall will
      // change p_enabled state to true when items are added to it
      // by _open_get_result().
      gProjectIgnoreOnChange = 1;

      // Arg(1) specifies whether to open wild cards.
      result=_open_get_result(arg(1))
      if (result != "") { // path matched a file, update the directory list
         _str path;
         path = strip_filename(result, "N");
         _opendir_list._dlpath(path);
      }

      // Start accepting on_change events again:
      gProjectIgnoreOnChange = 0;

      // IF error, do nothing
      if (result!='') {
         _openfile_list._flfilename(result,'',1); // Refresh File list
      }
      removeMatchedEntriesFromOpenFileList();
      updateControlsAssociatedWithOpenFileList();
   }
}

_ok.on_create()  // Project Properties on_create
{
   REFRESH_BUTTON_PRESSED=false;
#if !__UNIX__
   if (machine()=='OS2386' || _win32s()==1) {
      ctlToolChangeDir.p_enabled=false;
   }
#endif
   if (_project_name=="") {
      ctlToolChangeDir.p_enabled=false;
   }
   // If a real project is opened, _project_name is not "" and arg(1) == ""
   // If an extension project is opened, _project_name is "" and arg(1) is ".e" or ".c" or ...
   fid=p_active_form;
   project = "";
   if (arg()>=1) project = arg(1);

   // Disable unused tabs (for extension project):
   //
   // gProjectName is either the extension project name or the real project name.
   if (project != "") {  // extension project
      gProjectName = project;
      _proj_prop_sstab._setEnabled(PROJPROPTAB_FILES,0); // Files tab
      _proj_prop_sstab._setEnabled(PROJPROPTAB_FILTERS,0); // Filters
      _proj_prop_sstab._setEnabled(PROJPROPTAB_OPENCOMMAND,0); // Command

      // Make sure the active tab is one of the enabled ones:
      int active;
      active = _retrieve_value("_project_form._proj_prop_sstab");
      if (active == "") {
         active = _proj_prop_sstab.p_ActiveTab;
      }
      if (active == PROJPROPTAB_FILES || active == PROJPROPTAB_FILTERS ||
               active == PROJPROPTAB_OPENCOMMAND) {
         _proj_prop_sstab.p_ActiveTab = PROJPROPTAB_DIRECTORIES;
      }
   } else {              // real project
      gProjectName = _project_name;

      // Restore active tab:
      if (arg() > 10) {
         _proj_prop_sstab.p_ActiveTab = arg(11);
      } else {
         _proj_prop_sstab._retrieve_value();
      }
   }

   // Initialize the various tabs:
   // If an extension project is being opened, only the Directories, Tools, and
   // Compile Options tabs need to be initialized.
   _proj_prop_sstab.oncreate_proj_prop_sstab();
   if (_project_name != "") {  // a real project opened
      ctlFilterNameList.oncreateFilterNameList();
      ctlHelpLabelOpenCmd.oncreateMacro();
   }
   //ctlcdb4compile.oncreateCompileOptions();
   ctlToolName.oncreateTools(project);  // project == ".e" for extension project, "" for real project
   if (_project_name != "") {  // a real project opened
      _addall.oncreate_addall(arg(1),arg(2),arg(3),arg(4),arg(5),arg(6),arg(7),arg(8),arg(9),arg(10),arg(11),arg(12));
      _remove_all.oncreate_remove_all();
   }

#if __UNIX__
   // Disable this for now.
   ctlassociate.p_enabled = false;
#endif
}

_ok.on_destroy()
{
   //if (!sstIsControlExists("_openchange_dir")) return( "" );
   if (!_openchange_dir.p_value && _ok.p_user!=getcwd()) {
      chdir(_ok.p_user,1);//_ok.p_user has the name of the old directory.
      call_list('_cd_');
   }
   if (projectToolListStateSaved) {  // restore saved project tool list
      projectToolList = projectToolListSaved;
      projectToolListStateSaved = 0;
   }
}

defeventtab _project_form._openfile_list _inherit _open_form._openfile_list;
void _srcfile_list.on_destroy()
{
   //_str text;
   //text = sstGetLBExtText(_srcfile_list);
   //sstSetProp("_srcfile_list","p_exttext",'1',1);
}
static void updateControlsAssociatedWithOpenFileList()
{
   if (_openfile_list.p_Noflines == 0) {
      _add.p_enabled = false;
      _addall.p_enabled = false;
   } else {
      _addall.p_enabled = true;
      if (_openfile_list.p_Nofselected > 0) {
         _add.p_enabled = true;
      } else {
         _add.p_enabled = false;
      }
   }
}
_openfile_list.on_change(reason)
{
   // Honor ignoring the on_change event to prevent flashing
   // (ie. quick toggling of the p_enabled) of the buttons
   // associated with _openfile_list:
   if (!gProjectIgnoreOnChange) {
      updateControlsAssociatedWithOpenFileList();
   }
   next_eventtab=eventtab_inherit(defeventtab _open_form._openfile_list);
   next_eventtab=defeventtab _open_form._openfile_list;
   call_event(reason, next_eventtab, ON_CHANGE,'E');
}

_openfile_list.lbutton_double_click()
{
   _add.call_event(_add,LBUTTON_UP);
}

_add.lbutton_up()
{
   PROJECT_FILE_LIST_MODIFIED=1;
   _openfile_list._save_pos2(p);
   ff=1
   while (!_openfile_list._lbfind_selected(ff)) {
      filename=_openfile_list._lbget_text();
      cdir = getCurrentDir();
      if (last_char(cdir)!=FILESEP) {
         _srcfile_list._lbadd_item(cdir:+FILESEP:+_openfile_list._lbget_text());
      }else{
         _srcfile_list._lbadd_item(cdir:+_openfile_list._lbget_text());
      }
      ff=0;
   }
#if 1
   /* Delete Selected entries */
   ff=1
   while (!_openfile_list._lbfind_selected(ff)) {
      _openfile_list._lbdelete_item();
      _openfile_list.p_line=_openfile_list.p_line-1;
      ff=0;
   }
#endif
   _openfile_list._lbtop();
   _openfile_list._lbdeselect_all();
   p_enabled=0;
   _openfile_list._restore_pos2(p);
   _srcfile_list._lbsort('-f');
   _srcfile_list._remove_duplicates(_fpos_case);
   _srcfile_list._lbtop();
   _srcfile_list.call_event(CHANGE_SELECTED,_srcfile_list,ON_CHANGE,'');
   _openfile_list.call_event(CHANGE_SELECTED,_openfile_list,ON_CHANGE,'');
}
static void updateControlsAssociatedWithSrcFileList()
{
   _project_nofselected.p_caption=_srcfile_list.p_Nofselected' of '_srcfile_list.p_noflines' Files Selected';

   // If there is nothing in _srcfile_list, disable Remove All button and
   // if there is nothing selected in _srcfile_list, disable Remove button
   if (_srcfile_list.p_noflines == 0) {
      _remove_all.p_enabled = false;
      _remove.p_enabled = false;
      _invert.p_enabled = false;
   } else {
      _remove_all.p_enabled = true;
      _invert.p_enabled = true;
      if (_srcfile_list.p_Nofselected > 0) {
         _remove.p_enabled = true;
      } else {
         _remove.p_enabled = false;
      }
   }
}
_srcfile_list.on_change()
{
   updateControlsAssociatedWithSrcFileList();
}

_addtree.lbutton_up()
{
   int fid;
   fid = p_active_form;
   result=show('-modal _addtree_form',
               'Add Tree',
               C_WILDCARDS);
   if (result == "") {
      return("");
   }

   // Find all files in tree:
   mou_hour_glass(1);
   message('Visual SlickEdit is finding all files in tree');
   recursive=(_param2)?'+t':'-t';
   formwid=p_active_form;
   orig_view_id=_create_temp_view(filelist_view_id);
   p_view_id=filelist_view_id;
   for (i=0;i<_param1._length();++i) {
      insert_file_list(_param1[i]' 'recursive' -v +p -d');
   }
   _param1._makeempty();
   p_line=0;

   // Insert tree file list into project source file list:
   top();up();
   while (!down()) {
      get_line(filename);
      filename=strip(filename);
      if (filename=='') break;
      fid._srcfile_list._lbadd_item(filename);
   }
   p_view_id=orig_view_id;
   _delete_temp_view(filelist_view_id);

   // Sort and remove duplicate items in the project source file list:
   fid._srcfile_list._lbsort('-f');
   fid._srcfile_list._remove_duplicates(_fpos_case);
   fid._srcfile_list._lbtop();

   // Update the buttons associated with the lists:
   fid._srcfile_list.call_event(CHANGE_SELECTED,_srcfile_list,ON_CHANGE,'');
   fid._openfile_list.call_event(CHANGE_SELECTED,_openfile_list,ON_CHANGE,'');

   // Remove all matching files in the directory file list:
   PROJECT_FILE_LIST_MODIFIED=1;
   removeMatchedEntriesFromOpenFileList();

   // Indicate that the project source file list has been modified:
   mou_hour_glass(0);
   clear_message();
}

static void oncreate_addall()
{
   int fid;
   fid=p_active_form;
   _str fileToBeSelected;
   fileToBeSelected = "";
   if (arg() >= 12) fileToBeSelected = arg(12);
   fid.oncreateFiles(fileToBeSelected);
}

// Desc:  Add all the entries in the _openfile_list into the
//        _srcfile_list.
_addall.lbutton_up()
{
   // Indicate that the _srcfile_list has been changed:
   PROJECT_FILE_LIST_MODIFIED=1;

   cdir = getCurrentDir();
   _openfile_list.save_pos(p);
   _openfile_list._lbtop();_openfile_list._lbup();
   while (!_openfile_list._lbdown()) {
      if (last_char(cdir)!=FILESEP) {
         _srcfile_list._lbadd_item(cdir:+FILESEP:+_openfile_list._lbget_text());
         _openfile_list._lbdelete_item();//Dan added to remove filename from list
         _openfile_list._lbup();         //9:38am 2/13/1996
      }else{
         _srcfile_list._lbadd_item(cdir:+_openfile_list._lbget_text());
         _openfile_list._lbdelete_item();//Dan added to remove filename from list
         _openfile_list._lbup();         //9:38am 2/13/1996
      }
   }
   _srcfile_list._lbsort('-f');
   _srcfile_list._remove_duplicates(_fpos_case);
   _srcfile_list._lbtop();
   _openfile_list.restore_pos(p);
   _srcfile_list.call_event(CHANGE_SELECTED,_srcfile_list,ON_CHANGE,'');
   _openfile_list.call_event(CHANGE_SELECTED,_openfile_list,ON_CHANGE,'');
}

// Desc:  Add the selected entries in the _srcfile_list to the
//        _openfile_list if they are supposed to be in the
//        current directory.
static void addSelectedEntriesToOpenFileList()
{
   // Remember the current line in the _openfile_list so that
   // we can restore it after the update:
   int currLine;
   currLine = _openfile_list.p_line;

   // Indicate that the _srcfile_list is modified:
   PROJECT_FILE_LIST_MODIFIED=1;

   // Build the path to the current directory:
   _str currPath = getCurrentDir();
   if (last_char(currPath)!=FILESEP) {
      currPath=currPath:+FILESEP;
   }

   // Loop thru all the selected entries in the _srcfile_list:
   // Entries that are added back to the _openfile_list are removed
   // from _srcfile_list.
   int findfirst, changed;
   findfirst=1;
   changed=0;
   while (!_srcfile_list._lbfind_selected(findfirst)) {
      // We need a loop here because after _lbdelete_item() is called,
      // current entry is the following entry.  If we go back to the
      // outer loop, we would have skipped over the entry following the
      // selected entry!
      while (_srcfile_list._lbisline_selected()) {
         filename=_srcfile_list._lbget_text();
         // Special case for "associated project files":
         if (substr(filename,1,1)=='*') {
            _message_box(nls("%s cannot be removed from the project because it is in a makefile associated to the project.",substr(filename,2)));
            _srcfile_list._lbdeselect_line();
            continue;
         }

         // If path of selected file matches that of current directory,
         // add file name back to _openfile_list:
         // (Complete code is duplicated for paren matching!)
         path=strip_filename(filename,'ne');
#if __UNIX__
         if (path==currPath) {
            _openfile_list.save_pos(p);
            _openfile_list._lbadd_item(strip_filename(filename, 'p'));
            changed=1;
         }
#else
         if (!stricmp(path,currPath)) {
            _openfile_list.save_pos(p);
            _openfile_list._lbadd_item(strip_filename(filename, 'p'));
            changed=1;
         }
#endif
         _srcfile_list._lbdelete_item();
      }
      findfirst=0;
   }

   // If the _openfile_list was changed, re-sort it:
   if (changed) {
      _openfile_list._lbsort('-F');
      //_openfile_list.restore_pos(p);
      parse p with linenum col cursor_y left_edge p;
      if ( substr(linenum,1,1)=='r' ) {  /* Use real line number? */
         p_RLine=(int)substr(linenum,2);
      } else {
         if (linenum != 0) {
            _openfile_list.goto_point(p,linenum);
         }
      }
      _openfile_list.set_scroll_pos(left_edge,cursor_y);
      _openfile_list.p_col=col;
   }

   // Update all the controls associated with the lists:
   _srcfile_list.call_event(CHANGE_SELECTED,_srcfile_list,ON_CHANGE,'');
   _openfile_list.call_event(CHANGE_SELECTED,_openfile_list,ON_CHANGE,'');

   // Restore the current line in the _openfile_list or make the
   // first line in the list as the current line:
   if (currLine) {
      _openfile_list.p_line = currLine;
   } else if (_openfile_list.p_Noflines){
      _openfile_list.p_line = 1;
   }
}

// Desc:  Add the selected entries in the _srcfile_list to the
//        _openfile_list if they are supposed to be in the
//        current directory.
_remove.lbutton_up()
{
   addSelectedEntriesToOpenFileList();
}

_remove_all.lbutton_up()
{
   // Add all files back to openfile_list:
   PROJECT_FILE_LIST_MODIFIED=1;
   _srcfile_list._lbselect_all();
   _remove.call_event(_remove,LBUTTON_UP,'W');

   // Remove all files in srcfile_list:
   _srcfile_list._lbclear();
   _srcfile_list.call_event(CHANGE_SELECTED,_srcfile_list,ON_CHANGE,'');
   _openfile_list.call_event(CHANGE_SELECTED,_openfile_list,ON_CHANGE,'');
}

// Desc: Go thru the project file list and remove all files that do not exist.
void ctlrefresh.lbutton_up()
{
   int modified;
   modified = 0;
   _str result;
   int removed;
   boolean yesforall;
   removed = 0;
   result=_message_box('Remove deleted files from project without prompt?',"",MB_YESNOCANCEL|MB_DEFBUTTON2);
   if (result==IDCANCEL) {
      return;
   }
   REFRESH_BUTTON_PRESSED=true;
   yesforall= result==IDYES;
   mou_hour_glass(1);
   _srcfile_list._lbtop();
   _srcfile_list._lbup();
   Noflines=_srcfile_list.p_Noflines;
   while (!_srcfile_list._lbdown()) {
      _str line;
      line = _srcfile_list._lbget_text();

      // Skip over files from associate make files.
      if (pos("*", line) == 1) continue;

      linenum=_srcfile_list.p_line;
      //if (!(linenum % 5) || linenum==1) {
         message("Checking "linenum"/"Noflines': 'line);
      //}
      // If file does not exits, remove the file from the project
      // file list.
      result = file_match("-p "maybe_quote_filename(line), 1);
      if (result == "") {
         // If already selected "Yes for all", just remove the file
         // without asking. Otherwise, ask the user.
         clear_message();
         if (yesforall) {
            _srcfile_list._lbdelete_item();
            _srcfile_list._lbup();
            modified = 1;
            removed++;
         } else {
            _str msg;
            _str answer;
            msg = line :+ "\nno longer exists.\n\nRemove file from project?";
            answer = show("-modal _yesToAll_form", msg, "Remove File From Project");
            if (answer == "CANCEL") {
               break;
            } else if (answer == "YES") {
               _srcfile_list._lbdelete_item();
               _srcfile_list._lbup();
               modified = 1;
               removed++;
            } else if (answer == "YESTOALL") {
               _srcfile_list._lbdelete_item();
               _srcfile_list._lbup();
               modified = 1;
               removed++;
               yesforall= true;
            }
         }
      }
   }
   clear_message();
   if (removed) {
      _str fileMsg;
      fileMsg = "file";
      if (removed > 1) fileMsg = "files";
      _message_box("Project file list refreshed.\n\nRemoved "removed" "fileMsg".");
   }
   mou_hour_glass(0);
   if (modified) PROJECT_FILE_LIST_MODIFIED=1;
}

_invert.lbutton_up()
{
   _srcfile_list._lbinvert();
   _srcfile_list.call_event(CHANGE_SELECTED,_srcfile_list,ON_CHANGE,'')
}

static typeless okFiles(int & fileListModified)
{
   fileListModified=0;

   wid=p_active_form;
#if 0
   if (_openfile_list.p_Nofselected>0) {
      result=_message_box(nls("Do you wish to add the selected files to the project %s?",_project_name),
                              '',
                              MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDYES) {
         _add.call_event(_add, LBUTTON_UP);
      }
   }
#endif
#if 0
   //10:53am 11/5/1998
   //Delete this section of code when fix is verified...
   if (_project_name!='') {
      parse AssociatedMakefile with name "\t" type;
      if (name!='' && type!='') {
         status=_open_temp_view(name,temp_view_id,orig_view_id);
         if (!status) {
            date=p_file_date;
            p_view_id=orig_view_id;
            _delete_temp_view(temp_view_id);
            _ini_set_value(_project_name,"ASSOCIATION",'makefile',name);
            _ini_set_value(_project_name,"ASSOCIATION",'makefiletype',type);
            _ini_set_value(_project_name,"ASSOCIATION",'makefiledate',date);
         }
      }else{
         orig_view_id=_create_temp_view(temp_view_id);
         p_view_id=orig_view_id;
         _ini_put_section(_project_name,"ASSOCIATION",temp_view_id)
      }
   }
#endif

   int cid;
   cid = _find_control("_proj_prop_sstab");
   //if (!sstIsControlExists("_srcfile_list") && !cid.sstIsPropInHash("_srcfile_list","p_exttext")) return( 0 );
   // Update project:
   status = 0;
   if (PROJECT_FILE_LIST_MODIFIED || REFRESH_BUTTON_PRESSED) {
      fileListModified = 1;
      status=save_source_filenames(wid);

      //10:46am 11/5/1998
      //Dan moved this code from above because it has to happen after 
      //save_source_filenames so that "source file diff" works out right.
      if (_project_name!='') {
         parse AssociatedMakefile with name "\t" type;
         if (name!='' && type!='') {
            status=_open_temp_view(name,temp_view_id,orig_view_id);
            if (!status) {
               date=p_file_date;
               p_view_id=orig_view_id;
               _delete_temp_view(temp_view_id);
               _ini_set_value(_project_name,"ASSOCIATION",'makefile',name);
               _ini_set_value(_project_name,"ASSOCIATION",'makefiletype',type);
               _ini_set_value(_project_name,"ASSOCIATION",'makefiledate',date);
            } else {
               // This is probably a makefile that does not exist
               status=0;
            }
         }else{
            orig_view_id=_create_temp_view(temp_view_id);
            p_view_id=orig_view_id;
            _ini_put_section(_project_name,"ASSOCIATION",temp_view_id)
         }
      }

      clear_message();
   }
   return( status );
}
// Desc:  Check to see if the text field has been modified.
// Retn:  1 for modified, 0 for not.
static int isTextFieldModified(_str ctlName,typeless &ht)
{
   _str value;
   int cid;
   cid = _find_control(ctlName);
   value = "";
   if (cid) value = cid.p_text;
   if (!ht._indexin(ctlName)) return(1);
   if (ht._indexin(ctlName) && value != ht:[ctlName]) return(1);
   return(0);
}

// Desc:  Check to see if the specified project tool in the new project
//        tool table has been modified.
// Retn:  1 for table modified, 0 for not.
static int isProjectToolModified(typeless & oldprojectToolList,
                                 int toolIndex /* tool index in new table */)
{
   // If the tool is not in the old tool table...
   int otoolIndex;
   _str name;
   name = projectToolList[toolIndex].name;
   if (!isToolNameInProjectToolTable(oldprojectToolList,name,otoolIndex)) {
      return(1);
   }

   // Check individual fields...
   ProjectToolStruct i1, i2;
   i1 = projectToolList[toolIndex];
   i2 = oldprojectToolList[otoolIndex];
   if (i1.name != i2.name) {
      //messageNwait("isProjectToolModified name");
      return(1);
   }
   if (i1.nameKey != i2.nameKey) {
      //messageNwait("isProjectToolModified nameKey");
      return(1);
   }
   if (i1.cmd != i2.cmd) {
      //messageNwait("isProjectToolModified cmd");
      return(1);
   }
   if (i1.caption != i2.caption) {
      //messageNwait("isProjectToolModified caption");
      return(1);
   }
   if (i1.outputConcur != i2.outputConcur) {
      //messageNwait("isProjectToolModified outputConcur");
      return(1);
   }
   if (i1.captureOutput != i2.captureOutput) {
      //messageNwait("isProjectToolModified captureOutput");
      return(1);
   }
   if (i1.hideIfNoCmd != i2.hideIfNoCmd) {
      //messageNwait("isProjectToolModified hideIfNoCmd");
      return(1);
   }
   if (i1.clearProcessBuf != i2.clearProcessBuf) {
      //messageNwait("isProjectToolModified clearProcessBuf");
      return(1);
   }
   if (i1.saveOptions != i2.saveOptions) {
      //messageNwait("isProjectToolModified saveOptions");
      return(1);
   }
   if (i1.changeDir != i2.changeDir) {
      //messageNwait("isProjectToolModified changeDir");
      return(1);
   }
   //messageNwait("isProjectToolModified NO MODIFICATION");
   return(0);
}

// Desc:  Check to see if the project tool table has been modified.
// Retn:  1 for table modified, 0 for not.
static int isProjectToolListModified(typeless & oldprojectToolList)
{
   // If the table are of different lengths, they are different:
   if (projectToolList._length() != oldprojectToolList._length()) {
      return(1);
   }

   // Check to see if the tool table has been changed:
   int i;
   for (i=0; i<projectToolList._length(); i++) {
      if (isProjectToolModified(oldprojectToolList, i)) {
         return(1);
      }
   }
   return(0);
}

// Desc:  Front-end to handle OK button for the Directories and Tools tabs.
// Retn:  0 for OK, <>0 for error.
static int okTools()
{
   int status;
   status = okTools2();
   if (projectToolListStateSaved) {  // restore saved project tool list
      projectToolList = projectToolListSaved;
      projectToolListStateSaved = 0;
   }
   return(status);
}

// Desc:  Handle OK button for the Directories and Tools tabs.
// Retn:  0 for OK, <>0 for error.
static int okTools2()
{
   int fid;
   p_window_id = _control _proj_prop_sstab;
   fid=p_active_form;

   typeless ht:[];
   typeless tl;
   tl = _proj_prop_sstab.p_user;
   if (tl._varformat() == VF_HASHTAB) ht = _proj_prop_sstab.p_user;

   // Store the retrieval information:
   _append_retrieve(0, ctlToolName.p_text, "_project_form.toolNameSelected");

   // Retrieve the initial project tool table:
   ProjectToolStruct oldprojectToolList[];
   oldprojectToolList = ht:["projectToolList"];

   // If the project tool list and directories and files have
   // not been modified, do nothing:
   if (!isProjectToolListModified(oldprojectToolList) &&
            !fid.isTextFieldModified("_prjworking_dir",ht) &&
            !fid.isTextFieldModified("_prjinclude_dirs",ht) &&
            !fid.isTextFieldModified("_prjtag_files",ht) &&
            !fid.isTextFieldModified("_prjref_files",ht)) {
      return(0);
   }

   // Get the project file name and section name:
   _str filename, section_name;
   section_name = _proj_prop_sstab._prjworklab.p_user;
   filename = _proj_prop_sstab._prjworking_dir.p_user;

   /*
      Because some tools may have been deleted from the tool
      table, the deleted tools must also be deleted from
      the section (COMPILE for real project or .c for extension
      project) in the project file.

      We do this by first read the entire section and keep
      a list of key/values pairs that are not one of the
      predefined tools, or prefix with a valid tool key,
      or is one of the workingdir/includedirs/tagfiles/reffile keys.
      When we write out the project tools,
      we first write out this key/value pairs list and
      then we write the project tools.

      We use _ini_put_section() (instead of _ini_replace_section())
      to complete replace all matching keys and delete
      non-matching keys.
   */

   // Get the current section key/values pairs that are
   // not valid project tools:
   _str keyValueList[];
   int keyValueCount;
   keyValueList._makeempty();
   keyValueCount = 0;
   int status;
   status=_ini_get_section(filename, section_name, temp_view_id);
   int hasSection;
   hasSection = 1;
   if (status) {
      // If we can't read the extension project, it may be a new extension
      // project so we just let it go:
      if (pos(".",section_name) != 1) {
         _message_box(nls("Unable to read section '%s' from project %s.",section_name,filename));
         return(1);
      }
      hasSection = 0;
   }
   if (hasSection) {
      int first;
      first = 1;
      for (;;) {
         // Get the next text line from the temp view:
         // If no more, delete the temp view and its buffer.
         status=_ini_parse_line(temp_view_id, fname, info, first);
         if (status) break;
         _str oriInfo;
         oriInfo = info;
         parse info with cb_info ',' info;
         _str key;
         key = lowcase(fname);
         first=0;
         // We don't keep any old tools:
         if (isToolKeyValid(key)) continue;
         // We don't keep these because we write the new
         // ones later:
         if (key == "workingdir" || key == "includedirs" ||
             key == "tagfiles"   || key == "reffile") {
            continue;
         }
         keyValueList[keyValueCount] = fname :+ "=" :+ oriInfo;
         keyValueCount++;  // Found a non-tool key
      }
   }

   // Project Tools and Directories modified, update section and generate
   // code for macro recording:
   _macro('m',_macro('s'));
   orig_view_id=_create_temp_view(temp_view);
   if (orig_view_id=='') return(0);
   _macro_append("orig_view_id=_create_temp_view(temp_view);");
   _macro_append("if (orig_view_id=='') return('');");

   // Output all the non-tool key/value pairs:
   int i;
   for (i=0; i<keyValueList._length(); i++) {
      insert_line(keyValueList[i]);
      _macro_call("insert_line",keyValueList[i]);
   }

   // Output all the project tools:
   // We need to output all the tools because we can't be sure
   // whether tools have been added or deleted.  So we list all
   // current tools and replace the entire section.
   _str value;
   for (i=0; i<projectToolList._length(); i++) {
      _str text;
      value = buildToolCommandText(i);
      text = projectToolList[i].nameKey :+ "=" :+ value;
      insert_line(text);
      _macro_call("insert_line",text);
   }

   // Output the project directory and file paths into a
   // temp view:
   int TagFilesModified;
   TagFilesModified=0;
   int RefFileModified;
   RefFileModified=0;
   value=fid._proj_prop_sstab._prjworking_dir.p_text;
   insert_line 'workingdir='value;
   _macro_call("insert_line","workingdir="value);
   value=fid._proj_prop_sstab._prjinclude_dirs.p_text;
   insert_line 'includedirs='value;
   _macro_call("insert_line","includedirs="value);
   value=fid._proj_prop_sstab._prjtag_files.p_text;
   if (fid.isTextFieldModified("_prjtag_files",ht)) TagFilesModified=1;
   insert_line('tagfiles='value);
   _macro_call("insert_line","tagfiles="value);
   value=fid._proj_prop_sstab._prjref_files.p_text;
   if (fid.isTextFieldModified("_prjref_files",ht)) RefFileModified=1;
   insert_line('reffile='value);
   _macro_call("insert_line","reffile="value);

   // Replace the entire section, delete the previous
   // section content:
   activate_view(orig_view_id);
   _macro_append("activate_view(orig_view_id);");
   _ini_put_section(filename, section_name, temp_view);
   _macro_append("_ini_replace_section("_quote(filename)",\"":+section_name:+"\", temp_view);");

   // Update the extension project hash table:
   updateToolAccelText();
   if (substr(section_name,1,1)=='.') {
      projectExtensionProjectsHT:[lowcase(section_name)] = projectToolList;
   }

   // Update tag files:
   if (TagFilesModified) {
      _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   } else if (RefFileModified) {
      _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX);
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   }
   return( 0 );
}
static _str getNewLineChars(_str text)
{
   p = pos("\n",text);
   if (!p) return( "\n" );  // Can't find one so does not matter
   if (p < 2) return( "\n" );
   lc = substr(text,p-1,1);
   if (lc == "\r") return( "\r\n" );
   return( "\n" );
}
static int getMacroText(var text)
{
   flags = macroflags;
   max_Noflines = macromax_Noflines;
   max_filesize = macromax_filesize;

   /*
   if (!sstIsControlExists("list1")) {
      text = sstGetProp2("list1","p_text");
      if (flags & EDC_OUTPUTINI) {
         text = stranslate(text,'\\','\');
         //text = stranslate(text,'\n',list1.p_newline);
         _str newLineChars;
         newLineChars = getNewLineChars(text);  // only work for UNIX & DOS
         text = stranslate(text,'\n',newLineChars);
      }
      size = length(text);
      if (isinteger(max_filesize) && size>max_filesize) {
         _message_box(nls("Text too large. Only %s bytes are allowed",max_filesize));
         return(1);
      }
      return( 0 );
   }
   */

   if (isinteger(max_Noflines) && list1.p_Noflines>max_Noflines) {
      _message_box(nls("Too many lines in list. Only %s lines are allowed",max_Noflines));
      return(1);
   }
   size=list1.p_buf_size;
   text='';
   if (flags & EDC_OUTPUTINI) {
      list1.save_pos(p);
      list1.top();
      text=list1.get_text(list1.p_buf_size);
      text=stranslate(text,'\\','\');
      text=stranslate(text,'\n',list1.p_newline);
      size=length(text);
      list1.restore_pos(p);
   } else if(flags & EDC_OUTPUTSTRING){
      list1.save_pos(p);
      list1.top();
      text=list1.get_text(list1.p_buf_size);
      size=length(text);
      list1.restore_pos(p);
   }
   if (isinteger(max_filesize) && size>max_filesize) {
      _message_box(nls("Text too large. Only %s bytes are allowed",max_filesize));
      return(1);
   }
   return( 0 );
}
static int okMacro()
{
   typeless ht:[];
   typeless tl;
   tl = _proj_prop_sstab.p_user;
   if (tl._varformat() == VF_HASHTAB) ht = _proj_prop_sstab.p_user;

   p_window_id = _control _proj_prop_sstab;
   //if (!sstIsControlExists("list1") && !sstIsPropInHash("list1","p_text")) return( 0 );
   int status;
   status = getMacroText(text);
   if (status) return( 1 );
   if (ht._indexin("macro") && text != ht:["macro"]) {
      _macro('m',_macro('s'))
      _ini_set_value(_project_get_filename(),"COMPILER","MACRO",text);
      _macro_call("_ini_set_value", _project_get_filename(),
                  "COMPILER", "MACRO", text);
   }
   return( 0 );
}
/*
static int okCompileOptions()
{
   typeless ht:[];
   ht = _proj_prop_sstab.p_user;

   p_window_id = _control _proj_prop_sstab;
   //if (!sstIsControlExists("_comp_curr") && !sstIsPropInHash("_comp_curr","p_value")) return( 0 );
   if (_comp_curr.p_value/*sstGetProp2("_comp_curr","p_value")*/) {
      comp=1;
   }else if (_comp_all.p_value/*sstGetProp2("_comp_all","p_value")*/) {
      comp=2;
   }else if (ctlcomplistmodified.p_value/*sstGetProp2("ctlcomplistmodified","p_value")*/) {
      comp=3;
   }else{
      comp=0;
   }
   if (_make_curr.p_value/*sstGetProp2("_make_curr","p_value")*/) {
      make=1;
   }else if (_make_all.p_value/*sstGetProp2("_make_all","p_value")*/) {
      make=2;
   }else if (ctlmakelistmodified.p_value/*sstGetProp2("ctlmakelistmodified","p_value")*/) {
      make=3;
   }else{
      make=0;
   }
   _macro('m',_macro('s'))
   int compile_flags;
   compile_flags = def_compile_flags;
   if (_clear_pbuffer.p_value/*sstGetProp2("_clear_pbuffer","p_value")*/) {
      compile_flags|=COMPILEFLAG_CLEARPROCESSBUFFER;
   } else {
      compile_flags&=~COMPILEFLAG_CLEARPROCESSBUFFER;
   }
   if (ctlcdb4compile.p_value/*sstGetProp2("ctlcdb4compile","p_value")*/) {
      compile_flags|=COMPILEFLAG_CDB4COMPILE;
   } else {
      compile_flags&=~COMPILEFLAG_CDB4COMPILE;
   }
   if (ht._indexin("def_compile_flags") && compile_flags != ht:["def_compile_flags"]) {
      def_compile_flags = compile_flags;
      _config_modify|=CFGMODIFY_DEFVAR;
      _macro_append('def_compile_flags='def_compile_flags';');
   }
   _str save_on_compile;
   save_on_compile=comp' 'make;
   if (ht._indexin("def_save_on_compile") && save_on_compile != ht:["def_save_on_compile"]) {
      def_save_on_compile = save_on_compile;
      _config_modify|=CFGMODIFY_DEFVAR;
      _macro_append('def_save_on_compile='def_save_on_compile';');
   }
   typeless processTabOutput;
   processTabOutput = 1;
   if (ctlOutputToMDI.p_value/*sstGetProp2("ctlOutputToMDI","p_value")*/) {
      processTabOutput = 0;
   }
   if (processTabOutput != def_process_tab_output) {
      def_process_tab_output = processTabOutput;
      _config_modify|=CFGMODIFY_DEFVAR;
      _macro_append('def_process_tab_output='def_process_tab_output';');
   }
   return( 0 );
}
*/
_ok.lbutton_up()
{
   mou_hour_glass(1);
   doOK();
   mou_hour_glass(0);
}
static doOK()
{
   _tbSetRefreshBy(VSTBREFRESHBY_PROJECT);
   fid=p_active_form;
   if (substr(gProjectName,1,1)==".") {  // extension project is opened
      status = fid.okTools();
      if (status) return("");
      //status = fid.okCompileOptions();
      //if (status) return("");
   } else {                              // real project is opened
      //say( "okCompileOptions "sstGetProp2("_comp_curr","p_value") );
      int fileListModified, filterModified;
      status = fid.okFiles(fileListModified);
      if (status) return("");
      status = fid.okTools();
      if (status) return("");
      status = fid.okMacro();
      if (status) return("");
      //status = fid.okCompileOptions();
      //if (status) return("");
      status = fid.okFilter(filterModified);
      if (status) return("");
      if (fileListModified || filterModified) {
         toolbarUpdateFilterList(gProjectName);
      }
      /*if (fileListModified) {
         call_list("_project_update_files_");
      } */
   }
   value = _proj_prop_sstab.p_ActiveTab;
   _append_retrieve( _proj_prop_sstab, value );
   fid._delete_window(0);
}


_edit_settings.lbutton_up()
{
   result=show('-modal _project_form',
               _project_name);
}

/*
_changename.lbutton_up()
{
   result=project_rename();
   if (result=='') {
      return('');
   }
   if (substr(result,1,1)=='-') {
      return(result);
   }
   p_active_form.p_caption='Source Files For 'result;
}
*/

ctlassociate.lbutton_up()
{
   olduser=AssociatedMakefile;
   //Since the association does not have to change to require a
   //refresh, I need to store it in _param1
   _param1=0;   // Remember whether user changed something
   _param2='';
   //_param1 is used for a list of files to "add", not associate
   result=show('-modal _makefile_form',_project_name,olduser);
   // Don't check result!='' because filename is '' when users
   // does disassociate
   if (_param1) {
      PROJECT_FILE_LIST_MODIFIED=1;
      AssociatedMakefile=result;
      _srcfile_list._lbclear();
      FileList=_param2;
      _srcfile_list.get_filelist(p_active_form,FileList);
      //toolbarUpdateFilterList(_project_name);
      //call_list('_project_update_files_');
      _project_nofselected.p_caption='0 of '_srcfile_list.p_noflines' Files Selected';
   }
}

/*
  _compileLabel.p_user  indicates section.
  _prjworking_dir.p_user  indicates filename

*/

defeventtab _project_form;
_prjcompile_concur.lbutton_up()
{
   if (p_value) {
      p_next.p_value=1
   }
}

_prjcompile_capture.lbutton_up()
{
   if (!p_value) {
      p_prev.p_value=0;
   }
}

/*
defeventtab _project_open_form;
_opencancel.on_create()
{
   _project_label.p_caption=(_project_name=='')?'':'The current project is '_project_name;
#if !__UNIX__
   if (_project_label.p_caption=='') {
      p_active_form.p_height-=_project_label.p_height;
   }
#endif
}
*/

defeventtab _project_new_form;
void _new_prjname.on_change()
{
   exename=strip_filename(p_text,'pe');
#if __UNIX__
   ctlExecutableName.p_text=exename;
#else
   ctlExecutableName.p_text=exename".exe";
#endif
}
ctlBrowsedir.lbutton_up()
{
   wid=p_window_id;
   result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
   if( result=='' ) {
      return('');
   }
   p_window_id=wid.p_prev;
   result=strip(result,'B','"');
   if (last_char(result) != FILESEP) {
      result = result :+ FILESEP;
   }
   result=maybe_quote_filename(result);
   p_text=result;
   end_line();
   _set_focus();
   return('');
}
_new_prjok.on_create()
{
   name=arg(1);
   if (name != '') {
      _new_prjname.p_text = name;
   /*} else {
      _new_prjname.p_text = "*":+PRJ_FILE_EXT;*/
   }
   _str currentDir;
   currentDir = getcwd();
   if (last_char(currentDir) != FILESEP) {  // append a FILESEP if there is not one
      currentDir = currentDir :+ FILESEP;
   }
   ctlProjectNewDir.p_text = currentDir;
   wid=p_window_id;
   p_window_id=_control _pkglist;
   filename=slick_path_search(PRJ_PACKS_FILE);
   _ini_list_sections(filename);
   _lbtop();
   for (;;) {
      text=_lbget_text();
      if (machine()=='OS2386') {
         if (pos('Windows',text,1,'i') || pos('WIN32S',text,1,'i')) {
            if (_lbdelete_item()) break;
         } else {
            if (_lbdown()) break;
         }
      } else {
         if (pos('OS/2',text)) {
            if (_lbdelete_item()) break;
         } else {
            if (_lbdown()) break;
         }
      }
   }
   _lbsort();
   _lbtop();
   _lbselect_line();

   // If a default compiler package is specified, use it.
   // Otherwise select the last compiler package selected.
   if (_compiler_default == "") {
      _compiler_restore = _retrieve_value("_project_new_form.packageSelected");
   } else {
      _compiler_restore = _compiler_default;
   }
   if (_compiler_restore == "") {
      _compiler_restore = "(None)";
   }
   _compiler_restore = lowcase(_compiler_restore);
   int found;
   found = 0;
   _lbtop();_lbup();
   while (!_lbdown()) {
      if (!stricmp(_lbget_text(),_compiler_restore)) {
         _lbselect_line();
         found = 1;
         break;
      }
   }
   // If no exact match, try a prefix match:
   // Use the first match.
   if (!found) {
      _lbtop();_lbup();
      while (!_lbdown()) {
         text=lowcase(_lbget_text());
         if (pos(_compiler_restore,text) == 1) {
            _lbselect_line();
            found = 1;
            break;
         }
      }
   }
   // If no compiler package can be matched, use the first package
   // which is the (None) package:
   if (!found) {
      _lbtop();
      _lbselect_line();
   }
   p_window_id=wid;
}

static int _mkdir_chdir(path)
{
   status=cd(path);
   if (status) {
      clear_message();
      if (status==ACCESS_DENIED_RC) {
         _message_box(get_message(ACCESS_DENIED_RC));
         return(status);
      }
      result=_message_box(nls("Directory %s does not exist\n\nCreate it?",path),"",MB_ICONQUESTION|MB_YESNOCANCEL);
      if (result!=IDYES) {
         return(COMMAND_CANCELLED_RC);
      }
      status=make_path(path);
      if (status) {
         _message_box(nls("Unable to create directory %s",path));
         return(status);
      }
      return(cd(path));
   }
   return(0);
}
void _new_prjok.lbutton_up()
{
   fid=p_active_form;
   wid=p_window_id;
   if (_new_prjname.p_text==''/*||pos('*', _new_prjname.p_text)*/) {
      _new_prjname.p_text=next_temp_name('p');
   }
   orig_cwd=getcwd();
   if(ctlProjectNewDir.p_text!='' && _mkdir_chdir(ctlProjectNewDir.p_text)) return;

   // Build full path to project file:
   filename=absolute(_new_prjname.p_text);
   if (!file_eq(get_extension(filename,1),PRJ_FILE_EXT)) {
      filename=filename:+PRJ_FILE_EXT;
   }
   if(_mkdir_chdir(strip_filename(filename,'N'))) return;

   // WE WANT THE NEW DIRECTORY TO BE THE PROJECT DIRECTORY.
   //cd(orig_cwd);

   // Check to see if file already exists:
   if (file_match("-p "maybe_quote_filename(filename), 1)!='') {
      _message_box(nls("Project %s already exists.",filename));
      return;
   }
   p_window_id=fid;
   comp_name=_pkglist._lbget_text();
   _param1=ctlExecutableName.p_text;
   _param2=comp_name;
   _compiler_restore = comp_name;  // Remember the compiler package
   p_window_id=wid;
   p_active_form._delete_window(filename);
}

void _project_new_form.on_destroy()
{
   _append_retrieve(0, _compiler_restore, "_project_new_form.packageSelected");
}

/*
defeventtab _project_rename_form;
_project_rename_form.on_load()
{
   p_window_id=_control _new_name;
}

_ok.on_create()
{
   //_prjlabel.p_caption=_prjlabel.p_caption:+' '_project_name;
   _new_name.p_text=_project_name;
}

_ok.lbutton_up()
{
   p_active_form._delete_window(_new_name.p_text);
}
*/

// Input filename to this function must be absolute.  This requirement
// is imposed so that unnecessary disk reads (durring autorestore) do
// not occur.  Calling the absolute function for floppy drives is slow.
//
_str def_max_prjhist=9;
#define PROJECTHIST_HELP ''
#define PROJECTHIST_MESSAGE 'Opens the project'

void _menu_add_prjhist(filename)
{
   call_list("_MenuAddPrjHist_",filename);
   if (!def_max_filehist || !_mdi.p_menu_handle) return;
   _menu_add_hist(filename,_mdi.p_menu_handle,'&Project','prjhist','project-open','ncw|prjopen',PROJECTHIST_HELP,PROJECTHIST_MESSAGE)
}

static close_all2()
{

   /* If leaves '.process' buffer up if def_auto_restore&RF_PROCESS */

   status=list_modified(nls("Save Changes Before Closing"));
   p_window_id=_mdi.p_child;
   if (status) {
      return(status);
   }
   process_check=((def_restore_flags&RF_PROCESS)&&arg(1)==1);
   found_process=0;
   x=0;
   for (;;) {
      if (p_modify)  {
         p_modify=0;
      }
      if (p_buf_name=='.process'&&!found_process&& process_check) {
         found_process=1;
         _next_buffer();
         continue;
      }
      if (p_buf_name=='.process') {
         status=0;
         if (!process_check) {
            status=close_buffer();
         }
      }else{
         status=close_buffer();
      }
      if (status||(p_buf_name=='.process'&&found_process&&process_check)) {
         status=0;
         if (found_process) {
            if (!_no_child_windows()) {
               old_win_style=def_one_file;
               def_one_file='';
               while (!status) {
                  status=close_window();
               }
               def_one_file=old_win_style;
            }
         }
         return(0);
      }
   }
}

static boolean keep_process_up(filename)
{
   /* Returns 1 if restore file "filename" has a entry for a .process buffer  */

   get_view_id view_id;
   if (arg(2)!='') {
      info=arg(2);
   }else{
      //_ini_get_value(filename, "AUTO RESTORE", 'state_name', info, 'default value');
      //if (info=='default value') return(0);
      info='STATE'
   }
   status=_ini_get_section(filename, info, project_file_view_id);
   if (status) {
      return(0);
   }
   activate_view project_file_view_id;
   status=search('^(BUFFER\: BN=".process")','r@');
   activate_view view_id;
   _delete_temp_view(project_file_view_id);
   return(!status);
}

defeventtab _project_form;
static get_filelist(form_wid,.../*AdditionalFileList*/)
{
   AdditionalFileList=arg(2);
   _nocheck _control _srcfile_list
   wid=p_window_id;
   get_view_id view_id;
   //11:45am 8/18/1997
   //Dan changed for makefile support
   //status=_ini_get_section(_project_get_filename(), _project_get_section("FILES"), ini_view_id);

   //Ok, since the association stuff insn't actually in the project file
   //yet, we have to do this.
   parse AssociatedMakefile with Makefilename "\t" MakefileType;
   status=GetProjectFiles(_project_get_filename(), ini_view_id,'*',Makefilename,MakefileType);
   if (status) {
      /* Prompt the user here? */
      if (status==FILE_NOT_FOUND_RC&&_project_name!='') {
         status=_ini_create_section(_project_name, "FILES");
         return(status);
      }
      if (status==STRING_NOT_FOUND_RC) {
         activate_view view_id;
         return(0);
      }
      if (status) {
         _message_box(nls("An error occured while loading the project %s",_project_get_filename()));
         p_window_id=wid;
         return(status);
      }
   }
   activate_view ini_view_id;
   //Dump the AdditionalFileList stuff in now so that we only have to do
   //one sort and remove
   for (;;) {
      filename=parse_file(AdditionalFileList);
      filename=strip(filename,'b','"');
      if (filename=='') break;
      //Before we add, we have to look to see if this is in an
      //associated makefile
      p_line=0;
      status=search('^\*'_escape_re_chars(filename)'$','r@'_fpos_case);
      if (status) {
         insert_line(filename);
      }
   }
   mark_id=_alloc_selection();
   top();
   _select_line(mark_id);
   bottom();
   status=_select_line(mark_id) ;
   if (!status) {//If _select_line returned an error we don't have to do this stuff
      _shift_selection_right(mark_id);
      form_wid._srcfile_list._copy_to_cursor(mark_id);
      form_wid._srcfile_list._lbtop();
      form_wid._srcfile_list._lbsort('-f');
      form_wid._srcfile_list._remove_duplicates(_fpos_case);
      form_wid._srcfile_list._lbtop();
   }else{
      clear_message();
   }
   _free_selection(mark_id);
   _delete_temp_view(ini_view_id);
   activate_view view_id;
   return(0);
}

static get_list_filename()
{
   return(_project_name);
}

static void RemoveMakefileFilesFromView()
{
   p_line=0;
   for (;;) {
      status=search('^\*','r@');
      if (status) break;
      _delete_line();
      _begin_line();
   }
}

static void GetNewFileList(_str (&NewFiles)[],_str (&DeletedFiles)[])
{
   _str NewFileTable:[];
   _str ExistingFileTable:[];
   top();up();
   while (!down()) {
      get_line(CurFilename);
      CurFilename=substr(CurFilename,2);//Getting text from a list box
      if (substr(CurFilename,1,1)=='*') CurFilename=substr(CurFilename,2);
      NewFileTable:[CurFilename]=1;
   }
   orig_view_id=p_view_id;
   status=_ini_get_section(_project_name,"Files",temp_view_id);
   if (status) {
      return;
   }

   p_view_id=temp_view_id;
   top();up();
   while (!down()) {
      get_line(CurFilename);
      if (substr(CurFilename,1,1)=='*') CurFilename=substr(CurFilename,2);
      ExistingFileTable:[CurFilename]=1;
   }
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);


   for (i._makeempty();;) {
      NewFileTable._nextel(i);
      if (i._varformat()==VF_EMPTY) break;
      if (!ExistingFileTable._indexin(i)) {
         NewFiles[NewFiles._length()]=i;
      }
   }
   for (i._makeempty();;) {
      ExistingFileTable._nextel(i);
      if (i._varformat()==VF_EMPTY) break;
      if (!NewFileTable._indexin(i)) {
         DeletedFiles[DeletedFiles._length()]=i;
      }
   }
}

static int MaybeAddFilesToVC(_str NewFiles[])
{
   if ( NewFiles._length() &&
        ( ( machine()=='NT386' && _isscc(def_vc_system) && _SCCProjectIsOpen() ) ||
           _VCSCommandIsValid(VCS_CHECKIN_NEW)) ) {
      result=_message_box(nls("Do you want to add the new files to version control?"),'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDYES) {
         result=show('-modal _vc_comment_form',NewFiles[0],1,1);
         if (result=='') {
            return(COMMAND_CANCELLED_RC);
         }
         comment=_param1;
         prompt_for_each_comment=!_param2;
         if (_isscc(def_vc_system) && machine()=='NT386') {
            if (prompt_for_each_comment) {
               int FileStatus[];
               FileStatus._makeempty();
               for (i=0;i<NewFiles._length();++i) {
                  _str CurFiles[];
                  CurFiles[0]=NewFiles[i];
                  status=vsSccAdd(CurFiles,comment);
                  if (i+1>=NewFiles._length()) {
                     break;
                  }
                  result=show('-modal _vc_comment_form',NewFiles[i+1],1,1);
                  if (result=='') {
                     return(COMMAND_CANCELLED_RC);
                  }
                  comment=_param1;
                  prompt_for_each_comment=!_param2;
                  if (!prompt_for_each_comment) break;
               }
               if (i<NewFiles._length()-1) {
                  //There are some left, but use same comment for all
                  _str CurFiles[];
                  for (j=i+1;j<NewFiles._length();++j) {
                     CurFiles[j-(i+1)]=NewFiles[j];
                  }
                  status=vsSccAdd(CurFiles,comment);
               }
            }else{
               status=vsSccAdd(NewFiles,comment);
            }
         }else{
            if (prompt_for_each_comment) {
               int SkipNext=0;
               for (i=0;i<NewFiles._length();++i) {
                  if (!SkipNext) {
                     vcadd(NewFiles[i],comment);
                  }
                  SkipNext=0;
                  if (i+1>=NewFiles._length()) {
                     break;
                  }
                  result=show('-modal _vc_comment_form',NewFiles[i+1],1,1);
                  if (result=='') {
                     SkipNext=1;
                     continue;
                  }
                  comment=_param1;
                  prompt_for_each_comment=!_param2;
                  if (!prompt_for_each_comment) break;
               }
               for (j=i+1;j<NewFiles._length();++j) {
                  vcadd(NewFiles[j],comment);
               }
            }else{
               for (i=0;i<NewFiles._length();++i) {
                  vcadd(NewFiles[i],comment);
               }
            }
         }
      }
   }
   return(0);
}

static int AddAndRemoveFilesFromVC(int SrcFileWID)
{
   // Update project file:
   _str NewFiles[];
   _str DeletedFiles[];
   SrcFileWID.GetNewFileList(NewFiles,DeletedFiles);

   if (_isscc(def_vc_system) && machine()=='NT386') {
      status=vsSccQueryInfo(NewFiles,FileStatus);
      if (!status) {
         for (i=0;i<FileStatus._length();++i) {
            if (FileStatus[i]) {
               //File is already in Version control...
               NewFiles._deleteel(i);
               FileStatus._deleteel(i);
               --i;
            }
         }
      }
   }
   MaybeAddFilesToVC(NewFiles);
   if (_isscc(def_vc_system) && machine()=='NT386') {
      status=vsSccQueryInfo(DeletedFiles,FileStatus);
      if (!status) {
         for (i=0;i<FileStatus._length();++i) {
            if (!FileStatus[i]) {
               //File is not in Version control...
               DeletedFiles._deleteel(i);
               FileStatus._deleteel(i);
               --i;
            }
         }
      }
   }
   if ( DeletedFiles._length() &&
        ( (machine()=='NT386' && _isscc() && _SCCProjectIsOpen() ) ||
           _VCSCommandIsValid(VCS_REMOVE)) ) {
      result=_message_box(nls("You have removed some files from your project that are under version control.\n\nWould you like to remove these files from version control?"),'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result==IDYES) {
         if (_isscc(def_vc_system) && machine()=='NT386') {
            vsSccRemove(DeletedFiles,'');
         }else{
            for (i=0;i<DeletedFiles._length();++i) {
               vcremove(DeletedFiles[i]);
            }
         }
      }
   }
   return(0);
}

static void ProjectAddRemoveFromTagFile(int list_view_id)
{
   
   int orig_view_id=p_view_id;
   if (_project_name=='') {
      return;
   }
   message("Getting source files in current project");
   mou_hour_glass(1);
   _str tag_filename = _GetProjectTagsFilename();
   int status=GetProjectFiles(_project_name, old_list_view_id,
                              '*'  // Need this for correct sort
                              );
   if (status) {
      mou_hour_glass(0);
      return;
   }
   // open, or create from scratch the tag file
   status = _OpenOrCreateTagFile(tag_filename, false);
   if (status) {
      mou_hour_glass(0);
      return;
   }
   activate_view(list_view_id);top();up();
   num_files=p_Noflines;
   activate_view(old_list_view_id);
   sort_buffer('-f');
   top();up();
   boolean doNextFile=true;
   for (;;) {
      if (doNextFile) {
         activate_view(old_list_view_id);
         if (down()) {
            old_filename="";
         } else {
            get_line(old_filename);
         }
         activate_view(list_view_id);
         if (down()) {
            filename="";
         } else {
            filename=_lbget_text();
         }
         //message('Processing 'p_line'/'num_files': 'filename);
      }
      //messageNwait('filename='filename' old_filename='old_filename);
      if (file_eq(filename,old_filename)) {
         if (filename=="") {
            break;
         }
         doNextFile=true;
         continue;
      }
      doNextFile=false;
      tfilename=_file_case(filename);
      if (substr(tfilename,1,1)=='*') {
         tfilename=substr(tfilename,2);
      }
      told_filename=_file_case(old_filename);
      if (substr(told_filename,1,1)=='*') {
         told_filename=substr(told_filename,2);
      }
      // IF a file was deleted
      if ((tfilename>told_filename && told_filename!="") || tfilename=="") {
         for (;;) {
            //messageNwait('remove file 'told_filename);
            // Delete told_filename from tag file
            message('Removing 'told_filename);
            tag_remove_from_file(told_filename,1);
            activate_view(old_list_view_id);
            if (down()) {
               old_filename="";
               break;
            } else {
               get_line(old_filename);
               told_filename=_file_case(old_filename);
               if (substr(told_filename,1,1)=='*') {
                  told_filename=substr(told_filename,2);
               }
            }
            if (tfilename!="" && tfilename<=told_filename) {
               break;
            }
         }
      } else {
         for (;;) {
            //messageNwait('add file 'filename);
            // Add filename to tag file
            _str xfilename=filename;
            if (substr(xfilename,1,1)=='*') {
               xfilename=substr(xfilename,2);
            }
            activate_view(list_view_id);
            message('Tagging 'p_line'/'num_files': 'xfilename);
            boolean inmem=true;
            int status=_open_temp_view(xfilename,temp_view_id,filelist_view_id,'+b');
            if (status) {
               inmem=false;

               status=_open_temp_view(xfilename,temp_view_id,filelist_view_id);
               if (!status) select_edit_mode();
            }
            if (!status) {
               RetagCurrentFile();
               // close the temporary view
               if (inmem) {
                  p_buf_flags&=~HIDE_BUFFER;
                  _quit_view();
                  p_view_id=filelist_view_id;
               }else{
                  p_view_id=filelist_view_id;
                  _delete_temp_view(temp_view_id);
               }
            }
            activate_view(list_view_id);
            if (down()) {
               filename="";
               break;
            } else {
               filename=_lbget_text();
               tfilename=_file_case(filename);
               if (substr(tfilename,1,1)=='*') {
                  tfilename=substr(tfilename,2);
               }
            }
            if (told_filename!="" && tfilename>=told_filename) {
               break;
            }
         }
      }
   }
   // close the database and check that it was clean
   status = tag_close_db(tag_filename, 1/*leave it open for read*/);
   if (status) {
      _message_box(nls("Error closing tags database %s.\n%s",tag_filename,get_message(status)));
   }
   _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX,tag_filename);
   _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   
   // that's all folks
   clear_message();
   mou_hour_glass(0);
   activate_view(orig_view_id);
}
static int save_source_filenames(form_wid)
{
   if (_project_name=='') return( 0 );

   if (!form_wid.REFRESH_BUTTON_PRESSED) {
      // Do the fast add/remove tag files
      ProjectAddRemoveFromTagFile(form_wid._srcfile_list.p_view_id);
      AddAndRemoveFilesFromVC(form_wid._srcfile_list);
   }
   

   view_id=_create_temp_view(temp_view_id);
   mark_id=_alloc_selection();
   form_wid._srcfile_list._lbtop();
   form_wid._srcfile_list._select_line(mark_id);
   form_wid._srcfile_list._lbbottom();
   status=form_wid._srcfile_list._select_line(mark_id);
   if (!status) {// If an error was returned from _select_line, there were no files in
                 // the list
      activate_view temp_view_id;
      _copy_to_cursor(mark_id);
      _deselect(mark_id);
      top();
      _select_line(mark_id);
      bottom();
      _select_line(mark_id);
      _shift_selection_left(mark_id);
      // Retag differences
      RemoveMakefileFilesFromView();
   }
   _free_selection(mark_id);
   activate_view view_id
   status=_ini_put_section(_project_name, "FILES", temp_view_id);
   if (status) {
      _message_box(nls("Could not save changes to file %s.\n\n%s\n\nThis file may be read only.",_project_name,get_message(status)));
      p_window_id=form_wid;
      return(status);
   }

   // Generate code for macro recording:
   p_window_id=_mdi.p_child;
   _macro('m',_macro('s'))
   orig_view_id=_create_temp_view(temp_view);
   _macro_append("orig_view_id=_create_temp_view(temp_view);");
   if (orig_view_id=='') {
      p_window_id=form_wid;
      return(1);
   }
   _macro_append("if (orig_view_id=='') return('');");

   form_wid._srcfile_list._lbtop();
   form_wid._srcfile_list._lbup();
   while (!form_wid._srcfile_list._lbdown()) {
      _str line;
      line = form_wid._srcfile_list._lbget_text();
      _macro_call("insert_line",line);
   }
   activate_view orig_view_id;
   _macro_append("activate_view(orig_view_id);");
   _macro_append("_ini_put_section("_quote(_project_name)",\"FILES\", temp_view);");

   if (form_wid.REFRESH_BUTTON_PRESSED) {
      // Here we are conservative.  
      AddAndRemoveFilesFromVC(form_wid._srcfile_list);
      // Rebuild tag file if necessary
      _project_update_files_retag();
   }
   p_window_id=form_wid;
   return(0);
}

/*
static _get_shell_command(_str ctlName)
{
   int wid;
   wid = sstIsControlExists(ctlName);
   if (!wid) {
      _str widptext;
      int concur, capture;
      widptext = _proj_prop_sstab.sstGetProp2(ctlName,"p_text");
      if (widptext == "") return( "" );
      flags='';
      concur = _proj_prop_sstab.sstGetProp2(ctlName:+"_concur","p_value");
      capture = _proj_prop_sstab.sstGetProp2(ctlName:+"_capture","p_value");
      if (concur) {
         flags='concur';
      }
      if (capture) {
         if (flags!='') {
            flags=flags:+'|'
         }
         flags=flags:+'capture'
      }
      return(flags','widptext)
   }

   if (wid.p_text=='') return('');
   flags=''
   concurwid = wid.p_next.p_next;
   capturewid = concurwid.p_next;
   if (concurwid.p_value) {
      flags='concur'
   }
   if (capturewid.p_value) {
      if (flags!='') {
         flags=flags:+'|'
      }
      flags=flags:+'capture'
   }
   return(flags','wid.p_text)
}
*/

// Desc:  Build the tool text line for the project file.
//
//        The tool command text has the following formats:
//
//        rebuild=concur|capture,remakevnt -!
//        newtool1=concur|capture|:New Tool 1:Menu Tool 1,newtoolcmd -u -B
//        newtool1=concur|:New Tool 1:Menu Tool 1,newtoolcmd -u -B
//        newtool1=:New Tool 1:Menu Tool 1,newtoolcmd -u -B
//        newtool1=concur|capture|hide|clear|savecurrent|changedir:New Tool 1:Menu Tool 1,newtoolcmd -u -B
//
static _str buildToolCommandText(int toolIndex)
{
   _str text;
   text = "";
   if (projectToolList[toolIndex].outputConcur) {
      text = text :+ "concur";
   }
   if (projectToolList[toolIndex].captureOutput) {
      if (text != "") {
         text = text :+ "|";
      }
      text = text :+ "capture";
   }
   if (projectToolList[toolIndex].hideIfNoCmd) {
      if (text != "") {
         text = text :+ "|";
      }
      text = text :+ "hide";
   }
   if (projectToolList[toolIndex].clearProcessBuf) {
      if (text != "") text = text :+ "|";
      text = text :+ "clear";
   }
   // explicitSave is set when the save option was loaded directly from
   // the project file or when the user explicitly selects the save option
   // toggle buttons.
   if (projectToolList[toolIndex].explicitSave) {
      if (projectToolList[toolIndex].saveOptions == saveCurrent) {
         if (text != "") text = text :+ "|";
         text = text :+ "savecurrent";
      } else if (projectToolList[toolIndex].saveOptions == saveAll) {
         if (text != "") text = text :+ "|";
         text = text :+ "saveall";
      } else if (projectToolList[toolIndex].saveOptions == saveModified) {
         if (text != "") text = text :+ "|";
         text = text :+ "savemodified";
      } else if (projectToolList[toolIndex].saveOptions == saveNone) {
         if (text != "") text = text :+ "|";
         text = text :+ "savenone";
      }
   }
   if (!projectToolList[toolIndex].changeDir) {
      if (text != "") text = text :+ "|";
      text = text :+ "nochangedir";
   }

   // This code appends another '|' at the end of the options string.
   // Not sure if we really need this. Since it does not hurt anything,
   // leave it in for possible backward compatibility.
   if (text != "") text = text :+ "|";

   text = text :+ ":" :+ projectToolList[toolIndex].name;
   _str caption;
   caption = projectToolList[toolIndex].caption;
   caption = strip(caption);
   if (caption == "") {  // no menu caption?  use the tool name
      caption = "&" :+ projectToolList[toolIndex].name;
      projectToolList[toolIndex].caption = caption;
   }
   text = text :+ ":" :+ caption;
   text = text :+ ",";
   text = text :+ projectToolList[toolIndex].cmd;
   return(text);
}

// Desc:  Check to specified tool command for modifications.
// Retn:  1 for modified, 0 for nothing modified.
static int isProjectShellCommandModified(_str ctlName, typeless & ht)
{
   int wid;
   /*
   wid = sstIsControlExists(ctlName);
   if (!wid) {
      _str widptext;
      int concur, capture;
      widptext = _proj_prop_sstab.sstGetProp2(ctlName,"p_text");

      if (!ht._indexin(ctlName)) {
         old_text='';
      } else {
         old_text=ht:[ctlName];
      }
      if (widptext != old_text) return(1);
      concur = _proj_prop_sstab.sstGetProp2(ctlName:+"_concur","p_value");
      if (ht._indexin(ctlName:+"_concur") && concur != ht:[ctlName:+"_concur"]) return(1);
      capture = _proj_prop_sstab.sstGetProp2(ctlName:+"_capture","p_value");
      if (ht._indexin(ctlName:+"_capture") && capture != ht:[ctlName:+"_capture"]) return(1);
      return(0);
   }
   */
   wid = _find_control(ctlName);
   if (!wid) {
      return(0);
   }

   int concurwid, capturewid;
   concurwid = wid.p_next.p_next;
   capturewid = concurwid.p_next;
   if (!ht._indexin(ctlName)) {
      old_text='';
   } else {
      old_text=ht:[ctlName];
   }
   if (wid.p_text != old_text) return(1);
   if (ht._indexin(ctlName:+"_concur") && concurwid.p_value != ht:[ctlName:+"_concur"]) return(1);
   if (ht._indexin(ctlName:+"_capture") && capturewid.p_value != ht:[ctlName:+"_capture"]) return(1);
   return(0);
}


static preload_files()
{
   //Dan changed for makefile support
   //status=_ini_get_section(_project_name, "FILES", ini_view_id);
   status=GetProjectFiles(_project_name, ini_view_id);
   if (status) {
      return(status);
   }
   get_view_id view_id;
   activate_view ini_view_id;
   top;
   for (;;) {
      if (down()) {
         break;
      }
      get_line line;
      activate_view view_id;
      edit(line);
      activate_view ini_view_id;
   }
   activate_view view_id;
   _delete_temp_view(ini_view_id);
}

static next_temp_name()
{
   /* Returns the name of the next temp filename.  projxxxx if arg(1)='p'
      makexxxx if arg(1)=='m' */
   zeros='0000';
   num=1;
   if (lowcase(arg(1))=='p') {
      prefix='proj';
   }else if (lowcase(arg(1))=='m') {
      prefix='make';
   }
   filename=prefix:+substr(zeros, 1, length(zeros)-length(num)):+num;
   while (file_match(filename, 1)!='') {
      filename=prefix:+substr(zeros, 1, length(zeros)-length(num)):+num;
      num++;
   }
   return(filename);
}

int _OnUpdate_project_load(CMDUI &cmdui,int target_wid,_str command)
{
    return(_OnUpdate_project_close(cmdui,target_wid,command));
}
_command void project_load()
{
   if (_project_name=='') return;
    get_view_id(orig_view_id);
   title=nls('Load Files')
   p_window_id=_mdi.p_child;
   _macro_delete_line()
   _start_buf_id=p_buf_id
   //11:45am 8/18/1997
   //Dan changed for makefile support
   //status=_ini_get_section(_project_get_filename(),"FILES",temp_view_id);
   status=GetProjectFiles(_project_get_filename(),temp_view_id);
   if (status) {
      return;
   }
   activate_view(temp_view_id);
   // Remove blank lines
   top();
   for (;;) {
      status=search('^ *$','r@');
      if (status) break;
      _delete_line();
   }
   if (p_Noflines==0) {
      _delete_temp_view(temp_view_id);
      activate_view orig_view_id
      _set_focus();_message_box(nls('No files in this project'))
      return;
   }

   top();up();
   while (!down()) {
      get_line(line);
      replace_line(' 'strip_filename(line,'p'):+"\t":+strip_filename(line,'n'));
   }
   sort_buffer(_fpos_case);
   _remove_duplicates(_fpos_case);
#if __UNIX__
   isearch_case=SL_MATCHCASE;
#else
   isearch_case=0;
#endif
   buttons=nls('&Open');
   activate_view(orig_view_id);
   result=show('_sellist_form -mdi -modal',
               title,
               isearch_case|SL_SELECTCLINE|SL_SELECTPREFIXMATCH|SL_COMBO|SL_COLWIDTH|SL_SELECTALL|SL_INVERT|SL_ALLOWMULTISELECT|SL_VIEWID|SL_DEFAULTCALLBACK,
               temp_view_id,
               buttons,
               'Load Files dialog box',        // help item name
               '',                    // font
               _project_load_callback,   // Call back function
               '',                       // Item separator for list data
               'project_load'            // Retrieve form name
              );
   if (result=='') {
      return;
   }
}
static _str _project_load_callback(reason,var result,key)
{
   _nocheck _control _sellistok,_sellist;
   orig_wid=p_window_id;

   if (reason==SL_ONINIT || reason==SL_ONSELECT) {
      ok_wid=_sellistok;
      if (_sellist.p_Nofselected) {
         if (!ok_wid.p_enabled) {
             ok_wid.p_enabled=1
         }
      } else {
         ok_wid.p_enabled=0
      }
      return('');
   }

   if (reason==SL_ONDEFAULT) {  // Enter key
      if (!_sellistok.p_enabled) {
         return('');
      }
      sellist_wid=_control _sellist;
      p_window_id=sellist_wid;
      top();up();
      done=0;
      _macro('m',_macro('s'));
      for (;;) {
         down();
         if (rc) break;
         get_line(line);
         while (!_lbisline_selected()) {
            if(_delete_line()) {
               done=1;
               break;
            }
         }
         if (done ) break;
         parse _lbget_text() with filename "\t" path;
         filename=path:+filename;
         status=edit('+q 'maybe_quote_filename(filename),EDIT_DEFAULT_FLAGS);
         _macro_call('edit',maybe_quote_filename(filename));
         p_window_id=sellist_wid;
      }
      p_window_id=orig_wid;
      return(1);
   }
   user_button=reason==SL_ONUSERBUTTON;
   if (user_button) {
      return('');
   }
   return('');
}

defeventtab _project_form;
_browsedir.lbutton_up()
{
   wid=p_window_id;
   result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
   if( result=='' ) {
      return('');
   }
   p_window_id=wid.p_prev;
   p_text=result;
   end_line();
   _set_focus();
   return('');
}
_browsedirconcat.lbutton_up()
{
   wid=p_window_id;
   result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
   if( result=='' ) {
      return('');
   }
   p_window_id=wid.p_prev;
   if (p_text=="") {
      p_text = result;
   } else {
      p_text = p_text :+ ";" :+ result;
   }
   end_line();
   _set_focus();
   return('');
}
_browsefileconcat.lbutton_up()
{
   wid=p_window_id;
   result=_OpenDialog('-modal '_stdform('_open_form'),
                      'Choose File',        // Dialog Box Title
                      '',                   // Initial Wild Cards
                      "Tag Files (*.slk;*.vtg)", // File Type List
                      OFN_FILEMUSTEXIST     // Flags
                      );
   if (result=='') {
      return('');
   }
   p_window_id=wid.p_prev;
   if (p_text=="") {
      p_text = result;
   } else {
      p_text = p_text :+ ";" :+ result;
   }
   end_line();
   _set_focus();
   return('');
}
_browserefs.lbutton_up()
{
   wid=p_window_id;
   result=show('-modal '_stdform('_open_form'),
                      'Choose File',        // Dialog Box Title
                      '',                   // Initial Wild Cards
                      "References Files (*.bsc;*.vtr)", // File Type List
                      OFN_FILEMUSTEXIST     // Flags
                      );
   if (result=='') {
      return('');
   }
   p_window_id=wid.p_prev;
   p_text = result;
   end_line();
   _set_focus();
   return('');
}

//------------------------------------------------------------------------------
defeventtab _tbproject_form;

void _tbproject_form.'C-A'-'C-Z',F2-F4,f6-F12,C_F12()
{
   _smart_toolbar_hotkey();
}
void _tbproject_form.'C-W',A_UP,A_LEFT,A_RIGHT()
{
   if (!_no_child_windows()) {
      p_window_id=_mdi.p_child;
      _set_focus();
   }
}
static void refresh_file_list()
{
   path=_opendir_list._dlpath();
   //_openfile_list._flfilename(result,'',1); // Refresh File list

   parse _openfile_list._flfilename() with ';' wildcards;
   //wildcards=_openfn.p_text;
   /*if (!iswildcard(wildcards)) {
      //wildcards=_open_get_wildcards();
      wildcards=ALLFILES_RE;
   } */
   _openfile_list._flfilename(wildcards,path,1)
}
static void refresh_dir_list()
{
   _opendir_list._dlpath(_opendir_list._dlpath(),1);
}
void _openfile_list.'F5'()
{
   refresh_file_list();
   refresh_dir_list();
   // We should update the drive list too. Maybe next release.
}
void _opendir_list.'F5'()
{
   refresh_file_list();
   refresh_dir_list();
   // We should update the drive list too. Maybe next release.
}
static int gignore_change;
void _proj_tooltab_tree.on_create()
{
   _str projectName;
   if (arg() >= 1) {
      projectName = arg(1);
   } else {
      projectName = _project_name;
   }
   _col_width(0, 5000);  // Just init to some value

   // Add files:
   toolbarUpdateFilterList(projectName);

   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
      orig_active_tab=_proj_toolbar_sstab.p_ActiveTab;
      gignore_change=1;
      _proj_toolbar_sstab.p_ActiveTab=PROJTOOLTAB_FILES;
      _proj_toolbar_sstab.p_ActiveEnabled=0;
      _proj_toolbar_sstab.p_ActiveTab=PROJTOOLTAB_OPEN;
      _proj_toolbar_sstab.p_ActiveEnabled=0;

      if (orig_active_tab==PROJTOOLTAB_FILES || orig_active_tab==PROJTOOLTAB_OPEN) {
         _proj_toolbar_sstab.p_ActiveTab=PROJTOOLTAB_PROCS;
      } else {
         _proj_toolbar_sstab.p_ActiveTab=orig_active_tab;
      }
      gignore_change=0;
   }
}
static void toolbarSaveExpansion(_str project_name)
{
   //say( "toolbarSaveExpansion "project_name );
   formid = _find_object("_tbproject_form","N")
   if (!formid) {
      return;
   }

   // Build a list of level 1 items expansion mode:
   _str expansionList;
   int childL1;
   childL1 = formid._proj_tooltab_tree._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   expansionList = "";
   while (childL1 != -1) {
      int childrenShown, bm1, bm2;
      formid._proj_tooltab_tree._TreeGetInfo(childL1, childrenShown, bm1, bm2);
      if (expansionList == "") {
         expansionList = childrenShown;
      } else {
         expansionList = expansionList :+ " " :+ childrenShown;
      }
      childL1 = formid._proj_tooltab_tree._TreeGetNextSiblingIndex(childL1);
   }
   //say( "expansionList="expansionList );
   _ini_set_value(project_name,"COMPILER", "FILTEREXPANSION", expansionList);
}
void _proj_tooltab_tree.on_destroy()
{
   toolbarSaveExpansion(_project_name);
}
void _openfile_list.'ENTER',lbutton_double_click()
{
   if (p_Nofselected>0) {
      orig_text=_openfn.p_text;
      _openfn.p_text="";
      result=_open_get_result();
      _openfn.p_text=orig_text;
      if (result!='') {
         edit(result,EDIT_DEFAULT_FLAGS);
      }
      return;
   }

   _str line, path;
   _str filename;
   line = _lbget_text();
   parse _dlpath() with path ';' rest;
   if (path!='' && last_char(path) != FILESEP) {
      path = path :+ FILESEP;
   }
   filename = path :+ line;
   p_window_id = _mdi._edit_window();
   edit(maybe_quote_filename(filename),EDIT_DEFAULT_FLAGS);
}
void _openfile_list.on_change(reason)
{
   if (reason==CHANGE_FILENAME) {
      parse _flfilename() with ';'text
      _openfn.set_command text,1,length(text)+1
      return;
   }
}

void _openfile_list.rbutton_down()
{
   //Stole this code from _ul2_listbox.lbutton_down(), for the MS_NONE case
   //Changed it so I liked the way it select things
   linenum=p_line;
   nochange_event=_lbisline_selected();
   if (p_Nofselected==1) {
      _lbdeselect_all();
   }
   if (p_scroll_left_edge>=0) {
      nochange_event=0;
      parse _scroll_page() with line_pos down_count;
      goto_point(line_pos);
      down(down_count);
      set_scroll_pos(p_scroll_left_edge,0);
      p_scroll_left_edge= -1;
   }
   if (_on_line0()) return;
   if (mou_last_y()>p_font_height*p_char_height) {
      scroll_down();
   }
   p_cursor_y=mou_last_y();
   p_cursor_x=p_left_edge+p_windent_x;
   if (!p_Nofselected) {
      _lbselect_line();
   }
   if (p_line!=linenum || !nochange_event || !_lbisline_selected()) {
      call_event(CHANGE_SELECTED,p_window_id,ON_CHANGE,'');
   }
}

void _openfile_list.rbutton_up()
{
   index=find_index("_opentb_menu",oi2type(OI_MENU));
   menu_handle=_mdi._menu_load(index,'P');
   mou_get_xy(x,y);
   status=_menu_show(menu_handle,VPM_RIGHTBUTTON,x-1,y-1);
}

static _str GetCurrentOpenTBFilename()
{
   _str path=_opendir_list._dlpath();
   _str filename=path:+_lbget_text();
   return(maybe_quote_filename(filename));
}

_command void OpenTBMenuOpen()
{
   mou_hour_glass(1);
   int ff=1;
   for (;;) {
      status=_lbfind_selected(ff);ff=0;
      if (status) break;
      _str filename=GetCurrentOpenTBFilename();
      _mdi.edit(filename);
   }
   _lbdeselect_all();
   mou_hour_glass(0);
}

_command void OpenTBMenuExecute()
{
   mou_hour_glass(1);
   int ff=1;
   boolean SendErrMessage=false;
   for (;;) {
      status=_lbfind_selected(ff);ff=0;
      if (status) break;
      _str filename=GetCurrentOpenTBFilename();
      boolean isexe=false;
#if __UNIX__
      attrs=file_list_field(filename,DIR_ATTR_COL,DIR_ATTR_WIDTH);
      isexe=pos('x',attrs)!=0;
#else
      ext=get_extension(filename);
      isexe=file_eq(ext,'bat')||file_eq(ext,'exe')||file_eq(ext,'cmd')||file_eq(ext,'com');
#endif
      if (isexe) {
         shell(filename,'A');
      }else{
         SendErrMessage=true;
      }
   }
   if (SendErrMessage) {
      _str msg='';
#if __UNIX__
      msg=nls('At least one file did not have execute permissions');
#else
      msg=nls('At least one file was not an executable');
#endif
      _message_box(msg);
   }
   _lbdeselect_all();
   mou_hour_glass(0);
}

_command void OpenTBMenuPrint()
{
   int ff=1;
   mou_hour_glass(1);
   if (_no_child_windows()) {
      bid= -1;
   } else {
      bid=_mdi.p_child.p_buf_id;
   }
   for (;;) {
      status=_lbfind_selected(ff);ff=0;
      if (status) break;
      _str filename=GetCurrentOpenTBFilename();
      boolean inmem=true;
      status=_mdi.edit('+q +b 'filename);
      if (status) {
         inmem=false;
         status=_mdi.edit(filename);
      }
      if (!status) {
         _mdi.p_child.print();
         if (!inmem) {
            _mdi.p_child.quit();
         }
      }
   }
   if (bid>=0) {
      _mdi.p_child.edit('+bi 'bid);
   }
   _lbdeselect_all();
   mou_hour_glass(0);
}

static int _myisdirectory(_str path)
{
   if (isdirectory(path) && path!='') {
      return(0);
   }
   _message_box(nls("'%s' is not a valid path",path));
   return(1);
}

_command void OpenTBMenuCopyFile()
{
   bid=_mdi.p_child.p_buf_id;
   int ff=1;
   boolean LastPrompt=false;
   _str DestPath='';
   _str SourceFilename='';
   for (;;) {
      status=_lbfind_selected(ff);ff=0;
      if (status) break;

      SourceFilename=_opendir_list._dlpath():+_lbget_text();

      if (!LastPrompt) {
         status=show('-modal _textbox_form',
                     'Copy Files to Directory',
                     TB_RETRIEVE_INIT, //Flags
                     '',//width
                     '',//help item
                     "OK,Apply to &All,Cancel:_cancel\tCopy file '"SourceFilename"' to",//Button List
                     'OpenTBMenuCopyFile',//retrieve name
                     'Directory:');
         if (status=='') return;
         mou_hour_glass(1);
         DestPath=_param1;
         if (status==2 && isdirectory(DestPath) && DestPath!='') {
            LastPrompt=true;
         }
         if (DestPath=='') {
            mou_hour_glass(0);
            return;
         }
         if (last_char(DestPath)!=FILESEP && isdirectory(DestPath)) {
            DestPath=DestPath:+FILESEP;
         }
      }

      _str JustDir=strip_filename(DestPath,'N');
      _str JustName=strip_filename(DestPath,'P');
      boolean HaveDir=JustDir!='';
      boolean HaveName=JustName!='';
      _str DestName='';
      if (HaveDir && HaveName) {
         DestName=DestPath;
      }else if (!HaveDir && HaveName) {
         DestName=strip_filename(SourceFilename,'N');
         DestName=DestName:+JustName;
      }else if (HaveDir && !HaveName) {
         DestName=JustDir;
         if (last_char(DestName)!=FILESEP) DestName=DestName:+FILESEP;
         DestName=DestName:+strip_filename(SourceFilename,'P');
      }/*else if (!HaveDir && !HaveName) {
         //This cannot happen
      }*/

      status=copy_file(SourceFilename,DestName);
      if (status) {
         _message_box(nls("Could not copy file '%s' to '%s'\n\n%s",SourceFilename,DestName,get_message(status)));
         return;
      }
      _lbdeselect_line();
   }
   OpenTBMenuRefresh();
   mou_hour_glass(0);
}

_command void OpenTBMenuRenameFile()
{
   int ff=1;
   boolean LastPrompt=false;
   _str DestPath='';
   _str SourceFilename='';
   for (;;) {
      int status=_lbfind_selected(ff);ff=0;
      if (status) break;

      SourceFilename=_opendir_list._dlpath():+_lbget_text();

      if (!LastPrompt) {
         status=show('-modal _textbox_form',
                     'Move/Rename Files',
                     TB_RETRIEVE_INIT, //Flags
                     '',//width
                     '',//help item
                     "OK,Apply to &All,Cancel:_cancel\tMove/Rename file '"SourceFilename"' to",//Button List
                     'OpenTBMenuRenameFile',//retrieve name
                     'Directory/Filename:');
         if (status=='') return;
         mou_hour_glass(1);
         DestPath=_param1;
         if (status==2 && isdirectory(DestPath) && DestPath!='') {
            LastPrompt=true;
         }
         if (DestPath=='') {
            return;
         }
         _str JustDir=strip_filename(DestPath,'N');
         _str JustName=strip_filename(DestPath,'P');
         boolean HaveDir=JustDir!='';
         boolean HaveName=JustName!='';
         _str DestName;
         if (HaveDir && HaveName) {
            DestName=DestPath;
         }else if (!HaveDir && HaveName) {
            DestName=strip_filename(SourceFilename,'N');
            DestName=DestName:+JustName;
         }else if (HaveDir && !HaveName) {
            DestName=JustDir;
            if (last_char(DestName)!=FILESEP) DestName=DestName:+FILESEP;
            DestName=DestName:+strip_filename(SourceFilename,'P');
         }/*else if (!HaveDir && !HaveName) {
            //This cannot happen
         }*/

         status=_file_move(DestName,SourceFilename);
         if (status) {
            _message_box(nls("Could not move file '%s' to '%s'",SourceFilename,DestPath));
            return;
         }
      }

      _lbdeselect_line();
   }
   OpenTBMenuRefresh();
   mou_hour_glass(0);
}

_command void OpenTBMenuRefresh(boolean ProjectUpdate=false)
{
   _opendir_list._dlpath('',1);
   _openfile_list._flfilename('','',1);
   if (ProjectUpdate) {
      toolbarUpdateFilterList(_project_name);
   }
}

_command void OpenTBMenuTouch()
{
   int ff=1;
   boolean LastPrompt=false;
   _str DestPath='';
   _str SourceFilename='';
   for (;;) {
      status=_lbfind_selected(ff);ff=0;
      if (status) break;

      CurFilename=_opendir_list._dlpath():+_lbget_text();

      //NEED TOUCH BUILT IN HERE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

      status=_open_temp_view(CurFilename,temp_view_id,orig_view_id);
      if (!status) {
         mou_hour_glass(1);
         _save_file('+o');
         p_view_id=orig_view_id;
         _delete_temp_view(temp_view_id);
         mou_hour_glass(0);
      }
      _lbdeselect_line();
   }
   OpenTBMenuRefresh();
   mou_hour_glass(0);
}

_command void OpenTBMenuDeleteFile()
{
   int ff=1;
   boolean LastPrompt=false;
   boolean LastPromptRemoveProject=false;
   boolean LastPromptRemoveVC=false;
   _str DestPath='';
   _str SourceFilename='';
   boolean MultiFiles=p_Nofselected>1;
   for (;;) {
      int status=_lbfind_selected(ff);ff=0;
      if (status) break;

      CurFilename=_opendir_list._dlpath():+_lbget_text();

      _str buttons;
      if (MultiFiles) {
         buttons="Yes,Yes to &All,No,Cancel:_cancel\tDelete file '"CurFilename"'?";
      }else{
         buttons="Yes,No,Cancel:_cancel\tDelete file '"CurFilename"'?";
      }
      if (!LastPrompt) {
         status=show('-modal _textbox_form',
                     'Delete File(s)',
                     TB_RETRIEVE_INIT, //Flags
                     '',//width
                     '',//help item
                     buttons,
                     'OpenTBMenuDeleteFile');
         if (status=='') return;
         mou_hour_glass(1);
         if (status==2 && MultiFiles) {
            LastPrompt=true;
         }
      }

      boolean NoDelete;
      NoDelete=(MultiFiles && status==3) || (!MultiFiles && status==2);

      if (!NoDelete) {
         status=delete_file(CurFilename);
         if (status) {
            result=_message_box(nls("Could not delete file '%s'\n%s\n\nContinue?",CurFilename,get_message(status)),'',MB_YESNOCANCEL|MB_ICONQUESTION);
            if (result!=IDYES) break;
         }else{
            if (FileInProject(CurFilename)) {
               status=RemoveFromProjectAndVC(CurFilename,LastPromptRemoveProject,LastPromptRemoveVC);
               if (status==COMMAND_CANCELLED_RC) {
                  return;
               }
            }
         }
      }
      _lbdeselect_line();
   }
   OpenTBMenuRefresh();
   mou_hour_glass(0);
}

static boolean FileInProject(_str Filename)
{
   if (_project_name=='') {
      return(0);
   }
   orig_view_id=p_view_id;
   status=_ini_get_section(_project_name,"Files",temp_view_id);
   if (status) return(0);
   p_view_id=temp_view_id;
   if (!status) {
      top();up();
      status=search('^'_escape_re_chars(Filename)'$','@r'_fpos_case);
   }
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   return(!status);
}

_openfile_list.del()
{
   OpenTBMenuDeleteFile();
}

_command void OpenTBMenuCheckout()
{
   int ff=1;
   boolean LastPrompt=false;
   _str DestPath='';
   _str SourceFilename='';
   for (;;) {
      status=_lbfind_selected(ff);ff=0;
      if (status) break;

      CurFilename=_opendir_list._dlpath():+_lbget_text();

      orig_view_id=p_view_id;
      vccheckout(CurFilename);
      p_view_id=orig_view_id;
      _lbdeselect_line();
   }
   OpenTBMenuRefresh();
   mou_hour_glass(0);
}

_command void OpenTBMenuCheckin()
{
   int ff=1;
   boolean LastPrompt=false;
   _str DestPath='';
   _str SourceFilename='';
   for (;;) {
      status=_lbfind_selected(ff);ff=0;
      if (status) break;

      CurFilename=_opendir_list._dlpath():+_lbget_text();

      orig_view_id=p_view_id;
      status=vccheckin(CurFilename);
      p_view_id=orig_view_id;

      _lbdeselect_line();
   }
   OpenTBMenuRefresh();
   mou_hour_glass(0);
}

_command void OpenTBMenuAttr()
{
   int ff=1;
   boolean LastPrompt=false;
   _str DestPath='';
   _str SourceFilename='';
   for (;;) {
      status=_lbfind_selected(ff);ff=0;
      if (status) break;

      CurFilename=_opendir_list._dlpath():+_lbget_text();

   #if __UNIX__
      result=show('-modal _unixfmattr_form',CurFilename,'',nls("?Sets the Read and Write permissions of the selected files."));
   #else
      result=show('-modal _fmattr_form',CurFilename,'',nls("?Sets the Read Only, Hidden, System, and Archive attributes of the selected files."));
   #endif
      if (result=='') return;
      parse result with . plus minus
      if (_param2=='+') plus='';
      if (_param3=='-') minus='';
      result=maybe_quote_filename(_param2' '_param3);
      _macro('m',_macro('s'));
      chmod(result' 'CurFilename);

      _lbdeselect_line();
   }
   OpenTBMenuRefresh();
   mou_hour_glass(0);
}

_command void OpenTBMenuAddToProject()
{
   boolean LastPrompt=false;
   _str DestPath='';
   _str SourceFilename='';
   if (_project_name=='') {
      _message_box(nls("No project open"));
      return;
   }
   orig_view_id=p_view_id;
   status=_ini_get_section(_project_name,"FILES",temp_view_id);
   if (status) {
      _message_box(nls("Could not open file '%s'\n%s",_project_name,get_message(status)));
      return;
   }
   int ff=1;
   _str NewFiles[];
   for (;;) {
      status=_lbfind_selected(ff);ff=0;
      if (status) break;

      CurFilename=_opendir_list._dlpath():+_lbget_text();

      p_view_id=temp_view_id;
      top();up();
      if (search('^'_escape_re_chars(CurFilename)'$','@r'_fpos_case)) {
         insert_line(CurFilename);
         NewFiles[NewFiles._length()]=CurFilename;
      }
      p_view_id=orig_view_id;
      _lbdeselect_line();
   }
   status=_ini_put_section(_project_name, "FILES", temp_view_id);
   if (status) {
      _message_box(nls("Could not update project file '%s'\n%s",_project_name,get_message(status)));
   }
   MaybeAddFilesToVC(NewFiles);
   OpenTBMenuRefresh(1);
   toolbarUpdateFilterList(_project_name);
   mou_hour_glass(0);
}

_openfn.on_drop_down(reason)
{
   switch (reason) {
   case DROP_DOWN:
      _openfn.p_user=p_text;
      break;
   case DROP_UP:
      drive=p_cb_list_box._lbget_seltext();
      old_text=_openfn.p_user;
      if (drive!='' && drive!=old_text) {
         _open_get_result();
      }
   }
}
/*
   The ENTER causes VSE to reapply the wildcards in the
   _openfn text box.
*/
void _openfn.'ENTER'()
{
   if (p_cb_list_box.p_visible) {
      call_event(p_window_id,last_event(),'2');
      return;
   }
#if __UNIX__
   message("Applying filter to files in project toolbar...");
#endif
   result=_open_get_result();
#if __UNIX__
   clear_message();
#endif
   if (result!='') {
      edit(result,EDIT_DEFAULT_FLAGS);
   }
}
/*
    This function is called by the cd command. Here
    we update the current directory.
*/
void _cd_tbproject()
{
   wid=_find_object('_tbproject_form','n')
   if (wid) {
      // Update directory listing only if tab Open tab is active:
      _nocheck _control _proj_toolbar_sstab;
      if (wid._proj_toolbar_sstab.p_ActiveTab != PROJTOOLTAB_OPEN) {
         return;
      }
      mou_hour_glass(1);
      // I think I would rather not lose the users message
#if __UNIX__
      _str transientCurrentDir;
      transientCurrentDir = getcwd();
      if (last_char(transientCurrentDir) != FILESEP) {
         transientCurrentDir = transientCurrentDir :+ FILESEP;
      }
      int labelwid;
      labelwid = wid._find_control('_filenameLabel');
      if (labelwid.p_user != "" &&
          labelwid.p_user == transientCurrentDir) {
         //messageNwait("Skipping tb cd");
         return;
      }
      message("Updating project toolbar's directory list...");
#endif
      orig_wid=p_window_id;
      p_window_id=wid;
      //_openfile_list._flfilename(result,'',1); // Refresh File list
      _opendir_list._dlpath(getcwd());
      _opendrives._dvldrive('');
      p_window_id=orig_wid;
      mou_hour_glass(0);
   }
}
void _opendir_list.on_change(reason)
{
   switch (reason) {
   case CHANGE_PATH:
   {
      path=_dlpath();
#if __UNIX__
      // Remember the current directory:
      clear_message();
      int wid;
      wid=_find_object('_tbproject_form','n')
      int labelwid;
      labelwid=wid._find_control('_filenameLabel')
      labelwid.p_user = path;
#endif
      _set_opencd(path);
      parse _openfile_list._flfilename() with ';' wildcards;
      //wildcards=_openfn.p_text;
      if (!iswildcard(wildcards)) {
         //wildcards=_open_get_wildcards();
         wildcards=ALLFILES_RE;
      }
      _openfile_list._flfilename(wildcards,path)
      // Don't want the combo box text selected
      _openfn._set_sel(1);
   }
   }
}
static void projecttbOptionalEdit(_str msg, _str name, _str fullPath)
{
   int idval;
   idval = _message_box(msg :+ name :+ ".\n\nEdit file in Visual SlickEdit?",
            "", MB_YESNO|MB_ICONQUESTION);
   if (idval == IDNO) return;
   edit(maybe_quote_filename(fullPath),EDIT_DEFAULT_FLAGS);
   return;
}

// Desc: If the application command is a VSE _command, use it. Otherwise
//       look for the program in the path and use it.
static void projecttbRunAppCommand(_str appCommand, _str fullPath)
{
   // Build the actual command:
   _str command, temp, pgmname;
   int status;
   command = _parse_project_command(appCommand, fullPath, _project_name, "");
   temp = command;
   pgmname = parse_file(temp);

   // If there is a VSE command, use it. Otherwise look for program in the
   // path and, if found, use it instead.
   index = find_index(pgmname, COMMAND_TYPE);
   if (index) {
      status = execute(command, '');
   } else {
      temp = slick_path_search(pgmname, 'p');
      if (temp=='') {
         message2 = ".\n\nFrom the Project menu, select \"Properties...\" and select the Filter tab to change filter command."
         _message_box(nls("Program %s not found",pgmname)message2)
      }
      //messageNwait("projecttbRunAppCommand command="command);
      status = shell(command,'ap')
   }
}

// Desc: Get the filter application command and use file association that
//       correspond to the filter name.
// Retn: 0 found item, 1 not found
static int projecttbFilterInfoFromTreeIndex(int parentIndex, _str & appCommand
                                            ,int & assocType)
{
   // Get a list of filter names and their attributes:
   _str nameList[];
   _str patternList[];
   _str appCommandList[];
   int assocTypeList[];
   appCommand = "";
   assocType = 0;
   if (_project_name == "") return(1);
   getFilterList(_project_name, nameList, patternList, assocTypeList, appCommandList);

   // Get the filter name from tree:
   _str filterName = _proj_tooltab_tree._TreeGetCaption(parentIndex);

   // Match the filter name:
   int iiCount = nameList._length();
   int i;
   for (i=0; i<iiCount; i++) {
      if (!stricmp(nameList[i],filterName)) {
         appCommand = appCommandList[i];
         assocType = assocTypeList[i];
         //say("projecttbFilterInfoFromTreeIndex appCommand="appCommand" assocType="assocType);
         return(0);
      }
   }
   return(1);
}

static void projecttbMaybeEditFile(int index, _str name, _str fullPath)
{
   // Determine if file type association needs to be applied
   // to this file:
   int parentIndex, assocType;
   _str appCommand;
   parentIndex = _proj_tooltab_tree._TreeGetParentIndex(index);
   projecttbFilterInfoFromTreeIndex(parentIndex, appCommand, assocType);

#if __UNIX__
   // On Unix, we don't have file type association. This should be false
   // all the time on Unix anyway. This is only a precaution in case
   // something slips thru the crack.
   assocType = 0;
#endif
   if (substr(fullPath,1,1)=='*') {
      fullPath=substr(fullPath,2);
   }

   // If file association is not used, check the application
   // command and use it instead.
   if (!assocType) {
      if (appCommand != "") {
         projecttbRunAppCommand(appCommand, fullPath);
      } else {
         edit(maybe_quote_filename(fullPath),EDIT_DEFAULT_FLAGS);
      }
      return;
   }

   #if 1
   if (substr(machine(),1,2)=='NT') {
      //fullPath='e:\vslick30\rt\slick\xxx.bmp';
      status=NTShellExecute("open",fullPath,"","");
      if (status<=32) {
         switch (status) {
         case 0:
            msg='Out of memory/resources';
            break;
         case 1:
            // I seem to get this code if there is no association in the registry
            msg='Possible missing association';
            break;
         case 2:
            msg='File not found';
            break;
         case 3:
            msg='Path not found';
            break;
         case 11:
            msg='Bad format';
            break;
         case 26:
            msg='Sharing violation';
            break;
         case 27:
            msg='Invalid/incomplete association';
            break;
         case 28:
            msg='DDE timed out';
            break;
         case 29:
            msg='DDE failed';
            break;
         case 30:
            msg='DDE busy';
            break;
         case 31:
            msg='No association';
            break;
         default:
            msg='Unknown error';
         }
         if( status==2 || status==3 ) {
            // File not found OR Path not found
            _message_box(msg:+"\n\nUnable to open ":+fullPath);
         } else {
            projecttbOptionalEdit(msg:+"\n\nUnable to open ", fullPath, fullPath);
         }
         //projecttbOptionalEdit("Unable to open ", fullPath, fullPath);
      }
   } else {
      edit(maybe_quote_filename(fullPath),EDIT_DEFAULT_FLAGS);
      return;
   }
   #else
   // Look up the file association table and run the proper program:
   // Currently only valid for Win95 and NT.  For other platforms,
   // just edit the file in the editor.
   if ((_win32s() != 2) && (substr(machine(),1,2) != "NT")) {
      edit(maybe_quote_filename(fullPath),EDIT_DEFAULT_FLAGS);
      return;
   }

   // Look up registry for associated application:
   _str ext = lowcase(get_extension(name));
   if (ext == "") {
      edit(maybe_quote_filename(fullPath),EDIT_DEFAULT_FLAGS);
      return;
   }
   _str value;
   _str regKey;
   regKey = "SOFTWARE\\Classes\\." :+ ext;
   value = _ntRegQueryValue(HKEY_LOCAL_MACHINE, regKey,"");
   if (value == "") {
      projecttbOptionalEdit("Unable to determine associated application for file ",
               name, fullPath);
      return;
   }
   _str appExe;
   regKey = "SOFTWARE\\Classes\\" :+ value :+ "\\shell\\open\\command";
   appExe = _ntRegQueryValue(HKEY_LOCAL_MACHINE, regKey, "");
   if (appExe == "") {
      projecttbOptionalEdit("Unable to locate associated application for file ",
               name, fullPath);
      return;
   }
   //say( "appExe="appExe );
   _str exeCmd;
   if (parseExeAndFileCommand(appExe, fullPath, exeCmd)) {
      projecttbOptionalEdit("Unable to execute associated application for file ",
               name, fullPath);
      return;
   }
   //say( "exeCmd="exeCmd );
   ec = shell( exeCmd, 'AN' );
   if (ec) {
      projecttbOptionalEdit("Unable to execute ", exeCmd, fullPath);
   }
   #endif
}
void _proj_tooltab_tree.on_change(reason)
{
   int index;
   index = arg(2);
   switch (reason) {
   case CHANGE_LEAF_ENTER:
   case CHANGE_COLLAPSED:
      if (_TreeGetDepth(index) == 2) {
         _str caption;
         caption = _TreeGetCaption(index);
         parse caption with name "\t" fullPath;
         projecttbMaybeEditFile(index, name, fullPath);
         return;
      }
      break;
   }
}
static int find_caption(int menu_index,_str menu_text)
{
   child=menu_index.p_child;
   if (child) {
      firstchild=child;
      for (;;) {
         item_text=stranslate(child.p_caption,'','&');
         if (!stricmp(item_text,menu_text)) {
            return(child);
         }
         child=child.p_next;
         if (child==firstchild) {
            break;
         }
      }
   }
   return(0);
}
// Retn:  0 for OK, 1 for non-file item, -1 for no project toolbar (error)
static int getCurrentTreeFile(int & treeWid, int & currIndex,
         _str & name, _str & fullpath)
{
   int formWid;
   treeWid = _find_object("_tbproject_form._proj_tooltab_tree");
   currIndex = treeWid._TreeCurIndex();
   _str caption;
   caption = treeWid._TreeGetCaption(currIndex);
   parse caption with name1 "\t" fullPath1;
   if (substr(name1,1,1)=='*') name1=substr(name1,2);
   if (substr(fullPath1,1,1)=='*') fullPath1=substr(fullPath1,2);
   name = name1;
   fullpath = fullPath1;
   if ((currIndex == TREE_ROOT_INDEX) || (fullpath == "")) {
      return(1);
   }
   return(0);
}
_command projecttbEditFile()
{
   int treeWid, currIndex;
   _str name, fullPath;
   if (getCurrentTreeFile(treeWid, currIndex, name, fullPath)) {
      return(0);
   }
   projecttbMaybeEditFile(currIndex, name, fullPath);
}
int _OnUpdate_projecttbCheckin(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdate_vccheckin(cmdui,target_wid,command));
}
_command projecttbCheckin()
{
   int treeWid, currIndex;
   _str name, fullPath;
   if (getCurrentTreeFile(treeWid, currIndex, name, fullPath)) {
      return(0);
   }
   //checkin("", fullPath);
   vccheckin(fullPath);
}

int _OnUpdate_projecttbCheckout(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdate_vccheckout(cmdui,target_wid,command));
}
_command projecttbCheckout()
{
   int treeWid, currIndex;
   _str name, fullPath;
   if (getCurrentTreeFile(treeWid, currIndex, name, fullPath)) {
      return(0);
   }
   //checkout("", fullPath);
   vccheckout(fullPath);
}
_command projecttbCompile()
{
   int treeWid, currIndex;
   _str name, fullPath;
   if (getCurrentTreeFile(treeWid, currIndex, name, fullPath)) {
      return(0);
   }
   project_compile(fullPath);
}
_command void projecttbAddToProject()
{
   if (_project_name=="") {
      return;
   }
   _macro_delete_line();
   old_delay_filelist=def_delay_filelist;
   def_delay_filelist=0;
   result=show('-mdi -modal _project_form',
        '',
        _last_wildcards,      // Initial wildcards
        //'*.c;*.h',
        def_file_types,
        OFN_ALLOWMULTISELECT|((def_delay_filelist)?OFN_DELAYFILELIST:0)|SL_INVERT,
        '',      // Default extension
        '',      // Initial filename
        '',      // Initial directory
        '',
        '',
        _project_name,/*This is the name of the project to show source files for*/
        0        // Active Files tab
        );
   def_delay_filelist=old_delay_filelist;
}
/*
    FileList is a spaced delimited list of double quoted
    strings.
*/
int project_add_filelist(_str project_filename,_str FileList)
{
   TagFilename=strip_filename(_project_name,'E'):+TAG_FILE_EXT;
   return(tag_add_filelist(TagFilename,FileList));
}
int project_remove_filelist(_str project_filename,_str FileList)
{
   TagFilename=strip_filename(_project_name,'E'):+TAG_FILE_EXT;
   return(tag_remove_filelist(TagFilename,FileList));
}
_command void projecttbRemoveFromProject()
{
   int treeWid, currIndex;
   _str name, fullPath;
   if (getCurrentTreeFile(treeWid, currIndex, name, fullPath)) {
      return;
   }

   if (project_is_associated_file(_project_name,fullPath)) {
      status=_ini_get_value(_project_name,'ASSOCIATION','makefiletype',makefiletype,'');
      if (status) {
         makefiletype='';
      }
      switch (makefiletype) {
      case 'Microsoft Visual C++':
         _message_box(nls("Can not remove associated file.  Remove this file from your project in Visual C++ and invoke the Close Workspace menu item."));
         break;
      case 'Borland C++':
         _message_box(nls("Can not remove associated file.  Remove this file from your project in Borland C++ and regenerate your makefile."));
         break;
      default:
         _message_box(nls("Can not remove associated file"));
         break;
      }
      return;
   }

   RemoveFromProjectAndVC(fullPath);
}

static int RemoveFromProjectAndVC(_str fullPath,
                                   boolean &LastPromptRemove=false,
                                   boolean &LastPromptVC=false)
{
   status=0;
   if (!LastPromptRemove) {
      buttons="Yes,Yes to &All,No,Cancel:_cancel\tRemove file '"fullPath"' from project?";
      status=show('-modal _textbox_form',
                  'Remove Files From Project',
                  TB_RETRIEVE_INIT, //Flags
                  '',//width
                  '',//help item
                  buttons,
                  '');
      if (status=='') {
         return(COMMAND_CANCELLED_RC);
      }
      if (status==2) {
         LastPromptRemove=true;
      }
   }
   boolean NoRemove=status==3;

   if (!NoRemove) {
      project_remove_filelist(_project_name,maybe_quote_filename(fullPath));
   }
   if ( (machine()=='NT386' && _isscc() && _SCCProjectIsOpen() ) ||
        _VCSCommandIsValid(VCS_REMOVE) ) {
      int status=0;
      if (!LastPromptVC) {
         buttons="Yes,Yes to &All,No,Cancel:_cancel\tRemove file '"fullPath"' from version control?";
         status=show('-modal _textbox_form',
                     'Remove Files From Version Control',
                     TB_RETRIEVE_INIT, //Flags
                     '',//width
                     '',//help item
                     buttons,
                     '');
         if (status=='') {
            return(COMMAND_CANCELLED_RC);
         }
         if (status==2) {
            LastPromptVC=true;
         }
      }
      if (LastPromptVC || status==1) {
         if (_isscc(def_vc_system) && machine()=='NT386') {
            Files[0]=fullPath;
            vsSccRemove(Files,'');
         }else{
            int orig_view_id=_create_temp_view(temp_view_id);
            p_view_id=orig_view_id;
            int status=_misc_cl_vc_command(VCS_REMOVE,temp_view_id,fullPath,def_vc_system,0);
            if (status) {
               show('-modal _vc_error_form',temp_view_id);
            }
         }
      }
   }
   return(0);
}

_command projecttbRetagFile()
{
   int treeWid, currIndex;
   _str name, fullPath;
   if (getCurrentTreeFile(treeWid, currIndex, name, fullPath)) {
      return(0);
   }
   inmem=1;
   status=_open_temp_view(fullPath,temp_view_id,orig_view_id,'+b');
   if (status) {
      inmem=0;
      status=_open_temp_view(fullPath,temp_view_id,orig_view_id);
      if (!status) select_edit_mode();
   }
   if (status) return(status);
   FileList=project_tags_filename();
   DoneList='';
   ff=1;
   for (;;) {
      CurTagFilename=next_tag_file2(FileList,false);
      if (CurTagFilename=='') break;
      //We don't want to repeat files, and tags_filename sometimes
      //returns a string with duplicates.
      if (pos(' 'CurTagFilename' ',DoneList,'',_fpos_case)) continue;
      status=tag_open_db(CurTagFilename);
      if (!status) {
         message('Retagging 'p_buf_name);
         status=RetagCurrentFile();
         clear_message();
         DoneList=DoneList' 'CurTagFilename' ';
         status=tag_close_db(CurTagFilename,1);
      }
      //tag_open_db(CurTagFilename);
   }
   if (inmem) {
      p_buf_flags&=~HIDE_BUFFER;
      _quit_view();
      p_view_id=orig_view_id;
   }else{
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
   }
}

_command projecttbRetagProject()
{
   _project_update_files_retag(false);
}
void _proj_tooltab_tree.ins()
{
   projecttbAddToProject();
}
void _proj_tooltab_tree.del()
{
   projecttbRemoveFromProject();
}
boolean project_is_associated_file(_str ProjectFilename,_str filename)
{
   status=_ini_get_section(ProjectFilename,"FILES",FileViewId);
   if (status) {
      return(false);
   }
   orig_view_id=p_view_id;
   p_view_id=FileViewId;
   p_line=0;
   status=search('^'_escape_re_chars(filename)'$','r@'_fpos_case);
   _delete_temp_view(FileViewId);
   p_view_id=orig_view_id;
   return(status!=0);
}
void _proj_tooltab_tree.rbutton_up()
{
   index=find_index("_projecttb_menu",oi2type(OI_MENU))
   if (!index) {
      return;
   }
   menu_handle=p_active_form._menu_load(index,'P');

   int formWid;
   formWid = _find_object("_tbproject_form");
   if (!formWid) return;
   int treeWid;
   treeWid = formWid._proj_tooltab_tree.p_window_id;
   int currIndex;
   currIndex = treeWid._TreeCurIndex();
   _str caption;
   caption = treeWid._TreeGetCaption(currIndex);
   parse caption with name "\t" fullPath;



   // If a file is not selected, disable file operations:
   if ((currIndex == TREE_ROOT_INDEX) || (fullPath == "")) {
      _menu_set_state(menu_handle, "projecttbCompile", MF_GRAYED, 'M');
      _menu_set_state(menu_handle, "projecttbEditFile", MF_GRAYED, 'M');
      _menu_set_state(menu_handle, "projecttbCheckin", MF_GRAYED, 'M');
      _menu_set_state(menu_handle, "projecttbCheckout", MF_GRAYED, 'M');
      _menu_set_state(menu_handle, "projecttbRemoveFromProject", MF_GRAYED, 'M');
      _menu_set_state(menu_handle, "projecttbRetagFile", MF_GRAYED, 'M');
   }
   if (fullPath!="" && project_is_associated_file(_project_name,fullPath)) {
      _menu_set_state(menu_handle, "projecttbRemoveFromProject", MF_GRAYED, 'M');
   }
   if (_project_name == "") {
      _menu_set_state(menu_handle, "projecttbAddToProject", MF_GRAYED, 'M');
      _menu_set_state(menu_handle, "projecttbRetagProject", MF_GRAYED, 'M');
      _menu_set_state(menu_handle, "project_edit", MF_GRAYED, 'M');
      _menu_set_state(menu_handle, "projecttbCompile", MF_GRAYED, 'M');
   }

   // Show the menu:
   x=100;y=100;
   x=mou_last_x('M')-x;y=mou_last_y('M')-y;
   _lxy2dxy(p_scale_mode,x,y);
   _map_xy(p_window_id,0,x,y,SM_PIXEL);
   flags=VPM_LEFTALIGN|VPM_RIGHTBUTTON;
   _KillToolTipMessages();
   //TreeDisablePopup(DelaySetting);
   //get_view_id(orig_view_id);
   status=_menu_show(menu_handle,flags,x,y);
   //activate_view(orig_view_id);
   _menu_destroy(menu_handle);
   //TreeEnablePopup(DelaySetting);
}
// Desc: Get a list of filter names, their patterns, the associate types flags,
//       and the application command.
static int getFilterList(_str projectName, _str (&nameList)[]
                         ,_str (&patternList)[], int (&assocTypeList)[]
                         ,_str (&appCommandList)[])
{
   _str result;
   int rc;

   nameList._makeempty();
   patternList._makeempty();
   assocTypeList._makeempty();
   appCommandList._makeempty();

   // Get filter name list:
   int iiCount;
   iiCount = 0;
   rc = _ini_get_value(projectName,"COMPILER","FILTERNAME",result);
   if (rc) {
      // If the section is not defined for this project, use the default filters:
      int i;
      for (i=0; i<filterDefaultName._length(); i++) {
         nameList[i] = filterDefaultName[i];
      }
      iiCount = filterDefaultName._length();
   } else {
      result = _ini_xlat_multiline(result);
      int i;
      for (i=0;;i++) {
         if (result=='') break;
         nameList[i] = _parse_line(result);
         iiCount++;
      }
   }

   // Get filter pattern list:
   _str tKey, tValue;
   rc = _ini_get_value(projectName,"COMPILER","FILTERPATTERN",result);
   if (rc) {
      // If the section is not defined for this project, use the default filters:
      int i;
      for (i=0; i<iiCount; i++) {
         tKey = lowcase(nameList[i]);
         tValue = "";
         if (filterDefaultPattern._indexin(tKey)) {
            tValue = filterDefaultPattern:[tKey];
         }
         patternList[i] = tValue;
      }
   } else {
      result = _ini_xlat_multiline(result);
      int i;
      for (i=0; i<iiCount ;i++) {
         if (result=='') {
            patternList[i] = "";
         } else {
            patternList[i] = _parse_line(result);
         }
      }
   }

   // Get filter application command list:
   rc = _ini_get_value(projectName,"COMPILER","FILTERAPPCOMMAND",result);
   if (rc) {
      // If the section is not defined for this project, use the default filters:
      int i;
      for (i=0; i<iiCount; i++) {
         tKey = lowcase(nameList[i]);
         tValue = "";
         if (filterDefaultAppCommand._indexin(tKey)) {
            tValue = filterDefaultAppCommand:[tKey];
         }
         appCommandList[i] = tValue;
      }
   } else {
      result = _ini_xlat_multiline(result);
      int i;
      for (i=0; i<iiCount ;i++) {
         if (result=='') {
            appCommandList[i] = "";
         } else {
            appCommandList[i] = _parse_line(result);
         }
      }
   }

   // Get associate file types list:
   rc = _ini_get_value(projectName,"COMPILER","FILTERASSOCIATEFILETYPES",result);
   if (rc) {
      // If the section is not defined for this project, use the default filters:
      int i;
      for (i=0; i<iiCount; i++) {
         tKey = lowcase(nameList[i]);
         if (filterDefaultFileAssociation._indexin(tKey)) {
            tValue = filterDefaultFileAssociation:[tKey];
            assocTypeList[i] = (int)tValue;
         } else {
            assocTypeList[i] = 0;
         }
      }
   } else {
      int i;
      for (i=0; i<iiCount; i++) {
         if (result != "") {
            parse result with atype result;
         } else {
            atype = "";
         }
         if (atype == "") {
            assocTypeList[i] = 0;
         } else {
            assocTypeList[i] = atype;
         }
      }
   }

   return(0);
}
static int getProjectFileList(_str projectName, typeless & fileList)
{
   fileList._makeempty();

   int view_id;
   get_view_id(view_id);
   //11:45am 8/18/1997
   //Dan changed for makefile support
   //status=_ini_get_section(projectName, "FILES", ini_view_id);
   status=GetProjectFiles(projectName, ini_view_id);
   if (status) {
      activate_view(view_id);
      return(1);
   }
   activate_view(ini_view_id);
   if (p_Noflines+10>_default_option(VSOPTION_WARNING_ARRAY_SIZE)) {
      _default_option(VSOPTION_WARNING_ARRAY_SIZE,p_Noflines+10);
   }

   _str line;
   top();
   up();
   int i;
   i = 0;
   while (!down()) {
      get_line(line);
      fileList[i] = line;
      i++;
   }
   _delete_temp_view(ini_view_id);
   activate_view(view_id);
   return(0);
}
static int isPatternAllFilesRE(_str pattern)
{
#if __UNIX__
      return(pos(';'ALLFILES_RE';',';'pattern';',1,_fpos_case));
      /*return(pos(';*.*;',';'pattern';',1,_fpos_case) ||
             pos(';*;',';'pattern';',1,_fpos_case));*/
#else
      return(pos(';'ALLFILES_RE';',';'pattern';',1,_fpos_case));
#endif
}
// Desc:  Check to see if the specified file has one of the extensions
//     listed in semicolon-separated pattern.
static int isFileMatchedExtension(_str name, _str pattern)
{
   ext = get_extension(name);
   if (ext=='') {
      return(isPatternAllFilesRE(pattern));
   }
   status=pos(';*.'ext';',';'pattern';',1,_fpos_case);
   if (status) {
      return(status);
   }
   return(isPatternAllFilesRE(pattern));
}

static boolean IsReadOnly(_str filename)
{
#if __UNIX__
   attrs=file_list_field(filename,DIR_ATTR_COL,DIR_ATTR_WIDTH);
   if (attrs=='') return(0);
   w=pos('w',attrs,'','i');
   return(!w);
#else
   attrs=file_list_field(filename,DIR_ATTR_COL,DIR_ATTR_WIDTH);
   if (attrs=='') return(0);
   ro=pos('r',attrs,1,'i');
   return(ro);
#endif
}

/*
int _pic_vc_co_user_r;           // File under version control checked out by user, read-only
int _pic_vc_co_other_m_r;        // File under version control checked out by other user multiple, read-only
int _pic_vc_co_other_x_r;        // File under version control checked out by other user exclusive, read-only
int _pic_vc_available_r;         // File under version control not checked read-only
int _pic_doc_r;                  // File NOT under version control read-only

int _pic_vc_co_user_w;           // File under version control checked out by user, writable
int _pic_vc_co_other_m_w;        // File under version control checked out by other user multiple, writable
int _pic_vc_co_other_x_w;        // File under version control checked out by other user exclusive, writable
int _pic_vc_available_w;         // File under version control not checked writable
int _pic_doc_w;                  // File NOT under version control writable
*/

#if 0
void _exit_prj()
{
   //9:36am 7/2/1998
   //This frees the handle to vsscc.dll that is loaded by vshlp.dll in
   //_InsertProjectFileList.
   //If this doesn't happen, the editor crashes on exit w/o any debug info
   //(Not even a cancel button)
   if (substr(machine(),1,2)=='NT') {
      _FreeSccDll();
   }
}
#endif

int def_optimize_prjfiles=1000;
int def_optimize_sccprjfiles=4000;
static int toolbarBuildFilterList(_str projectName)
{
   _str nameList[];
   _str patternList[];
   _str appCommandList[];
   _str fileList[];
   int assocTypeList[];

   if (projectName == "") return(0);
   getFilterList(projectName, nameList, patternList, assocTypeList, appCommandList);
   getProjectFileList(projectName, fileList);
   if (nameList._isempty() || nameList._length() == 0) return(0);
   /*
        If there are more than 1000 files in the project,
        don't fill in the extensions
        return(0);
   */

   // Show project name in root node:
   _str nameOnly, newCaption;
   nameOnly = strip_filename(projectName, 'P');
   newCaption = nameOnly :+ "\t" :+ projectName;
   _proj_tooltab_tree._TreeSetCaption(TREE_ROOT_INDEX,newCaption);
   _proj_tooltab_tree._TreeSetInfo(TREE_ROOT_INDEX,0,_pic_tproject,_pic_tproject);

   // Initialize tree column width to at least fit the project name.
   // This width may be changed by _InsertProjectFileList().
   int longestWW;
   longestWW = _proj_tooltab_tree._text_width(nameOnly);
   _proj_tooltab_tree._col_width(0, longestWW + 200);

   int doneCount;
   doneCount = 0;
   int i;
   int FileStatus[];
   FileStatus._makeempty();
   //This code was dead.
   _proj_tooltab_tree._TreeSetInfo(TREE_ROOT_INDEX, 1);
   BitmapIndexList[0]=_pic_doc_w;
   BitmapIndexList[1]=_pic_doc_r
   BitmapIndexList[2]=_pic_vc_co_user_w
   BitmapIndexList[3]=_pic_vc_co_user_r
   BitmapIndexList[4]=_pic_vc_co_other_x_w
   BitmapIndexList[5]=_pic_vc_co_other_x_r
   BitmapIndexList[6]=_pic_vc_co_other_m_w
   BitmapIndexList[7]=_pic_vc_co_other_m_r
   BitmapIndexList[8]=_pic_vc_available_w
   BitmapIndexList[9]=_pic_vc_available_r
   t1=_time('b');
   mou_hour_glass(1);

   orig_wid=p_window_id;
   p_window_id=_proj_tooltab_tree;
   status= _InsertProjectFileList(nameList,
                                  fileList,
                                  assocTypeList,
                                  patternList,
                                  BitmapIndexList,
                                  editor_name('P'),
                                  def_optimize_prjfiles,
                                  def_optimize_sccprjfiles,
                                  _pic_tfldclos,
                                  _pic_tfldopen,
                                  _isscc());
   p_window_id=orig_wid;
   mou_hour_glass(0);
   nindex=_TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   for (;;) {
      if (nindex<0) break;
      _TreeSortCaption(nindex,'F');
      nindex=_TreeGetNextSiblingIndex(nindex);
   }
   //t2=_time('b');
   //say('t2-t1='t2-t1);
   return(status);
}

//4:31pm 8/22/1997
//This was static, but Dan made it global so that the project toolbar
//could be updated if someone added/removed a project file from the
//make tags dialog
int toolbarUpdateFilterList(_str projectName)
{
   oriWindowId = p_window_id;

   //say( "toolbarUpdateFilterList "projectName );
   int formid;
   formid = _find_object("_tbproject_form","N")
   if (!formid) {
      p_window_id = oriWindowId;
      return(0);
   }
   p_window_id = formid._proj_tooltab_tree.p_window_id;

   // Delete all level 1 nodes in tree view and remember the expansion list:
   int expansionModeList[];
   _str expansionNameList[];
   int count;
   int childL1;
   childL1 = formid._proj_tooltab_tree._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
   count = 0;
   while (childL1 != -1) {
      int childrenShown, bm1, bm2;
      expansionNameList[count] = formid._proj_tooltab_tree._TreeGetCaption(childL1);
      formid._proj_tooltab_tree._TreeGetInfo(childL1, childrenShown, bm1, bm2);
      expansionModeList[count] = childrenShown;
      //say( expansionNameList[count]" "childrenShown );
      count++;
      int temp;
      temp = childL1;
      childL1 = formid._proj_tooltab_tree._TreeGetNextSiblingIndex(childL1);
      formid._proj_tooltab_tree._TreeDelete(temp);
   }

   // If no current project
   if (projectName == "") {
      _str text;
      text = "  No Project  ";
      int longestWW;
      longestWW = formid._proj_tooltab_tree._text_width(text);
      formid._proj_tooltab_tree._TreeSetCaption(TREE_ROOT_INDEX, text);
      formid._proj_tooltab_tree._col_width(0, longestWW + 200);
      p_window_id = oriWindowId;
      return(0);
   }

   // Build new tree:
   toolbarBuildFilterList(projectName);

   // Reset expansion state:
   if (count) {
      int i, j;
      childL1 = formid._proj_tooltab_tree._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
      while (childL1 != -1) {
         _str caption;
         caption = formid._proj_tooltab_tree._TreeGetCaption(childL1);
         for (j=0; j<expansionNameList._length(); j++) {
            if (caption != expansionNameList[j]) continue;
            formid._proj_tooltab_tree._TreeSetInfo(childL1, expansionModeList[j]);
            break;
         }
         childL1 = formid._proj_tooltab_tree._TreeGetNextSiblingIndex(childL1);
      }
   } else {
      // Get and apply the last expansion list from project file:
      _str text;
      _ini_get_value(projectName,"COMPILER","FILTEREXPANSION",text);
      if (text != "") {
         int childL1;
         childL1 = formid._proj_tooltab_tree._TreeGetFirstChildIndex(TREE_ROOT_INDEX);
         while (childL1 != -1) {
            parse text with val text;
            if (val == "") break;
            formid._proj_tooltab_tree._TreeSetInfo(childL1, val);
            if (text == "") break;
            childL1 = formid._proj_tooltab_tree._TreeGetNextSiblingIndex(childL1);
         }
      }
   }

   p_window_id = oriWindowId;
   return(0);
}
void _openfn.on_create()
{
   //messageNwait("_openfn.on_create");
   /*
   // Initialize directories:
   _opendir_list._dlpath('');
   _openfile_list._flfilename('');
   */

   _str path;
   path=_opendir_list._dlpath();
   _set_opencd(path);

   int wid;
   wid = p_window_id;
   p_window_id=_openfn.p_cb_list_box;
   _str text, tp;
   text = def_file_types;
   for (;;) {
      parse text with tp ',' text;
      if (tp == "") break;
      parse tp with . '(' tp ')' .;
      _lbadd_item(tp);
   }
   _openfn.p_text = ALLFILES_RE;
   _openfn._set_sel(1,length(_openfn.p_text)+1);
   clear_message();
}
void _proj_toolbar_sstab.on_change(int reason)
{
   if (gignore_change) {
      return;
   }
   if (reason == CHANGE_TABACTIVATED) {
      switch (p_ActiveTab) {
      case PROJTOOLTAB_CLASSES:
         cbrowser_on_expose();
         break;
      case PROJTOOLTAB_PROCS:
         _proctree_on_expose();
         break;
      case PROJTOOLTAB_OPEN:
         openTabActivated();
         break;
      }
   }
}
/*
static int getProjectToolbarWidth()
{
   // Find tab height and max tabs width:
   int i;
   int tallest, totalWidth;
   tallest = 0;
   totalWidth = 0;
   for (i=0; i<p_NofTabs; i++) {
      _str text;
      text = _getTabInfo(i);
      parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
      tabHeight = _dy2ly(SM_TWIP,y2 - y1);
      if (tabHeight > tallest) tallest = tabHeight;
      totalWidth += maxW;
   }
   int newWidth = _dx2lx(SM_TWIP,totalWidth) + _dx2lx(SM_TWIP,4);
   return(newWidth);
}
*/
void _proj_toolbar_sstab.on_create()
{
   //messageNwait("_proj_toolbar_sstab.on_create IN");
   typeless ht:[];
   ht:["_formW"] = p_active_form.p_width;
   ht:["_formH"] = p_active_form.p_height;
   ht:["_proj_toolbar_sstabW"] = p_width;
   ht:["_proj_toolbar_sstabH"] = p_height;
   ht:["_openfile_listX"] = _openfile_list.p_x;
   ht:["_openfile_listY"] = _openfile_list.p_y;
   ht:["_openfile_listW"] = _openfile_list.p_width;
   ht:["_openfile_listH"] = _openfile_list.p_height;
   ht:["lastOrientation"] = 'H';
   ht:["_openfnW"] = _openfn.p_width;
   ht:["_fileLabelY"] = _fileLabel.p_y;
   ht:["_opencdX"] = _opencd.p_x;
   ht:["_opencdY"] = _opencd.p_y;

   // Find tab height and max tabs width:
   int i;
   int tallest, totalWidth;
   tallest = 0;
   for (i=0; i<p_NofTabs; i++) {
      _str text;
      text = _getTabInfo(i);
      parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
      tabHeight = _dy2ly(SM_TWIP,y2 - y1);
      if (tabHeight > tallest) tallest = tabHeight;
   }
   ht:["tabHeight"] = tallest;
   p_user = ht;

   // This will cause an active tab switch and initializes the
   // directory list and file list:
   _retrieve_value();
   _retrieve_value("_tbproject_form._openfn");
   _openfn._set_sel(1, length(_openfn.p_text)+1);

   // If there is a wildcard in the text, apply the filter to the file list:
   if (iswildcard(_openfn.p_text)) {
      _openfn.call_event(_openfn, ENTER);
   }
   //messageNwait("_proj_toolbar_sstab.on_create OUT");
}
void _tbproject_form.on_destroy()
{
   value = _proj_toolbar_sstab.p_ActiveTab;
   _append_retrieve( _proj_toolbar_sstab, value );
   _append_retrieve( _openfn, _openfn.p_text, "_tbproject_form._openfn" );
   cbrowser_on_destroy();
   call_event(p_window_id,ON_DESTROY,'2');
}
#if 0
int _srg_projecttb()
{
   int formwid;
   formwid = _find_object("_tbproject_form","N");
   if (!formwid) return(0);
   if ( arg(1)=='R' || arg(1)=='N' ) {
      parse arg(2) with oldActive;
      formwid._proj_toolbar_sstab.p_ActiveTab = oldActive;
      down();
      _str line;
      get_line(line);
      formwid._openfn.p_text = line;
      formwid._openfn._set_sel(1, length(formwid._openfn.p_text)+1);
      formwid._openfn.call_event(formwid._openfn, ENTER);
   } else {
      insert_line("PROJECTTB: "formwid._proj_toolbar_sstab.p_ActiveTab);
      insert_line(formwid._openfn.p_text);
   }
   return(0);
}
#endif
void _project_getNewSSTabWH(typeless & ht, int formWid, int sstWid, int & sstabW,
                          int & sstabH, int & tabHeight)
{
   tabHeight = ht:["tabHeight"];
   //say( "obj="p_active_form.p_object );
   //say( "parent="p_active_form.p_parent );
   tabHeight = ht:["tabHeight"];
#if 0
   //say('sfsd');
   if (formWid.p_isbutton_bar) {
      //say('got here');
      name1='ctlgrabbar1';
      name2='ctlgrabbar2';
      grabbar1_wid=_find_control(name1);
      if (formWid.p_isbutton_bar==BBSIDE_TOP || formWid.p_isbutton_bar==BBSIDE_BOTTOM) {
         x1=_twips_per_pixel_x()*1;
         y1=_twips_per_pixel_y()*2;
         width1=0;
         height1=formWid.p_height-_twips_per_pixel_y()*4;

         x2=x1+_twips_per_pixel_x()*(3+1);
         y2=y1;
         width2=width1;
         height2=height1;

         start_x=x2+_twips_per_pixel_x()*(3+2);
         start_y=0;
         style=PSPIC_GRABBARVERT;
      } else {
         x1=_twips_per_pixel_x()*2;
         y1=_twips_per_pixel_y()*1;
         width1=formWid.p_width-_twips_per_pixel_x()*4;
         height1=0;

         x2=x1;
         y2=y1+_twips_per_pixel_y()*(3+1);
         width2=width1;
         height2=height1;

         start_x=0;
         start_y=y2+_twips_per_pixel_y()*(3+2);
         style=PSPIC_GRABBARHORZ;
      }
      if (!grabbar1_wid) {
         get_view_id(orig_view_id);
         grabbar1_wid=_create_window(OI_IMAGE,formWid,"",x1,y1,width1,height1,CW_CHILD,BDS_NONE);
         grabbar1_wid.p_name=name1;
         grabbar1_wid.p_style=style;
         grabbar2_wid=_create_window(OI_IMAGE,formWid,"",x2,y2,width2,height2,CW_CHILD,BDS_NONE);
         grabbar2_wid.p_style=style;
         grabbar2_wid.p_name=name2;
         activate_view(orig_view_id);
      } else {
         grabbar2_wid=_find_control(name2);
         grabbar1_wid._move_window(x1,y1,width1,height1);
         grabbar2_wid._move_window(x2,y2,width2,height2);
      }
      sstWid.p_x=start_x;
      sstWid.p_y=start_y;

      sstabW = _dx2lx(SM_TWIP,formWid.p_client_width) - start_x-0;
      sstabH = _dy2ly(SM_TWIP,formWid.p_client_height) - start_y-0;
      return;
   }
#endif

   sstabW = _dx2lx(SM_TWIP,formWid.p_client_width) - 2 * sstWid.p_x;
   sstabH = _dy2ly(SM_TWIP,formWid.p_client_height) - 2 * sstWid.p_y;
}
/*
// Desc: Check to see if the tabs need to be switched to
//       picture only mode.
static void updatePictureOnly(int sstabW, int sstabH)
{
   // Toggle tab control to display tab with text and images or just images:
   int newWidth;
   newWidth = _proj_toolbar_sstab.getProjectToolbarWidth();
   if (sstabW < newWidth) {
      if (p_PictureOnly != TRUE) {
         p_PictureOnly = TRUE;
      }
   } else {
      if (p_PictureOnly != FALSE) {
         p_PictureOnly = FALSE;
      }
   }
}
*/
static void resizeTabControl(typeless & ht)
{
   int sstabW,sstabH;
   _project_getNewSSTabWH(ht, p_active_form, p_window_id, sstabW, sstabH, tabHeight);
   p_width = sstabW;
   p_height = sstabH;
   ht:["sstabW"] = sstabW;
   ht:["sstabH"] = sstabH;

   // Toggle tab control to display tab with text and images or just images:
   //updatePictureOnly(sstabW, sstabH);
}
static void resizeOpenTab(typeless & ht)
{
   int sstabW,sstabH;
   int tabHeight;
   int noDriveList, noDirList, noLabels;

   _project_getNewSSTabWH(ht, p_active_form, _proj_toolbar_sstab.p_window_id, sstabW, sstabH, tabHeight);

   int tabWindow;
   tabwindow = _proj_toolbar_sstab._getActiveWindow();

   // Determine orientation:
   int minFormWidth, minFormHeight;
   _str orientation, lastOrientation;
   minFormWidth = (int)(PROJECT_MINFORMWIDTH * 0.90);
   minFormHeight = PROJECT_MINFORMHEIGHT;
   lastOrientation = ht:["lastOrientation"];
   orientation = lastOrientation;
   if (p_width < minFormWidth) {
      orientation = 'V';
   } else if (p_width > ht:["_formW"]) {
      orientation = 'H';
   }
   //say( "orientation="orientation );

   // Make controls invisible first:
   tabwindow.p_visible = FALSE;
   //_proj_toolbar_sstab.p_visible = FALSE;

   if (orientation == 'V') {
#if __UNIX__
      noDriveList = 1;
#else
      noDriveList = 0;
#endif
      noDirList = 0;
      noLabels = 0;

      // Stack up file and directory list boxes:
      availW = sstabW - 2 * ht:["_openfile_listX"] - _dy2ly(SM_TWIP,3);
      availH = sstabH - tabHeight - ht:["_openfile_listY"] -
               (int)(1.7 * _dirLabel.p_height) -
               _opendrives.p_height - 2*_filenameLabel.p_y -
               _dy2ly(SM_TWIP,4);
      fileListH = (int)(availH * 0.6);
      dirListH = availH - fileListH;

      // If too short, remove drive list and reallocate space to the list boxes:
      if ((dirListH < (int)(1.5 * _opendrives.p_height)) || noDriveList) {
         noDriveList = 1;
         availH += _filenameLabel.p_y + _opendrives.p_height;
         fileListH = (int)(availH * 0.6);
         dirListH = availH - fileListH;
      }

      // If space is still too tight, remove the directory list
      if (dirListH < (int)(1.5 * _openfn.p_height)) {
         noDirList = 1;
         availH += (int)(1.7 * _dirLabel.p_height);
         fileListH = availH;
      }

      _openfn.p_width = availW;

      _fileLabel.p_y = ht:["_fileLabelY"];

      _openfile_list.p_y = ht:["_openfile_listY"];
      _openfile_list.p_width = availW;
      _openfile_list.p_height = fileListH;

      _opendir_list.p_x = _openfile_list.p_x;
      _opendir_list.p_y = _openfile_list.p_y + _openfile_list.p_height +
               (int)(1.7 * _dirLabel.p_height);
      _opendir_list.p_width = availW;
      _opendir_list.p_height = dirListH;

      _dirLabel.p_x = _openfile_list.p_x;
      _dirLabel.p_y = _opendir_list.p_y - _dirLabel.p_height -
               (int)(0.2 * _dirLabel.p_height);

      if (noDirList) {
         _opendir_list.p_visible = FALSE;
         _dirLabel.p_visible = FALSE;
         _fileLabel.p_visible = FALSE;

         // Move current directory to side fileLabel:
         _opencd.p_x = _fileLabel.p_x;
         _opencd.p_y = _fileLabel.p_y;
      } else {
         _opendir_list.p_visible = TRUE;
         _dirLabel.p_visible = FALSE;
         _fileLabel.p_visible = TRUE;

         // Move current directory to side dirLabel:
         _opencd.p_x = _dirLabel.p_x;
         _opencd.p_y = _dirLabel.p_y;
      }
      _currDirLabel.p_visible = FALSE;

      _opendrives.p_x = _openfile_list.p_x;
      _opendrives.p_y = _opendir_list.p_y + _opendir_list.p_height +
               _filenameLabel.p_y;

      _opendrives.p_width = availW;
      if (noDriveList) {
         _opendrives.p_visible = FALSE;
      } else {
         _opendrives.p_visible = TRUE;
      }
   } else {
#if __UNIX__
      noDriveList = 1;
#else
      noDriveList = 0;
#endif
      noDirList = 0;
      noLabels = 0;

      // Put file and directory list boxes side by side:
      availW = sstabW - 3 * ht:["_openfile_listX"] - _dy2ly(SM_TWIP,3);
      availH = sstabH - tabHeight - ht:["_openfile_listY"] -
               _filenameLabel.p_y - _dy2ly(SM_TWIP,5);
      fileListW = (int)(availW * 0.4);
      if (fileListW < ht:["_openfile_listW"]) {
         fileListW = ht:["_openfile_listW"];
      }
      fileListH = availH;
      dirListW = availW - fileListW;
      dirListH = availH - _opendrives.p_height - _filenameLabel.p_y;

      // If too short, remove drive list and reallocate space to the list boxes:
      if ((dirListH < (int)(1.5 * _opendrives.p_height)) || noDriveList) {
         noDriveList = 1;
         dirListH = availH;
      }

      // If still too short, remove file and directory labels:
      startY = _openfn.p_y + _openfn.p_height + (int)(1.7 * _fileLabel.p_height);
      if (fileListH < (int)(1.5 * _openfn.p_height)) {
         noLabels = 1;
         availH = sstabH - tabHeight - (_openfn.p_y + _openfn.p_height) -
                  2 * _filenameLabel.p_y -
                  _dy2ly(SM_TWIP,5);
         fileListH = availH;
         dirListH = availH;
         startY = _openfn.p_y + _openfn.p_height + (int)(0.2 * _fileLabel.p_height);
      }

      _openfn.p_width = fileListW;

      _openfile_list.p_y = startY;
      _openfile_list.p_width = fileListW;
      _openfile_list.p_height = fileListH;

      _fileLabel.p_y = _openfile_list.p_y - (int)(1.2 * _fileLabel.p_height);

      _opendir_list.p_x = _openfile_list.p_x + _openfile_list.p_width + ht:["_openfile_listX"];
      _opendir_list.p_y = _openfile_list.p_y;
      _opendir_list.p_width = dirListW;
      _opendir_list.p_height = dirListH;

      _dirLabel.p_x = _opendir_list.p_x;
      _dirLabel.p_y = _fileLabel.p_y;
      _dirLabel.p_visible = TRUE;

      _currDirLabel.p_x = _dirLabel.p_x;
      _currDirLabel.p_y = _filenameLabel.p_y;
      _currDirLabel.p_visible = TRUE;

      // Move current directory label back:
      _opencd.p_x = _dirLabel.p_x;
      _opencd.p_y = ht:["_opencdY"];

      if (noLabels) {
         _fileLabel.p_visible = FALSE;
         _dirLabel.p_visible = FALSE;
      } else {
         _fileLabel.p_visible = TRUE;
         _dirLabel.p_visible = TRUE;
      }
      if (noDirList) {
         _opendir_list.p_visible = FALSE;
      } else {
         _opendir_list.p_visible = TRUE;
      }

      _opendrives.p_x = _opendir_list.p_x;
      _opendrives.p_y = _opendir_list.p_y + _opendir_list.p_height + _filenameLabel.p_y;
      _opendrives.p_width = dirListW;
      if (noDriveList) {
         _opendrives.p_visible = FALSE;
      } else {
         _opendrives.p_visible = TRUE;
      }
   }

   // Update current directory label:
   _set_opencd(getcwd());

   tabwindow.p_visible = TRUE;
   //_proj_toolbar_sstab.p_visible = TRUE;
   ht:["lastOrientation"] = orientation;
}

static void resizeProcsTab(_str (&ht):[])
{
   int nn;
   int avail;
   int tabHeight;
   int sstabW,sstabH;

   _project_getNewSSTabWH(ht, p_active_form, p_window_id, sstabW, sstabH, tabHeight);

   // Resize width:
   //nn = sstabW - 2 * _proc_tree.p_y - _dy2ly(SM_TWIP,2);
   _proc_tree.p_width =_dx2lx(SM_TWIP,_proc_tree.p_parent.p_client_width)-(2*_proc_tree.p_x);

   // Resize height:
   avail = sstabH - _proc_tree.p_y - tabHeight - _proc_tree.p_x - _dy2ly(SM_TWIP,4);
   _proc_tree.p_height = avail;
}

static void resizeClassesTab(typeless &ht)
{
   int tabHeight;
   int sstabW,sstabH;

   //p_child._get_window(cx,cy,cwidth,cheight);
   _project_getNewSSTabWH(ht, p_active_form, p_window_id, sstabW, sstabH, tabHeight);

   // delagate to proc implemented in cbrowser.e
   avail_width    = sstabW - _dy2ly(SM_TWIP,2);
   // Fix this is VSE 5.0
   avail_height   = sstabH - tabHeight /*- _dy2ly(SM_TWIP,2)*/;
   cbrowser_on_resize(avail_width, avail_height);
}

static void resizeFilesTab(typeless & ht)
{
   int nn;
   int avail;
   int tabHeight;
   int sstabW,sstabH;

   _project_getNewSSTabWH(ht, p_active_form, p_window_id, sstabW, sstabH, tabHeight);

   // Resize width:
   nn = sstabW - 2 * _proj_tooltab_tree.p_y - _dy2ly(SM_TWIP,2);
   _proj_tooltab_tree.p_width = nn;

   // Resize height:
   avail = sstabH - _proj_tooltab_tree.p_y - tabHeight - _proj_tooltab_tree.p_x - _dy2ly(SM_TWIP,4);
   _proj_tooltab_tree.p_height = avail;
}

static void resizeFTPTab(typeless &ht)
{
   int tabHeight;
   int sstabW,sstabH;
   int new_width,new_height,new_x,new_y;

   _project_getNewSSTabWH(ht,p_active_form,p_window_id,sstabW,sstabH,tabHeight);

   #if 1
   progress_height= _dy2ly(SM_TWIP,4)+_ctl_bottom_divider.p_height+_dy2ly(SM_TWIP,4)+_ctl_operation.p_height+_dy2ly(SM_TWIP,4)+_ctl_nofbytes.p_height+_dy2ly(SM_TWIP,8);
   #else
   progress_height= _dy2ly(SM_TWIP,4)+_ctl_bottom_divider.p_height+_dy2ly(SM_TWIP,4)+_ctl_operation.p_height+_dy2ly(SM_TWIP,4)+_ctl_progress.p_height+_ctl_nofbytes.p_height+_dy2ly(SM_TWIP,8);
   #endif
   
   // Picture group
   _ctl_group.p_width=sstabW;
   _ctl_group.p_height=sstabH-tabHeight-progress_height;
   
   // Width
   new_width=sstabW-2*_ctl_profile.p_x-_dy2ly(SM_TWIP,2);
   _ctl_profile.p_width=new_width;
   _ctl_remote_cwd.p_width=new_width;
   _ctl_remote_dir.p_width=new_width;

   // Height
   new_height=sstabH-_ctl_remote_dir.p_y-tabHeight-progress_height;
   _ctl_remote_dir.p_height=new_height;
   
   // Bitmap buttons and divider
   _ctl_disconnect.p_x= _ctl_connect.p_x+_ctl_connect.p_width+_dx2lx(SM_TWIP,4);
   _ctl_divider1.p_x= _ctl_disconnect.p_x+_ctl_disconnect.p_width+_dx2lx(SM_TWIP,4);
   _ctl_divider1.p_height=_ctl_disconnect.p_height;
   _ctl_ascii.p_x= _ctl_divider1.p_x+_ctl_divider1.p_width+_dx2lx(SM_TWIP,4);
   _ctl_binary.p_x= _ctl_ascii.p_x+_ctl_ascii.p_width+_dx2lx(SM_TWIP,2);
   
   // Center the "(No connection)" caption
   new_x= (sstabW-_ctl_no_connection.p_width)/2;
   new_y= _ctl_remote_cwd.p_y + ((_ctl_remote_dir.p_y+new_height) - _ctl_remote_cwd.p_y)/2;
   _ctl_no_connection.p_x=new_x;
   _ctl_no_connection.p_y=new_y;
   
   // Bottom controls
   _ctl_bottom_divider.p_y=_ctl_group.p_y+_ctl_group.p_height+_dy2ly(SM_TWIP,4);
   _ctl_bottom_divider.p_width=sstabW-2*_dx2lx(SM_TWIP,4);
      
   #if 1
   _ctl_operation.p_y=_ctl_bottom_divider.p_y+_ctl_bottom_divider.p_height+_dy2ly(SM_TWIP,4);
   _ctl_nofbytes.p_y=_ctl_operation.p_y+_ctl_operation.p_height+_dy2ly(SM_TWIP,4);
   new_width=sstabW-2*_ctl_operation.p_x - _dx2lx(SM_TWIP,4) - _ctl_abort.p_width;
   _ctl_operation.p_width=new_width;
   _ctl_nofbytes.p_width=new_width;
   #else
   _ctl_operation.p_y=_ctl_bottom_divider.p_y+_ctl_bottom_divider.p_height+_dy2ly(SM_TWIP,4);
   _ctl_progress.p_y=_ctl_operation.p_y+_ctl_operation.p_height+_dy2ly(SM_TWIP,4);
   _ctl_nofbytes.p_y=_ctl_progress.p_y+_ctl_progress.p_height;
   new_width=sstabW-2*_ctl_progress.p_x - _dx2lx(SM_TWIP,4) - _ctl_abort.p_width;
   _ctl_operation.p_width=new_width;
   _ctl_progress.p_width=new_width;
   _ctl_nofbytes.p_width=new_width;
   #endif
   
   new_x=_ctl_operation.p_x+new_width+_dx2lx(SM_TWIP,4);
   _ctl_abort.p_x=new_x;
   _ctl_abort.p_y=_ctl_bottom_divider.p_y+_ctl_bottom_divider.p_height;
}

void _tbproject_form.on_resize()
{
   typeless lastW, lastH;
   typeless ht:[];
   ht = _proj_toolbar_sstab.p_user;
   if (ht._indexin("formWH")) {
      _str text;
      text = ht:["formWH"];
      parse text with lastW lastH;
      if (lastW == p_width && lastH == p_height &&
          _proj_toolbar_sstab.p_width<p_width) return;
   } else {
      ht:["formWH"] = p_width:+" ":+p_height;
      _proj_toolbar_sstab.p_user = ht;
      return;
   }

   // Resize tab control:
   _proj_toolbar_sstab.resizeTabControl(ht);

   // Resize Open tab:
   _proj_toolbar_sstab.resizeOpenTab(ht);

   // Resize Files tab:
   _proj_toolbar_sstab.resizeFilesTab(ht);

   // Resize Files tab:
   _proj_toolbar_sstab.resizeProcsTab(ht);

   // Resize Classes tab:
   _proj_toolbar_sstab.resizeClassesTab(ht);
   
   // Resize FTP tab:
   _proj_toolbar_sstab.resizeFTPTab(ht);

   // Save form's new XYWH:
   ht:["formWH"] = p_width:+" ":+p_height;
   _proj_toolbar_sstab.p_user = ht;
}
// Desc:  Update open file list only if the tab is activated.
//     If the Open tab is not the active tab, suppress updating the files.
static void openTabActivated()
{
   // If active tab is not Open tab, do nothing:
   if (_proj_toolbar_sstab.p_ActiveTab != PROJTOOLTAB_OPEN ) {
      return;
   }

   // Refresh Open tab:
   _cd_tbproject();
#if __UNIX__
   // openTabActivated() gets called when we dock/undock the toolbar so we need
   // to clear the message from _cd_tbproject()
   clear_message();
#endif
}
static void MaybeUpdateProjectToMakeFile(GettingFocus,...)
{
   if (!GettingFocus) return;
   RefreshToobar=arg(2);
   //10:17am 9/16/1997
   //Retagging seemed to slow everything down a little bit, so I figured
   //we should only do it when switching to our app....
   if (_project_name=='') return;
   status=_ini_get_value(_project_name,"ASSOCIATION",'makefile',makefile,'');
   if (status||makefile=='') return;
   status=_open_temp_view(makefile,temp_view_id,orig_view_id);
   if (status) return;
   date=p_file_date;
   _delete_temp_view(temp_view_id);
   p_view_id=orig_view_id;
   status=_ini_get_value(_project_name,"ASSOCIATION",'makefiledate',makefiledate,'');
   if (status) return;
   if (date!=makefiledate) {
      mou_hour_glass(1);
      //tagging callbacks will get called if necessary by this function
      message(nls('The makefile %s changed.  Visual SlickEdit is updating tag files',makefile));
      call_list('_project_update_files',_project_name);
      if (RefreshToobar) {
         toolbarUpdateFilterList(_project_name);
      }
      status=_ini_set_value(_project_name,"ASSOCIATION",'makefiledate',date,'');
      mou_hour_glass(0);
   }
}
//Start DANS STUFF
_actapp_makefile()
{
   MaybeUpdateProjectToMakeFile(arg(1));
}
int _OnUpdate_project_add_file(CMDUI &cmdui,int target_wid, _str command)
{
   parse command with cmdname filename;
   if (_project_name=='') {
      return(MF_GRAYED);
   }
   if (filename=="") {
      if ( !target_wid || !target_wid._isEditorCtl()) {
         return(MF_GRAYED);
      }
      filename=target_wid.p_buf_name;
   }
   // For now, its too slow to check whether the file is
   // already in the project.  If we every cache the project
   // files or keep the project file loaded, we can do better.
#if 0
   // Code below only works for taggable project files
   filename=absolute(strip(filename,'B','"'));
   tag_files=project_tags_filename();
   for (;;) {
      parse tag_files with tag_filename tag_files;
      if (tag_filename=="") {
         break;
      }
      int status= tag_read_db(tag_filename);
      if (!status) {
         // get the files from the database
         int status=tag_get_date(filename,tagged_date);
         if (!status) {
            return(MF_GRAYED);
         }
      }
   }
#endif
   return(MF_ENABLED);
}
_command void project_add_file(_str newfilename="")
{
   if (_project_name == '') {                           //Check to see if Project is Active
      _message_box('No Project Open', 'Error!',0);
      return;
   }
   newfilename = strip(newfilename,'B','"');
   if (newfilename == '') {                                //Check to see if arg(1) is empty, if so
      newfilename = p_buf_name;                            //Get the current buffer name
      if (newfilename == '') {                             //If p_buf_name is empty
         _message_box('Buffer Has No Name','Error',0);
         return;
      }
   }
   // Check to see if file exists
   if ((file_match(maybe_quote_filename(newfilename)'  -p',1))== '') {                                         //If there is no such file...
      _message_box('File Does Not Exist or Has Not Been Saved','Error',0);
      return;
   }
   newfilename=absolute(newfilename);
   
   tag_filename=_GetProjectTagsFilename();
   tag_add_filelist(tag_filename,maybe_quote_filename(newfilename));
   //toolbarUpdateFilterList(_project_name);
   _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX,tag_filename);
   _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
}

//--------------------------------------------------------------------------
defeventtab _yesToAll_form;

void ctlYes.on_create()
{
   ctlMsg.p_caption = arg(1);
   p_active_form.p_caption = arg(2);
}

void yesToAllExit(_str msg)
{
   int fid;
   fid = p_active_form;
   fid._delete_window(msg);
}

void ctlYes.lbutton_up()
{
   yesToAllExit("YES");
}

void ctlYesToAll.lbutton_up()
{
   yesToAllExit("YESTOALL");
}

void ctlNo.lbutton_up()
{
   yesToAllExit("NO");
}

void ctlCancel.lbutton_up()
{
   yesToAllExit("CANCEL");
}
