/*
$VerboseHistory: pushtag.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:54a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:52a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

#define KEYPRESSTOTAGMATCHINGDELAY 100
#define PREFIXMATCHEDMAXLISTCOUNT 200
#define COLWIDTHGAP 200
#define PREFIXMINCHARCOUNT 1

static int pushTgBmTimerID = -1;
static int pushTgBmIgnoreChange = 0;

  static typeless _bm_number=1;  // typeless because parse used.

  int def_max_bm_tags=15;

definit()
{
   if ( arg(1)!='L' ) {
     _bm_number=1
   }

}
_command push_bookmark(...) name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   markid=arg(1);

   if (markid=="") {
      markid=_alloc_selection('b');
      _select_char(markid);
   }

   bm_id='TAG':+_bm_number
   _bm_number=_bm_number+1
   if ( _bm_number>def_max_bm_tags ) {
      _bm_number=1
   }
   i=_BookmarkFind(bm_id,VSBMFLAG_PUSHED);
   if (i>=0) {
      _BookmarkRemove(i);
   }
   _BookmarkAdd(bm_id,markid,VSBMFLAG_PUSHED);
   return(0)
}
_command f,push_tag(...) name_info(TAG_ARG','VSARG2_EDITORCTL|VSARG2_REQUIRES_MDI)
{
   if (_no_child_windows()) {
      return(find_tag(arg(1)))
   }
   mark=_alloc_selection('b')
   if ( mark<0 ) {
      return(mark)
   }
   _select_char(mark);
   status=find_tag(arg(1))
   if ( status /* or substr(p_buf_name,1,7)="Help on" */ ) {
      _free_selection mark
      return(status)
   }
   return(push_bookmark(mark))

}
int _OnUpdate_pop_bookmark(CMDUI &cmdui,int target_wid,_str command)
{
   temp=_bm_number;
   --temp;
   if (temp<1) {
      temp=def_max_bm_tags;
   }
   bm_id='TAG':+temp;
   i=_BookmarkFind(bm_id,VSBMFLAG_PUSHED);
   if (i<0) {
      return(MF_GRAYED);
   }
   return(MF_ENABLED);
}
_command pop_bookmark() name_info(','VSARG2_ICON|VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   orig_bm_number=_bm_number;
   --_bm_number;
   if (_bm_number<1) {
      _bm_number=def_max_bm_tags;
   }
   bm_id='TAG':+_bm_number;
   i=_BookmarkFind(bm_id,VSBMFLAG_PUSHED);
   if (i<0) {
      _bm_number=orig_bm_number;
      message nls('No bookmarks to pop')
      return(1)
   }
   old_buffer_name=(p_DocumentName!="")?p_DocumentName:p_buf_name;
   status=_BookmarkGetInfo(i,
                    bm_id,mark_id,vsbmflags,buf_id,
                    0,RealLineNumber,col,BeginLineROffset,
                    LineData,filename,DocumentName
                    );
   if (status==TEXT_NOT_SELECTED_RC) {
      status=_restore_bookmark(filename);
      if (status) {
         return(status);
      }
   }
   
   switch_buffer(old_buffer_name);
   begin_select(mark_id);
   _BookmarkRemove(i);
   //_set_focus();
   return(status)


}
_str strip_last_word(var line)
{
   line=strip(line,'T');
   i=lastpos(' ',line);
   if ( ! i ) {
      result=line;
      line='';
      return(result);
   }
   result=substr(line,i+1);
   line=strip(substr(line,1,i-1),'T');
   return(result)

}
//_command gui_push_tag() name_info(','VSARG2_ICON|VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
_command gui_push_tag(...) name_info(','VSARG2_EDITORCTL|VSARG2_REQUIRES_MDI)
{
   _macro_delete_line();
   for (;;) {
      result = show('-modal -reinit _tagbookmark_form');
      if (result == '') {
         return(COMMAND_CANCELLED_RC)
      }
      status = push_tag(result);
      if(status != 1) {  /* Tag not found? */
         _macro('m',_macro('s'))
         _macro_call('push_tag', result);
         return(status);
      }
      orig_buf_id = p_buf_id;
      status = load_files('+b .command');
      if (!status) {
         bottom();
         status = search("\\@cb _tagbookmark_form.ctlTag", 'r-');
         _delete_line(); up(); _delete_line();
         p_buf_id = orig_buf_id;
      }
   }
}

//--------------------------------------------------------------
defeventtab _tagbookmark_form
void ctlTagList.lbutton_double_click()
{
   ctlOK.call_event(ctlOK, LBUTTON_UP, 'W');
}
void pushTgConfigureMenu(int menu_handle, int flags, int include_proctree)
{
   // get rid of proctree items
   if (!include_proctree) {
      status=_menu_find(menu_handle,"sortfunc",mh,mpos,'C');
      if (!status) {
        _menu_delete(mh,mpos);
      }
      status=_menu_find(menu_handle,"sortlinenum",mh,mpos,'C');
      if (!status) {
        _menu_delete(mh,mpos);
      }
      status=_menu_find(menu_handle,"autoexpand",mh,mpos,'C');
      if (!status) {
        _menu_delete(mh,mpos);
      }
      status=_menu_find(menu_handle,"nontaggable",mh,mpos,'C');
      if (!status) {
        _menu_delete(mh,mpos);
      }
   } else {
      status=_menu_find(menu_handle,"lvar",mh,mpos,'C');
      if (!status) {
        _menu_delete(mh,mpos);
      }
   }

   // handle 'case sensitive' as a special case
   if (!include_proctree) {
      if (flags & VS_TAGFILTER_CASESENSITIVE) {
         _menu_set_state(menu_handle,"casesensitive",MF_CHECKED,'C');
      }
   } else {
      status=_menu_find(menu_handle,"casesensitive",mh,mpos,'C');
      if (!status) {
        _menu_delete(mh,mpos);
      }
   }

   // set up states of the rest of the flags
   if (flags & VS_TAGFILTER_PROC) {
      _menu_set_state(menu_handle,"proc",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_PROTO) {
      _menu_set_state(menu_handle,"proto",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_DEFINE) {
      _menu_set_state(menu_handle,"define",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_ENUM) {
      _menu_set_state(menu_handle,"enum",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_GVAR) {
      _menu_set_state(menu_handle,"gvar",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_TYPEDEF) {
      _menu_set_state(menu_handle,"typedef",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_STRUCT) {
      _menu_set_state(menu_handle,"struct",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_UNION) {
      _menu_set_state(menu_handle,"union",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_LABEL) {
      _menu_set_state(menu_handle,"label",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_INTERFACE) {
      _menu_set_state(menu_handle,"interface",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_PACKAGE) {
      _menu_set_state(menu_handle,"package",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_VAR) {
      _menu_set_state(menu_handle,"var",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_CONSTANT) {
      _menu_set_state(menu_handle,"const",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_PROPERTY) {
      _menu_set_state(menu_handle,"prop",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_LVAR) {
      _menu_set_state(menu_handle,"lvar",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_DATABASE) {
      _menu_set_state(menu_handle,"database",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_GUI) {
      _menu_set_state(menu_handle,"gui",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_INCLUDE) {
      _menu_set_state(menu_handle,"include",MF_CHECKED,'C');
   }
   if (flags & VS_TAGFILTER_MISCELLANEOUS) {
      _menu_set_state(menu_handle,"misc",MF_CHECKED,'C');
   }
}
void ctlTagList.rbutton_up()
{
   // Get handle to menu:
   int index=find_index("_tagbookmark_menu",oi2type(OI_MENU));
   menu_handle=_mdi._menu_load(index,'P');

   int flags = ctlTagList.p_user;
   pushTgConfigureMenu(menu_handle, flags, 0);

   // Show menu:
   mou_get_xy(x,y);
   _KillToolTipMessages();
   status=_menu_show(menu_handle,VPM_RIGHTBUTTON,x-1,y-1);
   _menu_destroy(menu_handle);
}
void ctlCaseSensitive.lbutton_up()
{
   pushTgBmMatchTags();
}
void _tagbookmark_form.on_create()
{
   typeless ht:[];
   ht:["ctlOK.xdiff"] = _dx2lx(SM_TWIP, p_active_form.p_client_width) - ctlOK.p_x;
   ht:["xgap"] = ctlTag.p_x + _dx2lx(SM_TWIP,2);
   ctlOK.p_user = ht;
}
void _tagbookmark_form.on_resize()
{
   typeless ht:[];
   int width, height;
   int newW, newH;

   ht = ctlOK.p_user;
   width = _dx2lx(SM_TWIP, p_active_form.p_client_width);
   height = _dy2ly(SM_TWIP, p_active_form.p_client_height);

   newW = width - ctlTag.p_x - ht:["ctlOK.xdiff"] - ht:["xgap"];
   newH = height - ctlTagList.p_y - ctlTag.p_y;

   // Make controls invisible
   ctlTag.p_visible = false;
   ctlTagList.p_visible = false;

   ctlTag.p_width = newW;
   ctlTagList.p_width = newW;

   ctlTagList.p_height = newH;

   ctlOK.p_x = width - ht:["ctlOK.xdiff"];
   ctlCancel.p_x = ctlOK.p_x;
   //ctlhelp.p_x = ctlOK.p_x;

   // Redisplay controls:
   ctlTag.p_visible = true;;
   ctlTagList.p_visible = true;;
}
void ctlTagList.on_change(reason)
{
   _str text = _lbget_text();
   if (substr(text,1,8) == "<Listing") {
      return;
   }
   parse text with tag "\t" .;
   pushTgBmIgnoreChange = 1;
   ctlTag.p_cb_text_box.p_text = tag;
   pushTgBmIgnoreChange = 0;
}
void pushTgBmTimerCB()
{
   if (pushTgBmTimerID >= 0) {
      _kill_timer(pushTgBmTimerID);
      pushTgBmTimerID = -1;
   }
   // Fill tag list:
   int formwid = _find_object("_tagbookmark_form",'n');
   if (!formwid) return;
   formwid.pushTgBmMatchTags();
   refresh();
}
static void pushTgBmMatchTags()
{
   // If prefix is too short, don't match tags:
   _str prefix = ctlTag.p_text;
   _str rejected_ext = '#';
   if (length(prefix) < PREFIXMINCHARCOUNT) {
      ctlTagList._lbclear();
      return;
   }
   int prefixLen = length(prefix);
   int flags = ctlTagList.p_user;
   int longestTag  = 0;
   int longestName = 0;

   // Clear tag list box:
   ctlTagList.p_visible = false;
   ctlTagList._lbclear();

   // Open tag files:
   int tagCount = 0;
   typeless tag_files = tags_filenamea(ctlTag.p_user);
   int i=0;
outerloop:
   for (;;) {
      // get next tag file
      _str tag_filename = next_tag_filea(tag_files, i, false, true);
      if (tag_filename == '') {
         break;
      }

      // Loop thru the matching tags in tag file:
      int status = tag_find_prefix(prefix);
      //say('prefix='prefix' status='status);
      for (;;) {
         if (status) break;
         if (tagCount > PREFIXMATCHEDMAXLISTCOUNT) {
            ctlTagList._lbadd_item("<Listing stopped after "PREFIXMATCHEDMAXLISTCOUNT" matches>");
            break outerloop;
         }
         tag_name=type_name=filename=line_no=class_name='';
         tag_get_info(tag_name,type_name,filename,line_no,class_name,tag_flags);
         
         // Filter out certain tags:
         if (!tag_filter_type(0, flags, type_name) || 
             (tag_flags & VS_TAGFLAG_anonymous) || 
             type_name == 'import' || type_name=='friend') {
            status=tag_next_prefix(prefix);
            continue;
         }

         // maybe filter out tags from class, jar, or zip files
         if (flags & VS_TAGFILTER_NOBINARY) {
            _str ext = lowcase(get_extension(filename));
            if (ext:==rejected_ext || find_index('vs'ext'_load_tags',PROC_TYPE)) {
               rejected_ext=ext;
               status=tag_next_prefix(prefix);
               continue;
            }
         }

         // Case-sensitivity:
         if (flags & VS_TAGFILTER_CASESENSITIVE) {
            if (prefix != substr(tag_name,1,prefixLen)) {
               status=tag_next_prefix(prefix);
               continue;
            }
         }
         _str nameOnly = strip_filename(filename, 'P');
         _str pathOnly = strip_filename(filename, 'N');
         _str text = tag_name"\t"type_name"\t"nameOnly"\t"pathOnly;
         ctlTagList._lbadd_item(text);
         tagCount++;
         status=tag_next_prefix(prefix);

         int ll = ctlTagList._text_width(tag_name);
         if (ll > longestTag) longestTag = ll;
         ll = ctlTagList._text_width(nameOnly);
         if (ll > longestName) longestName = ll;
      }
   }

   ctlTagList._col_width(0, (longestTag+COLWIDTHGAP));
   ctlTagList._lbsort();
   ctlTagList.pushTgBmRemoveDup(longestType);
   ctlTagList._col_width(1, (longestType+COLWIDTHGAP));
   ctlTagList._col_width(2, (longestName+COLWIDTHGAP));
   ctlTagList._lbtop();

   ctlTagList.p_visible = true;
   //say( "tagCount="tagCount );
}
void ctlTag.on_change(reason)
{
   int currTime;
   if (pushTgBmIgnoreChange) return;

   // If prefix is too short, don't match tags:
   _str prefix;
   prefix = ctlTag.p_cb_text_box.p_text;
   if (length(prefix) < PREFIXMINCHARCOUNT) {
      ctlTagList._lbclear();
      return;
   }
   
   if (pushTgBmTimerID >= 0) _kill_timer(pushTgBmTimerID);
   pushTgBmTimerID = _set_timer( KEYPRESSTOTAGMATCHINGDELAY, pushTgBmTimerCB, 0 );
}
void ctlTag.on_create(_str searchText="",_str FormName="",_str ext="",
                      boolean nobinary=true)
{
   if (FormName!='') {
      p_active_form.p_caption=FormName;
   }
   // Save extension for extension-specific tag file searching
   p_user = ext;

   // Restore previous history values:
   ctlTag._retrieve_value();
   ctlTag.p_cb_list_box._retrieve_list();
   ctlTagList.p_user = _retrieve_value("_tagbookmark_form.ctlTagList");
   if (ctlTagList.p_user == "") {
      ctlTagList.p_user = 0xffff & (~VS_TAGFILTER_CASESENSITIVE);    
   }
   if (nobinary) {
      ctlTagList.p_user |= VS_TAGFILTER_NOBINARY;
   }

   if (arg() >= 1) {
      ctlTag.p_text = searchText;
   }
   ctlTagList._col_width(0, 2000);  // Just init to some value
   ctlTagList._col_width(-1,1);
}
void ctlTag.on_destroy()
{
   if (pushTgBmTimerID >= 0) {
      _kill_timer(pushTgBmTimerID);
      pushTgBmTimerID = -1;
   }
}
void _tagbookmark_form.on_destroy()
{
   _append_retrieve(ctlTag, ctlTag.p_cb_text_box.p_text);
   _append_retrieve(0, ctlTagList.p_user, "_tagbookmark_form.ctlTagList" );
}
void ctlOK.lbutton_up()
{
   p_active_form._delete_window(ctlTag.p_cb_text_box.p_text);
}
void ctlCancel.lbutton_up()
{
   p_active_form._delete_window("");
}
static void pushTgBmRemoveDup(int & typeLength)
{
   int newType;
   _str lastTag;
   lastTag = "";
   _str typeText;
   typeText = "";
   _str typeList[];
   typeList._makeempty();

#if 0
   int i;
   i = 0;
   _lbtop();
   _lbup();
   while (!_lbdown()) {
      text = _lbget_text();
      say( i". "text );
      i++;
   }
#endif 

   _str longestTypeText;
   longestTypeText = "";
   _str firstFileName, firstFilePath;
   firstFileName = "";
   firstFilePath = "";
   int moreThanOneFile;
   moreThanOneFile = 0;
   _lbtop();
   _lbup();
   if (!_lbdown()) {
      for (;;) {
         _str text;
         text = _lbget_text();
         parse text with tag "\t" type "\t" name "\t" path;
         if (!stricmp(tag,lastTag)) {
            // If type is new, add to type list:
            newType = 1;
            for (i=0; i<typeList._length(); i++) {
               if (type == typeList[i]) {
                  newType = 0;
                  break;
               }
            }
            if (newType) {
               if (typeText == "") {
                  typeText = type;
               } else {
                  typeText = typeText :+ ", " :+ type;
               }
               //say( "tag="tag" typeText="typeText );
               typeList[typeList._length()] = type;
               _lbup();
               _lbdelete_item();
               _lbdelete_item();
               _lbup();
               if (moreThanOneFile ||
                   stricmp(name,firstFileName) ||
                   stricmp(path,firstFilePath)) {
                  _lbadd_item(tag"\t"typeText"\t"firstFileName"...\t"firstFilePath);
               } else {
                  _lbadd_item(tag"\t"typeText"\t"firstFileName"\t"firstFilePath);
               }
               if (length(typeText) > length(longestTypeText)) {
                  longestTypeText = typeText;
               }
            } else {
               if (stricmp(name,firstFileName) ||
                   stricmp(path,firstFilePath)) moreThanOneFile = 1;
               // Special case for last line...  Just delete it and done.
               // Otherwise, delete the line and skip the down().
               if (p_line == p_Noflines) {
                  _lbdelete_item();
                  break;
               }
               _lbdelete_item();
               continue;  // Skip the down()
            }
         } else {
            moreThanOneFile = 0;
            firstFileName = name;
            firstFilePath = path;
            typeText = type;
            if (length(typeText) > length(longestTypeText)) {
               longestTypeText = typeText;
            }
            typeList._makeempty();
            typeList[0] = type;
         }

         lastTag = upcase(tag);
         if (_lbdown()) break;
      }
   }
   typeLength = _text_width(longestTypeText);
}
_command tagBookmarkRunMenu() name_info(','VSARG2_CMDLINE)
{
   if (arg(1)=='') {
      return('');
   }
   _str FormName=p_active_form.p_name;
#if 0
   int formwid = _find_object("_tagbookmark_form", "N");
   if (!formwid) return("");
#else 
   //1:23pm 8/11/1997 -Dan 
   //I think this is ok
   int formwid=p_window_id;
#endif

   int flags;
   if (FormName=='_tagbookmark_form') {
      flags = formwid.ctlTagList.p_user;
   }else if (FormName=='_tboutput_form') {
      flags = def_tagwin_flags;
   }else if (FormName=='_tbproject_form') {
      flags = def_proctree_flags;
   }
   int mask=0;
   switch (arg(1)) {
   case 'casesensitive': mask = VS_TAGFILTER_CASESENSITIVE; break;
   case 'proc':          mask = VS_TAGFILTER_PROC;          break;
   case 'proto':         mask = VS_TAGFILTER_PROTO;         break;
   case 'define':        mask = VS_TAGFILTER_DEFINE;        break;
   case 'enum':          mask = VS_TAGFILTER_ENUM;          break;
   case 'gvar':          mask = VS_TAGFILTER_GVAR;          break;
   case 'typedef':       mask = VS_TAGFILTER_TYPEDEF;       break;
   case 'struct':        mask = VS_TAGFILTER_STRUCT;        break;
   case 'union':         mask = VS_TAGFILTER_UNION;         break;
   case 'label':         mask = VS_TAGFILTER_LABEL;         break;
   case 'interface':     mask = VS_TAGFILTER_INTERFACE;     break;
   case 'package':       mask = VS_TAGFILTER_PACKAGE;       break;
   case 'var':           mask = VS_TAGFILTER_VAR;           break;
   case 'const':         mask = VS_TAGFILTER_CONSTANT;      break;
   case 'prop':          mask = VS_TAGFILTER_PROPERTY;      break;
   case 'lvar':          mask = VS_TAGFILTER_LVAR;          break;
   case 'database':      mask = VS_TAGFILTER_DATABASE;      break;
   case 'gui':           mask = VS_TAGFILTER_GUI;           break;
   case 'include':       mask = VS_TAGFILTER_INCLUDE;       break;
   case 'misc':          mask = VS_TAGFILTER_MISCELLANEOUS; break;
   }
   // toggle bit mask
   flags = (flags & mask)? (flags & (~mask)) : (flags | mask);

   if (FormName=='_tagbookmark_form') {
      formwid.ctlTagList.p_user = flags;
      formwid.pushTgBmMatchTags();
   }else if (FormName=='_tboutput_form') {
      def_tagwin_flags&=~(VS_TAGFILTER_CASESENSITIVE|VS_TAGFILTER_ANYTHING);
      def_tagwin_flags|=flags;
      _config_modify|=CFGMODIFY_DEFVAR;
      _mdi.p_child._set_focus();
      _UpdateTagWindow(true);
      _nocheck _control ctltagname;
      ctltagname.call_event(CHANGE_CLINE,ctltagname,ON_CHANGE,'W');
   }else if (FormName=='_tbproject_form') {
      def_proctree_flags&=~(VS_TAGFILTER_CASESENSITIVE|VS_TAGFILTER_ANYTHING);
      def_proctree_flags|=flags;
      _config_modify|=CFGMODIFY_DEFVAR;
      _mdi.p_child._set_focus();
      _mdi.p_child.p_ModifyFlags &= ~MODIFYFLAG_PROCTREE_UPDATED;
      _UpdateCurrentTag(true);
   }
   return(flags);
   //_mdi.p_child._set_focus();
}
