/*
$VerboseHistory: sellist.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:00a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:59a
 * Comment:
 * Change message box to display question mark icon.
 * Added support for editor control.
 * Added support for Explorer style open dialog.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

   _control _sellist;

#define NO_NAME 'Untitled<'

#define PREFIX_RE '^ *'
#define SEARCH_OPTIONS '+>r'
#if __UNIX__
   #define TEMP_LIST '.list.slk'
#else
   #define TEMP_LIST '$list.slk'
#endif

#define BUFFER_COL 5
#define SORT_BUFLIST_FLAG 1
#define SEPARATE_PATH_FLAG 2
#define SHOW_SYSTEM_BUFFERS_FLAG 4

static _str lb_nls_chars;
static int gstart_buf_id;

int def_buflist=SORT_BUFLIST_FLAG+SEPARATE_PATH_FLAG


_control btnsave_selected;   // Save Selected button
static _str _list_modified_ft(reason,var result,key)
{
   // Initialize or change selected
   if (reason==SL_ONINIT || reason==SL_ONSELECT) {
      save_selected_wid=btnsave_selected
      if (_sellist.p_Nofselected) {
         if (!save_selected_wid.p_enabled) {
             save_selected_wid.p_enabled=1
         }
      } else {
         save_selected_wid.p_enabled=0
      }
      return('');
   }
   if (reason==SL_ONDEFAULT) {  // Enter callback?
      /* Save all files. */
      result=1;
      return(1);
   }
   if (reason!=SL_ONUSERBUTTON && reason!=SL_ONLISTKEY){
      return('');
   }
   orig_wid=p_window_id;
   p_window_id=_sellist
   if ( key==4) {  /* Save Selected */
      if (!btnsave_selected.p_enabled) {
         return('');
      }
      top();up();
      done=0;
      for (;;) {
         down();
         if (rc) break;
         get_line line
         while (!_lbisline_selected()) {
            if(_delete_line()) {
               done=1;
               break;
            }
         }
         if (done ) break;
         get_line line
         name=_buflist_name(line);
         replace_line name
      }
      p_buf_flags=p_buf_flags & ~DELETE_BUFFER_ON_CLOSE;
      // If there is an existing temp list, get rid of it
      buf_id=p_buf_id;
      temp_name=absolute(TEMP_LIST)
      status=load_files('+q +b 'temp_name)
      if (!status) {
         _delete_buffer;
         p_buf_id=buf_id;
      }
      p_buf_name=temp_name
      result='@'p_buf_name
      p_window_id=orig_wid;
      return(1)
   } else if ( key==5) { /* Invert. */
      _lbinvert();
      _list_modified_ft(SL_ONSELECT,junk,'')
      p_window_id=orig_wid;
      return('');
   } else if ( key==6) { /* Save None. */
      result=6;
      p_window_id=orig_wid;
      return(1);
   }
   return('');
}
static _str _list_buffers_callback(reason,var result,key)
{
   if (reason==SL_ONDEFAULT) {  // Enter key
      _sellist.get_line line
      name=_buflist_name(line);
      result=name
      return(1);
   }
   user_button=reason==SL_ONUSERBUTTON
   if (reason!=SL_ONLISTKEY && !user_button) {
      return('');
   }
   orig_wid=p_window_id;
   p_window_id=_sellist
   buffer_list=lowcase(p_active_form.p_caption)=='select a buffer';
   if (buffer_list) {
      if (!user_button && isalpha(key)) {
         if (upcase(key)=='Q') {
            key=5
         } else {
            i=pos(key,lb_nls_chars,1,'i')
            if (i) {
               key=i+2;
            }
         }
      }
      if ( key==6) {  // Toggle order
         _lbclear();
         if ( def_buflist&SORT_BUFLIST_FLAG ) {
            def_buflist=def_buflist&~SORT_BUFLIST_FLAG
         } else {
            def_buflist=def_buflist|SORT_BUFLIST_FLAG
         }
         _build_buf_list(width,p_buf_id,false,gstart_buf_id);
         top
         p_modify=0
         _lbselect_line();
         p_window_id=orig_wid;
         return('');
      } else if ( key==4) {  // Save
         get_line line
         name=_buflist_name(line)
         if ( substr(name,1,1)=='.' ) {
            _message_box(nls("Can't save buffer starting with '.'"))
            p_window_id=orig_wid;_set_focus();
            return('')
         }
         if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
            if ( delphiIsRunning() && delphiIsBufInDelphi(name) ) {
               //sticky_message( "delphi file="p_buf_name );
               delphiSaveBuffer( name );
               return( '' );
            }
         }
         status=_save_non_active(name)
         if (status) {
            p_window_id=orig_wid;
            return('');
         }
         //get_line line
         indicators=stranslate(substr('',1,BUFFER_COL-1),'','*')
         replace_line indicators:+build_buf_name(name)
         _lbselect_line();
         p_modify=0
         p_window_id=orig_wid;
         return('')
      } else if ( key==5) { // Close.
         get_line line
         name=_buflist_name(line)
         if ( substr(name,1,1)=='.' ) {
            p_window_id=orig_wid;_set_focus();
            _message_box(nls("Can't close buffer starting with '.'"))
            return('')
         }
         if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
            if ( delphiIsRunning() && delphiIsBufInDelphi(name) ) {
               //messageNwait( "closing file="name );
               delphiCloseBuffer( name );
               return( '' );
            }
         }
         status=_save_non_active(name,1)
         if (status) {
            p_window_id=orig_wid;
            return('');
         }
         _delete_line
         if (!_on_line0()) {
            _lbselect_line();
         }
         // If the list is the last buffer?
         if (last_buffer()) {
            result=''
            p_window_id=orig_wid;
            return(1);
         }
         p_window_id=orig_wid;
         return('')
      }
   } else {//Should be Link to window form
      if (key==5) {//CPB
         old_val=def_one_file;
         def_one_file='';
         p_window_id=_mdi.p_child;
         result=start_process();
         if (result==PROCESS_ALREADY_RUNNING_RC) {
            p_window_id=orig_wid;
            def_one_file=old_val;
            result='.process';
            return(1);
         }
         if (result) {
            p_window_id=orig_wid;
            def_one_file=old_val;
            return('');
         }
         _macro_append('old_option=def_one_file;');
         _macro_call('start_process');
         _macro_append('def_one_file=old_option;');
         result=_chr(0);
         def_one_file=old_val;
         p_window_id=orig_wid;
         return(1);
      }else if (key==4) {
         old_val=def_one_file;
         def_one_file='';
         old_rec=_macro('m');_macro('m',0);
         result=gui_open(OFN_READONLY);
         _macro('m',old_rec);
         if (result) {
            def_one_file=old_val;
            return('');
         }
         _macro_append("edit('-w ':+"_quote(maybe_quote_filename(p_buf_name))");");
         result=_chr(0)
         def_one_file=old_val;
         p_window_id=orig_wid;
         return(1);
      }
   }
   return('');
}
int _OnUpdate_close_all(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdate_list_buffers(cmdui,target_wid,command));
}
_command int close_all() name_info(','VSARG2_REQUIRES_MDI)
{
   while (!quit(1));

   if ( !(p_window_flags&HIDE_WINDOW_OVERLAP) ) {
      return(1);
   }

   //Now see if there are any buffers that are not attatched to windows.
   p_window_id=_mdi.p_child;
   _safe_hidden_window();
   orig_buf_id=p_buf_id;

   found_one=0;
   for (;;) {
      if (_need_to_save()) {
         is_hidden=(p_buf_flags&HIDE_BUFFER)
         if ( ! is_hidden) {
            found_one=1;
            break;
         }

      }
      _next_buffer 'NRH'
      if ( p_buf_id==orig_buf_id ) {
         break
      }
   }
   if (found_one) {
      status=edit('+t');
      if (status) {
         message_box('error: 'get_message(status));
         return(status);
      }
      wid=p_window_id;
      for (;;) {
         if (close_buffer(1)) break;
         if (wid!=p_window_id) break;
      }
      //while (!close_buffer()) ;
   }
   return(0);
}
_command delete_all() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   _lbclear();
}
_command link_window() name_info(','VSARG2_MARK|VSARG2_ICON|VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   return(list_buffers('l'))
}

int _OnUpdate_list_buffers(CMDUI &cmdui,int target_wid,_str command)
{
   Nofbuffers=_Nofbuffers(2);
   adjust=0
   if ( _mdi.p_child.p_buf_flags&HIDE_BUFFER ) {
      adjust=1;
   }
   if ( Nofbuffers-adjust>0) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command list_buffers() name_info(','VSARG2_EDITORCTL|VSARG2_REQUIRES_MDI)
{
   if (p_window_id==_mdi) {
      p_window_id=_mdi.p_child;
   }
   if (!p_mdi_child && !p_isbutton_bar) {
      return(1);
   }
   link_window='';
   title=nls('Select a Buffer')
   if (arg(1)!='') {
      link_window='-w '
      title=nls('Link Window')
   }
   p_window_id=_mdi.p_child;
   _macro_delete_line()
    gstart_buf_id=p_buf_id
    orig_view_id=_create_temp_view(temp_view_id);
    if (orig_view_id=='') return(1);
    if (link_window!='') {
       buttons=nls('&Link to Window,&Open File,&Start Process')
       help_item='Link Window dialog box'
    } else {
       if ( lowcase(def_keys)=='brief-keys' ) {
          buttons=nls('&Edit,&Write,&Delete')
       } else {
          buttons=nls('&Edit,&Save,&Close,&Order')
       }
       help_item='Select a Buffer dialog box'
    }
    lb_nls_chars=nls_selection_chars(buttons)
    _build_buf_list(width,p_buf_id,false,gstart_buf_id);
    if ( p_Noflines==0 ) {
       _delete_temp_view(temp_view_id);
       activate_view orig_view_id
       _set_focus();_message_box(nls('Buffer list empty'))
       return(1)
    }
    buflist=def_buflist;
#if 1
    result=show('_sellist_form -mdi -modal -reinit',
                title,
                SL_VIEWID|SL_SELECTCLINE|SL_NOISEARCH|SL_DEFAULTCALLBACK,
                temp_view_id,
                buttons,
                help_item,        // help item name
                '',                    // font
                _list_buffers_callback   // Call back function
               );
#else
    result=show('_sellist_form -mdi -modal -reinit',
                title,
                SL_VIEWID|SL_SELECTCLINE|SL_DEFAULTCALLBACK,
                temp_view_id,
                buttons,
                help_item,        // help item name
                '',                    // font
                _list_buffers_callback,   // Call back function
                '',                       // Item list separator
                'list_buffers',           // retrieve form name
                '',                       // combo box completion property value
                '',                       // Minimum list width
                '',                       // Combo box initial value
                3                         // Number of leading characters to skip over when searching
               );
#endif
    def_buflist=buflist
    if (result=='') {
       return(COMMAND_CANCELLED_RC);
    }
    if (result==_chr(0)) {
       /* Start Process or Open File button pressed.  Work done.*/
       return(0);
    }
    _macro('m',_macro('s'))
    delete_buffer_id='';
    p_window_id=_mdi.p_child;
    // IF we are doing a link window AND
    //    we are in one file per window AND
    //    this is the last window viewing this buffer AND
    //    and it is not a keep on quit buffer (stay residen buffer).
    if (link_window!="" && def_one_file!='' && _islast_window() && !(p_buf_flags&KEEP_ON_QUIT)) {
       delete_buffer_id=p_buf_id;
       status=_window_quit(1/* support KEEP_ON_QUIT*/,1 /*Save position.*/,
                           ''/* Don't support hidden windows. */,
                           1 /* Just save buffer. */
                           );
       if (status) {
          return(status);
       }
    }
    if (_isno_name(result)){
       parse result with '<' buf_id'>';
       _macro('m',_macro('s'));
       _macro_call('edit',link_window'+bi 'buf_id);
       status=edit(link_window'+bi 'buf_id);
       if ( ! status ) {
          p_buf_flags=p_buf_flags & (~HIDE_BUFFER);
       }
#if 0
       status=edit('+bi 'buf_id)
        status=edit('+b 'result)
       _macro_append('p_buf_id=buf_id')
#endif
    } else {
        _macro('m',_macro('s'));
        _macro_call('edit',link_window'+b 'result);
        status=edit(link_window'+b 'result)
        if ( ! status ) {
           p_buf_flags=p_buf_flags & (~HIDE_BUFFER)
        }
    }
    if (!status) {
       if (p_window_state=='I') p_window_state='N';
       // IF we need to delete original buffer AND
       //    this
       if (delete_buffer_id!='' && p_buf_id!=delete_buffer_id) {
          buf_id=p_buf_id;
          p_buf_id=delete_buffer_id;
          _delete_buffer();
          p_buf_id=buf_id;
       }
    }
    return(status);
}
/* This procedure does not duplicate the buffer's margins, tabs, undo steps, */
/* etc. and thats why this procedure has not been made global yet. */
static _str duplicate_buffer()
{
   mark=_alloc_selection()
   if ( mark<0 ) {
      return(mark);
   }
   top;_select_line mark
   bottom;_select_line mark
   load_files arg(1)' +t'
   if ( rc ) {
      _free_selection mark
      return(rc)
   }
   _delete_line
   status=_copy_to_cursor(mark)
   _free_selection mark
   return(status)

}
/*static*/ _str _buflist_name(result)
{
   result=substr(result,BUFFER_COL)
   if ( def_buflist&SEPARATE_PATH_FLAG ) {
      if (_isno_name(result)) {
         return(result);
      }
      parse result with name'<'path'>'
      if ( path!='' ) {
         result=path:+strip(name)
      }
   }
   return(result)


}
static _str build_buf_name(match_name)
{
   if ( (def_buflist&SEPARATE_PATH_FLAG) &&
      (_dbcsSubstr(match_name,2,1)==':' || substr(match_name,1,1)==FILESEP) ) {
      line=field(strip_filename(match_name,'P'),13)'<'strip_filename(match_name,'N')'>'
   } else {
      line=match_name
   }
   return(line);
}
void _build_buf_list(int &width,int temp_buf_id,boolean list_modified=false,int start_buf_id=-1)
{
   _safe_hidden_window();
   list_modified=arg(3)
   allow_system_buffers=(def_buflist&SHOW_SYSTEM_BUFFERS_FLAG)
   width=0;
   if (start_buf_id<0) {
      start_buf_id=_mdi.p_child.p_buf_id;
   }
   load_files('+bi 'start_buf_id);
   for (;;) {
      // Skip over Delphi buffers:
      skipBuf = 0;
      if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
         if ( list_modified && delphiIsRunning() &&
              delphiIsBufInDelphi(p_buf_name) ) {
            skipBuf = 1;
         }
      }
      if ( !skipBuf && (p_buf_id!=temp_buf_id) ) {
         if (p_DocumentName!='') {
            match_name=p_DocumentName;
         } else {
            match_name=p_buf_name;
         }
         modify=p_modify
         if (match_name=='') {
            match_name=NO_NAME:+p_buf_id'>'
         }
         if (!list_modified ||
              (modify &&  _need_to_save())
            ) {
            if ( modify ) {
               modify=' *'
            } else {
               modify=''
            }
            line=build_buf_name(match_name)
            is_hidden=(p_buf_flags&HIDE_BUFFER)
            if ( ! is_hidden || allow_system_buffers) {
               if ( is_hidden ) {
                  modify=modify:+'H'
               }
               buf_id=p_buf_id
               p_buf_id=temp_buf_id
               insert_line substr(modify,1,BUFFER_COL-1):+ strip(line,'L')
               p_buf_id=buf_id
               if ( length(line)>width ) { width=length(line) }
            }

         }
      }
      _next_buffer('NRH');
      if ( p_buf_id==start_buf_id ) {
         break
      }
   }
   p_buf_id=temp_buf_id
   if ( def_buflist&SORT_BUFLIST_FLAG && !_on_line0()) {
      mark=_alloc_selection()
      if ( mark>=0 ) {
         top;p_col=BUFFER_COL;_select_block mark
         bottom;p_col=255;_select_block mark
         old_mark=_duplicate_selection('')
         _show_selection mark
         sort_on_selection('I' /* _fpos_case */)
         _show_selection old_mark
         _free_selection mark
         top();
      }
   }
   next=1
   for (i=1; i<=p_Noflines ; ++i) {
      p_line=next
      get_line line
      modify=substr(line,1,BUFFER_COL-1)
      new_modify=substr(stranslate(modify,'','H'),1,BUFFER_COL-1)
      if ( pos('H',modify) || (substr(line,BUFFER_COL,1)=='.' && (def_buflist&SORT_BUFLIST_FLAG)) ) {
         _delete_line
         bottom;insert_line new_modify:+ substr(line,BUFFER_COL)
      } else {
         replace_line new_modify:+ substr(line,BUFFER_COL)
         next=next+1
      }
   }
}
_str _lbmulti_select_result()
{
   create_list_option= arg(1)!=''
   cwd=arg(2)
   isfileman_list=arg(3)!=''
   result=''
   status=_lbfind_selected(1);
   for (;;) {
      if (status) break;
      if (isfileman_list) {
         get_line line
         text=pcfilename(line)
      } else {
         text=maybe_quote_filename(_lbget_text())
      }
      if (cwd!='') {
         text=_absolute2(text,cwd)
      }
      if ( length(result)+length(text)>MAX_LINE-50 || create_list_option) {
         if (_macro('s')) {
            _message_box('Sorry, keyboard macro recording does not support large selections yet.')
            result='';
            break;
         }
         status=duplicate_buffer()
         if ( status ) {
            _message_box(nls('Selection list could not return parameters')'. 'get_message(status))
            result=''
            break
         }
         if (isfileman_list) {
            /* remove the data to the left of the filename */
            mark=_alloc_selection()
            if (mark<0) {
               _delete_buffer
               _message_box(get_message(TOO_MANY_SELECTIONS_RC));
               result='';
               break;
            }
            top();p_col=2;_select_block mark;
            bottom;p_col=DIR_FILE_COL-1;_select_block mark
            _delete_selection mark
            _free_selection mark
         }
         p_buf_flags=p_buf_flags|THROW_AWAY_CHANGES
         /* remove non-selected lines */
         top
         process_list('psearch','^ ','R*@','psearch','zap-line')
         top
         search '^>','*r@',' '
         // Put quotes around selections with spaces.
         top
         search '^ {?* ?*$}','*r@',' #0'
         if (cwd!='') {
            top;up()
            for(;;){
               down();
               if (rc) break;
               get_line line
               replace_line ' '_absolute2(strip(line),cwd)
            }
         }
         buf_id=p_buf_id
         // If there is an existing temp list, get rid of it
         temp_name=absolute(TEMP_LIST)
         status=load_files('+q +b 'temp_name)
         if (!status) {
            _delete_buffer;
            p_buf_id=buf_id;
         }
         p_buf_name=temp_name
         result='@'p_buf_name
         _prev_buffer 'h'
         break
      }
      result=result" "text
      status=_lbfind_selected(0);
   }
   return(result)
}
static void restore_view(list_view_id,temp_view_id)
{
   _delete_temp_view(temp_view_id,0);
   activate_view(list_view_id);
}
_save_non_active(var buf_name)
{
   quit_option=arg(2);
   if (_isno_name(buf_name)) {
      parse buf_name with '<' buf_id'>';
      status=_open_temp_view('',temp_view_id,list_view_id,'+bi 'buf_id);
      //status=load_files('+bi 'buf_id);
   } else {
      status=_open_temp_view(buf_name,temp_view_id,list_view_id,"+b");
      //status=load_files('+b 'buf_name);
   }
   if ( status ) {
      return(status)
   }
   if (quit_option=='' && lowcase(def_keys)=='brief-keys' && ! p_modify ) {
      restore_view(list_view_id,temp_view_id);
      _message_box(nls('File not modified.  Nothing saved.'))
      return(1);
   }
   if ( quit_option=='' ||
        (p_modify && ! (p_buf_flags&THROW_AWAY_CHANGES))) {  /* file modified? */
      result=IDYES;
      if (quit_option!='') {
         activate_view(list_view_id);
         result=_message_box(nls("Save changes to '%s'?",buf_name),'',MB_ICONQUESTION|MB_YESNOCANCEL)
         if (result==IDCANCEL) {
            restore_view(list_view_id,temp_view_id);
            return(1);
         }
      }
      if (result==IDYES) {
         if (_isno_name(buf_name)) {
            parse buf_name with '<' buf_id'>';
            // Give this buffer a name
            activate_view(list_view_id);
            result=_OpenDialog(_stdform('_open_form')' -mdi -new -modal',
                 'Save As',
                 '',   /* Initial wildcards */
                 //'*.c;*.h',
                 def_file_types,
                 OFN_SAVEAS|OFN_DELAYFILELIST,
                 '',      // Default extensions
                 '',      // Initial filename
                 '',      // Initial directory
                 ''       // Reserved
                 )
            if (result=='') {
               restore_view(list_view_id,temp_view_id);
               return(COMMAND_CANCELLED_RC);
            }
            activate_view(temp_view_id);
            name(result);
            p_buf_flags=p_buf_flags& ~PROMPT_REPLACE_BFLAG
            buf_name=p_buf_name;
         }
         activate_view(temp_view_id);
         if ((p_buf_flags & PROMPT_REPLACE_BFLAG) &&
              file_match('-p 'buf_name,1)!='') {
            activate_view list_view_id
            status=overwrite_existing(buf_name,'Save')
            if ( status ) {
               restore_view(list_view_id,temp_view_id);
               return(status)
            }
         }
         activate_view(temp_view_id);
         status=save('',SV_RETURNSTATUS);
         if (status) {
            activate_view(list_view_id);
            _save_status(status,buf_name);

            restore_view(list_view_id,temp_view_id);
            return(status)
         }
      }
      activate_view(temp_view_id);
      p_modify=0;
   }
   activate_view(temp_view_id);
   if (quit_option!='') {
      if (def_one_file!='') {
         // Delete all mdi windows which are displaying this buffer.
         count=0;
         wid=window_match(p_buf_name,1,'xn')
         for (;;) {
            if (!wid) break;
            if (wid.p_mdi_child) ++count;
            wid=window_match(p_buf_name,0,'xn')
         }
         if (count>=1) {
            buf_name=p_buf_name;
            wid=window_match(buf_name,1,'xn')
            while (count--) {
               // If deleting last window
               if (wid.p_mdi_child) {
                  if (!count) {
                     // Delete the window and the buffer
                     wid.close_window('','');
                  } else {
                     // Delete the window and not the buffer.
                     wid._delete_window();
                  }
               }
               wid=window_match(buf_name,0,'xn')
            }
         } else {
            close_buffer('',0 /* allow delete if hidden */);
         }
      } else {

         quit('',0 /* allow delete if hidden */);
      }
   }
   restore_view(list_view_id,temp_view_id);
   return(0)
}
boolean _isno_name(name)
{
   return(substr(name,1,length(NO_NAME))==NO_NAME);
}
_str _build_buf_name()
{
   if (p_buf_name:!='') {
      return(p_buf_name);
   }
   return(NO_NAME:+p_buf_id'>');
}
_str _build_buf_name2(buf_name,buf_id)
{
   if (buf_name:!='') {
      return(buf_name);
   }
   return(NO_NAME:+buf_id'>');
}
_command list_modified() name_info(','VSARG2_REQUIRES_MDI)
{
   p_window_id=_mdi.p_child;
   _macro_delete_line()
    gstart_buf_id=p_buf_id
    orig_view_id=_create_temp_view(temp_view_id);
    if (orig_view_id=='') return(1);
    title=arg(1)
    if ( title=='' ) {
      title=nls('Modified Buffers')
    }
    _build_buf_list(width,p_buf_id,1,gstart_buf_id);
    if ( p_Noflines==0 ) {
       _delete_temp_view();
       activate_view orig_view_id
       if (_executed_from_key_or_cmdline('list-modified')) {
          message nls('No buffers are modified.')
       }
       return(0)
    }
    buttons=nls('Save &All,&Save Selected:btnsave_selected,&Invert,Save &None')
    lb_nls_chars=nls_selection_chars(buttons)
    buflist=def_buflist

    activate_view(orig_view_id);
    result=show('_sellist_form -mdi -modal',
                title,
                SL_VIEWID|SL_ALLOWMULTISELECT|SL_NOISEARCH|
                SL_DEFAULTCALLBACK,
                temp_view_id,
                buttons,
                "Modified Buffers dialog box",        // help item name
                '',             // font
                _list_modified_ft   // Call back function
               );
    def_buflist=buflist;
    if ( result=='' ) {
       message 'command cancelled'
       return(COMMAND_CANCELLED_RC)
    }
    switch (result) {
    case 1:
       p_window_id=_mdi.p_child;
       return(save_all())
    default:
       if (substr(result,1,1)=='@') {
          _TagDelayCallList();
          p_window_id=_mdi.p_child;
          orig_buf_id=p_buf_id;
          get_view_id mdi_view_id
          was_hidden_window=0
          if (p_window_flags &HIDE_WINDOW_OVERLAP) {
             was_hidden_window=1
          }
          activate_view HIDDEN_VIEW_ID
          load_files '+c +b 'substr(result,2);
          p_buf_flags=p_buf_flags | HIDE_BUFFER;
          get_view_id list_view_id

          top();up();
          for (;;) {
             down();
             if (rc) break;
             get_line buf_name
             activate_view mdi_view_id
             if (_isno_name(buf_name)) {
                parse buf_name with '<' buf_id'>'
                status=edit('+q +bi 'buf_id)
             } else {
                status=edit('+q +b 'buf_name)
             }
             if ( status ) {
                activate_view list_view_id
                _delete_buffer;_quit_view;
                p_window_id=_mdi.p_child;_set_focus();
                _message_box(nls("Unable to active file '%s'\n",buf_name)get_message(status));
                _TagProcessCallList();
                return(status)
             }
             if (!was_hidden_window) {
                activate_view mdi_view_id
             } else {
                was_hidden_window=0;
                get_view_id mdi_view_id
             }
             status=save();
             if ( status ) {
                get_view_id view_id
                activate_view list_view_id
                _delete_buffer;_quit_view;
                activate_view view_id
                   _TagProcessCallList();
                return(status)
             }
             activate_view list_view_id
          }
          _delete_buffer;_quit_view;
          p_window_id=_mdi.p_child;
          p_buf_id=orig_buf_id;
          _TagProcessCallList();
       }
    }
    /*
        Retag files that were not saved.
    */
    status=_open_temp_view('',temp_view_id,orig_view_id,'+bi '_mdi.p_child.p_buf_id);
    if (status) {
       return(0);
    }
    _TagDelayCallList();
    first_buf_id=p_buf_id;
    for (;;) {
       _next_buffer('NHR');
       if (
           !(p_buf_flags&HIDE_BUFFER) && 
            (p_ModifyFlags&MODIFYFLAG_TAGGED) &&  
             (p_modify)
           ) {
          _cbquit_maybe_retag();
       }
       if (p_buf_id==first_buf_id) break;
       // The +m option preserves the old buffer position information for the current buffer
    }
    _delete_temp_view(temp_view_id,0 /* Don't delete buffer*/);
    activate_view(orig_view_id);
    _TagProcessCallList();

    return(0);
}


void _BufCreateTempView(int buf_id,int &TempViewId, int &OrigViewId)
{
   _open_temp_view("",TempViewId,OrigViewId,"+bi "buf_id);
}
void VSAPI _BufDeleteTempView(int TempViewId,int OrigViewId)
{
   _delete_temp_view(TempViewId,0);
   activate_view(OrigViewId);
}

/*
    Use this function to check if you need to save an 
    MDI buffer or an editor control buffer.
*/
boolean _need_to_save2(...)
{
   buf_name=arg(1);
   TestModify=arg(2)!='' && arg(2);
   if (buf_name!="") {
      parse buf_match(buf_name,1,'HEV') with buf_id ModifyFlags buf_flags buf_name;
      if (buf_id=='') {
         // Buffer was not found.
         return(0);
      }
      _BufCreateTempView(buf_id,temp_view_id,orig_view_id);
      status=_need_to_save2('',TestModify);
      _BufDeleteTempView(temp_view_id,orig_view_id);
      return(status);
	
   }
   return((!TestModify || p_modify) && (p_AllowSave || _need_to_save()));
}
/*
   Use this function if you only want to check for MDI
   buffers.  
*/
boolean _need_to_save()
{
   return(
          !(p_buf_flags&(THROW_AWAY_CHANGES|HIDE_BUFFER))&&
             !_modename_eq(p_mode_name,'FILEMAN') &&
            substr(p_buf_name,1,1)!='.'
   )
}
_str _font_param(_str font_name,_str font_size,_str font_flags)
{
   return(font_name','font_size','font_flags','arg(4))
}
