/*
$VerboseHistory: smartp.e$
*/
/*
   Smart Paste (tm)

*/
#include "slick.sh"

_str def_csmart_paste=1;
_str def_pas_smartpaste=1;

#define STYLE1_FLAG 1
#define STYLE2_FLAG 2
#define BRACE_INSERT_FLAG 4
#define BRACE_INSERT_LINE_FLAG 8
#define MAX_PASTE 400       /* Don't adjust paste of more than 400 lines. */
#define MAX_PASTE_BYTES (MAX_PASTE*32)   /* Don't adjust paste of more than 400*32 bytes. */

int smart_paste()
{
   _EmbeddedStart(orig_values,'');
   status=smart_paste2(arg(1),arg(2),arg(3));
   _EmbeddedEnd(orig_values);
   return(status);
}
static int smart_paste2()
{
   markid=arg(1);
   copymove_option=arg(2);
   reserved=arg(3);
   if( def_keys=='vi-keys' ) {
      if( upcase(vi_get_vi_mode())=='C' ) {
         etab_name=vi_name_on_key('','IK');
      } else {
         etab_name=name_name(p_mode_eventtab);
      }
   } else {
      etab_name=name_name(p_mode_eventtab);
   }
   //etab_name=name_name(p_mode_eventtab)
   parse name_info(_edit_window().p_index) with . expand .;
   syntax_indent=p_SyntaxIndent;
   if (copymove_option!='') {
      if (_select_type(markid)=='') {
         message(get_message(TEXT_NOT_SELECTED_RC));
         return(TEXT_NOT_SELECTED_RC);
      }
      if (p_hex_mode || syntax_indent<=0 || p_indent_style!=INDENT_SMART ||
           copy_too_large(markid)>MAX_PASTE ||
          _select_type(markid)=='BLOCK' ||
          (_select_type(markid)=='CHAR' && 
            (!SupportCharSelection(markid) || !pasting_at_blanks())
          ) ||
          smart_in_comment()) {
         lock_selection(1);
         if (upcase(copymove_option)=='M') {
            status=_move_to_cursor(markid);
         } else {
            status=_copy_to_cursor(markid);
         }
         return(status);
      }
      _get_selinfo(start_col,end_col,junk,markid);
      if (def_csmart_paste && (etab_name=='c-keys' || etab_name=='slick-keys' || etab_name=='awk-keys' || etab_name=='perl-keys' )) {
         return(c_smart_paste(markid,copymove_option,"",reserved,start_col));
      }
      if (def_pas_smartpaste && (etab_name=='pascal-keys')) {
         return(pas_smart_paste(markid,copymove_option,"",reserved,start_col));
      }
      ext=p_extension;
      index=find_index('def_'ext'_smartpaste',VAR_TYPE);
      if (index && _get_var(index)) {
         return(ext_smartpaste(markid,copymove_option,"",reserved,start_col,ext));
      }
      if (upcase(copymove_option)=='M') {
         status=_move_to_cursor(markid);
      } else {
         status=_copy_to_cursor(markid);
      }
      return(status);
   }
   temp_view_id=_cvtsysclipboard(1);
   if (p_hex_mode || syntax_indent<=0 || p_indent_style!=INDENT_SMART ||
       !_isclipboard_internal(1) || clipboard_iNoflines(temp_view_id)>MAX_PASTE ||
       clipboard_itype(temp_view_id)=='BLOCK' ||
       (clipboard_itype(temp_view_id)=='CHAR' && 
          (!SupportCharSelection2(temp_view_id) || !pasting_at_blanks())
          //(clipboard_iNoflines(temp_view_id)==1 || !pasting_at_blanks())
        ) ||
       smart_in_comment()) {
      return(paste2(def_persistent_select,temp_view_id,reserved));
   }
   if (def_csmart_paste && (etab_name=='c-keys' || etab_name=='slick-keys' || etab_name=='awk-keys' || etab_name=='perl-keys')) {
      return(c_smart_paste(markid,copymove_option,temp_view_id,reserved,clipboard_col(temp_view_id)));
   }
   if (def_pas_smartpaste && (etab_name=='pascal-keys')) {
         return(pas_smart_paste(markid,copymove_option,temp_view_id,reserved,clipboard_col(temp_view_id)));
   }
   ext=p_extension;
   index=find_index('def_'ext'_smartpaste',VAR_TYPE);
   if (index && _get_var(index)) {
      return(ext_smartpaste(markid,copymove_option,"",reserved,start_col,ext));
   }
   return(paste2(def_persistent_select,temp_view_id,reserved));
}
static int copy_too_large(markid)
{
   orig_buf_id=p_buf_id
   _get_selinfo(start_col,end_col,buf_id,markid);
   p_buf_id=buf_id;
   save_pos(orig_pos);
   _begin_select(markid);
   bpoint=point();
   _end_select(markid);
   epoint=point();
   restore_pos(orig_pos);
   p_buf_id=orig_buf_id;
   parse epoint with epoint .;
   parse bpoint with bpoint .;
   if (epoint-bpoint>MAX_PASTE_BYTES) {
      return(1);
   }
   return(0)
}

static boolean SupportCharSelection(markid)
{
   orig_buf_id=p_buf_id
   _get_selinfo(start_col,end_col,buf_id,markid);
   p_buf_id=buf_id;
   save_pos(orig_pos);
   _end_select(markid);
   save_pos(begin_pos);
   beginendcmp=_begin_select_compare(markid)+_end_select_compare(markid);
   end_col+=(_select_type(markid,'i'))?0:-1;
   support=0;
   // IF start and end selection are on the same line
   if (beginendcmp==0) {
      // Require the EOL character to be selected
      len=_text_colc(0,'L');
      if (end_col>len) {
         support=1;
      }
   } else {
      // Require that only leading blanks be selected on last line
      if (_expand_tabsc(1,end_col,'s')==' ') {
         support=1;
      }
   }
   restore_pos(orig_pos);
   p_buf_id=orig_buf_id
   return(support);
}
static boolean SupportCharSelection2(int temp_view_id)
{
   get_view_id(orig_view_id);
   Noflines=clipboard_iNoflines(temp_view_id);
   activate_view(temp_view_id);
   if (Noflines<=1) {
      activate_view(orig_view_id);
      return(0);
   }
   save_pos(orig_pos);
   down(Noflines);
   support=0;
   // Require that last line be all blanks
   if (_expand_tabsc(1,-1,'s')=='') {
      support=1;
   }
   restore_pos(orig_pos);
   activate_view(orig_view_id);
   return(support);
}
static boolean pasting_at_blanks()
{
   get_line(line);
   if (line=="") {
      return(1);
   }
   save_pos(p);
   orig_col=p_col;
   _begin_line;//_refresh_scroll();
   first_non_blank();
   all_blanks=(orig_col<=p_col);
   restore_pos(p);
   return(all_blanks);
}
_str _skip_pp
static int c_smart_paste(markid,copymove_option,temp_view_id,reserved,int first_col)
{
   if (markid!='') {
      cur_markid=_duplicate_selection('');
      _show_selection(markid);
      status=c_smart_paste2(copymove_option,temp_view_id,reserved,first_col);
      _show_selection(cur_markid);
      return(status);
   }
   return(c_smart_paste2(copymove_option,temp_view_id,reserved,first_col));
}
static int c_smart_paste2(copymove_option,temp_view_id,reserved,int first_col)
{
   dest_col=p_col;
   old_deselect_paste=def_deselect_paste;
   if (copymove_option!='') {
      char_cbtype=_select_type()=='CHAR';
      Noflines=count_lines_in_selection();
      if (upcase(copymove_option)=='M') {
         status=_move_to_cursor();
      } else {
         status=_copy_to_cursor();
      }
      if (status) {
         return(status);
      }
      if (char_cbtype) --Noflines;
   } else {
      char_cbtype=clipboard_itype(temp_view_id)=='CHAR';
      Noflines=clipboard_iNoflines(temp_view_id);
      def_deselect_paste=0;
      status=paste2(def_persistent_select,temp_view_id,reserved);
      if (status) {
         if (old_deselect_paste!=def_deselect_paste) {
            deselect();def_deselect_paste=old_deselect_paste;
         }
         return(status);
      }
      if (char_cbtype) --Noflines;
   }
   // Save position by line number.
   _save_pos2(p);
   orig_col=p_col;
   // Check first non source blank word/character of what was pasted to
   // see if it is a } or "case".
   _begin_select;_begin_line();
   comment_col='';
   //If pasted stuff starts with comment and indent is different than code,
   // do nothing.
   // Find first non-blank line
   save_pos(p4);
   for (j=1;j<=Noflines;++j) {
      get_line(first_line);
      i=verify(first_line,' '\t);
      if ( i ) {
         p_col=text_col(first_line,i,'I');
      }
      if (i) {
         break;
      }
      if(down()) {
         break;
      }
   }
   comment_col=p_col;
   if (j>1) {
      restore_pos(p4);
   }

   // Look for first piece of code not in a comment
   status=_clex_skip_blanks('m');
   // IF (no code found /*AND pasting comment */AND comment does not start in column 1) OR
   //   (code found AND pasting comment AND code col different than comment indent)
   //  OR  first non-blank code of pasted stuff is preprocessing 
   //  OR first non-blank pasted line starts with non-blank AND 
   //     (not pasting character selection OR copied text from column 1)
   if ((status /*&& comment_col!='' */&& comment_col<=1) 
       || (!status && comment_col!='' && p_col!=comment_col)
       || (!status && get_text()=='#') 
       || (substr(first_line,1,1)!='' && (!char_cbtype ||first_col<=1))
       ) {
      if (old_deselect_paste!=def_deselect_paste) {
         deselect();
         def_deselect_paste=old_deselect_paste;
      }
      //messageNwait('give up status='status' comment_col='comment_col);
      _restore_pos2(p);
      return(0);
   }
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .;
   syntax_indent=p_SyntaxIndent;
   
   if (!status && (cur_word(junk)=='case' || cur_word(junk)=='default')) {
      // IF pasting stuff contains code AND first word of code is case or default
      /* Indent case based on indent of switch. */
      col=_c_last_switch_col();
      if ( col ) {
         // indent_case=='' means we are editting a Slick-C file.
         if ((indent_case && indent_case!='') || (be_style&STYLE2_FLAG)) {
            enter_col=col+syntax_indent
         } else {
            enter_col=col;
         }
         _begin_select;up();
      } else {
         status=1;
      }
#if 0
      if (i)
         {
         }

      else
         else


      else
         {

         }

      {

      } else ++i;
      do
         {

         }
      while (  );


#endif
   } else if (!status && get_text()=='}') {
      // IF pasting stuff contains code AND first char of code }
      ++p_col;
      enter_col=c_endbrace_col(be_style);
      if (!enter_col) {
         enter_col='';
      }
      _begin_select;up();
   } else {
      /*  Need to know if we are pasting an open brace. */
      pasting_open_brace2=false;
      // The new c_enter_col always wants to know if we are 
      // pasting and open brace.
      if (!status && get_text()=='{' /*&& (be_style & STYLE1_FLAG)*/) {
         pasting_open_brace2=true;
      }
      _begin_select;up();
      _end_line
      _skip_pp=1;
      enter_col=c_enter_col(pasting_open_brace2);
      _skip_pp='';
      status=0;
   }
   //IF no code found/want to give up OR ... OR want to give up 
   if (status || enter_col==1 || enter_col=='' ) {
      if (old_deselect_paste!=def_deselect_paste) {
         deselect();def_deselect_paste=old_deselect_paste;
      }
      _restore_pos2(p);
      return(0);
   }
   if (char_cbtype) {
      // Remove leading blanks inserted into last line
      typeless p2;
      save_pos(p2);
      _end_select();
      Nofcols=p_col+(_select_type('','i')?0:-1);
/*
      first_non_blank();Nofcols2=p_col-1;
      // IF the last line of the character selection pasted has non-blank text
      if (Nofcols2<Nofcols) {
         Nofcols=0;
      }
      messageNwait("Nofcols="Nofcols);
*/
      if (Nofcols) {
         _begin_line();_delete_text(Nofcols,'C');
      }
      restore_pos(p2);
   }
   down();
   save_pos(p4);
   for (i=1;i<=Noflines;++i) {
      get_line(line);
      if (line!='') {
         break;
      }
      down();
   }
   if (i<=Noflines) {
      first_non_blank();
      if (p_col!=enter_col) {
         adjust_col=enter_col-p_col;
         restore_pos(p4);
         for (i=1;i<=Noflines;++i) {
            get_line(line);
            line=reindent_line(line,adjust_col);
            // IF line just constists of blanks and tab characters
            if (line=='') line='';
            replace_line(line);
            down();
         }
      } else {
         down(Noflines-i+1);
      }
   }
   if (char_cbtype && dest_col>1) {
      get_line(line);
      line=reindent_line(line,dest_col-1);
      if (line=='') line='';
      replace_line(line);
      /*first_non_blank();
      NofLeadingBlankCols=p_col+paste_col;*/
   }
   if (old_deselect_paste!=def_deselect_paste) {
      deselect();
      def_deselect_paste=old_deselect_paste;
   }
   _restore_pos2(p);
   return(status)

}
static c_enter_col(pasting_open_brace2)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      c_enter_col2(enter_col,p_SyntaxIndent,expand,be_style,indent_fl,indent_case,pasting_open_brace2) ) {
      return('');
   }
   return(enter_col);
}


static _str c_enter_col2(var enter_col,syntax_indent,expand,be_style,indent_fl,indent_case,pasting_open_brace2)
{
   enter_col='';
   status=0
   status=c_get_info(Noflines,cur_line,first_word,last_word,rest,
              non_blank_col,semi,prev_semi,1)
   if (status) return(1);
   style1=be_style & STYLE1_FLAG
   style2=be_style & STYLE2_FLAG
   parse cur_line with line '/*' /* Strip comment on current line. */
   parse line with line '//' /* Strip comment on current line. */
   //For now give up if the previous line ended in comma
   if (last_char(strip(line))==',') {
      return(0);
   }
   if ( expand && ! Noflines ) {
      if ( first_word=='main' && rest=='' ) {
         return(1);
      } else if ( (first_word=='case' || first_word=='default')) {
         enter_col=non_blank_col+syntax_indent;
         return(0);
      } else if ( first_word=='switch' && last_word=='{' ) {
         if ((indent_case && indent_case!='') || (be_style&STYLE2_FLAG)) {
            enter_col=non_blank_col+syntax_indent;
            return(0);
         }
         enter_col=non_blank_col;
         return(0);
     } else if (first_word=='extern' && last_word=='{' && pos('"C"',cur_line,1,'i')) {
        return(0);
     } else {
        status=1
     }
   } else {
     status=1
   }
   if ( status ) {  /* try some more? Indenting only. */
      status=0;
      _end_line
      if (p_col<non_blank_col+1) {
         p_col=non_blank_col+1;
      }
      enter_col=c_indent_col(non_blank_col,pasting_open_brace2)
   }
   return(status)

}

/* Check if the first character of next line is in multi line comment. */
static smart_in_comment()
{
   status=down();
   if (status) {
      return(0);
   }
   _clex_find(0,'g');  // Refresh line flags for multi-line comments
   flags=_lineflags();
   up();
   // If we are in a multi line comment from the previous line.
   //    or embedded language
   if ((flags & COMMENTINFOMASK_LF) || 
       ((flags & EMBEDDEDLANGAUGEMASK_LF) && _default_option(VSOPTION_EMBEDDED)!=VSEMBEDDED_ONLY)
      ) {
      return(1);
   }
   return(0);

}
static int pas_smart_paste(markid,copymove_option,temp_view_id,reserved,first_col)
{
   if (markid!='') {
      cur_markid=_duplicate_selection('');
      _show_selection(markid);
      status=pas_smart_paste2(copymove_option,temp_view_id,reserved,first_col);
      _show_selection(cur_markid);
      return(status);
   }
   return(pas_smart_paste2(copymove_option,temp_view_id,reserved,first_col));
}
static int pas_smart_paste2(copymove_option,temp_view_id,reserved,int first_col)
{
   dest_col=p_col;
   old_deselect_paste=def_deselect_paste;
   if (copymove_option!='') {
      char_cbtype=_select_type()=='CHAR';
      Noflines=count_lines_in_selection();
      if (upcase(copymove_option)=='M') {
         status=_move_to_cursor();
      } else {
         status=_copy_to_cursor();
      }
      if (status) {
         return(status);
      }
   } else {
      char_cbtype=clipboard_itype(temp_view_id)=='CHAR';
      Noflines=clipboard_iNoflines(temp_view_id);
      def_deselect_paste=0;
      status=paste2(def_persistent_select,temp_view_id,reserved);
      if (status) {
         if (old_deselect_paste!=def_deselect_paste) {
            deselect();def_deselect_paste=old_deselect_paste;
         }
         return(status);
      }
      if (char_cbtype) --Noflines;
   }
   // Save position by line number.
   _save_pos2(p);
   orig_col=p_col;
   _begin_select;_begin_line();

   comment_col='';
   //If pasted stuff starts with comment and indent is different than code,
   // do nothing.
   get_line first_line
   i=verify(first_line,' '\t);
   if ( i ) p_col=text_col(first_line,i,'I');
   if ( first_line!='' && _clex_find(0,'g')==CFG_COMMENT) {
      comment_col=p_col;
   }

   comment_col=p_col;
   // Look for first piece of code not in a comment
   status=_clex_skip_blanks('m');
   // IF (no code found AND pasting comment) OR
   //   (code found AND pasting comment AND code col different than comment indent)
   if ((status && comment_col!='') || (!status && comment_col!='' && p_col!=comment_col)) {
      if (old_deselect_paste!=def_deselect_paste) {
         deselect();
         def_deselect_paste=old_deselect_paste;
      }
      _restore_pos2(p);
      return(0);
   }

   //messageNwait('got to the beginning of reformatting');
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .;
   syntax_indent=p_SyntaxIndent;
   get_line(myline);
   parse myline with temp '\(\*|\{|//','r';
   //messageNwait("pas_smart_paste2: status="status" myline="temp);
   if (!status && (lastpos('\:([ \t]*begin|)[ \t]*$',temp,length(temp),'ri') && substr(myline,1,1)=="")) {
      /* Indent constant based on indent of case. */
      temp_col=p_col;
      _begin_line();  //set up so last case col will NOT see the begin on the end of the line
      col=_pas_last_case_col();
      p_col=temp_col;
      if ( col ) {
         // indent_case=='' means we are editting a Slick-C file.
         if ((indent_case && indent_case!='')) {
            enter_col=col+syntax_indent
         } else {
            enter_col=col;
         }
         _begin_select;get_line first_line;up();
      } else {
         status=1;
      }
   //first word of paste selection is an end
   } else if (!status && lowcase(cur_word(junk))=='end') {
      //messageNwait('it was an end');
      ++p_col;
      enter_col=pas_endbrace_col(be_style);
      if (!enter_col) {
         enter_col='';
      }
      _begin_select;get_line first_line;up();
   } else if (!status && (lowcase(cur_word(junk))=='var' || lowcase(cur_word(junk))=='type'  ||
      lowcase(cur_word(junk))=='const')) {
      enter_col=_pas_last_prog_col()+syntax_indent;
      _begin_select;get_line first_line;up();

   } else {
      //messageNwait('inside other');
      pasting_open_brace2=''
      _begin_select;get_line first_line;up();
      _end_line
      _skip_pp=1;
      enter_col=pas_enter_col(pasting_open_brace2);
      _skip_pp='';
      status=0;
   }
   //IF no code found/want to give up OR ... OR want to give up OR
   //   first_line of pasted stuff is preprocessing
   if (status || enter_col==1 || enter_col=='' || pos('^[ \t]*\#',first_line,1,'r') ||
      (substr(first_line,1,1)!='' && (!char_cbtype ||first_col<=1))) {
      if (old_deselect_paste!=def_deselect_paste) {
         deselect();def_deselect_paste=old_deselect_paste;
      }
      _restore_pos2(p);
      return(0);
   }
   if (char_cbtype) {
      // Remove leading blanks inserted into last line
      typeless p2;
      save_pos(p2);
      _end_select();
      Nofcols=p_col+(_select_type('','i')?0:-1);
      if (Nofcols) {
         _begin_line();_delete_text(Nofcols,'C');
      }
      restore_pos(p2);
   }
   down();
   for (i=1;i<=Noflines;++i) {
      get_line(line);
      if (line!='') {
         break;
      }
      down();
   }
   if (i<=Noflines) {
      first_non_blank();
      if (p_col!=enter_col) {
         adjust_col=enter_col-p_col;
         for (i=1;i<=Noflines;++i) {
            get_line(line);
            line=reindent_line(line,adjust_col);
            // IF line just constists of blanks and tab characters
            if (line=='') line='';
            replace_line(line);
            down();
         }
      } else {
         down(Noflines-i+1);
      }
   }
   if (char_cbtype && dest_col>1) {
      get_line(line);
      line=reindent_line(line,dest_col-1);
      if (line=='') line='';
      replace_line(line);
      /*first_non_blank();
      NofLeadingBlankCols=p_col+paste_col;*/
   }
   if (old_deselect_paste!=def_deselect_paste) {
      deselect();
      def_deselect_paste=old_deselect_paste;
   }
   _restore_pos2(p);
   return(status)

}

static pas_enter_col(pasting_open_brace2)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl indent_case .;
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      pas_enter_col2(enter_col,p_SyntaxIndent,expand,be_style,indent_fl,indent_case,pasting_open_brace2) ) {
      return('');
   }
   return(enter_col);
}


static typeless pas_enter_col2(var enter_col,syntax_indent,expand,be_style,indent_fl,indent_case,pasting_open_brace2)
{
   //messageNwait('entercol2');
   enter_col='';
   status=0
   status=pascal_get_info(Noflines,cur_line,first_word,last_word,rest,
              non_blank_col,semi,prev_semi,true)

   if (status) return(1);
   lfirst_word=lowcase(first_word);  //account for mixed case keywords
   llast_word=lowcase(last_word);
   parse cur_line with line '(*' /* Strip comment on current line. */
   parse line with line '{' /* Strip comment on current line. */
   //For now give up if the previous line ended in comma
   if (last_char(strip(line))==',') {
      return(0);
   }
   if ( expand && ! Noflines ) {
      if ( lfirst_word=='program' && rest=='' ) {
         return(1);
      } else if (lastpos('[~:]*\:[ \t]*(begin)' ,cur_line,1,'ri')) {
         //messageNwait('got into begin line');
         myline=strip(cur_line)
         parse myline with stuff 'begin','i' +0 junk;
         enter_col=non_blank_col+syntax_indent+length(stuff);
         return(0);
      } else if ( lfirst_word=='case' && llast_word=='of' ) {
         /* This code probably won't matter because */
         if ((indent_case && indent_case!='')) {
            enter_col=non_blank_col+syntax_indent;
            return(0);
         }
         enter_col=non_blank_col;
         return(0);
      } else if (lfirst_word=='var' || lfirst_word=='type' || lfirst_word=='const') { //might want to add label
         enter_col=non_blank_col+syntax_indent;

      } else if (llast_word=='end' || lfirst_word=='end') {
         _save_pos2(p);
         level=0;
         //messageNwait('got to end place');

         //loop around looking for keywords that match the end.  Get the col of the match
         status=search('begin|end|case|for|if|while','@ri-');
         if (status) {
            go=0;
         } else go=1;

         while (go) {
            keyword='';
            color=_clex_find(0,'g');
            if (color==CFG_KEYWORD) {
               keyword=get_text(match_length(),match_length('S'));
               switch (lowcase(keyword)) {
               case 'end':
                  --level;
                  break;
               case 'begin':
                  ++level;
                  break;
               case 'case':
                  ++level;
                  break;
               default:
                  break;
               }
            }
            //messageNwait('keyword: 'keyword' level:'level);
            if (level==0&&(status||keyword=='for'||keyword=='if'||keyword=='while'||keyword=='case')) {
               go=0;  //break out of loop
            } else {
                 status=repeat_search();
                 if (status) {
                    go=0;
                 } else go=1;
            }

         }
         //messageNwait('done...keyword:'keyword);
         enter_col=text_col('',p_col,'P');
         //messageNwait('col:'enter_col);
         _restore_pos2(p);


     } else {
        status=1
     }
   } else {
     status=1
   }
   if ( status ) {  /* try some more? Indenting only. */
      status=0;
      _end_line
      if (p_col<non_blank_col+1) {
         p_col=non_blank_col+1;
      }
      enter_col=pas_indent_col(cur_line,lfirst_word,llast_word,non_blank_col,semi,prev_semi,Noflines,pasting_open_brace2)
   }
   return(status)

}


static int ext_smartpaste(markid,copymove_option,temp_view_id,reserved,first_col,_str ext)
{
   if (markid!='') {
      cur_markid=_duplicate_selection('');
      _show_selection(markid);
      status=ext_smartpaste2(copymove_option,temp_view_id,reserved,first_col,ext);
      _show_selection(cur_markid);
      return(status);
   }
   return(ext_smartpaste2(copymove_option,temp_view_id,reserved,first_col,ext));
}
static int ext_smartpaste2(copymove_option,temp_view_id,reserved,int first_col,_str ext)
{
   dest_col=p_col;
   old_deselect_paste=def_deselect_paste;
   if (copymove_option!='') {
      char_cbtype=_select_type()=='CHAR';
      Noflines=count_lines_in_selection();
      if (upcase(copymove_option)=='M') {
         status=_move_to_cursor();
      } else {
         status=_copy_to_cursor();
      }
      if (status) {
         return(status);
      }
   } else {
      char_cbtype=clipboard_itype(temp_view_id)=='CHAR';
      Noflines=clipboard_iNoflines(temp_view_id);
      def_deselect_paste=0;
      status=paste2(def_persistent_select,temp_view_id,reserved);
      if (status) {
         if (old_deselect_paste!=def_deselect_paste) {
            deselect();def_deselect_paste=old_deselect_paste;
         }
         return(status);
      }
      if (char_cbtype) --Noflines;
   }



   // Save position by line number.
   _save_pos2(p);
   _begin_select;_begin_line();
   index=find_index(ext'_smartpaste',PROC_TYPE|COMMAND_TYPE);
   if (!index) {
      enter_col=0;
   } else {
      enter_col=call_index(char_cbtype,first_col,index);
   }
   //IF no code found/want to give up OR ... OR want to give up OR
   //   first_line of pasted stuff is preprocessing
   if (!enter_col) {
      if (old_deselect_paste!=def_deselect_paste) {
         deselect();def_deselect_paste=old_deselect_paste;
      }
      _restore_pos2(p);
      return(0);
   }
   if (char_cbtype) {
      // Remove leading blanks inserted into last line
      typeless p2;
      save_pos(p2);
      _end_select();
      Nofcols=p_col+(_select_type('','i')?0:-1);
      if (Nofcols) {
         _begin_line();_delete_text(Nofcols,'C');
      }
      restore_pos(p2);
   }
   down();
   for (i=1;i<=Noflines;++i) {
      get_line(line);
      if (line!='') {
         break;
      }
      down();
   }
   if (i<=Noflines) {
      first_non_blank();
      if (p_col!=enter_col) {
         adjust_col=enter_col-p_col;
         for (i=1;i<=Noflines;++i) {
            get_line(line);
            line=reindent_line(line,adjust_col);
            // IF line just constists of blanks and tab characters
            if (line=='') line='';
            replace_line(line);
            down();
         }
      } else {
         down(Noflines-i+1);
      }
   }
   if (char_cbtype && dest_col>1) {
      get_line(line);
      line=reindent_line(line,dest_col-1);
      if (line=='') line='';
      replace_line(line);
      /*first_non_blank();
      NofLeadingBlankCols=p_col+paste_col;*/
   }
   if (old_deselect_paste!=def_deselect_paste) {
      deselect();
      def_deselect_paste=old_deselect_paste;
   }
   _restore_pos2(p);
   return(status)

}


