/*
  To install this macro, perform use
  the Load module dialog box ("Macro", "Load Module...").
  

  IF  BEGIN
  END
  WHILE  BEGIN
  END
  
*/
#include 'slick.sh'

#define EXTENSION 'sqlserver'
#define MODE_NAME 'SQL Server'
#define VLXLEXERNAME  'SQL Server'
// The funky symbols at the end are yen and pound symbols
// Try the courier font for them to display correctly.
#define IDENTIFIER_CHARS  'A-Za-z0-9_$#@'

boolean def_sqlserver_autocase=0;

defload()
{
   setup_info='MN='MODE_NAME',TABS=+3,MA=1 74 1,':+
               'KEYTAB='EXTENSION'-keys,WW=1,IWT=0,ST=0,IN=2,WC='IDENTIFIER_CHARS',LN='VLXLEXERNAME',CF=1,';
   compile_info='';
   // The first two number are syntax_indent amount and expand on/off
   // the restore of 
   syntax_info='3 1 ':+   // <Syntax indent amount>  <expansion on/off>
               '1 -1 0';   // <min abbrev> <word_case> <begin/end style>
   be_info='';
   create_ext(kt_index,EXTENSION,'',MODE_NAME,setup_info,compile_info,
              syntax_info,be_info);
   set_eventtab_index(kt_index,event2index(ENTER),find_index('sqlserver-enter',COMMAND_TYPE));
   set_eventtab_index(kt_index,event2index(' '),find_index('sqlserver-space',COMMAND_TYPE));
   /*index=find_index('def-setup-sql',MISC_TYPE);
   if (index && substr(name_info(index),1,1)!='@') {
      delete_name(index);
      insert_name('def-setup-sql',MISC_TYPE,'@plsql');
   } */
}
//0 = lowcase
//1 = UPPER CASE
//2 = Capitalize Word
static _str word_case(_str s)
{
   parse name_info(p_index) with . . . scase .;
   if (scase== -1) {
      return(s);
   } else if ( scase==0 ) {
      return(lowcase(s)) /* Lower case language key words. */
   } else if ( scase==1 ) {
      return(upcase(s))    /* Upper case language key words. */
   }
   s=lowcase(s);

   // Uppercase the first letter of each word
   for (i=1;;) {
      i=pos('(^|:b)\c['p_word_chars']',s,i,'r');
      if (!i) {
         break;
      }
      s=substr(s,1,i-1):+upcase(substr(s,i,1)):+
         substr(s,i+1);
      i=i+1;
   }
   return(s);
}

defeventtab sqlserver_keys
//def ' '=sql_space
//def ENTER=sql_enter*/

_command sqlserver_mode()  name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode('sqlserver');
}
_command sqlserver_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style . ;
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) ||
         sqlserver_expand_enter(p_SyntaxIndent,expand) ) {
      call_root_key(ENTER);
   } else if (_argument=='') {
      _undo('S');
   }

}

_command sqlserver_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   was_space=(last_event():==' ');
   parse name_info(_edit_window().p_index) with . expand . . be_style . ;
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      sqlserver_expand_space(p_SyntaxIndent) ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ');
         } else {
            keyin(' ');
            save_pos(orig_pos);
            left();left();
            cfg=_clex_find(0,'g');
            if (cfg==CFG_KEYWORD && def_sqlserver_autocase) {
               cw=cur_word(word_pcol);
               p_col=_text_colc(word_pcol,'I');
               _delete_text(length(cw));
               _insert_text(word_case(cw));
            }
            restore_pos(orig_pos);
         }
      }
   } else if (_argument=='') {
      _undo('S');
   }
}

   static _str space_words[]={
      'if','while','return','exception','else'
   };



/*
    Returns true if nothing is done
*/
static boolean sqlserver_expand_enter(syntax_indent)
{
   save_pos(p);
   orig_linenum=p_line;
   orig_col=p_col;
   enter_cmd=name_on_key(ENTER);
   if (enter_cmd=='nosplit-insert-line') {
      _end_line();
   }
   save_pos(p2);
   _clex_skip_blanks('-');
   word=lowcase(cur_word(junk));
   if (word=='begin') {
      first_non_blank();
      word=lowcase(cur_word(junk));
      if (word=='if' || word=='while') {
         restore_pos(p2);
         indent_on_enter(syntax_indent);
         return(false);
      }
   }
   restore_pos(p);
   return(true)
}
/*
    Returns true if nothing is done.
*/
static boolean sqlserver_expand_space(syntax_indent)
{
   status=0
   get_line orig_line
   line=strip(orig_line,'T')
   orig_word=strip(line);
   if ( p_col!=text_col(line)+1 ) {
      return(1)
   }
   if_special_case=0;
   aliasfilename='';
   word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename)
   if (aliasfilename!=''&&word!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   if ( word=='') return(1);

   line=substr(line,1,length(line)-length(orig_word)):+word;
   width=text_col(line,length(line)-length(word)+1,'i')-1;
   orig_word=word;
   word=lowcase(word);
   if ( word=='if' ) {
      replace_line(word_case(line:+'  begin'));
      insert_line(indent_string(width)word_case('end'));
      up();_end_line();p_col-=6;
   } else if (word=='while') {
      replace_line(word_case(line:+'  begin'));
      insert_line(indent_string(width)word_case('end'));
      up();_end_line();p_col-=6;
   } else {
     status=1
   }
   return status
}
/*
static boolean _isProtoType()
{
   save_pos(orig_pos);
   save_search(p1,p2,p3,p4);
   status=search('as','@hrixcs');
   for (;;) {
      if (status) {
         return(status);
      }
      if (match_length()==1) {
         cw=';';
         break;
      }
      cw=upcase(cur_word(junk));
      if(cw=='IS' || cw=='AS') {
         break;
      }
      status=repeat_search();
   }
   restore_search(p1,p2,p3,p4);
   restore_pos(orig_pos);
   return(cw==';');
}
*/

_str sqlserver_proc_search(_str &proc_name,int find_first)
{
   if ( find_first ) {
      variable_re='(['p_word_chars']#)';
      re='(^|[ \t])(proc|procedure|trigger)[ \t]+{#0'variable_re'}';
         //_mdi.p_child.insert_line(re);
      status=search(re,'ri@xcs>');
   } else {
      status=repeat_search();
   }
   save_pos(orig_pos);
   for (;;) {
      if ( status ) {
         restore_pos(orig_pos);
         break;
      }
      name=get_text(match_length('0'),match_length('S0'));
      type='func)';
      classname='(';
      name=name:+classname:+type;
      if (proc_name:=='') {
         restore_pos(orig_pos);
         proc_name=name;
         return(0);
      } 
      if (proc_name==name) {
         restore_pos(orig_pos);
         return(0);
      }
      status=repeat_search();
   }
   return(status)
}

/*
    This functions make show_procs smarter by showing user
    all parameters and attributes of the function definition
    but not the code.
*/
void sqlserver_find_lastprocparam()
{
   save_pos(p);
   startpos=_nrseek();
   status=search("as","wixcs");
   if (status) {
      restore_pos(p);
      return;
   }
   orig_col=p_col;
   first_non_blank();
   if (p_col==orig_col) {
      up();_end_line();
   }
}



defeventtab sqlserver_keys
def  'a'-'z','0'-'9','$','_','#'= sqlserver_maybe_case_word
def  'BACKSPACE'= sqlserver_maybe_case_backspace
//def ' '=sql_space
//def ENTER=sql_enter*/

static int gWordEndOffset=-1;
static _str gWord;
static void _maybe_case_word(boolean autocase)
{
   event=event2name(last_event());
   if (command_state()) {
      keyin(event);
      return;
   } else {
      if (p_line==0) {
         return;
      }
   }
   cfg=_clex_find(0,'g');
   if (cfg==CFG_COMMENT || cfg==CFG_STRING || !autocase) {
      keyin(event);
      return;
   }
   keyin(event);
   left();
   cfg=_clex_find(0,'g');
   right();

   if (cfg==CFG_KEYWORD) {
      save_pos(p);
      left();

      NewWord=cur_word(word_pcol);
      if (length(gWord)<length(NewWord) && lowcase(gWord):==lowcase(substr(NewWord,1,length(gWord)))) {
         gWord=gWord:+substr(NewWord,length(gWord)+1);
      } else {
         gWord=NewWord;
      }

      right();
      p_col=_text_colc(word_pcol,'I');
      _delete_text(length(gWord));
      _insert_text(word_case(gWord));
      gWordEndOffset=(int)point('s');
      restore_pos(p);
   } else if (gWordEndOffset+1==point('s')) {
      prev_cmd=name_name(prev_index('','C'));
      if (pos('maybe-case-word',prev_cmd)==0 && 
          pos('maybe-case-backspace',prev_cmd)==0) {
         return;
      }
      // Put the original word back
      p_col-=length(gWord)+1;
      _delete_text(length(gWord)+1);
      _insert_text(gWord:+event);
      gWordEndOffset= -1;gWord="";
   } else {
      gWordEndOffset= -1;gWord="";
   }
}
//Returns 0 if the letter wasn't upcased, otherwise 1
_command void sqlserver_maybe_case_word() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   _maybe_case_word(def_sqlserver_autocase);
}
static void _maybe_case_backspace(boolean autocase)
{
   event=event2name(last_event());
   if (command_state()) {
      call_root_key(BACKSPACE);
      return;
   } 
   if (p_line==0) {
      return;
   }
   prev_cmd=name_name(prev_index('','C'));
   i=last_index('','C');
   call_root_key(BACKSPACE);
   last_index(i,'C');
   if (p_col==1) {
      return;
   }
   cfg=_clex_find(0,'g');
   if (cfg==CFG_COMMENT || cfg==CFG_STRING || !autocase) {
      return;
   }
   left();cfg=_clex_find(0,'g');right();
   if (cfg==CFG_KEYWORD) {
      save_pos(p);

      NewWord=cur_word(word_pcol);
      if (length(NewWord)<length(gWord) && lowcase(NewWord):==lowcase(substr(gWord,1,length(NewWord)))) {
         gWord=substr(gWord,1,length(NewWord));
      } else {
         gWord=NewWord;
      }

      p_col=_text_colc(word_pcol,'I');
      _delete_text(length(gWord));
      _insert_text(word_case(gWord));
      gWordEndOffset=(int)point('s');
      restore_pos(p);
   } else if (gWordEndOffset-1==point('s') && length(gWord)>1) {
      if (pos('maybe-case-word',prev_cmd)==0 && 
          pos('maybe-case-backspace',prev_cmd)==0) {
         return;
      }
      // Put the original word back
      p_col-=length(gWord)-1;
      _delete_text(length(gWord)-1);
      _insert_text(substr(gWord,1,length(gWord)-1));
   } else {
      gWordEndOffset= -1;gWord="";
   }
}

_command void sqlserver_maybe_case_backspace() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   _maybe_case_backspace(def_sqlserver_autocase);
}

defeventtab _sqlserver_extform

void _lowcase.lbutton_up()
{
   ctlautocase.p_enabled=ctlnone.p_value==0;
}
void _upcase.lbutton_up()
{
   ctlautocase.p_enabled=ctlnone.p_value==0;
}
void _capitalize.lbutton_up()
{
   ctlautocase.p_enabled=ctlnone.p_value==0;
}
void ctlnone.lbutton_up()
{
   ctlautocase.p_enabled=ctlnone.p_value==0;
}
_ok.on_create()
{
   parse p_active_form.p_name with '_' ext '_extform';
   index = find_index('def-options-'ext, MISC_TYPE);
   if (!index) {
      return('');
   }
   info = name_info(index);
   parse info with rem1 rem2 minexpkwdlen scase .;
   _minimum.p_text=minexpkwdlen;
   //messageNwait('before comments comment:'comment' ic:'indentcase);
    //index=find_index('def_'ext'_smartpaste',VAR_TYPE);
   //_smartp.p_value=_get_var(index);
   _minimum.p_text = minexpkwdlen;
   switch (scase) {
   case -1:ctlnone.p_value = 1;break;
   case 0:_lower.p_value = 1;break;
   case 1:_upper.p_value = 1;break;
   case 2:_capitalize.p_value = 1;break;
   }
   acindex=find_index('def_'ext'_autocase',VAR_TYPE);
   ctlautocase.p_value=(int)_get_var(acindex);
}
_ok.lbutton_up()
{
   parse p_active_form.p_name with '_' ext '_extform';
   index = find_index('def-options-'ext, MISC_TYPE);
   info = name_info(index);
   parse info with p1 p2 p3 . rest;

   if (_lower.p_value) {//THESE CONTROLS
      kw_case = 0;
   }else if(_upper.p_value) {
      kw_case = 1;
   } else if (_capitalize.p_value) {
      kw_case= 2;
   }else{
      kw_case= -1;
   }

   /*spindex=find_index('def_'ext'_smartpaste',VAR_TYPE);
   if (_smartp.p_value&&_smartp.p_enabled) {
      _set_var(spindex,1);
   }else{
      _set_var(spindex,0);
   } */

   info = p1' 'p2' '_minimum.p_text' 'kw_case' 'rest;
   acindex=find_index('def_'ext'_autocase',VAR_TYPE);
   _set_var(acindex,(ctlautocase.p_value!=0));
   _setext(ext, 'options', info);

   p_active_form._delete_window(0);
}
