/*
$VerboseHistory: stdcmds.e$
 *
 * *****************  Version 2  *****************
 * User: Clark       Date: 01/14/1998  Time:11:26a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/14/1998 11:25a
 * Comment:
 * Added select mode C++ API hook
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:15a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:15a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/08/1997 09:41a
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"
_str process_retrieve_id;

_str process_first_retrieve;
_str process_mark;
_str _error_mark;
_str _top_process_mark;//All you need from here are this and the initialization in
//definit.  Any other differences are unintentional.
_str compile_rc;
_str _mffind_markid;

boolean def_deselect_copyto=0;

no_code_swapping;   /* Just in case there is an I/O error reading */
/* the slick.sta file, this will ensure user */
/* safe exit and save of files.  Common cursor */
/* movement commands will not cause module swapping. */
static boolean undo_past_save;
static _str _command_mark,_orig_mark
static _str _command_op_list

static int _picos2_cbarrow;
static int _picos2_cbdots;
static int _picos2_cbarrow;
static int _picwin_cbarrow;
static int _picwin_cbdots;
static int _picwin_cbdis;
static int gNextWindow_wid;

int _c_stl_view_id;

int _dialogs_view_id;
int _DebugPictureTab[];   // Global debug picture indexes for faster initialization
definit()
{
   gNextWindow_wid=0;
   _EnhanceHTMLSetup();
   gNoTagCallList=0;
   // New dialog retrieval initialization code.
   get_view_id(orig_view_id);
   activate_view(HIDDEN_VIEW_ID);
   status=find_view('.dialogs');
   if ( ! status ) {
      top();
      if ( ! _on_line0()  ) {   /* Buffer not already empty. */
         _lbclear();
      }
   } else {
      clear_message();
      load_files("+c +70 +t");
      //p_undo_steps=3000
      p_buf_name=".dialogs";
      _delete_line();
      p_buf_flags= THROW_AWAY_CHANGES|HIDE_BUFFER|KEEP_ON_QUIT;
   }
   get_view_id(_dialogs_view_id);
   activate_view(orig_view_id);
   rc=0;

   _last_have_dll='';
   if ( arg(1):!='L' ) {
      _c_stl_view_id=0;
      /* Editor initialization case. */
      // Position where last compile was started
      // Don't go past here when searching for the previous error.
      _mffind_markid="";
      _top_process_mark='';
      process_mark=''; /* Position of last error found by NEXT-ERROR in .process. */
      _error_mark='';  /* Position of last error found by NEXT-ERROR in $errors.tmp*/
      process_retrieve_id='';
      process_first_retrieve=1;
      gerror_info._makeempty();
      _error_file='';
      _grep_buffer='';
      compile_rc=0;
      _cua_select=0;
      _command_op_list='';
      _command_mark='';
      _orig_mark='';
      _project_name='';
      //_cua_textbox(def_cua_textbox)
   } else {

      _pic_project=load_picture(-1,'_ptproj.bmp');
      _pic_file=load_picture(-1,'_file.bmp');
      _pic_file_d=load_picture(-1,'_filed.bmp');

      _pic_drcdrom=load_picture(-1,'_drcdrom.bmp');
      _pic_drremov=load_picture(-1,'_drremov.bmp');
      _pic_drfixed=load_picture(-1,'_drfixed.bmp');

      _picwin_cbarrow=load_picture(-1,'_cbarrow.bmp');
      _picwin_cbdots=load_picture(-1,'_cbdots.bmp');
      _picwin_cbdis=load_picture(-1,'_cbdis.bmp');
      // Load OS/2 combo box bitmap indexes.
      _picos2_cbarrowl=load_picture(-1,'_cboarrl.bmp');
      _picos2_cbdotsl=load_picture(-1,'_cbodotl.bmp');

      _picos2_cbarrow=load_picture(-1,'_cboarro.bmp');
      _picos2_cbdots=load_picture(-1,'_cbodots.bmp');

      _pic_fldaop=load_picture(-1,'_fldaop.bmp');
      _pic_fldclos=load_picture(-1,'_fldclos.bmp');
      _pic_fldopen=load_picture(-1,'_fldopen.bmp');
      _pic_tt=load_picture(-1,'_tt.bmp');
      _pic_printer=load_picture(-1,'_printer.bmp');
      _pic_lbplus=load_picture(-1,'_lbplus.bmp');
      _pic_lbminus=load_picture(-1,'_lbminus.bmp');
      _pic_lbvs=load_picture(-1,'_lbvs.bmp');
      _pic_func=load_picture(-1,'_func.bmp');
      _pic_sm_file=load_picture(-1,'_smfile.bmp');
      _pic_sm_file_d=load_picture(-1,'_smfiled.bmp');
      _pic_sm_func=load_picture(-1,'_smfunc.bmp');

      //1:13pm 6/22/1998
      //Dan added these bitmaps for the new project toolbar stuff....
      _pic_vc_co_user_w=load_picture(-1,'_docvcc.bmp');
      set_name_info(_pic_vc_co_user_w,"You have this file checked out");
      _pic_vc_co_user_r=load_picture(-1,'_docvccg.bmp');
      set_name_info(_pic_vc_co_user_r,"You have this read only file checked out");
      _pic_vc_co_other_m_w=load_picture(-1,'_docvccm.bmp');
      set_name_info(_pic_vc_co_other_m_w,"Another user has this file checked out");
      _pic_vc_co_other_m_r=load_picture(-1,'_docvcrm.bmp');
      set_name_info(_pic_vc_co_other_m_r,"Another user has this read only file checked out");
      _pic_vc_co_other_x_w=load_picture(-1,'_docvcwx.bmp');
      set_name_info(_pic_vc_co_other_x_w,"Another user has this file checked out exclusively");
      _pic_vc_co_other_x_r=load_picture(-1,'_docvccx.bmp');
      set_name_info(_pic_vc_co_other_x_r,"Another user has this read only file checked out exclusively");
      _pic_vc_available_w=load_picture(-1,'_docvc.bmp');
      set_name_info(_pic_vc_available_w,"This file is available for check out");
      _pic_vc_available_r=load_picture(-1,'_docvcg.bmp');
      set_name_info(_pic_vc_available_r,"This read only file is available for check out");
      _pic_doc_w=load_picture(-1,'_doc.bmp');
      _pic_doc_r=load_picture(-1,'_docg.bmp');

      _pic_tfldclos=load_picture(-1,'_tfldcls.bmp');
      _pic_tfldopen=load_picture(-1,'_tfldopn.bmp');
      _pic_tproject=load_picture(-1,'_tptproj.bmp');

      breakpt_index=load_picture(-1,'_breakpt.bmp');
      execbrk_index=load_picture(-1,'_execbrk.bmp');
      execpt_index=load_picture(-1,'_execpt.bmp');
      stackbrk_index=load_picture(-1,'_stackbr.bmp');
      stackexc_index=load_picture(-1,'_stackex.bmp');

      breakpn_index=load_picture(-1,'_breakpn.bmp');
      execbn_index=load_picture(-1,'_execbn.bmp');
      stackbn_index=load_picture(-1,'_stackbn.bmp');

#define VSBPFLAG_BREAKPOINT        0x00000001    /* Break point on this line*/
#define VSBPFLAG_EXEC              0x00000002    /* Line about to be executed. */
#define VSBPFLAG_STACKEXEC         0x00000004    /* Call Stack execution line */
#define VSBPFLAG_BREAKPOINTDISABLED   0x00000008 /* Break point disabled*/

#define VSBPFLAGC_NOFBITMAPS (0x0f+1)
      for (i=0;i<VSBPFLAGC_NOFBITMAPS;++i) {
         _DebugPictureTab[i]=0;
      }

      _DebugPictureTab[VSBPFLAG_BREAKPOINT]=breakpt_index;  // Break point
      _DebugPictureTab[VSBPFLAG_EXEC]=execpt_index;   // Execution point
      _DebugPictureTab[VSBPFLAG_BREAKPOINT|VSBPFLAG_EXEC]=execbrk_index;   // execution point with break point
      _DebugPictureTab[VSBPFLAG_STACKEXEC]=stackexc_index;  // Stack execution
      _DebugPictureTab[VSBPFLAG_STACKEXEC|VSBPFLAG_BREAKPOINT]=stackbrk_index;
      _DebugPictureTab[VSBPFLAG_STACKEXEC|VSBPFLAG_EXEC]=execpt_index;  // Execution point
      _DebugPictureTab[VSBPFLAG_STACKEXEC|VSBPFLAG_BREAKPOINT|VSBPFLAG_EXEC]=execbrk_index;   // execution point with break point

      _DebugPictureTab[VSBPFLAG_BREAKPOINTDISABLED]=breakpn_index;  // Break point disabled

      _DebugPictureTab[VSBPFLAG_BREAKPOINTDISABLED|VSBPFLAG_BREAKPOINT]=breakpt_index;  // Break point
      _DebugPictureTab[VSBPFLAG_BREAKPOINTDISABLED|VSBPFLAG_EXEC]=execbn_index;   // Executing point with break point disabled
      _DebugPictureTab[VSBPFLAG_BREAKPOINTDISABLED|VSBPFLAG_BREAKPOINT|VSBPFLAG_EXEC]=execbrk_index;   // execution point with break point
      _DebugPictureTab[VSBPFLAG_BREAKPOINTDISABLED|VSBPFLAG_STACKEXEC]=stackbn_index;  // Stack execution with break point disabled
      _DebugPictureTab[VSBPFLAG_BREAKPOINTDISABLED|VSBPFLAG_STACKEXEC|VSBPFLAG_BREAKPOINT]=stackbrk_index;
      _DebugPictureTab[VSBPFLAG_BREAKPOINTDISABLED|VSBPFLAG_STACKEXEC|VSBPFLAG_EXEC]=execbn_index;   // Executing point with break point disabled
      _DebugPictureTab[VSBPFLAG_BREAKPOINTDISABLED|VSBPFLAG_STACKEXEC|VSBPFLAG_BREAKPOINT|VSBPFLAG_EXEC]=execbrk_index;   // execution point with break point
   }
   if (machine()=='OS2386' || __UNIX__) {
      if (_screen_width()<=800) {
         _picos2_cbarrowl=find_index('_cboarrl.bmp',PICTURE_TYPE);
         _picos2_cbdotsl=find_index('_cbodotl.bmp',PICTURE_TYPE);
         //messageNwait('_picos2_cbarrowl='_picos2_cbarrowl);
         _pic_cbarrow=_picos2_cbarrowl;
         _pic_cbdots=_picos2_cbdotsl;
         _pic_cbdis=_picos2_cbarrowl;
      } else {
         //messageNwait('>800 _picos2_cbarrow='_picos2_cbarrow);
         _pic_cbarrow=_picos2_cbarrow;
         _pic_cbdots=_picos2_cbdots;
         _pic_cbdis=_picos2_cbarrow;
      }
   } else {
      _pic_cbarrow=_picwin_cbarrow;
      _pic_cbdots=_picwin_cbdots;
      _pic_cbdis=_picwin_cbdis;
   }
#if 0
   clex_file=slick_path_search(_VLX_FILE);
   if (clex_file!='') {
      _clex_load(clex_file);
   }
#endif
   clex_file_list=LEXER_FILE_LIST;
   for (;;) {
      parse clex_file_list with filename (PATHSEP) clex_file_list;
      if (filename=='') {
         break;
      }
#if 1
      if (file_eq(filename,USER_LEXER_FILENAME)) {
         //If this is the user file, we have to check the VSLICKCONFIG directory first...
         clex_file='';
      }else{
         clex_file=misc_path_search(filename);
      }
      if (clex_file=='') {
         path=_config_path();
         clex_file=file_match("-p "maybe_quote_filename(path:+filename),1);
      }
#else
      path=_config_path();
      clex_file=file_match("-p "maybe_quote_filename(path:+filename),1);
      if (clex_file=='') {
         clex_file=misc_path_search(filename);
      }
#endif
      if (clex_file!='') {
         //clex_file=path_search(filename);
         _clex_load(clex_file);
      }
   }
   _in_quit=0;
   _in_exit_list=0;
   _in_help=0;
   undo_past_save=0;
   if (name_on_key(name2event('a-f4'))!= 'safe-exit') {
      _mdi._sysmenu_bind(SC_CLOSE,"&Close");
   }
   if (machine()=='OS2386') {
      if (name_on_key(name2event('a-f5'))!= 'restore-mdi') {
         _mdi._sysmenu_bind(SC_RESTORE,"&Restore");
      }
      if (name_on_key(name2event('a-f7'))!= 'move-mdi') {
         _mdi._sysmenu_bind(SC_MOVE,"&Move");
      }
      if (name_on_key(name2event('a-f8'))!= 'size-mdi') {
         _mdi._sysmenu_bind(SC_SIZE,"&Size");
      }
      if (name_on_key(name2event('a-f9'))!= 'iconize-mdi') {
         _mdi._sysmenu_bind(SC_MINIMIZE,"Mi&nimize");
      }
      if (name_on_key(name2event('a-f10'))!= 'maximize-mdi') {
         _mdi._sysmenu_bind(SC_MAXIMIZE,"Ma&ximize");
      }
   }

}
def on_keystatechange=_on_keystatechange;

void _on_keystatechange()
{
   if (_IsKeyDown(CTRL)) {
      //say('down');
      gNextWindow_wid=_mdi.p_child;
      if (gNextWindow_wid.p_window_flags & HIDE_WINDOW_OVERLAP) {
         gNextWindow_wid=0;
      }
   } else {
      //say('up gNextWindow_wid='gNextWindow_wid);
      final_wid=_mdi.p_child;
      if (!(final_wid.p_window_flags & HIDE_WINDOW_OVERLAP) && 
           (_iswindow_valid(gNextWindow_wid) && gNextWindow_wid.p_mdi_child) &&
          final_wid!=gNextWindow_wid) {
         if (_default_option(VSOPTION_NEXTWINDOWSTYLE)==1) {
            final_wid._MDIReorder(gNextWindow_wid);
         }
      }
      gNextWindow_wid=0;
   }
}

/* Find view in the current buffer with the given buffer name */
_str find_view(_str file_spec)
{
   status=1;
   get_view_id(first_view_id);
   for (;;) {
      _next_view();
      get_view_id(view_id);
      /* messageNwait('p_buf_name='p_buf_name' file_spec='file_spec) */
      if ( view_id!=HIDDEN_VIEW_ID && view_id!=RETRIEVE_VIEW_ID &&
           file_eq(p_buf_name,file_spec) ) {
         status=0;
         break;
      }
      if ( view_id==first_view_id ) break;
   }
   return(status);
}
static load_picture(option,filename)
{
   result=_update_picture(option,filename);
   if (result<0) {
      if (result==FILE_NOT_FOUND_RC) {
         _message_box(nls('File "%s" not found',filename));
      } else {
         _message_box(nls('Unable to load picture "%s"',filename)'. 'get_message(result));
      }
      rc=result;
   }
   return(result);
}
_command void cmdclear_message()
{
   clear_message();
}
_command void key_not_defined() name_info(','VSARG2_LASTKEY|VSARG2_EDITORCTL)
{
   switch (last_event()) {
   case ON_NUM_LOCK:
      return;
   }
   index=event2index(last_event());
   if ( index<MEVENTS_OFFSET || index>S_C_MEVENTS_OFFSET+NMEVENTS) {
      message nls("Key not defined");
   }
}
_str undo_msg(status)
{
   msg='';
   if ( status&LINE_INSERTS_UNDONE ) {
      msg=nls('Line insert(s),');
   }
   if ( status&LINE_DELETES_UNDONE ) {
      msg=msg:+nls('Line delete(s),');
   }
   if ( status&MARK_CHANGE_UNDONE ) {
      msg=msg:+nls('Mark change,');
   }
   if ( status&TEXT_CHANGE_UNDONE ) {
      msg=msg:+nls('Text change,');
   }
   if ( status&CURSOR_MOVEMENT_UNDONE ) {
      msg=msg:+nls('Cursor movement,');
   }
   if (status & LINE_FLAGS_UNDONE) {
      msg=msg:+nls('Line flags,');
   }
   if (status & FILE_FORMAT_CHANGE_UNDONE) {
      msg=msg:+nls('File Format Change,');
   }
   if (status & COLOR_CHANGE_UNDONE) {
      msg=msg:+nls('Color Change,');
   }
   msg=strip(msg,'T',','):+' 'nls('undone');
   if ( p_undo_steps==0 ) {
      msg=nls('Undo not on');
   }
   return(msg);

}
static _str past_save(...)
{
   if ( undo_past_save ) {
      name= name_name(prev_index('','C'));
      if ( arg(1)!='' ) {
         bool=(name=='redo');
      } else {
         bool=(name=='undo' || name=='undo-line' || name=='undo-cursor');
      }
      if ( bool ) {
         flush_keyboard();
         result=_message_box(nls("You are about to undo past previous save.\nContinue?"),'',MB_ICONQUESTION|MB_YESNOCANCEL);
         if ( result!=IDYES) {
            return(1);
         }
      }
      undo_past_save=0;
   }
   return(0);

}

int _OnUpdate_undo(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   if (_isdiffed(target_wid.p_buf_id)) {
      return(NOTHING_TO_UNDO_RC);
   }
   return((target_wid._undo_status():==NOTHING_TO_UNDO_RC)?MF_GRAYED:MF_ENABLED);
}
_command undo() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL/*|VSARG2_NOEXIT_SCROLL*/)
{
   if ( past_save() ) {
      return(1);
   }
   status=_undo();
   if ( status>=0 && test_event('r'):=='' ) {
      message undo_msg(status);
   } else {
      message(get_message(status));
   }
   undo_past_save=(status>=0 && (status&MODIFY_FLAG_UNDONE));
   return(status);
}
int _OnUpdate_undo_cursor(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdate_undo(cmdui,target_wid,command));
}
_command undo_cursor() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL/*|VSARG2_NOEXIT_SCROLL*/)
{
   if ( past_save() ) {
      return(1);
   }
   status=_undo('C');
   if ( status>=0 && test_event('r'):=='' ) {
      message undo_msg(status);
   } else {
      message(get_message(status));
   }
   undo_past_save=(status>=0 && (status&MODIFY_FLAG_UNDONE));
   return(status);
}
int _OnUpdate_redo(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   return((_undo_status('r'):==NOTHING_TO_REDO_RC)?MF_GRAYED:MF_ENABLED);
}
_command redo() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   if ( past_save('r') ) {
      return(1);
   }
   status=_undo('r');
   if ( status>=0 && test_event('r'):=='' ) {
      message(undo_msg(status));
   } else {
      message(get_message(status));
   }
   undo_past_save=(status>=0 && (status&MODIFY_FLAG_UNDONE));
   return(status);

}
_str def_auto_reset;        /* If non-zero, reset-next-error is called. */
                       /* before a compile or make commands is executed. */

_command void nosplit_insert_line() name_info(','VSARG2_LASTKEY|VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      command_execute();
   } else {
      // For better BRIEF emulation, ctrl+enter is set to nosplit_insert_line
      // nosplit_insert_line command should still perform smart indenting.
      // If last event
      if (last_event():!=ENTER && last_event():!=' ') {
         last_event(ENTER);
         enter_index=eventtab_index(p_mode_eventtab,p_mode_eventtab,event2index(ENTER));
         if (enter_index && p_mode_eventtab!=_default_keys) {
            index=eventtab_index(_default_keys,_default_keys,event2index(ENTER));
            set_eventtab_index(_default_keys,event2index(ENTER),
                               find_index('nosplit_insert_line',COMMAND_TYPE));
            call_index(enter_index);
            set_eventtab_index(_default_keys,event2index(ENTER),index);
            return;
         }

      }
      if ( p_window_state:=='I' ) {
         p_window_state='N';
         return;
      }
      if (_QReadOnly()) {
         _on_readonly_error(0);
         return;
      }
      if (_on_line0()) {
         col=1;
      } else {
         save_pos(p);
         _begin_line();
         search('[~ \t]|$','r');
         restore_pos(p);
         // If not on blank line
         if ( match_length() ) {
            _begin_line;
            _refresh_scroll();
            first_non_blank();
            col=p_col;
         } else {
            col=enter_on_bl();
         }
      }
      if ( p_indent_style!=INDENT_NONE) {
         if ( def_enter_indent ) {
            insert_line(indent_string(col-1));
         } else {
            insert_line('');
         }
         p_col=col;
      } else {
         insert_line('');
      }
   }

}
enter_on_bl()
{
   if ( p_index ) { /* Does this buffer has syntax expansion options? */
      /* For source code buffers, leave the cursor position alone. */
      col=p_col;
   } else {
      parse p_margins with left_margin right_margin new_para_margin;
      col=new_para_margin;
   }
   return(col);

}
void command_execute()
{
   if ( ! def_stay_on_cmdline) {
      if (_no_child_windows()) {
         VSWID_STATUS._set_focus();
      } else {
         cursor_data();
         old_wid=p_window_id;
         refresh();
         p_window_id=old_wid;
      }
   } else {
      // Could be executing command on child edit window when it
      // does not have focus.
      _mdi.p_child._undo('s');
      orig_wid=p_window_id;
   }
   if (substr(_cmdline.p_text,1,1)=='@') {
      _cmdline.set_command('',1);
      message get_message(COMMAND_NOT_FOUND_RC);
      return;
   }
   //say('_mac='_macro());
   if ( _macro() ) {
      _cmdline.get_command(command);
      _macro_call('execute',command,'a');
   }
   _macro('m',_macro());
   //say('h2 _mac='_macro());
   last_index(prev_index());

   if (def_unix_expansion) {
      /* Execute result of function call. */
      text=_cmdline.p_text;
      _cmdline.set_command('',1);
      status=execute(_maybe_unix_expansion(text),'a');
      append_retrieve_command(text);
   } else {
      status=execute(_cmdline.p_text,'ar');
   }
   if (_no_child_windows()) {
      if (status==UNKNOWN_COMMAND_RC) {
         _beep();
      } else if (isinteger(status) && status<0 &&
                 status!=COMMAND_CANCELLED_RC) {
         _message_box(get_message(status));
      }
   }

   if (def_stay_on_cmdline && orig_wid==_cmdline && p_mdi_child) {
      _cmdline._set_focus();
   }
   // IF we have a 2.0 constant value for UNIXRE_SEARCH
   if (def_re_search==0x80) {
      // convert it to the new 3.0 value
      def_re_search=UNIXRE_SEARCH;
   }
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_ONE_FILE_PER_WINDOW)) {
      def_one_file='+w';
   }
}
_command void split_insert_line() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   if ( command_state() ) {
      command_execute();
      return;
   }
   if ( p_window_state:=='I' ) {
      p_window_state='N';
      return;
   }
   if (_QReadOnly()) {
      _on_readonly_error(0);
      return;
   }
   orig_col=p_col;
   if (_on_line0()) {
      insert_line('');
      //p_col=orig_col;
      return;
   }
   if ( p_indent_style!=INDENT_NONE ) {
      _begin_line;
      _refresh_scroll();
      first_non_blank();
      if (p_col>_text_colc()) {
         p_col=orig_col;
         indent_col=enter_on_bl();
         p_col=orig_col;
      } else {
         indent_col=p_col;
         if (p_col<orig_col) {
            p_col=orig_col;
         }
      }
   } else {
      indent_col=1;
      p_col=orig_col;
   }
   // Try to use insert_line('') instead of _split_line
   // so current line does not look modified
   did_insert_line=0;
   if (p_col>_text_colc()) {
      if (p_buf_width) {
         // Record files have no NLChars.  _split_line
         // won't insert any either.
         insert_line('');
         did_insert_line=1;
      } else {
         p_col=_text_colc()+1;
         NLChars=get_text(_line_length(1)-_line_length());
         if (NLChars:==p_newline) {
            insert_line('');
            did_insert_line=1;
         }
      }
   }
   if (!did_insert_line) {
      _split_line();
      down();
      _begin_line();
   }
   result=indent_string(indent_col-1);
   _insert_text(result);
}
_command void maybe_split_insert_line() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   if ( command_state() || _insert_state()) {
      _macro('m', _macro('s'));
      split_insert_line();
      return;
   }
   if ( p_window_state:=='I' ) {
      p_window_state='N';
      return;
   }
   if (_QReadOnly()) {
      _on_readonly_error(0);
      return;
   }
   if ( down() ) {
      insert_line('');
   }
   _begin_line();

}
// Returns 0 if tabs not in fixed increment.  Otherwise increment
// is returned.  Returns 0 if first tab stop not 1.
int _tabs_in_fixed_increments()
{
   tabs=p_tabs;
   parse tabs with first rest;
   if (first!=true || rest=="") {
      return(0);
   }
   parse rest with prev rest;
   inc=prev-first;
   for (;;) {
      if (rest=="") {
         return(inc);
      }
      parse rest with next rest;
      if (next-prev!=inc) {
         return(0);
      }
   }
}
_command void ctab() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   if ( command_state() ) {
      maybe_list_matches('','','1');
      return;
   }
   if (!command_state() && def_modal_tab && select_active()) {
      if (_isnull_selection()) {
         _deselect();
      } else {
         indent_selection();
         return;
      }
   }
   if (!command_state() && p_indent_with_tabs ) {
      if (!command_state()) maybe_delete_selection();
      if (!_tabs_in_fixed_increments()) {
         keyin("\t");
         return;
      }
      // Don't worry about long line here.  This is for C source.
      get_line(line);
      if ( command_state() || expand_tabs(line,1,p_col-1)!='') {
         state=_insert_state();
         if ( ! _insert_state() ) {
            _insert_toggle();
         }
         keyin("\t");
         if ( state!=_insert_state() ) {
            _insert_toggle();
         }
         return;
      }
      old_col=p_col;
      ptab();
      syntax_indent=p_col-old_col;
      replace_line reindent_line(line,syntax_indent);
      return;
   }
   init_command_op();
   ptab();
   retrieve_command_results();
}
void ptab(...)
{
   parse name_info(p_index) with . .;
   if ( p_indent_style!=INDENT_NONE && p_SyntaxIndent>0 ) {
      if ( arg(1)=='' ) {
         p_col=((p_col-1) intdiv p_SyntaxIndent)*p_SyntaxIndent+1;
      } else {
         p_col=((p_col-2) intdiv p_SyntaxIndent)*p_SyntaxIndent+1+p_SyntaxIndent;
      }
      p_col=p_col+(int)(arg(1)p_SyntaxIndent);
   } else {
      if ( arg(1)=='-' ) {
         backtab();
      } else {
         tab();
      }
   }

}
_command void cbacktab() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   if (!command_state() && def_modal_tab && select_active()) {
      if (_isnull_selection()) {
         _deselect();
      } else {
         unindent_selection();
         return;
      }
   }
   init_command_op();
   ptab('-');
   retrieve_command_results();

}
_command void move_text_tab() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   if ( command_state() ) {
      maybe_list_matches('','','1');
      return;
   }
   if (!command_state() && def_modal_tab && select_active()) {
      if (_isnull_selection()) {
         _deselect();
      } else {
         indent_selection();
         return;
      }
   }
   if ( !command_state() && p_indent_with_tabs ) {
      ctab();
      return;
   }
   if (!command_state()) maybe_delete_selection();
   init_command_op();
   old_col=p_col;
   ptab()
   replace_line(_expand_tabsc(1,old_col-1,'S'):+
                substr('',1,p_col-old_col):+
                _expand_tabsc(old_col,-1,'S'));
   retrieve_command_results();

}
_command void move_text_backtab() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   if (!command_state() && def_modal_tab && select_active()) {
      if (_isnull_selection()) {
         _deselect();
      } else {
         unindent_selection();
         return;
      }
   }
   init_command_op();
   old_col=p_col;
   ptab('-');
   if ( _expand_tabsc(1,old_col)=='' ) {
      syntax_indent=old_col-p_col;
      _reindent_linec('-'syntax_indent);
      return;
   }
   subtext=strip(_expand_tabsc(p_col,old_col-p_col),'T');
   replace_line _expand_tabsc(1,p_col-1,'S'):+subtext:+_expand_tabsc(old_col,-1,'S');
   p_col=p_col+length(subtext);
   retrieve_command_results();

}
_command scroll_begin_line() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   if (p_cb) p_window_id=p_cb_list_box;
   _begin_line();
}
_command scroll_end_line() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   if (p_cb) p_window_id=p_cb_list_box;
   _end_line();

}
_command void begin_line() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      _begin_line;
      return;
   }
   if (p_hex_mode) {
      _hex_begin_line();
      return;
   }
   _begin_line();
   if ( p_left_edge && p_col<p_char_width-2 ) {
      set_scroll_pos(0,p_cursor_y);
   }

}
_command void begin_line_text_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      _begin_line();
      return;
   }
   if (p_hex_mode) {
      _hex_begin_line();
      return;
   }
   /* make this a toggle from column 1 to first non blank. */
   orig_col=p_col;
   first_non_blank();
   /* not already on first non blank? */
   if ( p_col!=orig_col) {
      first_non_blank();
   } else {
      _begin_line();
   }
   if ( p_left_edge && p_col<p_char_width-2 ) {
      set_scroll_pos(0,p_cursor_y);
   }

}

_first_non_blank_col(...)
{
   save_search(sv_search_string,sv_flags,sv_word_re,sv_more);
   return_if_all_blanks=arg(1);
   save_pos(p);
   _begin_line();
   search('[~ \t]|$','r');
   col=p_col;
   restore_pos(p);
   if (!match_length() && return_if_all_blanks!='') {
      restore_search(sv_search_string,sv_flags,sv_word_re,sv_more);
      return(return_if_all_blanks);
   }
   restore_search(sv_search_string,sv_flags,sv_word_re,sv_more);
   return(col);
}
/* find the first non blank character in the current line */
_command void first_non_blank() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if (_on_line0()) {
      p_col=1;
      return;
   }
   save_search(sv_search_string,sv_flags,sv_word_re,sv_more);
   _begin_line();
   search('[~ \t]|$','@r'arg(1));
   restore_search(sv_search_string,sv_flags,sv_word_re,sv_more);
}
_command void end_line() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      _end_line();
      return;
   }
   if (p_hex_mode) {
      _hex_end_line();
      return;
   }
   _end_line();
}
static int gupdown_col=1;
_command int cursor_up() name_info(','VSARG2_READ_ONLY|VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   return(_cursor_updown(arg(1),"",1));
}
int _cursor_updown(...)
{
   count=1;
   if (arg(1)!='') {
      count=arg(1);
   }
   dodown=arg(2)!="";
   generate_macro_source=arg(3)!="";
   if (command_state()) {
      for (i=1;i<=count;++i) {
         retrieve_skip(arg(2));
         get_command(line);
         command_put(line);
      }
      return(0);
   }
   key=last_event();
   //read_behind_flush_repeats(key,def_flush_repeats)
   prev_cmd=translate(name_name(prev_index('','C')),'_','-');
   if (prev_cmd!='cursor_up' && prev_cmd!='cursor_down' && def_updown_col) {
      gupdown_col=p_col;
   }
   if (generate_macro_source) {
      _macro_repeat();
   }
   save_pos(downp);
   for (i=1;i<=count;++i) {
      if (p_hex_mode) {
         if ( dodown) {
            status=_hex_down();
         } else {
            status=_hex_up();
         }
      } else {
         if ( dodown) {
            status=down();
         } else {
            status=up();
         }
         if (status) {
            if (dodown && (_lineflags()&HIDDEN_LF)) {
               restore_pos(downp);
            }
            break;
         }
         if (_lineflags()&HIDDEN_LF) {
            --i;
         } else if (dodown) {
            save_pos(downp);
         }
      }
   }
   if (!p_hex_mode) {
      if (def_updown_col) {
         stay_on_text(gupdown_col);
      }
   }
   //read_behind_flush_repeats(key,def_flush_repeats);
   return(status);
}
static void stay_on_text(updown_col)
{
   if ( updown_col && (! select_active() || _select_type():!='BLOCK') ) {
      if ( _text_colc()<updown_col ) {
         p_col=_text_colc()+1;
      } else if ( _text_colc(updown_col,'T')<0 ) {
         p_col=_text_colc(1-_text_colc(updown_col,'T'),'i');
      } else {
         p_col=updown_col;
      }
   }

}
_command int cursor_down() name_info(','VSARG2_READ_ONLY|VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   status=_cursor_updown(arg(1),"n",1);
   return(status);
}
_command void top_of_buffer() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if (p_cb) p_window_id=p_cb_list_box;
   if (p_hex_mode) {
      set_scroll_pos(0,p_cursor_y);
      top();
      return;
   }
   if ( def_top_bottom_style ) {
      old_col=p_col;
      old_left_edge=p_left_edge;
      old_point=point();
      set_scroll_pos(old_left_edge,p_cursor_y);
   }
   top();
   if ( def_top_bottom_style && old_point!=point() ) {
      p_col=old_col;
   }
   block_was_read(1);
   call(read_ahead());
}
_command void bottom_of_buffer() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if (p_hex_mode) {
      hex_bottom();
      return;
   }
   if (p_cb) p_window_id=p_cb_list_box;
   if ( def_top_bottom_style ) {
      old_col=p_col;
      old_left_edge=p_left_edge;
      old_point=point();
   }
   bottom();
   if ( def_top_bottom_style && old_point!=point() ) {
      p_col=old_col;
      set_scroll_pos(old_left_edge,p_cursor_y);
   }
   block_was_read(1);
   call(read_behind());

}
_command void page_up() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   page_up_down();

}
_command void page_down() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   page_up_down('d');

}
static void page_up_down()
{
   if (p_hex_mode) {
      if ( arg(1)!='' ) {
         _hex_pagedown();
      } else {
         _hex_pageup();
      }
      return;
   }
   key=last_event();
   read_behind(key);
   prev_cmd=name_name(prev_index());
   if (prev_cmd!='page-up' && prev_cmd!='page-down' ) {
      gupdown_col=p_col;
   }
   if ( arg(1)!='' ) {
      _page_down();
   } else {
      _page_up();
   }
   if (def_updown_col) {
      stay_on_text(gupdown_col);
   } else {
      p_col=gupdown_col;
   }
   if ( def_flush_repeats ) {
      refresh();
      flush_repeats(key);
      read_behind(key);
      flush_repeats(key);
   } else {
      read_behind(key);
   }
}
_command cursor_left() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   count=1;
   if (arg(1)!='') {
      count=arg(1);
   }
   if (command_state()) {
      for (i=1;i<=count;++i) {
         if ( def_jmp_on_tab ) {
            left();
         } else {
            get_command(line,col);
            set_command(line,col-1);
         }
      }
      return('');
   }
   _macro_repeat();
   for (i=1;i<=count;++i) {
      if (p_hex_mode) {
         _hex_left();
      } else {
         wordwrap_left(def_cursorwrap);
      }
   }

}
void wordwrap_left()
{
   parse p_margins with leftmargin rightmargin .;
   col=p_col;
   if ( def_jmp_on_tab ) {
      left();
   } else {
      p_col=p_col-1;
   }
   if ( (p_word_wrap_style&WORD_WRAP_WWS) ||
        arg(1):=='1' ) {
      if ( def_linewrap || !(p_word_wrap_style&WORD_WRAP_WWS)) {
         leftmargin=1;
      }
      if ( col<=leftmargin) {
         get_line(line);
         if (strip(substr(line,1,_text_colc(col-1,'P')),'B'):=='' ) {
            up();
            if ( ! rc ) {
               _end_line();
            }
         }
      }
   }

}
_command cursor_right() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   count=1;
   if (arg(1)!='') {
      count=arg(1);
   }
   if (command_state()) {
      for (i=1;i<=count;++i) {
         right();
      }
      return('');
   }
   _macro_repeat();
   for (i=1;i<=count;++i) {
      if (p_hex_mode) {
         _hex_right();
      } else {
         wordwrap_right(def_cursorwrap);
      }
   }
}
void wordwrap_right()
{
   parse p_margins with leftmargin rightmargin .;
   if ( (p_word_wrap_style&WORD_WRAP_WWS) ||
        arg(1):=='1' ) {
      if ( (p_col>rightmargin || arg(1):=='1') &&
           p_col>_text_colc() && (! select_active() || _select_type():!='BLOCK') ) {
         down();
         if ( ! rc ) {
            if ( def_linewrap || !(p_word_wrap_style&WORD_WRAP_WWS)) {
               p_col=1;
            } else {
               p_col=leftmargin;
            }
         }
         return;
      }
   }
   if ( def_jmp_on_tab ) {
      right();
   } else {
      p_col=p_col+1;
   }


}
_command void delete_char(...) name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      _delete_char();
   } else {
      wordwrap_delete_char(arg(1));
   }

}
_command void linewrap_delete_char() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   _macro('m',_macro());
   delete_char(1);
}
/* This procedure joins the next line to the current line if the column */
/* position is greater than the length of the line. */
/* otherwise the character under the cursor is deleted. */
void wordwrap_delete_char()
{
   if ( (p_word_wrap_style&WORD_WRAP_WWS)  ||
        arg(1)!='' ) {
      if ( _on_line0() ) {
         return;
      }
      LineLen=_text_colc();
      if ( p_col>LineLen) {
         join_line(def_linewrap);
      } else {
         _delete_char();
      }
   } else {
      _delete_char();
   }

}
_command void rubout(...) name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() ) {
      _rubout();
   } else {
      wordwrap_rubout(arg(1));
   }
}
_command void linewrap_rubout() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   _macro('m',_macro());
   rubout(1);
}
void wordwrap_rubout()
{
   col=p_col;
   if ( def_pull || _insert_state() ) {
      if ( def_hack_tabs && p_col!=1 ) {
         // Changed this to support DBCS
         left();
         if (get_text()=="\t") {
            p_col=col;p_col=p_col-1;_delete_char();
         } else {
            _delete_char();
         }
         //_delete_text();
      } else {
         if (/*def_keys=='brief-keys' && */p_index && p_indent_style==INDENT_SMART && p_indent_with_tabs && p_show_tabs!=1 && p_buf_width==0) {
            line_len=_text_colc();
            if (p_col>line_len+1) {
               parse name_info(p_index) with . .;
               count=p_SyntaxIndent;
               if (count>0) {
                  count=((p_col-1)%count);
                  if (!count) count=p_SyntaxIndent;
               }
               if (count<=0) {
                  count=1;
               }
               if (p_col-1<count) {
                  count=p_col-1;
               }
               if (p_col-count>line_len) {
                  p_col-=count;
               } else {
                  temp=_expand_tabsc(p_col-count,count,'S');
                  temp_len=p_col-count-1+length(strip(temp,'T'));
                  p_col=temp_len+1;
                  delete_end_line();
#if 0
                  temp=_expand_tabsc(p_col-count,count,'S');
                  temp_len=p_col-count-1+length(strip(temp,'T'));
                  replace_line expand_tabs(line,1,temp_len,'S');
                  _end_line();
#endif
               }
            } else {
               _rubout();
            }
         } else {
            _rubout();
         }
      }
   } else {
      if ( col!=1 ) {
         // Changed this to support DBCS
         left();
         if (get_text()=="") {
            p_col=col;
            p_col=p_col-1;
         } else if (p_col==col-2) {
            keyin('  ');
            left();left();
         } else {
            keyin(' ');
            left();
         }
      }
   }
   if ( (p_word_wrap_style&WORD_WRAP_WWS) ||
        arg(1)!='' ) {
      parse p_margins with leftmargin .;
      if ( _on_line0() ) {
         return;
      }
      if ( def_linewrap || !(p_word_wrap_style&WORD_WRAP_WWS)) {
         leftmargin=1;
      }
      get_line(line);
      if ( (col<=leftmargin || col:==1) &&  p_col<=_first_non_blank_col()
           /*strip(substr(line,1,text_col(line,p_col-1,'P')),'B',' ')==''*/ ) {
         up();
         if ( ! _on_line0()  ) {  /* hit top of file? */
            /* did not hit top of file. */
            if ( def_pull || _insert_state() ) {
               down();
               // Might split tab character. Deleting previous character
               // will not cause a problem.
               _rubout();
               physical_col=_text_colc(p_col,'P');
               _begin_line();
               _delete_text(physical_col-1);
               up();
               _end_line();

               _join_line();
            } else {
               _end_line();
            }
         } else {
            down();
         }
      }
   }

}
_command void top_of_window() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   p_cursor_y=0;
}
_command void bottom_of_window() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   p_cursor_y=(p_client_height-1);

}
_command void split_line() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   int first_non_blank;

   get_line(line);
   orig_col=p_col;
   ifirst_non_blank=_first_non_blank_col(0);

   // Try to use insert_line('') instead of _split_line
   // so current line does not look modified
   did_insert_line=0;
   if (p_col>_text_colc()) {
      if (p_buf_width) {
         // Record files have no NLChars.  _split_line
         // won't insert any either.
         insert_line('');
         did_insert_line=1;
      } else {
         p_col=_text_colc()+1;
         NLChars=get_text(_line_length(1)-_line_length());
         if (NLChars:==p_newline) {
            insert_line('');
            did_insert_line=1;
         }
      }
   }
   if (!did_insert_line) {
      _split_line();
      down();
      _begin_line();
   }
   search('[ \t]@','r@');
   if (match_length()) {
      _delete_text(match_length());
   }
   if (ifirst_non_blank) {
      _insert_text(indent_string(ifirst_non_blank-1));
   }
   up();
   p_col=orig_col;
}
void strip_trailing_spaces()
{
   save_pos(p);
   // Must start from beginning of line to ensure that we find
   // something on this line.
   _begin_line();
   status=search('[ \t]@$','r@');
   if (!status && match_length()) {
      search_replace('');
   }
   restore_pos(p);
}
void strip_leading_spaces()
{
   save_pos(p);
   _begin_line();
   status=search('^[ \t]@','r@');
   if (!status && match_length()) {
      search_replace('');
   }
   restore_pos(p);
}
_command join_line() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   /* join next line to current line at cursor position. */
   /* if cursor position is less than length of line then */
   /* join next line to end of current line. */
   /* leading spaces and tabs of next line are stripped before join. */
   /* Trailing spaces of current line are stripped. */
   strip_trailing_spaces();
   //get_line current_line;current_line=strip(current_line,'T',' ')
   CurLineLineLen=_text_colc();
   status=down();
   if ( status ) {
      message(get_message(rc));
      return(rc);
   }
   up();
   if ( p_col>CurLineLineLen ) {
      // Force padding with spaces
      _insert_text('a');--p_col;_delete_text(1,'C');
   }
   if ( arg(1)!='' && arg(1) ) { /* Do not strip spaces? */
      _join_line();
   } else {
      down();
      strip_leading_spaces();
      up();
      _join_line();
      //current_line= current_line:+strip(line,'L')
   }
   return(0);

}
_command begin_select() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   temp_view_id="";
   if (!_isEditorCtl()) {
      orig_view_id=_create_temp_view(temp_view_id);
   }
   orig_buf_id=p_buf_id;
   status=_begin_select(arg(1));
   if (status) {
      return(status);
   }
   // Here we exit scroll for convenience.
   // Caller might have already done this
   _exit_scroll();
   if (def_one_file!='' || !p_mdi_child || _no_child_windows() ||
       !(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)
      ) {
      if (!_correct_window(orig_buf_id)) {
         _begin_select(arg(1));
      }
   }
   if (temp_view_id!="") {
      _delete_temp_view(temp_view_id);
   }
   return(0);
}
int _correct_window(orig_buf_id)
{
   buf_name=p_buf_name;
   buf_id=p_buf_id;
   // If the original buffer is the same as the new buffer
   if (orig_buf_id==buf_id) {
      return(0);
   }
   // Restore original buffer displayed in this window
   p_buf_id=orig_buf_id;
   // Find a window to display this window
   wid=0;
   for (i=1;i<=_last_window_id();++i) {
      if (_iswindow_valid(i) && i._isEditorCtl() && i.p_buf_id==buf_id &&
          !i.p_isbutton_bar &&
          (i.p_mdi_child ||
           !(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW))
         ) {
         wid=i;
         break;
      }
   }
   /*wid=window_match(buf_name,1,'xn');
   for (;;) {
      if (!wid) break;
      if (wid.p_buf_id==buf_id) break;
      wid=window_match(buf_name,0,'xn');
   }
   */
   if (wid) {
      p_window_id=wid;
      _set_focus();
   } else {
      if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
         return(1);
      }
      edit('+bi 'buf_id);
   }
   return(0);
}
_command end_select() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   orig_buf_id=p_buf_id;
   status=_end_select(arg(1));
   if (status) {
      return(status);
   }
   if (def_one_file!='' || !p_mdi_child || _no_child_windows() ||
       !(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)
      ) {
      if (!_correct_window(orig_buf_id)) {
         _end_select(arg(1));
      }
   }
}
_command select_line() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   _cua_select=0;
   if ( lock_selection() ) return(1);
   flag=_select_type('')!='' && _select_type('','S')!='C';
   status=_select_line('',def_select_style:+def_advanced_select);
   if ( status==TEXT_ALREADY_SELECTED_RC ||
        (pos('C',def_select_style,1,'i') && flag) ) {
      _deselect;clear_message;select_line();
   }

}
_command select_block() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   _cua_select=0;
   if ( lock_selection() ) return(1);
   flag=_select_type('')!='' && _select_type('','S')!='C';
   status=_select_block('',def_select_style:+def_advanced_select);
   if ( status==TEXT_ALREADY_SELECTED_RC ||
        (pos('C',def_select_style,1,'i') && flag)
      ) {
      _deselect;clear_message;select_block();
   }

}
_command select_char() name_info(','VSARG2_MARK|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   _cua_select=0;
   if ( lock_selection() ) {
      return(1);
   }
   flag=_select_type('')!='' && _select_type('','S')!='C';
   status=_select_char('',def_select_style:+def_advanced_select);
   if ( status==TEXT_ALREADY_SELECTED_RC || (pos('C',def_select_style,1,'i') && flag) ) {
      _deselect;clear_message;select_char();
   }

}
_command void deselect() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION)
{
   _deselect();
}
_command copy_to_cursor() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_SELECTION)
{
   return(_copy_or_move(arg(1),'C'));

}
_command move_to_cursor() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_SELECTION)
{
   return(_copy_or_move(arg(1),'M'));

}
_str _copy_or_move()
{
   markid=arg(1);
   copymove_option=arg(2);
   do_smartpaste=arg(3);
   support_deselect=arg(4);
   if (do_smartpaste) {
      // Here we are assuming we were called from clipbd.e on a
      // paste operation.
      _extend_outline_selection(markid);
   }
   /* lock_selection(1)  /* No message */ */
   special_case=_select_type(arg(1))=='LINE' && def_line_insert=='B';
   if ( special_case ) {
      cursor_y=p_cursor_y;
      up();
   }
   adjust_outline_destination(markid);
   if (do_smartpaste) {
      status=smart_paste(markid,copymove_option);
   } else {
      if ( upcase(copymove_option)=='M' ) {
         status=_move_to_cursor(markid);
      } else {
         status=_copy_to_cursor(markid);
      }
   }
   if ( special_case && (!status || status==SOURCE_DEST_CONFLICT_RC) ) {
      down();
      set_scroll_pos(p_left_edge,cursor_y);
   }
   if (support_deselect && def_deselect_copyto) {
      _deselect(arg(1));
   }
   return(status);

}
static void adjust_outline_destination(markid)
{
   if (_select_type(markid)=='LINE') {
      //count=count_lines_in_selection(markid);
      //messageNwait('adjust_outline_destination: count='count);
      //bottom();
      //return;
      pm= _lineflags()&(PLUSBITMAP_LF|MINUSBITMAP_LF);
      // IF there is a plus bitmap displayed on this line.
      if (pm==PLUSBITMAP_LF) {
         for (;;) {
            if (down()) {
               break;
            }
            if (!(_lineflags()&HIDDEN_LF)) {
               up();
               break;
            }
         }
      }
   }
}
/* arg(1)<>'' indicates not to display message */
_str lock_selection()
{
   if ( _select_type('','S')=='C' && def_advanced_select!='' ) {
      _get_selinfo(first_col,last_col,buf_id);
      if ( p_buf_id==buf_id ) {
         select_it(_select_type(),'',_select_type('','I'):+def_advanced_select)
         if ( arg(1)=='' ) {
            message('Selection locked.');
         }
         return(1);
      }
   }
   return(0);

}
_command void delete_selection() name_info(','VSARG2_TEXT_BOX|VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION)
{
   was_command_state=command_state();
   if (was_command_state) {
      _get_sel(start_pos,end_pos);
      if (start_pos==end_pos) {
         set_command("",1);
         return;
      }
      init_command_op();
      if (_select_type()=='') {
         retrieve_command_results();
         return;
      }

   }
   markid=arg(1);
   _extend_outline_selection(markid);
   _begin_select(markid);
   _delete_selection(markid);
   if (was_command_state) retrieve_command_results();
}
_command void gui_fill_selection() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION)
{
   _macro('m',_macro());
   fill_selection('gui');
}
_command fill_selection() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION)
{
   gui=arg(1);
   if (!p_mdi_child && _executed_from_key_or_cmdline('fill_selection')) {
      gui=1;
   }
   if ( _select_type()=='' ) {
      message(get_message(TEXT_NOT_SELECTED_RC));
      return(TEXT_NOT_SELECTED_RC);
   }
   _macro_delete_line();
   if (gui!='') {
      orig_wid=p_window_id;
      wid=show('_fill_form');
      key=get_event();
      wid._delete_window();
      if ( iscancel(key) ) {
         return(1);
      }
      p_window_id=orig_wid;
      _macro('m',_macro('s'));
   } else {
      message nls('Type a key to fill mark with');key=get_event();
      if ( iscancel(key) ) {
         cancel();
         return(1);
      }
   }
   param=key2ascii(key);
   _macro_call('_fill_selection',param);
   clear_message();
   _fill_selection(param);
   return(0);
}
_command adjust_block_selection() name_info(','/*VSARG2_MARK|*/VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_BLOCK_SELECTION)
{
   _adjust_block_selection();
}
_command void overlay_block_selection() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_BLOCK_SELECTION)
{
   _overlay_block_selection();
}
_command void shift_selection_left(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION)
{
   numshifts=arg(1);
   if (numshifts=='') {
      numshifts=1;
   }
   for (i=1;i<=numshifts;++i) {
      _shift_selection_left();
   }
}
_command void shift_selection_right(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION)
{
   numshifts=arg(1);
   if (numshifts=='') {
      numshifts=1;
   }
   for (i=1;i<=numshifts;++i) {
      _shift_selection_right();
   }
}
_command void arg_shift_selection() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION)
{
   _macro_delete_line();
   _str LeftOrRight;
   _str count;
   LeftOrRight=upcase(arg(1));
   doLeft=(LeftOrRight=="L");
   count=arg(2);
   if (count=="") {
      result=show("-modal _textbox_form",
                  (doLeft)?"Shift Selection Left":"Shift Selection Right", // Form caption
                  0, //flags
                  '',   //use default textbox width
                  '',   //Help item.
                  '',   //Font (not yet supported)
                  "arg_shift_selection",  //Retrieve Name
                  "-i 1,99999 Count:"1
                 );
      if (result=="") {
         return;
      }
      count=_param1;
   }
   if (doLeft) {
      shift_selection_left(count);
      _macro_call("shift_selection_left",count);
   } else {
      shift_selection_right(count);
      _macro_call("shift_selection_right",count);
   }
}
_command void quote_key() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   _macro_delete_line();
   message(nls('Type a key'));
   key=get_event();
   clear_message();
   key=key2ascii(key);
   if ( length(key)>1 ) {
      param=last_event();
   } else {
      param=key2ascii(key);
   }
   _macro_call('keyin',param);
   keyin(param);
}
_command void insert_toggle() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   _macro_delete_line();
   _insert_toggle();
   if (_insert_state()) {
      _macro_call('_insert_state',1);
   } else {
      _macro_call('_insert_state',0);
   }
}
_command void cmdline_toggle() name_info(','VSARG2_MARK|VSARG2_CMDLINE|VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if (!p_mdi_child && !p_isbutton_bar && p_object==OI_EDITOR) {
      if (last_event():==ESC || last_event():==A_F4) {
         call_event(defeventtab _ainh_dlg_manager,last_event(),'e');
      }
      return;
   }
   if (outputIsInTabShell()) {
      if (_no_child_windows()) {
         p_window_id= _cmdline;
      } else {
         p_window_id= _mdi.p_child;
      }
      _set_focus();
      return;
   }
   if ((p_window_id!=_cmdline &&
        !_default_option(VSOPTION_HAVECMDLINE))) {
      result = show('-modal _textbox_form',
                    '', // Form caption
                    TB_RETRIEVE, //flags
                    '', //use default textbox width
                    '', //Help item.
                    '', //Font (not yet supported)
                    'command',   //Retrieve Name
                    '-c 'COMMAND_ARG:+_chr(0)'Command:');
      if (result=='') {
         return;
      }
      text=_param1;
      if ( _macro() ) {
         _cmdline.get_command(text);
         _macro_call('execute',text,'a');
      }
      _macro('m',_macro());
      last_index(prev_index());

      if (def_unix_expansion) {
         /* Execute result of function call. */
         //_cmdline.set_command('',1);
         execute(_maybe_unix_expansion(text),'a');
         //append_retrieve_command(text);
      } else {
         execute(text,'ar');
      }
      if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_CONFIGURABLE_ONE_FILE_PER_WINDOW)) {
         def_one_file='+w';
      }
      return;
   }

   if (!command_state()) {
      // Assume that retrieve_prev_form/next_form called
      get_view_id(view_id);
      activate_view(RETRIEVE_VIEW_ID);
      bottom();
      activate_view(view_id);
      _macro_delete_line();
   }
   /* call last_index(prev_index()) */
   command_toggle();
}
_command void normal_character() name_info(','VSARG2_MARK|VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   maybe_delete_selection();
   keyin(key2ascii(last_event()));
}
_command void keyin_buf_name() name_info(','VSARG2_MARK|VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_TEXT_BOX)
{
   maybe_delete_selection();
   buf_name= _mdi._edit_window().p_buf_name;
   keyin(maybe_quote_filename(buf_name));
}
_command void nothing() name_info(','VSARG2_EDITORCTL)
{
}
_command void retrieve_prev() name_info(','VSARG2_CMDLINE)
{
   _cmdline.retrieve_skip();_cmdline.get_command(line);command_put(line);
}
_command void retrieve_next() name_info(','VSARG2_CMDLINE)
{
   _cmdline.retrieve_skip('n');_cmdline.get_command(line);command_put(line);
}
_command void version() name_info(','VSARG2_EDITORCTL)
{
   //line2=center(get_message(SERIAL_NUMBER_RC),length(get_message(SLICK_EDITOR_VERSION_RC)))
   line2=get_message(SERIAL_NUMBER_RC);
   line3="\n\nWebsite: www.slickedit.com\nTechnical Support Phone: (919) 303-7400\nTechnical Support Email: support@slickedit.com";
   line4="\n\nBuild Date: February 17, 1999";
   _message_box(get_message(SLICK_EDITOR_VERSION_RC)\n:+\n:+line2:+line3:+line4,'',MB_ICONNONE);
}

_command cap_word() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   init_command_op();
   /* Set variable def_from_cursor to 1 if you want to start from cursor */
   word=cur_word(start_col,def_from_cursor,false,def_word_continue);
   if (word=='') {
      retrieve_command_results();
      message(nls('No word at cursor'));
      return(1);
   }
   p_col=_text_colc(start_col,'I');
   _delete_text(length(word));
   _insert_text(upcase(substr(word,1,1)):+lowcase(substr(word,2)));
   retrieve_command_results();
   return(0);

}
/*
   If cursor is sitting on a valid word character (p_word_chars),
   the current word is returned.  Otherwise "" is returned.

*/
_str _SymbolWord()
{
   ch=get_text();
   if (!pos('['p_word_chars']',ch,1,'r')|| !_dbcsStartOfDBCSCol(p_col)) {
      return("");
   }
   common_re='([~\od'p_word_chars']#|^)\c[\od'p_word_chars']';
   //common_re='('common_re')|^';
   save_pos(p);
   search(common_re,'r-');
   start_col=p_col;
   status=search('[~\od'p_word_chars']|$','r');
   if ( status) {
      _end_line();
   }
   word=_expand_tabsc(start_col,p_col-start_col);
   restore_pos(p);
   return(word);
}
/*
thIS IS A TEST
TO SEE WHAT

*/
_str cur_word(int &start_col,_str from_cursor="",boolean end_prev_word=false,boolean multi_line=false)
{
   /*
      end_prev_word effects the following case.

          word1<cursor here>  word2

       By default, word2 is returned,  if end_prev_word==1 then word1 is returned.
   */
   end_prev_word=arg(3);
   from_cursor=arg(2);
   int option=VSCURWORD_WHOLE_WORD;
   if( from_cursor!='1') {
      if (end_prev_word==1) {
         option=VSCURWORD_AT_END_USE_PREV;
      } else {
         option=VSCURWORD_FROM_CURSOR;
      }
   }
   word=cur_word2(start_col,option,multi_line,true);
   if (word!='') {
      start_col=_text_colc(start_col,'P');
   }
   return(word);
}

_str cur_word2(int &start_col=0,int option=VSCURWORD_WHOLE_WORD,
               boolean multi_line=false,
               boolean doRestorePos=true
               )
{
   if (multi_line) doRestorePos=false;
   save_search(sv_search_string,sv_flags,sv_word_re,sv_more);
   /*
      end_prev_word effects the following case.

          word1<cursor here>  word2

       By default, word2 is returned,  if end_prev_word==1 then word1 is returned.
   */
   end_prev_word=arg(3);
   from_cursor=arg(2);
   save_pos(p);
   if ( option!=VSCURWORD_WHOLE_WORD ) {
      common_re='([~\od'p_word_chars']#|^)\c[\od'p_word_chars']';
      common_re='('common_re')|^';
      if (option==VSCURWORD_AT_END_USE_PREV && p_col!=1 &&
          !(pos('[\od'p_word_chars']',get_text(1),1,'r') || _dbcsIsLeadByte(get_text()))
         ) {
         left();
         bool=pos('[\od'p_word_chars']',get_text(1),1,'r')  || _dbcsIsLeadByte(get_text());
         right();
         if (bool) {
            //start_col=lastpos('\c['p_word_chars']#',line, col,'r')
            status=search('(\c[\od'p_word_chars']#)|^','h@r-');
         } else {
            status=search(common_re,'h@r-');
         }
      } else {
         if (multi_line) {
            if( pos('[\od'p_word_chars']',get_text(),1,'r') || _dbcsIsLeadByte(get_text())) {
               status=search(common_re,'h@r-');
            } else {
               status=search('[\od'p_word_chars']','h@r');
            }
         } else {
            status=search(common_re,'h@r-');
         }
      }
   } else {
      if (multi_line) {
         status=search('[\od'p_word_chars']','h@r');
      } else {
         status=search('[\od'p_word_chars']|$','h@r');
      }
   }
   if ( status || !match_length()) {
      restore_pos(p);
      restore_search(sv_search_string,sv_flags,sv_word_re,sv_more);
      return('');
   }
   start_col=p_col;
   status=search('[~\od'p_word_chars']|$','h@r');
   if ( status) {
      _end_line();
   }
   word=_expand_tabsc(start_col,p_col-start_col);
   if (doRestorePos) {
      restore_pos(p);
   }
   restore_search(sv_search_string,sv_flags,sv_word_re,sv_more);
   return(word);
}
/*
_command begin_word() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
   word=cur_word(start_col);
   if (word='') return(1);
   p_col=_text_colc(line,start_col,'I');
   return(0)
*/
_command void next_word() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   init_command_op();
   status=skip_word('');
   retrieve_command_results();
}
_command void prev_word() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   was_command_state=command_state();
   if (was_command_state) init_command_op();
   skip_word('-');
   if ( was_command_state ) {
      down();
      if ( ! rc ) {       /* on previous line? */
         begin_line();
      }
   }
   if (was_command_state) retrieve_command_results();

}
static _str skip_word(direction_option)
{
   if (def_brief_word) {
      if ( direction_option=='-') {
         if ( p_col==1 ) {
            up();_end_line();
         } else {
            left();
         }
         re1='([\od'p_word_chars'])';
         re2='([~\od \t'p_word_chars'])';
         status=search(re1'|'re2,'@re-<');
         if ( status ) {
            top();
         } else {
            ch=get_text();
            if (pos(re1,ch,1,'r') || _dbcsIsLeadByte(ch)) {
               re1='((^|[~\od'p_word_chars'])\c[\od'p_word_chars'])';
            } else {
               re1='((^|[\od \t'p_word_chars'])\c[~\od \t'p_word_chars'])';
            }
            search(re1,'@re-<');
         }
      } else {
         ch=get_text();
         if (ch!='' ) {
            // Search for end of word.
            if (pos('[\od'p_word_chars']',ch,1,'r') || _dbcsIsLeadByte(ch)) {
               search('[~\od'p_word_chars']|$','re@');
            } else {
               search('[\od \t'p_word_chars']|$','re@');
            }
         }
         // def_next_word_style=='E' is not supported
         status=search('[~\od \t]#','@re');
      }
      return(status);
   }
   if ( direction_option=='-' ) {
      if ( p_col==1 ) {
         up();_end_line();
      } else {
         left();
      }
      //status=search('['p_word_chars']#','@re-<');
      status=search('[\od'p_word_chars']','@re-<');
      if (status) {
         top();
      } else {
         search('(^|[~\od'p_word_chars'])\c[\od'p_word_chars']','@re-<');
      }
   } else {
      if ( def_next_word_style=='E' ) {   /* Move to end of next word */
         status=search('[\od'p_word_chars']#','@re>');
      } else {
         /* Move to beginning of next word. */
         if ( pos('[\od'p_word_chars']',get_text(1),1,'r')  || _dbcsIsLeadByte(get_text())) {
            right();
         }
         search('([~\od'p_word_chars']|^)\c[\od'p_word_chars']#','@re');
      }
   }
   return(status);
}
_command void select_word() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   pselect_word(_duplicate_selection(''));

}
_str def_word_delim='0';

_str pselect_word(mark)
{
   _deselect mark;_select_char(mark);
   if (def_brief_word) {
      // blanks | wordchars [blanks] |~ blnk,word_chars [blanks]
      search('[ \t]#|[\od'p_word_chars']#([ \t]@)|[~\od 'p_word_chars']#([ \t]@)','re>');  /* rev2a */
   } else {
      if ( def_word_delim ) {
         search('[\od'p_word_chars']#|[~\od'p_word_chars']#','re>');  /* rev2a */
      } else {
         search('[\od'p_word_chars']#','re>'); /* rev2a */
      }
   }
   status=rc;
   if ( status ) {
      _deselect(mark);
      return(status);
   }
   _select_char(mark,translate(def_select_style,'N','I'));
   _cua_select=1;
   return(0);

}
_command void line_to_top() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   set_scroll_pos(p_left_edge,0);

}
_command void line_to_bottom() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   set_scroll_pos(p_left_edge,p_client_height);
}
_command upcase_word() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   init_command_op();
   /* Set variable def_from_cursor to 1 if you want to start from cursor */
   word=cur_word(start_col,def_from_cursor,false,def_word_continue);
   if ( word=='' ) {
      retrieve_command_results();
      message(nls('No word at cursor'));
      return(1);
   }
   p_col=_text_colc(start_col,'I');
   _delete_text(length(word));
   _insert_text(upcase(word));
   retrieve_command_results();
   return(0);

}
_command lowcase_word() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   init_command_op();
   /* Set variable def_from_cursor to 1 if you want to start from cursor */
   word=cur_word(start_col,def_from_cursor,false,def_word_continue);
   if ( word=='' ) {
      retrieve_command_results();
      message(nls('No word at cursor'));
      return(1);
   }
   p_col=_text_colc(start_col,'I');
   _delete_text(length(word));
   _insert_text(lowcase(word));
   retrieve_command_results();
   return(0);

}
_command copy_word() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   init_command_op();
   push=name_name(prev_index('','C'))!='copy-word';
   if ( push ) {
      i=_text_colc(p_col,'p');
      LineLen=_line_length();
      if ( i>LineLen && LineLen) {
         i=LineLen;
      }
      p_col=_text_colc(i,'I');
      status=search('[\od'p_word_chars']#|?|^','-r@');
   }
   status=cut_word2(push,'C');
   retrieve_command_results();
   return(status);

}
_str retrieve_skip()
{
   get_view_id(view_id);
   activate_view(RETRIEVE_VIEW_ID);
   Noflines=p_Noflines;
   result='';
   if (arg(2)=='') {
      activate_view(view_id);
      for (i=1; i<=Noflines+1 ; ++i) {
         if ( upcase(arg(1))=='N' ) {
            _retrieve_next();
         } else {
            _retrieve_prev();
         }
         _cmdline.get_command(line);
         if ( substr(line,1,1)!='@' ) {
            result=line;
            break;
         }
         _cmdline.set_command('',1,1);
      }
   } else {
      // Old code was way to slow.  Speeding it up by using search built-in
      _cmdline.get_command(old1,old2,old3,old4); /* ,old5,old6,old7,old8 */
      start_line=p_line;
      done=0;
      if ( upcase(arg(1))=='N' ) {
         _cmdline._retrieve_next();
      } else {
         _cmdline._retrieve_prev();
      }
      _cmdline.get_command(line);
      if ( substr(line,1,length(arg(2)))==arg(2) && line:!=arg(3) ) {
         result=line;
         done=1;
      }
      _cmdline.set_command(old1,old2,old3,old4); /* ,old5,old6,old7,old8 */
      if (!done) {
         re='^'_escape_re_chars(arg(2));
         if ( upcase(arg(1))=='N' ) {
            _end_line();
            status=search(re,'r@');
            for (;;) {
               if (status) break;
               get_line(line);
               if (line:!=arg(3)) {
                  result=line;
                  done=1;
                  break;
               }
               status=repeat_search();
            }
            if (!done) {
               top();
               status=search(re,'r@');
               for (;;) {
                  if (status||p_line>=start_line) break;
                  get_line(line);
                  if (line:!=arg(3)) {
                     result=line;
                     done=1;
                     break;
                  }
                  status=repeat_search();
               }
            }
         } else {
            up();_end_line();
            status=search(re,'-r@');
            for (;;) {
               if (status) break;
               get_line(line);
               if (line:!=arg(3)) {
                  result=line;
                  done=1;
                  break;
               }
               status=repeat_search();
            }
            if (!done) {
               bottom();
               status=search(re,'-r@');
               for (;;) {
                  if (status||p_line<start_line) break;
                  get_line(line);
                  if (line:!=arg(3)) {
                     result=line;
                     done=1;
                     break;
                  }
                  status=repeat_search();
               }
            }
         }
      }
      if (!done) {
         p_line=start_line;
      }
      activate_view(view_id);

   }
#if 0
   _cmdline.get_command(old1,old2,old3,old4); /* ,old5,old6,old7,old8 */
   activate_view(view_id);
   for (i=1; i<=Noflines+1 ; ++i) {
      if ( upcase(arg(1))=='N' ) {
         _retrieve_next();
      } else {
         _retrieve_prev();
      }
      _cmdline.get_command(line);
      if ( arg(2):!='' ) {
         if ( substr(line,1,length(arg(2)))==arg(2) && line:!=arg(3) ) {
            result=line;
            break;
         }
      } else {
         if ( substr(line,1,1)!='@' ) {
            result=line;
            break;
         }
         _cmdline.set_command('',1,1);
      }
      if ( arg(2):!='' ) {
         _cmdline.set_command(old1,old2,old3,old4); /* ,old5,old6,old7,old8 */
      }
   }
#endif
   return(result);
}

void select_edit_mode(...)
{
   bypass_buffer_setup=(arg(2)!='' && arg(2));
   keys=def_keys;

   if ( arg(1)!='' ) {
      extension=arg(1);
      buf_name='';
   } else {
      extension= get_extension(p_buf_name);
      buf_name=p_buf_name;
   }
   old_extension=extension;
   check_and_load_support(old_extension,setup_index,buf_name);

   extension=refer_ext(_file_case(extension),buf_name);

   p_mode_eventtab=_default_keys;
   proc_index= find_index('suffix-'extension,PROC_TYPE|COMMAND_TYPE);
   if ( index_callable(proc_index) ) {
      status=call_index(proc_index);
      if ( !status ) {
         return;
      }
   }

   p_index=find_index('def-options-'extension,MISC_TYPE);
   parse name_info(p_index) with syntax_indent .;
   if (isinteger(syntax_indent)) {
      p_SyntaxIndent=syntax_indent;
   } else {
      p_SyntaxIndent=0;
   }

   if ( !bypass_buffer_setup ) {
      p_ModifyFlags&= ~MODIFYFLAG_PROCTREE_UPDATED;
   }

   if ( setup_index ) {
      parse name_info(setup_index) with 'MN=' mode_name ','\
         'TABS=' tabs ',' 'MA=' margins ',' 'KEYTAB=' keytab_name ','\
         'WW='word_wrap_style ',' 'IWT='indent_with_tabs ','\
         'ST='show_tabs ',' 'IN='indent_style ','\
         'WC='word_chars',' 'LN='lexer_name',' 'CF='color_flags','\
         'LNL='line_numbers_len',';

      if ( !bypass_buffer_setup ) {
         p_mode_name=mode_name;
         p_extension=extension;

         _ext_init_values(extension,lexer_name,color_flags);
         if ( isinteger(line_numbers_len) ) {
            p_line_numbers_len=line_numbers_len;
         }
         p_color_flags=color_flags;
         p_lexer_name=lexer_name;

         if ( ! read_format_line() ) {
            if ( tabs!='' ) p_tabs=tabs;
            if ( margins!='' ) p_margins=margins;
            if ( word_wrap_style!='' ) {
               p_word_wrap_style=word_wrap_style;
               p_indent_with_tabs=indent_with_tabs;

               if ( keys=="vi-keys" ) {
                  _show_tabs=__ex_set_list();
                  if ( _show_tabs!="" && _show_tabs>=0 ) {
                     show_tabs=_show_tabs;
                  }
               }
               p_show_tabs=show_tabs;
            }
            if ( indent_style!='' ) {
               p_indent_style=indent_style;
            } else {
               p_indent_style=INDENT_SMART;
            }
            if ( word_chars!='' ) {
               p_word_chars=word_chars;
            }
         }
      }

      in_process=(keytab_name=="process-keys");
      in_fileman=(keytab_name=="fileman-keys");
      vi_idx=find_index('vi-get-vi-mode',COMMAND_TYPE|PROC_TYPE);
      if( vi_idx && index_callable(vi_idx) && keys=="vi-keys" && !in_process && !in_fileman ) {
         vi_mode=upcase(strip(vi_get_vi_mode()));
         if ( vi_mode=="C" ) {
            // Don't switch out of command mode!
            index=find_index('vi-command-keys',EVENTTAB_TYPE);
            if ( !index ) {
               message('Could not find event-table: "vi-command-keys".  Type any key');
               get_event();
            }
            // Toggle back to character-insert mode if necessary
            if ( !_insert_state() ) {
               _insert_toggle();
            }
            // Make sure the cursor is on a real character for each buffer
            if ( p_col>_text_colc() ) {
               p_col= _text_colc();
            }
         } else {
            index=find_index(keytab_name,EVENTTAB_TYPE);
         }
      } else {
         index=find_index(keytab_name,EVENTTAB_TYPE);
      }
      if ( index ) {
         p_mode_eventtab=index;
      } else {
         p_mode_eventtab=_default_keys;
      }
   }

   if ( !bypass_buffer_setup ) {
      p_CallbackBufSetLineColor=0;
      vsCallbackSelectMode(p_window_id,extension);
   }

   if ( !proc_index && !setup_index ) {  // No setup for the file extension?
      fundamental_mode();
   }
}

_command void fundamental_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   select_edit_mode('fundamental');
}
void indent_on_enter(syntax_indent)
{
   name=name_on_key(ENTER);
   if ( name=='split-insert-line' ||
        (name=='maybe-split-insert-line' && _insert_state()) ) {
      get_line(line);
      if ( expand_tabs(line,1,p_col-1)=='' ) {
         first_non_blank();
      }
      split_insert_line();
      get_line(line);
      if ( arg(2)!='' ) {
         col1=arg(2);
         col2=p_col;
      } else {
         col2=p_col;
         col1=p_col+syntax_indent;
      }
      result=indent_string(col1-1):+expand_tabs(line,col2,-1,'S');
      if ( result=='' && !def_enter_indent ) {
         result='';
      }
      replace_line(result);
      p_col=col1;
   } else if ( name=='maybe-split-insert-line' && ! _insert_state() ) {
      maybe_split_insert_line();
   } else {
      nosplit_insert_line();
      if ( arg(2)!='' ) {
         p_col=arg(2);
      } else {
         p_col=p_col+syntax_indent;
      }
      if ( def_enter_indent ) {
         get_line(line);
         if (line=="") {
            replace_line(indent_string(p_col-1));
         }
      }
   }

}
_command void count_lines() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   /* Force slick to caculate number of lines. */
   message(nls('File contains %s lines',p_Noflines));
}
_command void process_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   if ( !command_state() && p_window_state:!='I') {
      if (!(_process_info('b') && p_line==p_Noflines) ) {
         if (select_active2() && !_end_select_compare() && !_begin_select_compare()) {
            _get_selinfo(first_col,last_col,buf_id);
            get_line(line);
            if (_select_type('','I')) ++last_col;
            if (_select_type()=='LINE') {
               command=line;
            } else {
               command=expand_tabs(line,first_col,last_col-first_col);
            }
            _deselect();
            concur_command(command);
            return;
         }
         call_root_key(last_event());
         return;
      }
      orig_view_id=p_view_id;
      if ( def_auto_reset ) {
         reset_next_error('','',0);
         /* clear_message */
      }
      p_view_id=orig_view_id;
      get_line(line);
      if ( _process_info('c') ) {
         col=_process_info('c');
      } else {
         col=1;
      }
      insert_retrieve(process_retrieve_id,process_first_retrieve,
                      expand_tabs(line,col,-1,'S'));
      insert_line('');
      return;
   }
   call_root_key(last_event());

}
_command void process_begin_line() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( ! command_state() && _process_info('c') && _process_info('c')<=p_col ) {
      p_col=_process_info('c');
      if ( p_left_edge && p_col<p_char_width-2 ) {
         set_scroll_pos(0,p_cursor_y);
      }
      return;
   }
   call_root_key(last_event());

}
_command void process_up() name_info(','VSARG2_READ_ONLY|VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   if ( ! command_state() && _process_info('b') && p_line:==p_Noflines && name_name(prev_index()):!='root-keydef' ) {
      if ( _process_info('c') ) {
         col=_process_info('c');
      } else {
         col=1;
      }
      get_line(line);
      line=expand_tabs(line,1,col-1,'S'):+
           pretrieve_prev(process_retrieve_id,process_first_retrieve);
      replace_line(line);
      set_scroll_pos(0,p_cursor_y);
      _end_line();
      return;
   }
   call_root_key(last_event());

}
_command void process_down() name_info(','VSARG2_READ_ONLY|VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   if ( ! command_state() && _process_info('b') && p_line:==p_Noflines && name_name(prev_index()):!='root-keydef' ) {
      if ( _process_info('c') ) {
         col=_process_info('c');
      } else {
         col=1;
      }
      get_line(line);
      line=expand_tabs(line,1,col-1,'S'):+
           pretrieve_next(process_retrieve_id,process_first_retrieve);
      replace_line(line);
      set_scroll_pos(0,p_cursor_y);
      _end_line();
      return;
   }
   call_root_key(last_event());

}
_command void process_rubout() name_info(','VSARG2_READ_ONLY|VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   if ( ! command_state() && _process_info('b') && 
        (_process_info('c')==p_col ||
         (! _process_info('c') && p_line:==p_Noflines && p_col==1)
        )
      ) {
      return;
   }
   call_root_key(last_event());

}

void init_command_op()
{
   command_op_wid='';
   if ( command_state() ) {
      get_command(line,begin_col,col);
      if( p_object!=OI_COMBO_BOX && p_Password ) {
         line=substr('',1,length(line),'*');
      }
      command_op_wid=p_window_id;
      activate_view(RETRIEVE_VIEW_ID);
      bottom();
      insert_line(line);p_col=col;
      _orig_mark=_duplicate_selection('');
      if ( _command_mark=='' ) {
         _command_mark=_alloc_selection();
         if ( _command_mark>=0 ) {
            _show_selection(_command_mark);
         }
      } else {
         status=_show_selection(_command_mark);
         // Just incase some body screwed up the mark, lets allocate
         // another
         if (status==INVALID_SELECTION_HANDLE_RC) {
            _command_mark=_alloc_selection();
            _show_selection(_command_mark);
         }
         _deselect();
      }
      if ( begin_col!=col ) {
         if ( _command_mark!='' ) {
            p_col=begin_col;
            _select_char('','cn');
            p_col=col;
            _select_char('','cn');
         }
      }
   }
   _command_op_list='.'command_op_wid' '_command_op_list;

}
void retrieve_command_results()
{
   parse _command_op_list with command_op_wid _command_op_list;
   command_op_wid=strip(command_op_wid,'B','.');
   if ( command_op_wid!='' ) {
      _command_mark=_duplicate_selection('');
      begin_col=p_col;col=p_col;
      get_line(line);
      if ( _select_type()!='' ) {
         if ( _select_type()=='LINE' ) {
            begin_col=1;col=length(line)+1;
         } else {
            _get_selinfo(begin_col,col,buf_id,_command_mark);
            if (substr(_select_type('','P'),2,1)=='E') {
               temp=begin_col;begin_col=col;col=temp;
            }
         }
      }
      _delete_line();
      if ( _orig_mark!='' ) {
         _show_selection(_orig_mark);
      }
      p_window_id=command_op_wid;
      if (line!=p_text ) {
         if( p_object!=OI_COMBO_BOX && p_Password ) {
            if( verify(line,'*') ) {
               // There is something other than all '*', so allow it
               set_command(line,begin_col,col);
            }
         } else {
            set_command(line,begin_col,col);
         }
      } else {
         _set_sel(begin_col,col);
      }
   }
}

boolean parseoption(var cmdline,optionletter)
{
   i=pos('-':+upcase(optionletter),upcase(cmdline));
   if ( ! i ) {
      i=pos('+':+upcase(optionletter),upcase(cmdline));
   }
   if ( i && substr(cmdline,i+length(optionletter)+1,1)=='' && (i==1 || substr(cmdline,i-1,1)=='') ) {
      cmdline=substr(cmdline,1,i-1):+substr(cmdline,i+length(optionletter)+1);
      return(1);
   } else {
      return(0);
   }
}
_command _str cload() name_info(FILE_ARG','VSARG2_CMDLINE)
{
   was_recording=_macro();
   filename=arg(1);
   wid=p_window_id;
   p_window_id=_mdi.p_child;
   default_buf_name=(_no_child_windows())?'':p_buf_name;
   if (filename=='') {
      filename=default_buf_name;
   }
   if ( filename=='<' || (filename=='' && _no_child_windows()) ||
        !(p_view_id<0 && file_eq('.'get_extension(filename),'.vlx'))
      ) {
      filename=_OpenDialog(_stdform('_open_form')' -modal',
                           'Open Color Lexer File', '*.vlx',
                           "Color Lexer (*.vlx),All Files "ALLFILES_RE")",
                           OFN_FILEMUSTEXIST,
                           'vlx',      // Default extensions
                           '',         // Initial filename
                           '',         // Initial directory
                           'vlx'       // Retrieve name
                          );
      if (filename=='') {
         p_window_id=wid;
         return(COMMAND_CANCELLED_RC);
      }
   }
   if (filename=='' || (p_view_id<0 && file_eq(p_buf_name,absolute(filename)))) {
      if ( p_modify ) {
         status=save();
         if ( status ) {
            p_window_id=wid;
            return(status);
         }
      }
      filename=default_buf_name;
   }
   _macro('m',was_recording);
   _macro_delete_line();
   filename=strip(filename,'b','"');
   _macro_call('_clex_load',filename);
   status=_clex_load(filename);
   if (status) {
      _message_box(nls("Unable to load color lexer file '%s'",filename)"\n\n"get_message(status));
      p_window_id=wid;
      return(status);
   }

   filename=strip_filename(filename,'p');
   string='(^|\'PATHSEP')':+_escape_re_chars(filename)'($|\'PATHSEP')';
   p_window_id=wid;
   return(0);
}

_command color_modified_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if (p_color_flags&MODIFY_COLOR_FLAG) {
      p_color_flags&=~MODIFY_COLOR_FLAG;
   } else {
      p_color_flags|=MODIFY_COLOR_FLAG;
   }
}
_command color_language_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if (p_color_flags&LANGUAGE_COLOR_FLAG) {
      p_color_flags&=~LANGUAGE_COLOR_FLAG;
   } else {
      p_color_flags|=LANGUAGE_COLOR_FLAG;
   }
}
int _OnUpdate_view_line_numbers_toggle(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED|MF_UNCHECKED);
   }
   if (p_line_numbers_len) {
      return(MF_CHECKED|MF_ENABLED);
   }
   return(MF_UNCHECKED|MF_ENABLED);
}
_command view_line_numbers_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   if (p_line_numbers_len) {
      p_line_numbers_len=0;
   } else {
      p_line_numbers_len=LINE_NUMBERS_LEN;
   }
}
int _OnUpdate_view_specialchars_toggle(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED|MF_UNCHECKED);
   }
   if ((p_ShowSpecialChars & (SHOWSPECIALCHARS_NLCHARS|SHOWSPECIALCHARS_TABS|SHOWSPECIALCHARS_SPACES|SHOWSPECIALCHARS_EOF))==
       (SHOWSPECIALCHARS_NLCHARS|SHOWSPECIALCHARS_TABS|SHOWSPECIALCHARS_SPACES|SHOWSPECIALCHARS_EOF)) {
      return(MF_CHECKED|MF_ENABLED);
   }
   return(MF_UNCHECKED|MF_ENABLED);
}
_command view_specialchars_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   if ((p_ShowSpecialChars & (SHOWSPECIALCHARS_NLCHARS|SHOWSPECIALCHARS_TABS|SHOWSPECIALCHARS_SPACES|SHOWSPECIALCHARS_EOF))==
       (SHOWSPECIALCHARS_NLCHARS|SHOWSPECIALCHARS_TABS|SHOWSPECIALCHARS_SPACES|SHOWSPECIALCHARS_EOF)) {
      p_ShowSpecialChars=0;
   } else {
      p_ShowSpecialChars=SHOWSPECIALCHARS_ALL;
   }
   if (!_QReadOnly()) {
      update_format_line();
   }
}
int _OnUpdate_view_nlchars_toggle(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED|MF_UNCHECKED);
   }
   if (p_ShowSpecialChars & SHOWSPECIALCHARS_NLCHARS) {
      return(MF_CHECKED|MF_ENABLED);
   }
   return(MF_UNCHECKED|MF_ENABLED);
}
_command view_nlchars_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   p_ShowSpecialChars^=SHOWSPECIALCHARS_NLCHARS;
   if (!_QReadOnly()) {
      update_format_line();
   }
}

int _OnUpdate_view_tabs_toggle(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED|MF_UNCHECKED);
   }
   if (p_ShowSpecialChars & SHOWSPECIALCHARS_TABS) {
      return(MF_CHECKED|MF_ENABLED);
   }
   return(MF_UNCHECKED|MF_ENABLED);
}
_command view_tabs_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   p_ShowSpecialChars^=SHOWSPECIALCHARS_TABS;
   if (!_QReadOnly()) {
      update_format_line();
   }
}
int _OnUpdate_view_spaces_toggle(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED|MF_UNCHECKED);
   }
   if (p_ShowSpecialChars & SHOWSPECIALCHARS_SPACES) {
      return(MF_CHECKED|MF_ENABLED);
   }
   return(MF_UNCHECKED|MF_ENABLED);
}
_command view_spaces_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_NOEXIT_SCROLL)
{
   p_ShowSpecialChars^=SHOWSPECIALCHARS_SPACES;
   if (!_QReadOnly()) {
      update_format_line();
   }
}
_command color_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if (p_color_flags&(LANGUAGE_COLOR_FLAG)) {
      p_color_flags|=MODIFY_COLOR_FLAG;
      p_color_flags&=~(LANGUAGE_COLOR_FLAG|CLINE_COLOR_FLAG);
   } else if (p_color_flags&MODIFY_COLOR_FLAG) {
      p_color_flags|=CLINE_COLOR_FLAG;
      p_color_flags&=~(MODIFY_COLOR_FLAG|LANGUAGE_COLOR_FLAG);
   } else {
      p_color_flags|=LANGUAGE_COLOR_FLAG;
      p_color_flags&=~(MODIFY_COLOR_FLAG|CLINE_COLOR_FLAG);
   }
}
void _clex_error(params)
{
   parse params with filename "\0" clex_status section ']' name'='value
   //message 'fn='filename' clex_status='clex_status' section='section' name='name' value='value

   switch (clex_status) {
   case CLEX_NOT_ENOUGH_MEMORY_RC:
      _message_box(nls('Unable to initialize color lexer.')'  'get_message(clex_status));
      return;
   }
   find_section_only=0;
   switch (clex_status) {
   case CLEX_IDCHARS_MUST_BE_DEFINED_FIRST_RC:
      find_section_only=1;
   }
   status=edit(filename);
   if (status) {
      if (status==NEW_FILE_RC) {
         quit();
      }
      _message_box(nls("Unable to initialize color lexer.")"  "get_message(clex_status)nls("\n\nUnable to open file '%s'.",filename)"  "get_message(status));
      return;
   }
   // Find this section
   /* Search for the Environment section */
   top();
   status=search('^[ \t]*\[[ \t]*'section'[ \t]*\]','ri@');
   if (status) {
      _message_box(nls("Unable to initialize color lexer.\nUnable to find section '%s'.\n",section)get_message(clex_status));
      return;
   }
   if (find_section_only) {
      _message_box(nls("Error in lexer definition\n\n")get_message(clex_status));
      return;
   }

   // Find this name and value
   down();
   save_pos(p);
   if (value=='') {
      name_re=_escape_re_chars(name)'(=|$)';
   } else {
      name_re=_escape_re_chars(name)'=( *)'_escape_re_chars(value);
   }
   section_re='\[';
   status=search('^[ \t]*('name_re'|'section_re')','ri@');
   value='';
   if (!status) {
      get_line(line);
      if (substr(strip(line),1,1)=='[') {
         status=1;
      }
   }
   if (status) {
      // name and value not found
      restore_pos(p);
      _message_box(nls("Unable to initialize color lexer.\nUnable to find line of error '%s'.\n",section)get_message(clex_status));
      return;
   }
   _message_box(nls("Error in lexer definition found\n\n")get_message(clex_status));
}
_command keyin_space() name_info(','VSARG2_TEXT_BOX|VSARG2_REQUIRES_EDITORCTL)
{
   keyin(' ');
}
//
// This function is global.  However, this function may be
// modified in the future making it incompatible with the
// the current implementation.
//

#define DEFAULT_LEXER_LIST 'asm=asm awk=Awk pas=Pascal e=Slick-C c=cpp cmd=Rexx cob=COBOL cbl=COBOL mod=Modula-2 for=Fortran ada=ADA prg=xbase pl=Perl tcl=tcl tlib=tcl'

void _ext_init_values(_str ext,_str &lexer_name,typeless &color_flags)
{
   if (color_flags!='') return;
   value=lexer_name;
   if (value=='') {
      if (file_eq(ext,'bas')) {
         value='Visual Basic';
      } else {
         value=eq_name2value(ext,DEFAULT_LEXER_LIST);
         //messageNwait('value='value' ext='ext)
      }
   }
   if (value=='') {
      color_flags=CLINE_COLOR_FLAG;
      return;
   }
   color_flags=LANGUAGE_COLOR_FLAG;
   lexer_name=value;
}
int _OnUpdate_read_only_mode_toggle(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED|MF_UNCHECKED);
   }
   if (p_readonly_mode) {
      return(MF_CHECKED|MF_ENABLED);
   }
   return(MF_UNCHECKED|MF_ENABLED);
}
_command void read_only_mode_toggle() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   if (_isdiffed(p_buf_id)) {
      _message_box(nls("Cannot change out of read only mode because file is being diffed."));
      return;
   }
   p_readonly_mode=!p_readonly_mode;
   p_readonly_set_by_user=true;
}
_command void read_only_mode() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   if (arg(1)=='') {
      p_readonly_mode=true;
   } else {
      if ( arg(1)=='0' ) {
         if (_isdiffed(p_buf_id)) {
            _message_box(nls("Cannot change out of read only mode because file is being diffed."));
            return;
         }
         p_readonly_mode=false;
      } else {   // '1'
         p_readonly_mode=true;
      }
      p_readonly_set_by_user=true;
   }
}

void msg_ro()
{
   popup_message('The key you pressed is not allowed in Read Only mode.');
   //popup_message(nls('The key you pressed is not allowed in %s mode.',p_mode_name))
}
int _isdiffed(int buf_id)
{
   last=_last_window_id();
   for (i=1;i<=last;++i) {
      if (!_iswindow_valid(i) ) continue;
      if ((i.p_name=='_ctlfile1' || i.p_name=='_ctlfile2') &&
          (i.p_parent) && (i.p_parent.p_name=='_diff_form')) {
         if (buf_id==i.p_buf_id) {
            if (!i.p_edit && i.p_visible) {//Form not edited, and is visible 10:31am 4/8/1996
               //I hope this does away with the intermittent "You cannot close because
               //file is diffed" messages that we have gotten
               return(1);
            }
         }
      }
   }
   return(0);
}
static _str _get_vclangext_filename()
{
   if (substr(machine(),1,2)!='NT') {
      return('');
   }
   //return('c:\public\langext.dat');
   value = _ntGetRegistryValue(HKEY_CURRENT_USER,"SOFTWARE\\Microsoft\\Devstudio","Directories","Install Dirs",1);
   if (value=="") {
      return("");
   }
   if (last_char(value)!=FILESEP) {
      value=value:+FILESEP;
   }
   return(value:+'langext.dat');
}
static boolean _is_c_stl_file(_str buf_name)
{
   buf_name=strip_filename(buf_name,'p');
   if (buf_name=='' || pos(' ',buf_name)) {
      return(false);
   }
   langext_filename=_get_vclangext_filename();
   if (langext_filename=='') {
      return(false);
   }
   get_view_id(orig_view_id);
   if (!_c_stl_view_id) {
      status=_ini_get_section(langext_filename,"C/C++",temp_view_id);
      if (status) {
         return(false);
      }
      _c_stl_view_id=temp_view_id;
   }

   activate_view(_c_stl_view_id);
   top();
   save_search(a,b,c,d);
   status=search(buf_name,'@w'_fpos_case);
   restore_search(a,b,c,d);
   if (!status) {
      activate_view(orig_view_id);
      return(true);
   }
   activate_view(orig_view_id);
   return(false);
}
#if !__UNIX__
static boolean _is_rul_h_file(_str buf_name)
{
   _str just_name=strip_filename(strip_filename(buf_name,'p'),'e');
   if (!pos(' 'just_name' ',' dao directx odbc sddialog sdint sdlang sdrc winsub ',1,_fpos_case)) {
      return(false);
   }
   _str path=_InstallShieldIncludePath();
   if (path!="" && length(buf_name)>length(path) && 
       file_eq(path,substr(buf_name,1,length(path))) ){
      return(true);
   }
   return(false);
}
#endif
/*
    refer_ext is not a method which operators on an editor control
    so you can't access p_buf_name here.

    We have modified our code to pass the buffer name
    where we need too.  However, there are definitely
    cases where arg(2) is not given and it is NOT
    SUPPOSED to be given.
*/
_str refer_ext(_str ext,...)
{
   buf_name=arg(2);  // This is usually passed in but not always
   //say('buf_name='buf_name);
   if ( ext=='' ) {
      name=strip_filename(buf_name,'P');
      // We are NOT doing a file_eq because UNIX
      // users type makefile and Makefile
      if (lowcase(name) :== "makefile") {
         return('mak');
      }
      if (_is_c_stl_file(buf_name)) {
         return('c');
      }
      //path=
      return('Fundamental');
   } 
#if !__UNIX__
   // Check for installShield rul include files
   if (ext=='h' && substr(machine(),1,2)=='NT' && _is_rul_h_file(buf_name)) {
      return('rul');
   }
#endif
   name='def-setup-'ext;
   index=find_index(name,MISC_TYPE);
   if ( ! index || substr(name_info(index),1,1)!='@' ) {
      return(ext);
   }
   return(substr(name_info(index),2));

}
