#include 'slick.sh'

/* sys_message,reserved,callback_index,font,header,footer,options */
defeventtab _tprint_form
void ctlhex.lbutton_up()
{
   enabled=!(ctlhex.p_value && ctlhex.p_enabled);
   if (enabled) {
      wid=_form_parent();
      if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
         ctlvisibleonly.p_enabled=wid.p_Nofhidden!=0;
      } else {
         ctlvisibleonly.p_enabled=0;
      }
   } else {
      ctlvisibleonly.p_enabled=enabled;
   }
   ctllinenums_every.p_enabled=enabled;
   ctllinenums_everylab.p_enabled=enabled;
}
void ctlvisibleonly.lbutton_up()
{
   enabled=!(ctlvisibleonly.p_value && ctlvisibleonly.p_enabled);
   if (enabled) {
      wid=_form_parent();
      if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
         ctlhex.p_enabled=1;
      } else {
         ctlhex.p_enabled=0;
      }
   } else {
      ctlhex.p_enabled=enabled;
   }
   ctllinenums_every.p_enabled=enabled;
   ctllinenums_everylab.p_enabled=enabled;
}
defeventtab _tprint_form._mffiles _inherit _replace_form._mffiles
_mffiles.on_destroy()
{
   // Need this for UNIX only.  List box of combobox does not get
   // reinitialized.
   p_cb_list_box.p_user="";
}
_mffiles.on_drop_down(reason)
{
   if (p_cb_list_box.p_user=='') {
      p_cb_list_box._retrieve_list();
      p_cb_list_box.p_user=1; // Indicate that retrieve list has been done
   }
}
_finddir.lbutton_up()
{
   result=show('-modal '_stdform('_cd_form'),'Choose Directory',1,1,1);
   if( result=='' ) {
      return('');
   }
   result=strip_options(result,dummy);
   line=_mffiles.p_text;
   if( line!='' ) {
      if( last_char(line)==FILESEP ) {
         #if __UNIX__
         line=strip(line,'T'):+'* ':+result;
         #else
         line=strip(line,'T'):+'*.* ':+result;
         #endif
      } else {
         line=strip(line,'T'):+' ':+result;
      }
   } else {
      line=result;
   }
   _mffiles.p_text=line;
   _mffiles._end_line();
   _mffiles._set_focus();
}

_mfhook.lbutton_up(reason,info)
{
   if (reason==CHANGE_SELECTED) {
      _mfnofselected.p_caption=_mfbuflist.p_Nofselected' of '_mfbuflist.p_Noflines' selected';
      if (info) {
         // Some files or bufers have been selected
         if (_selection_only.p_enabled) _selection_only.p_enabled=0;
         if (ctlvisibleonly.p_enabled) {
            ctlvisibleonly.p_enabled=0;
            ctlvisibleonly.call_event(ctlvisibleonly,LBUTTON_UP);
         }
         if (ctlhex.p_enabled) {
            ctlhex.p_enabled=0;
            ctlhex.call_event(ctlhex,LBUTTON_UP);
         }
      } else {
         // No files or buffers are selected
         if (!_selection_only.p_enabled) {
            wid=_form_parent();
            if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)
                && wid.select_active()) {
               _selection_only.p_enabled=1;
            }
         }
         if (!ctlvisibleonly.p_enabled) {
            wid=_form_parent();
            if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
               ctlvisibleonly.p_enabled= wid.p_Nofhidden!=0;
               ctlvisibleonly.call_event(ctlvisibleonly,LBUTTON_UP);
            }
         }
         if (!ctlhex.p_enabled) {
            wid=_form_parent();
            if (wid.p_view_id<0 && !(wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
               ctlhex.p_enabled= wid.p_hex_mode!=0;
               ctlhex.call_event(ctlhex,LBUTTON_UP);
            }
         }
      }
   }
}

_ok.on_create()
{
   wid=_form_parent()
   nowins=wid.p_view_id>=0 || (wid.p_window_flags & HIDE_WINDOW_OVERLAP);
   Nofhidden=0;
   hex_mode=0;
   if (!nowins) {
      Nofhidden= wid.p_Nofhidden;
      hex_mode=wid.p_hex_mode;
   }
   if (nowins || !wid.select_active()) {
      _selection_only.p_enabled=0;
   } else {
      _selection_only.p_value=1;
   }
   parse def_tprint_options with print_flags','blafterheader','blbeforefooter','linesperpage','columnsperline','linenums_every','
   if (!isinteger(print_flags)) print_flags=TPRINT_FORM_FEED_AFTER_LAST_PAGE;
   if (print_flags&TPRINT_FORM_FEED_AFTER_LAST_PAGE) {
      ctlffafter.p_value=1;
   }
   ctllheader.p_text=def_tprint_lheader
   ctlcheader.p_text=def_tprint_cheader
   ctlrheader.p_text=def_tprint_rheader
   ctllfooter.p_text=def_tprint_lfooter
   ctlcfooter.p_text=def_tprint_cfooter
   ctlrfooter.p_text=def_tprint_rfooter
   ctllinenums_every.p_text=linenums_every

   ctlblafterheader.p_text=blafterheader;
   ctlblbeforefooter.p_text=blbeforefooter;
   ctllinesperpage.p_text=linesperpage;
   ctlcolumnsperline.p_text=columnsperline;
   ctlprintcommand.p_text=def_tprint_command;
   ctlprintdevice.p_text=def_tprint_device;
   ctlprintfilter.p_text=def_tprint_filter;

   _retrieve_prev_form()
   if (!_selection_only.p_enabled) {
      _selection_only.p_value=0;
   }
   if (!Nofhidden) {
      ctlvisibleonly.p_enabled=0;
      ctlvisibleonly.p_value=0;
   } else {
      ctlvisibleonly.p_value=1;
   }
   if (!hex_mode) {
      //ctlhex.p_enabled=0;
      ctlhex.p_value=0;
   } else {
      ctlhex.p_value=1;
      ctlhex.call_event(ctlhex,LBUTTON_UP);
   }
}
_ok.lbutton_up()
{
   orig_view_id=p_view_id;
   print_flags=0;
   wid=_form_parent();
   include_pfiles=(_mfproject_files.p_value)&&(pos('<<',_mfmore.p_caption));

   files='';atbuflist='';
   list_view_id='';
   _param11='';
   fid=p_active_form;
   if (pos('<<',_mfmore.p_caption)) {
      status=_mfget_result(files, atbuflist, include_pfiles);
      //Third parameter is to include project files
      if (status) {
         return(status);
      }
      if (wid.p_view_id>=0 || (wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
         if (files=='' && atbuflist=='') {
            //If there really are no files selected, mffind can
            //return 0 and we wind up here.  I didn't want to mess with
            //mffind to much, so we just wind up here.
            _message_box(nls("No files selected"));
            p_window_id=_control _mffiles;_set_focus
            _set_sel(1,length(p_text)+1)
            return('');
         }
      }
      _param11=get_pfile_list(files, atbuflist);
      if (_param11==''&&include_pfiles) {
         _message_box(nls("There are no files in the current project."));
         p_view_id=orig_view_id;
         return('');
      }
   }else if (wid.p_view_id>=0 || (wid.p_window_flags & HIDE_WINDOW_OVERLAP)) {
      _message_box(nls("No files selected"));
      _mfmore.call_event(_mfmore,LBUTTON_UP);
      return('');
   }
   p_window_id=fid;

   if(_check_int(_control ctllinenums_every,0,99999)) return(1);
   if(_check_int(_control ctlblafterheader,0,99999)) return(1);
   if(_check_int(_control ctlblbeforefooter,0,99999)) return(1);
   if(_check_int(_control ctllinesperpage,0,99999)) return(1);
   if(_check_int(_control ctlcolumnsperline,0,99999)) return(1);
   if (ctlvisibleonly.p_value && ctlvisibleonly.p_enabled) print_flags|=PRINT_VISIBLEONLY;
   if (ctlhex.p_value && ctlhex.p_enabled) {
      print_flags|=PRINT_HEX;
   }

   parse def_tprint_options with ','.','.','.','.','.','rest
   if (ctlffafter.p_value) {
      print_flags|=TPRINT_FORM_FEED_AFTER_LAST_PAGE;
   }
   _param1=print_flags','ctlblafterheader.p_text','ctlblbeforefooter.p_text',':+
           ctllinesperpage.p_text','ctlcolumnsperline.p_text','ctllinenums_every.p_text','rest
   _param2= ctlcheader.p_text;
   _param3= ctlcfooter.p_text;
   _param4= ctllheader.p_text;
   _param5= ctllfooter.p_text;
   _param6= ctlrheader.p_text;
   _param7= ctlrfooter.p_text;
   _param8= ctlprintcommand.p_text;
   _param9= ctlprintdevice.p_text;
   _param10= ctlprintfilter.p_text;
   if (arg(1)!='') {
      def_tprint_options=_param1;
      def_tprint_cheader=_param2;
      def_tprint_cfooter=_param3;
      def_tprint_lheader=_param4;
      def_tprint_lfooter=_param5;
      def_tprint_rheader=_param6;
      def_tprint_rfooter=_param7;
      def_tprint_command=_param8;
      def_tprint_device=_param9;
      def_tprint_filter=_param10;
      return(0)
   }
   _ok.p_user='';
   _save_form_response()
   p_active_form._delete_window((_selection_only.p_value && _selection_only.p_enabled)?2:1)
}
_ok.on_destroy()
{
   // IF save settings button pressed and user did not press OK button
   if (_ok.p_user!='') {
      _save_form_response()
   }
}
void ctlprintcommand.on_change()
{
   if (p_text=='') {
      ctlprintdevice.p_enabled=1;
   } else {
      if (ctlprintdevice.p_enabled) {
         ctlprintdevice.p_enabled=0;
      }
   }
}
void ctlprintfilter.on_change()
{
   enable='';
   if (p_text=='') {
      if (!ctlcheader.p_enabled) {
         enable=1;
      }
   } else {
      if (ctlcheader.p_enabled) {
         enable=0;
      }
   }
   if (enable!='') {
      ctlcheader.p_enabled=enable;
      ctlcheaderlab.p_enabled=enable;
      ctlcfooter.p_enabled=enable;
      ctlcfooterlab.p_enabled=enable;
      ctllheader.p_enabled=enable;
      ctllheaderlab.p_enabled=enable;
      ctllfooter.p_enabled=enable;
      ctllfooterlab.p_enabled=enable;
      ctlrheader.p_enabled=enable;
      ctlrheaderlab.p_enabled=enable;
      ctlrfooter.p_enabled=enable;
      ctlrfooterlab.p_enabled=enable;

      ctlhex.p_enabled=enable;
      ctlvisibleonly.p_enabled=enable;
      ctllinenums_every.p_enabled=enable;
      ctllinenums_everylab.p_enabled=enable;
      ctlblafterheader.p_enabled=enable;
      ctlblafterheaderlab.p_enabled=enable;
      ctlblbeforefooter.p_enabled=enable;
      ctlblbeforefooterlab.p_enabled=enable;
      ctllinesperpage.p_enabled=enable;
      ctllinesperpagelab.p_enabled=enable;
      ctlcolumnsperline.p_enabled=enable;
      ctlcolumnsperlinelab.p_enabled=enable;

      ctlffafter.p_enabled=enable;
   }
}

#if 0
ctlsave_settings.lbutton_up()
{
   // Indicate that the save settings button was pressed.
   _ok.p_user=1;
   status=call_event(IDNO,defeventtab _tprint_form._ok,LBUTTON_UP,'e')
   if (!status) {
      save_config();
      _macro('m',_macro('s'))
      _macro_append('_config_modify|=CFGMODIFY_DEFVAR')
      _macro_append('def_tprint_options="'def_tprint_options'"')
      _macro_append('def_tprint_cheader="'def_tprint_cheader'"')
      _macro_append('def_tprint_cfooter="'def_tprint_cfooter'"')
      _macro_append('def_tprint_lheader="'def_tprint_lheader'"')
      _macro_append('def_tprint_lfooter="'def_tprint_lfooter'"')
      _macro_append('def_tprint_rheader="'def_tprint_rheader'"')
      _macro_append('def_tprint_rfooter="'def_tprint_rfooter'"')
      _macro_append('def_tprint_command="'def_tprint_command'"')
      _macro_append('def_tprint_device="'def_tprint_device'"')
      _macro_append('def_tprint_filter="'def_tprint_filter'"')
   }
}
#endif
static _check_int(wid,low,high)
{
   if (!isinteger(wid.p_text) || wid.p_text<low || wid.p_text>high ){
      _message_box('Invalid setting');
      p_window_id=wid;
      wid._set_sel(1,length(wid.p_text)+1);_set_focus();
      return(1)
   }
   return(0)
}
_command print_selection() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_MARK)
{
   _tprint_selection();
}
_command print() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   tprint();
}
_command gui_print() name_info(','VSARG2_EDITORCTL)
{
   _macro_delete_line()
   result=show('-modal _tprint_form')
   if (result=='') {
      return(COMMAND_CANCELLED_RC)
   }
   if (result==1) {
      if (_param11!='') {
         orig_view_id=p_view_id;
         filelist_view_id=_param11;
         p_view_id=filelist_view_id;
         if (!p_Noflines) {
            _message_box(nls("No matching files."));
            p_view_id=orig_view_id;
            _delete_temp_view(filelist_view_id);
            return('');
         }
         p_line=0;
         while (!down()) {
            get_line(filename);
            filename=strip(filename);
            p_view_id=HIDDEN_VIEW_ID;
            status=load_files('+c +q +b 'filename)
            if (!status) {
               fileinmem=1;
            }else{
               load_files('+c +q 'filename);
               fileinmem=0;
            }
            //I decided to use load_files instead of edit to get around cases
            //where there were no child windows and edit brought them up.
            //This just feels cleaner to me.
            status=tprint(
                   _param1,  //printflags,afterhdrTxt,b4footerTxt,lpr,colpl,LNumsE,rest
                   _param2,  //cheader
                   _param3,  //cfooter
                   _param4,  //lheader
                   _param5,  //lfooter
                   _param6,  //rheader
                   _param7,  //rfooter
                   _param8,  //printcommand
                   _param9,  //printdevice
                   _param10  //printfilter
                   );
            if (!fileinmem) _delete_buffer();//Delete buffer if not already up
            _quit_view();
            p_view_id=orig_view_id;
            p_view_id=filelist_view_id;
            _macro('m',_macro('s'))
            _macro_call('tprint',_param1,_param2,_param3,_param4,_param5,_param6,_param7,_param8,_param9,_param10)
         }
         p_view_id=orig_view_id;
         _delete_temp_view(filelist_view_id);
      } else {
         status=tprint(
                _param1,  //printflags,afterhdrTxt,b4footerTxt,lpr,colpl,LNumsE,rest
                _param2,  //cheader
                _param3,  //cfooter
                _param4,  //lheader
                _param5,  //lfooter
                _param6,  //rheader
                _param7,  //rfooter
                _param8,  //printcommand
                _param9,  //printdevice
                _param10  //printfilter
                );
         _macro('m',_macro('s'))
         _macro_call('tprint',_param1,_param2,_param3,_param4,_param5,_param6,_param7,_param8,_param9,_param10)
      }
   } else {
      status=_tprint_selection(
             _param1,
             _param2,
             _param3,
             _param4,
             _param5,
             _param6,
             _param7,
             _param8,
             _param9,
             _param10
             )
      _macro('m',_macro('s'))
      _macro_call('_tprint_selection',_param1,_param2,_param3,_param4,_param5,_param6,_param7,_param8,_param9,_param10)
   }
   return(status)
}
static _str _insert_print_options(_str string,_str buf_name)
{
   result="";
   for(i=1;;) {
      j=pos("%",string,i);
      if (!j) {
         result=result:+substr(string,i);
         return(result);
      }
      result=result:+substr(string,i,j-i);
      switch (upcase(substr(string,j+1,2))) {
      case "FD":
         result=result:+file_date(buf_name);
         i=j+3;
         break;
      case "FT":
         result=result:+file_time(buf_name);
         i=j+3;
         break;
      default:
         result=result:+substr(string,j,2);
         i=j+2;
      }
   }
}
_command tprint() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   if (arg(1)>1) {
      status=_tprint(p_buf_name,
             arg(1),
             _insert_print_options(arg(2),p_buf_name),
             _insert_print_options(arg(3),p_buf_name),
             _insert_print_options(arg(4),p_buf_name),
             _insert_print_options(arg(5),p_buf_name),
             _insert_print_options(arg(6),p_buf_name),
             _insert_print_options(arg(7),p_buf_name),
             arg(8),
             arg(9),
             arg(10)
             );
   } else {
      status=_tprint(p_buf_name,
             def_tprint_options,
             _insert_print_options(def_tprint_cheader,p_buf_name),
             _insert_print_options(def_tprint_cfooter,p_buf_name),
             _insert_print_options(def_tprint_lheader,p_buf_name),
             _insert_print_options(def_tprint_lfooter,p_buf_name),
             _insert_print_options(def_tprint_rheader,p_buf_name),
             _insert_print_options(def_tprint_rfooter,p_buf_name),
             def_tprint_command,
             def_tprint_device,
             def_tprint_filter
             );
   }
   if (status<0) {
      _message_box(nls('Printing Failed')'.  'get_message(status))
   }
   return(status);
}

typeless _tprint_selection()
{
   print_options=def_tprint_options
   print_cheader=def_tprint_cheader
   print_cfooter=def_tprint_cfooter
   print_lheader=def_tprint_lheader
   print_lfooter=def_tprint_lfooter
   print_rheader=def_tprint_rheader
   print_rfooter=def_tprint_rfooter
   print_command=def_tprint_command
   print_device=def_tprint_device
   print_filter=def_tprint_filter
   if(arg()>=1) print_options=arg(1)
   if(arg()>=2) print_cheader=arg(2)
   if(arg()>=3) print_cfooter=arg(3)
   if(arg()>=4) print_lheader=arg(4)
   if(arg()>=5) print_lfooter=arg(5)
   if(arg()>=6) print_rheader=arg(6)
   if(arg()>=7) print_rfooter=arg(7)
   if(arg()>=8) print_command=arg(8)
   if(arg()>=9) print_device=arg(9)
   if(arg()>=10) print_filter=arg(10)
   parse print_options with print_flags','blafterheader','blbeforefooter','linesperpage','columnsperline','linenums_every',';
   if ( _select_type()=='' ) {
      _message_box(get_message(TEXT_NOT_SELECTED_RC))
      return(TEXT_NOT_SELECTED_RC)
   }
   mark= _duplicate_selection()    /* Save the users mark. */
   if ( rc  ) { return(rc) }
   _get_selinfo junk,junk,buf_id
   old_buf_id=p_buf_id
   p_buf_id=buf_id
   if ( rc ) {
      _free_selection mark
      return(rc)
   }
   save_pos(p);_begin_select();
   if (print_flags & PRINT_HEX) {
      if (_select_type()=='LINE') {
         _begin_line();
      }
      linenum=_QROffset();
      //messageNwait('RealLineNumber='RealLineNumber);
   } else {
      linenum=p_RLine;
   }
   restore_pos(p);
   tabs=p_tabs;buf_width=p_buf_width;buf_name=p_buf_name
   load_files '+bi 'old_buf_id
   if ( buf_width ) {
      status=load_files('+'buf_width' +c -u +t 'maybe_quote_filename(buf_name))
   } else {
      status=load_files('+c -u +t 'maybe_quote_filename(buf_name))
   }
   if ( status ) {
      if ( status:==NEW_FILE_RC ) {
         _delete_buffer();_quit_view();
      }
      _free_selection mark
      return(status)
   }
   p_tabs=tabs
   status=_copy_to_cursor(mark)
   _free_selection mark
   if ( status ) {
      _delete_buffer();_quit_view()
      message get_message(status)
      return(status)
   }
   if (_select_type()=='LINE') {
      top;_delete_line
   }
   parse print_options with print_flags','blafterheader','blbeforefooter','linesperpage','columnsperline','linenums_every',';
   print_options=print_flags','blafterheader','blbeforefooter','linesperpage','columnsperline','linenums_every','linenum',';
   p_show_tabs=0
   status=_tprint(buf_name,    //callback_index
          print_options,
          _insert_print_options(print_cheader,p_buf_name),
          _insert_print_options(print_cfooter,p_buf_name),
          _insert_print_options(print_lheader,p_buf_name),
          _insert_print_options(print_lfooter,p_buf_name),
          _insert_print_options(print_rheader,p_buf_name),
          _insert_print_options(print_rfooter,p_buf_name),
          print_command,
          print_device,
          print_filter
          )
   p_modify=0;_delete_buffer();_quit_view()
   if ( status<0 ) {
      _message_box(nls('Printing Failed')'.  'get_message(status))
   } else {
      if (def_keys=='brief-keys') deselect();
   }
   return(status)

}
const TEMP_FILENAME="print.slk";
int def_print_async=0;
static print_mktemp()
{
   if (!def_print_async) {
      return(mktemp());
   }
   return('/tmp/'TEMP_FILENAME);
}
typeless _tprint(buf_name,print_options,
          print_cheader,print_cfooter,
          print_lheader,print_lfooter,
          print_rheader,print_rfooter,
          print_command,print_device,print_filter
          )
{
   parse print_options with options','
   tprint_command=print_command;
#if __UNIX__
   // LINUX does not have an lp program.
   if (tprint_command!='') {
      parse tprint_command with pgmname .
      if (slick_path_search(pgmname)=='') {
         tprint_command='lpr %f';
         // LINUX lpr already prints a form feed
         options&= ~TPRINT_FORM_FEED_AFTER_LAST_PAGE;
      }
   }
#endif
   if (print_filter=='') {
      // Might as well always terminate lines with CR/LF
      // LINUX lpr does not print UNIX files properly.
      // Want binary temp file so can add form feed without CR/LF
      orig_view_id=_create_temp_view(temp_view_id,'+70 +td');
      if (orig_view_id=='') return(INSUFFICIENT_MEMORY_RC);
      activate_view(orig_view_id);
      _tprint_format(temp_view_id,buf_name,print_options,
             print_cheader,print_cfooter,
             print_lheader,print_lfooter,
             print_rheader,print_rfooter
             );
      activate_view(temp_view_id);
      output_filename=print_mktemp();
      status=0;
      if ( def_leading_codes:!='' ) {
         top;get_line tline
         replace_line def_leading_codes:+expand_tabs(tline)
      }
      if (options& TPRINT_FORM_FEED_AFTER_LAST_PAGE) {
         bottom;get_line bline
         replace_line bline:+"\f"
      }
      if ( def_trailing_codes:!='' ) {
         bottom;get_line bline
         replace_line bline:+def_trailing_codes
      }
      if (tprint_command!='') {
         status=save('-z 'output_filename,SV_OVERWRITE)
      }
      if (status) {
         delete_file(output_filename);
         _delete_temp_view(temp_view_id);
         activate_view(orig_view_id);
         return(status);
      }

   } else {
      filename_is_temp=0;
      if (p_modify || buf_name!=p_buf_name || file_match('-p 'buf_name,1)=='') {
         filename=mktemp()
         status=save(filename,SV_OVERWRITE)
         if (status) {
            delete_file(filename);
            return(status);
         }
         filename_is_temp=1;
      } else {
         filename=p_buf_name;
      }
      output_filename=mktemp();
      command=print_filter' <'filename' >'output_filename;
      message nls('Running print filter: %s',command)
      status=shell(command);
      if (filename_is_temp) {
         delete_file(filename);
      }
      if ( status ) {
         delete_file(output_filename);
         if (status==FILE_NOT_FOUND_RC || status==PATH_NOT_FOUND_RC) {
            parse command with pgmname .
            _message_box(nls('Program %s not found',pgmname));
            return(status);
         }
         _message_box(nls('Print filter command %s returned error',command))
         return(status);
      }
      status=_open_temp_view(output_filename,temp_view_id,orig_view_id,"+l");
      if (tprint_command=='') delete_file(output_filename);
      if (status) {
         delete_file(output_filename);
         return(status);
      }
   }
   activate_view(temp_view_id);

   if ( tprint_command=='' ) {
      message 'Printing 'buf_name
      status=_save_file('-z +o -a +e 'print_device)
      //delete_file(output_filename);
      clear_message
      if (status) {
         _message_box(nls('Failed to write to print device %s',print_device))
         _delete_temp_view(temp_view_id);
         activate_view(orig_view_id);
         return(status);
      }
      delete_file(output_filename);
   } else {
      command=_parse_project_command(tprint_command,
                                     output_filename,'','')
      //messageNwait('command='command);
      message nls('Running print command: %s',command)
      status=shell(command,def_print_async?'a':'');
      //messageNwait('wait');
      if (!def_print_async) {
         delete_file(output_filename);
      }
      clear_message
      if ( status ) {
         _delete_temp_view(temp_view_id);
         activate_view(orig_view_id);
         delete_file(output_filename);
         if (status==FILE_NOT_FOUND_RC || status==PATH_NOT_FOUND_RC) {
            parse command with pgmname .
            _message_box(nls('Program %s not found',pgmname));
            return(status);
         }
         _message_box(nls('Print command %s returned error',command))
         return(status);
      }
   }
   _delete_temp_view(temp_view_id);
   activate_view(orig_view_id);
   return(0)
}
static _str get_pfile_list(files, atbuflist)
/* returns view id of buffer/file list */
{
   orig_view_id=_create_temp_view(temp_view_id);
   p_view_id=temp_view_id;
   for (;;) {
      word=parse_file(files);
      if (word=="") break;
      insert_file_list(word' +p -v');
   }
   for (;;) {
      cur_buf=parse_file(atbuflist);
      if (cur_buf=='') {
         break;
      }
      if (substr(cur_buf,1,1)=='@') {
         _open_temp_view(substr(cur_buf,2),temp_buflist_view_id, temp_view_id);
         p_view_id=temp_buflist_view_id;
         mark_id=_alloc_selection();
         top();_select_line(mark_id);
         bottom();_select_line(mark_id);
         p_view_id=temp_view_id;
         _copy_to_cursor(mark_id);
         _delete_temp_view(temp_buflist_view_id);
      }else{
         insert_line(strip(cur_buf,'B','"'));
         //insert_file_list(cur_buf' +p -v');
      }
   }
   if (p_Noflines) {
      sort_buffer('-f');
      _remove_duplicates();
   }else{
      p_view_id=orig_view_id;
      _delete_temp_view(temp_view_id);
      return('');
   }
   p_view_id=orig_view_id;
   return(temp_view_id);
}
