/*
$VerboseHistory: wfont.e$
*/
#include 'slick.sh'

_control _okay
_control _just_window
_control _sample_text
_control _font_name_list

defeventtab _wfont_form

static void generate_change_all_macro(font_name, font_size, font_flags,charset)
{
   _macro('m',_macro('s'));
   _macro_call("_change_all_wfonts",font_name,font_size,font_flags,charset);
}

static void generate_change_current_macro(_str font_name, _str font_size, int font_flags,int charset=VSCHARSET_DEFAULT)
{
   charset=arg(4);
   fs = font_flags & F_STRIKE_THRU
   fu = font_flags & F_UNDERLINE
   fi = font_flags & F_ITALIC
   fb = font_flags & F_BOLD;
   _macro('m',_macro('s'));
   _macro_append("p_font_name       ="_quote(font_name)";");
   _macro_append("p_font_size       ="font_size";");
   _macro_append("p_font_bold       ="fb";");
   _macro_append("p_font_italic     ="fi";");
   _macro_append("p_font_underline  ="fu";");
   _macro_append("p_font_strike_thru="fs";");
   _macro_append("p_font_charset="charset";");
}

void _change_all_wfonts(_str font_name, _str font_size, int font_flags,int charset=VSCHARSET_DEFAULT)
{
   last=_last_window_id()
   for (i=1;i<=last;++i) {
      if ((_iswindow_valid(i)) && 
           (i.p_object==OI_EDITOR ||
            (i.p_mdi_child) && (i.p_view_id < 0)
           )
         ){
         i.p_redraw=0;
         i.p_font_name      = font_name;
         i.p_font_size      = font_size;
         i.p_font_bold      = (font_flags & F_BOLD)!=0;
         i.p_font_italic    = (font_flags & F_ITALIC)!=0;
         i.p_font_underline = (font_flags & F_UNDERLINE)!=0;
         i.p_font_strike_thru = (font_flags & F_STRIKE_THRU)!=0;
         i.p_font_charset=charset;
         i.p_redraw=1;
      }
   }
   new_default = font_name','font_size','font_flags',';
   _default_font(CFG_WINDOW_TEXT, new_default)
   _config_modify|= CFGMODIFY_OPTION;
}


_okay.lbutton_up()
{
   update_sample_text();
   font_info = _font_get_result();
   if (font_info == '') {
      return('');
   }

   parse font_info with font_name ',' font_size ',' font_flags ','charset ',' ;
   if (!isinteger(charset)) {
      charset=VSCHARSET_DEFAULT;
   }

   if (_just_window.p_value) {
      p_active_form._delete_window(1);
      wid=_mdi.p_child;
      wid.p_redraw=0;
      wid.p_font_name        = font_name;
      wid.p_font_size        = font_size;
      wid.p_font_bold        = font_flags & F_BOLD;
      wid.p_font_italic      = font_flags & F_ITALIC;
      wid.p_font_underline   = font_flags & F_UNDERLINE;
      wid.p_font_strike_thru = font_flags & F_STRIKE_THRU;
      wid.p_font_charset=charset;
      wid.p_redraw=1;
      generate_change_current_macro(font_name, font_size, font_flags,charset);
   }else{
      p_active_form._delete_window(1);
      _change_all_wfonts(font_name, font_size, font_flags);
      generate_change_all_macro(font_name, font_size, font_flags,charset);
   }
}

_command void wfont() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_NOEXIT_SCROLL)
{
   param2 = _font_props2flags();
   show('-modal _wfont_form',
        'f',
        _font_param(p_font_name,p_font_size,param2,p_font_charset)
       )

}
#if 0
_command reset_wfonts()
{
   last=_last_window_id();
   for (i=1;i<=last;++i) {
      if ((_iswindow_valid(i)) && (i.p_mdi_child) && (i.p_view_id < 0)){
         i.p_font_name        = 'Courier'
         i.p_font_size        = 10;
         i.p_font_bold        = 0;
         i.p_font_italic      = 0;
         i.p_font_underline   = 0;
         i.p_font_strike_thru = 0;
      }
   }
}
#endif
